/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.table.runtime.compression.BlockCompressionFactory;
import org.apache.flink.table.runtime.compression.BlockCompressor;
import org.apache.flink.table.runtime.compression.BlockDecompressor;
import org.apache.flink.util.Preconditions;

public class CompressedBlockChannelReader
implements BlockChannelReader<MemorySegment>,
RequestDoneCallback<Buffer>,
BufferRecycler {
    private final LinkedBlockingQueue<MemorySegment> blockQueue;
    private final boolean copyCompress;
    private final BlockDecompressor decompressor;
    private final BufferFileReader reader;
    private final AtomicReference<IOException> cause;
    private final LinkedBlockingQueue<Buffer> retBuffers = new LinkedBlockingQueue();
    private byte[] buf;
    private ByteBuffer bufWrapper;
    private int offset;
    private int len;

    public CompressedBlockChannelReader(IOManager ioManager, FileIOChannel.ID channel, LinkedBlockingQueue<MemorySegment> blockQueue, BlockCompressionFactory codecFactory, int preferBlockSize, int segmentSize) throws IOException {
        this.reader = ioManager.createBufferFileReader(channel, (RequestDoneCallback)this);
        this.blockQueue = blockQueue;
        this.copyCompress = preferBlockSize > segmentSize * 2;
        int blockSize = this.copyCompress ? preferBlockSize : segmentSize;
        this.decompressor = codecFactory.getDecompressor();
        this.cause = new AtomicReference();
        if (this.copyCompress) {
            this.buf = new byte[blockSize];
            this.bufWrapper = ByteBuffer.wrap(this.buf);
        }
        BlockCompressor compressor = codecFactory.getCompressor();
        for (int i = 0; i < 2; ++i) {
            MemorySegment segment = MemorySegmentFactory.wrap((byte[])new byte[compressor.getMaxCompressedSize(blockSize)]);
            this.reader.readInto((Buffer)new NetworkBuffer(segment, (BufferRecycler)this));
        }
    }

    public void readBlock(MemorySegment segment) throws IOException {
        if (this.cause.get() != null) {
            throw this.cause.get();
        }
        if (this.copyCompress) {
            int readOffset = 0;
            int readLen = segment.size();
            while (readLen > 0) {
                int copy2 = Math.min(readLen, this.len - this.offset);
                if (copy2 == 0) {
                    this.readBuffer();
                    continue;
                }
                segment.put(readOffset, this.buf, this.offset, copy2);
                this.offset += copy2;
                readOffset += copy2;
                readLen -= copy2;
            }
        } else {
            int len = this.decompressBuffer(segment.wrap(0, segment.size()));
            Preconditions.checkState((len == segment.size() ? 1 : 0) != 0);
        }
        boolean add2 = this.blockQueue.add(segment);
        Preconditions.checkState((boolean)add2);
    }

    private void readBuffer() throws IOException {
        this.len = this.decompressBuffer(this.bufWrapper);
    }

    private int decompressBuffer(ByteBuffer toRead) throws IOException {
        try {
            Buffer buffer;
            while ((buffer = this.retBuffers.poll(1000L, TimeUnit.MILLISECONDS)) == null) {
                if (this.cause.get() == null) continue;
                throw this.cause.get();
            }
            int readLen = this.decompressor.decompress(buffer.getMemorySegment().wrap(0, buffer.getSize()), 0, buffer.getSize(), toRead, 0);
            buffer.recycleBuffer();
            return readLen;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void seekToPosition(long position) throws IOException {
        throw new RuntimeException("Not support yet!");
    }

    public MemorySegment getNextReturnedBlock() throws IOException {
        try {
            do {
                MemorySegment next;
                if ((next = this.blockQueue.poll(1000L, TimeUnit.MILLISECONDS)) == null) continue;
                return next;
            } while (!this.reader.isClosed());
            throw new IOException("The writer has been closed.");
        }
        catch (InterruptedException e) {
            throw new IOException("Writer was interrupted while waiting for the next returning segment.");
        }
    }

    public LinkedBlockingQueue<MemorySegment> getReturnQueue() {
        return this.blockQueue;
    }

    public FileIOChannel.ID getChannelID() {
        return this.reader.getChannelID();
    }

    public long getSize() throws IOException {
        return this.reader.getSize();
    }

    public boolean isClosed() {
        return this.reader.isClosed();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public void deleteChannel() {
        this.reader.deleteChannel();
    }

    public void closeAndDelete() throws IOException {
        this.reader.closeAndDelete();
    }

    public FileChannel getNioFileChannel() {
        return this.reader.getNioFileChannel();
    }

    public void requestSuccessful(Buffer request) {
        this.retBuffers.add(request);
    }

    public void requestFailed(Buffer buffer, IOException e) {
        this.cause.compareAndSet(null, e);
        throw new RuntimeException(e);
    }

    public void recycle(MemorySegment segment) {
        try {
            this.reader.readInto((Buffer)new NetworkBuffer(segment, (BufferRecycler)this));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

