/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext$;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class JoinUtil$ {
    public static final JoinUtil$ MODULE$;

    static {
        new JoinUtil$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<int[], int[]> checkAndGetJoinKeys(List<IntPair> keyPairs, RelNode left, RelNode right, boolean allowEmptyKey) {
        Tuple2 tuple2;
        ArrayBuffer leftKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer rightKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        if (keyPairs.isEmpty()) {
            if (!allowEmptyKey) throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Joins should have at least one equality condition.\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tleft: ", "\\n\\tright: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.toString(), right.toString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"please re-check the join statement and make sure there's "})).s((Seq)Nil$.MODULE$)).append((Object)"equality condition for join.").toString());
            tuple2 = new Tuple2(leftKeys.toArray(ClassTag$.MODULE$.Int()), rightKeys.toArray(ClassTag$.MODULE$.Int()));
            return tuple2;
        } else {
            java.util.List<RelDataTypeField> leftFields = left.getRowType().getFieldList();
            java.util.List<RelDataTypeField> rightFields = right.getRowType().getFieldList();
            keyPairs.foreach((Function1)new Serializable(left, right, leftKeys, rightKeys, leftFields, rightFields){
                public static final long serialVersionUID = 0L;
                private final RelNode left$1;
                private final RelNode right$1;
                private final ArrayBuffer leftKeys$1;
                private final ArrayBuffer rightKeys$1;
                private final java.util.List leftFields$1;
                private final java.util.List rightFields$1;

                public final ArrayBuffer<Object> apply(IntPair pair) {
                    SqlTypeName leftKeyType = ((RelDataTypeField)this.leftFields$1.get(pair.source)).getType().getSqlTypeName();
                    SqlTypeName rightKeyType = ((RelDataTypeField)this.rightFields$1.get(pair.target)).getType().getSqlTypeName();
                    SqlTypeName sqlTypeName = leftKeyType;
                    SqlTypeName sqlTypeName2 = rightKeyType;
                    if (!(sqlTypeName != null ? !((Object)((Object)sqlTypeName)).equals((Object)((Object)sqlTypeName2)) : sqlTypeName2 != null)) {
                        this.leftKeys$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)pair.source));
                        return this.rightKeys$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)pair.target));
                    }
                    throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Join: Equality join predicate on incompatible types. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tLeft: ", "\\n\\tright: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left$1.toString(), this.right$1.toString()}))).append((Object)"please re-check the join statement.").toString());
                }
                {
                    this.left$1 = left$1;
                    this.right$1 = right$1;
                    this.leftKeys$1 = leftKeys$1;
                    this.rightKeys$1 = rightKeys$1;
                    this.leftFields$1 = leftFields$1;
                    this.rightFields$1 = rightFields$1;
                }
            });
            tuple2 = new Tuple2(leftKeys.toArray(ClassTag$.MODULE$.Int()), rightKeys.toArray(ClassTag$.MODULE$.Int()));
        }
        return tuple2;
    }

    public boolean checkAndGetJoinKeys$default$4() {
        return false;
    }

    public JoinInfo createJoinInfo(RelNode left, RelNode right, RexNode condition, java.util.List<Boolean> filterNulls2) {
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RexNode remaining = RelOptUtil.splitJoinCondition(left, right, condition, leftKeys, rightKeys, filterNulls2);
        return remaining.isAlwaysTrue() ? JoinInfo.of(ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys)) : JoinInfo.of(left, right, condition);
    }

    public GeneratedJoinCondition generateConditionFunction(TableConfig config, RexBuilder rexBuilder, JoinInfo joinInfo, LogicalType leftType, LogicalType rightType) {
        String string;
        CodeGeneratorContext ctx = CodeGeneratorContext$.MODULE$.apply(config);
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        LogicalType x$1 = leftType;
        String x$2 = qual$1.bindInput$default$2();
        Option<int[]> x$3 = qual$1.bindInput$default$3();
        ExprCodeGenerator qual$2 = qual$1.bindInput(x$1, x$2, x$3);
        LogicalType x$4 = rightType;
        String x$5 = qual$2.bindSecondInput$default$2();
        Option<int[]> x$6 = qual$2.bindSecondInput$default$3();
        ExprCodeGenerator exprGenerator = qual$2.bindSecondInput(x$4, x$5, x$6);
        if (joinInfo.isEqui()) {
            string = "return true;";
        } else {
            RexNode nonEquiPredicates = joinInfo.getRemaining(rexBuilder);
            GeneratedExpression condition = exprGenerator.generateExpression(nonEquiPredicates);
            string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |return ", ";\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condition.code(), condition.resultTerm()})))).stripMargin();
        }
        String body = string;
        return FunctionCodeGenerator$.MODULE$.generateJoinCondition(ctx, "ConditionFunction", body, FunctionCodeGenerator$.MODULE$.generateJoinCondition$default$4(), FunctionCodeGenerator$.MODULE$.generateJoinCondition$default$5());
    }

    private JoinUtil$() {
        MODULE$ = this;
    }
}

