/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.rules.logical.PushPartitionIntoTableSourceScanRule$;
import org.apache.flink.table.planner.plan.schema.FlinkRelOptTable;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.PartitionPruner$;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor$;
import org.apache.flink.table.sources.PartitionableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001'\t!\u0003+^:i!\u0006\u0014H/\u001b;j_:Le\u000e^8UC\ndWmU8ve\u000e,7kY1o%VdWM\u0003\u0002\u0004\t\u00059An\\4jG\u0006d'BA\u0003\u0007\u0003\u0015\u0011X\u000f\\3t\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q#G\u0007\u0002-)\u0011qa\u0006\u0006\u000319\tqaY1mG&$X-\u0003\u0002\u001b-\tQ!+\u001a7PaR\u0014V\u000f\\3\t\u000bq\u0001A\u0011A\u000f\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005\u0011\u0001\"B\u0011\u0001\t\u0003\u0012\u0013aB7bi\u000eDWm\u001d\u000b\u0003G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012qAQ8pY\u0016\fg\u000eC\u0003+A\u0001\u00071&\u0001\u0003dC2d\u0007CA\u000b-\u0013\ticC\u0001\bSK2|\u0005\u000f\u001e*vY\u0016\u001c\u0015\r\u001c7\t\u000b=\u0002A\u0011\t\u0019\u0002\u000f=tW*\u0019;dQR\u0011\u0011\u0007\u000e\t\u0003IIJ!aM\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006U9\u0002\ra\u000b\u0005\u0006m\u0001!IaN\u0001\u0016aV\u001c\b\u000eU1si&$\u0018n\u001c8J]R|7kY1o)\u0015\t\u0004(O\"K\u0011\u0015QS\u00071\u0001,\u0011\u0015QT\u00071\u0001<\u0003\u00191\u0017\u000e\u001c;feB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005G>\u0014XM\u0003\u0002A/\u0005\u0019!/\u001a7\n\u0005\tk$A\u0002$jYR,'\u000fC\u0003Ek\u0001\u0007Q)\u0001\u0003tG\u0006t\u0007C\u0001$I\u001b\u00059%BA\u0002@\u0013\tIuI\u0001\tM_\u001eL7-\u00197UC\ndWmU2b]\")1*\u000ea\u0001\u0019\u0006Y!/\u001a7PaR$\u0016M\u00197f!\ti\u0005+D\u0001O\u0015\tye!\u0001\u0004tG\",W.Y\u0005\u0003#:\u0013\u0001C\u00127j].\u0014V\r\\(qiR\u000b'\r\\3\t\u000bM\u0003A\u0011\u0002+\u00021\u0005$'.^:u!\u0006\u0014H/\u001b;j_:\u0004&/\u001a3jG\u0006$X\r\u0006\u0003V7\u001eL\u0007C\u0001,Z\u001b\u00059&B\u0001-\u0018\u0003\r\u0011X\r_\u0005\u00035^\u0013qAU3y\u001d>$W\rC\u0003]%\u0002\u0007Q,A\bj]B,HOR5fY\u0012t\u0015-\\3t!\r!c\fY\u0005\u0003?\u0016\u0012Q!\u0011:sCf\u0004\"!\u00193\u000f\u0005\u0011\u0012\u0017BA2&\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r,\u0003\"\u00025S\u0001\u0004i\u0016a\u00059beRLG/[8o\r&,G\u000e\u001a(b[\u0016\u001c\b\"\u00026S\u0001\u0004)\u0016A\u00059beRLG/[8o!J,G-[2bi\u0016<Q\u0001\u001c\u0002\t\u00025\fA\u0005U;tQB\u000b'\u000f^5uS>t\u0017J\u001c;p)\u0006\u0014G.Z*pkJ\u001cWmU2b]J+H.\u001a\t\u0003?94Q!\u0001\u0002\t\u0002=\u001c\"A\u001c9\u0011\u0005\u0011\n\u0018B\u0001:&\u0005\u0019\te.\u001f*fM\")AD\u001cC\u0001iR\tQ\u000eC\u0004w]\n\u0007I\u0011A<\u0002\u0011%s5\u000bV!O\u0007\u0016+\u0012\u0001\u0006\u0005\u0007s:\u0004\u000b\u0011\u0002\u000b\u0002\u0013%s5\u000bV!O\u0007\u0016\u0003\u0003")
public class PushPartitionIntoTableSourceScanRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return PushPartitionIntoTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean bl;
        Filter filter = (Filter)call.rel(0);
        if (filter.getCondition() == null) {
            return false;
        }
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        if (tableSourceTable != null) {
            boolean bl2;
            TableSourceTable tableSourceTable2 = tableSourceTable;
            TableSource tableSource = tableSourceTable2.tableSource();
            if (tableSource instanceof PartitionableTableSource) {
                PartitionableTableSource partitionableTableSource = (PartitionableTableSource)((Object)tableSource);
                bl2 = JavaConversions$.MODULE$.asScalaBuffer(partitionableTableSource.getPartitionFieldNames()).nonEmpty();
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        FlinkRelOptTable table = (FlinkRelOptTable)scan.getTable();
        this.pushPartitionIntoScan(call, filter, scan, table);
    }

    private void pushPartitionIntoScan(RelOptRuleCall call, Filter filter, LogicalTableScan scan, FlinkRelOptTable relOptTable) {
        TableSourceTable tableSourceTable = relOptTable.unwrap(TableSourceTable.class);
        PartitionableTableSource tableSource = (PartitionableTableSource)((Object)tableSourceTable.tableSource());
        String[] partitionFieldNames = (String[])JavaConversions$.MODULE$.asScalaBuffer(tableSource.getPartitionFieldNames()).toList().toArray(ClassTag$.MODULE$.apply(String.class));
        RelDataType inputFieldType = filter.getInput().getRowType();
        RelBuilder relBuilder = call.builder();
        int maxCnfNodeCount = FlinkRelOptUtil$.MODULE$.getMaxCnfNodeCount(scan);
        Tuple2<RexNode, RexNode> tuple2 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(filter.getCondition(), maxCnfNodeCount, (String[])JavaConversions$.MODULE$.asScalaBuffer(inputFieldType.getFieldNames()).toList().toArray(ClassTag$.MODULE$.apply(String.class)), relBuilder.getRexBuilder(), partitionFieldNames);
        if (tuple2 != null) {
            FlinkStatistic flinkStatistic;
            Tuple2 tuple22;
            RexNode partitionPredicate = (RexNode)tuple2._1();
            RexNode nonPartitionPredicate = (RexNode)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionPredicate, (Object)nonPartitionPredicate);
            RexNode partitionPredicate2 = (RexNode)tuple23._1();
            RexNode nonPartitionPredicate2 = (RexNode)tuple23._2();
            if (partitionPredicate2.isAlwaysTrue()) {
                return;
            }
            RexNode finalPartitionPredicate = this.adjustPartitionPredicate((String[])JavaConversions$.MODULE$.asScalaBuffer(inputFieldType.getFieldNames()).toList().toArray(ClassTag$.MODULE$.apply(String.class)), partitionFieldNames, partitionPredicate2);
            LogicalType[] partitionFieldTypes = (LogicalType[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitionFieldNames).map((Function1)new Serializable(this, inputFieldType){
                public static final long serialVersionUID = 0L;
                public final RelDataType inputFieldType$1;

                public final RelDataType apply(String name) {
                    int index = this.inputFieldType$1.getFieldNames().indexOf(name);
                    Predef$.MODULE$.require(index >= 0, (Function0)new Serializable(this, name){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$1 $outer;
                        private final String name$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not found in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, JavaConversions$.MODULE$.asScalaBuffer(this.$outer.inputFieldType$1.getFieldNames()).mkString(", ")}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.name$1 = name$1;
                        }
                    });
                    return this.inputFieldType$1.getFieldList().get(index).getType();
                }
                {
                    this.inputFieldType$1 = inputFieldType$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class)))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final LogicalType apply(RelDataType relDataType) {
                    return FlinkTypeFactory$.MODULE$.toLogicalType(relDataType);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
            List<Map<String, String>> allPartitions = tableSource.getPartitions();
            List<Map<String, String>> remainingPartitions = PartitionPruner$.MODULE$.prunePartitions(((FlinkContext)call.getPlanner().getContext()).getTableConfig(), partitionFieldNames, partitionFieldTypes, allPartitions, finalPartitionPredicate);
            TableSource newTableSource = tableSource.applyPartitionPruning(remainingPartitions);
            FlinkStatistic statistic2 = tableSourceTable.statistic();
            if (remainingPartitions.size() == allPartitions.size()) {
                flinkStatistic = statistic2;
            } else {
                FlinkStatistic flinkStatistic2 = statistic2;
                FlinkStatistic flinkStatistic3 = FlinkStatistic$.MODULE$.UNKNOWN();
                flinkStatistic = !(flinkStatistic2 != null ? !flinkStatistic2.equals(flinkStatistic3) : flinkStatistic3 != null) ? statistic2 : FlinkStatistic$.MODULE$.builder().statistic(statistic2).tableStats(null).build();
            }
            FlinkStatistic newStatistic = flinkStatistic;
            TableSourceTable newTableSourceTable = new TableSourceTable(newTableSource, tableSourceTable.isStreamingMode(), newStatistic);
            FlinkRelOptTable newRelOptTable = relOptTable.copy(newTableSourceTable, relOptTable.getRowType());
            LogicalTableScan newScan = new LogicalTableScan(scan.getCluster(), scan.getTraitSet(), newRelOptTable);
            if (nonPartitionPredicate2.isAlwaysTrue()) {
                call.transformTo(newScan);
            } else {
                Filter newFilter = filter.copy(filter.getTraitSet(), newScan, nonPartitionPredicate2);
                call.transformTo(newFilter);
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    private RexNode adjustPartitionPredicate(String[] inputFieldNames, String[] partitionFieldNames, RexNode partitionPredicate) {
        return partitionPredicate.accept(new RexShuttle(this, inputFieldNames, partitionFieldNames){
            private final String[] inputFieldNames$1;
            public final String[] partitionFieldNames$1;

            public RexNode visitInputRef(RexInputRef inputRef) {
                int index = inputRef.getIndex();
                String fieldName = this.inputFieldNames$1[index];
                int newIndex = Predef$.MODULE$.refArrayOps((Object[])this.partitionFieldNames$1).indexOf((Object)fieldName);
                Predef$.MODULE$.require(newIndex >= 0, (Function0)new Serializable(this, fieldName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    private final String fieldName$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not found in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fieldName$1, Predef$.MODULE$.refArrayOps((Object[])this.$outer.partitionFieldNames$1).mkString(", ")}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.fieldName$1 = fieldName$1;
                    }
                });
                return index == newIndex ? inputRef : new RexInputRef(newIndex, inputRef.getType());
            }
            {
                this.inputFieldNames$1 = inputFieldNames$1;
                this.partitionFieldNames$1 = partitionFieldNames$1;
            }
        });
    }

    public PushPartitionIntoTableSourceScanRule() {
        super(RelOptRule.operand(Filter.class, RelOptRule.operand(LogicalTableScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushPartitionIntoTableSourceScanRule");
    }
}

