/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionDefaultVisitor;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.LookupCallResolver;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.operations.AggregateQueryOperation;
import org.apache.flink.table.operations.CalculatedQueryOperation;
import org.apache.flink.table.operations.CatalogQueryOperation;
import org.apache.flink.table.operations.DistinctQueryOperation;
import org.apache.flink.table.operations.FilterQueryOperation;
import org.apache.flink.table.operations.JavaDataStreamQueryOperation;
import org.apache.flink.table.operations.JoinQueryOperation;
import org.apache.flink.table.operations.ProjectQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.operations.ScalaDataStreamQueryOperation;
import org.apache.flink.table.operations.SetQueryOperation;
import org.apache.flink.table.operations.SortQueryOperation;
import org.apache.flink.table.operations.TableSourceQueryOperation;
import org.apache.flink.table.operations.WindowAggregateQueryOperation;
import org.apache.flink.table.operations.utils.QueryOperationDefaultVisitor;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.PlannerProctimeAttribute;
import org.apache.flink.table.planner.expressions.PlannerRowtimeAttribute;
import org.apache.flink.table.planner.expressions.PlannerWindowEnd;
import org.apache.flink.table.planner.expressions.PlannerWindowReference;
import org.apache.flink.table.planner.expressions.PlannerWindowStart;
import org.apache.flink.table.planner.expressions.RexNodeConverter;
import org.apache.flink.table.planner.expressions.RexNodeExpression;
import org.apache.flink.table.planner.expressions.SqlAggFunctionVisitor;
import org.apache.flink.table.planner.functions.utils.TableSqlFunction;
import org.apache.flink.table.planner.operations.DataStreamQueryOperation;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.RichTableSourceQueryOperation;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.schema.DataStreamTable;
import org.apache.flink.table.planner.plan.schema.FlinkRelOptTable;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.schema.TypedFlinkTableFunction;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.sources.LookupableTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;
import scala.Option;
import scala.Some;

@Internal
public class QueryOperationConverter
extends QueryOperationDefaultVisitor<RelNode> {
    private final FlinkRelBuilder relBuilder;
    private final SingleRelVisitor singleRelVisitor = new SingleRelVisitor();
    private final LookupCallResolver callResolver;
    private final RexNodeConverter rexNodeConverter;
    private final AggregateVisitor aggregateVisitor = new AggregateVisitor();
    private final JoinExpressionVisitor joinExpressionVisitor = new JoinExpressionVisitor();

    public QueryOperationConverter(FlinkRelBuilder relBuilder, FunctionLookup functionCatalog) {
        this.relBuilder = relBuilder;
        this.callResolver = new LookupCallResolver(functionCatalog);
        this.rexNodeConverter = new RexNodeConverter(relBuilder);
    }

    @Override
    public RelNode defaultMethod(QueryOperation other) {
        other.getChildren().forEach(child -> this.relBuilder.push(child.accept(this)));
        return other.accept(this.singleRelVisitor);
    }

    private RexNode convertExprToRexNode(Expression expr) {
        return expr.accept(this.callResolver).accept(this.rexNodeConverter);
    }

    private class AggCallVisitor
    extends ExpressionDefaultVisitor<RelBuilder.AggCall> {
        private final RelBuilder relBuilder;
        private final SqlAggFunctionVisitor sqlAggFunctionVisitor;
        private final RexNodeConverter rexNodeConverter;
        private final String name;
        private final boolean isDistinct;

        public AggCallVisitor(RelBuilder relBuilder, RexNodeConverter rexNodeConverter, String name, boolean isDistinct) {
            this.relBuilder = relBuilder;
            this.sqlAggFunctionVisitor = new SqlAggFunctionVisitor((FlinkTypeFactory)relBuilder.getTypeFactory());
            this.rexNodeConverter = rexNodeConverter;
            this.name = name;
            this.isDistinct = isDistinct;
        }

        @Override
        public RelBuilder.AggCall visit(CallExpression call) {
            FunctionDefinition def = call.getFunctionDefinition();
            if (BuiltInFunctionDefinitions.DISTINCT == def) {
                Expression innerAgg = call.getChildren().get(0);
                return innerAgg.accept(new AggCallVisitor(this.relBuilder, this.rexNodeConverter, this.name, true));
            }
            SqlAggFunction sqlAggFunction = call.accept(this.sqlAggFunctionVisitor);
            return this.relBuilder.aggregateCall(sqlAggFunction, this.isDistinct, false, null, this.name, call.getChildren().stream().map(expr -> expr.accept(this.rexNodeConverter)).collect(Collectors.toList()));
        }

        @Override
        protected RelBuilder.AggCall defaultMethod(Expression expression2) {
            throw new TableException("Unexpected expression: " + expression2);
        }
    }

    private class AggregateVisitor
    extends ExpressionDefaultVisitor<RelBuilder.AggCall> {
        private AggregateVisitor() {
        }

        @Override
        public RelBuilder.AggCall visit(CallExpression unresolvedCall) {
            if (unresolvedCall.getFunctionDefinition() == BuiltInFunctionDefinitions.AS) {
                String aggregateName = ExpressionUtils.extractValue(unresolvedCall.getChildren().get(1), String.class).orElseThrow(() -> new TableException("Unexpected name."));
                Expression aggregate = unresolvedCall.getChildren().get(0);
                if (ApiExpressionUtils.isFunctionOfKind(aggregate, FunctionKind.AGGREGATE)) {
                    return aggregate.accept(QueryOperationConverter.this.callResolver).accept(new AggCallVisitor(QueryOperationConverter.this.relBuilder, QueryOperationConverter.this.rexNodeConverter, aggregateName, false));
                }
            }
            throw new TableException("Expected named aggregate. Got: " + unresolvedCall);
        }

        @Override
        protected RelBuilder.AggCall defaultMethod(Expression expression2) {
            throw new TableException("Unexpected expression: " + expression2);
        }
    }

    private class JoinExpressionVisitor
    extends ExpressionDefaultVisitor<RexNode> {
        private static final int numberOfJoinInputs = 2;

        private JoinExpressionVisitor() {
        }

        @Override
        public RexNode visit(CallExpression callExpression) {
            List<ResolvedExpression> newChildren = callExpression.getChildren().stream().map(expr -> {
                RexNode convertedNode = expr.accept(this);
                return new RexNodeExpression(convertedNode, ((ResolvedExpression)expr).getOutputDataType());
            }).collect(Collectors.toList());
            CallExpression newCall = new CallExpression(callExpression.getObjectIdentifier().get(), callExpression.getFunctionDefinition(), newChildren, callExpression.getOutputDataType());
            return QueryOperationConverter.this.convertExprToRexNode(newCall);
        }

        @Override
        public RexNode visit(FieldReferenceExpression fieldReference2) {
            return QueryOperationConverter.this.relBuilder.field(2, fieldReference2.getInputIndex(), fieldReference2.getFieldIndex());
        }

        @Override
        protected RexNode defaultMethod(Expression expression2) {
            return QueryOperationConverter.this.convertExprToRexNode(expression2);
        }
    }

    private class SingleRelVisitor
    implements QueryOperationVisitor<RelNode> {
        private SingleRelVisitor() {
        }

        @Override
        public RelNode visit(ProjectQueryOperation projection) {
            List<RexNode> rexNodes = this.convertToRexNodes(projection.getProjectList());
            return QueryOperationConverter.this.relBuilder.project(rexNodes, Arrays.asList(projection.getTableSchema().getFieldNames()), true).build();
        }

        @Override
        public RelNode visit(AggregateQueryOperation aggregate) {
            List<RelBuilder.AggCall> aggregations = aggregate.getAggregateExpressions().stream().map(this::getAggCall).collect(Collectors.toList());
            List<RexNode> groupings = this.convertToRexNodes(aggregate.getGroupingExpressions());
            RelBuilder.GroupKey groupKey = QueryOperationConverter.this.relBuilder.groupKey(groupings);
            return QueryOperationConverter.this.relBuilder.aggregate(groupKey, (Iterable<RelBuilder.AggCall>)aggregations).build();
        }

        @Override
        public RelNode visit(WindowAggregateQueryOperation windowAggregate) {
            List<RelBuilder.AggCall> aggregations = windowAggregate.getAggregateExpressions().stream().map(this::getAggCall).collect(Collectors.toList());
            List<RexNode> groupings = this.convertToRexNodes(windowAggregate.getGroupingExpressions());
            LogicalWindow logicalWindow = this.toLogicalWindow(windowAggregate.getGroupWindow());
            PlannerWindowReference windowReference = logicalWindow.aliasAttribute();
            List<FlinkRelBuilder.PlannerNamedWindowProperty> windowProperties = windowAggregate.getWindowPropertiesExpressions().stream().map(expr -> this.convertToWindowProperty(expr.accept(QueryOperationConverter.this.callResolver), windowReference)).collect(Collectors.toList());
            RelBuilder.GroupKey groupKey = QueryOperationConverter.this.relBuilder.groupKey(groupings);
            return QueryOperationConverter.this.relBuilder.aggregate(logicalWindow, groupKey, windowProperties, aggregations).build();
        }

        private FlinkRelBuilder.PlannerNamedWindowProperty convertToWindowProperty(Expression expression2, PlannerWindowReference windowReference) {
            Preconditions.checkArgument((boolean)(expression2 instanceof CallExpression), (Object)"This should never happened");
            CallExpression aliasExpr = (CallExpression)expression2;
            Preconditions.checkArgument((BuiltInFunctionDefinitions.AS == aliasExpr.getFunctionDefinition() ? 1 : 0) != 0, (Object)"This should never happened");
            String name = ((ValueLiteralExpression)aliasExpr.getChildren().get(1)).getValueAs(String.class).orElseThrow(() -> new TableException("Invalid literal."));
            Expression windowPropertyExpr = aliasExpr.getChildren().get(0);
            Preconditions.checkArgument((boolean)(windowPropertyExpr instanceof CallExpression), (Object)"This should never happened");
            CallExpression windowPropertyCallExpr = (CallExpression)windowPropertyExpr;
            FunctionDefinition fd = windowPropertyCallExpr.getFunctionDefinition();
            if (BuiltInFunctionDefinitions.WINDOW_START == fd) {
                return new FlinkRelBuilder.PlannerNamedWindowProperty(name, new PlannerWindowStart(windowReference));
            }
            if (BuiltInFunctionDefinitions.WINDOW_END == fd) {
                return new FlinkRelBuilder.PlannerNamedWindowProperty(name, new PlannerWindowEnd(windowReference));
            }
            if (BuiltInFunctionDefinitions.PROCTIME == fd) {
                return new FlinkRelBuilder.PlannerNamedWindowProperty(name, new PlannerProctimeAttribute(windowReference));
            }
            if (BuiltInFunctionDefinitions.ROWTIME == fd) {
                return new FlinkRelBuilder.PlannerNamedWindowProperty(name, new PlannerRowtimeAttribute(windowReference));
            }
            throw new TableException("Invalid literal.");
        }

        private RelBuilder.AggCall getAggCall(Expression aggregateExpression) {
            if (ApiExpressionUtils.isFunctionOfKind(aggregateExpression, FunctionKind.TABLE_AGGREGATE)) {
                throw new UnsupportedOperationException("TableAggFunction is not supported yet!");
            }
            return aggregateExpression.accept(QueryOperationConverter.this.aggregateVisitor);
        }

        @Override
        public RelNode visit(JoinQueryOperation join) {
            Set<CorrelationId> corSet = join.isCorrelated() ? Collections.singleton(QueryOperationConverter.this.relBuilder.peek().getCluster().createCorrel()) : Collections.emptySet();
            return QueryOperationConverter.this.relBuilder.join(this.convertJoinType(join.getJoinType()), join.getCondition().accept(QueryOperationConverter.this.joinExpressionVisitor), corSet).build();
        }

        @Override
        public RelNode visit(SetQueryOperation setOperation) {
            switch (setOperation.getType()) {
                case INTERSECT: {
                    QueryOperationConverter.this.relBuilder.intersect(setOperation.isAll());
                    break;
                }
                case MINUS: {
                    QueryOperationConverter.this.relBuilder.minus(setOperation.isAll());
                    break;
                }
                case UNION: {
                    QueryOperationConverter.this.relBuilder.union(setOperation.isAll());
                }
            }
            return QueryOperationConverter.this.relBuilder.build();
        }

        @Override
        public RelNode visit(FilterQueryOperation filter) {
            RexNode rexNode = QueryOperationConverter.this.convertExprToRexNode(filter.getCondition());
            return QueryOperationConverter.this.relBuilder.filter(rexNode).build();
        }

        @Override
        public RelNode visit(DistinctQueryOperation distinct) {
            return QueryOperationConverter.this.relBuilder.distinct().build();
        }

        @Override
        public RelNode visit(SortQueryOperation sort) {
            List<RexNode> rexNodes = this.convertToRexNodes(sort.getOrder());
            return QueryOperationConverter.this.relBuilder.sortLimit(sort.getOffset(), sort.getFetch(), rexNodes).build();
        }

        @Override
        public <U> RelNode visit(CalculatedQueryOperation<U> calculatedTable) {
            DataType resultType2 = TypeConversions.fromLegacyInfoToDataType(calculatedTable.getResultType());
            TableFunction<U> tableFunction = calculatedTable.getTableFunction();
            String[] fieldNames = calculatedTable.getTableSchema().getFieldNames();
            TypedFlinkTableFunction function = new TypedFlinkTableFunction(tableFunction, fieldNames, resultType2);
            FlinkTypeFactory typeFactory = QueryOperationConverter.this.relBuilder.getTypeFactory();
            TableSqlFunction sqlFunction = new TableSqlFunction(tableFunction.functionIdentifier(), tableFunction.toString(), tableFunction, resultType2, typeFactory, function, (Option<SqlOperandTypeChecker>)Option.empty());
            List<RexNode> parameters = this.convertToRexNodes(calculatedTable.getParameters());
            return LogicalTableFunctionScan.create(QueryOperationConverter.this.relBuilder.peek().getCluster(), Collections.emptyList(), QueryOperationConverter.this.relBuilder.call((SqlOperator)sqlFunction, parameters), function.getElementType(null), function.getRowType(typeFactory, null, null), null);
        }

        @Override
        public RelNode visit(CatalogQueryOperation catalogTable) {
            return QueryOperationConverter.this.relBuilder.scan(catalogTable.getTablePath()).build();
        }

        @Override
        public RelNode visit(QueryOperation other) {
            if (other instanceof PlannerQueryOperation) {
                return ((PlannerQueryOperation)other).getCalciteTree();
            }
            if (other instanceof DataStreamQueryOperation) {
                return this.convertToDataStreamScan((DataStreamQueryOperation)other);
            }
            if (other instanceof JavaDataStreamQueryOperation) {
                JavaDataStreamQueryOperation dataStreamQueryOperation = (JavaDataStreamQueryOperation)other;
                return this.convertToDataStreamScan(dataStreamQueryOperation.getDataStream(), dataStreamQueryOperation.getFieldIndices(), dataStreamQueryOperation.getTableSchema());
            }
            if (other instanceof ScalaDataStreamQueryOperation) {
                ScalaDataStreamQueryOperation dataStreamQueryOperation = (ScalaDataStreamQueryOperation)other;
                return this.convertToDataStreamScan(dataStreamQueryOperation.getDataStream(), dataStreamQueryOperation.getFieldIndices(), dataStreamQueryOperation.getTableSchema());
            }
            throw new TableException("Unknown table operation: " + other);
        }

        @Override
        public <U> RelNode visit(TableSourceQueryOperation<U> tableSourceOperation) {
            List<String> names;
            FlinkStatistic statistic2;
            boolean isBatch;
            TableSource<U> tableSource = tableSourceOperation.getTableSource();
            if (tableSource instanceof LookupableTableSource) {
                isBatch = tableSourceOperation.isBatch();
            } else if (tableSource instanceof StreamTableSource) {
                isBatch = ((StreamTableSource)tableSource).isBounded();
            } else {
                throw new TableException(String.format("%s is not supported.", tableSource.getClass().getSimpleName()));
            }
            if (tableSourceOperation instanceof RichTableSourceQueryOperation && ((RichTableSourceQueryOperation)tableSourceOperation).getQualifiedName() != null) {
                statistic2 = ((RichTableSourceQueryOperation)tableSourceOperation).getStatistic();
                names = ((RichTableSourceQueryOperation)tableSourceOperation).getQualifiedName();
            } else {
                statistic2 = FlinkStatistic.UNKNOWN();
                String refId = "Unregistered_TableSource_" + System.identityHashCode(tableSource);
                names = Collections.singletonList(refId);
            }
            TableSourceTable<U> tableSourceTable = new TableSourceTable<U>(tableSource, !isBatch, statistic2);
            FlinkRelOptTable table = FlinkRelOptTable.create(QueryOperationConverter.this.relBuilder.getRelOptSchema(), tableSourceTable.getRowType(QueryOperationConverter.this.relBuilder.getTypeFactory()), names, tableSourceTable);
            return LogicalTableScan.create(QueryOperationConverter.this.relBuilder.getCluster(), table);
        }

        private RelNode convertToDataStreamScan(DataStreamQueryOperation<?> operation) {
            List<String> names;
            DataStreamTable dataStreamTable = new DataStreamTable(operation.getDataStream(), operation.isProducesUpdates(), operation.isAccRetract(), operation.getFieldIndices(), operation.getTableSchema().getFieldNames(), operation.getStatistic(), (Option<boolean[]>)Option.apply((Object)operation.getFieldNullables()));
            if (operation.getQualifiedName() != null) {
                names = operation.getQualifiedName();
            } else {
                String refId = String.format("Unregistered_DataStream_%s", operation.getDataStream().getId());
                names = Collections.singletonList(refId);
            }
            FlinkRelOptTable table = FlinkRelOptTable.create(QueryOperationConverter.this.relBuilder.getRelOptSchema(), dataStreamTable.getRowType(QueryOperationConverter.this.relBuilder.getTypeFactory()), names, dataStreamTable);
            return LogicalTableScan.create(QueryOperationConverter.this.relBuilder.getCluster(), table);
        }

        private RelNode convertToDataStreamScan(DataStream<?> dataStream, int[] fieldIndices, TableSchema tableSchema) {
            DataStreamTable dataStreamTable = new DataStreamTable(dataStream, false, false, fieldIndices, tableSchema.getFieldNames(), FlinkStatistic.UNKNOWN(), (Option<boolean[]>)Option.empty());
            String refId = String.format("Unregistered_DataStream_%s", dataStream.getId());
            FlinkRelOptTable table = FlinkRelOptTable.create(QueryOperationConverter.this.relBuilder.getRelOptSchema(), dataStreamTable.getRowType(QueryOperationConverter.this.relBuilder.getTypeFactory()), Collections.singletonList(refId), dataStreamTable);
            return LogicalTableScan.create(QueryOperationConverter.this.relBuilder.getCluster(), table);
        }

        private List<RexNode> convertToRexNodes(List<ResolvedExpression> expressions) {
            return expressions.stream().map(x$0 -> QueryOperationConverter.this.convertExprToRexNode(x$0)).collect(Collectors.toList());
        }

        private LogicalWindow toLogicalWindow(WindowAggregateQueryOperation.ResolvedGroupWindow window) {
            DataType windowType = window.getTimeAttribute().getOutputDataType();
            PlannerWindowReference windowReference = new PlannerWindowReference(window.getAlias(), (Option<LogicalType>)new Some((Object)TypeConversions.fromDataToLogicalType(windowType)));
            switch (window.getType()) {
                case SLIDE: {
                    return new SlidingGroupWindow(windowReference, window.getTimeAttribute(), window.getSize().orElseThrow(() -> new TableException("missed size parameters!")), window.getSlide().orElseThrow(() -> new TableException("missed slide parameters!")));
                }
                case SESSION: {
                    return new SessionGroupWindow(windowReference, window.getTimeAttribute(), window.getGap().orElseThrow(() -> new TableException("missed gap parameters!")));
                }
                case TUMBLE: {
                    return new TumblingGroupWindow(windowReference, window.getTimeAttribute(), window.getSize().orElseThrow(() -> new TableException("missed size parameters!")));
                }
            }
            throw new TableException("Unknown window type");
        }

        private JoinRelType convertJoinType(JoinQueryOperation.JoinType joinType) {
            switch (joinType) {
                case INNER: {
                    return JoinRelType.INNER;
                }
                case LEFT_OUTER: {
                    return JoinRelType.LEFT;
                }
                case RIGHT_OUTER: {
                    return JoinRelType.RIGHT;
                }
                case FULL_OUTER: {
                    return JoinRelType.FULL;
                }
            }
            throw new TableException("Unknown join type: " + (Object)((Object)joinType));
        }
    }
}

