/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;

@Internal
public class DataStreamQueryOperation<E>
implements QueryOperation {
    private List<String> qualifiedName;
    private final DataStream<E> dataStream;
    private final int[] fieldIndices;
    private final TableSchema tableSchema;
    private final boolean[] fieldNullables;
    private final boolean producesUpdates;
    private final boolean isAccRetract;
    private final FlinkStatistic statistic;

    public DataStreamQueryOperation(DataStream<E> dataStream, int[] fieldIndices, TableSchema tableSchema, boolean[] fieldNullables, boolean producesUpdates, boolean isAccRetract, FlinkStatistic statistic2) {
        this.dataStream = dataStream;
        this.tableSchema = tableSchema;
        this.fieldNullables = fieldNullables;
        this.fieldIndices = fieldIndices;
        this.producesUpdates = producesUpdates;
        this.isAccRetract = isAccRetract;
        this.statistic = statistic2;
    }

    public DataStreamQueryOperation(DataStream<E> dataStream, int[] fieldIndices, TableSchema tableSchema, boolean[] fieldNullables, FlinkStatistic statistic2) {
        this(dataStream, fieldIndices, tableSchema, fieldNullables, false, false, statistic2);
    }

    public DataStream<E> getDataStream() {
        return this.dataStream;
    }

    public int[] getFieldIndices() {
        return this.fieldIndices;
    }

    @Override
    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("id", this.dataStream.getId());
        args.put("fields", this.tableSchema.getFieldNames());
        return OperationUtils.formatWithChildren("DataStream", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public List<String> getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(List<String> qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public boolean[] getFieldNullables() {
        return this.fieldNullables;
    }

    public boolean isProducesUpdates() {
        return this.producesUpdates;
    }

    public boolean isAccRetract() {
        return this.isAccRetract;
    }

    public FlinkStatistic getStatistic() {
        return this.statistic;
    }
}

