/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.math.BigDecimal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;

public abstract class AvgAggFunction
extends DeclarativeAggregateFunction {
    private UnresolvedReferenceExpression sum = ApiExpressionUtils.unresolvedRef("sum");
    private UnresolvedReferenceExpression count = ApiExpressionUtils.unresolvedRef("count");

    public abstract DataType getSumType();

    @Override
    public int operandCount() {
        return 1;
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.sum, this.count};
    }

    @Override
    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getSumType(), DataTypes.BIGINT()};
    }

    @Override
    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.literal(0L, this.getSumType()), ExpressionBuilder.literal(0L)};
    }

    @Override
    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(0)), this.sum, ExpressionBuilder.plus(this.sum, this.operand(0))), ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(0)), this.count, ExpressionBuilder.plus(this.count, ExpressionBuilder.literal(1L)))};
    }

    @Override
    public Expression[] retractExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(0)), this.sum, ExpressionBuilder.minus(this.sum, this.operand(0))), ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(0)), this.count, ExpressionBuilder.minus(this.count, ExpressionBuilder.literal(1L)))};
    }

    @Override
    public Expression[] mergeExpressions() {
        return new Expression[]{ExpressionBuilder.plus(this.sum, this.mergeOperand(this.sum)), ExpressionBuilder.plus(this.count, this.mergeOperand(this.count))};
    }

    @Override
    public Expression getValueExpression() {
        Expression ifTrue = ExpressionBuilder.nullOf(this.getResultType());
        Expression ifFalse = ExpressionBuilder.cast(ExpressionBuilder.div(this.sum, this.count), ExpressionBuilder.typeLiteral(this.getResultType()));
        return ExpressionBuilder.ifThenElse(ExpressionBuilder.equalTo(this.count, ExpressionBuilder.literal(0L)), ifTrue, ifFalse);
    }

    public static class DecimalAvgAggFunction
    extends AvgAggFunction {
        private final DecimalType type;

        public DecimalAvgAggFunction(DecimalType type) {
            this.type = type;
        }

        @Override
        public DataType getResultType() {
            DecimalType t = FlinkTypeSystem.inferAggAvgType(this.type.getScale());
            return DataTypes.DECIMAL(t.getPrecision(), t.getScale());
        }

        @Override
        public DataType getSumType() {
            DecimalType t = FlinkTypeSystem.inferAggSumType(this.type.getScale());
            return DataTypes.DECIMAL(t.getPrecision(), t.getScale());
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(BigDecimal.ZERO, this.getSumType()), ExpressionBuilder.literal(0L)};
        }
    }

    public static class DoubleAvgAggFunction
    extends AvgAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }

        @Override
        public DataType getSumType() {
            return DataTypes.DOUBLE();
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(0.0), ExpressionBuilder.literal(0L)};
        }
    }

    public static class FloatAvgAggFunction
    extends AvgAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }

        @Override
        public DataType getSumType() {
            return DataTypes.DOUBLE();
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(0.0), ExpressionBuilder.literal(0L)};
        }
    }

    public static class LongAvgAggFunction
    extends AvgAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }

        @Override
        public DataType getSumType() {
            return DataTypes.BIGINT();
        }
    }

    public static class IntAvgAggFunction
    extends AvgAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.INT();
        }

        @Override
        public DataType getSumType() {
            return DataTypes.BIGINT();
        }
    }

    public static class ShortAvgAggFunction
    extends AvgAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }

        @Override
        public DataType getSumType() {
            return DataTypes.BIGINT();
        }
    }

    public static class ByteAvgAggFunction
    extends AvgAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }

        @Override
        public DataType getSumType() {
            return DataTypes.BIGINT();
        }
    }
}

