/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OrdinalReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.TableReferenceExpression;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.expressions.TypeLiteralExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.RexAggLocalVariable;
import org.apache.flink.table.planner.calcite.RexDistinctKeyVariable;
import org.apache.flink.table.planner.expressions.ResolvedAggInputReference;
import org.apache.flink.table.planner.expressions.ResolvedAggLocalReference;
import org.apache.flink.table.planner.expressions.ResolvedDistinctKeyReference;
import org.apache.flink.table.planner.expressions.RexNodeExpression;
import org.apache.flink.table.planner.expressions.SqlAggFunctionVisitor;
import org.apache.flink.table.planner.functions.InternalFunctionDefinitions;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.sql.SqlThrowExceptionFunction;
import org.apache.flink.table.planner.functions.utils.UserDefinedFunctionUtils;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

public class RexNodeConverter
implements ExpressionVisitor<RexNode> {
    private final RelBuilder relBuilder;
    private final FlinkTypeFactory typeFactory;
    private final Map<FunctionDefinition, RexNodeConversion> conversionsOfBuiltInFunc = new IdentityHashMap<FunctionDefinition, RexNodeConversion>();

    public RexNodeConverter(RelBuilder relBuilder) {
        this.relBuilder = relBuilder;
        this.typeFactory = (FlinkTypeFactory)relBuilder.getRexBuilder().getTypeFactory();
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.CAST, exprs -> this.convertCast(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.REINTERPRET_CAST, exprs -> this.convertReinterpretCast(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.IN, exprs -> this.convertIn(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.GET, exprs -> this.convertGet(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.TRIM, exprs -> this.convertTrim(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.AS, exprs -> this.convertAs(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.OVER, exprs -> this.convertOver(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.IS_NULL, exprs -> this.convertIsNull(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.BETWEEN, exprs -> this.convertBetween(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.NOT_BETWEEN, exprs -> this.convertNotBetween(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.REPLACE, exprs -> this.convertReplace(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.PLUS, exprs -> this.convertPlus(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.CEIL, exprs -> this.convertCeil(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.FLOOR, exprs -> this.convertFloor(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.TEMPORAL_OVERLAPS, exprs -> this.convertTemporalOverlaps(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.TIMESTAMP_DIFF, exprs -> this.convertTimestampDiff(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.ARRAY, exprs -> this.convertArray(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.ARRAY_ELEMENT, exprs -> this.convertArrayElement(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.MAP, exprs -> this.convertMap(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.ROW, exprs -> this.convertRow(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.ORDER_ASC, exprs -> this.convertOrderAsc(exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SHA1, exprs -> this.convert(FlinkSqlOperatorTable.SHA1, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.AND, exprs -> this.convert(FlinkSqlOperatorTable.AND, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.OR, exprs -> this.convert(FlinkSqlOperatorTable.OR, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.NOT, exprs -> this.convert(FlinkSqlOperatorTable.NOT, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.IF, exprs -> this.convert(FlinkSqlOperatorTable.CASE, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.EQUALS, exprs -> this.convert(FlinkSqlOperatorTable.EQUALS, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.GREATER_THAN, exprs -> this.convert(FlinkSqlOperatorTable.GREATER_THAN, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL, exprs -> this.convert(FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.LESS_THAN, exprs -> this.convert(FlinkSqlOperatorTable.LESS_THAN, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, exprs -> this.convert(FlinkSqlOperatorTable.LESS_THAN_OR_EQUAL, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.NOT_EQUALS, exprs -> this.convert(FlinkSqlOperatorTable.NOT_EQUALS, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.IS_NULL, exprs -> this.convert(FlinkSqlOperatorTable.IS_NULL, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.IS_NOT_NULL, exprs -> this.convert(FlinkSqlOperatorTable.IS_NOT_NULL, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.IS_TRUE, exprs -> this.convert(FlinkSqlOperatorTable.IS_TRUE, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.IS_FALSE, exprs -> this.convert(FlinkSqlOperatorTable.IS_FALSE, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.IS_NOT_TRUE, exprs -> this.convert(FlinkSqlOperatorTable.IS_NOT_TRUE, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.IS_NOT_FALSE, exprs -> this.convert(FlinkSqlOperatorTable.IS_NOT_FALSE, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.CHAR_LENGTH, exprs -> this.convert(FlinkSqlOperatorTable.CHAR_LENGTH, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.INIT_CAP, exprs -> this.convert(FlinkSqlOperatorTable.INITCAP, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.LIKE, exprs -> this.convert(FlinkSqlOperatorTable.LIKE, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.LOWER, exprs -> this.convert(FlinkSqlOperatorTable.LOWER, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SIMILAR, exprs -> this.convert(FlinkSqlOperatorTable.SIMILAR_TO, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SUBSTRING, exprs -> this.convert(FlinkSqlOperatorTable.SUBSTRING, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.UPPER, exprs -> this.convert(FlinkSqlOperatorTable.UPPER, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.POSITION, exprs -> this.convert(FlinkSqlOperatorTable.POSITION, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.OVERLAY, exprs -> this.convert(FlinkSqlOperatorTable.OVERLAY, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.CONCAT, exprs -> this.convert(FlinkSqlOperatorTable.CONCAT_FUNCTION, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.CONCAT_WS, exprs -> this.convert(FlinkSqlOperatorTable.CONCAT_WS, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.LPAD, exprs -> this.convert(FlinkSqlOperatorTable.LPAD, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.RPAD, exprs -> this.convert(FlinkSqlOperatorTable.RPAD, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.REGEXP_EXTRACT, exprs -> this.convert(FlinkSqlOperatorTable.REGEXP_EXTRACT, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.FROM_BASE64, exprs -> this.convert(FlinkSqlOperatorTable.FROM_BASE64, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.TO_BASE64, exprs -> this.convert(FlinkSqlOperatorTable.TO_BASE64, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.UUID, exprs -> this.convert(FlinkSqlOperatorTable.UUID, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.LTRIM, exprs -> this.convert(FlinkSqlOperatorTable.LTRIM, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.RTRIM, exprs -> this.convert(FlinkSqlOperatorTable.RTRIM, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.REPEAT, exprs -> this.convert(FlinkSqlOperatorTable.REPEAT, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.REGEXP_REPLACE, exprs -> this.convert(FlinkSqlOperatorTable.REGEXP_REPLACE, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.MINUS, exprs -> this.convert(FlinkSqlOperatorTable.MINUS, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.DIVIDE, exprs -> this.convert(FlinkSqlOperatorTable.DIVIDE, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.TIMES, exprs -> this.convert(FlinkSqlOperatorTable.MULTIPLY, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.ABS, exprs -> this.convert(FlinkSqlOperatorTable.ABS, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.EXP, exprs -> this.convert(FlinkSqlOperatorTable.EXP, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.LOG10, exprs -> this.convert(FlinkSqlOperatorTable.LOG10, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.LOG2, exprs -> this.convert(FlinkSqlOperatorTable.LOG2, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.LN, exprs -> this.convert(FlinkSqlOperatorTable.LN, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.LOG, exprs -> this.convert(FlinkSqlOperatorTable.LOG, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.POWER, exprs -> this.convert(FlinkSqlOperatorTable.POWER, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.MOD, exprs -> this.convert(FlinkSqlOperatorTable.MOD, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SQRT, exprs -> relBuilder.call((SqlOperator)FlinkSqlOperatorTable.POWER, (Iterable<? extends RexNode>)this.convertCallChildren(Arrays.asList((Expression)exprs.get(0), ApiExpressionUtils.valueLiteral(0.5)))));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.MINUS_PREFIX, exprs -> this.convert(FlinkSqlOperatorTable.UNARY_MINUS, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SIN, exprs -> this.convert(FlinkSqlOperatorTable.SIN, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.COS, exprs -> this.convert(FlinkSqlOperatorTable.COS, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SINH, exprs -> this.convert(FlinkSqlOperatorTable.SINH, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.TAN, exprs -> this.convert(FlinkSqlOperatorTable.TAN, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.TANH, exprs -> this.convert(FlinkSqlOperatorTable.TANH, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.COT, exprs -> this.convert(FlinkSqlOperatorTable.COT, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.ASIN, exprs -> this.convert(FlinkSqlOperatorTable.ASIN, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.ACOS, exprs -> this.convert(FlinkSqlOperatorTable.ACOS, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.ATAN, exprs -> this.convert(FlinkSqlOperatorTable.ATAN, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.ATAN2, exprs -> this.convert(FlinkSqlOperatorTable.ATAN2, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.COSH, exprs -> this.convert(FlinkSqlOperatorTable.COSH, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.DEGREES, exprs -> this.convert(FlinkSqlOperatorTable.DEGREES, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.RADIANS, exprs -> this.convert(FlinkSqlOperatorTable.RADIANS, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SIGN, exprs -> this.convert(FlinkSqlOperatorTable.SIGN, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.ROUND, exprs -> this.convert(FlinkSqlOperatorTable.ROUND, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.PI, exprs -> this.convert(FlinkSqlOperatorTable.PI, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.E, exprs -> this.convert(FlinkSqlOperatorTable.E, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.RAND, exprs -> this.convert(FlinkSqlOperatorTable.RAND, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.RAND_INTEGER, exprs -> this.convert(FlinkSqlOperatorTable.RAND_INTEGER, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.BIN, exprs -> this.convert(FlinkSqlOperatorTable.BIN, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.HEX, exprs -> this.convert(FlinkSqlOperatorTable.HEX, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.TRUNCATE, exprs -> this.convert(FlinkSqlOperatorTable.TRUNCATE, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.EXTRACT, exprs -> this.convert(FlinkSqlOperatorTable.EXTRACT, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.CURRENT_DATE, exprs -> this.convert(FlinkSqlOperatorTable.CURRENT_DATE, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.CURRENT_TIME, exprs -> this.convert(FlinkSqlOperatorTable.CURRENT_TIME, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.CURRENT_TIMESTAMP, exprs -> this.convert(FlinkSqlOperatorTable.CURRENT_TIMESTAMP, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.LOCAL_TIME, exprs -> this.convert(FlinkSqlOperatorTable.LOCALTIME, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.LOCAL_TIMESTAMP, exprs -> this.convert(FlinkSqlOperatorTable.LOCALTIMESTAMP, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.DATE_FORMAT, exprs -> this.convert(FlinkSqlOperatorTable.DATE_FORMAT, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.AT, exprs -> this.convert(FlinkSqlOperatorTable.ITEM, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.CARDINALITY, exprs -> this.convert(FlinkSqlOperatorTable.CARDINALITY, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.ORDER_DESC, exprs -> this.convert(FlinkSqlOperatorTable.DESC, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.MD5, exprs -> this.convert(FlinkSqlOperatorTable.MD5, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SHA2, exprs -> this.convert(FlinkSqlOperatorTable.SHA2, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SHA224, exprs -> this.convert(FlinkSqlOperatorTable.SHA224, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SHA256, exprs -> this.convert(FlinkSqlOperatorTable.SHA256, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SHA384, exprs -> this.convert(FlinkSqlOperatorTable.SHA384, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SHA512, exprs -> this.convert(FlinkSqlOperatorTable.SHA512, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.SHA1, exprs -> this.convert(FlinkSqlOperatorTable.SHA1, exprs));
        this.conversionsOfBuiltInFunc.put(BuiltInFunctionDefinitions.STREAM_RECORD_TIMESTAMP, exprs -> this.convert(FlinkSqlOperatorTable.STREAMRECORD_TIMESTAMP, exprs));
        this.conversionsOfBuiltInFunc.put(InternalFunctionDefinitions.THROW_EXCEPTION, exprs -> {
            DataType type = ((TypeLiteralExpression)exprs.get(1)).getOutputDataType();
            return this.convert(new SqlThrowExceptionFunction(this.typeFactory.createFieldTypeFromLogicalType(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(type))), exprs.subList(0, 1));
        });
    }

    @Override
    public RexNode visit(CallExpression call) {
        FunctionDefinition func = call.getFunctionDefinition();
        if (func instanceof ScalarFunctionDefinition) {
            ScalarFunction scalaFunc = ((ScalarFunctionDefinition)func).getScalarFunction();
            List<RexNode> child = this.convertCallChildren(call.getChildren());
            SqlFunction sqlFunction = UserDefinedFunctionUtils.createScalarSqlFunction(scalaFunc.functionIdentifier(), scalaFunc.toString(), scalaFunc, this.typeFactory);
            return this.relBuilder.call((SqlOperator)sqlFunction, (Iterable<? extends RexNode>)child);
        }
        if (func instanceof TableFunctionDefinition) {
            throw new RuntimeException("There is no possible reach here!");
        }
        if (func instanceof AggregateFunctionDefinition) {
            AggregateFunction<?, ?> aggFunc = ((AggregateFunctionDefinition)func).getAggregateFunction();
            if (aggFunc instanceof AggregateFunction) {
                SqlFunction aggSqlFunction = UserDefinedFunctionUtils.createAggregateSqlFunction(aggFunc.functionIdentifier(), aggFunc.toString(), aggFunc, TypeConversions.fromLegacyInfoToDataType(aggFunc.getResultType()), TypeConversions.fromLegacyInfoToDataType(aggFunc.getAccumulatorType()), this.typeFactory);
                List<RexNode> child = this.convertCallChildren(call.getChildren());
                return this.relBuilder.call((SqlOperator)aggSqlFunction, (Iterable<? extends RexNode>)child);
            }
            throw new UnsupportedOperationException("TableAggregateFunction is not supported yet!");
        }
        FunctionDefinition def = call.getFunctionDefinition();
        if (this.conversionsOfBuiltInFunc.containsKey(def)) {
            RexNodeConversion conversion = this.conversionsOfBuiltInFunc.get(def);
            return conversion.convert(call);
        }
        throw new UnsupportedOperationException(def.toString());
    }

    private List<RexNode> convertCallChildren(List<Expression> children) {
        return children.stream().map(expression2 -> expression2.accept(this)).collect(Collectors.toList());
    }

    private RexNode convert(SqlOperator sqlOperator, List<Expression> children) {
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        return this.relBuilder.call(sqlOperator, (Iterable<? extends RexNode>)childrenRexNode);
    }

    private RexNode convertArrayElement(List<Expression> children) {
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        return this.relBuilder.call(FlinkSqlOperatorTable.ELEMENT, (Iterable<? extends RexNode>)childrenRexNode);
    }

    private RexNode convertOrderAsc(List<Expression> children) {
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        return childrenRexNode.get(0);
    }

    private RexNode convertTimestampDiff(List<Expression> children) {
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        return this.relBuilder.call((SqlOperator)FlinkSqlOperatorTable.TIMESTAMP_DIFF, childrenRexNode.get(0), childrenRexNode.get(2), childrenRexNode.get(1));
    }

    private RexNode convertIsNull(List<Expression> children) {
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        return this.relBuilder.isNull(childrenRexNode.get(0));
    }

    private RexNode convertNotBetween(List<Expression> children) {
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        Preconditions.checkArgument((childrenRexNode.size() == 3 ? 1 : 0) != 0);
        RexNode expr = childrenRexNode.get(0);
        RexNode lowerBound = childrenRexNode.get(1);
        RexNode upperBound = childrenRexNode.get(2);
        return this.relBuilder.or(this.relBuilder.call(FlinkSqlOperatorTable.LESS_THAN, expr, lowerBound), this.relBuilder.call(FlinkSqlOperatorTable.GREATER_THAN, expr, upperBound));
    }

    private RexNode convertBetween(List<Expression> children) {
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        Preconditions.checkArgument((childrenRexNode.size() == 3 ? 1 : 0) != 0);
        RexNode expr = childrenRexNode.get(0);
        RexNode lowerBound = childrenRexNode.get(1);
        RexNode upperBound = childrenRexNode.get(2);
        return this.relBuilder.and(this.relBuilder.call(FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL, expr, lowerBound), this.relBuilder.call(FlinkSqlOperatorTable.LESS_THAN_OR_EQUAL, expr, upperBound));
    }

    private RexNode convertCeil(List<Expression> children) {
        Preconditions.checkArgument((children.size() == 1 || children.size() == 2 ? 1 : 0) != 0);
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        if (children.size() == 1) {
            return this.relBuilder.call((SqlOperator)FlinkSqlOperatorTable.CEIL, (Iterable<? extends RexNode>)childrenRexNode);
        }
        return this.relBuilder.call((SqlOperator)FlinkSqlOperatorTable.CEIL, childrenRexNode.get(1), childrenRexNode.get(0));
    }

    private RexNode convertFloor(List<Expression> children) {
        Preconditions.checkArgument((children.size() == 1 || children.size() == 2 ? 1 : 0) != 0);
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        if (children.size() == 1) {
            return this.relBuilder.call((SqlOperator)FlinkSqlOperatorTable.FLOOR, (Iterable<? extends RexNode>)childrenRexNode);
        }
        return this.relBuilder.call((SqlOperator)FlinkSqlOperatorTable.FLOOR, childrenRexNode.get(1), childrenRexNode.get(0));
    }

    private RexNode convertArray(List<Expression> children) {
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        ArrayType arrayType = new ArrayType(FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType()));
        RelDataType relDataType = this.typeFactory.createFieldTypeFromLogicalType(arrayType);
        return this.relBuilder.getRexBuilder().makeCall(relDataType, FlinkSqlOperatorTable.ARRAY_VALUE_CONSTRUCTOR, childrenRexNode);
    }

    private RexNode convertMap(List<Expression> children) {
        Preconditions.checkArgument((!children.isEmpty() && children.size() % 2 == 0 ? 1 : 0) != 0);
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        RelDataType keyType = childrenRexNode.get(0).getType();
        RelDataType valueType = childrenRexNode.get(childrenRexNode.size() - 1).getType();
        RelDataType mapType = this.typeFactory.createMapType(keyType, valueType);
        return this.relBuilder.getRexBuilder().makeCall(mapType, FlinkSqlOperatorTable.MAP_VALUE_CONSTRUCTOR, childrenRexNode);
    }

    private RexNode convertRow(List<Expression> children) {
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        LogicalType[] childTypes = (LogicalType[])childrenRexNode.stream().map(rexNode -> FlinkTypeFactory.toLogicalType(rexNode.getType())).toArray(LogicalType[]::new);
        RowType rowType = RowType.of(childTypes);
        RelDataType relDataType = this.typeFactory.createFieldTypeFromLogicalType(rowType);
        return this.relBuilder.getRexBuilder().makeCall(relDataType, FlinkSqlOperatorTable.ROW, childrenRexNode);
    }

    private RexNode convertTemporalOverlaps(List<Expression> children) {
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        RexNode leftTimePoint = childrenRexNode.get(0);
        RexNode leftTemporal = childrenRexNode.get(1);
        RexNode rightTimePoint = childrenRexNode.get(2);
        RexNode rightTemporal = childrenRexNode.get(3);
        RexNode convLeftT = TypeCheckUtils.isTimeInterval(FlinkTypeFactory.toLogicalType(leftTemporal.getType())) ? this.relBuilder.call(FlinkSqlOperatorTable.DATETIME_PLUS, leftTimePoint, leftTemporal) : leftTemporal;
        RexNode leftLe = this.relBuilder.call(FlinkSqlOperatorTable.LESS_THAN_OR_EQUAL, leftTimePoint, convLeftT);
        RexNode s0 = this.relBuilder.call(FlinkSqlOperatorTable.CASE, leftLe, leftTimePoint, convLeftT);
        RexNode e0 = this.relBuilder.call(FlinkSqlOperatorTable.CASE, leftLe, convLeftT, leftTimePoint);
        RexNode convRightT = TypeCheckUtils.isTimeInterval(FlinkTypeFactory.toLogicalType(rightTemporal.getType())) ? this.relBuilder.call(FlinkSqlOperatorTable.DATETIME_PLUS, rightTimePoint, rightTemporal) : rightTemporal;
        RexNode rightLe = this.relBuilder.call(FlinkSqlOperatorTable.LESS_THAN_OR_EQUAL, rightTimePoint, convRightT);
        RexNode s1 = this.relBuilder.call(FlinkSqlOperatorTable.CASE, rightLe, rightTimePoint, convRightT);
        RexNode e1 = this.relBuilder.call(FlinkSqlOperatorTable.CASE, rightLe, convRightT, rightTimePoint);
        RexNode leftPred = this.relBuilder.call(FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL, e0, s1);
        RexNode rightPred = this.relBuilder.call(FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL, e1, s0);
        return this.relBuilder.call(FlinkSqlOperatorTable.AND, leftPred, rightPred);
    }

    private RexNode convertPlus(List<Expression> children) {
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        if (TypeCheckUtils.isCharacterString(FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType()))) {
            return this.relBuilder.call(FlinkSqlOperatorTable.CONCAT, childrenRexNode.get(0), this.relBuilder.cast(childrenRexNode.get(1), SqlTypeName.VARCHAR));
        }
        if (TypeCheckUtils.isCharacterString(FlinkTypeFactory.toLogicalType(childrenRexNode.get(1).getType()))) {
            return this.relBuilder.call(FlinkSqlOperatorTable.CONCAT, this.relBuilder.cast(childrenRexNode.get(0), SqlTypeName.VARCHAR), childrenRexNode.get(1));
        }
        if (TypeCheckUtils.isTimeInterval(FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType())) && childrenRexNode.get(0).getType() == childrenRexNode.get(1).getType()) {
            return this.relBuilder.call(FlinkSqlOperatorTable.PLUS, (Iterable<? extends RexNode>)childrenRexNode);
        }
        if (TypeCheckUtils.isTimeInterval(FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType())) && TypeCheckUtils.isTemporal(FlinkTypeFactory.toLogicalType(childrenRexNode.get(1).getType()))) {
            return this.relBuilder.call(FlinkSqlOperatorTable.DATETIME_PLUS, childrenRexNode.get(1), childrenRexNode.get(0));
        }
        if (TypeCheckUtils.isTemporal(FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType())) && TypeCheckUtils.isTemporal(FlinkTypeFactory.toLogicalType(childrenRexNode.get(1).getType()))) {
            return this.relBuilder.call(FlinkSqlOperatorTable.DATETIME_PLUS, (Iterable<? extends RexNode>)childrenRexNode);
        }
        return this.relBuilder.call(FlinkSqlOperatorTable.PLUS, (Iterable<? extends RexNode>)childrenRexNode);
    }

    private RexNode convertReplace(List<Expression> children) {
        Preconditions.checkArgument((children.size() == 2 || children.size() == 3 ? 1 : 0) != 0);
        List<RexNode> childrenRexNode = this.convertCallChildren(children);
        if (children.size() == 2) {
            return this.relBuilder.call((SqlOperator)FlinkSqlOperatorTable.REPLACE, childrenRexNode.get(0), childrenRexNode.get(1), this.relBuilder.call((SqlOperator)FlinkSqlOperatorTable.CHAR_LENGTH, childrenRexNode.get(0)));
        }
        return this.relBuilder.call((SqlOperator)FlinkSqlOperatorTable.REPLACE, (Iterable<? extends RexNode>)childrenRexNode);
    }

    private RexNode convertOver(List<Expression> children) {
        List<Expression> args = children;
        Expression agg = args.get(0);
        SqlAggFunction aggFunc = agg.accept(new SqlAggFunctionVisitor(this.typeFactory));
        RelDataType aggResultType = this.typeFactory.createFieldTypeFromLogicalType(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(((ResolvedExpression)agg).getOutputDataType()));
        List<RexNode> aggExprs = agg.getChildren().stream().map(expr -> expr.accept(this)).collect(Collectors.toList());
        Expression orderKeyExpr = args.get(1);
        HashSet<SqlKind> kinds = new HashSet<SqlKind>();
        RexNode collationRexNode = this.createCollation(orderKeyExpr.accept(this), RelFieldCollation.Direction.ASCENDING, null, kinds);
        ImmutableList<RexFieldCollation> orderKey = ImmutableList.of(new RexFieldCollation(collationRexNode, (Set<SqlKind>)kinds));
        List<RexNode> partitionKeys = args.subList(4, args.size()).stream().map(expr -> expr.accept(this)).collect(Collectors.toList());
        Expression preceding = args.get(2);
        boolean isPhysical = LogicalTypeChecks.hasRoot(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(((ResolvedExpression)preceding).getOutputDataType()), LogicalTypeRoot.BIGINT);
        Expression following = args.get(3);
        RexWindowBound lowerBound = this.createBound(preceding, SqlKind.PRECEDING);
        RexWindowBound upperBound = this.createBound(following, SqlKind.FOLLOWING);
        return this.relBuilder.getRexBuilder().makeOver(aggResultType, aggFunc, aggExprs, partitionKeys, orderKey, lowerBound, upperBound, isPhysical, true, false, false);
    }

    private RexNode convertAs(List<Expression> children) {
        String name = RexNodeConverter.extractValue((ValueLiteralExpression)children.get(1), String.class);
        RexNode child = children.get(0).accept(this);
        return this.relBuilder.alias(child, name);
    }

    private RexNode convertTrim(List<Expression> children) {
        SqlTrimFunction.Flag trimMode2;
        ValueLiteralExpression removeLeadingExpr = (ValueLiteralExpression)children.get(0);
        Boolean removeLeading = RexNodeConverter.extractValue(removeLeadingExpr, Boolean.class);
        ValueLiteralExpression removeTrailingExpr = (ValueLiteralExpression)children.get(1);
        Boolean removeTrailing = RexNodeConverter.extractValue(removeTrailingExpr, Boolean.class);
        RexNode trimString = children.get(2).accept(this);
        RexNode str = children.get(3).accept(this);
        if (removeLeading.booleanValue() && removeTrailing.booleanValue()) {
            trimMode2 = SqlTrimFunction.Flag.BOTH;
        } else if (removeLeading.booleanValue()) {
            trimMode2 = SqlTrimFunction.Flag.LEADING;
        } else if (removeTrailing.booleanValue()) {
            trimMode2 = SqlTrimFunction.Flag.TRAILING;
        } else {
            throw new IllegalArgumentException("Unsupported trim mode.");
        }
        return this.relBuilder.call((SqlOperator)FlinkSqlOperatorTable.TRIM, this.relBuilder.getRexBuilder().makeFlag(trimMode2), trimString, str);
    }

    private RexNode convertGet(List<Expression> children) {
        RexNode child = children.get(0).accept(this);
        ValueLiteralExpression keyLiteral = (ValueLiteralExpression)children.get(1);
        Optional<Integer> indexOptional = ExpressionUtils.extractValue(keyLiteral, String.class).map(child.getType().getFieldNames()::indexOf);
        int index = indexOptional.isPresent() ? indexOptional.get().intValue() : RexNodeConverter.extractValue(keyLiteral, Integer.class).intValue();
        return this.relBuilder.getRexBuilder().makeFieldAccess(child, index);
    }

    private RexNode convertIn(List<Expression> children) {
        Expression headExpr = children.get(1);
        if (headExpr instanceof TableReferenceExpression) {
            QueryOperation tableOperation = ((TableReferenceExpression)headExpr).getQueryOperation();
            RexNode child = children.get(0).accept(this);
            return RexSubQuery.in(((FlinkRelBuilder)this.relBuilder).queryOperation(tableOperation).build(), ImmutableList.of(child));
        }
        List<RexNode> child = this.convertCallChildren(children);
        return this.relBuilder.call(FlinkSqlOperatorTable.IN, (Iterable<? extends RexNode>)child);
    }

    private RexNode convertReinterpretCast(List<Expression> children) {
        RexNode child = children.get(0).accept(this);
        TypeLiteralExpression type = (TypeLiteralExpression)children.get(1);
        RexNode checkOverflow = children.get(2).accept(this);
        return this.relBuilder.getRexBuilder().makeReinterpretCast(this.typeFactory.createFieldTypeFromLogicalType(type.getOutputDataType().getLogicalType().copy(child.getType().isNullable())), child, checkOverflow);
    }

    private RexNode convertCast(List<Expression> children) {
        RexNode child = children.get(0).accept(this);
        TypeLiteralExpression type = (TypeLiteralExpression)children.get(1);
        return this.relBuilder.getRexBuilder().makeAbstractCast(this.typeFactory.createFieldTypeFromLogicalType(type.getOutputDataType().getLogicalType().copy(child.getType().isNullable())), child);
    }

    @Override
    public RexNode visit(ValueLiteralExpression valueLiteral) {
        LogicalType type = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(valueLiteral.getOutputDataType());
        RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)this.relBuilder.getTypeFactory();
        if (valueLiteral.isNull()) {
            return this.relBuilder.getRexBuilder().makeCast(typeFactory.createFieldTypeFromLogicalType(type), this.relBuilder.getRexBuilder().constantNull());
        }
        switch (type.getTypeRoot()) {
            case DECIMAL: {
                DecimalType dt = (DecimalType)type;
                BigDecimal bigDecimal = RexNodeConverter.extractValue(valueLiteral, BigDecimal.class);
                RelDataType decType = this.relBuilder.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, dt.getPrecision(), dt.getScale());
                return this.relBuilder.getRexBuilder().makeExactLiteral(bigDecimal, decType);
            }
            case BIGINT: {
                BigDecimal bigint = RexNodeConverter.extractValue(valueLiteral, BigDecimal.class);
                return this.relBuilder.getRexBuilder().makeBigintLiteral(bigint);
            }
            case FLOAT: {
                return this.relBuilder.getRexBuilder().makeApproxLiteral(RexNodeConverter.extractValue(valueLiteral, BigDecimal.class), this.relBuilder.getTypeFactory().createSqlType(SqlTypeName.FLOAT));
            }
            case DOUBLE: {
                return rexBuilder.makeApproxLiteral(RexNodeConverter.extractValue(valueLiteral, BigDecimal.class), this.relBuilder.getTypeFactory().createSqlType(SqlTypeName.DOUBLE));
            }
            case DATE: {
                return this.relBuilder.getRexBuilder().makeDateLiteral(DateString.fromCalendarFields(RexNodeConverter.valueAsCalendar(RexNodeConverter.extractValue(valueLiteral, java.sql.Date.class))));
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return this.relBuilder.getRexBuilder().makeTimeLiteral(TimeString.fromCalendarFields(RexNodeConverter.valueAsCalendar(RexNodeConverter.extractValue(valueLiteral, Time.class))), 0);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return this.relBuilder.getRexBuilder().makeTimestampLiteral(TimestampString.fromCalendarFields(RexNodeConverter.valueAsCalendar(RexNodeConverter.extractValue(valueLiteral, Timestamp.class))), 3);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                TimeZone timeZone = TimeZone.getTimeZone(((FlinkContext)((FlinkRelBuilder)this.relBuilder).getCluster().getPlanner().getContext()).getTableConfig().getLocalTimeZone());
                return this.relBuilder.getRexBuilder().makeTimestampWithLocalTimeZoneLiteral(new TimestampWithTimeZoneString(TimestampString.fromMillisSinceEpoch(RexNodeConverter.extractValue(valueLiteral, Instant.class).toEpochMilli()), timeZone).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString(), 3);
            }
            case INTERVAL_YEAR_MONTH: {
                return this.relBuilder.getRexBuilder().makeIntervalLiteral(BigDecimal.valueOf(RexNodeConverter.extractValue(valueLiteral, Integer.class).intValue()), new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO));
            }
            case INTERVAL_DAY_TIME: {
                return this.relBuilder.getRexBuilder().makeIntervalLiteral(BigDecimal.valueOf(RexNodeConverter.extractValue(valueLiteral, Long.class)), new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO));
            }
        }
        Object object = RexNodeConverter.extractValue(valueLiteral, Object.class);
        if (object instanceof TimePointUnit) {
            TimeUnit value;
            switch ((TimePointUnit)object) {
                case YEAR: {
                    value = TimeUnit.YEAR;
                    break;
                }
                case MONTH: {
                    value = TimeUnit.MONTH;
                    break;
                }
                case DAY: {
                    value = TimeUnit.DAY;
                    break;
                }
                case HOUR: {
                    value = TimeUnit.HOUR;
                    break;
                }
                case MINUTE: {
                    value = TimeUnit.MINUTE;
                    break;
                }
                case SECOND: {
                    value = TimeUnit.SECOND;
                    break;
                }
                case QUARTER: {
                    value = TimeUnit.QUARTER;
                    break;
                }
                case WEEK: {
                    value = TimeUnit.WEEK;
                    break;
                }
                case MILLISECOND: {
                    value = TimeUnit.MILLISECOND;
                    break;
                }
                case MICROSECOND: {
                    value = TimeUnit.MICROSECOND;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return this.relBuilder.getRexBuilder().makeFlag(value);
        }
        if (object instanceof TimeIntervalUnit) {
            TimeUnitRange value;
            switch ((TimeIntervalUnit)object) {
                case YEAR: {
                    value = TimeUnitRange.YEAR;
                    break;
                }
                case YEAR_TO_MONTH: {
                    value = TimeUnitRange.YEAR_TO_MONTH;
                    break;
                }
                case QUARTER: {
                    value = TimeUnitRange.QUARTER;
                    break;
                }
                case MONTH: {
                    value = TimeUnitRange.MONTH;
                    break;
                }
                case WEEK: {
                    value = TimeUnitRange.WEEK;
                    break;
                }
                case DAY: {
                    value = TimeUnitRange.DAY;
                    break;
                }
                case DAY_TO_HOUR: {
                    value = TimeUnitRange.DAY_TO_HOUR;
                    break;
                }
                case DAY_TO_MINUTE: {
                    value = TimeUnitRange.DAY_TO_MINUTE;
                    break;
                }
                case DAY_TO_SECOND: {
                    value = TimeUnitRange.DAY_TO_SECOND;
                    break;
                }
                case HOUR: {
                    value = TimeUnitRange.HOUR;
                    break;
                }
                case SECOND: {
                    value = TimeUnitRange.SECOND;
                    break;
                }
                case HOUR_TO_MINUTE: {
                    value = TimeUnitRange.HOUR_TO_MINUTE;
                    break;
                }
                case HOUR_TO_SECOND: {
                    value = TimeUnitRange.HOUR_TO_SECOND;
                    break;
                }
                case MINUTE: {
                    value = TimeUnitRange.MINUTE;
                    break;
                }
                case MINUTE_TO_SECOND: {
                    value = TimeUnitRange.MINUTE_TO_SECOND;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return this.relBuilder.getRexBuilder().makeFlag(value);
        }
        return this.relBuilder.literal(RexNodeConverter.extractValue(valueLiteral, Object.class));
    }

    private static <T> T extractValue(ValueLiteralExpression literal, Class<T> clazz) {
        Optional<Object> possibleObject = literal.getValueAs(Object.class);
        if (!possibleObject.isPresent()) {
            throw new TableException("Invalid literal.");
        }
        Object object = possibleObject.get();
        if (clazz.equals(BigDecimal.class)) {
            Optional<BigDecimal> possibleDecimal = literal.getValueAs(BigDecimal.class);
            if (possibleDecimal.isPresent()) {
                return (T)possibleDecimal.get();
            }
            if (object instanceof Decimal) {
                return (T)((Decimal)object).toBigDecimal();
            }
        }
        return literal.getValueAs(clazz).orElseThrow(() -> new TableException("Unsupported literal class: " + clazz));
    }

    private static Calendar valueAsCalendar(Object value) {
        Date date = (Date)value;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    @Override
    public RexNode visit(FieldReferenceExpression fieldReference2) {
        return this.relBuilder.field(fieldReference2.getName());
    }

    @Override
    public RexNode visit(TypeLiteralExpression typeLiteral) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RexNode visit(Expression other) {
        if (other instanceof UnresolvedReferenceExpression) {
            return this.visitUnresolvedReferenceExpression((UnresolvedReferenceExpression)other);
        }
        if (other instanceof ResolvedAggInputReference) {
            return this.visitResolvedAggInputReference((ResolvedAggInputReference)other);
        }
        if (other instanceof ResolvedAggLocalReference) {
            return this.visitResolvedAggLocalReference((ResolvedAggLocalReference)other);
        }
        if (other instanceof ResolvedDistinctKeyReference) {
            return this.visitResolvedDistinctKeyReference((ResolvedDistinctKeyReference)other);
        }
        if (other instanceof UnresolvedCallExpression) {
            return this.visit((UnresolvedCallExpression)other);
        }
        if (other instanceof RexNodeExpression) {
            return ((RexNodeExpression)other).getRexNode();
        }
        throw new UnsupportedOperationException(other.getClass().getSimpleName() + ":" + other.toString());
    }

    private RexNode visitUnresolvedReferenceExpression(UnresolvedReferenceExpression field) {
        return this.relBuilder.field(field.getName());
    }

    private RexNode visitResolvedAggInputReference(ResolvedAggInputReference reference) {
        return new RexInputRef(reference.getIndex(), this.typeFactory.createFieldTypeFromLogicalType(reference.getResultType()));
    }

    private RexNode visitResolvedAggLocalReference(ResolvedAggLocalReference reference) {
        LogicalType type = reference.getResultType();
        return new RexAggLocalVariable(reference.getFieldTerm(), reference.getNullTerm(), this.typeFactory.createFieldTypeFromLogicalType(type), type);
    }

    private RexNode visitResolvedDistinctKeyReference(ResolvedDistinctKeyReference reference) {
        LogicalType type = reference.getResultType();
        return new RexDistinctKeyVariable(reference.getName(), this.typeFactory.createFieldTypeFromLogicalType(type), type);
    }

    private RexNode visit(UnresolvedCallExpression call) {
        FunctionDefinition func = call.getFunctionDefinition();
        switch (func.getKind()) {
            case SCALAR: {
                if (func instanceof ScalarFunctionDefinition) {
                    ScalarFunction scalaFunc = ((ScalarFunctionDefinition)func).getScalarFunction();
                    List<RexNode> child = this.convertCallChildren(call.getChildren());
                    SqlFunction sqlFunction = UserDefinedFunctionUtils.createScalarSqlFunction(scalaFunc.functionIdentifier(), scalaFunc.toString(), scalaFunc, this.typeFactory);
                    return this.relBuilder.call((SqlOperator)sqlFunction, (Iterable<? extends RexNode>)child);
                }
                FunctionDefinition def = call.getFunctionDefinition();
                if (this.conversionsOfBuiltInFunc.containsKey(def)) {
                    RexNodeConversion conversion = this.conversionsOfBuiltInFunc.get(def);
                    return conversion.convert(call);
                }
                throw new UnsupportedOperationException(def.toString());
            }
        }
        throw new UnsupportedOperationException();
    }

    private RexNode createCollation(RexNode node, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection, Set<SqlKind> kinds) {
        switch (node.getKind()) {
            case DESCENDING: {
                kinds.add(node.getKind());
                return this.createCollation(((RexCall)node).getOperands().get(0), RelFieldCollation.Direction.DESCENDING, nullDirection, kinds);
            }
            case NULLS_FIRST: {
                kinds.add(node.getKind());
                return this.createCollation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.FIRST, kinds);
            }
            case NULLS_LAST: {
                kinds.add(node.getKind());
                return this.createCollation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.LAST, kinds);
            }
        }
        if (nullDirection == null) {
            if (FlinkPlannerImpl.defaultNullCollation().last(direction.equals((Object)RelFieldCollation.Direction.DESCENDING))) {
                kinds.add(SqlKind.NULLS_LAST);
            } else {
                kinds.add(SqlKind.NULLS_FIRST);
            }
        }
        return node;
    }

    private RexWindowBound createBound(Expression bound, SqlKind sqlKind) {
        if (bound instanceof CallExpression) {
            CallExpression callExpr = (CallExpression)bound;
            FunctionDefinition func = callExpr.getFunctionDefinition();
            if (BuiltInFunctionDefinitions.UNBOUNDED_ROW.equals(func) || BuiltInFunctionDefinitions.UNBOUNDED_RANGE.equals(func)) {
                SqlNode unbounded = sqlKind.equals((Object)SqlKind.PRECEDING) ? SqlWindow.createUnboundedPreceding(SqlParserPos.ZERO) : SqlWindow.createUnboundedFollowing(SqlParserPos.ZERO);
                return RexWindowBound.create(unbounded, null);
            }
            if (BuiltInFunctionDefinitions.CURRENT_ROW.equals(func) || BuiltInFunctionDefinitions.CURRENT_RANGE.equals(func)) {
                SqlNode currentRow2 = SqlWindow.createCurrentRow(SqlParserPos.ZERO);
                return RexWindowBound.create(currentRow2, null);
            }
            throw new IllegalArgumentException("Unexpected expression: " + bound);
        }
        if (bound instanceof ValueLiteralExpression) {
            RelDataType returnType = this.typeFactory.createFieldTypeFromLogicalType(new DecimalType(true, 19, 0));
            SqlPostfixOperator sqlOperator = new SqlPostfixOperator(sqlKind.name(), sqlKind, 2, new OrdinalReturnTypeInference(0), null, null);
            SqlNode[] operands = new SqlNode[]{SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO)};
            SqlBasicCall node = new SqlBasicCall(sqlOperator, operands, SqlParserPos.ZERO);
            ValueLiteralExpression literalExpr2 = (ValueLiteralExpression)bound;
            RexNode literalRexNode = literalExpr2.getValueAs(Double.class).map(v -> this.relBuilder.literal(BigDecimal.valueOf(v))).orElse(this.relBuilder.literal(RexNodeConverter.extractValue(literalExpr2, Object.class)));
            ArrayList<RexNode> expressions = new ArrayList<RexNode>();
            expressions.add(literalRexNode);
            RexNode rexNode = this.relBuilder.getRexBuilder().makeCall(returnType, sqlOperator, expressions);
            return RexWindowBound.create(node, rexNode);
        }
        throw new TableException("Unexpected expression: " + bound);
    }

    private static interface RexNodeConversion {
        public RexNode convert(List<Expression> var1);

        default public RexNode convert(CallExpression expression2) {
            return this.convert(expression2.getChildren());
        }

        default public RexNode convert(UnresolvedCallExpression unresolvedCallExpression) {
            return this.convert(unresolvedCallExpression.getChildren());
        }
    }
}

