/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.Collections;
import java.util.List;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

public class ResolvedDistinctKeyReference
implements Expression {
    private final String name;
    private final LogicalType resultType;

    public ResolvedDistinctKeyReference(String name, LogicalType resultType2) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.resultType = resultType2;
    }

    public String getName() {
        return this.name;
    }

    public LogicalType getResultType() {
        return this.resultType;
    }

    @Override
    public String asSummaryString() {
        return this.name;
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedDistinctKeyReference that = (ResolvedDistinctKeyReference)o;
        return this.name.equals(that.name) && this.resultType.equals(that.resultType);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.resultType.hashCode();
        return result;
    }

    public String toString() {
        return this.asSummaryString();
    }
}

