/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.planner.catalog.CatalogCalciteSchema;
import org.apache.flink.table.planner.catalog.FlinkSchema;

@Internal
public class CatalogManagerCalciteSchema
extends FlinkSchema {
    private final CatalogManager catalogManager;
    private final boolean isStreamingMode;

    public CatalogManagerCalciteSchema(CatalogManager catalogManager, boolean isStreamingMode) {
        this.catalogManager = catalogManager;
        this.isStreamingMode = isStreamingMode;
    }

    @Override
    public Table getTable(String name) {
        return null;
    }

    @Override
    public Set<String> getTableNames() {
        return Collections.emptySet();
    }

    @Override
    public Schema getSubSchema(String name) {
        Schema schema = this.catalogManager.getCatalog(name).map(catalog -> new CatalogCalciteSchema(name, (Catalog)catalog, this.isStreamingMode)).orElse(null);
        if (schema == null && this.catalogManager.getExternalCatalog(name).isPresent()) {
            throw new TableException("ExternalCatalog is deprecated and is not supported in blink planner");
        }
        return schema;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return new HashSet<String>(this.catalogManager.getCatalogs());
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return null;
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

