/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.ValueDataTypeConverter;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class ValueLiteralExpression
implements ResolvedExpression {
    @Nullable
    private final Object value;
    private final DataType dataType;

    public ValueLiteralExpression(Object value) {
        this(value, ValueLiteralExpression.deriveDataTypeFromValue(value));
    }

    public ValueLiteralExpression(Object value, DataType dataType2) {
        ValueLiteralExpression.validateValueDataType(value, (DataType)Preconditions.checkNotNull((Object)dataType2, (String)"Data type must not be null."));
        this.value = value;
        this.dataType = dataType2;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public <T> Optional<T> getValueAs(Class<T> clazz) {
        if (this.value == null) {
            return Optional.empty();
        }
        Class<?> valueClass = this.value.getClass();
        Serializable convertedValue = null;
        if (clazz.isInstance(this.value)) {
            convertedValue = (Serializable)clazz.cast(this.value);
        } else if (valueClass == Integer.class && clazz == Long.class) {
            Integer integer = (Integer)this.value;
            convertedValue = integer.longValue();
        } else if (valueClass == Duration.class && clazz == Long.class) {
            Duration duration = (Duration)this.value;
            convertedValue = duration.toMillis();
        } else if (valueClass == Long.class && clazz == Duration.class) {
            Long longVal = (Long)this.value;
            convertedValue = Duration.ofMillis(longVal);
        } else if (valueClass == Period.class && clazz == Integer.class) {
            Period period = (Period)this.value;
            convertedValue = period.toTotalMonths();
        } else if (valueClass == Integer.class && clazz == Period.class) {
            Integer integer = (Integer)this.value;
            convertedValue = Period.ofMonths(integer);
        } else if (valueClass == Date.class && clazz == LocalDate.class) {
            Date date = (Date)this.value;
            convertedValue = date.toLocalDate();
        } else if (valueClass == Time.class && clazz == LocalTime.class) {
            Time time = (Time)this.value;
            convertedValue = time.toLocalTime();
        } else if (valueClass == Timestamp.class && clazz == LocalDateTime.class) {
            Timestamp timestamp = (Timestamp)this.value;
            convertedValue = timestamp.toLocalDateTime();
        } else if (valueClass == LocalDate.class && clazz == Date.class) {
            LocalDate date = (LocalDate)this.value;
            convertedValue = Date.valueOf(date);
        } else if (valueClass == LocalTime.class && clazz == Time.class) {
            LocalTime time = (LocalTime)this.value;
            convertedValue = Time.valueOf(time);
        } else if (valueClass == LocalDateTime.class && clazz == Timestamp.class) {
            LocalDateTime dateTime = (LocalDateTime)this.value;
            convertedValue = Timestamp.valueOf(dateTime);
        } else if (Number.class.isAssignableFrom(valueClass) && clazz == BigDecimal.class) {
            convertedValue = new BigDecimal(String.valueOf(this.value));
        }
        return Optional.ofNullable(convertedValue);
    }

    @Override
    public DataType getOutputDataType() {
        return this.dataType;
    }

    @Override
    public List<ResolvedExpression> getResolvedChildren() {
        return Collections.emptyList();
    }

    @Override
    public String asSummaryString() {
        return ValueLiteralExpression.stringifyValue(this.value);
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueLiteralExpression that = (ValueLiteralExpression)o;
        return Objects.equals(this.value, that.value) && this.dataType.equals(that.dataType);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.dataType);
    }

    public String toString() {
        return this.asSummaryString();
    }

    private static DataType deriveDataTypeFromValue(Object value) {
        return ValueDataTypeConverter.extractDataType(value).orElseThrow(() -> new ValidationException("Cannot derive a data type for value '" + value + "'. The data type must be specified explicitly."));
    }

    private static void validateValueDataType(Object value, DataType dataType2) {
        LogicalType logicalType = dataType2.getLogicalType();
        if (value == null) {
            if (!logicalType.isNullable()) {
                throw new ValidationException(String.format("Data type '%s' does not support null values.", dataType2));
            }
            return;
        }
        Class<?> candidate = value.getClass();
        if (!dataType2.getConversionClass().isAssignableFrom(candidate)) {
            throw new ValidationException(String.format("Data type '%s' with conversion class '%s' does not support a value literal of class '%s'.", dataType2, dataType2.getConversionClass().getName(), value.getClass().getName()));
        }
        if (!logicalType.supportsInputConversion(candidate)) {
            throw new ValidationException(String.format("Data type '%s' does not support a conversion from class '%s'.", dataType2, candidate.getName()));
        }
    }

    private static String stringifyValue(Object value) {
        if (value instanceof String[]) {
            String[] array = (String[])value;
            return Stream.of(array).map(ValueLiteralExpression::stringifyValue).collect(Collectors.joining(", ", "[", "]"));
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            return Stream.of(array).map(ValueLiteralExpression::stringifyValue).collect(Collectors.joining(", ", "[", "]"));
        }
        if (value instanceof String) {
            return "'" + ((String)value).replace("'", "''") + "'";
        }
        return EncodingUtils.objectToString(value);
    }
}

