/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.util.Arrays;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.util.StringUtils;

public abstract class ObjectArrayRow
implements BaseRow {
    private byte header;
    protected final Object[] fields;

    public ObjectArrayRow(int arity) {
        this.fields = new Object[arity];
    }

    @Override
    public int getArity() {
        return this.fields.length;
    }

    @Override
    public byte getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(byte header) {
        this.header = header;
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.fields[ordinal] == null;
    }

    @Override
    public void setNullAt(int ordinal) {
        this.fields[ordinal] = null;
    }

    @Override
    public void setDecimal(int i, Decimal value, int precision) {
        this.fields[i] = value;
    }

    @Override
    public BinaryString getString(int ordinal) {
        return (BinaryString)this.fields[ordinal];
    }

    @Override
    public byte[] getBinary(int ordinal) {
        return (byte[])this.fields[ordinal];
    }

    @Override
    public BaseArray getArray(int ordinal) {
        return (BaseArray)this.fields[ordinal];
    }

    @Override
    public BaseMap getMap(int ordinal) {
        return (BaseMap)this.fields[ordinal];
    }

    @Override
    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return (Decimal)this.fields[ordinal];
    }

    @Override
    public <T> BinaryGeneric<T> getGeneric(int ordinal) {
        return (BinaryGeneric)this.fields[ordinal];
    }

    @Override
    public BaseRow getRow(int ordinal, int numFields) {
        return (BaseRow)this.fields[ordinal];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (BaseRowUtil.isAccumulateMsg(this)) {
            sb.append("+");
        } else {
            sb.append("-");
        }
        sb.append("|");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(StringUtils.arrayAwareToString((Object)this.fields[i]));
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return 31 * Byte.hashCode(this.getHeader()) + Arrays.hashCode(this.fields);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ObjectArrayRow) {
            ObjectArrayRow other = (ObjectArrayRow)o;
            return this.header == other.header && Arrays.equals(this.fields, other.fields);
        }
        return false;
    }

    public boolean equalsWithoutHeader(BaseRow o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ObjectArrayRow)) {
            return false;
        }
        ObjectArrayRow row = (ObjectArrayRow)o;
        return Arrays.equals(this.fields, row.fields);
    }
}

