/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.dataformat.BinaryFormat;

public abstract class LazyBinaryFormat<T>
extends BinaryFormat {
    protected T javaObject;

    public LazyBinaryFormat() {
        this(null, -1, -1, null);
    }

    public LazyBinaryFormat(MemorySegment[] segments, int offset, int sizeInBytes, T javaObject) {
        super(segments, offset, sizeInBytes);
        this.javaObject = javaObject;
    }

    public LazyBinaryFormat(MemorySegment[] segments, int offset, int sizeInBytes) {
        this(segments, offset, sizeInBytes, null);
    }

    public LazyBinaryFormat(T javaObject) {
        this(null, -1, -1, javaObject);
    }

    public T getJavaObject() {
        return this.javaObject;
    }

    public void setJavaObject(T javaObject) {
        this.javaObject = javaObject;
    }

    @Override
    public MemorySegment[] getSegments() {
        this.ensureMaterialized();
        return this.segments;
    }

    @Override
    public int getOffset() {
        this.ensureMaterialized();
        return this.offset;
    }

    @Override
    public int getSizeInBytes() {
        this.ensureMaterialized();
        return this.sizeInBytes;
    }

    public void ensureMaterialized() {
        if (this.segments == null) {
            this.materialize();
        }
    }

    public abstract void materialize();

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof LazyBinaryFormat) {
            LazyBinaryFormat other = (LazyBinaryFormat)o;
            this.ensureMaterialized();
            other.ensureMaterialized();
            return this.binaryEquals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        this.ensureMaterialized();
        return super.hashCode();
    }
}

