/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.util.Preconditions;

public class GenericArray
implements BaseArray {
    private final Object arr;
    private final int numElements;
    private final boolean isPrimitiveArray;

    public GenericArray(Object arr, int numElements) {
        this(arr, numElements, GenericArray.isPrimitiveArray(arr));
    }

    public GenericArray(Object arr, int numElements, boolean isPrimitiveArray) {
        this.arr = arr;
        this.numElements = numElements;
        this.isPrimitiveArray = isPrimitiveArray;
    }

    private static boolean isPrimitiveArray(Object arr) {
        Preconditions.checkNotNull((Object)arr);
        Preconditions.checkArgument((boolean)arr.getClass().isArray());
        return arr.getClass().getComponentType().isPrimitive();
    }

    public boolean isPrimitiveArray() {
        return this.isPrimitiveArray;
    }

    public Object getArray() {
        return this.arr;
    }

    @Override
    public int numElements() {
        return this.numElements;
    }

    @Override
    public boolean isNullAt(int pos) {
        return !this.isPrimitiveArray && ((Object[])this.arr)[pos] == null;
    }

    @Override
    public void setNullAt(int pos) {
        Preconditions.checkState((!this.isPrimitiveArray ? 1 : 0) != 0, (Object)"Can't set null for primitive array");
        ((Object[])this.arr)[pos] = null;
    }

    @Override
    public void setNotNullAt(int pos) {
    }

    @Override
    public void setNullLong(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullInt(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullBoolean(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullByte(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullShort(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullFloat(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullDouble(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public boolean[] toBooleanArray() {
        return (boolean[])this.arr;
    }

    @Override
    public byte[] toByteArray() {
        return (byte[])this.arr;
    }

    @Override
    public short[] toShortArray() {
        return (short[])this.arr;
    }

    @Override
    public int[] toIntArray() {
        return (int[])this.arr;
    }

    @Override
    public long[] toLongArray() {
        return (long[])this.arr;
    }

    @Override
    public float[] toFloatArray() {
        return (float[])this.arr;
    }

    @Override
    public double[] toDoubleArray() {
        return (double[])this.arr;
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.isPrimitiveArray ? ((boolean[])this.arr)[pos] : (Boolean)this.getObject(pos);
    }

    @Override
    public byte getByte(int pos) {
        return this.isPrimitiveArray ? ((byte[])this.arr)[pos] : (Byte)this.getObject(pos);
    }

    @Override
    public short getShort(int pos) {
        return this.isPrimitiveArray ? ((short[])this.arr)[pos] : (Short)this.getObject(pos);
    }

    @Override
    public int getInt(int pos) {
        return this.isPrimitiveArray ? ((int[])this.arr)[pos] : (Integer)this.getObject(pos);
    }

    @Override
    public long getLong(int pos) {
        return this.isPrimitiveArray ? ((long[])this.arr)[pos] : (Long)this.getObject(pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.isPrimitiveArray ? ((float[])this.arr)[pos] : ((Float)this.getObject(pos)).floatValue();
    }

    @Override
    public double getDouble(int pos) {
        return this.isPrimitiveArray ? ((double[])this.arr)[pos] : (Double)this.getObject(pos);
    }

    @Override
    public byte[] getBinary(int pos) {
        return (byte[])this.getObject(pos);
    }

    @Override
    public BinaryString getString(int pos) {
        return (BinaryString)this.getObject(pos);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return (Decimal)this.getObject(pos);
    }

    @Override
    public <T> BinaryGeneric<T> getGeneric(int pos) {
        return (BinaryGeneric)this.getObject(pos);
    }

    @Override
    public BaseRow getRow(int pos, int numFields) {
        return (BaseRow)this.getObject(pos);
    }

    @Override
    public BaseArray getArray(int pos) {
        return (BaseArray)this.getObject(pos);
    }

    @Override
    public BaseMap getMap(int pos) {
        return (BaseMap)this.getObject(pos);
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        if (this.isPrimitiveArray) {
            ((boolean[])this.arr)[pos] = value;
        } else {
            this.setObject(pos, value);
        }
    }

    @Override
    public void setByte(int pos, byte value) {
        if (this.isPrimitiveArray) {
            ((byte[])this.arr)[pos] = value;
        } else {
            this.setObject(pos, value);
        }
    }

    @Override
    public void setShort(int pos, short value) {
        if (this.isPrimitiveArray) {
            ((short[])this.arr)[pos] = value;
        } else {
            this.setObject(pos, value);
        }
    }

    @Override
    public void setInt(int pos, int value) {
        if (this.isPrimitiveArray) {
            ((int[])this.arr)[pos] = value;
        } else {
            this.setObject(pos, value);
        }
    }

    @Override
    public void setLong(int pos, long value) {
        if (this.isPrimitiveArray) {
            ((long[])this.arr)[pos] = value;
        } else {
            this.setObject(pos, value);
        }
    }

    @Override
    public void setFloat(int pos, float value) {
        if (this.isPrimitiveArray) {
            ((float[])this.arr)[pos] = value;
        } else {
            this.setObject(pos, Float.valueOf(value));
        }
    }

    @Override
    public void setDouble(int pos, double value) {
        if (this.isPrimitiveArray) {
            ((double[])this.arr)[pos] = value;
        } else {
            this.setObject(pos, value);
        }
    }

    @Override
    public void setDecimal(int pos, Decimal value, int precision) {
        this.setObject(pos, value);
    }

    public Object getObject(int pos) {
        return ((Object[])this.arr)[pos];
    }

    public void setObject(int pos, Object value) {
        ((Object[])this.arr)[pos] = value;
    }
}

