/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryFormat;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.BinaryWriter;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.runtime.typeutils.BaseArraySerializer;
import org.apache.flink.table.runtime.typeutils.BaseMapSerializer;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.runtime.util.SegmentsUtil;

public abstract class AbstractBinaryWriter
implements BinaryWriter {
    protected MemorySegment segment;
    protected int cursor;
    protected DataOutputViewStreamWrapper outputView;

    protected abstract void setOffsetAndSize(int var1, int var2, long var3);

    protected abstract int getFieldOffset(int var1);

    protected abstract void afterGrow();

    protected abstract void setNullBit(int var1);

    @Override
    public void writeString(int pos, BinaryString input) {
        if (input.getSegments() == null) {
            String javaObject = (String)input.getJavaObject();
            this.writeBytes(pos, javaObject.getBytes());
        } else {
            int len = input.getSizeInBytes();
            if (len <= 7) {
                byte[] bytes = SegmentsUtil.allocateReuseBytes(len);
                SegmentsUtil.copyToBytes(input.getSegments(), input.getOffset(), bytes, 0, len);
                AbstractBinaryWriter.writeBytesToFixLenPart(this.segment, this.getFieldOffset(pos), bytes, len);
            } else {
                this.writeSegmentsToVarLenPart(pos, input.getSegments(), input.getOffset(), len);
            }
        }
    }

    private void writeBytes(int pos, byte[] bytes) {
        int len = bytes.length;
        if (len <= 7) {
            AbstractBinaryWriter.writeBytesToFixLenPart(this.segment, this.getFieldOffset(pos), bytes, len);
        } else {
            this.writeBytesToVarLenPart(pos, bytes, len);
        }
    }

    @Override
    public void writeArray(int pos, BaseArray input, BaseArraySerializer serializer) {
        BinaryArray binary = serializer.toBinaryArray(input);
        this.writeSegmentsToVarLenPart(pos, binary.getSegments(), binary.getOffset(), binary.getSizeInBytes());
    }

    @Override
    public void writeMap(int pos, BaseMap input, BaseMapSerializer serializer) {
        BinaryMap binary = serializer.toBinaryMap(input);
        this.writeSegmentsToVarLenPart(pos, binary.getSegments(), binary.getOffset(), binary.getSizeInBytes());
    }

    private DataOutputViewStreamWrapper getOutputView() {
        if (this.outputView == null) {
            this.outputView = new DataOutputViewStreamWrapper((OutputStream)new BinaryRowWriterOutputView());
        }
        return this.outputView;
    }

    @Override
    public void writeGeneric(int pos, BinaryGeneric input) {
        if (input.getSegments() == null) {
            int beforeCursor = this.cursor;
            try {
                input.getJavaObjectSerializer().serialize(input.getJavaObject(), (DataOutputView)this.getOutputView());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int size = this.cursor - beforeCursor;
            int roundedSize = AbstractBinaryWriter.roundNumberOfBytesToNearestWord(size);
            int paddingBytes = roundedSize - size;
            this.ensureCapacity(paddingBytes);
            this.setOffsetAndSize(pos, beforeCursor, size);
            this.zeroBytes(this.cursor, paddingBytes);
            this.cursor += paddingBytes;
        } else {
            this.writeSegmentsToVarLenPart(pos, input.getSegments(), input.getOffset(), input.getSizeInBytes());
        }
    }

    @Override
    public void writeRow(int pos, BaseRow input, BaseRowSerializer serializer) {
        if (input instanceof BinaryFormat) {
            BinaryFormat row = (BinaryFormat)((Object)input);
            this.writeSegmentsToVarLenPart(pos, row.getSegments(), row.getOffset(), row.getSizeInBytes());
        } else {
            BinaryRow row = serializer.toBinaryRow(input);
            this.writeSegmentsToVarLenPart(pos, row.getSegments(), row.getOffset(), row.getSizeInBytes());
        }
    }

    @Override
    public void writeBinary(int pos, byte[] bytes) {
        int len = bytes.length;
        if (len <= 7) {
            AbstractBinaryWriter.writeBytesToFixLenPart(this.segment, this.getFieldOffset(pos), bytes, len);
        } else {
            this.writeBytesToVarLenPart(pos, bytes, len);
        }
    }

    @Override
    public void writeDecimal(int pos, Decimal value, int precision) {
        assert (value == null || value.getPrecision() == precision);
        if (Decimal.isCompact(precision)) {
            assert (value != null);
            this.writeLong(pos, value.toUnscaledLong());
        } else {
            this.ensureCapacity(16);
            this.segment.putLong(this.cursor, 0L);
            this.segment.putLong(this.cursor + 8, 0L);
            if (value == null) {
                this.setNullBit(pos);
                this.setOffsetAndSize(pos, this.cursor, 0L);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                this.segment.put(this.cursor, bytes, 0, bytes.length);
                this.setOffsetAndSize(pos, this.cursor, bytes.length);
            }
            this.cursor += 16;
        }
    }

    private void zeroBytes(int offset, int size) {
        for (int i = offset; i < offset + size; ++i) {
            this.segment.put(i, (byte)0);
        }
    }

    protected void zeroOutPaddingBytes(int numBytes) {
        if ((numBytes & 7) > 0) {
            this.segment.putLong(this.cursor + (numBytes >> 3 << 3), 0L);
        }
    }

    protected void ensureCapacity(int neededSize) {
        int length = this.cursor + neededSize;
        if (this.segment.size() < length) {
            this.grow(length);
        }
    }

    private void writeSegmentsToVarLenPart(int pos, MemorySegment[] segments, int offset, int size) {
        int roundedSize = AbstractBinaryWriter.roundNumberOfBytesToNearestWord(size);
        this.ensureCapacity(roundedSize);
        this.zeroOutPaddingBytes(size);
        if (segments.length == 1) {
            segments[0].copyTo(offset, this.segment, this.cursor, size);
        } else {
            this.writeMultiSegmentsToVarLenPart(segments, offset, size);
        }
        this.setOffsetAndSize(pos, this.cursor, size);
        this.cursor += roundedSize;
    }

    private void writeMultiSegmentsToVarLenPart(MemorySegment[] segments, int offset, int size) {
        int needCopy = size;
        int fromOffset = offset;
        int toOffset = this.cursor;
        for (MemorySegment sourceSegment : segments) {
            int remain = sourceSegment.size() - fromOffset;
            if (remain > 0) {
                int copySize = remain > needCopy ? needCopy : remain;
                sourceSegment.copyTo(fromOffset, this.segment, toOffset, copySize);
                needCopy -= copySize;
                toOffset += copySize;
                fromOffset = 0;
                continue;
            }
            fromOffset -= sourceSegment.size();
        }
    }

    private void writeBytesToVarLenPart(int pos, byte[] bytes, int len) {
        int roundedSize = AbstractBinaryWriter.roundNumberOfBytesToNearestWord(len);
        this.ensureCapacity(roundedSize);
        this.zeroOutPaddingBytes(len);
        this.segment.put(this.cursor, bytes, 0, len);
        this.setOffsetAndSize(pos, this.cursor, len);
        this.cursor += roundedSize;
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.segment.size();
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        this.segment = MemorySegmentFactory.wrap((byte[])Arrays.copyOf(this.segment.getArray(), newCapacity));
        this.afterGrow();
    }

    protected static int roundNumberOfBytesToNearestWord(int numBytes) {
        int remainder = numBytes & 7;
        if (remainder == 0) {
            return numBytes;
        }
        return numBytes + (8 - remainder);
    }

    private static void writeBytesToFixLenPart(MemorySegment segment, int fieldOffset, byte[] bytes, int len) {
        long firstByte = len | 0x80;
        long sevenBytes = 0L;
        if (BinaryRow.LITTLE_ENDIAN) {
            for (int i = 0; i < len; ++i) {
                sevenBytes |= (0xFFL & (long)bytes[i]) << (int)((long)i * 8L);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                sevenBytes |= (0xFFL & (long)bytes[i]) << (int)((long)(6 - i) * 8L);
            }
        }
        long offsetAndSize = firstByte << 56 | sevenBytes;
        segment.putLong(fieldOffset, offsetAndSize);
    }

    private class BinaryRowWriterOutputView
    extends OutputStream {
        private BinaryRowWriterOutputView() {
        }

        @Override
        public void write(int b) throws IOException {
            AbstractBinaryWriter.this.ensureCapacity(1);
            AbstractBinaryWriter.this.segment.put(AbstractBinaryWriter.this.cursor, (byte)b);
            ++AbstractBinaryWriter.this.cursor;
        }

        @Override
        public void write(byte[] b) throws IOException {
            AbstractBinaryWriter.this.ensureCapacity(b.length);
            AbstractBinaryWriter.this.segment.put(AbstractBinaryWriter.this.cursor, b, 0, b.length);
            AbstractBinaryWriter.this.cursor += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            AbstractBinaryWriter.this.ensureCapacity(len);
            AbstractBinaryWriter.this.segment.put(AbstractBinaryWriter.this.cursor, b, off, len);
            AbstractBinaryWriter.this.cursor += len;
        }

        public void write(MemorySegment seg, int off, int len) throws IOException {
            AbstractBinaryWriter.this.ensureCapacity(len);
            seg.copyTo(off, AbstractBinaryWriter.this.segment, AbstractBinaryWriter.this.cursor, len);
            AbstractBinaryWriter.this.cursor += len;
        }
    }
}

