/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlAbstractStringLiteral;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.BarfingInvocationHandler;
import org.apache.calcite.util.ConversionUtil;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.base.Predicates;
import org.apache.flink.calcite.shaded.com.google.common.base.Utf8;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterators;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;

public abstract class SqlUtil {
    static SqlNode andExpressions(SqlNode node1, SqlNode node2) {
        if (node1 == null) {
            return node2;
        }
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        if (node1.getKind() == SqlKind.AND) {
            list.addAll(((SqlCall)node1).getOperandList());
        } else {
            list.add(node1);
        }
        if (node2.getKind() == SqlKind.AND) {
            list.addAll(((SqlCall)node2).getOperandList());
        } else {
            list.add(node2);
        }
        return SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, list);
    }

    static ArrayList<SqlNode> flatten(SqlNode node) {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        SqlUtil.flatten(node, list);
        return list;
    }

    public static SqlNode getFromNode(SqlSelect query, int ordinal) {
        ArrayList<SqlNode> list = SqlUtil.flatten(query.getFrom());
        return list.get(ordinal);
    }

    private static void flatten(SqlNode node, ArrayList<SqlNode> list) {
        switch (node.getKind()) {
            case JOIN: {
                SqlJoin join = (SqlJoin)node;
                SqlUtil.flatten(join.getLeft(), list);
                SqlUtil.flatten(join.getRight(), list);
                return;
            }
            case AS: {
                SqlCall call = (SqlCall)node;
                SqlUtil.flatten(call.operand(0), list);
                return;
            }
        }
        list.add(node);
    }

    public static SqlNodeList toNodeList(SqlNode[] operands) {
        SqlNodeList ret = new SqlNodeList(SqlParserPos.ZERO);
        for (SqlNode node : operands) {
            ret.add(node);
        }
        return ret;
    }

    public static boolean isNullLiteral(SqlNode node, boolean allowCast) {
        SqlCall call;
        if (node instanceof SqlLiteral) {
            SqlLiteral literal = (SqlLiteral)node;
            if (literal.getTypeName() == SqlTypeName.NULL) {
                assert (null == literal.getValue());
                return true;
            }
            return false;
        }
        return allowCast && node.getKind() == SqlKind.CAST && SqlUtil.isNullLiteral((call = (SqlCall)node).operand(0), false);
    }

    public static boolean isNull(SqlNode node) {
        return SqlUtil.isNullLiteral(node, false) || node.getKind() == SqlKind.CAST && SqlUtil.isNull(((SqlCall)node).operand(0));
    }

    public static boolean isLiteral(SqlNode node, boolean allowCast) {
        SqlCall call;
        assert (node != null);
        if (node instanceof SqlLiteral) {
            return true;
        }
        return allowCast && node.getKind() == SqlKind.CAST && SqlUtil.isLiteral((call = (SqlCall)node).operand(0), false);
    }

    public static boolean isLiteral(SqlNode node) {
        return SqlUtil.isLiteral(node, false);
    }

    public static boolean isLiteralChain(SqlNode node) {
        assert (node != null);
        if (node instanceof SqlCall) {
            SqlCall call = (SqlCall)node;
            return call.getKind() == SqlKind.LITERAL_CHAIN;
        }
        return false;
    }

    public static void unparseFunctionSyntax(SqlOperator operator, SqlWriter writer, SqlCall call) {
        if (operator instanceof SqlFunction) {
            SqlIdentifier id;
            SqlFunction function = (SqlFunction)operator;
            if (function.getFunctionType().isSpecific()) {
                writer.keyword("SPECIFIC");
            }
            if ((id = function.getSqlIdentifier()) == null) {
                writer.keyword(operator.getName());
            } else {
                SqlUtil.unparseSqlIdentifierSyntax(writer, id, true);
            }
        } else {
            writer.print(operator.getName());
        }
        if (call.operandCount() == 0) {
            switch (call.getOperator().getSyntax()) {
                case FUNCTION_ID: {
                    return;
                }
            }
        }
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
        SqlLiteral quantifier = call.getFunctionQuantifier();
        if (quantifier != null) {
            quantifier.unparse(writer, 0, 0);
        }
        if (call.operandCount() == 0) {
            switch (call.getOperator().getSyntax()) {
                case FUNCTION_STAR: {
                    writer.sep("*");
                }
            }
        }
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, 0, 0);
        }
        writer.endList(frame);
    }

    public static void unparseSqlIdentifierSyntax(SqlWriter writer, SqlIdentifier identifier, boolean asFunctionID) {
        boolean isUnquotedSimple = identifier.isSimple() && !identifier.getParserPosition().isQuoted();
        SqlOperator operator = isUnquotedSimple ? SqlValidatorUtil.lookupSqlFunctionByID(SqlStdOperatorTable.instance(), identifier, null) : null;
        boolean unparsedAsFunc = false;
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.IDENTIFIER);
        if (isUnquotedSimple && operator != null && (asFunctionID || operator.getSyntax() == SqlSyntax.FUNCTION_ID)) {
            writer.keyword(identifier.getSimple());
            unparsedAsFunc = true;
        }
        if (!unparsedAsFunc) {
            for (int i = 0; i < identifier.names.size(); ++i) {
                writer.sep(".");
                String name = (String)identifier.names.get(i);
                SqlParserPos pos = identifier.getComponentParserPosition(i);
                if (name.equals("")) {
                    writer.print("*");
                    continue;
                }
                writer.identifier(name, pos.isQuoted());
            }
        }
        if (null != identifier.getCollation()) {
            identifier.getCollation().unparse(writer);
        }
        writer.endList(frame);
    }

    public static void unparseBinarySyntax(SqlOperator operator, SqlCall call, SqlWriter writer, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startList(operator instanceof SqlSetOperator ? SqlWriter.FrameTypeEnum.SETOP : SqlWriter.FrameTypeEnum.SIMPLE);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, operator.getLeftPrec());
        boolean needsSpace = operator.needsSpace();
        writer.setNeedWhitespace(needsSpace);
        writer.sep(operator.getName());
        writer.setNeedWhitespace(needsSpace);
        ((SqlNode)call.operand(1)).unparse(writer, operator.getRightPrec(), rightPrec);
        writer.endList(frame);
    }

    public static SqlLiteral concatenateLiterals(List<SqlLiteral> lits) {
        if (lits.size() == 1) {
            return lits.get(0);
        }
        return ((SqlAbstractStringLiteral)lits.get(0)).concat1(lits);
    }

    public static SqlOperator lookupRoutine(SqlOperatorTable opTab, SqlIdentifier funcName, List<RelDataType> argTypes, List<String> argNames, SqlFunctionCategory category, SqlSyntax syntax, SqlKind sqlKind, SqlNameMatcher nameMatcher) {
        Iterator<SqlOperator> list = SqlUtil.lookupSubjectRoutines(opTab, funcName, argTypes, argNames, syntax, sqlKind, category, nameMatcher);
        if (list.hasNext()) {
            return list.next();
        }
        return null;
    }

    private static Iterator<SqlOperator> filterOperatorRoutinesByKind(Iterator<SqlOperator> routines, SqlKind sqlKind) {
        return Iterators.filter(routines, operator -> Objects.requireNonNull(operator).getKind() == sqlKind);
    }

    public static Iterator<SqlOperator> lookupSubjectRoutines(SqlOperatorTable opTab, SqlIdentifier funcName, List<RelDataType> argTypes, List<String> argNames, SqlSyntax sqlSyntax, SqlKind sqlKind, SqlFunctionCategory category, SqlNameMatcher nameMatcher) {
        Iterator<SqlOperator> routines = SqlUtil.lookupSubjectRoutinesByName(opTab, funcName, sqlSyntax, category, nameMatcher);
        routines = SqlUtil.filterRoutinesByParameterCount(routines, argTypes);
        if (category == SqlFunctionCategory.USER_DEFINED_PROCEDURE) {
            return routines;
        }
        routines = SqlUtil.filterRoutinesByParameterType(sqlSyntax, routines, argTypes, argNames);
        ArrayList<SqlOperator> list = Lists.newArrayList(routines);
        routines = list.iterator();
        if (list.size() < 2) {
            return routines;
        }
        routines = SqlUtil.filterRoutinesByTypePrecedence(sqlSyntax, routines, argTypes);
        return SqlUtil.filterOperatorRoutinesByKind(routines, sqlKind);
    }

    public static boolean matchRoutinesByParameterCount(SqlOperatorTable opTab, SqlIdentifier funcName, List<RelDataType> argTypes, SqlFunctionCategory category, SqlNameMatcher nameMatcher) {
        Iterator<SqlOperator> routines = SqlUtil.lookupSubjectRoutinesByName(opTab, funcName, SqlSyntax.FUNCTION, category, nameMatcher);
        routines = SqlUtil.filterRoutinesByParameterCount(routines, argTypes);
        return routines.hasNext();
    }

    private static Iterator<SqlOperator> lookupSubjectRoutinesByName(SqlOperatorTable opTab, SqlIdentifier funcName, SqlSyntax syntax, SqlFunctionCategory category, SqlNameMatcher nameMatcher) {
        ArrayList<SqlOperator> sqlOperators = new ArrayList<SqlOperator>();
        opTab.lookupOperatorOverloads(funcName, category, syntax, sqlOperators, nameMatcher);
        switch (syntax) {
            case FUNCTION: {
                return Iterators.filter(sqlOperators.iterator(), Predicates.instanceOf(SqlFunction.class));
            }
        }
        return Iterators.filter(sqlOperators.iterator(), operator -> Objects.requireNonNull(operator).getSyntax() == syntax);
    }

    private static Iterator<SqlOperator> filterRoutinesByParameterCount(Iterator<SqlOperator> routines, List<RelDataType> argTypes) {
        return Iterators.filter(routines, operator -> Objects.requireNonNull(operator).getOperandCountRange().isValidCount(argTypes.size()));
    }

    private static Iterator<SqlOperator> filterRoutinesByParameterType(SqlSyntax syntax, Iterator<SqlOperator> routines, List<RelDataType> argTypes, List<String> argNames) {
        if (syntax != SqlSyntax.FUNCTION) {
            return routines;
        }
        return Iterators.filter(Iterators.filter(routines, SqlFunction.class), function -> {
            List<Object> permutedArgTypes;
            List<RelDataType> paramTypes = Objects.requireNonNull(function).getParamTypes();
            if (paramTypes == null) {
                return true;
            }
            if (argNames != null) {
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                for (Ord argName : Ord.zip(argNames)) {
                    int i = function.getParamNames().indexOf(argName.e);
                    if (i < 0) {
                        return false;
                    }
                    map.put(i, argName.i);
                }
                permutedArgTypes = Functions.generate(paramTypes.size(), a0 -> {
                    if (map.containsKey(a0)) {
                        return (RelDataType)argTypes.get((Integer)map.get(a0));
                    }
                    return null;
                });
            } else {
                permutedArgTypes = Lists.newArrayList(argTypes);
                while (permutedArgTypes.size() < argTypes.size()) {
                    paramTypes.add(null);
                }
            }
            for (Pair p : Pair.zip(paramTypes, permutedArgTypes)) {
                RelDataType argType = (RelDataType)p.right;
                RelDataType paramType = (RelDataType)p.left;
                if (argType == null || SqlTypeUtil.canCastFrom(paramType, argType, false)) continue;
                return false;
            }
            return true;
        });
    }

    private static Iterator<SqlOperator> filterRoutinesByTypePrecedence(SqlSyntax sqlSyntax, Iterator<SqlOperator> routines, List<RelDataType> argTypes) {
        if (sqlSyntax != SqlSyntax.FUNCTION) {
            return routines;
        }
        List<SqlFunction> sqlFunctions = Lists.newArrayList(Iterators.filter(routines, SqlFunction.class));
        for (Ord<RelDataType> argType : Ord.zip(argTypes)) {
            RelDataTypePrecedenceList precList = ((RelDataType)argType.e).getPrecedenceList();
            RelDataType bestMatch = SqlUtil.bestMatch(sqlFunctions, argType.i, precList);
            if (bestMatch == null) continue;
            sqlFunctions = sqlFunctions.stream().filter(function -> {
                List<RelDataType> paramTypes = function.getParamTypes();
                if (paramTypes == null) {
                    return false;
                }
                RelDataType paramType = paramTypes.get(argType.i);
                return precList.compareTypePrecedence(paramType, bestMatch) >= 0;
            }).collect(Collectors.toList());
        }
        return sqlFunctions.iterator();
    }

    private static RelDataType bestMatch(List<SqlFunction> sqlFunctions, int i, RelDataTypePrecedenceList precList) {
        RelDataType bestMatch = null;
        for (SqlFunction function : sqlFunctions) {
            List<RelDataType> paramTypes = function.getParamTypes();
            if (paramTypes == null) continue;
            RelDataType paramType = paramTypes.get(i);
            if (bestMatch == null) {
                bestMatch = paramType;
                continue;
            }
            int c = precList.compareTypePrecedence(bestMatch, paramType);
            if (c >= 0) continue;
            bestMatch = paramType;
        }
        return bestMatch;
    }

    public static SqlNode getSelectListItem(SqlNode query, int i) {
        switch (query.getKind()) {
            case SELECT: {
                SqlSelect select = (SqlSelect)query;
                SqlNode from = SqlUtil.stripAs(select.getFrom());
                if (from != null && from.getKind() == SqlKind.VALUES) {
                    return SqlUtil.getSelectListItem(from, i);
                }
                SqlNodeList fields2 = select.getSelectList();
                if (i >= fields2.size()) {
                    i = 0;
                }
                return fields2.get(i);
            }
            case VALUES: {
                SqlCall call = (SqlCall)query;
                assert (call.operandCount() > 0) : "VALUES must have at least one operand";
                SqlCall row = (SqlCall)call.operand(0);
                assert (row.operandCount() > i) : "VALUES has too few columns";
                return row.operand(i);
            }
        }
        throw Util.needToImplement(query);
    }

    public static String deriveAliasFromOrdinal(int ordinal) {
        return "EXPR$" + ordinal;
    }

    public static String getOperatorSignature(SqlOperator op, List<?> typeList) {
        return SqlUtil.getAliasedSignature(op, op.getName(), typeList);
    }

    public static String getAliasedSignature(SqlOperator op, String opName, List<?> typeList) {
        StringBuilder ret = new StringBuilder();
        String template = op.getSignatureTemplate(typeList.size());
        if (null == template) {
            ret.append("'");
            ret.append(opName);
            ret.append("(");
            for (int i = 0; i < typeList.size(); ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                String t = typeList.get(i).toString().toUpperCase(Locale.ROOT);
                ret.append("<").append(t).append(">");
            }
            ret.append(")'");
        } else {
            Object[] values = new Object[typeList.size() + 1];
            values[0] = opName;
            ret.append("'");
            for (int i = 0; i < typeList.size(); ++i) {
                String t = typeList.get(i).toString().toUpperCase(Locale.ROOT);
                values[i + 1] = "<" + t + ">";
            }
            ret.append(new MessageFormat(template, Locale.ROOT).format(values));
            ret.append("'");
            assert (typeList.size() + 1 == values.length);
        }
        return ret.toString();
    }

    public static CalciteException newContextException(SqlParserPos pos, Resources.ExInst<?> e, String inputText) {
        CalciteContextException ex = SqlUtil.newContextException(pos, e);
        ex.setOriginalStatement(inputText);
        return ex;
    }

    public static CalciteContextException newContextException(SqlParserPos pos, Resources.ExInst<?> e) {
        int line = pos.getLineNum();
        int col = pos.getColumnNum();
        int endLine = pos.getEndLineNum();
        int endCol = pos.getEndColumnNum();
        return SqlUtil.newContextException(line, col, endLine, endCol, e);
    }

    public static CalciteContextException newContextException(int line, int col, int endLine, int endCol, Resources.ExInst<?> e) {
        CalciteContextException contextExcn = (line == endLine && col == endCol ? Static.RESOURCE.validatorContextPoint(line, col) : Static.RESOURCE.validatorContext(line, col, endLine, endCol)).ex((Throwable)e.ex());
        contextExcn.setPosition(line, col, endLine, endCol);
        return contextExcn;
    }

    public static boolean isCallTo(SqlNode node, SqlOperator operator) {
        return node instanceof SqlCall && ((SqlCall)node).getOperator() == operator;
    }

    public static RelDataType createNlsStringType(RelDataTypeFactory typeFactory, NlsString str) {
        SqlCollation collation;
        Charset charset = str.getCharset();
        if (null == charset) {
            charset = typeFactory.getDefaultCharset();
        }
        if (null == (collation = str.getCollation())) {
            collation = SqlCollation.COERCIBLE;
        }
        RelDataType type = typeFactory.createSqlType(SqlTypeName.CHAR, str.getValue().length());
        type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
        return type;
    }

    public static String translateCharacterSetName(String name) {
        switch (name) {
            case "BIG5": {
                return "Big5";
            }
            case "LATIN1": {
                return "ISO-8859-1";
            }
            case "GB2312": 
            case "GBK": {
                return name;
            }
            case "UTF8": {
                return "UTF-8";
            }
            case "UTF16": {
                return ConversionUtil.NATIVE_UTF16_CHARSET_NAME;
            }
            case "UTF-16BE": 
            case "UTF-16LE": 
            case "ISO-8859-1": 
            case "UTF-8": {
                return name;
            }
        }
        return null;
    }

    public static Charset getCharset(String charsetName) {
        assert (charsetName != null);
        String javaCharsetName = SqlUtil.translateCharacterSetName(charsetName = charsetName.toUpperCase(Locale.ROOT));
        if (javaCharsetName == null) {
            throw new UnsupportedCharsetException(charsetName);
        }
        return Charset.forName(javaCharsetName);
    }

    public static void validateCharset(ByteString value, Charset charset) {
        byte[] bytes;
        if (charset == StandardCharsets.UTF_8 && !Utf8.isWellFormed(bytes = value.getBytes())) {
            String string = new String(bytes, charset);
            throw Static.RESOURCE.charsetEncoding(string, charset.name()).ex();
        }
    }

    public static SqlNode stripAs(SqlNode node) {
        if (node != null && node.getKind() == SqlKind.AS) {
            return ((SqlCall)node).operand(0);
        }
        return node;
    }

    public static ImmutableList<SqlNode> getAncestry(SqlNode root, Predicate<SqlNode> predicate, Predicate<SqlNode> postPredicate) {
        try {
            new Genealogist(predicate, postPredicate).visitChild(root);
            throw new AssertionError((Object)("not found: " + predicate + " in " + root));
        }
        catch (Util.FoundOne e) {
            return (ImmutableList)e.getNode();
        }
    }

    private static class Genealogist
    extends SqlBasicVisitor<Void> {
        private final List<SqlNode> ancestors = new ArrayList<SqlNode>();
        private final Predicate<SqlNode> predicate;
        private final Predicate<SqlNode> postPredicate;

        Genealogist(Predicate<SqlNode> predicate, Predicate<SqlNode> postPredicate) {
            this.predicate = predicate;
            this.postPredicate = postPredicate;
        }

        private Void check(SqlNode node) {
            this.preCheck(node);
            this.postCheck(node);
            return null;
        }

        private Void preCheck(SqlNode node) {
            if (this.predicate.test(node)) {
                throw new Util.FoundOne(ImmutableList.copyOf(this.ancestors));
            }
            return null;
        }

        private Void postCheck(SqlNode node) {
            if (this.postPredicate.test(node)) {
                throw new Util.FoundOne(ImmutableList.copyOf(this.ancestors));
            }
            return null;
        }

        private void visitChild(SqlNode node) {
            if (node == null) {
                return;
            }
            this.ancestors.add(node);
            node.accept(this);
            this.ancestors.remove(this.ancestors.size() - 1);
        }

        @Override
        public Void visit(SqlIdentifier id) {
            return this.check(id);
        }

        @Override
        public Void visit(SqlCall call) {
            this.preCheck(call);
            for (SqlNode node : call.getOperandList()) {
                this.visitChild(node);
            }
            return this.postCheck(call);
        }

        @Override
        public Void visit(SqlIntervalQualifier intervalQualifier) {
            return this.check(intervalQualifier);
        }

        @Override
        public Void visit(SqlLiteral literal) {
            return this.check(literal);
        }

        @Override
        public Void visit(SqlNodeList nodeList) {
            this.preCheck(nodeList);
            for (SqlNode node : nodeList) {
                this.visitChild(node);
            }
            return this.postCheck(nodeList);
        }

        @Override
        public Void visit(SqlDynamicParam param) {
            return this.check(param);
        }

        @Override
        public Void visit(SqlDataTypeSpec type) {
            return this.check(type);
        }
    }

    public static class DatabaseMetaDataInvocationHandler
    extends BarfingInvocationHandler {
        private final String databaseProductName;
        private final String identifierQuoteString;

        public DatabaseMetaDataInvocationHandler(String databaseProductName, String identifierQuoteString) {
            this.databaseProductName = databaseProductName;
            this.identifierQuoteString = identifierQuoteString;
        }

        public String getDatabaseProductName() throws SQLException {
            return this.databaseProductName;
        }

        public String getIdentifierQuoteString() throws SQLException {
            return this.identifierQuoteString;
        }
    }
}

