/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractResponse;

public class ListGroupsResponse
extends AbstractResponse {
    public static final String ERROR_CODE_KEY_NAME = "error_code";
    public static final String GROUPS_KEY_NAME = "groups";
    public static final String GROUP_ID_KEY_NAME = "group_id";
    public static final String PROTOCOL_TYPE_KEY_NAME = "protocol_type";
    private final Errors error;
    private final int throttleTimeMs;
    private final List<Group> groups;

    public ListGroupsResponse(Errors error, List<Group> groups) {
        this(0, error, groups);
    }

    public ListGroupsResponse(int throttleTimeMs, Errors error, List<Group> groups) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.groups = groups;
    }

    public ListGroupsResponse(Struct struct) {
        this.throttleTimeMs = struct.hasField("throttle_time_ms") ? struct.getInt("throttle_time_ms") : 0;
        this.error = Errors.forCode(struct.getShort(ERROR_CODE_KEY_NAME));
        this.groups = new ArrayList<Group>();
        for (Object groupObj : struct.getArray(GROUPS_KEY_NAME)) {
            Struct groupStruct = (Struct)groupObj;
            String groupId = groupStruct.getString(GROUP_ID_KEY_NAME);
            String protocolType = groupStruct.getString(PROTOCOL_TYPE_KEY_NAME);
            this.groups.add(new Group(groupId, protocolType));
        }
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<Group> groups() {
        return this.groups;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.LIST_GROUPS.responseSchema(version));
        if (struct.hasField("throttle_time_ms")) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        struct.set(ERROR_CODE_KEY_NAME, (Object)this.error.code());
        ArrayList<Struct> groupList = new ArrayList<Struct>();
        for (Group group : this.groups) {
            Struct groupStruct = struct.instance(GROUPS_KEY_NAME);
            groupStruct.set(GROUP_ID_KEY_NAME, (Object)group.groupId);
            groupStruct.set(PROTOCOL_TYPE_KEY_NAME, (Object)group.protocolType);
            groupList.add(groupStruct);
        }
        struct.set(GROUPS_KEY_NAME, (Object)groupList.toArray());
        return struct;
    }

    public static ListGroupsResponse fromError(Errors error) {
        return ListGroupsResponse.fromError(0, error);
    }

    public static ListGroupsResponse fromError(int throttleTimeMs, Errors error) {
        return new ListGroupsResponse(throttleTimeMs, error, Collections.emptyList());
    }

    public static ListGroupsResponse parse(ByteBuffer buffer, short version) {
        return new ListGroupsResponse(ApiKeys.LIST_GROUPS.parseResponse(version, buffer));
    }

    public static class Group {
        private final String groupId;
        private final String protocolType;

        public Group(String groupId, String protocolType) {
            this.groupId = groupId;
            this.protocolType = protocolType;
        }

        public String groupId() {
            return this.groupId;
        }

        public String protocolType() {
            return this.protocolType;
        }
    }
}

