/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka011.org.apache.kafka.common.requests.ApiError;

public class CreateAclsResponse
extends AbstractResponse {
    private static final String CREATION_RESPONSES = "creation_responses";
    private final int throttleTimeMs;
    private final List<AclCreationResponse> aclCreationResponses;

    public CreateAclsResponse(int throttleTimeMs, List<AclCreationResponse> aclCreationResponses) {
        this.throttleTimeMs = throttleTimeMs;
        this.aclCreationResponses = aclCreationResponses;
    }

    public CreateAclsResponse(Struct struct) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.aclCreationResponses = new ArrayList<AclCreationResponse>();
        for (Object responseStructObj : struct.getArray(CREATION_RESPONSES)) {
            Struct responseStruct = (Struct)responseStructObj;
            ApiError error = new ApiError(responseStruct);
            this.aclCreationResponses.add(new AclCreationResponse(error));
        }
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.CREATE_ACLS.responseSchema(version));
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        ArrayList<Struct> responseStructs = new ArrayList<Struct>();
        for (AclCreationResponse response : this.aclCreationResponses) {
            Struct responseStruct = struct.instance(CREATION_RESPONSES);
            response.error.write(responseStruct);
            responseStructs.add(responseStruct);
        }
        struct.set(CREATION_RESPONSES, (Object)responseStructs.toArray());
        return struct;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<AclCreationResponse> aclCreationResponses() {
        return this.aclCreationResponses;
    }

    public static CreateAclsResponse parse(ByteBuffer buffer, short version) {
        return new CreateAclsResponse(ApiKeys.CREATE_ACLS.responseSchema(version).read(buffer));
    }

    public static class AclCreationResponse {
        private final ApiError error;

        public AclCreationResponse(ApiError error) {
            this.error = error;
        }

        public ApiError error() {
            return this.error;
        }

        public String toString() {
            return "(" + this.error + ")";
        }
    }
}

