/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import shaded.alink.kafka011.org.apache.kafka.common.network.Send;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka011.org.apache.kafka.common.requests.RequestHeader;

public class ApiVersionsResponse
extends AbstractResponse {
    public static final ApiVersionsResponse API_VERSIONS_RESPONSE = ApiVersionsResponse.createApiVersionsResponse(0, (byte)2);
    private static final String THROTTLE_TIME_KEY_NAME = "throttle_time_ms";
    public static final String ERROR_CODE_KEY_NAME = "error_code";
    public static final String API_VERSIONS_KEY_NAME = "api_versions";
    public static final String API_KEY_NAME = "api_key";
    public static final String MIN_VERSION_KEY_NAME = "min_version";
    public static final String MAX_VERSION_KEY_NAME = "max_version";
    private final Errors error;
    private final int throttleTimeMs;
    private final Map<Short, ApiVersion> apiKeyToApiVersion;

    public ApiVersionsResponse(Errors error, List<ApiVersion> apiVersions) {
        this(0, error, apiVersions);
    }

    public ApiVersionsResponse(int throttleTimeMs, Errors error, List<ApiVersion> apiVersions) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.apiKeyToApiVersion = this.buildApiKeyToApiVersion(apiVersions);
    }

    public ApiVersionsResponse(Struct struct) {
        this.throttleTimeMs = struct.hasField(THROTTLE_TIME_KEY_NAME) ? struct.getInt(THROTTLE_TIME_KEY_NAME) : 0;
        this.error = Errors.forCode(struct.getShort(ERROR_CODE_KEY_NAME));
        ArrayList<ApiVersion> tempApiVersions = new ArrayList<ApiVersion>();
        for (Object apiVersionsObj : struct.getArray(API_VERSIONS_KEY_NAME)) {
            Struct apiVersionStruct = (Struct)apiVersionsObj;
            short apiKey = apiVersionStruct.getShort(API_KEY_NAME);
            short minVersion = apiVersionStruct.getShort(MIN_VERSION_KEY_NAME);
            short maxVersion = apiVersionStruct.getShort(MAX_VERSION_KEY_NAME);
            tempApiVersions.add(new ApiVersion(apiKey, minVersion, maxVersion));
        }
        this.apiKeyToApiVersion = this.buildApiKeyToApiVersion(tempApiVersions);
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.API_VERSIONS.responseSchema(version));
        if (struct.hasField(THROTTLE_TIME_KEY_NAME)) {
            struct.set(THROTTLE_TIME_KEY_NAME, (Object)this.throttleTimeMs);
        }
        struct.set(ERROR_CODE_KEY_NAME, (Object)this.error.code());
        ArrayList<Struct> apiVersionList = new ArrayList<Struct>();
        for (ApiVersion apiVersion : this.apiKeyToApiVersion.values()) {
            Struct apiVersionStruct = struct.instance(API_VERSIONS_KEY_NAME);
            apiVersionStruct.set(API_KEY_NAME, (Object)apiVersion.apiKey);
            apiVersionStruct.set(MIN_VERSION_KEY_NAME, (Object)apiVersion.minVersion);
            apiVersionStruct.set(MAX_VERSION_KEY_NAME, (Object)apiVersion.maxVersion);
            apiVersionList.add(apiVersionStruct);
        }
        struct.set(API_VERSIONS_KEY_NAME, (Object)apiVersionList.toArray());
        return struct;
    }

    public static ApiVersionsResponse apiVersionsResponse(int throttleTimeMs, byte maxMagic) {
        if (maxMagic == 2 && throttleTimeMs == 0) {
            return API_VERSIONS_RESPONSE;
        }
        return ApiVersionsResponse.createApiVersionsResponse(throttleTimeMs, maxMagic);
    }

    public static Send unsupportedVersionSend(String destination, RequestHeader requestHeader) {
        ApiVersionsResponse response = new ApiVersionsResponse(0, Errors.UNSUPPORTED_VERSION, Collections.emptyList());
        return response.toSend(destination, (short)0, requestHeader.toResponseHeader());
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Collection<ApiVersion> apiVersions() {
        return this.apiKeyToApiVersion.values();
    }

    public ApiVersion apiVersion(short apiKey) {
        return this.apiKeyToApiVersion.get(apiKey);
    }

    public Errors error() {
        return this.error;
    }

    public static ApiVersionsResponse parse(ByteBuffer buffer, short version) {
        return new ApiVersionsResponse(ApiKeys.API_VERSIONS.parseResponse(version, buffer));
    }

    public static ApiVersionsResponse createApiVersionsResponse(int throttleTimeMs, byte minMagic) {
        ArrayList<ApiVersion> versionList = new ArrayList<ApiVersion>();
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (apiKey.minRequiredInterBrokerMagic > minMagic) continue;
            versionList.add(new ApiVersion(apiKey));
        }
        return new ApiVersionsResponse(throttleTimeMs, Errors.NONE, versionList);
    }

    private Map<Short, ApiVersion> buildApiKeyToApiVersion(List<ApiVersion> apiVersions) {
        HashMap<Short, ApiVersion> tempApiIdToApiVersion = new HashMap<Short, ApiVersion>();
        for (ApiVersion apiVersion : apiVersions) {
            tempApiIdToApiVersion.put(apiVersion.apiKey, apiVersion);
        }
        return tempApiIdToApiVersion;
    }

    public static final class ApiVersion {
        public final short apiKey;
        public final short minVersion;
        public final short maxVersion;

        public ApiVersion(ApiKeys apiKey) {
            this(apiKey.id, apiKey.oldestVersion(), apiKey.latestVersion());
        }

        public ApiVersion(short apiKey, short minVersion, short maxVersion) {
            this.apiKey = apiKey;
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
        }

        public String toString() {
            return "ApiVersion(apiKey=" + this.apiKey + ", minVersion=" + this.minVersion + ", maxVersion= " + this.maxVersion + ")";
        }
    }
}

