/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.clients.producer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka011.org.apache.kafka.clients.ApiVersions;
import shaded.alink.kafka011.org.apache.kafka.clients.producer.Callback;
import shaded.alink.kafka011.org.apache.kafka.clients.producer.internals.BufferPool;
import shaded.alink.kafka011.org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import shaded.alink.kafka011.org.apache.kafka.clients.producer.internals.IncompleteBatches;
import shaded.alink.kafka011.org.apache.kafka.clients.producer.internals.ProducerBatch;
import shaded.alink.kafka011.org.apache.kafka.clients.producer.internals.ProducerIdAndEpoch;
import shaded.alink.kafka011.org.apache.kafka.clients.producer.internals.TransactionManager;
import shaded.alink.kafka011.org.apache.kafka.common.Cluster;
import shaded.alink.kafka011.org.apache.kafka.common.MetricName;
import shaded.alink.kafka011.org.apache.kafka.common.Node;
import shaded.alink.kafka011.org.apache.kafka.common.PartitionInfo;
import shaded.alink.kafka011.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka011.org.apache.kafka.common.errors.UnsupportedVersionException;
import shaded.alink.kafka011.org.apache.kafka.common.header.Header;
import shaded.alink.kafka011.org.apache.kafka.common.metrics.Measurable;
import shaded.alink.kafka011.org.apache.kafka.common.metrics.MetricConfig;
import shaded.alink.kafka011.org.apache.kafka.common.metrics.Metrics;
import shaded.alink.kafka011.org.apache.kafka.common.metrics.Sensor;
import shaded.alink.kafka011.org.apache.kafka.common.metrics.stats.Rate;
import shaded.alink.kafka011.org.apache.kafka.common.record.AbstractRecords;
import shaded.alink.kafka011.org.apache.kafka.common.record.CompressionRatioEstimator;
import shaded.alink.kafka011.org.apache.kafka.common.record.CompressionType;
import shaded.alink.kafka011.org.apache.kafka.common.record.MemoryRecords;
import shaded.alink.kafka011.org.apache.kafka.common.record.MemoryRecordsBuilder;
import shaded.alink.kafka011.org.apache.kafka.common.record.Record;
import shaded.alink.kafka011.org.apache.kafka.common.record.TimestampType;
import shaded.alink.kafka011.org.apache.kafka.common.utils.CopyOnWriteMap;
import shaded.alink.kafka011.org.apache.kafka.common.utils.Time;
import shaded.alink.kafka011.org.apache.kafka.common.utils.Utils;

public final class RecordAccumulator {
    private static final Logger log = LoggerFactory.getLogger(RecordAccumulator.class);
    private volatile boolean closed = false;
    private final AtomicInteger flushesInProgress = new AtomicInteger(0);
    private final AtomicInteger appendsInProgress = new AtomicInteger(0);
    private final int batchSize;
    private final CompressionType compression;
    private final long lingerMs;
    private final long retryBackoffMs;
    private final BufferPool free;
    private final Time time;
    private final ApiVersions apiVersions;
    private final ConcurrentMap<TopicPartition, Deque<ProducerBatch>> batches;
    private final IncompleteBatches incomplete;
    private final Set<TopicPartition> muted;
    private int drainIndex = 0;
    private final TransactionManager transactionManager;

    public RecordAccumulator(int batchSize, long totalSize, CompressionType compression, long lingerMs, long retryBackoffMs, Metrics metrics, Time time, ApiVersions apiVersions, TransactionManager transactionManager) {
        this.batchSize = batchSize;
        this.compression = compression;
        this.lingerMs = lingerMs;
        this.retryBackoffMs = retryBackoffMs;
        this.batches = new CopyOnWriteMap<TopicPartition, Deque<ProducerBatch>>();
        String metricGrpName = "producer-metrics";
        this.free = new BufferPool(totalSize, batchSize, metrics, time, metricGrpName);
        this.incomplete = new IncompleteBatches();
        this.muted = new HashSet<TopicPartition>();
        this.time = time;
        this.apiVersions = apiVersions;
        this.transactionManager = transactionManager;
        this.registerMetrics(metrics, metricGrpName);
    }

    private void registerMetrics(Metrics metrics, String metricGrpName) {
        MetricName metricName = metrics.metricName("waiting-threads", metricGrpName, "The number of user threads blocked waiting for buffer memory to enqueue their records");
        Measurable waitingThreads = new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return RecordAccumulator.this.free.queued();
            }
        };
        metrics.addMetric(metricName, waitingThreads);
        metricName = metrics.metricName("buffer-total-bytes", metricGrpName, "The maximum amount of buffer memory the client can use (whether or not it is currently used).");
        Measurable totalBytes = new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return RecordAccumulator.this.free.totalMemory();
            }
        };
        metrics.addMetric(metricName, totalBytes);
        metricName = metrics.metricName("buffer-available-bytes", metricGrpName, "The total amount of buffer memory that is not being used (either unallocated or in the free list).");
        Measurable availableBytes = new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return RecordAccumulator.this.free.availableMemory();
            }
        };
        metrics.addMetric(metricName, availableBytes);
        Sensor bufferExhaustedRecordSensor = metrics.sensor("buffer-exhausted-records");
        metricName = metrics.metricName("buffer-exhausted-rate", metricGrpName, "The average per-second number of record sends that are dropped due to buffer exhaustion");
        bufferExhaustedRecordSensor.add(metricName, new Rate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public RecordAppendResult append(TopicPartition tp, long timestamp, byte[] key, byte[] value, Header[] headers, Callback callback, long maxTimeToBlock) throws InterruptedException {
        byte maxUsableMagic;
        Deque<ProducerBatch> dq;
        ByteBuffer buffer;
        block18: {
            block17: {
                RecordAppendResult recordAppendResult;
                this.appendsInProgress.incrementAndGet();
                buffer = null;
                if (headers == null) {
                    headers = Record.EMPTY_HEADERS;
                }
                try {
                    Deque<ProducerBatch> deque = dq = this.getOrCreateDeque(tp);
                    // MONITORENTER : deque
                    if (this.closed) {
                        throw new IllegalStateException("Cannot send after the producer is closed.");
                    }
                    RecordAppendResult appendResult = this.tryAppend(timestamp, key, value, headers, callback, dq);
                    if (appendResult == null) break block17;
                    recordAppendResult = appendResult;
                    // MONITOREXIT : deque
                    if (buffer != null) {
                        this.free.deallocate(buffer);
                    }
                    this.appendsInProgress.decrementAndGet();
                }
                catch (Throwable throwable) {
                    if (buffer != null) {
                        this.free.deallocate(buffer);
                    }
                    this.appendsInProgress.decrementAndGet();
                    throw throwable;
                }
                return recordAppendResult;
            }
            // MONITOREXIT : deque
            maxUsableMagic = this.apiVersions.maxUsableProduceMagic();
            int size = Math.max(this.batchSize, AbstractRecords.estimateSizeInBytesUpperBound(maxUsableMagic, this.compression, key, value, headers));
            log.trace("Allocating a new {} byte message buffer for topic {} partition {}", size, tp.topic(), tp.partition());
            buffer = this.free.allocate(size, maxTimeToBlock);
            Deque<ProducerBatch> deque = dq;
            // MONITORENTER : deque
            if (this.closed) {
                throw new IllegalStateException("Cannot send after the producer is closed.");
            }
            RecordAppendResult appendResult = this.tryAppend(timestamp, key, value, headers, callback, dq);
            if (appendResult == null) break block18;
            RecordAppendResult recordAppendResult = appendResult;
            // MONITOREXIT : deque
            if (buffer != null) {
                this.free.deallocate(buffer);
            }
            this.appendsInProgress.decrementAndGet();
            return recordAppendResult;
        }
        MemoryRecordsBuilder recordsBuilder = this.recordsBuilder(buffer, maxUsableMagic);
        ProducerBatch batch = new ProducerBatch(tp, recordsBuilder, this.time.milliseconds());
        FutureRecordMetadata future = Utils.notNull(batch.tryAppend(timestamp, key, value, headers, callback, this.time.milliseconds()));
        dq.addLast(batch);
        this.incomplete.add(batch);
        buffer = null;
        RecordAppendResult recordAppendResult = new RecordAppendResult(future, dq.size() > 1 || batch.isFull(), true);
        // MONITOREXIT : deque
        if (buffer != null) {
            this.free.deallocate(buffer);
        }
        this.appendsInProgress.decrementAndGet();
        return recordAppendResult;
    }

    private MemoryRecordsBuilder recordsBuilder(ByteBuffer buffer, byte maxUsableMagic) {
        if (this.transactionManager != null && maxUsableMagic < 2) {
            throw new UnsupportedVersionException("Attempting to use idempotence with a broker which does not support the required message format (v2). The broker must be version 0.11 or later.");
        }
        return MemoryRecords.builder(buffer, maxUsableMagic, this.compression, TimestampType.CREATE_TIME, 0L);
    }

    private RecordAppendResult tryAppend(long timestamp, byte[] key, byte[] value, Header[] headers, Callback callback, Deque<ProducerBatch> deque) {
        ProducerBatch last = deque.peekLast();
        if (last != null) {
            FutureRecordMetadata future = last.tryAppend(timestamp, key, value, headers, callback, this.time.milliseconds());
            if (future == null) {
                last.closeForRecordAppends();
            } else {
                return new RecordAppendResult(future, deque.size() > 1 || last.isFull(), false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProducerBatch> expiredBatches(int requestTimeout, long now) {
        ArrayList<ProducerBatch> expiredBatches = new ArrayList<ProducerBatch>();
        for (Map.Entry entry : this.batches.entrySet()) {
            Deque dq = (Deque)entry.getValue();
            TopicPartition tp = (TopicPartition)entry.getKey();
            if (this.muted.contains(tp)) continue;
            Deque deque = dq;
            synchronized (deque) {
                ProducerBatch lastBatch = (ProducerBatch)dq.peekLast();
                Iterator batchIterator = dq.iterator();
                while (batchIterator.hasNext()) {
                    boolean isFull;
                    ProducerBatch batch = (ProducerBatch)batchIterator.next();
                    boolean bl = isFull = batch != lastBatch || batch.isFull();
                    if (!batch.maybeExpire(requestTimeout, this.retryBackoffMs, now, this.lingerMs, isFull)) break;
                    expiredBatches.add(batch);
                    batchIterator.remove();
                }
            }
        }
        return expiredBatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reenqueue(ProducerBatch batch, long now) {
        Deque<ProducerBatch> deque;
        batch.reenqueued(now);
        Deque<ProducerBatch> deque2 = deque = this.getOrCreateDeque(batch.topicPartition);
        synchronized (deque2) {
            deque.addFirst(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int splitAndReenqueue(ProducerBatch bigBatch) {
        CompressionRatioEstimator.setEstimation(bigBatch.topicPartition.topic(), this.compression, Math.max(1.0f, (float)bigBatch.compressionRatio()));
        Deque<ProducerBatch> dq = bigBatch.split(this.batchSize);
        int numSplitBatches = dq.size();
        Deque<ProducerBatch> partitionDequeue = this.getOrCreateDeque(bigBatch.topicPartition);
        while (!dq.isEmpty()) {
            ProducerBatch batch = dq.pollLast();
            this.incomplete.add(batch);
            Deque<ProducerBatch> deque = partitionDequeue;
            synchronized (deque) {
                partitionDequeue.addFirst(batch);
            }
        }
        return numSplitBatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadyCheckResult ready(Cluster cluster, long nowMs) {
        HashSet<Node> readyNodes = new HashSet<Node>();
        long nextReadyCheckDelayMs = Long.MAX_VALUE;
        HashSet<String> unknownLeaderTopics = new HashSet<String>();
        boolean exhausted = this.free.queued() > 0;
        for (Map.Entry entry : this.batches.entrySet()) {
            TopicPartition part = (TopicPartition)entry.getKey();
            Deque deque = (Deque)entry.getValue();
            Node leader = cluster.leaderFor(part);
            Deque deque2 = deque;
            synchronized (deque2) {
                ProducerBatch batch;
                if (leader == null && !deque.isEmpty()) {
                    unknownLeaderTopics.add(part.topic());
                } else if (!readyNodes.contains(leader) && !this.muted.contains(part) && (batch = (ProducerBatch)deque.peekFirst()) != null) {
                    boolean sendable;
                    long waitedTimeMs = batch.waitedTimeMs(nowMs);
                    boolean backingOff = batch.attempts() > 0 && waitedTimeMs < this.retryBackoffMs;
                    long timeToWaitMs = backingOff ? this.retryBackoffMs : this.lingerMs;
                    boolean full = deque.size() > 1 || batch.isFull();
                    boolean expired = waitedTimeMs >= timeToWaitMs;
                    boolean bl = sendable = full || expired || exhausted || this.closed || this.flushInProgress();
                    if (sendable && !backingOff) {
                        readyNodes.add(leader);
                    } else {
                        long timeLeftMs = Math.max(timeToWaitMs - waitedTimeMs, 0L);
                        nextReadyCheckDelayMs = Math.min(timeLeftMs, nextReadyCheckDelayMs);
                    }
                }
            }
        }
        return new ReadyCheckResult(readyNodes, nextReadyCheckDelayMs, unknownLeaderTopics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUndrained() {
        for (Map.Entry entry : this.batches.entrySet()) {
            Deque deque;
            Deque deque2 = deque = (Deque)entry.getValue();
            synchronized (deque2) {
                if (!deque.isEmpty()) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, List<ProducerBatch>> drain(Cluster cluster, Set<Node> nodes, int maxSize, long now) {
        if (nodes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<ProducerBatch>> batches = new HashMap<Integer, List<ProducerBatch>>();
        for (Node node : nodes) {
            int size = 0;
            List<PartitionInfo> parts = cluster.partitionsForNode(node.id());
            ArrayList<ProducerBatch> ready = new ArrayList<ProducerBatch>();
            int start = this.drainIndex %= parts.size();
            do {
                Deque<ProducerBatch> deque;
                PartitionInfo part;
                TopicPartition tp;
                if (!this.muted.contains(tp = new TopicPartition((part = parts.get(this.drainIndex)).topic(), part.partition())) && (deque = this.getDeque(tp)) != null) {
                    Deque<ProducerBatch> deque2 = deque;
                    synchronized (deque2) {
                        ProducerBatch first = deque.peekFirst();
                        if (first != null) {
                            boolean backoff;
                            boolean bl = backoff = first.attempts() > 0 && first.waitedTimeMs(now) < this.retryBackoffMs;
                            if (!backoff) {
                                if (size + first.sizeInBytes() > maxSize && !ready.isEmpty()) {
                                    break;
                                }
                                ProducerIdAndEpoch producerIdAndEpoch = null;
                                boolean isTransactional = false;
                                if (this.transactionManager != null) {
                                    if (!this.transactionManager.isSendToPartitionAllowed(tp)) {
                                        break;
                                    }
                                    producerIdAndEpoch = this.transactionManager.producerIdAndEpoch();
                                    if (!producerIdAndEpoch.isValid()) {
                                        break;
                                    }
                                    isTransactional = this.transactionManager.isTransactional();
                                }
                                ProducerBatch batch = deque.pollFirst();
                                if (producerIdAndEpoch != null && !batch.inRetry()) {
                                    int sequenceNumber = this.transactionManager.sequenceNumber(batch.topicPartition);
                                    log.debug("Assigning sequence number {} from producer {} to dequeued batch from partition {} bound for {}.", sequenceNumber, producerIdAndEpoch, batch.topicPartition, node);
                                    batch.setProducerState(producerIdAndEpoch, sequenceNumber, isTransactional);
                                }
                                batch.close();
                                size += batch.sizeInBytes();
                                ready.add(batch);
                                batch.drained(now);
                            }
                        }
                    }
                }
                this.drainIndex = (this.drainIndex + 1) % parts.size();
            } while (start != this.drainIndex);
            batches.put(node.id(), ready);
        }
        return batches;
    }

    private Deque<ProducerBatch> getDeque(TopicPartition tp) {
        return (Deque)this.batches.get(tp);
    }

    private Deque<ProducerBatch> getOrCreateDeque(TopicPartition tp) {
        ArrayDeque<ProducerBatch> d = (ArrayDeque<ProducerBatch>)this.batches.get(tp);
        if (d != null) {
            return d;
        }
        d = new ArrayDeque<ProducerBatch>();
        Deque previous = this.batches.putIfAbsent(tp, d);
        if (previous == null) {
            return d;
        }
        return previous;
    }

    public void deallocate(ProducerBatch batch) {
        this.incomplete.remove(batch);
        if (!batch.isSplitBatch()) {
            this.free.deallocate(batch.buffer(), batch.initialCapacity());
        }
    }

    long bufferPoolAvailableMemory() {
        return this.free.availableMemory();
    }

    boolean flushInProgress() {
        return this.flushesInProgress.get() > 0;
    }

    Map<TopicPartition, Deque<ProducerBatch>> batches() {
        return Collections.unmodifiableMap(this.batches);
    }

    public void beginFlush() {
        this.flushesInProgress.getAndIncrement();
    }

    private boolean appendsInProgress() {
        return this.appendsInProgress.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitFlushCompletion() throws InterruptedException {
        try {
            for (ProducerBatch batch : this.incomplete.copyAll()) {
                batch.produceFuture.await();
            }
        }
        finally {
            this.flushesInProgress.decrementAndGet();
        }
    }

    public boolean hasIncomplete() {
        return !this.incomplete.isEmpty();
    }

    public void abortIncompleteBatches() {
        do {
            this.abortBatches();
        } while (this.appendsInProgress());
        this.abortBatches();
        this.batches.clear();
    }

    private void abortBatches() {
        this.abortBatches(new IllegalStateException("Producer is closed forcefully."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortBatches(RuntimeException reason) {
        for (ProducerBatch batch : this.incomplete.copyAll()) {
            Deque<ProducerBatch> dq;
            Deque<ProducerBatch> deque = dq = this.getDeque(batch.topicPartition);
            synchronized (deque) {
                batch.abortRecordAppends();
                dq.remove(batch);
            }
            batch.abort(reason);
            this.deallocate(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortUndrainedBatches(RuntimeException reason) {
        for (ProducerBatch batch : this.incomplete.copyAll()) {
            Deque<ProducerBatch> dq = this.getDeque(batch.topicPartition);
            boolean aborted = false;
            Deque<ProducerBatch> deque = dq;
            synchronized (deque) {
                if (!batch.isClosed()) {
                    aborted = true;
                    batch.abortRecordAppends();
                    dq.remove(batch);
                }
            }
            if (!aborted) continue;
            batch.abort(reason);
            this.deallocate(batch);
        }
    }

    public void mutePartition(TopicPartition tp) {
        this.muted.add(tp);
    }

    public void unmutePartition(TopicPartition tp) {
        this.muted.remove(tp);
    }

    public void close() {
        this.closed = true;
    }

    public static final class ReadyCheckResult {
        public final Set<Node> readyNodes;
        public final long nextReadyCheckDelayMs;
        public final Set<String> unknownLeaderTopics;

        public ReadyCheckResult(Set<Node> readyNodes, long nextReadyCheckDelayMs, Set<String> unknownLeaderTopics) {
            this.readyNodes = readyNodes;
            this.nextReadyCheckDelayMs = nextReadyCheckDelayMs;
            this.unknownLeaderTopics = unknownLeaderTopics;
        }
    }

    public static final class RecordAppendResult {
        public final FutureRecordMetadata future;
        public final boolean batchIsFull;
        public final boolean newBatchCreated;

        public RecordAppendResult(FutureRecordMetadata future, boolean batchIsFull, boolean newBatchCreated) {
            this.future = future;
            this.batchIsFull = batchIsFull;
            this.newBatchCreated = newBatchCreated;
        }
    }
}

