/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.security.scram;

import java.util.Collection;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import shaded.alink.kafka010.org.apache.kafka.common.security.authenticator.CredentialCache;
import shaded.alink.kafka010.org.apache.kafka.common.security.scram.ScramCredential;
import shaded.alink.kafka010.org.apache.kafka.common.security.scram.ScramMechanism;

public class ScramCredentialUtils {
    private static final String SALT = "salt";
    private static final String STORED_KEY = "stored_key";
    private static final String SERVER_KEY = "server_key";
    private static final String ITERATIONS = "iterations";

    public static String credentialToString(ScramCredential credential) {
        return String.format("%s=%s,%s=%s,%s=%s,%s=%d", SALT, DatatypeConverter.printBase64Binary((byte[])credential.salt()), STORED_KEY, DatatypeConverter.printBase64Binary((byte[])credential.storedKey()), SERVER_KEY, DatatypeConverter.printBase64Binary((byte[])credential.serverKey()), ITERATIONS, credential.iterations());
    }

    public static ScramCredential credentialFromString(String str) {
        Properties props = ScramCredentialUtils.toProps(str);
        if (!(props.size() == 4 && props.containsKey(SALT) && props.containsKey(STORED_KEY) && props.containsKey(SERVER_KEY) && props.containsKey(ITERATIONS))) {
            throw new IllegalArgumentException("Credentials not valid: " + str);
        }
        byte[] salt = DatatypeConverter.parseBase64Binary((String)props.getProperty(SALT));
        byte[] storedKey = DatatypeConverter.parseBase64Binary((String)props.getProperty(STORED_KEY));
        byte[] serverKey = DatatypeConverter.parseBase64Binary((String)props.getProperty(SERVER_KEY));
        int iterations = Integer.parseInt(props.getProperty(ITERATIONS));
        return new ScramCredential(salt, storedKey, serverKey, iterations);
    }

    private static Properties toProps(String str) {
        String[] tokens;
        Properties props = new Properties();
        for (String token : tokens = str.split(",")) {
            int index = token.indexOf(61);
            if (index <= 0) {
                throw new IllegalArgumentException("Credentials not valid: " + str);
            }
            props.put(token.substring(0, index), token.substring(index + 1));
        }
        return props;
    }

    public static void createCache(CredentialCache cache, Collection<String> enabledMechanisms) {
        for (String mechanism : ScramMechanism.mechanismNames()) {
            if (!enabledMechanisms.contains(mechanism)) continue;
            cache.createCache(mechanism, ScramCredential.class);
        }
    }
}

