/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.security.authenticator;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CredentialCache {
    private final Map<String, Cache<? extends Object>> cacheMap = new HashMap<String, Cache<? extends Object>>();

    public <C> Cache<C> createCache(String mechanism, Class<C> credentialClass) {
        Cache<C> cache = new Cache<C>(credentialClass);
        this.cacheMap.put(mechanism, cache);
        return cache;
    }

    public <C> Cache<C> cache(String mechanism, Class<C> credentialClass) {
        Cache<? extends Object> cache = this.cacheMap.get(mechanism);
        if (cache != null) {
            if (cache.credentialClass() != credentialClass) {
                throw new IllegalArgumentException("Invalid credential class " + credentialClass + ", expected " + cache.credentialClass());
            }
            return cache;
        }
        return null;
    }

    public static class Cache<C> {
        private final Class<C> credentialClass;
        private final ConcurrentHashMap<String, C> credentials;

        public Cache(Class<C> credentialClass) {
            this.credentialClass = credentialClass;
            this.credentials = new ConcurrentHashMap();
        }

        public C get(String username) {
            return this.credentials.get(username);
        }

        public C put(String username, C credential) {
            return this.credentials.put(username, credential);
        }

        public C remove(String username) {
            return this.credentials.remove(username);
        }

        public Class<C> credentialClass() {
            return this.credentialClass;
        }
    }
}

