/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.network;

import java.util.Map;
import shaded.alink.kafka010.org.apache.kafka.common.network.ChannelBuilder;
import shaded.alink.kafka010.org.apache.kafka.common.network.LoginType;
import shaded.alink.kafka010.org.apache.kafka.common.network.Mode;
import shaded.alink.kafka010.org.apache.kafka.common.network.PlaintextChannelBuilder;
import shaded.alink.kafka010.org.apache.kafka.common.network.SaslChannelBuilder;
import shaded.alink.kafka010.org.apache.kafka.common.network.SslChannelBuilder;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.SecurityProtocol;
import shaded.alink.kafka010.org.apache.kafka.common.security.auth.DefaultPrincipalBuilder;
import shaded.alink.kafka010.org.apache.kafka.common.security.auth.PrincipalBuilder;
import shaded.alink.kafka010.org.apache.kafka.common.security.authenticator.CredentialCache;
import shaded.alink.kafka010.org.apache.kafka.common.utils.Utils;

public class ChannelBuilders {
    private ChannelBuilders() {
    }

    public static ChannelBuilder clientChannelBuilder(SecurityProtocol securityProtocol, LoginType loginType, Map<String, ?> configs, String clientSaslMechanism, boolean saslHandshakeRequestEnable) {
        if (securityProtocol == SecurityProtocol.SASL_PLAINTEXT || securityProtocol == SecurityProtocol.SASL_SSL) {
            if (loginType == null) {
                throw new IllegalArgumentException("`loginType` must be non-null if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
            }
            if (clientSaslMechanism == null) {
                throw new IllegalArgumentException("`clientSaslMechanism` must be non-null in client mode if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
            }
        }
        return ChannelBuilders.create(securityProtocol, Mode.CLIENT, loginType, configs, clientSaslMechanism, saslHandshakeRequestEnable, null);
    }

    public static ChannelBuilder serverChannelBuilder(SecurityProtocol securityProtocol, Map<String, ?> configs, CredentialCache credentialCache) {
        return ChannelBuilders.create(securityProtocol, Mode.SERVER, LoginType.SERVER, configs, null, true, credentialCache);
    }

    private static ChannelBuilder create(SecurityProtocol securityProtocol, Mode mode, LoginType loginType, Map<String, ?> configs, String clientSaslMechanism, boolean saslHandshakeRequestEnable, CredentialCache credentialCache) {
        ChannelBuilder channelBuilder;
        switch (securityProtocol) {
            case SSL: {
                ChannelBuilders.requireNonNullMode(mode, securityProtocol);
                channelBuilder = new SslChannelBuilder(mode);
                break;
            }
            case SASL_SSL: 
            case SASL_PLAINTEXT: {
                ChannelBuilders.requireNonNullMode(mode, securityProtocol);
                channelBuilder = new SaslChannelBuilder(mode, loginType, securityProtocol, clientSaslMechanism, saslHandshakeRequestEnable, credentialCache);
                break;
            }
            case PLAINTEXT: 
            case TRACE: {
                channelBuilder = new PlaintextChannelBuilder();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected securityProtocol " + (Object)((Object)securityProtocol));
            }
        }
        channelBuilder.configure(configs);
        return channelBuilder;
    }

    static PrincipalBuilder createPrincipalBuilder(Map<String, ?> configs) {
        Class principalBuilderClass = (Class)configs.get("principal.builder.class");
        PrincipalBuilder principalBuilder = principalBuilderClass == null ? new DefaultPrincipalBuilder() : (PrincipalBuilder)Utils.newInstance(principalBuilderClass);
        principalBuilder.configure(configs);
        return principalBuilder;
    }

    private static void requireNonNullMode(Mode mode, SecurityProtocol securityProtocol) {
        if (mode == null) {
            throw new IllegalArgumentException("`mode` must be non-null if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
        }
    }
}

