/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.clients.consumer.internals;

public final class Heartbeat {
    private final long sessionTimeout;
    private final long heartbeatInterval;
    private final long maxPollInterval;
    private final long retryBackoffMs;
    private volatile long lastHeartbeatSend;
    private long lastHeartbeatReceive;
    private long lastSessionReset;
    private long lastPoll;
    private boolean heartbeatFailed;

    public Heartbeat(long sessionTimeout, long heartbeatInterval, long maxPollInterval, long retryBackoffMs) {
        if (heartbeatInterval >= sessionTimeout) {
            throw new IllegalArgumentException("Heartbeat must be set lower than the session timeout");
        }
        this.sessionTimeout = sessionTimeout;
        this.heartbeatInterval = heartbeatInterval;
        this.maxPollInterval = maxPollInterval;
        this.retryBackoffMs = retryBackoffMs;
    }

    public void poll(long now) {
        this.lastPoll = now;
    }

    public void sentHeartbeat(long now) {
        this.lastHeartbeatSend = now;
        this.heartbeatFailed = false;
    }

    public void failHeartbeat() {
        this.heartbeatFailed = true;
    }

    public void receiveHeartbeat(long now) {
        this.lastHeartbeatReceive = now;
    }

    public boolean shouldHeartbeat(long now) {
        return this.timeToNextHeartbeat(now) == 0L;
    }

    public long lastHeartbeatSend() {
        return this.lastHeartbeatSend;
    }

    public long timeToNextHeartbeat(long now) {
        long delayToNextHeartbeat;
        long timeSinceLastHeartbeat = now - Math.max(this.lastHeartbeatSend, this.lastSessionReset);
        if (timeSinceLastHeartbeat > (delayToNextHeartbeat = this.heartbeatFailed ? this.retryBackoffMs : this.heartbeatInterval)) {
            return 0L;
        }
        return delayToNextHeartbeat - timeSinceLastHeartbeat;
    }

    public boolean sessionTimeoutExpired(long now) {
        return now - Math.max(this.lastSessionReset, this.lastHeartbeatReceive) > this.sessionTimeout;
    }

    public long interval() {
        return this.heartbeatInterval;
    }

    public void resetTimeouts(long now) {
        this.lastSessionReset = now;
        this.lastPoll = now;
        this.heartbeatFailed = false;
    }

    public boolean pollTimeoutExpired(long now) {
        return now - this.lastPoll > this.maxPollInterval;
    }
}

