/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.security.token.delegation;

import java.util.Arrays;
import java.util.Base64;
import shaded.alink.kafka.org.apache.kafka.common.annotation.InterfaceStability;
import shaded.alink.kafka.org.apache.kafka.common.security.token.delegation.TokenInformation;

@InterfaceStability.Evolving
public class DelegationToken {
    private TokenInformation tokenInformation;
    private byte[] hmac;

    public DelegationToken(TokenInformation tokenInformation, byte[] hmac) {
        this.tokenInformation = tokenInformation;
        this.hmac = hmac;
    }

    public TokenInformation tokenInfo() {
        return this.tokenInformation;
    }

    public byte[] hmac() {
        return this.hmac;
    }

    public String hmacAsBase64String() {
        return Base64.getEncoder().encodeToString(this.hmac);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegationToken token = (DelegationToken)o;
        if (this.tokenInformation != null ? !this.tokenInformation.equals(token.tokenInformation) : token.tokenInformation != null) {
            return false;
        }
        return Arrays.equals(this.hmac, token.hmac);
    }

    public int hashCode() {
        int result = this.tokenInformation != null ? this.tokenInformation.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.hmac);
        return result;
    }

    public String toString() {
        return "DelegationToken{tokenInformation=" + this.tokenInformation + ", hmac=[*******]" + '}';
    }
}

