/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.ExpireDelegationTokenResponse;

public class ExpireDelegationTokenRequest
extends AbstractRequest {
    private static final String HMAC_KEY_NAME = "hmac";
    private static final String EXPIRY_TIME_PERIOD_KEY_NAME = "expiry_time_period";
    private final ByteBuffer hmac;
    private final long expiryTimePeriod;
    private static final Schema TOKEN_EXPIRE_REQUEST_V0;
    private static final Schema TOKEN_EXPIRE_REQUEST_V1;

    private ExpireDelegationTokenRequest(short version, ByteBuffer hmac, long renewTimePeriod) {
        super(ApiKeys.EXPIRE_DELEGATION_TOKEN, version);
        this.hmac = hmac;
        this.expiryTimePeriod = renewTimePeriod;
    }

    public ExpireDelegationTokenRequest(Struct struct, short versionId) {
        super(ApiKeys.EXPIRE_DELEGATION_TOKEN, versionId);
        this.hmac = struct.getBytes(HMAC_KEY_NAME);
        this.expiryTimePeriod = struct.getLong(EXPIRY_TIME_PERIOD_KEY_NAME);
    }

    public static ExpireDelegationTokenRequest parse(ByteBuffer buffer, short version) {
        return new ExpireDelegationTokenRequest(ApiKeys.EXPIRE_DELEGATION_TOKEN.parseRequest(version, buffer), version);
    }

    public static Schema[] schemaVersions() {
        return new Schema[]{TOKEN_EXPIRE_REQUEST_V0, TOKEN_EXPIRE_REQUEST_V1};
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.EXPIRE_DELEGATION_TOKEN.requestSchema(version));
        struct.set(HMAC_KEY_NAME, (Object)this.hmac);
        struct.set(EXPIRY_TIME_PERIOD_KEY_NAME, (Object)this.expiryTimePeriod);
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new ExpireDelegationTokenResponse(throttleTimeMs, Errors.forException(e));
    }

    public ByteBuffer hmac() {
        return this.hmac;
    }

    public long expiryTimePeriod() {
        return this.expiryTimePeriod;
    }

    static {
        TOKEN_EXPIRE_REQUEST_V1 = TOKEN_EXPIRE_REQUEST_V0 = new Schema(new Field(HMAC_KEY_NAME, Type.BYTES, "HMAC of the delegation token to be expired."), new Field(EXPIRY_TIME_PERIOD_KEY_NAME, Type.INT64, "expiry time period in milli seconds."));
    }

    public static class Builder
    extends AbstractRequest.Builder<ExpireDelegationTokenRequest> {
        private final ByteBuffer hmac;
        private final long expiryTimePeriod;

        public Builder(byte[] hmac, long expiryTimePeriod) {
            super(ApiKeys.EXPIRE_DELEGATION_TOKEN);
            this.hmac = ByteBuffer.wrap(hmac);
            this.expiryTimePeriod = expiryTimePeriod;
        }

        @Override
        public ExpireDelegationTokenRequest build(short version) {
            return new ExpireDelegationTokenRequest(version, this.hmac, this.expiryTimePeriod);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type: ExpireDelegationTokenRequest").append(", hmac=").append(this.hmac).append(", expiryTimePeriod=").append(this.expiryTimePeriod).append(")");
            return bld.toString();
        }
    }
}

