/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import shaded.alink.kafka.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.CommonFields;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.ArrayOf;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import shaded.alink.kafka.org.apache.kafka.common.utils.CollectionUtils;

public class AddPartitionsToTxnRequest
extends AbstractRequest {
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final Schema ADD_PARTITIONS_TO_TXN_REQUEST_V0;
    private static final Schema ADD_PARTITIONS_TO_TXN_REQUEST_V1;
    private final String transactionalId;
    private final long producerId;
    private final short producerEpoch;
    private final List<TopicPartition> partitions;

    public static Schema[] schemaVersions() {
        return new Schema[]{ADD_PARTITIONS_TO_TXN_REQUEST_V0, ADD_PARTITIONS_TO_TXN_REQUEST_V1};
    }

    private AddPartitionsToTxnRequest(short version, String transactionalId, long producerId, short producerEpoch, List<TopicPartition> partitions) {
        super(ApiKeys.ADD_PARTITIONS_TO_TXN, version);
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.partitions = partitions;
    }

    public AddPartitionsToTxnRequest(Struct struct, short version) {
        super(ApiKeys.ADD_PARTITIONS_TO_TXN, version);
        Object[] topicPartitionsArray;
        this.transactionalId = struct.get(CommonFields.TRANSACTIONAL_ID);
        this.producerId = struct.get(CommonFields.PRODUCER_ID);
        this.producerEpoch = struct.get(CommonFields.PRODUCER_EPOCH);
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (Object topicPartitionObj : topicPartitionsArray = struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicPartitionStruct = (Struct)topicPartitionObj;
            String topic = topicPartitionStruct.get(CommonFields.TOPIC_NAME);
            for (Object partitionObj : topicPartitionStruct.getArray(PARTITIONS_KEY_NAME)) {
                partitions.add(new TopicPartition(topic, (Integer)partitionObj));
            }
        }
        this.partitions = partitions;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public List<TopicPartition> partitions() {
        return this.partitions;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.ADD_PARTITIONS_TO_TXN.requestSchema(this.version()));
        struct.set(CommonFields.TRANSACTIONAL_ID, this.transactionalId);
        struct.set(CommonFields.PRODUCER_ID, this.producerId);
        struct.set(CommonFields.PRODUCER_EPOCH, this.producerEpoch);
        Map<String, List<Integer>> mappedPartitions = CollectionUtils.groupPartitionsByTopic(this.partitions);
        Object[] partitionsArray = new Object[mappedPartitions.size()];
        int i = 0;
        for (Map.Entry<String, List<Integer>> topicAndPartitions : mappedPartitions.entrySet()) {
            Struct topicPartitionsStruct = struct.instance(TOPICS_KEY_NAME);
            topicPartitionsStruct.set(CommonFields.TOPIC_NAME, topicAndPartitions.getKey());
            topicPartitionsStruct.set(PARTITIONS_KEY_NAME, (Object)topicAndPartitions.getValue().toArray());
            partitionsArray[i++] = topicPartitionsStruct;
        }
        struct.set(TOPICS_KEY_NAME, (Object)partitionsArray);
        return struct;
    }

    @Override
    public AddPartitionsToTxnResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        for (TopicPartition partition : this.partitions) {
            errors.put(partition, Errors.forException(e));
        }
        return new AddPartitionsToTxnResponse(throttleTimeMs, errors);
    }

    public static AddPartitionsToTxnRequest parse(ByteBuffer buffer, short version) {
        return new AddPartitionsToTxnRequest(ApiKeys.ADD_PARTITIONS_TO_TXN.parseRequest(version, buffer), version);
    }

    static {
        ADD_PARTITIONS_TO_TXN_REQUEST_V1 = ADD_PARTITIONS_TO_TXN_REQUEST_V0 = new Schema(CommonFields.TRANSACTIONAL_ID, CommonFields.PRODUCER_ID, CommonFields.PRODUCER_EPOCH, new Field(TOPICS_KEY_NAME, new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field(PARTITIONS_KEY_NAME, new ArrayOf(Type.INT32)))), "The partitions to add to the transaction."));
    }

    public static class Builder
    extends AbstractRequest.Builder<AddPartitionsToTxnRequest> {
        private final String transactionalId;
        private final long producerId;
        private final short producerEpoch;
        private final List<TopicPartition> partitions;

        public Builder(String transactionalId, long producerId, short producerEpoch, List<TopicPartition> partitions) {
            super(ApiKeys.ADD_PARTITIONS_TO_TXN);
            this.transactionalId = transactionalId;
            this.producerId = producerId;
            this.producerEpoch = producerEpoch;
            this.partitions = partitions;
        }

        @Override
        public AddPartitionsToTxnRequest build(short version) {
            return new AddPartitionsToTxnRequest(version, this.transactionalId, this.producerId, this.producerEpoch, this.partitions);
        }

        public List<TopicPartition> partitions() {
            return this.partitions;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=AddPartitionsToTxnRequest").append(", transactionalId=").append(this.transactionalId).append(", producerId=").append(this.producerId).append(", producerEpoch=").append(this.producerEpoch).append(", partitions=").append(this.partitions).append(")");
            return bld.toString();
        }
    }
}

