/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.message;

import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiMessage;
import shaded.alink.kafka.org.apache.kafka.common.protocol.MessageUtil;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Readable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Writable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;

public class RequestHeaderData
implements ApiMessage {
    private short requestApiKey;
    private short requestApiVersion;
    private int correlationId;
    private String clientId;
    public static final Schema SCHEMA_0 = new Schema(new Field("request_api_key", Type.INT16, "The API key of this request."), new Field("request_api_version", Type.INT16, "The API version of this request."), new Field("correlation_id", Type.INT32, "The correlation ID of this request."), new Field("client_id", Type.STRING, "The client ID string."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public RequestHeaderData(Readable readable, short version) {
        this.read(readable, version);
    }

    public RequestHeaderData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public RequestHeaderData() {
        this.requestApiKey = 0;
        this.requestApiVersion = 0;
        this.correlationId = 0;
        this.clientId = "";
    }

    @Override
    public short apiKey() {
        return -1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable readable, short version) {
        this.requestApiKey = readable.readShort();
        this.requestApiVersion = readable.readShort();
        this.correlationId = readable.readInt();
        this.clientId = readable.readNullableString();
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeShort(this.requestApiKey);
        writable.writeShort(this.requestApiVersion);
        writable.writeInt(this.correlationId);
        writable.writeString(this.clientId);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.requestApiKey = struct.getShort("request_api_key");
        this.requestApiVersion = struct.getShort("request_api_version");
        this.correlationId = struct.getInt("correlation_id");
        this.clientId = struct.getString("client_id");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("request_api_key", (Object)this.requestApiKey);
        struct.set("request_api_version", (Object)this.requestApiVersion);
        struct.set("correlation_id", (Object)this.correlationId);
        struct.set("client_id", (Object)this.clientId);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += 2;
        size += 4;
        size += 2;
        return size += MessageUtil.serializedUtf8Length(this.clientId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RequestHeaderData)) {
            return false;
        }
        RequestHeaderData other = (RequestHeaderData)obj;
        if (this.requestApiKey != other.requestApiKey) {
            return false;
        }
        if (this.requestApiVersion != other.requestApiVersion) {
            return false;
        }
        if (this.correlationId != other.correlationId) {
            return false;
        }
        return !(this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.requestApiKey;
        hashCode = 31 * hashCode + this.requestApiVersion;
        hashCode = 31 * hashCode + this.correlationId;
        hashCode = 31 * hashCode + (this.clientId == null ? 0 : this.clientId.hashCode());
        return hashCode;
    }

    public String toString() {
        return "RequestHeaderData(requestApiKey=" + this.requestApiKey + ", requestApiVersion=" + this.requestApiVersion + ", correlationId=" + this.correlationId + ", clientId='" + this.clientId + "')";
    }

    public short requestApiKey() {
        return this.requestApiKey;
    }

    public short requestApiVersion() {
        return this.requestApiVersion;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public RequestHeaderData setRequestApiKey(short v) {
        this.requestApiKey = v;
        return this;
    }

    public RequestHeaderData setRequestApiVersion(short v) {
        this.requestApiVersion = v;
        return this;
    }

    public RequestHeaderData setCorrelationId(int v) {
        this.correlationId = v;
        return this;
    }

    public RequestHeaderData setClientId(String v) {
        this.clientId = v;
        return this;
    }
}

