/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import shaded.alink.kafka.org.apache.kafka.common.errors.UnsupportedVersionException;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiMessage;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Message;
import shaded.alink.kafka.org.apache.kafka.common.protocol.MessageUtil;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Readable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Writable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.ArrayOf;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;

public class OffsetFetchResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<OffsetFetchResponseTopic> topics;
    private short errorCode;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;

    public OffsetFetchResponseData(Readable readable, short version) {
        this.topics = new ArrayList<OffsetFetchResponseTopic>();
        this.read(readable, version);
    }

    public OffsetFetchResponseData(Struct struct, short version) {
        this.topics = new ArrayList<OffsetFetchResponseTopic>();
        this.fromStruct(struct, version);
    }

    public OffsetFetchResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new ArrayList<OffsetFetchResponseTopic>();
        this.errorCode = 0;
    }

    @Override
    public short apiKey() {
        return 9;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = version >= 3 ? readable.readInt() : 0;
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear();
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new OffsetFetchResponseTopic(readable, version));
            }
        }
        this.errorCode = version >= 2 ? readable.readShort() : (short)0;
    }

    @Override
    public void write(Writable writable, short version) {
        if (version >= 3) {
            writable.writeInt(this.throttleTimeMs);
        }
        writable.writeInt(this.topics.size());
        for (OffsetFetchResponseTopic element : this.topics) {
            element.write(writable, version);
        }
        if (version >= 2) {
            writable.writeShort(this.errorCode);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 3 ? struct.getInt("throttle_time_ms") : 0;
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<OffsetFetchResponseTopic>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new OffsetFetchResponseTopic((Struct)nestedObject, version));
        }
        this.errorCode = version >= 2 ? struct.getShort("error_code") : (short)0;
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 3) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (OffsetFetchResponseTopic element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        if (version >= 2) {
            struct.set("error_code", (Object)this.errorCode);
        }
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        if (version >= 3) {
            size += 4;
        }
        size += 4;
        for (OffsetFetchResponseTopic element : this.topics) {
            size += element.size(version);
        }
        if (version >= 2) {
            size += 2;
        } else if (this.errorCode != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default errorCode at version " + version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetFetchResponseData)) {
            return false;
        }
        OffsetFetchResponseData other = (OffsetFetchResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return this.errorCode == other.errorCode;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.errorCode;
        return hashCode;
    }

    public String toString() {
        return "OffsetFetchResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", errorCode=" + this.errorCode + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<OffsetFetchResponseTopic> topics() {
        return this.topics;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public OffsetFetchResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public OffsetFetchResponseData setTopics(List<OffsetFetchResponseTopic> v) {
        this.topics = v;
        return this;
    }

    public OffsetFetchResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(OffsetFetchResponseTopic.SCHEMA_0), "The responses per topic."));
        SCHEMA_2 = new Schema(new Field("topics", new ArrayOf(OffsetFetchResponseTopic.SCHEMA_0), "The responses per topic."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error."));
        SCHEMA_4 = SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(OffsetFetchResponseTopic.SCHEMA_0), "The responses per topic."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error."));
        SCHEMA_5 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(OffsetFetchResponseTopic.SCHEMA_5), "The responses per topic."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class OffsetFetchResponsePartition
    implements Message {
        private int partitionIndex;
        private long committedOffset;
        private int committedLeaderEpoch;
        private String metadata;
        private short errorCode;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public OffsetFetchResponsePartition(Readable readable, short version) {
            this.read(readable, version);
        }

        public OffsetFetchResponsePartition(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public OffsetFetchResponsePartition() {
            this.partitionIndex = 0;
            this.committedOffset = 0L;
            this.committedLeaderEpoch = 0;
            this.metadata = "";
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.committedOffset = readable.readLong();
            this.committedLeaderEpoch = version >= 5 ? readable.readInt() : 0;
            this.metadata = readable.readNullableString();
            this.errorCode = readable.readShort();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeLong(this.committedOffset);
            if (version >= 5) {
                writable.writeInt(this.committedLeaderEpoch);
            }
            writable.writeNullableString(this.metadata);
            writable.writeShort(this.errorCode);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.committedOffset = struct.getLong("committed_offset");
            this.committedLeaderEpoch = version >= 5 ? struct.getInt("committed_leader_epoch") : 0;
            this.metadata = struct.getString("metadata");
            this.errorCode = struct.getShort("error_code");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("committed_offset", (Object)this.committedOffset);
            if (version >= 5) {
                struct.set("committed_leader_epoch", (Object)this.committedLeaderEpoch);
            }
            struct.set("metadata", (Object)this.metadata);
            struct.set("error_code", (Object)this.errorCode);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 8;
            if (version >= 5) {
                size += 4;
            } else if (this.committedLeaderEpoch != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default committedLeaderEpoch at version " + version);
            }
            size += 2;
            if (this.metadata != null) {
                size += MessageUtil.serializedUtf8Length(this.metadata);
            }
            return size += 2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetFetchResponsePartition)) {
                return false;
            }
            OffsetFetchResponsePartition other = (OffsetFetchResponsePartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.committedOffset != other.committedOffset) {
                return false;
            }
            if (this.committedLeaderEpoch != other.committedLeaderEpoch) {
                return false;
            }
            if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
                return false;
            }
            return this.errorCode == other.errorCode;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.committedOffset >> 32) ^ (int)this.committedOffset);
            hashCode = 31 * hashCode + this.committedLeaderEpoch;
            hashCode = 31 * hashCode + (this.metadata == null ? 0 : this.metadata.hashCode());
            hashCode = 31 * hashCode + this.errorCode;
            return hashCode;
        }

        public String toString() {
            return "OffsetFetchResponsePartition(partitionIndex=" + this.partitionIndex + ", committedOffset=" + this.committedOffset + ", committedLeaderEpoch=" + this.committedLeaderEpoch + ", metadata='" + this.metadata + "', errorCode=" + this.errorCode + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long committedOffset() {
            return this.committedOffset;
        }

        public int committedLeaderEpoch() {
            return this.committedLeaderEpoch;
        }

        public String metadata() {
            return this.metadata;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public OffsetFetchResponsePartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public OffsetFetchResponsePartition setCommittedOffset(long v) {
            this.committedOffset = v;
            return this;
        }

        public OffsetFetchResponsePartition setCommittedLeaderEpoch(int v) {
            this.committedLeaderEpoch = v;
            return this;
        }

        public OffsetFetchResponsePartition setMetadata(String v) {
            this.metadata = v;
            return this;
        }

        public OffsetFetchResponsePartition setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("committed_offset", Type.INT64, "The committed message offset."), new Field("metadata", Type.NULLABLE_STRING, "The partition metadata."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error.")))));
            SCHEMA_5 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("committed_offset", Type.INT64, "The committed message offset."), new Field("committed_leader_epoch", Type.INT32, "The leader epoch."), new Field("metadata", Type.NULLABLE_STRING, "The partition metadata."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class OffsetFetchResponseTopic
    implements Message {
        private String name;
        private List<OffsetFetchResponsePartition> partitions;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public OffsetFetchResponseTopic(Readable readable, short version) {
            this.partitions = new ArrayList<OffsetFetchResponsePartition>();
            this.read(readable, version);
        }

        public OffsetFetchResponseTopic(Struct struct, short version) {
            this.partitions = new ArrayList<OffsetFetchResponsePartition>();
            this.fromStruct(struct, version);
        }

        public OffsetFetchResponseTopic() {
            this.name = "";
            this.partitions = new ArrayList<OffsetFetchResponsePartition>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions.clear();
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new OffsetFetchResponsePartition(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (OffsetFetchResponsePartition element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<OffsetFetchResponsePartition>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new OffsetFetchResponsePartition((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (OffsetFetchResponsePartition element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (OffsetFetchResponsePartition element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetFetchResponseTopic)) {
                return false;
            }
            OffsetFetchResponseTopic other = (OffsetFetchResponseTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "OffsetFetchResponseTopic(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<OffsetFetchResponsePartition> partitions() {
            return this.partitions;
        }

        public OffsetFetchResponseTopic setName(String v) {
            this.name = v;
            return this;
        }

        public OffsetFetchResponseTopic setPartitions(List<OffsetFetchResponsePartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetFetchResponsePartition.SCHEMA_0), "The responses per partition")))));
            SCHEMA_5 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetFetchResponsePartition.SCHEMA_5), "The responses per partition"));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

