/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.message;

import java.util.Arrays;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiMessage;
import shaded.alink.kafka.org.apache.kafka.common.protocol.MessageUtil;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Readable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Writable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;
import shaded.alink.kafka.org.apache.kafka.common.utils.Bytes;

public class CreateDelegationTokenResponseData
implements ApiMessage {
    private short errorCode;
    private String principalType;
    private String principalName;
    private long issueTimestampMs;
    private long expiryTimestampMs;
    private long maxTimestampMs;
    private String tokenId;
    private byte[] hmac;
    private int throttleTimeMs;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public CreateDelegationTokenResponseData(Readable readable, short version) {
        this.read(readable, version);
    }

    public CreateDelegationTokenResponseData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public CreateDelegationTokenResponseData() {
        this.errorCode = 0;
        this.principalType = "";
        this.principalName = "";
        this.issueTimestampMs = 0L;
        this.expiryTimestampMs = 0L;
        this.maxTimestampMs = 0L;
        this.tokenId = "";
        this.hmac = Bytes.EMPTY;
        this.throttleTimeMs = 0;
    }

    @Override
    public short apiKey() {
        return 38;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.errorCode = readable.readShort();
        this.principalType = readable.readNullableString();
        this.principalName = readable.readNullableString();
        this.issueTimestampMs = readable.readLong();
        this.expiryTimestampMs = readable.readLong();
        this.maxTimestampMs = readable.readLong();
        this.tokenId = readable.readNullableString();
        this.hmac = readable.readNullableBytes();
        this.throttleTimeMs = readable.readInt();
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeShort(this.errorCode);
        writable.writeString(this.principalType);
        writable.writeString(this.principalName);
        writable.writeLong(this.issueTimestampMs);
        writable.writeLong(this.expiryTimestampMs);
        writable.writeLong(this.maxTimestampMs);
        writable.writeString(this.tokenId);
        writable.writeBytes(this.hmac);
        writable.writeInt(this.throttleTimeMs);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.errorCode = struct.getShort("error_code");
        this.principalType = struct.getString("principal_type");
        this.principalName = struct.getString("principal_name");
        this.issueTimestampMs = struct.getLong("issue_timestamp_ms");
        this.expiryTimestampMs = struct.getLong("expiry_timestamp_ms");
        this.maxTimestampMs = struct.getLong("max_timestamp_ms");
        this.tokenId = struct.getString("token_id");
        this.hmac = struct.getByteArray("hmac");
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("principal_type", (Object)this.principalType);
        struct.set("principal_name", (Object)this.principalName);
        struct.set("issue_timestamp_ms", (Object)this.issueTimestampMs);
        struct.set("expiry_timestamp_ms", (Object)this.expiryTimestampMs);
        struct.set("max_timestamp_ms", (Object)this.maxTimestampMs);
        struct.set("token_id", (Object)this.tokenId);
        struct.setByteArray("hmac", this.hmac);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.principalType);
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.principalName);
        size += 8;
        size += 8;
        size += 8;
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.tokenId);
        size += 4;
        size += this.hmac.length;
        return size += 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateDelegationTokenResponseData)) {
            return false;
        }
        CreateDelegationTokenResponseData other = (CreateDelegationTokenResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.principalType == null ? other.principalType != null : !this.principalType.equals(other.principalType)) {
            return false;
        }
        if (this.principalName == null ? other.principalName != null : !this.principalName.equals(other.principalName)) {
            return false;
        }
        if (this.issueTimestampMs != other.issueTimestampMs) {
            return false;
        }
        if (this.expiryTimestampMs != other.expiryTimestampMs) {
            return false;
        }
        if (this.maxTimestampMs != other.maxTimestampMs) {
            return false;
        }
        if (this.tokenId == null ? other.tokenId != null : !this.tokenId.equals(other.tokenId)) {
            return false;
        }
        if (!Arrays.equals(this.hmac, other.hmac)) {
            return false;
        }
        return this.throttleTimeMs == other.throttleTimeMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.principalType == null ? 0 : this.principalType.hashCode());
        hashCode = 31 * hashCode + (this.principalName == null ? 0 : this.principalName.hashCode());
        hashCode = 31 * hashCode + ((int)(this.issueTimestampMs >> 32) ^ (int)this.issueTimestampMs);
        hashCode = 31 * hashCode + ((int)(this.expiryTimestampMs >> 32) ^ (int)this.expiryTimestampMs);
        hashCode = 31 * hashCode + ((int)(this.maxTimestampMs >> 32) ^ (int)this.maxTimestampMs);
        hashCode = 31 * hashCode + (this.tokenId == null ? 0 : this.tokenId.hashCode());
        hashCode = 31 * hashCode + Arrays.hashCode(this.hmac);
        hashCode = 31 * hashCode + this.throttleTimeMs;
        return hashCode;
    }

    public String toString() {
        return "CreateDelegationTokenResponseData(errorCode=" + this.errorCode + ", principalType='" + this.principalType + "', principalName='" + this.principalName + "', issueTimestampMs=" + this.issueTimestampMs + ", expiryTimestampMs=" + this.expiryTimestampMs + ", maxTimestampMs=" + this.maxTimestampMs + ", tokenId='" + this.tokenId + "', hmac=" + Arrays.toString(this.hmac) + ", throttleTimeMs=" + this.throttleTimeMs + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String principalType() {
        return this.principalType;
    }

    public String principalName() {
        return this.principalName;
    }

    public long issueTimestampMs() {
        return this.issueTimestampMs;
    }

    public long expiryTimestampMs() {
        return this.expiryTimestampMs;
    }

    public long maxTimestampMs() {
        return this.maxTimestampMs;
    }

    public String tokenId() {
        return this.tokenId;
    }

    public byte[] hmac() {
        return this.hmac;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public CreateDelegationTokenResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public CreateDelegationTokenResponseData setPrincipalType(String v) {
        this.principalType = v;
        return this;
    }

    public CreateDelegationTokenResponseData setPrincipalName(String v) {
        this.principalName = v;
        return this;
    }

    public CreateDelegationTokenResponseData setIssueTimestampMs(long v) {
        this.issueTimestampMs = v;
        return this;
    }

    public CreateDelegationTokenResponseData setExpiryTimestampMs(long v) {
        this.expiryTimestampMs = v;
        return this;
    }

    public CreateDelegationTokenResponseData setMaxTimestampMs(long v) {
        this.maxTimestampMs = v;
        return this;
    }

    public CreateDelegationTokenResponseData setTokenId(String v) {
        this.tokenId = v;
        return this;
    }

    public CreateDelegationTokenResponseData setHmac(byte[] v) {
        this.hmac = v;
        return this;
    }

    public CreateDelegationTokenResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The top-level error, or zero if there was no error."), new Field("principal_type", Type.STRING, "The principal type of the token owner."), new Field("principal_name", Type.STRING, "The name of the token owner."), new Field("issue_timestamp_ms", Type.INT64, "When this token was generated."), new Field("expiry_timestamp_ms", Type.INT64, "When this token expires."), new Field("max_timestamp_ms", Type.INT64, "The maximum lifetime of this token."), new Field("token_id", Type.STRING, "The token UUID."), new Field("hmac", Type.BYTES, "HMAC of the delegation token."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

