/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.clients;

import java.io.IOException;
import java.util.List;
import shaded.alink.kafka.org.apache.kafka.clients.ClientRequest;
import shaded.alink.kafka.org.apache.kafka.clients.ClientResponse;
import shaded.alink.kafka.org.apache.kafka.clients.KafkaClient;
import shaded.alink.kafka.org.apache.kafka.common.Node;
import shaded.alink.kafka.org.apache.kafka.common.errors.DisconnectException;
import shaded.alink.kafka.org.apache.kafka.common.utils.Time;

public final class NetworkClientUtils {
    private NetworkClientUtils() {
    }

    public static boolean isReady(KafkaClient client, Node node, long currentTime) {
        client.poll(0L, currentTime);
        return client.isReady(node, currentTime);
    }

    public static boolean awaitReady(KafkaClient client, Node node, Time time, long timeoutMs) throws IOException {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("Timeout needs to be greater than 0");
        }
        long startTime = time.milliseconds();
        long expiryTime = startTime + timeoutMs;
        if (NetworkClientUtils.isReady(client, node, startTime) || client.ready(node, startTime)) {
            return true;
        }
        long attemptStartTime = time.milliseconds();
        while (!client.isReady(node, attemptStartTime) && attemptStartTime < expiryTime) {
            if (client.connectionFailed(node)) {
                throw new IOException("Connection to " + node + " failed.");
            }
            long pollTimeout = expiryTime - attemptStartTime;
            client.poll(pollTimeout, attemptStartTime);
            if (client.authenticationException(node) != null) {
                throw client.authenticationException(node);
            }
            attemptStartTime = time.milliseconds();
        }
        return client.isReady(node, attemptStartTime);
    }

    public static ClientResponse sendAndReceive(KafkaClient client, ClientRequest request, Time time) throws IOException {
        try {
            client.send(request, time.milliseconds());
            while (client.active()) {
                List<ClientResponse> responses = client.poll(Long.MAX_VALUE, time.milliseconds());
                for (ClientResponse response : responses) {
                    if (response.requestHeader().correlationId() != request.correlationId()) continue;
                    if (response.wasDisconnected()) {
                        throw new IOException("Connection to " + response.destination() + " was disconnected before the response was read");
                    }
                    if (response.versionMismatch() != null) {
                        throw response.versionMismatch();
                    }
                    return response;
                }
            }
            throw new IOException("Client was shutdown before response was read");
        }
        catch (DisconnectException e) {
            if (client.active()) {
                throw e;
            }
            throw new IOException("Client was shutdown before response was read");
        }
    }
}

