/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.operator.common.io.kafka;

import com.alibaba.alink.operator.common.io.kafka.BaseKafkaSourceBuilder;
import com.alibaba.alink.operator.common.io.kafka.KafkaMessageDeserialization;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.types.Row;
import org.apache.flink.util.StringUtils;
import shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer;
import shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import shaded.alink.kafka.org.apache.kafka.clients.consumer.ConsumerRecord;

public final class KafkaSourceBuilder
extends BaseKafkaSourceBuilder {
    @Override
    public RichParallelSourceFunction<Row> build() {
        FlinkKafkaConsumer<Row> consumer;
        if (!StringUtils.isNullOrWhitespaceOnly((String)this.topicPattern)) {
            Pattern pattern = Pattern.compile(this.topicPattern);
            consumer = new FlinkKafkaConsumer<Row>(pattern, new MessageDeserialization(), this.properties);
        } else {
            consumer = new FlinkKafkaConsumer<Row>((List<String>)this.topic, new MessageDeserialization(), this.properties);
        }
        switch (this.startupMode) {
            case LATEST: {
                consumer.setStartFromLatest();
                break;
            }
            case EARLIEST: {
                consumer.setStartFromEarliest();
                break;
            }
            case GROUP_OFFSETS: {
                consumer.setStartFromGroupOffsets();
                break;
            }
            case TIMESTAMP: {
                consumer.setStartFromTimestamp(this.startTimeMs);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid startupMode.");
            }
        }
        return consumer;
    }

    private static class MessageDeserialization
    implements KafkaDeserializationSchema<Row> {
        private MessageDeserialization() {
        }

        @Override
        public boolean isEndOfStream(Row nextElement) {
            return false;
        }

        @Override
        public Row deserialize(ConsumerRecord<byte[], byte[]> record) throws Exception {
            return KafkaMessageDeserialization.deserialize(record.key(), record.value(), record.topic(), record.partition(), record.offset());
        }

        public TypeInformation<Row> getProducedType() {
            return new RowTypeInfo(KafkaMessageDeserialization.KAFKA_SRC_FIELD_TYPES, KafkaMessageDeserialization.KAFKA_SRC_FIELD_NAMES);
        }
    }
}

