/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.util;

import com.alibaba.alink.executor.util.JsonUtil;
import com.alibaba.alink.operator.batch.BatchOperator;
import com.alibaba.alink.operator.stream.StreamOperator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.ml.api.misc.param.Params;

public class StreamOpUtil {
    public static StreamOperator makeStreamOp(String clsName, Params param) throws Exception {
        if (clsName.startsWith("com.alibaba.alink")) {
            Class<?> cls = Class.forName(clsName);
            Constructor<?> init = cls.getConstructor(Params.class);
            try {
                return (StreamOperator)init.newInstance(param);
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getCause();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof Exception) {
                    throw (Exception)ex;
                }
                throw e;
            }
        }
        throw new RuntimeException("invalid clsName: " + clsName);
    }

    public static StreamOperator makeOp(String clsName, Map<String, String> param, List<Object> rawList) throws Exception {
        return StreamOpUtil.makeOp(clsName, JsonUtil.convertToAlinkParameter(param), rawList);
    }

    public static StreamOperator makeOp(String clsName, Params param, List<Object> rawList) throws Exception {
        if (StreamOpUtil.checkHasModel(clsName)) {
            if (rawList.isEmpty()) {
                throw new RuntimeException(String.format("Operator[%s] has no input edge.", clsName));
            }
            BatchOperator model = (BatchOperator)rawList.get(0);
            ArrayList<StreamOperator> inList = new ArrayList<StreamOperator>();
            for (int i = 1; i < rawList.size(); ++i) {
                inList.add((StreamOperator)rawList.get(i));
            }
            Class<?> cls = Class.forName(clsName);
            Constructor<?> init = cls.getConstructor(BatchOperator.class, Params.class);
            try {
                StreamOperator ret = (StreamOperator)init.newInstance(model, param);
                ret.linkFrom(inList);
                return ret;
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getCause();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof Exception) {
                    throw (Exception)ex;
                }
                throw e;
            }
        }
        ArrayList<StreamOperator> inList = new ArrayList<StreamOperator>();
        for (int i = 0; i < rawList.size(); ++i) {
            inList.add((StreamOperator)rawList.get(i));
        }
        StreamOperator op = StreamOpUtil.makeStreamOp(clsName, param);
        op.linkFrom(inList);
        return op;
    }

    public static boolean checkHasModel(String clsName) throws ClassNotFoundException {
        if (clsName.startsWith("com.alibaba.alink")) {
            Class<?> cls = Class.forName(clsName);
            try {
                Constructor<?> init = cls.getConstructor(BatchOperator.class, Params.class);
                return init != null;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        throw new RuntimeException("invalid className: " + clsName);
    }
}

