/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.python;

import com.alibaba.alink.executor.python.PythonSideMain;
import com.alibaba.alink.executor.python.util.FileUtil;
import com.alibaba.alink.executor.python.util.TarFileUtil;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.GatewayServer;

public class PythonBridge {
    private static final Logger LOG = LoggerFactory.getLogger(PythonBridge.class);
    private static final String ALINK_RUNNER_RESOURCE_NAME = "/alink_python_runner.tar.gz";
    private static final String ALINK_RUNNER_DIR = "alink_workspace";
    private static final String EXTRA_PACKAGE_DIR = "extra";
    private static final String TMP_FILE_DIR = "tmp";
    private static final String ALINK_SYS_DIR = "sys";
    private static final String ALINK_USER_DIR = "user";
    private static final String RES_SYS_PREFIX = "/alink_sys_pkg";
    private static final String RES_USER_PREFIX = "/alink_user_pkg";
    private static PythonBridge inst = null;
    volatile boolean initialized = false;
    volatile boolean ready = false;
    volatile int jvmPort = 0;
    volatile int pythonPort = 0;
    volatile GatewayServer server;
    volatile Process process;
    volatile PythonSideMain app;
    volatile boolean alreadyAddHook = false;
    volatile String rootDir = null;
    Map<String, String> extraEnv = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PythonBridge inst() {
        if (inst != null) return inst;
        Class<PythonBridge> clazz = PythonBridge.class;
        synchronized (PythonBridge.class) {
            if (inst != null) return inst;
            inst = new PythonBridge();
            // ** MonitorExit[var0] (shouldn't be in output)
            return inst;
        }
    }

    private PythonBridge() {
    }

    String formatCmd(String cmd) {
        try {
            Class<?> cls = Class.forName("com.alibaba.alink.python.PyMain");
            if (cls == null) {
                return "python";
            }
            Method m = cls.getMethod("setupPythonEnv", String.class);
            if (this.rootDir == null) {
                try {
                    this.rootDir = Files.createTempDirectory(Paths.get(".", new String[0]), "tmp_py_", new FileAttribute[0]).toFile().getAbsolutePath();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to createTempDirectory");
                }
            }
            m.invoke(null, this.rootDir);
            return Paths.get(this.rootDir, cmd).toFile().getAbsolutePath();
        }
        catch (ClassNotFoundException e) {
            return "python";
        }
        catch (NoSuchMethodException e) {
            return cmd.startsWith("/") ? cmd : Paths.get(cmd, new String[0]).toFile().getAbsolutePath();
        }
        catch (IllegalAccessException e) {
            return cmd.startsWith("/") ? cmd : Paths.get(cmd, new String[0]).toFile().getAbsolutePath();
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    void startProcess(String cmd) {
        this.prepareEnv();
        LOG.info("begin to start PythonProcess {} -j {} -p {}", new Object[]{cmd, this.jvmPort, this.pythonPort});
        ProcessBuilder pb = new ProcessBuilder(this.getPythonCmd(), "-c", "from alink.py4j_gateway import main;main()", "-j", Integer.toString(this.jvmPort), "-p", Integer.toString(this.pythonPort));
        LOG.info("the command is: " + String.join((CharSequence)" ", pb.command()));
        Map<String, String> env = pb.environment();
        env.remove("LD_PRELOAD");
        this.updateEnv(env, this.extraEnv);
        pb.directory(new File(this.getAlinkWorkDir()));
        pb.redirectErrorStream(true);
        try {
            this.process = pb.start();
            this.waitProcessStarted(this.process, "Started Listening On");
            PythonBridge.inheritIO(this.process.getInputStream(), line -> LOG.info("PYTHON: {}", line));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!this.alreadyAddHook) {
            this.alreadyAddHook = true;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    PythonBridge.this.stopProcess();
                }
            });
        }
    }

    private void updateEnv(Map<String, String> env, Map<String, String> extra) {
        for (Map.Entry<String, String> e : extra.entrySet()) {
            if (e.getKey().endsWith("PATH")) {
                String old = env.getOrDefault(e.getKey(), "");
                env.put(e.getKey(), e.getValue() + ":" + old);
                continue;
            }
            env.put(e.getKey(), e.getValue());
        }
    }

    private static Thread inheritIO(final InputStream src, final Consumer<String> consumer) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Scanner sc = new Scanner(src);
                while (sc.hasNextLine() && !Thread.currentThread().isInterrupted()) {
                    consumer.accept(sc.nextLine());
                }
            }
        });
        t.setDaemon(true);
        t.start();
        return t;
    }

    void waitProcessStarted(Process p, String targetString) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (p.isAlive()) {
            sb.setLength(0);
            InputStream in = p.getInputStream();
            int c = 0;
            while ((c = in.read()) != -1 && c != 13 && c != 10) {
                sb.append((char)c);
            }
            String line = sb.toString();
            if (line.isEmpty()) continue;
            LOG.info("subprocess print: {}", (Object)line);
            if (!line.startsWith(targetString)) continue;
            LOG.info("subprocess is started");
            return;
        }
        throw new RuntimeException("the process is terminated.");
    }

    private void stopProcess() {
        if (this.process == null) {
            return;
        }
        LOG.info("the process's status is {}", (Object)this.process.isAlive());
        this.process.destroy();
        try {
            this.process.waitFor(50L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.process.isAlive()) {
            this.process.destroyForcibly();
        }
        LOG.info("the process has been killed");
        this.process = null;
    }

    boolean isRunning() {
        if (this.process != null && this.server != null && this.app != null) {
            return this.app.check();
        }
        return false;
    }

    private String getAlinkSysDir() {
        File f = Paths.get(this.rootDir, ALINK_SYS_DIR).toFile();
        return f.getAbsolutePath();
    }

    private String getPythonCmd() {
        File f = Paths.get(this.getAlinkSysDir(), "bin", "python").toFile();
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        String alinkPythonExecutable = System.getenv("ALINK_PYTHON_EXECUTABLE");
        if (StringUtils.isNotBlank((CharSequence)alinkPythonExecutable)) {
            return alinkPythonExecutable;
        }
        boolean hasPython3 = false;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command("python3", "-V").redirectOutput(ProcessBuilder.Redirect.PIPE);
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            String output = IOUtils.toString((InputStream)inputStream);
            System.out.println("python3 -V has output " + output);
            hasPython3 = output.startsWith("Python 3.");
        }
        catch (IOException e) {
            LOG.info("Cannot execute python3 -V", (Throwable)e);
        }
        return hasPython3 ? "python3" : "python";
    }

    private void setupPythonBaseEnv() {
        String stateName = ".python_sys_env__";
        File dstDir = new File(this.getAlinkSysDir());
        if (this.isFinished(".python_sys_env__")) {
            LOG.info("the PythonBaseEnv is already prepared.");
            this.addPathToEnv("PATH", Paths.get(this.getAlinkSysDir(), "bin").toFile().getAbsolutePath());
            return;
        }
        try (ScanResult res = new ClassGraph().whitelistPaths(RES_SYS_PREFIX).scan();){
            ResourceList list = res.getResourcesWithPath("/alink_sys_pkg/python_env.tar.gz");
            if (list.isEmpty()) {
                return;
            }
            if (list.size() != 1) {
                throw new RuntimeException("Found multiple python_env.tar.gz");
            }
            File localFile = Paths.get(this.getTmpFileDir(), "python_env.tar.gz").toFile();
            try (Resource r = (Resource)list.get(0);
                 InputStream is = r.open();){
                FileUtil.writeToFile(is, localFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            TarFileUtil.unTar(localFile, dstDir);
            this.appendPathToEnv("PATH", Paths.get(this.getAlinkSysDir(), "bin").toFile().getAbsolutePath());
            this.markFinished(".python_sys_env__");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void prepareEnv() {
        if (this.rootDir == null) {
            try {
                new File(".tmp").mkdirs();
                this.rootDir = Files.createTempDirectory(Paths.get(".tmp", new String[0]), "tmp_py_", new FileAttribute[0]).toFile().getAbsolutePath();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create TempDirectory");
            }
            Paths.get(this.rootDir, TMP_FILE_DIR).toFile().mkdirs();
            Paths.get(this.rootDir, ALINK_RUNNER_DIR).toFile().mkdirs();
            Paths.get(this.rootDir, EXTRA_PACKAGE_DIR).toFile().mkdirs();
            Paths.get(this.rootDir, ALINK_SYS_DIR).toFile().mkdirs();
            Paths.get(this.rootDir, ALINK_USER_DIR).toFile().mkdirs();
        }
        this.setupPythonBaseEnv();
        this.setupAlinkPythonRunner();
        this.extractPackages();
    }

    private String getAlinkWorkDir() {
        return Paths.get(this.rootDir, ALINK_USER_DIR).toFile().getAbsolutePath();
    }

    private String getTmpFileDir() {
        return Paths.get(this.rootDir, TMP_FILE_DIR).toFile().getAbsolutePath();
    }

    private static String getLastName(String resPath) {
        int idx = resPath.lastIndexOf(47);
        return idx >= 0 ? resPath.substring(idx + 1) : resPath;
    }

    private void extractPackages() {
        try (ScanResult scanResult = new ClassGraph().whitelistPaths(RES_USER_PREFIX).scan();){
            Files.write(Paths.get(this.getAlinkWorkDir(), "__init__.py"), "".getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            ResourceList list = scanResult.getAllResources();
            for (Resource res : list) {
                try {
                    String resName = PythonBridge.getLastName(res.getPath());
                    File dstDir = Paths.get(this.getAlinkWorkDir(), resName).toFile();
                    if (this.isFinished(resName)) {
                        LOG.info("the resource:{} is already prepared", (Object)resName);
                        this.addPathToEnv("PYTHONPATH", dstDir.getAbsolutePath());
                        continue;
                    }
                    File tarFile = Paths.get(this.getTmpFileDir(), resName).toFile();
                    try (InputStream is = res.open();){
                        FileUtil.writeToFile(is, tarFile);
                    }
                    dstDir.mkdirs();
                    if (resName.endsWith(".tar.gz")) {
                        TarFileUtil.unTar(tarFile, dstDir);
                    } else {
                        if (resName.endsWith(".py")) {
                            Files.write(Paths.get(dstDir.getAbsolutePath(), "__init__.py"), "".getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                        }
                        Files.move(Paths.get(tarFile.getAbsolutePath(), new String[0]), Paths.get(dstDir.getAbsolutePath(), resName), StandardCopyOption.REPLACE_EXISTING);
                    }
                    this.appendPathToEnv("PYTHONPATH", dstDir.getAbsolutePath());
                    this.markFinished(resName);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    res.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendPathToEnv(String key, String path) {
        if (this.extraEnv.containsKey(key)) {
            this.extraEnv.put(key, path + ":" + this.extraEnv.get(key));
        } else {
            this.extraEnv.put(key, path);
        }
    }

    private void addPathToEnv(String key, String path) {
        if (this.extraEnv.containsKey(key)) {
            String old = this.extraEnv.get(key);
            if (!Arrays.asList(old.split(":")).contains(path)) {
                this.extraEnv.put(key, path + ":" + this.extraEnv.get(key));
            }
        } else {
            this.extraEnv.put(key, path);
        }
    }

    private void markFinished(String name) {
        name = name.replace('/', '_');
        File stateDir = new File(this.getTmpFileDir(), ".alink_state");
        stateDir.mkdirs();
        File doneFile = new File(stateDir, name);
        if (!doneFile.exists()) {
            try {
                Files.write(Paths.get(doneFile.getAbsolutePath(), new String[0]), "".getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (Exception ex) {
                LOG.warn("write file:{} failed", (Object)doneFile, (Object)ex);
            }
        }
    }

    private boolean isFinished(String name) {
        name = name.replace('/', '_');
        File stateDir = new File(this.getTmpFileDir(), ".alink_state");
        File doneFile = new File(stateDir, name);
        return doneFile.exists();
    }

    private void setupAlinkPythonRunner() {
        String stateName = ".alink_python_runner__";
        File dst = Paths.get(this.rootDir, ALINK_RUNNER_DIR).toFile();
        if (this.isFinished(stateName)) {
            this.addPathToEnv("PYTHONPATH", dst.getAbsolutePath());
            LOG.info("the alink_python_runner is already prepared.");
            return;
        }
        File f = Paths.get(this.getTmpFileDir(), "alink_python_runner.tar.gz").toFile();
        LOG.info("the tmpFile is: {}", (Object)f.getAbsolutePath());
        try (InputStream in = this.getClass().getResourceAsStream(ALINK_RUNNER_RESOURCE_NAME);
             FileOutputStream fos = new FileOutputStream(f);){
            IOUtils.copyLarge((InputStream)in, (OutputStream)fos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            TarFileUtil.unTar(f, dst);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.appendPathToEnv("PYTHONPATH", dst.getAbsolutePath());
        this.markFinished(stateName);
    }

    public synchronized void open(String name, String cmd, int jvmPort, int pythonPort, int connectTimeout, int readTimeout, boolean turnOnLogging) {
        LOG.info("open bridge with {}", (Object)name);
        if (!this.isRunning()) {
            if (jvmPort < 1) {
                jvmPort = this.findRandomOpenPortOnAllLocalInterfaces();
            }
            if (pythonPort < 1) {
                pythonPort = this.findRandomOpenPortOnAllLocalInterfaces();
            }
            this.jvmPort = jvmPort;
            this.pythonPort = pythonPort;
            this.startProcess(cmd);
            GatewayServer.turnLoggingOn();
            GatewayServer.turnAllLoggingOn();
            if (turnOnLogging) {
                GatewayServer.turnLoggingOn();
                GatewayServer.turnAllLoggingOn();
            } else {
                GatewayServer.turnLoggingOff();
            }
            this.server = new GatewayServer(null, this.jvmPort, this.pythonPort, connectTimeout, readTimeout, null);
            this.server.start();
            this.app = (PythonSideMain)this.server.getPythonServerEntryPoint(new Class[]{PythonSideMain.class});
        }
        int n = this.app.open(name);
        LOG.info("the bridge[{}] is running, concurrent:{}", (Object)name, (Object)n);
    }

    public synchronized void close(String name) {
        int n = this.app.close(name);
        LOG.info("close bridge from {}, concurrent:{}", (Object)name, (Object)n);
        if (this.app.shutdown(name)) {
            LOG.info("shutdown bridge from {}", (Object)name);
            this.server.shutdown();
            this.app = null;
            this.stopProcess();
        }
    }

    public PythonSideMain app() {
        return this.app;
    }

    public GatewayServer server() {
        return this.server;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer findRandomOpenPortOnAllLocalInterfaces() {
        try (ServerSocket socket = new ServerSocket(0);){
            Integer n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        PythonBridge.inst().open("A", "/Users/zhangkai/IdeaProjects/flink_dev/pyalink/start_py4j.sh", 0, 0, 3000, 3000, true);
        PythonBridge.inst().open("B", "/Users/zhangkai/IdeaProjects/flink_dev/pyalink/start_py4j.sh", 0, 0, 3000, 3000, true);
        PythonSideMain app = PythonBridge.inst().app();
        boolean tag = PythonBridge.inst().app().check();
        LOG.info("check {}", (Object)tag);
        PythonBridge.inst().close("A");
        PythonBridge.inst().close("B");
    }
}

