##########################################################################################
# julian/_TIMEZONES.py
##########################################################################################
"""Dictionary of time zone abbreviations and their meanings.

Content excerpted from
    https://en.wikipedia.org/wiki/List_of_time_zone_abbreviations
on June 7, 2023.
"""
##########################################################################################

TIMEZONES = {
    "ACDT": "+10:30",
    "ACST": "+09:30",
    "ACT" : "-05",
    "ACWS": "+08:45",
    "ADT" : "-03",
    "AEDT": "+11",
    "AEST": "+10",
    "AFT" : "+04:30",
    "AKDT": "-08",
    "AKST": "-09",
    "ALMT": "+06",
    "AMST": "-03",
    "ANAT": "+12",
    "AQTT": "+05",
    "ART" : "-03",
    "AST" : "-04",
    "AWST": "+08",
    "AZOS": "+00",
    "AZOT": "-01",
    "AZT" : "+04",
    "BNT" : "+08",
    "BIOT": "+06",
    "BIT" : "-12",
    "BOT" : "-04",
    "BRST": "-02",
    "BRT" : "-03",
    "BST" : "+01",
    "BTT" : "+06",
    "CAT" : "+02",
    "CCT" : "+06:30",
    "CDT" : "-05",
    "CEST": "+02",
    "CET" : "+01",
    "CHAD": "+13:45",
    "CHAS": "+12:45",
    "CHOT": "+08",
    "CHOS": "+09",
    "CHST": "+10",
    "CHUT": "+10",
    "CIST": "-08",
    "CKT" : "-10",
    "CLST": "-03",
    "CLT" : "-04",
    "COST": "-04",
    "COT" : "-05",
    "CST" : "-06",
    "CVT" : "-01",
    "CWST": "+08:45",
    "CXT" : "+07",
    "DAVT": "+07",
    "DDUT": "+10",
    "DFT" : "+01",
    "EASS": "-05",
    "EAST": "-06",
    "EAT" : "+03",
    "EDT" : "-04",
    "EEST": "+03",
    "EET" : "+02",
    "EGST": "+00",
    "EGT" : "-01",
    "EST" : "-05",
    "FET" : "+03",
    "FJT" : "+12",
    "FKST": "-03",
    "FKT" : "-04",
    "FNT" : "-02",
    "GALT": "-06",
    "GAMT": "-09",
    "GET" : "+04",
    "GFT" : "-03",
    "GILT": "+12",
    "GIT" : "-09",
    "GMT" : "+00",
    "GYT" : "-04",
    "HDT" : "-09",
    "HAEC": "+02",
    "HST" : "-10",
    "HKT" : "+08",
    "HMT" : "+05",
    "HOVT": "+07",
    "ICT" : "+07",
    "IDLW": "-12",
    "IDT" : "+03",
    "IOT" : "+03",
    "IRDT": "+04:30",
    "IRKT": "+08",
    "IRST": "+03:30",
    "JST" : "+09",
    "KALT": "+02",
    "KGT" : "+06",
    "KOST": "+11",
    "KRAT": "+07",
    "KST" : "+09",
    "LINT": "+14",
    "MAGT": "+12",
    "MART": "-09:30",
    "MAWT": "+05",
    "MDT" : "-06",
    "MET" : "+01",
    "MEST": "+02",
    "MHT" : "+12",
    "MIST": "+11",
    "MIT" : "-09:30",
    "MMT" : "+06:30",
    "MSK" : "+03",
    "MST" : "-07",
    "MUT" : "+04",
    "MVT" : "+05",
    "MYT" : "+08",
    "NCT" : "+11",
    "NDT" : "-02:30",
    "NFT" : "+11",
    "NOVT": "+07",
    "NPT" : "+05:45",
    "NST" : "-03:30",
    "NT"  : "-03:30",
    "NUT" : "-11",
    "NZDT": "+13",
    "NZST": "+12",
    "OMST": "+06",
    "ORAT": "+05",
    "PDT" : "-07",
    "PET" : "-05",
    "PETT": "+12",
    "PGT" : "+10",
    "PHOT": "+13",
    "PHT" : "+08",
    "PHST": "+08",
    "PKT" : "+05",
    "PMDT": "-02",
    "PMST": "-03",
    "PONT": "+11",
    "PST" : "-08",
    "PWT" : "+09",
    "PYST": "-03",
    "PYT" : "-04",
    "RET" : "+04",
    "ROTT": "-03",
    "SAKT": "+11",
    "SAMT": "+04",
    "SAST": "+02",
    "SBT" : "+11",
    "SCT" : "+04",
    "SDT" : "-10",
    "SGT" : "+08",
    "SLST": "+05:30",
    "SRET": "+11",
    "SRT" : "-03",
#     "SST" : "-11",    ambiguous
#     "SST" : "+08",
    "SYOT": "+03",
    "TAHT": "-10",
    "THA" : "+07",
    "TFT" : "+05",
    "TJT" : "+05",
    "TKT" : "+13",
    "TLT" : "+09",
    "TMT" : "+05",
    "TRT" : "+03",
    "TOT" : "+13",
    "TVT" : "+12",
    "ULAS": "+09",
    "ULAT": "+08",
    "UTC" : "+00",
    "UYST": "-02",
    "UYT" : "-03",
    "UZT" : "+05",
    "VET" : "-04",
    "VLAT": "+10",
    "VOLT": "+03",
    "VOST": "+06",
    "VUT" : "+11",
    "WAKT": "+12",
    "WAST": "+02",
    "WAT" : "+01",
    "WEST": "+01",
    "WET" : "+00",
    "WIB" : "+07",
    "WIT" : "+09",
    "WITA": "+08",
    "WGST": "-02",
    "WGT" : "-03",
    "WST" : "+08",
    "YAKT": "+09",
    "YEKT": "+05",
    "Z"   : "+00",
}

##########################################################################################

