TEMPLATE_ENV_PY = """import os

from qdrant_client import QdrantClient

# --- Configuration ---
# This is where you connect the migration tool to your application's settings.
# You might import your standard Pydantic settings object here.
# e.g.: from app.settings import settings

QDRANT_URL = os.getenv("QDRANT_URL", "http://localhost:6333")
QDRANT_API_KEY = os.getenv("QDRANT_API_KEY")


def get_qdrant_client() -> QdrantClient:
    \"\"\"Creates and returns an instance of the asynchronous Qdrant client.

    Customize this to add timeouts, custom headers, or use gRPC if needed.
    \"\"\"
    return QdrantClient(url=QDRANT_URL, api_key=QDRANT_API_KEY)


def run_migrations_online(run_migration_fn) -> None:
    \"\"\"The main execution context for migrations.

    It sets up the client, runs the migration task, and ensures cleanup.

    Args:
        run_migration_fn (_type_): The callback provided by the migration runner.
    \"\"\"
    client = get_qdrant_client()
    try:
        # Execute the migration task with the configured client
        run_migration_fn(client=client)
    finally:
        # Ensure connections are always closed, even on error
        client.close()
"""


TEMPLATE_SCRIPT_MAKO = """\"\"\"${description}

Revision ID: ${revision}
Revises: ${revises}
Create Date: ${created_at}
\"\"\"

from qdrant_client import QdrantClient, models

# revision identifiers, used by the migration tool
revision = "${revision}"
down_revision = "${revises or None}"


def upgrade(client: QdrantClient) -> None:
    # ### commands auto-generated by Orthant - please adjust! ###
    pass
    # ### end Orthant commands ###


def downgrade(client: QdrantClient) -> None:
    # ### commands auto-generated by Orthant - please adjust! ###
    pass
    # ### end Orthant commands ###
"""

TEMPLATE_README = """# Orthant - Qdrant Migration Tool

This directory contains migration scripts for ensuring the Qdrant vector database schema (collections, indexes, payload schema) matches the application code.

## Structure

* `versions/`: Holds the individual migration scripts.
* `env.py`: Configuration file. This is where you customize how the tool connects to Qdrant.
* `script.py.mako`: The template used when generating new migrations.
* `.VERSION_INDEX`: Tracks the currently applied revision ID. DO NOT EDIT MANUALLY.
"""
