mimetypes = [
    ["Andrew Toolkit", "application/andrew-inset", None],
    ["Applixware", "application/applixware", ".aw"],
    ["Atom Syndication Format", "application/atom+xml", ".atom"],
    ["Atom Publishing Protocol", "application/atomcat+xml", ".atomcat"],
    [
        "Atom Publishing Protocol Service Document",
        "application/atomsvc+xml",
        ".atomsvc",
    ],
    ["Voice Browser Call Control", "application/ccxml+xml,", ".ccxml"],
    [
        "Cloud Data Management Interface (CDMI) - Capability",
        "application/cdmi-capability",
        ".cdmia",
    ],
    [
        "Cloud Data Management Interface (CDMI) - Contaimer",
        "application/cdmi-container",
        ".cdmic",
    ],
    [
        "Cloud Data Management Interface (CDMI) - Domain",
        "application/cdmi-domain",
        ".cdmid",
    ],
    [
        "Cloud Data Management Interface (CDMI) - Object",
        "application/cdmi-object",
        ".cdmio",
    ],
    [
        "Cloud Data Management Interface (CDMI) - Queue",
        "application/cdmi-queue",
        ".cdmiq",
    ],
    ["CU-SeeMe", "application/cu-seeme", ".cu"],
    [
        "Web Distributed Authoring and Versioning",
        "application/davmount+xml",
        ".davmount",
    ],
    [
        "Data Structure for the Security Suitability of Cryptographic Algorithms",
        "application/dssc+der",
        ".dssc",
    ],
    [
        "Data Structure for the Security Suitability of Cryptographic Algorithms",
        "application/dssc+xml",
        ".xdssc",
    ],
    ["ECMAScript", "application/ecmascript", ".es"],
    ["Extensible MultiModal Annotation", "application/emma+xml", ".emma"],
    ["Electronic Publication", "application/epub+zip", ".epub"],
    ["Efficient XML Interchange", "application/exi", ".exi"],
    ["Portable Font Resource", "application/font-tdpfr", ".pfr"],
    ["Hyperstudio", "application/hyperstudio", ".stk"],
    ["Internet Protocol Flow Information Export", "application/ipfix", ".ipfix"],
    ["Java Archive", "application/java-archive", ".jar"],
    ["Java Serialized Object", "application/java-serialized-object", ".ser"],
    ["Java Bytecode File", "application/java-vm", ".class"],
    ["JavaScript", "application/javascript", ".js"],
    ["JavaScript Object Notation (JSON)", "application/json", ".json"],
    ["Macintosh BinHex 4.0", "application/mac-binhex40", ".hqx"],
    ["Compact Pro", "application/mac-compactpro", ".cpt"],
    ["Metadata Authority  Description Schema", "application/mads+xml", ".mads"],
    ["MARC Formats", "application/marc", ".mrc"],
    ["MARC21 XML Schema", "application/marcxml+xml", ".mrcx"],
    ["Mathematica Notebooks", "application/mathematica", ".ma"],
    ["Mathematical Markup Language", "application/mathml+xml", ".mathml"],
    ["Mbox database files", "application/mbox", ".mbox"],
    [
        "Media Server Control Markup Language",
        "application/mediaservercontrol+xml",
        ".mscml",
    ],
    ["Metalink", "application/metalink4+xml", ".meta4"],
    ["Metadata Encoding and Transmission Standard", "application/mets+xml", ".mets"],
    ["Metadata Object Description Schema", "application/mods+xml", ".mods"],
    ["MPEG-21", "application/mp21", ".m21"],
    ["MPEG4", "application/mp4", ".mp4"],
    ["Microsoft Word", "application/msword", ".doc"],
    ["Material Exchange Format", "application/mxf", ".mxf"],
    ["Binary Data", "application/octet-stream", None],
    ["Office Document Architecture", "application/oda", ".oda"],
    ["Open eBook Publication Structure", "application/oebps-package+xml", ".opf"],
    ["Ogg", "application/ogg", ".ogx"],
    ["Microsoft OneNote", "application/onenote", ".onetoc"],
    ["XML Patch Framework", "application/patch-ops-error+xml", ".xer"],
    ["Adobe Portable Document Format", "application/pdf", ".pdf"],
    ["Pretty Good Privacy", "application/pgp-encrypted", ".pgp"],
    ["Pretty Good Privacy - Signature", "application/pgp-signature", ".pgp"],
    ["PICSRules", "application/pics-rules", ".prf"],
    ["PKCS #10 - Certification Request Standard", "application/pkcs10", ".p10"],
    [
        "PKCS #7 - Cryptographic Message Syntax Standard",
        "application/pkcs7-mime",
        ".p7m",
    ],
    [
        "PKCS #7 - Cryptographic Message Syntax Standard",
        "application/pkcs7-signature",
        ".p7s",
    ],
    ["PKCS #8 - Private-Key Information Syntax Standard", "application/pkcs8", ".p8"],
    ["Attribute Certificate", "application/pkix-attr-cert", ".ac"],
    [
        "Internet Public Key Infrastructure - Certificate",
        "application/pkix-cert",
        ".cer",
    ],
    [
        "Internet Public Key Infrastructure - Certificate Revocation Lists",
        "application/pkix-crl",
        ".crl",
    ],
    [
        "Internet Public Key Infrastructure - Certification Path",
        "application/pkix-pkipath",
        ".pkipath",
    ],
    [
        "Internet Public Key Infrastructure - Certificate Management Protocole",
        "application/pkixcmp",
        ".pki",
    ],
    ["Pronunciation Lexicon Specification", "application/pls+xml", ".pls"],
    ["PostScript", "application/postscript", ".ai"],
    ["CU-Writer", "application/prs.cww", ".cww"],
    ["Portable Symmetric Key Container", "application/pskc+xml", ".pskcxml"],
    ["Resource Description Framework", "application/rdf+xml", ".rdf"],
    ["IMS Networks", "application/reginfo+xml", ".rif"],
    ["Relax NG Compact Syntax", "application/relax-ng-compact-syntax", ".rnc"],
    ["XML Resource Lists", "application/resource-lists+xml", ".rl"],
    ["XML Resource Lists Diff", "application/resource-lists-diff+xml", ".rld"],
    ["XML Resource Lists", "application/rls-services+xml", ".rs"],
    ["Really Simple Discovery", "application/rsd+xml", ".rsd"],
    ["RSS - Really Simple Syndication", "application/rss+xml", ".rss"],
    ["Rich Text Format", "application/rtf", ".rtf"],
    ["Systems Biology Markup Language", "application/sbml+xml", ".sbml"],
    [
        "Server-Based Certificate Validation Protocol - Validation Request",
        "application/scvp-cv-request",
        ".scq",
    ],
    [
        "Server-Based Certificate Validation Protocol - Validation Response",
        "application/scvp-cv-response",
        ".scs",
    ],
    [
        "Server-Based Certificate Validation Protocol - Validation Policies - Request",
        "application/scvp-vp-request",
        ".spq",
    ],
    [
        "Server-Based Certificate Validation Protocol - Validation Policies - Response",
        "application/scvp-vp-response",
        ".spp",
    ],
    ["Session Description Protocol", "application/sdp", ".sdp"],
    [
        "Secure Electronic Transaction - Payment",
        "application/set-payment-initiation",
        ".setpay",
    ],
    [
        "Secure Electronic Transaction - Registration",
        "application/set-registration-initiation",
        ".setreg",
    ],
    ["S Hexdump Format", "application/shf+xml", ".shf"],
    ["Synchronized Multimedia Integration Language", "application/smil+xml", ".smi"],
    ["SPARQL - Query", "application/sparql-query", ".rq"],
    ["SPARQL - Results", "application/sparql-results+xml", ".srx"],
    ["Speech Recognition Grammar Specification", "application/srgs", ".gram"],
    [
        "Speech Recognition Grammar Specification - XML",
        "application/srgs+xml",
        ".grxml",
    ],
    ["Search/Retrieve via URL Response Format", "application/sru+xml", ".sru"],
    ["Speech Synthesis Markup Language", "application/ssml+xml", ".ssml"],
    ["Text Encoding and Interchange", "application/tei+xml", ".tei"],
    ["Sharing Transaction Fraud Data", "application/thraud+xml", ".tfi"],
    ["Time Stamped Data Envelope", "application/timestamped-data", ".tsd"],
    [
        "3rd Generation Partnership Project - Pic Large",
        "application/vnd.3gpp.pic-bw-large",
        ".plb",
    ],
    [
        "3rd Generation Partnership Project - Pic Small",
        "application/vnd.3gpp.pic-bw-small",
        ".psb",
    ],
    [
        "3rd Generation Partnership Project - Pic Var",
        "application/vnd.3gpp.pic-bw-var",
        ".pvb",
    ],
    [
        "3rd Generation Partnership Project - Transaction Capabilities Application Part",
        "application/vnd.3gpp2.tcap",
        ".tcap",
    ],
    ["3M Post It Notes", "application/vnd.3m.post-it-notes", ".pwn"],
    ["Simply Accounting", "application/vnd.accpac.simply.aso", ".aso"],
    ["Simply Accounting - Data Import", "application/vnd.accpac.simply.imp", ".imp"],
    ["ACU Cobol", "application/vnd.acucobol", ".acu"],
    ["ACU Cobol", "application/vnd.acucorp", ".atc"],
    [
        "Adobe AIR Application",
        "application/vnd.adobe.air-application-installer-package+zip",
        ".air",
    ],
    ["Adobe Flex Project", "application/vnd.adobe.fxp", ".fxp"],
    ["Adobe XML Data Package", "application/vnd.adobe.xdp+xml", ".xdp"],
    ["Adobe XML Forms Data Format", "application/vnd.adobe.xfdf", ".xfdf"],
    ["Ahead AIR Application", "application/vnd.ahead.space", ".ahead"],
    ["AirZip FileSECURE", "application/vnd.airzip.filesecure.azf", ".azf"],
    ["AirZip FileSECURE", "application/vnd.airzip.filesecure.azs", ".azs"],
    ["Amazon Kindle eBook format", "application/vnd.amazon.ebook", ".azw"],
    ["Active Content Compression", "application/vnd.americandynamics.acc", ".acc"],
    ["AmigaDE", "application/vnd.amiga.ami", ".ami"],
    ["Android Package Archive", "application/vnd.android.package-archive", ".apk"],
    [
        "ANSER-WEB Terminal Client - Certificate Issue",
        "application/vnd.anser-web-certificate-issue-initiation",
        ".cii",
    ],
    [
        "ANSER-WEB Terminal Client - Web Funds Transfer",
        "application/vnd.anser-web-funds-transfer-initiation",
        ".fti",
    ],
    ["Antix Game Player", "application/vnd.antix.game-component", ".atx"],
    ["Apple Installer Package", "application/vnd.apple.installer+xml", ".mpkg"],
    ["Multimedia Playlist Unicode", "application/vnd.apple.mpegurl", ".m3u8"],
    ["Arista Networks Software Image", "application/vnd.aristanetworks.swi", ".swi"],
    ["Audiograph", "application/vnd.audiograph", ".aep"],
    ["Blueice Research Multipass", "application/vnd.blueice.multipass", ".mpm"],
    ["BMI Drawing Data Interchange", "application/vnd.bmi", ".bmi"],
    ["BusinessObjects", "application/vnd.businessobjects", ".rep"],
    ["CambridgeSoft Chem Draw", "application/vnd.chemdraw+xml", ".cdxml"],
    ["Karaoke on Chipnuts Chipsets", "application/vnd.chipnuts.karaoke-mmd", ".mmd"],
    ["Interactive Geometry Software Cinderella", "application/vnd.cinderella", ".cdy"],
    ["Claymore Data Files", "application/vnd.claymore", ".cla"],
    ["RetroPlatform Player", "application/vnd.cloanto.rp9", ".rp9"],
    ["Clonk Game", "application/vnd.clonk.c4group", ".c4g"],
    [
        "ClueTrust CartoMobile - Config",
        "application/vnd.cluetrust.cartomobile-config",
        ".c11amc",
    ],
    [
        "ClueTrust CartoMobile - Config Package",
        "application/vnd.cluetrust.cartomobile-config-pkg",
        ".c11amz",
    ],
    ["Sixth Floor Media - CommonSpace", "application/vnd.commonspace", ".csp"],
    ["CIM Database", "application/vnd.contact.cmsg", ".cdbcmsg"],
    ["CosmoCaller", "application/vnd.cosmocaller", ".cmc"],
    ["CrickSoftware - Clicker", "application/vnd.crick.clicker", ".clkx"],
    [
        "CrickSoftware - Clicker - Keyboard",
        "application/vnd.crick.clicker.keyboard",
        ".clkk",
    ],
    [
        "CrickSoftware - Clicker - Palette",
        "application/vnd.crick.clicker.palette",
        ".clkp",
    ],
    [
        "CrickSoftware - Clicker - Template",
        "application/vnd.crick.clicker.template",
        ".clkt",
    ],
    [
        "CrickSoftware - Clicker - Wordbank",
        "application/vnd.crick.clicker.wordbank",
        ".clkw",
    ],
    [
        "Critical Tools - PERT Chart EXPERT",
        "application/vnd.criticaltools.wbs+xml",
        ".wbs",
    ],
    ["PosML", "application/vnd.ctc-posml", ".pml"],
    [
        "Adobe PostScript Printer Description File Format",
        "application/vnd.cups-ppd",
        ".ppd",
    ],
    ["CURL Applet", "application/vnd.curl.car", ".car"],
    ["CURL Applet", "application/vnd.curl.pcurl", ".pcurl"],
    ["RemoteDocs R-Viewer", "application/vnd.data-vision.rdz", ".rdz"],
    ["FCS Express Layout Link", "application/vnd.denovo.fcselayout-link", ".fe_launch"],
    ["New Moon Liftoff/DNA", "application/vnd.dna", ".dna"],
    ["Dolby Meridian Lossless Packing", "application/vnd.dolby.mlp", ".mlp"],
    ["DPGraph", "application/vnd.dpgraph", ".dpg"],
    ["DreamFactory", "application/vnd.dreamfactory", ".dfac"],
    ["Digital Video Broadcasting", "application/vnd.dvb.ait", ".ait"],
    ["Digital Video Broadcasting", "application/vnd.dvb.service", ".svc"],
    ["DynaGeo", "application/vnd.dynageo", ".geo"],
    ["EcoWin Chart", "application/vnd.ecowin.chart", ".mag"],
    ["Enliven Viewer", "application/vnd.enliven", ".nml"],
    ["QUASS Stream Player", "application/vnd.epson.esf", ".esf"],
    ["QUASS Stream Player", "application/vnd.epson.msf", ".msf"],
    ["QuickAnime Player", "application/vnd.epson.quickanime", ".qam"],
    ["SimpleAnimeLite Player", "application/vnd.epson.salt", ".slt"],
    ["QUASS Stream Player", "application/vnd.epson.ssf", ".ssf"],
    ["MICROSEC e-Szign\u00ef\u00bf\u00bd", "application/vnd.eszigno3+xml", ".es3"],
    ["EZPix Secure Photo Album", "application/vnd.ezpix-album", ".ez2"],
    ["EZPix Secure Photo Album", "application/vnd.ezpix-package", ".ez3"],
    ["Forms Data Format", "application/vnd.fdf", ".fdf"],
    [
        "Digital Siesmograph Networks - SEED Datafiles",
        "application/vnd.fdsn.seed",
        ".seed",
    ],
    ["NpGraphIt", "application/vnd.flographit", ".gph"],
    ["FluxTime Clip", "application/vnd.fluxtime.clip", ".ftc"],
    ["FrameMaker Normal Format", "application/vnd.framemaker", ".fm"],
    ["Frogans Player", "application/vnd.frogans.fnc", ".fnc"],
    ["Frogans Player", "application/vnd.frogans.ltf", ".ltf"],
    ["Friendly Software Corporation", "application/vnd.fsc.weblaunch", ".fsc"],
    ["Fujitsu Oasys", "application/vnd.fujitsu.oasys", ".oas"],
    ["Fujitsu Oasys", "application/vnd.fujitsu.oasys2", ".oa2"],
    ["Fujitsu Oasys", "application/vnd.fujitsu.oasys3", ".oa3"],
    ["Fujitsu Oasys", "application/vnd.fujitsu.oasysgp", ".fg5"],
    ["Fujitsu Oasys", "application/vnd.fujitsu.oasysprs", ".bh2"],
    ["Fujitsu - Xerox 2D CAD Data", "application/vnd.fujixerox.ddd", ".ddd"],
    ["Fujitsu - Xerox DocuWorks", "application/vnd.fujixerox.docuworks", ".xdw"],
    [
        "Fujitsu - Xerox DocuWorks Binder",
        "application/vnd.fujixerox.docuworks.binder",
        ".xbd",
    ],
    ["FuzzySheet", "application/vnd.fuzzysheet", ".fzs"],
    ["Genomatix Tuxedo Framework", "application/vnd.genomatix.tuxedo", ".txd"],
    ["GeoGebra", "application/vnd.geogebra.file", ".ggb"],
    ["GeoGebra", "application/vnd.geogebra.tool", ".ggt"],
    ["GeoMetry Explorer", "application/vnd.geometry-explorer", ".gex"],
    ["GEONExT and JSXGraph", "application/vnd.geonext", ".gxt"],
    ["GeoplanW", "application/vnd.geoplan", ".g2w"],
    ["GeospacW", "application/vnd.geospace", ".g3w"],
    ["GameMaker ActiveX", "application/vnd.gmx", ".gmx"],
    ["Google Earth - KML", "application/vnd.google-earth.kml+xml", ".kml"],
    ["Google Earth - Zipped KML", "application/vnd.google-earth.kmz", ".kmz"],
    ["GrafEq", "application/vnd.grafeq", ".gqf"],
    ["Groove - Account", "application/vnd.groove-account", ".gac"],
    ["Groove - Help", "application/vnd.groove-help", ".ghf"],
    ["Groove - Identity Message", "application/vnd.groove-identity-message", ".gim"],
    ["Groove - Injector", "application/vnd.groove-injector", ".grv"],
    ["Groove - Tool Message", "application/vnd.groove-tool-message", ".gtm"],
    ["Groove - Tool Template", "application/vnd.groove-tool-template", ".tpl"],
    ["Groove - Vcard", "application/vnd.groove-vcard", ".vcg"],
    ["Hypertext Application Language", "application/vnd.hal+xml", ".hal"],
    ["ZVUE Media Manager", "application/vnd.handheld-entertainment+xml", ".zmm"],
    ["Homebanking Computer Interface (HBCI)", "application/vnd.hbci", ".hbci"],
    ["Archipelago Lesson Player", "application/vnd.hhe.lesson-player", ".les"],
    ["HP-GL/2 and HP RTL", "application/vnd.hp-hpgl", ".hpgl"],
    ["Hewlett Packard Instant Delivery", "application/vnd.hp-hpid", ".hpid"],
    ["Hewlett-Packard's WebPrintSmart", "application/vnd.hp-hps", ".hps"],
    [
        "HP Indigo Digital Press - Job Layout Languate",
        "application/vnd.hp-jlyt",
        ".jlt",
    ],
    ["HP Printer Command Language", "application/vnd.hp-pcl", ".pcl"],
    ["PCL 6 Enhanced (Formely PCL XL)", "application/vnd.hp-pclxl", ".pclxl"],
    ["Hydrostatix Master Suite", "application/vnd.hydrostatix.sof-data", ".sfd-hdstx"],
    ["3D Crossword Plugin", "application/vnd.hzn-3d-crossword", ".x3d"],
    ["MiniPay", "application/vnd.ibm.minipay", ".mpy"],
    ["MO:DCA-P", "application/vnd.ibm.modcap", ".afp"],
    ["IBM DB2 Rights Manager", "application/vnd.ibm.rights-management", ".irm"],
    [
        "IBM Electronic Media Management System - Secure Container",
        "application/vnd.ibm.secure-container",
        ".sc",
    ],
    ["ICC profile", "application/vnd.iccprofile", ".icc"],
    ["igLoader", "application/vnd.igloader", ".igl"],
    ["ImmerVision PURE Players", "application/vnd.immervision-ivp", ".ivp"],
    ["ImmerVision PURE Players", "application/vnd.immervision-ivu", ".ivu"],
    ["IOCOM Visimeet", "application/vnd.insors.igm", ".igm"],
    ["Intercon FormNet", "application/vnd.intercon.formnet", ".xpw"],
    ["Interactive Geometry Software", "application/vnd.intergeo", ".i2g"],
    ["Open Financial Exchange", "application/vnd.intu.qbo", ".qbo"],
    ["Quicken", "application/vnd.intu.qfx", ".qfx"],
    [
        "IP Unplugged Roaming Client",
        "application/vnd.ipunplugged.rcprofile",
        ".rcprofile",
    ],
    ["iRepository / Lucidoc Editor", "application/vnd.irepository.package+xml", ".irp"],
    ["Express by Infoseek", "application/vnd.is-xpr", ".xpr"],
    [
        "International Society for Advancement of Cytometry",
        "application/vnd.isac.fcs",
        ".fcs",
    ],
    ["Lightspeed Audio Lab", "application/vnd.jam", ".jam"],
    [
        "Mobile Information Device Profile",
        "application/vnd.jcp.javame.midlet-rms",
        ".rms",
    ],
    ["RhymBox", "application/vnd.jisp", ".jisp"],
    ["Joda Archive", "application/vnd.joost.joda-archive", ".joda"],
    ["Kahootz", "application/vnd.kahootz", ".ktz"],
    ["KDE KOffice Office Suite - Karbon", "application/vnd.kde.karbon", ".karbon"],
    ["KDE KOffice Office Suite - KChart", "application/vnd.kde.kchart", ".chrt"],
    ["KDE KOffice Office Suite - Kformula", "application/vnd.kde.kformula", ".kfo"],
    ["KDE KOffice Office Suite - Kivio", "application/vnd.kde.kivio", ".flw"],
    ["KDE KOffice Office Suite - Kontour", "application/vnd.kde.kontour", ".kon"],
    ["KDE KOffice Office Suite - Kpresenter", "application/vnd.kde.kpresenter", ".kpr"],
    ["KDE KOffice Office Suite - Kspread", "application/vnd.kde.kspread", ".ksp"],
    ["KDE KOffice Office Suite - Kword", "application/vnd.kde.kword", ".kwd"],
    ["Kenamea App", "application/vnd.kenameaapp", ".htke"],
    ["Kidspiration", "application/vnd.kidspiration", ".kia"],
    ["Kinar Applications", "application/vnd.kinar", ".kne"],
    ["SSEYO Koan Play File", "application/vnd.koan", ".skp"],
    ["Kodak Storyshare", "application/vnd.kodak-descriptor", ".sse"],
    ["Laser App Enterprise", "application/vnd.las.las+xml", ".lasxml"],
    [
        "Life Balance - Desktop Edition",
        "application/vnd.llamagraphics.life-balance.desktop",
        ".lbd",
    ],
    [
        "Life Balance - Exchange Format",
        "application/vnd.llamagraphics.life-balance.exchange+xml",
        ".lbe",
    ],
    ["Lotus 1-2-3", "application/vnd.lotus-1-2-3", ".123"],
    ["Lotus Approach", "application/vnd.lotus-approach", ".apr"],
    ["Lotus Freelance", "application/vnd.lotus-freelance", ".pre"],
    ["Lotus Notes", "application/vnd.lotus-notes", ".nsf"],
    ["Lotus Organizer", "application/vnd.lotus-organizer", ".org"],
    ["Lotus Screencam", "application/vnd.lotus-screencam", ".scm"],
    ["Lotus Wordpro", "application/vnd.lotus-wordpro", ".lwp"],
    ["MacPorts Port System", "application/vnd.macports.portpkg", ".portpkg"],
    ["Micro CADAM Helix D&D", "application/vnd.mcd", ".mcd"],
    ["MedCalc", "application/vnd.medcalcdata", ".mc1"],
    ["MediaRemote", "application/vnd.mediastation.cdkey", ".cdkey"],
    ["Medical Waveform Encoding Format", "application/vnd.mfer", ".mwf"],
    ["Melody Format for Mobile Platform", "application/vnd.mfmp", ".mfm"],
    ["Micrografx", "application/vnd.micrografx.flo", ".flo"],
    ["Micrografx iGrafx Professional", "application/vnd.micrografx.igx", ".igx"],
    ["FrameMaker Interchange Format", "application/vnd.mif", ".mif"],
    [
        "Mobius Management Systems - UniversalArchive",
        "application/vnd.mobius.daf",
        ".daf",
    ],
    [
        "Mobius Management Systems - Distribution Database",
        "application/vnd.mobius.dis",
        ".dis",
    ],
    ["Mobius Management Systems - Basket file", "application/vnd.mobius.mbk", ".mbk"],
    ["Mobius Management Systems - Query File", "application/vnd.mobius.mqy", ".mqy"],
    [
        "Mobius Management Systems - Script Language",
        "application/vnd.mobius.msl",
        ".msl",
    ],
    [
        "Mobius Management Systems - Policy Definition Language File",
        "application/vnd.mobius.plc",
        ".plc",
    ],
    [
        "Mobius Management Systems - Topic Index File",
        "application/vnd.mobius.txf",
        ".txf",
    ],
    ["Mophun VM", "application/vnd.mophun.application", ".mpn"],
    ["Mophun Certificate", "application/vnd.mophun.certificate", ".mpc"],
    ["XUL - XML User Interface Language", "application/vnd.mozilla.xul+xml", ".xul"],
    ["Microsoft Artgalry", "application/vnd.ms-artgalry", ".cil"],
    ["Microsoft Cabinet File", "application/vnd.ms-cab-compressed", ".cab"],
    ["Microsoft Excel", "application/vnd.ms-excel", ".xls"],
    [
        "Microsoft Excel - Add-In File",
        "application/vnd.ms-excel.addin.macroenabled.12",
        ".xlam",
    ],
    [
        "Microsoft Excel - Binary Workbook",
        "application/vnd.ms-excel.sheet.binary.macroenabled.12",
        ".xlsb",
    ],
    [
        "Microsoft Excel - Macro-Enabled Workbook",
        "application/vnd.ms-excel.sheet.macroenabled.12",
        ".xlsm",
    ],
    [
        "Microsoft Excel - Macro-Enabled Template File",
        "application/vnd.ms-excel.template.macroenabled.12",
        ".xltm",
    ],
    ["Microsoft Embedded OpenType", "application/vnd.ms-fontobject", ".eot"],
    ["Microsoft Html Help File", "application/vnd.ms-htmlhelp", ".chm"],
    ["Microsoft Class Server", "application/vnd.ms-ims", ".ims"],
    ["Microsoft Learning Resource Module", "application/vnd.ms-lrm", ".lrm"],
    [
        "Microsoft Office System Release Theme",
        "application/vnd.ms-officetheme",
        ".thmx",
    ],
    [
        "Microsoft Trust UI Provider - Security Catalog",
        "application/vnd.ms-pki.seccat",
        ".cat",
    ],
    [
        "Microsoft Trust UI Provider - Certificate Trust Link",
        "application/vnd.ms-pki.stl",
        ".stl",
    ],
    ["Microsoft PowerPoint", "application/vnd.ms-powerpoint", ".ppt"],
    [
        "Microsoft PowerPoint - Add-in file",
        "application/vnd.ms-powerpoint.addin.macroenabled.12",
        ".ppam",
    ],
    [
        "Microsoft PowerPoint - Macro-Enabled Presentation File",
        "application/vnd.ms-powerpoint.presentation.macroenabled.12",
        ".pptm",
    ],
    [
        "Microsoft PowerPoint - Macro-Enabled Open XML Slide",
        "application/vnd.ms-powerpoint.slide.macroenabled.12",
        ".sldm",
    ],
    [
        "Microsoft PowerPoint - Macro-Enabled Slide Show File",
        "application/vnd.ms-powerpoint.slideshow.macroenabled.12",
        ".ppsm",
    ],
    [
        "Microsoft PowerPoint - Macro-Enabled Template File",
        "application/vnd.ms-powerpoint.template.macroenabled.12",
        ".potm",
    ],
    ["Microsoft Project", "application/vnd.ms-project", ".mpp"],
    [
        "Microsoft Word - Macro-Enabled Document",
        "application/vnd.ms-word.document.macroenabled.12",
        ".docm",
    ],
    [
        "Microsoft Word - Macro-Enabled Template",
        "application/vnd.ms-word.template.macroenabled.12",
        ".dotm",
    ],
    ["Microsoft Works", "application/vnd.ms-works", ".wps"],
    ["Microsoft Windows Media Player Playlist", "application/vnd.ms-wpl", ".wpl"],
    ["Microsoft XML Paper Specification", "application/vnd.ms-xpsdocument", ".xps"],
    ["3GPP MSEQ File", "application/vnd.mseq", ".mseq"],
    [
        "MUsical Score Interpreted Code Invented  for the ASCII designation of Notation",
        "application/vnd.musician",
        ".mus",
    ],
    ["Muvee Automatic Video Editing", "application/vnd.muvee.style", ".msty"],
    ["neuroLanguage", "application/vnd.neurolanguage.nlu", ".nlu"],
    ["NobleNet Directory", "application/vnd.noblenet-directory", ".nnd"],
    ["NobleNet Sealer", "application/vnd.noblenet-sealer", ".nns"],
    ["NobleNet Web", "application/vnd.noblenet-web", ".nnw"],
    ["N-Gage Game Data", "application/vnd.nokia.n-gage.data", ".ngdat"],
    [
        "N-Gage Game Installer",
        "application/vnd.nokia.n-gage.symbian.install",
        ".n-gage",
    ],
    ["Nokia Radio Application - Preset", "application/vnd.nokia.radio-preset", ".rpst"],
    [
        "Nokia Radio Application - Preset",
        "application/vnd.nokia.radio-presets",
        ".rpss",
    ],
    ["Novadigm's RADIA and EDM products", "application/vnd.novadigm.edm", ".edm"],
    ["Novadigm's RADIA and EDM products", "application/vnd.novadigm.edx", ".edx"],
    ["Novadigm's RADIA and EDM products", "application/vnd.novadigm.ext", ".ext"],
    ["OpenDocument Chart", "application/vnd.oasis.opendocument.chart", ".odc"],
    [
        "OpenDocument Chart Template",
        "application/vnd.oasis.opendocument.chart-template",
        ".otc",
    ],
    ["OpenDocument Database", "application/vnd.oasis.opendocument.database", ".odb"],
    ["OpenDocument Formula", "application/vnd.oasis.opendocument.formula", ".odf"],
    [
        "OpenDocument Formula Template",
        "application/vnd.oasis.opendocument.formula-template",
        ".odft",
    ],
    ["OpenDocument Graphics", "application/vnd.oasis.opendocument.graphics", ".odg"],
    [
        "OpenDocument Graphics Template",
        "application/vnd.oasis.opendocument.graphics-template",
        ".otg",
    ],
    ["OpenDocument Image", "application/vnd.oasis.opendocument.image", ".odi"],
    [
        "OpenDocument Image Template",
        "application/vnd.oasis.opendocument.image-template",
        ".oti",
    ],
    [
        "OpenDocument Presentation",
        "application/vnd.oasis.opendocument.presentation",
        ".odp",
    ],
    [
        "OpenDocument Presentation Template",
        "application/vnd.oasis.opendocument.presentation-template",
        ".otp",
    ],
    [
        "OpenDocument Spreadsheet",
        "application/vnd.oasis.opendocument.spreadsheet",
        ".ods",
    ],
    [
        "OpenDocument Spreadsheet Template",
        "application/vnd.oasis.opendocument.spreadsheet-template",
        ".ots",
    ],
    ["OpenDocument Text", "application/vnd.oasis.opendocument.text", ".odt"],
    [
        "OpenDocument Text Master",
        "application/vnd.oasis.opendocument.text-master",
        ".odm",
    ],
    [
        "OpenDocument Text Template",
        "application/vnd.oasis.opendocument.text-template",
        ".ott",
    ],
    ["Open Document Text Web", "application/vnd.oasis.opendocument.text-web", ".oth"],
    ["Sugar Linux Application Bundle", "application/vnd.olpc-sugar", ".xo"],
    ["OMA Download Agents", "application/vnd.oma.dd2+xml", ".dd2"],
    ["Open Office Extension", "application/vnd.openofficeorg.extension", ".oxt"],
    [
        "Microsoft Office - OOXML - Presentation",
        "application/vnd.openxmlformats-officedocument.presentationml.presentation",
        ".pptx",
    ],
    [
        "Microsoft Office - OOXML - Presentation (Slide)",
        "application/vnd.openxmlformats-officedocument.presentationml.slide",
        ".sldx",
    ],
    [
        "Microsoft Office - OOXML - Presentation (Slideshow)",
        "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
        ".ppsx",
    ],
    [
        "Microsoft Office - OOXML - Presentation Template",
        "application/vnd.openxmlformats-officedocument.presentationml.template",
        ".potx",
    ],
    [
        "Microsoft Office - OOXML - Spreadsheet",
        "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
        ".xlsx",
    ],
    [
        "Microsoft Office - OOXML - Spreadsheet Template",
        "application/vnd.openxmlformats-officedocument.spreadsheetml.template",
        ".xltx",
    ],
    [
        "Microsoft Office - OOXML - Word Document",
        "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
        ".docx",
    ],
    [
        "Microsoft Office - OOXML - Word Document Template",
        "application/vnd.openxmlformats-officedocument.wordprocessingml.template",
        ".dotx",
    ],
    ["MapGuide DBXML", "application/vnd.osgeo.mapguide.package", ".mgp"],
    ["OSGi Deployment Package", "application/vnd.osgi.dp", ".dp"],
    ["PalmOS Data", "application/vnd.palm", ".pdb"],
    ["PawaaFILE", "application/vnd.pawaafile", ".paw"],
    ["Proprietary P&G Standard Reporting System", "application/vnd.pg.format", ".str"],
    ["Proprietary P&G Standard Reporting System", "application/vnd.pg.osasli", ".ei6"],
    ["Pcsel eFIF File", "application/vnd.picsel", ".efif"],
    ["Qualcomm's Plaza Mobile Internet", "application/vnd.pmi.widget", ".wg"],
    ["PocketLearn Viewers", "application/vnd.pocketlearn", ".plf"],
    ["PowerBuilder", "application/vnd.powerbuilder6", ".pbd"],
    ["Preview Systems ZipLock/VBox", "application/vnd.previewsystems.box", ".box"],
    ["EFI Proteus", "application/vnd.proteus.magazine", ".mgz"],
    ["PubliShare Objects", "application/vnd.publishare-delta-tree", ".qps"],
    ["Princeton Video Image", "application/vnd.pvi.ptid1", ".ptid"],
    ["QuarkXpress", "application/vnd.quark.quarkxpress", ".qxd"],
    ["RealVNC", "application/vnd.realvnc.bed", ".bed"],
    ["Recordare Applications", "application/vnd.recordare.musicxml", ".mxl"],
    ["Recordare Applications", "application/vnd.recordare.musicxml+xml", ".musicxml"],
    ["CryptoNote", "application/vnd.rig.cryptonote", ".cryptonote"],
    ["Blackberry COD File", "application/vnd.rim.cod", ".cod"],
    ["RealMedia", "application/vnd.rn-realmedia", ".rm"],
    [
        "ROUTE 66 Location Based Services",
        "application/vnd.route66.link66+xml",
        ".link66",
    ],
    ["SailingTracker", "application/vnd.sailingtracker.track", ".st"],
    ["SeeMail", "application/vnd.seemail", ".see"],
    ["Secured eMail", "application/vnd.sema", ".sema"],
    ["Secured eMail", "application/vnd.semd", ".semd"],
    ["Secured eMail", "application/vnd.semf", ".semf"],
    ["Shana Informed Filler", "application/vnd.shana.informed.formdata", ".ifm"],
    ["Shana Informed Filler", "application/vnd.shana.informed.formtemplate", ".itp"],
    ["Shana Informed Filler", "application/vnd.shana.informed.interchange", ".iif"],
    ["Shana Informed Filler", "application/vnd.shana.informed.package", ".ipk"],
    ["SimTech MindMapper", "application/vnd.simtech-mindmapper", ".twd"],
    ["SMAF File", "application/vnd.smaf", ".mmf"],
    ["SMART Technologies Apps", "application/vnd.smart.teacher", ".teacher"],
    ["SudokuMagic", "application/vnd.solent.sdkm+xml", ".sdkm"],
    ["TIBCO Spotfire", "application/vnd.spotfire.dxp", ".dxp"],
    ["TIBCO Spotfire", "application/vnd.spotfire.sfs", ".sfs"],
    ["StarOffice - Calc", "application/vnd.stardivision.calc", ".sdc"],
    ["StarOffice - Draw", "application/vnd.stardivision.draw", ".sda"],
    ["StarOffice - Impress", "application/vnd.stardivision.impress", ".sdd"],
    ["StarOffice - Math", "application/vnd.stardivision.math", ".smf"],
    ["StarOffice - Writer", "application/vnd.stardivision.writer", ".sdw"],
    [
        "StarOffice - Writer  (Global)",
        "application/vnd.stardivision.writer-global",
        ".sgl",
    ],
    ["StepMania", "application/vnd.stepmania.stepchart", ".sm"],
    ["OpenOffice - Calc (Spreadsheet)", "application/vnd.sun.xml.calc", ".sxc"],
    [
        "OpenOffice - Calc Template (Spreadsheet)",
        "application/vnd.sun.xml.calc.template",
        ".stc",
    ],
    ["OpenOffice - Draw (Graphics)", "application/vnd.sun.xml.draw", ".sxd"],
    [
        "OpenOffice - Draw Template (Graphics)",
        "application/vnd.sun.xml.draw.template",
        ".std",
    ],
    ["OpenOffice - Impress (Presentation)", "application/vnd.sun.xml.impress", ".sxi"],
    [
        "OpenOffice - Impress Template (Presentation)",
        "application/vnd.sun.xml.impress.template",
        ".sti",
    ],
    ["OpenOffice - Math (Formula)", "application/vnd.sun.xml.math", ".sxm"],
    ["OpenOffice - Writer (Text - HTML)", "application/vnd.sun.xml.writer", ".sxw"],
    [
        "OpenOffice - Writer (Text - HTML)",
        "application/vnd.sun.xml.writer.global",
        ".sxg",
    ],
    [
        "OpenOffice - Writer Template (Text - HTML)",
        "application/vnd.sun.xml.writer.template",
        ".stw",
    ],
    ["ScheduleUs", "application/vnd.sus-calendar", ".sus"],
    ["SourceView Document", "application/vnd.svd", ".svd"],
    ["Symbian Install Package", "application/vnd.symbian.install", ".sis"],
    ["SyncML", "application/vnd.syncml+xml", ".xsm"],
    ["SyncML - Device Management", "application/vnd.syncml.dm+wbxml", ".bdm"],
    ["SyncML - Device Management", "application/vnd.syncml.dm+xml", ".xdm"],
    ["Tao Intent", "application/vnd.tao.intent-module-archive", ".tao"],
    ["MobileTV", "application/vnd.tmobile-livetv", ".tmo"],
    ["TRI Systems Config", "application/vnd.trid.tpt", ".tpt"],
    ["Triscape Map Explorer", "application/vnd.triscape.mxs", ".mxs"],
    ["True BASIC", "application/vnd.trueapp", ".tra"],
    ["Universal Forms Description Language", "application/vnd.ufdl", ".ufd"],
    ["User Interface Quartz - Theme (Symbian)", "application/vnd.uiq.theme", ".utz"],
    ["UMAJIN", "application/vnd.umajin", ".umj"],
    ["Unity 3d", "application/vnd.unity", ".unityweb"],
    ["Unique Object Markup Language", "application/vnd.uoml+xml", ".uoml"],
    ["VirtualCatalog", "application/vnd.vcx", ".vcx"],
    ["Microsoft Visio", "application/vnd.visio", ".vsd"],
    ["Microsoft Visio 2013", "application/vnd.visio2013", ".vsdx"],
    ["Visionary", "application/vnd.visionary", ".vis"],
    ["Viewport+", "application/vnd.vsf", ".vsf"],
    ["WAP Binary XML (WBXML)", "application/vnd.wap.wbxml", ".wbxml"],
    ["Compiled Wireless Markup Language (WMLC)", "application/vnd.wap.wmlc", ".wmlc"],
    ["WMLScript", "application/vnd.wap.wmlscriptc", ".wmlsc"],
    ["WebTurbo", "application/vnd.webturbo", ".wtb"],
    ["Mathematica Notebook Player", "application/vnd.wolfram.player", ".nbp"],
    ["Wordperfect", "application/vnd.wordperfect", ".wpd"],
    ["SundaHus WQ", "application/vnd.wqd", ".wqd"],
    ["Worldtalk", "application/vnd.wt.stf", ".stf"],
    ["CorelXARA", "application/vnd.xara", ".xar"],
    ["Extensible Forms Description Language", "application/vnd.xfdl", ".xfdl"],
    ["HV Voice Dictionary", "application/vnd.yamaha.hv-dic", ".hvd"],
    ["HV Script", "application/vnd.yamaha.hv-script", ".hvs"],
    ["HV Voice Parameter", "application/vnd.yamaha.hv-voice", ".hvp"],
    ["Open Score Format", "application/vnd.yamaha.openscoreformat", ".osf"],
    ["OSFPVG", "application/vnd.yamaha.openscoreformat.osfpvg+xml", ".osfpvg"],
    ["SMAF Audio", "application/vnd.yamaha.smaf-audio", ".saf"],
    ["SMAF Phrase", "application/vnd.yamaha.smaf-phrase", ".spf"],
    ["CustomMenu", "application/vnd.yellowriver-custom-menu", ".cmp"],
    ["Z.U.L. Geometry", "application/vnd.zul", ".zir"],
    ["Zzazz Deck", "application/vnd.zzazz.deck+xml", ".zaz"],
    ["VoiceXML", "application/voicexml+xml", ".vxml"],
    ["Widget Packaging and XML Configuration", "application/widget", ".wgt"],
    ["WinHelp", "application/winhlp", ".hlp"],
    ["WSDL - Web Services Description Language", "application/wsdl+xml", ".wsdl"],
    ["Web Services Policy", "application/wspolicy+xml", ".wspolicy"],
    ["7-Zip", "application/x-7z-compressed", ".7z"],
    ["AbiWord", "application/x-abiword", ".abw"],
    ["Ace Archive", "application/x-ace-compressed", ".ace"],
    [
        "Adobe (Macropedia) Authorware - Binary File",
        "application/x-authorware-bin",
        ".aab",
    ],
    ["Adobe (Macropedia) Authorware - Map", "application/x-authorware-map", ".aam"],
    [
        "Adobe (Macropedia) Authorware - Segment File",
        "application/x-authorware-seg",
        ".aas",
    ],
    ["Binary CPIO Archive", "application/x-bcpio", ".bcpio"],
    ["BitTorrent", "application/x-bittorrent", ".torrent"],
    ["Bzip Archive", "application/x-bzip", ".bz"],
    ["Bzip2 Archive", "application/x-bzip2", ".bz2"],
    ["Video CD", "application/x-cdlink", ".vcd"],
    ["pIRCh", "application/x-chat", ".chat"],
    ["Portable Game Notation (Chess Games)", "application/x-chess-pgn", ".pgn"],
    ["CPIO Archive", "application/x-cpio", ".cpio"],
    ["C Shell Script", "application/x-csh", ".csh"],
    ["Debian Package", "application/x-debian-package", ".deb"],
    ["Adobe Shockwave Player", "application/x-director", ".dir"],
    ["Doom Video Game", "application/x-doom", ".wad"],
    ["Navigation Control file for XML (for ePub)", "application/x-dtbncx+xml", ".ncx"],
    ["Digital Talking Book", "application/x-dtbook+xml", ".dtb"],
    ["Digital Talking Book - Resource File", "application/x-dtbresource+xml", ".res"],
    ["Device Independent File Format (DVI)", "application/x-dvi", ".dvi"],
    ["Glyph Bitmap Distribution Format", "application/x-font-bdf", ".bdf"],
    ["Ghostscript Font", "application/x-font-ghostscript", ".gsf"],
    ["PSF Fonts", "application/x-font-linux-psf", ".psf"],
    ["OpenType Font File", "application/x-font-otf", ".otf"],
    ["Portable Compiled Format", "application/x-font-pcf", ".pcf"],
    ["Server Normal Format", "application/x-font-snf", ".snf"],
    ["TrueType Font", "application/x-font-ttf", ".ttf"],
    ["PostScript Fonts", "application/x-font-type1", ".pfa"],
    ["Web Open Font Format", "application/x-font-woff", ".woff"],
    ["FutureSplash Animator", "application/x-futuresplash", ".spl"],
    ["Gnumeric", "application/x-gnumeric", ".gnumeric"],
    ["GNU Tar Files", "application/x-gtar", ".gtar"],
    ["Hierarchical Data Format", "application/x-hdf", ".hdf"],
    ["Java Network Launching Protocol", "application/x-java-jnlp-file", ".jnlp"],
    ["LaTeX", "application/x-latex", ".latex"],
    ["Mobipocket", "application/x-mobipocket-ebook", ".prc"],
    ["Microsoft ClickOnce", "application/x-ms-application", ".application"],
    ["Microsoft Windows Media Player Download Package", "application/x-ms-wmd", ".wmd"],
    ["Microsoft Windows Media Player Skin Package", "application/x-ms-wmz", ".wmz"],
    ["Microsoft XAML Browser Application", "application/x-ms-xbap", ".xbap"],
    ["Microsoft Access", "application/x-msaccess", ".mdb"],
    ["Microsoft Office Binder", "application/x-msbinder", ".obd"],
    ["Microsoft Information Card", "application/x-mscardfile", ".crd"],
    ["Microsoft Clipboard Clip", "application/x-msclip", ".clp"],
    ["Microsoft Application", "application/x-msdownload", ".exe"],
    ["Microsoft MediaView", "application/x-msmediaview", ".mvb"],
    ["Microsoft Windows Metafile", "application/x-msmetafile", ".wmf"],
    ["Microsoft Money", "application/x-msmoney", ".mny"],
    ["Microsoft Publisher", "application/x-mspublisher", ".pub"],
    ["Microsoft Schedule+", "application/x-msschedule", ".scd"],
    ["Microsoft Windows Terminal Services", "application/x-msterminal", ".trm"],
    ["Microsoft Wordpad", "application/x-mswrite", ".wri"],
    ["Network Common Data Form (NetCDF)", "application/x-netcdf", ".nc"],
    [
        "PKCS #12 - Personal Information Exchange Syntax Standard",
        "application/x-pkcs12",
        ".p12",
    ],
    [
        "PKCS #7 - Cryptographic Message Syntax Standard (Certificates)",
        "application/x-pkcs7-certificates",
        ".p7b",
    ],
    [
        "PKCS #7 - Cryptographic Message Syntax Standard (Certificate Request Response)",
        "application/x-pkcs7-certreqresp",
        ".p7r",
    ],
    ["RAR Archive", "application/x-rar-compressed", ".rar"],
    ["Bourne Shell Script", "application/x-sh", ".sh"],
    ["Shell Archive", "application/x-shar", ".shar"],
    ["Adobe Flash", "application/x-shockwave-flash", ".swf"],
    ["Microsoft Silverlight", "application/x-silverlight-app", ".xap"],
    ["Stuffit Archive", "application/x-stuffit", ".sit"],
    ["Stuffit Archive", "application/x-stuffitx", ".sitx"],
    ["System V Release 4 CPIO Archive", "application/x-sv4cpio", ".sv4cpio"],
    ["System V Release 4 CPIO Checksum Data", "application/x-sv4crc", ".sv4crc"],
    ["Tar File (Tape Archive)", "application/x-tar", ".tar"],
    ["Tcl Script", "application/x-tcl", ".tcl"],
    ["TeX", "application/x-tex", ".tex"],
    ["TeX Font Metric", "application/x-tex-tfm", ".tfm"],
    ["GNU Texinfo Document", "application/x-texinfo", ".texinfo"],
    ["Ustar (Uniform Standard Tape Archive)", "application/x-ustar", ".ustar"],
    ["WAIS Source", "application/x-wais-source", ".src"],
    ["X.509 Certificate", "application/x-x509-ca-cert", ".der"],
    ["Xfig", "application/x-xfig", ".fig"],
    ["XPInstall - Mozilla", "application/x-xpinstall", ".xpi"],
    [
        "XML Configuration Access Protocol - XCAP Diff",
        "application/xcap-diff+xml",
        ".xdf",
    ],
    ["XML Encryption Syntax and Processing", "application/xenc+xml", ".xenc"],
    [
        "XHTML - The Extensible HyperText Markup Language",
        "application/xhtml+xml",
        ".xhtml",
    ],
    ["XML - Extensible Markup Language", "application/xml", ".xml"],
    ["Document Type Definition", "application/xml-dtd", ".dtd"],
    ["XML-Binary Optimized Packaging", "application/xop+xml", ".xop"],
    ["XML Transformations", "application/xslt+xml", ".xslt"],
    ["XSPF - XML Shareable Playlist Format", "application/xspf+xml", ".xspf"],
    ["MXML", "application/xv+xml", ".mxml"],
    ["YANG Data Modeling Language", "application/yang", ".yang"],
    ["YIN (YANG - XML)", "application/yin+xml", ".yin"],
    ["Zip Archive", "application/zip", ".zip"],
    ["Adaptive differential pulse-code modulation", "audio/adpcm", ".adp"],
    ["Sun Audio - Au file format", "audio/basic", ".au"],
    ["MIDI - Musical Instrument Digital Interface", "audio/midi", ".mid"],
    ["MPEG-4 Audio", "audio/mp4", ".mp4a"],
    ["MPEG Audio", "audio/mpeg", ".mpga"],
    ["Ogg Audio", "audio/ogg", ".oga"],
    ["DECE Audio", "audio/vnd.dece.audio", ".uva"],
    ["Digital Winds Music", "audio/vnd.digital-winds", ".eol"],
    ["DRA Audio", "audio/vnd.dra", ".dra"],
    ["DTS Audio", "audio/vnd.dts", ".dts"],
    ["DTS High Definition Audio", "audio/vnd.dts.hd", ".dtshd"],
    ["Lucent Voice", "audio/vnd.lucent.voice", ".lvp"],
    ["Microsoft PlayReady Ecosystem", "audio/vnd.ms-playready.media.pya", ".pya"],
    ["Nuera ECELP 4800", "audio/vnd.nuera.ecelp4800", ".ecelp4800"],
    ["Nuera ECELP 7470", "audio/vnd.nuera.ecelp7470", ".ecelp7470"],
    ["Nuera ECELP 9600", "audio/vnd.nuera.ecelp9600", ".ecelp9600"],
    ["Hit'n'Mix", "audio/vnd.rip", ".rip"],
    ["Open Web Media Project - Audio", "audio/webm", ".weba"],
    ["Advanced Audio Coding (AAC)", "audio/x-aac", ".aac"],
    ["Audio Interchange File Format", "audio/x-aiff", ".aif"],
    ["M3U (Multimedia Playlist)", "audio/x-mpegurl", ".m3u"],
    ["Microsoft Windows Media Audio Redirector", "audio/x-ms-wax", ".wax"],
    ["Microsoft Windows Media Audio", "audio/x-ms-wma", ".wma"],
    ["Real Audio Sound", "audio/x-pn-realaudio", ".ram"],
    ["Real Audio Sound", "audio/x-pn-realaudio-plugin", ".rmp"],
    ["Waveform Audio File Format (WAV)", "audio/x-wav", ".wav"],
    ["ChemDraw eXchange file", "chemical/x-cdx", ".cdx"],
    ["Crystallographic Interchange Format", "chemical/x-cif", ".cif"],
    ["CrystalMaker Data Format", "chemical/x-cmdf", ".cmdf"],
    ["Chemical Markup Language", "chemical/x-cml", ".cml"],
    ["Chemical Style Markup Language", "chemical/x-csml", ".csml"],
    ["XYZ File Format", "chemical/x-xyz", ".xyz"],
    ["Bitmap Image File", "image/bmp", ".bmp"],
    ["Computer Graphics Metafile", "image/cgm", ".cgm"],
    ["G3 Fax Image", "image/g3fax", ".g3"],
    ["Graphics Interchange Format", "image/gif", ".gif"],
    ["Image Exchange Format", "image/ief", ".ief"],
    ["JPEG Image", "image/jpeg", ".jpeg"],
    ["JPEG Image (Progressive)", "image/pjpeg", ".pjpeg"],
    ["OpenGL Textures (KTX)", "image/ktx", ".ktx"],
    ["Portable Network Graphics (PNG)", "image/png", ".png"],
    ["Portable Network Graphics (PNG) (x-token)", "image/x-png", ".png"],
    ["Portable Network Graphics (PNG) (Citrix client)", "image/x-citrix-png", ".png"],
    ["BTIF", "image/prs.btif", ".btif"],
    ["Scalable Vector Graphics (SVG)", "image/svg+xml", ".svg"],
    ["Tagged Image File Format", "image/tiff", ".tiff"],
    ["Photoshop Document", "image/vnd.adobe.photoshop", ".psd"],
    ["DECE Graphic", "image/vnd.dece.graphic", ".uvi"],
    ["Close Captioning - Subtitle", "image/vnd.dvb.subtitle", ".sub"],
    ["DjVu", "image/vnd.djvu", ".djvu"],
    ["DWG Drawing", "image/vnd.dwg", ".dwg"],
    ["AutoCAD DXF", "image/vnd.dxf", ".dxf"],
    ["FastBid Sheet", "image/vnd.fastbidsheet", ".fbs"],
    ["FlashPix", "image/vnd.fpx", ".fpx"],
    ["FAST Search & Transfer ASA", "image/vnd.fst", ".fst"],
    ["EDMICS 2000", "image/vnd.fujixerox.edmics-mmr", ".mmr"],
    ["EDMICS 2000", "image/vnd.fujixerox.edmics-rlc", ".rlc"],
    ["Microsoft Document Imaging Format", "image/vnd.ms-modi", ".mdi"],
    ["FlashPix", "image/vnd.net-fpx", ".npx"],
    ["WAP Bitamp (WBMP)", "image/vnd.wap.wbmp", ".wbmp"],
    ["eXtended Image File Format (XIFF)", "image/vnd.xiff", ".xif"],
    ["WebP Image", "image/webp", ".webp"],
    ["CMU Image", "image/x-cmu-raster", ".ras"],
    ["Corel Metafile Exchange (CMX)", "image/x-cmx", ".cmx"],
    ["FreeHand MX", "image/x-freehand", ".fh"],
    ["Icon Image", "image/x-icon", ".ico"],
    ["PCX Image", "image/x-pcx", ".pcx"],
    ["PICT Image", "image/x-pict", ".pic"],
    ["Portable Anymap Image", "image/x-portable-anymap", ".pnm"],
    ["Portable Bitmap Format", "image/x-portable-bitmap", ".pbm"],
    ["Portable Graymap Format", "image/x-portable-graymap", ".pgm"],
    ["Portable Pixmap Format", "image/x-portable-pixmap", ".ppm"],
    ["Silicon Graphics RGB Bitmap", "image/x-rgb", ".rgb"],
    ["X BitMap", "image/x-xbitmap", ".xbm"],
    ["X PixMap", "image/x-xpixmap", ".xpm"],
    ["X Window Dump", "image/x-xwindowdump", ".xwd"],
    ["Email Message", "message/rfc822", ".eml"],
    ["Initial Graphics Exchange Specification (IGES)", "model/iges", ".igs"],
    ["Mesh Data Type", "model/mesh", ".msh"],
    ["COLLADA", "model/vnd.collada+xml", ".dae"],
    ["Autodesk Design Web Format (DWF)", "model/vnd.dwf", ".dwf"],
    ["Geometric Description Language (GDL)", "model/vnd.gdl", ".gdl"],
    ["Gen-Trix Studio", "model/vnd.gtw", ".gtw"],
    ["Virtue MTS", "model/vnd.mts", ".mts"],
    ["Virtue VTU", "model/vnd.vtu", ".vtu"],
    ["Virtual Reality Modeling Language", "model/vrml", ".wrl"],
    ["iCalendar", "text/calendar", ".ics"],
    ["Cascading Style Sheets (CSS)", "text/css", ".css"],
    ["Comma-Seperated Values", "text/csv", ".csv"],
    ["HyperText Markup Language (HTML)", "text/html", ".html"],
    ["Notation3", "text/n3", ".n3"],
    ["Text File", "text/plain", ".txt"],
    ["PRS Lines Tag", "text/prs.lines.tag", ".dsc"],
    ["Rich Text Format (RTF)", "text/richtext", ".rtx"],
    ["Standard Generalized Markup Language (SGML)", "text/sgml", ".sgml"],
    ["Tab Seperated Values", "text/tab-separated-values", ".tsv"],
    ["troff", "text/troff", ".t"],
    ["Turtle (Terse RDF Triple Language)", "text/turtle", ".ttl"],
    ["URI Resolution Services", "text/uri-list", ".uri"],
    ["Curl - Applet", "text/vnd.curl", ".curl"],
    ["Curl - Detached Applet", "text/vnd.curl.dcurl", ".dcurl"],
    ["Curl - Source Code", "text/vnd.curl.scurl", ".scurl"],
    ["Curl - Manifest File", "text/vnd.curl.mcurl", ".mcurl"],
    ["mod_fly / fly.cgi", "text/vnd.fly", ".fly"],
    ["FLEXSTOR", "text/vnd.fmi.flexstor", ".flx"],
    ["Graphviz", "text/vnd.graphviz", ".gv"],
    ["In3D - 3DML", "text/vnd.in3d.3dml", ".3dml"],
    ["In3D - 3DML", "text/vnd.in3d.spot", ".spot"],
    ["J2ME App Descriptor", "text/vnd.sun.j2me.app-descriptor", ".jad"],
    ["Wireless Markup Language (WML)", "text/vnd.wap.wml", ".wml"],
    ["Wireless Markup Language Script (WMLScript)", "text/vnd.wap.wmlscript", ".wmls"],
    ["Assembler Source File", "text/x-asm", ".s"],
    ["C Source File", "text/x-c", ".c"],
    ["Fortran Source File", "text/x-fortran", ".f"],
    ["Pascal Source File", "text/x-pascal", ".p"],
    ["Java Source File", "text/x-java-source,java", ".java"],
    ["Setext", "text/x-setext", ".etx"],
    ["UUEncode", "text/x-uuencode", ".uu"],
    ["vCalendar", "text/x-vcalendar", ".vcs"],
    ["vCard", "text/x-vcard", ".vcf"],
    ["3GP", "video/3gpp", ".3gp"],
    ["3GP2", "video/3gpp2", ".3g2"],
    ["H.261", "video/h261", ".h261"],
    ["H.263", "video/h263", ".h263"],
    ["H.264", "video/h264", ".h264"],
    ["JPGVideo", "video/jpeg", ".jpgv"],
    ["JPEG 2000 Compound Image File Format", "video/jpm", ".jpm"],
    ["Motion JPEG 2000", "video/mj2", ".mj2"],
    ["MPEG-4 Video", "video/mp4", ".mp4"],
    ["MPEG Video", "video/mpeg", ".mpeg"],
    ["Ogg Video", "video/ogg", ".ogv"],
    ["Quicktime Video", "video/quicktime", ".qt"],
    ["DECE High Definition Video", "video/vnd.dece.hd", ".uvh"],
    ["DECE Mobile Video", "video/vnd.dece.mobile", ".uvm"],
    ["DECE PD Video", "video/vnd.dece.pd", ".uvp"],
    ["DECE SD Video", "video/vnd.dece.sd", ".uvs"],
    ["DECE Video", "video/vnd.dece.video", ".uvv"],
    ["FAST Search & Transfer ASA", "video/vnd.fvt", ".fvt"],
    ["MPEG Url", "video/vnd.mpegurl", ".mxu"],
    ["Microsoft PlayReady Ecosystem Video", "video/vnd.ms-playready.media.pyv", ".pyv"],
    ["DECE MP4", "video/vnd.uvvu.mp4", ".uvu"],
    ["Vivo", "video/vnd.vivo", ".viv"],
    ["Open Web Media Project - Video", "video/webm", ".webm"],
    ["Flash Video", "video/x-f4v", ".f4v"],
    ["FLI/FLC Animation Format", "video/x-fli", ".fli"],
    ["Flash Video", "video/x-flv", ".flv"],
    ["M4v", "video/x-m4v", ".m4v"],
    ["Microsoft Advanced Systems Format (ASF)", "video/x-ms-asf", ".asf"],
    ["Microsoft Windows Media", "video/x-ms-wm", ".wm"],
    ["Microsoft Windows Media Video", "video/x-ms-wmv", ".wmv"],
    ["Microsoft Windows Media Audio/Video Playlist", "video/x-ms-wmx", ".wmx"],
    ["Microsoft Windows Media Video Playlist", "video/x-ms-wvx", ".wvx"],
    ["Audio Video Interleave (AVI)", "video/x-msvideo", ".avi"],
    ["SGI Movie", "video/x-sgi-movie", ".movie"],
    ["CoolTalk", "x-conference/x-cooltalk", ".ice"],
    ["BAS Partitur Format", "text/plain-bas", ".par"],
    ["YAML Ain't Markup Language / Yet Another Markup Language", "text/yaml", ".yaml"],
    ["Apple Disk Image", "application/x-apple-diskimage", ".dmg"],
    ["GPS eXchange Format", "application/gpx+xml", ".gpx"],
]
