# lmind

#### 介绍

这是一个简单的python插件, 主要功能是使用终端命令行搭建项目任务规划图，也可以用来做思维导图。

#### 软件架构
软件架构说明


#### 安装教程

1. pip install lmd

2. 安装环境：

- python >= 3.6

3. 项目依赖包：

- 1. PTable >= 0.9.2

#### 使用说明

##### 快速教程

1.  新建项目

安装软件后，就可以在bash命令行里使用'lmd'命令来新建项目：

`lmd -create 'new project'` or `lmd -c 'new project'`

2.  显示项目

使用`lmd -show` 或 `lmd -s`来查看项目:

`lmd -s` 或 `lmd -show`

可以指定'id'来指定要展示的项目或任务`lmd -s 1`。

```bash
+-------+-------------+----------+----------+---------+
| path  | name        | executor | deadline |  status |
+-------+-------------+----------+----------+---------+
| └── 1 | new project |          |          | working |
+-------+-------------+----------+----------+---------+
```

3. 使用`lmd -add` 或 `lmd -a` 命令来添加任务

`lmd -a 1 '任务1&&任务2'`

- 1 ：为project的id

- '任务1&&任务2': 为任务名, 多个任务名可以使用'&&'符号分隔，单个任务不需要'&&' 符号, 如果不包含空格或特殊符号可省去引号

```bash

+-----------+-------------+----------+----------+---------+
| path      | name        | executor | deadline |  status |
+-----------+-------------+----------+----------+---------+
| └── 1     | new project |          |          | working |
| │   ├── 2 | 任务1       |          |          | working |
| │   └── 3 | 任务2       |          |          | working |
+-----------+-------------+----------+----------+---------+
```

任务1下还可以添加任务:

`lmd -a 2 '任务3'`

- 2 ：为'任务1'的id

- '任务3': 为任务名

```bash
+---------------+-------------+----------+----------+---------+
| path          | name        | executor | deadline |  status |
+---------------+-------------+----------+----------+---------+
| └── 1         | new project |          |          | working |
| │   ├── 2     | 任务1       |          |          | working |
| │   │   └── 4 | 任务3       |          |          | working |
| │   └── 3     | 任务2       |          |          | working |
+---------------+-------------+----------+----------+---------+
```

4.  使用`lmd -executor` 或 `lmd -exe`为任务增加'执行人'

`lmd -executor 2-3 张三`

- 2-3 : 任务id，中间加'-'号是'到'的意思，意思是'从2到3'，如果是'2-5'，则包含id有'2,3,4,5'。

- 张三 : 执行人名称

`lmd -exe 4 李四`

```bash
+---------------+-------------+----------+----------+---------+
| path          | name        | executor | deadline |  status |
+---------------+-------------+----------+----------+---------+
| └── 1         | new project |          |          | working |
| │   ├── 2     | 任务1       |   张三   |          | working |
| │   │   └── 4 | 任务3       |   李四   |          | working |
| │   └── 3     | 任务2       |   张三   |          | working |
+---------------+-------------+----------+----------+---------+
```

5.  使用`lmd -deadline` 或 `lmd -dl`为任务增加'截止日期'

`lmd -deadline 2-3 20200603`

- 10-11: 任务id

- 20210603: 截止日期, 支持的日期格式有：yyyymmdd, yyyy/mm/dd, yyyy-mm-dd, yyyy.mm.dd

`lmd -dl 4 2022/07/09`

`lmd -dl 3 '2035.04.08'`

```bash

+---------------+-------------+----------+------------+---------+
| path          | name        | executor |  deadline  |  status |
+---------------+-------------+----------+------------+---------+
| └── 1         | new project |          |            | working |
| │   ├── 2     | 任务1       |   张三   |  20200603  | working |
| │   │   └── 4 | 任务3       |   李四   | 2022/07/09 | working |
| │   └── 3     | 任务2       |   张三   | 2035.04.08 | working |
+---------------+-------------+----------+------------+---------+
```

6.  改变任务状态

使用`lmd -work`, `lmd -done`, `lmd -cancel`, `lmd -stop` 分别把status修改成working, done, canceled, stopped四个状态

`lmd -done 2`

```bash

+---------------+-------------+----------+------------+---------+
| path          | name        | executor |  deadline  |  status |
+---------------+-------------+----------+------------+---------+
| └── 1         | new project |          |            | working |
| │   ├── 2     | 任务1       |   张三   |  20200603  |   done  |
| │   │   └── 4 | 任务3       |   李四   | 2022/07/09 |   done  |
| │   └── 3     | 任务2       |   张三   | 2035.04.08 | working |
+---------------+-------------+----------+------------+---------+
```

> 注：1. 状态更改会同时会更改子任务的状态

>     2. 当状态改为done时会自动更新'finish_date'

>     3. 当状态改为working时会清除'finish_date'


7. 使用`lmd -remove`或`lmd -rm`移除任务

`lmd -rm 2`

```bash

+-----------+-------------+----------+------------+---------+
| path      | name        | executor |  deadline  |  status |
+-----------+-------------+----------+------------+---------+
| └── 1     | new project |          |            | working |
| │   └── 3 | 任务2       |   张三   | 2035.04.08 | working |
+-----------+-------------+----------+------------+---------+

```

> 注：1. 移除任务同时会移除子任务

8. 使用`lmd -s --all` 来显示所有任务及所有信息，包括已移除的

`lmd -s --all`

```bash
+---------------+-------------+----------+-------------+------------+---------+---------+-------------+-------------+
| path          | name        | executor | description |  deadline  |  status | display | finish_date | create_date |
+---------------+-------------+----------+-------------+------------+---------+---------+-------------+-------------+
| └── 1         | new project |          |             |            | working |    1    |             |  2021-06-03 |
| │   ├── 2     | 任务1       |   张三   |             |  20200603  |   done  |    0    |  2021-06-03 |  2021-06-03 |
| │   │   └── 4 | 任务3       |   李四   |             | 2022/07/09 |   done  |    0    |  2021-06-03 |  2021-06-03 |
| │   └── 3     | 任务2       |   张三   |             | 2035.04.08 | working |    1    |             |  2021-06-03 |
+---------------+-------------+----------+-------------+------------+---------+---------+-------------+-------------+
```

9. 使用`lmd -back` 或 `lmd -bk`撤销移除

`lmd -bk 4`

```bash
+---------------+-------------+----------+------------+---------+
| path          | name        | executor |  deadline  |  status |
+---------------+-------------+----------+------------+---------+
| └── 1         | new project |          |            | working |
| │   ├── 2     | 任务1       |   张三   |  20200603  |   done  |
| │   │   └── 4 | 任务3       |   李四   | 2022/07/09 |   done  |
| │   └── 3     | 任务2       |   张三   | 2035.04.08 | working |
+---------------+-------------+----------+------------+---------+
```

> 注：1. 撤销移除的任务同时会撤销父级任务

10. 使用`lmd -description` 或 `lmd -desc` 添加任务描述信息

`lmd -desc 1 '这个项目任务2有延迟的风险'`

```bash
+---------------+-------------+----------+---------------------------+------------+---------+---------+-------------+-------------+
| path          | name        | executor |        description        |  deadline  |  status | display | finish_date | create_date |
+---------------+-------------+----------+---------------------------+------------+---------+---------+-------------+-------------+
| └── 1         | new project |          | 这个项目任务2有延迟的风险 |            | working |    1    |             |  2021-06-03 |
| │   ├── 2     | 任务1       |   张三   |                           |  20200603  |   done  |    1    |  2021-06-03 |  2021-06-03 |
| │   │   └── 4 | 任务3       |   李四   |                           | 2022/07/09 |   done  |    1    |  2021-06-03 |  2021-06-03 |
| │   └── 3     | 任务2       |   张三   |    遇到一些难解决的问题   | 2035.04.08 | working |    1    |             |  2021-06-03 |
+---------------+-------------+----------+---------------------------+------------+---------+---------+-------------+-------------+
```

11. 使用`lmd -name` 或 `lmd -na` 更改任务名称

`lmd -na 3 任务4`

```bash
+---------------+-------------+----------+------------+---------+
| path          | name        | executor |  deadline  |  status |
+---------------+-------------+----------+------------+---------+
| └── 1         | new project |          |            | working |
| │   ├── 2     | 任务1       |   张三   |  20200603  |   done  |
| │   │   └── 4 | 任务3       |   李四   | 2022/07/09 |   done  |
| │   └── 3     | 任务4       |   张三   | 2035.04.08 | working |
+---------------+-------------+----------+------------+---------+
```

12. 使用`lmd -update` 或 `lmd -u` 同时更改 'name', 'executor', 'description'和'deadline'的值

`lmd -u 4 'name=任务5&&executor=王五&&description=非常完美&&deadline=2025-12-01'`

或

`lmd -u 4 'na=任务5&&exe=王五&&desc=非常完美&&dl=2025-12-01'`

```bash
+---------------+-------------+----------+---------------------------+------------+---------+---------+-------------+-------------+
| path          | name        | executor |        description        |  deadline  |  status | display | finish_date | create_date |
+---------------+-------------+----------+---------------------------+------------+---------+---------+-------------+-------------+
| └── 1         | new project |          | 这个项目任务2有延迟的风险 |            | working |    1    |             |  2021-06-03 |
| │   ├── 2     | 任务1       |   张三   |                           |  20200603  |   done  |    1    |  2021-06-03 |  2021-06-03 |
| │   │   └── 4 | 任务5       |   王五   |          非常完美         | 2025-12-01 |   done  |    1    |  2021-06-03 |  2021-06-03 |
| │   └── 3     | 任务4       |   张三   |    遇到一些难解决的问题   | 2035.04.08 | working |    1    |             |  2021-06-03 |
+---------------+-------------+----------+---------------------------+------------+---------+---------+-------------+-------------+
```

13. 使用`lmd -show --where` 筛选要显示的内容

`lmd -s --where 'exe=张三'`

```bash
+-----------+-------+----------+------------+---------+
| path      | name  | executor |  deadline  |  status |
+-----------+-------+----------+------------+---------+
| │   ├── 2 | 任务1 |   张三   |  20200603  |   done  |
| │   └── 3 | 任务4 |   张三   | 2035.04.08 | working |
+-----------+-------+----------+------------+---------+
```


> 注：1. name, executor, description这两个值是模糊匹配，其他字段值都是完全匹配

>     2. 暂不支持正则匹配

>     3. 搜索出子任务会连带父任务一起显示


14. 使用`lmd -move` 或 `lmd -mv` 转移任务到另一个任务下

`lmd -mv 4 3`

```bash
+---------------+-------------+----------+------------+---------+
| path          | name        | executor |  deadline  |  status |
+---------------+-------------+----------+------------+---------+
| └── 1         | new project |          |            | working |
| │   ├── 2     | 任务1       |   张三   |  20200603  |   done  |
| │   └── 3     | 任务4       |   张三   | 2035.04.08 | working |
| │   │   └── 4 | 任务5       |   王五   | 2025-12-01 |   done  |
+---------------+-------------+----------+------------+---------+
```

> 注：移动任务时会携带子任务


15. 使用`lmd -delete` 或 `lmd -d`永久删除任务

`lmd -d 3`

```bash
+-----------+-------------+----------+----------+---------+
| path      | name        | executor | deadline |  status |
+-----------+-------------+----------+----------+---------+
| └── 1     | new project |          |          | working |
| │   └── 2 | 任务1       |   张三   | 20200603 |   done  |
+-----------+-------------+----------+----------+---------+
```

> 注：1. -delete 会永久删除，再来找不回来，没有回收站，也没有备份

>     2. 删除会携带子任务，子任务也会永久删除

使用`lmd -d --all` 是永久删除所有项目和任务


##### 全部命令

| 命令参数           | 命令说明                                        | 使用方法                                                                              |
| :------            | :------                                         | :------                                                                               |
| -h,-help           | 显示帮助信息                                    | lmd -h                                                                                |
| -show,-s           | 显示任务列表                                    | lmd -s [id]                                                                           |
| -all               | 在'-show','-delete'后面使用,表示对所有操作      | lmd -s --all, lmd -d --all                                                            |
| --where            | 在-show后面使用,作为show的筛选条件              | lmd -s [id] --where 'exe=name'                                                        |
| -create,-c         | 创建一个项目                                    | lmd -create [project-name]                                                            |
| -add,-a            | 在一个项目或任务增加新任务                      | lmd -add [id] '[task-name]&&[task-name]                                               |
| -remove,-rm        | 移除任务，使任务不再显示                        | lmd -remove [id]/([id]-[id])                                                          |
| -back,-bk          | 把已移除的任务重新显示                          | lmd -back [id]/([id]-[id])                                                            |
| -delete,-d         | 永久删除任务或项目                              | lmd -delete [id]/([id]-[id])                                                          |
| -move,-mv          | 把任务转移到另一个任务下面                      | lmd -move [id] [father-id]                                                            |
| -name,-na          | 更改任务名称                                    | lmd -name [id]/([id]-[id]) [new name]                                                 |
| -executor, -exe    | 更改任务执行人                                  | lmd -executor [id]/([id]-[id]) [new executor]                                         |
| -description,-desc | 更改任务描述                                    | lmd -desc [id]/([id]-[id]) [new desc]                                                 |
| -deadline,-dl      | 更改截止时间                                    | lmd -dl [id]/([id]-[id]) [new deadline]                                               |
| -update,-u         | 可以同时更改name,executor,description,deadline, | lmd -update [id] 'executor=[executor]&&description=[description]&&deadline=[deadline] |
| -work              | 更改status为working                             | lmd -work [id]/([id]-[id])                                                            |
| -done              | 更改status为done                                | lmd -done [id]/([id]-[id])                                                            |
| -cancel            | 更改status为canceled                            | lmd -cancel [id]/([id]-[id])                                                          |
| -stop              | 更改status为stopped                             | lmd -stop [id]/([id]-[id])                                                            |


#### 参与贡献

1.  Fork 本仓库
2.  新建 Feat_xxx 分支
3.  提交代码
4.  新建 Pull Request


#### 特技

1.  使用 Readme\_XXX.md 来支持不同的语言，例如 Readme\_en.md, Readme\_zh.md
2.  Gitee 官方博客 [blog.gitee.com](https://blog.gitee.com)
3.  你可以 [https://gitee.com/explore](https://gitee.com/explore) 这个地址来了解 Gitee 上的优秀开源项目
4.  [GVP](https://gitee.com/gvp) 全称是 Gitee 最有价值开源项目，是综合评定出的优秀开源项目
5.  Gitee 官方提供的使用手册 [https://gitee.com/help](https://gitee.com/help)
6.  Gitee 封面人物是一档用来展示 Gitee 会员风采的栏目 [https://gitee.com/gitee-stars/](https://gitee.com/gitee-stars/)
