# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool, StrictInt, conlist, constr 
from luminesce.models.auto_detect_type import AutoDetectType
from luminesce.models.column_info import ColumnInfo
from luminesce.models.options_csv import OptionsCsv
from luminesce.models.options_excel import OptionsExcel
from luminesce.models.options_parquet import OptionsParquet
from luminesce.models.options_sq_lite import OptionsSqLite
from luminesce.models.options_xml import OptionsXml
from luminesce.models.source import Source

class FileReaderBuilderDef(BaseModel):
    """
    Information on how to construct a file-read sql query  # noqa: E501
    """
    auto_detect: Optional[AutoDetectType] = Field(None, alias="autoDetect")
    columns: Optional[conlist(ColumnInfo)] = Field(None, description="Column information for the results")
    limit: Optional[StrictInt] = Field(None, description="What limit be added to the load query?  Less than or equal to zero means none")
    source: Optional[Source] = None
    available_sources: Optional[conlist(Source)] = Field(None, alias="availableSources", description="The source locations the user has access to.  The provider in essence.")
    variable_name:  Optional[StrictStr] = Field(None,alias="variableName", description="The name of the variable for the `use` statement") 
    file_path:  Optional[StrictStr] = Field(None,alias="filePath", description="The file (or folder) path") 
    folder_filter:  Optional[StrictStr] = Field(None,alias="folderFilter", description="The filter to apply to a folder (all matching files then being read) a RegExp") 
    zip_filter:  Optional[StrictStr] = Field(None,alias="zipFilter", description="The filter to apply to folder structures with zip archives (all matching files then being read) a RegExp") 
    add_file_name: Optional[StrictBool] = Field(None, alias="addFileName", description="Should a file name column be added to the output?")
    csv: Optional[OptionsCsv] = None
    excel: Optional[OptionsExcel] = None
    sq_lite: Optional[OptionsSqLite] = Field(None, alias="sqLite")
    xml: Optional[OptionsXml] = None
    parquet: Optional[OptionsParquet] = None
    __properties = ["autoDetect", "columns", "limit", "source", "availableSources", "variableName", "filePath", "folderFilter", "zipFilter", "addFileName", "csv", "excel", "sqLite", "xml", "parquet"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FileReaderBuilderDef:
        """Create an instance of FileReaderBuilderDef from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in columns (list)
        _items = []
        if self.columns:
            for _item in self.columns:
                if _item:
                    _items.append(_item.to_dict())
            _dict['columns'] = _items
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in available_sources (list)
        _items = []
        if self.available_sources:
            for _item in self.available_sources:
                if _item:
                    _items.append(_item.to_dict())
            _dict['availableSources'] = _items
        # override the default output from pydantic by calling `to_dict()` of csv
        if self.csv:
            _dict['csv'] = self.csv.to_dict()
        # override the default output from pydantic by calling `to_dict()` of excel
        if self.excel:
            _dict['excel'] = self.excel.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sq_lite
        if self.sq_lite:
            _dict['sqLite'] = self.sq_lite.to_dict()
        # override the default output from pydantic by calling `to_dict()` of xml
        if self.xml:
            _dict['xml'] = self.xml.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parquet
        if self.parquet:
            _dict['parquet'] = self.parquet.to_dict()
        # set to None if columns (nullable) is None
        # and __fields_set__ contains the field
        if self.columns is None and "columns" in self.__fields_set__:
            _dict['columns'] = None

        # set to None if available_sources (nullable) is None
        # and __fields_set__ contains the field
        if self.available_sources is None and "available_sources" in self.__fields_set__:
            _dict['availableSources'] = None

        # set to None if variable_name (nullable) is None
        # and __fields_set__ contains the field
        if self.variable_name is None and "variable_name" in self.__fields_set__:
            _dict['variableName'] = None

        # set to None if file_path (nullable) is None
        # and __fields_set__ contains the field
        if self.file_path is None and "file_path" in self.__fields_set__:
            _dict['filePath'] = None

        # set to None if folder_filter (nullable) is None
        # and __fields_set__ contains the field
        if self.folder_filter is None and "folder_filter" in self.__fields_set__:
            _dict['folderFilter'] = None

        # set to None if zip_filter (nullable) is None
        # and __fields_set__ contains the field
        if self.zip_filter is None and "zip_filter" in self.__fields_set__:
            _dict['zipFilter'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FileReaderBuilderDef:
        """Create an instance of FileReaderBuilderDef from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FileReaderBuilderDef.parse_obj(obj)

        _obj = FileReaderBuilderDef.parse_obj({
            "auto_detect": obj.get("autoDetect"),
            "columns": [ColumnInfo.from_dict(_item) for _item in obj.get("columns")] if obj.get("columns") is not None else None,
            "limit": obj.get("limit"),
            "source": Source.from_dict(obj.get("source")) if obj.get("source") is not None else None,
            "available_sources": [Source.from_dict(_item) for _item in obj.get("availableSources")] if obj.get("availableSources") is not None else None,
            "variable_name": obj.get("variableName"),
            "file_path": obj.get("filePath"),
            "folder_filter": obj.get("folderFilter"),
            "zip_filter": obj.get("zipFilter"),
            "add_file_name": obj.get("addFileName"),
            "csv": OptionsCsv.from_dict(obj.get("csv")) if obj.get("csv") is not None else None,
            "excel": OptionsExcel.from_dict(obj.get("excel")) if obj.get("excel") is not None else None,
            "sq_lite": OptionsSqLite.from_dict(obj.get("sqLite")) if obj.get("sqLite") is not None else None,
            "xml": OptionsXml.from_dict(obj.get("xml")) if obj.get("xml") is not None else None,
            "parquet": OptionsParquet.from_dict(obj.get("parquet")) if obj.get("parquet") is not None else None
        })
        return _obj
