# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List


class Config(TeaModel):
    """
    Model for initing client
    """
    def __init__(
        self,
        access_key_id: str = None,
        access_key_secret: str = None,
        security_token: str = None,
        protocol: str = None,
        read_timeout: int = None,
        connect_timeout: int = None,
        http_proxy: str = None,
        https_proxy: str = None,
        endpoint: str = None,
        no_proxy: str = None,
        max_idle_conns: int = None,
        user_agent: str = None,
        socks_5proxy: str = None,
        socks_5net_work: str = None,
        max_idle_time_millis: int = None,
        keep_alive_duration_millis: int = None,
        max_requests: int = None,
        max_requests_per_host: int = None,
    ):
        # accesskey id
        self.access_key_id = access_key_id
        # accesskey secret
        self.access_key_secret = access_key_secret
        # security token
        self.security_token = security_token
        # http protocol
        self.protocol = protocol
        # read timeout
        self.read_timeout = read_timeout
        # connect timeout
        self.connect_timeout = connect_timeout
        # http proxy
        self.http_proxy = http_proxy
        # https proxy
        self.https_proxy = https_proxy
        # endpoint
        self.endpoint = endpoint
        # proxy white list
        self.no_proxy = no_proxy
        # max idle conns
        self.max_idle_conns = max_idle_conns
        # user agent
        self.user_agent = user_agent
        # socks5 proxy
        self.socks_5proxy = socks_5proxy
        # socks5 network
        self.socks_5net_work = socks_5net_work
        # 长链接最大空闲时长
        self.max_idle_time_millis = max_idle_time_millis
        # 长链接最大连接时长
        self.keep_alive_duration_millis = keep_alive_duration_millis
        # 最大连接数（长链接最大总数）
        self.max_requests = max_requests
        # 每个目标主机的最大连接数（分主机域名的长链接最大总数
        self.max_requests_per_host = max_requests_per_host

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key_id is not None:
            result['accessKeyId'] = self.access_key_id
        if self.access_key_secret is not None:
            result['accessKeySecret'] = self.access_key_secret
        if self.security_token is not None:
            result['securityToken'] = self.security_token
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.read_timeout is not None:
            result['readTimeout'] = self.read_timeout
        if self.connect_timeout is not None:
            result['connectTimeout'] = self.connect_timeout
        if self.http_proxy is not None:
            result['httpProxy'] = self.http_proxy
        if self.https_proxy is not None:
            result['httpsProxy'] = self.https_proxy
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.no_proxy is not None:
            result['noProxy'] = self.no_proxy
        if self.max_idle_conns is not None:
            result['maxIdleConns'] = self.max_idle_conns
        if self.user_agent is not None:
            result['userAgent'] = self.user_agent
        if self.socks_5proxy is not None:
            result['socks5Proxy'] = self.socks_5proxy
        if self.socks_5net_work is not None:
            result['socks5NetWork'] = self.socks_5net_work
        if self.max_idle_time_millis is not None:
            result['maxIdleTimeMillis'] = self.max_idle_time_millis
        if self.keep_alive_duration_millis is not None:
            result['keepAliveDurationMillis'] = self.keep_alive_duration_millis
        if self.max_requests is not None:
            result['maxRequests'] = self.max_requests
        if self.max_requests_per_host is not None:
            result['maxRequestsPerHost'] = self.max_requests_per_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessKeyId') is not None:
            self.access_key_id = m.get('accessKeyId')
        if m.get('accessKeySecret') is not None:
            self.access_key_secret = m.get('accessKeySecret')
        if m.get('securityToken') is not None:
            self.security_token = m.get('securityToken')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('readTimeout') is not None:
            self.read_timeout = m.get('readTimeout')
        if m.get('connectTimeout') is not None:
            self.connect_timeout = m.get('connectTimeout')
        if m.get('httpProxy') is not None:
            self.http_proxy = m.get('httpProxy')
        if m.get('httpsProxy') is not None:
            self.https_proxy = m.get('httpsProxy')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('noProxy') is not None:
            self.no_proxy = m.get('noProxy')
        if m.get('maxIdleConns') is not None:
            self.max_idle_conns = m.get('maxIdleConns')
        if m.get('userAgent') is not None:
            self.user_agent = m.get('userAgent')
        if m.get('socks5Proxy') is not None:
            self.socks_5proxy = m.get('socks5Proxy')
        if m.get('socks5NetWork') is not None:
            self.socks_5net_work = m.get('socks5NetWork')
        if m.get('maxIdleTimeMillis') is not None:
            self.max_idle_time_millis = m.get('maxIdleTimeMillis')
        if m.get('keepAliveDurationMillis') is not None:
            self.keep_alive_duration_millis = m.get('keepAliveDurationMillis')
        if m.get('maxRequests') is not None:
            self.max_requests = m.get('maxRequests')
        if m.get('maxRequestsPerHost') is not None:
            self.max_requests_per_host = m.get('maxRequestsPerHost')
        return self


class JudicialFileInfo(TeaModel):
    def __init__(
        self,
        file_name: str = None,
        file_key: str = None,
        download_url: str = None,
        judicial_file_type: str = None,
    ):
        # 文件全名, 包含后缀
        self.file_name = file_name
        # 文件key
        self.file_key = file_key
        # 文件下载地址
        self.download_url = download_url
        # 司法纠纷平台文件类型
        self.judicial_file_type = judicial_file_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.file_key is not None:
            result['file_key'] = self.file_key
        if self.download_url is not None:
            result['download_url'] = self.download_url
        if self.judicial_file_type is not None:
            result['judicial_file_type'] = self.judicial_file_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('file_key') is not None:
            self.file_key = m.get('file_key')
        if m.get('download_url') is not None:
            self.download_url = m.get('download_url')
        if m.get('judicial_file_type') is not None:
            self.judicial_file_type = m.get('judicial_file_type')
        return self


class FileInfo(TeaModel):
    def __init__(
        self,
        file_key: str = None,
        file_name: str = None,
    ):
        # 文件key
        self.file_key = file_key
        # 文件名称
        self.file_name = file_name

    def validate(self):
        self.validate_required(self.file_key, 'file_key')
        self.validate_required(self.file_name, 'file_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_key is not None:
            result['file_key'] = self.file_key
        if self.file_name is not None:
            result['file_name'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('file_key') is not None:
            self.file_key = m.get('file_key')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        return self


class RentalInstallmentPerformance(TeaModel):
    def __init__(
        self,
        repayment_period: int = None,
        rent_payment_type: str = None,
        applied_repayment_time: str = None,
        applied_repayment_amount: str = None,
    ):
        # 被申请人还款期数
        self.repayment_period = repayment_period
        # 被申请人第几期租金支付方式
        self.rent_payment_type = rent_payment_type
        # 被申请人第几期还款时间
        self.applied_repayment_time = applied_repayment_time
        # 被申请人第几期还款金额
        self.applied_repayment_amount = applied_repayment_amount

    def validate(self):
        self.validate_required(self.repayment_period, 'repayment_period')
        self.validate_required(self.rent_payment_type, 'rent_payment_type')
        self.validate_required(self.applied_repayment_time, 'applied_repayment_time')
        self.validate_required(self.applied_repayment_amount, 'applied_repayment_amount')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.repayment_period is not None:
            result['repayment_period'] = self.repayment_period
        if self.rent_payment_type is not None:
            result['rent_payment_type'] = self.rent_payment_type
        if self.applied_repayment_time is not None:
            result['applied_repayment_time'] = self.applied_repayment_time
        if self.applied_repayment_amount is not None:
            result['applied_repayment_amount'] = self.applied_repayment_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('repayment_period') is not None:
            self.repayment_period = m.get('repayment_period')
        if m.get('rent_payment_type') is not None:
            self.rent_payment_type = m.get('rent_payment_type')
        if m.get('applied_repayment_time') is not None:
            self.applied_repayment_time = m.get('applied_repayment_time')
        if m.get('applied_repayment_amount') is not None:
            self.applied_repayment_amount = m.get('applied_repayment_amount')
        return self


class OrderItem(TeaModel):
    def __init__(
        self,
        product_name: str = None,
        commodity_brand: str = None,
        commodity_version: str = None,
        commodity_specification: str = None,
        commodity_color: str = None,
        commodity_details: str = None,
        commodity_official_price: str = None,
        lease_number: int = None,
    ):
        # 产品名称
        self.product_name = product_name
        # 商品品牌
        self.commodity_brand = commodity_brand
        # 商品版本
        self.commodity_version = commodity_version
        # 商品规格
        self.commodity_specification = commodity_specification
        # 商品颜色
        self.commodity_color = commodity_color
        # 商品详情
        self.commodity_details = commodity_details
        # 商品官方价格
        self.commodity_official_price = commodity_official_price
        # 租赁物数量
        self.lease_number = lease_number

    def validate(self):
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.commodity_brand, 'commodity_brand')
        self.validate_required(self.commodity_version, 'commodity_version')
        self.validate_required(self.commodity_specification, 'commodity_specification')
        self.validate_required(self.commodity_official_price, 'commodity_official_price')
        self.validate_required(self.lease_number, 'lease_number')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_name is not None:
            result['product_name'] = self.product_name
        if self.commodity_brand is not None:
            result['commodity_brand'] = self.commodity_brand
        if self.commodity_version is not None:
            result['commodity_version'] = self.commodity_version
        if self.commodity_specification is not None:
            result['commodity_specification'] = self.commodity_specification
        if self.commodity_color is not None:
            result['commodity_color'] = self.commodity_color
        if self.commodity_details is not None:
            result['commodity_details'] = self.commodity_details
        if self.commodity_official_price is not None:
            result['commodity_official_price'] = self.commodity_official_price
        if self.lease_number is not None:
            result['lease_number'] = self.lease_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('product_name') is not None:
            self.product_name = m.get('product_name')
        if m.get('commodity_brand') is not None:
            self.commodity_brand = m.get('commodity_brand')
        if m.get('commodity_version') is not None:
            self.commodity_version = m.get('commodity_version')
        if m.get('commodity_specification') is not None:
            self.commodity_specification = m.get('commodity_specification')
        if m.get('commodity_color') is not None:
            self.commodity_color = m.get('commodity_color')
        if m.get('commodity_details') is not None:
            self.commodity_details = m.get('commodity_details')
        if m.get('commodity_official_price') is not None:
            self.commodity_official_price = m.get('commodity_official_price')
        if m.get('lease_number') is not None:
            self.lease_number = m.get('lease_number')
        return self


class RentalStagingInformation(TeaModel):
    def __init__(
        self,
        installments_number: int = None,
        payment_time_each_cycle: str = None,
        payment_each_cycle: str = None,
    ):
        # 分期期数
        self.installments_number = installments_number
        # 租金每期应还款时间
        self.payment_time_each_cycle = payment_time_each_cycle
        # 租金每期应还款额
        self.payment_each_cycle = payment_each_cycle

    def validate(self):
        self.validate_required(self.installments_number, 'installments_number')
        self.validate_required(self.payment_time_each_cycle, 'payment_time_each_cycle')
        self.validate_required(self.payment_each_cycle, 'payment_each_cycle')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.installments_number is not None:
            result['installments_number'] = self.installments_number
        if self.payment_time_each_cycle is not None:
            result['payment_time_each_cycle'] = self.payment_time_each_cycle
        if self.payment_each_cycle is not None:
            result['payment_each_cycle'] = self.payment_each_cycle
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('installments_number') is not None:
            self.installments_number = m.get('installments_number')
        if m.get('payment_time_each_cycle') is not None:
            self.payment_time_each_cycle = m.get('payment_time_each_cycle')
        if m.get('payment_each_cycle') is not None:
            self.payment_each_cycle = m.get('payment_each_cycle')
        return self


class NotaryUser(TeaModel):
    def __init__(
        self,
        user_type: str = None,
        cert_type: str = None,
        cert_name: str = None,
        cert_no: str = None,
        person_mobile_no: str = None,
        legal_person_cert_type: str = None,
        legal_person_cert_name: str = None,
        legal_person_cert_no: str = None,
        legal_person_mobile_no: str = None,
        properties: str = None,
    ):
        # 用户类型，PERSON或者ENTERPRISE
        self.user_type = user_type
        # 证件类型
        # ● 个人：支持身份证IDENTITY_CARD
        # ● 企业：支持UNIFIED_SOCIAL_CREDIT_CODE（统一社会信用代码）和ENTERPRISE_REGISTERED_NUMBER（企业工商注册号）
        self.cert_type = cert_type
        # 证件用户名称
        # ● 个人：身份证姓名
        # ● 企业：企业名称
        self.cert_name = cert_name
        # 证件号
        # ● 个人：身份证号
        # ● 企业：社会统一信用代码或企业工商注册号，与证件类型保持一致即可
        self.cert_no = cert_no
        # 个人必填，用户手机号码
        self.person_mobile_no = person_mobile_no
        # 企业选填，法人证件类型，仅支持身份证，IDENTITY_CARD
        self.legal_person_cert_type = legal_person_cert_type
        # 企业选填，法人身份证姓名
        self.legal_person_cert_name = legal_person_cert_name
        # 企业选填，法人身份证号
        self.legal_person_cert_no = legal_person_cert_no
        # 企业选填，法人手机号
        self.legal_person_mobile_no = legal_person_mobile_no
        # 扩展属性
        self.properties = properties

    def validate(self):
        self.validate_required(self.user_type, 'user_type')
        self.validate_required(self.cert_type, 'cert_type')
        self.validate_required(self.cert_name, 'cert_name')
        self.validate_required(self.cert_no, 'cert_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_type is not None:
            result['user_type'] = self.user_type
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        if self.cert_name is not None:
            result['cert_name'] = self.cert_name
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.person_mobile_no is not None:
            result['person_mobile_no'] = self.person_mobile_no
        if self.legal_person_cert_type is not None:
            result['legal_person_cert_type'] = self.legal_person_cert_type
        if self.legal_person_cert_name is not None:
            result['legal_person_cert_name'] = self.legal_person_cert_name
        if self.legal_person_cert_no is not None:
            result['legal_person_cert_no'] = self.legal_person_cert_no
        if self.legal_person_mobile_no is not None:
            result['legal_person_mobile_no'] = self.legal_person_mobile_no
        if self.properties is not None:
            result['properties'] = self.properties
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        if m.get('cert_name') is not None:
            self.cert_name = m.get('cert_name')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('person_mobile_no') is not None:
            self.person_mobile_no = m.get('person_mobile_no')
        if m.get('legal_person_cert_type') is not None:
            self.legal_person_cert_type = m.get('legal_person_cert_type')
        if m.get('legal_person_cert_name') is not None:
            self.legal_person_cert_name = m.get('legal_person_cert_name')
        if m.get('legal_person_cert_no') is not None:
            self.legal_person_cert_no = m.get('legal_person_cert_no')
        if m.get('legal_person_mobile_no') is not None:
            self.legal_person_mobile_no = m.get('legal_person_mobile_no')
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        return self


class OrderInfo(TeaModel):
    def __init__(
        self,
        lessor_platform_name: str = None,
        order_number: str = None,
        contract_no: str = None,
        contract_name: str = None,
        order_items: List[OrderItem] = None,
        total_device_price: str = None,
        deposit_amount: str = None,
        free_deposit: str = None,
        signing_time: str = None,
        lease_start_time: str = None,
        lease_end_time: str = None,
        buyout_amount_formula_calc: str = None,
        pay_in_advance: str = None,
    ):
        # 出租方平台名称
        self.lessor_platform_name = lessor_platform_name
        # 订单号
        self.order_number = order_number
        # 合同编号
        self.contract_no = contract_no
        # 合同名称
        self.contract_name = contract_name
        # 订单商品信息
        self.order_items = order_items
        # 设备及配件总价
        self.total_device_price = total_device_price
        # 押金金额
        self.deposit_amount = deposit_amount
        # 免押金额
        self.free_deposit = free_deposit
        # 签约时间
        self.signing_time = signing_time
        # 租期起始时间
        self.lease_start_time = lease_start_time
        # 租期结束时间
        self.lease_end_time = lease_end_time
        # 买断金额计算公式
        self.buyout_amount_formula_calc = buyout_amount_formula_calc
        # 首付款
        self.pay_in_advance = pay_in_advance

    def validate(self):
        self.validate_required(self.lessor_platform_name, 'lessor_platform_name')
        self.validate_required(self.order_number, 'order_number')
        self.validate_required(self.contract_no, 'contract_no')
        self.validate_required(self.contract_name, 'contract_name')
        self.validate_required(self.order_items, 'order_items')
        if self.order_items:
            for k in self.order_items:
                if k:
                    k.validate()
        self.validate_required(self.total_device_price, 'total_device_price')
        self.validate_required(self.deposit_amount, 'deposit_amount')
        self.validate_required(self.free_deposit, 'free_deposit')
        self.validate_required(self.signing_time, 'signing_time')
        self.validate_required(self.lease_start_time, 'lease_start_time')
        self.validate_required(self.lease_end_time, 'lease_end_time')
        self.validate_required(self.buyout_amount_formula_calc, 'buyout_amount_formula_calc')
        self.validate_required(self.pay_in_advance, 'pay_in_advance')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lessor_platform_name is not None:
            result['lessor_platform_name'] = self.lessor_platform_name
        if self.order_number is not None:
            result['order_number'] = self.order_number
        if self.contract_no is not None:
            result['contract_no'] = self.contract_no
        if self.contract_name is not None:
            result['contract_name'] = self.contract_name
        result['order_items'] = []
        if self.order_items is not None:
            for k in self.order_items:
                result['order_items'].append(k.to_map() if k else None)
        if self.total_device_price is not None:
            result['total_device_price'] = self.total_device_price
        if self.deposit_amount is not None:
            result['deposit_amount'] = self.deposit_amount
        if self.free_deposit is not None:
            result['free_deposit'] = self.free_deposit
        if self.signing_time is not None:
            result['signing_time'] = self.signing_time
        if self.lease_start_time is not None:
            result['lease_start_time'] = self.lease_start_time
        if self.lease_end_time is not None:
            result['lease_end_time'] = self.lease_end_time
        if self.buyout_amount_formula_calc is not None:
            result['buyout_amount_formula_calc'] = self.buyout_amount_formula_calc
        if self.pay_in_advance is not None:
            result['pay_in_advance'] = self.pay_in_advance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('lessor_platform_name') is not None:
            self.lessor_platform_name = m.get('lessor_platform_name')
        if m.get('order_number') is not None:
            self.order_number = m.get('order_number')
        if m.get('contract_no') is not None:
            self.contract_no = m.get('contract_no')
        if m.get('contract_name') is not None:
            self.contract_name = m.get('contract_name')
        self.order_items = []
        if m.get('order_items') is not None:
            for k in m.get('order_items'):
                temp_model = OrderItem()
                self.order_items.append(temp_model.from_map(k))
        if m.get('total_device_price') is not None:
            self.total_device_price = m.get('total_device_price')
        if m.get('deposit_amount') is not None:
            self.deposit_amount = m.get('deposit_amount')
        if m.get('free_deposit') is not None:
            self.free_deposit = m.get('free_deposit')
        if m.get('signing_time') is not None:
            self.signing_time = m.get('signing_time')
        if m.get('lease_start_time') is not None:
            self.lease_start_time = m.get('lease_start_time')
        if m.get('lease_end_time') is not None:
            self.lease_end_time = m.get('lease_end_time')
        if m.get('buyout_amount_formula_calc') is not None:
            self.buyout_amount_formula_calc = m.get('buyout_amount_formula_calc')
        if m.get('pay_in_advance') is not None:
            self.pay_in_advance = m.get('pay_in_advance')
        return self


class LogisticsInfo(TeaModel):
    def __init__(
        self,
        delivery_time: str = None,
        express_logistics_company: str = None,
        courier_number: str = None,
        sign_time: str = None,
    ):
        # 发货时间
        self.delivery_time = delivery_time
        # 快递物流公司
        self.express_logistics_company = express_logistics_company
        # 快递单号
        self.courier_number = courier_number
        # 签收时间
        self.sign_time = sign_time

    def validate(self):
        self.validate_required(self.delivery_time, 'delivery_time')
        self.validate_required(self.express_logistics_company, 'express_logistics_company')
        self.validate_required(self.courier_number, 'courier_number')
        self.validate_required(self.sign_time, 'sign_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_time is not None:
            result['delivery_time'] = self.delivery_time
        if self.express_logistics_company is not None:
            result['express_logistics_company'] = self.express_logistics_company
        if self.courier_number is not None:
            result['courier_number'] = self.courier_number
        if self.sign_time is not None:
            result['sign_time'] = self.sign_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('delivery_time') is not None:
            self.delivery_time = m.get('delivery_time')
        if m.get('express_logistics_company') is not None:
            self.express_logistics_company = m.get('express_logistics_company')
        if m.get('courier_number') is not None:
            self.courier_number = m.get('courier_number')
        if m.get('sign_time') is not None:
            self.sign_time = m.get('sign_time')
        return self


class ContractDocSignVerifySignatureInfo(TeaModel):
    def __init__(
        self,
        is_modify: bool = None,
        time_from: str = None,
        sign_date: str = None,
    ):
        # 是否篡改
        self.is_modify = is_modify
        # 签署时间来源
        self.time_from = time_from
        # 签署时间
        self.sign_date = sign_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_modify is not None:
            result['is_modify'] = self.is_modify
        if self.time_from is not None:
            result['time_from'] = self.time_from
        if self.sign_date is not None:
            result['sign_date'] = self.sign_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('is_modify') is not None:
            self.is_modify = m.get('is_modify')
        if m.get('time_from') is not None:
            self.time_from = m.get('time_from')
        if m.get('sign_date') is not None:
            self.sign_date = m.get('sign_date')
        return self


class PerformanceInfo(TeaModel):
    def __init__(
        self,
        rent_pay_total: str = None,
        buyout_amount: str = None,
        rental_installment_performance: List[RentalInstallmentPerformance] = None,
    ):
        # 支付租金总额
        self.rent_pay_total = rent_pay_total
        # 买断金额
        self.buyout_amount = buyout_amount
        # 租赁分期履约信息
        self.rental_installment_performance = rental_installment_performance

    def validate(self):
        self.validate_required(self.rent_pay_total, 'rent_pay_total')
        self.validate_required(self.buyout_amount, 'buyout_amount')
        if self.rental_installment_performance:
            for k in self.rental_installment_performance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rent_pay_total is not None:
            result['rent_pay_total'] = self.rent_pay_total
        if self.buyout_amount is not None:
            result['buyout_amount'] = self.buyout_amount
        result['rental_installment_performance'] = []
        if self.rental_installment_performance is not None:
            for k in self.rental_installment_performance:
                result['rental_installment_performance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rent_pay_total') is not None:
            self.rent_pay_total = m.get('rent_pay_total')
        if m.get('buyout_amount') is not None:
            self.buyout_amount = m.get('buyout_amount')
        self.rental_installment_performance = []
        if m.get('rental_installment_performance') is not None:
            for k in m.get('rental_installment_performance'):
                temp_model = RentalInstallmentPerformance()
                self.rental_installment_performance.append(temp_model.from_map(k))
        return self


class ContractTextSignVerifyCertInfo(TeaModel):
    def __init__(
        self,
        owner: str = None,
        serial: str = None,
        start_date: str = None,
        end_date: str = None,
        issuer_cn: str = None,
    ):
        # 证书所有者
        self.owner = owner
        # 证书序列号
        self.serial = serial
        # 证书有效期开始时间
        self.start_date = start_date
        # 证书有效期结束时间
        self.end_date = end_date
        # 证书发布者名称
        self.issuer_cn = issuer_cn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['owner'] = self.owner
        if self.serial is not None:
            result['serial'] = self.serial
        if self.start_date is not None:
            result['start_date'] = self.start_date
        if self.end_date is not None:
            result['end_date'] = self.end_date
        if self.issuer_cn is not None:
            result['issuer_cn'] = self.issuer_cn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('owner') is not None:
            self.owner = m.get('owner')
        if m.get('serial') is not None:
            self.serial = m.get('serial')
        if m.get('start_date') is not None:
            self.start_date = m.get('start_date')
        if m.get('end_date') is not None:
            self.end_date = m.get('end_date')
        if m.get('issuer_cn') is not None:
            self.issuer_cn = m.get('issuer_cn')
        return self


class LeaseOrderInfo(TeaModel):
    def __init__(
        self,
        lessor_platform_name: str = None,
        order_number: str = None,
        contract_no: str = None,
        contract_name: str = None,
        order_items: List[OrderItem] = None,
        total_device_price: str = None,
        deposit_amount: str = None,
        free_deposit: str = None,
        sign_time: str = None,
        lease_start_time: str = None,
        lease_end_time: str = None,
        buyout_amount_formula_calc: str = None,
        pay_in_advance: str = None,
        order_create_time: str = None,
        buy_out_price: str = None,
    ):
        # 出租方平台名称
        self.lessor_platform_name = lessor_platform_name
        # 订单号
        self.order_number = order_number
        # 合同编号
        self.contract_no = contract_no
        # 合同名称
        self.contract_name = contract_name
        # 订单商品信息列表
        self.order_items = order_items
        # 设备及配件总价（单位元）
        self.total_device_price = total_device_price
        # 押金金额（单位元）
        self.deposit_amount = deposit_amount
        # 免押金额
        self.free_deposit = free_deposit
        # 签约时间
        self.sign_time = sign_time
        # 租期起始时间
        self.lease_start_time = lease_start_time
        # 租期结束时间
        self.lease_end_time = lease_end_time
        # 买断金额计算公式
        self.buyout_amount_formula_calc = buyout_amount_formula_calc
        # 首付款（单位元）
        self.pay_in_advance = pay_in_advance
        # 创建时间
        self.order_create_time = order_create_time
        # 到期买断价 保留两位小数 单位元
        self.buy_out_price = buy_out_price

    def validate(self):
        self.validate_required(self.order_number, 'order_number')
        self.validate_required(self.order_items, 'order_items')
        if self.order_items:
            for k in self.order_items:
                if k:
                    k.validate()
        self.validate_required(self.total_device_price, 'total_device_price')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lessor_platform_name is not None:
            result['lessor_platform_name'] = self.lessor_platform_name
        if self.order_number is not None:
            result['order_number'] = self.order_number
        if self.contract_no is not None:
            result['contract_no'] = self.contract_no
        if self.contract_name is not None:
            result['contract_name'] = self.contract_name
        result['order_items'] = []
        if self.order_items is not None:
            for k in self.order_items:
                result['order_items'].append(k.to_map() if k else None)
        if self.total_device_price is not None:
            result['total_device_price'] = self.total_device_price
        if self.deposit_amount is not None:
            result['deposit_amount'] = self.deposit_amount
        if self.free_deposit is not None:
            result['free_deposit'] = self.free_deposit
        if self.sign_time is not None:
            result['sign_time'] = self.sign_time
        if self.lease_start_time is not None:
            result['lease_start_time'] = self.lease_start_time
        if self.lease_end_time is not None:
            result['lease_end_time'] = self.lease_end_time
        if self.buyout_amount_formula_calc is not None:
            result['buyout_amount_formula_calc'] = self.buyout_amount_formula_calc
        if self.pay_in_advance is not None:
            result['pay_in_advance'] = self.pay_in_advance
        if self.order_create_time is not None:
            result['order_create_time'] = self.order_create_time
        if self.buy_out_price is not None:
            result['buy_out_price'] = self.buy_out_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('lessor_platform_name') is not None:
            self.lessor_platform_name = m.get('lessor_platform_name')
        if m.get('order_number') is not None:
            self.order_number = m.get('order_number')
        if m.get('contract_no') is not None:
            self.contract_no = m.get('contract_no')
        if m.get('contract_name') is not None:
            self.contract_name = m.get('contract_name')
        self.order_items = []
        if m.get('order_items') is not None:
            for k in m.get('order_items'):
                temp_model = OrderItem()
                self.order_items.append(temp_model.from_map(k))
        if m.get('total_device_price') is not None:
            self.total_device_price = m.get('total_device_price')
        if m.get('deposit_amount') is not None:
            self.deposit_amount = m.get('deposit_amount')
        if m.get('free_deposit') is not None:
            self.free_deposit = m.get('free_deposit')
        if m.get('sign_time') is not None:
            self.sign_time = m.get('sign_time')
        if m.get('lease_start_time') is not None:
            self.lease_start_time = m.get('lease_start_time')
        if m.get('lease_end_time') is not None:
            self.lease_end_time = m.get('lease_end_time')
        if m.get('buyout_amount_formula_calc') is not None:
            self.buyout_amount_formula_calc = m.get('buyout_amount_formula_calc')
        if m.get('pay_in_advance') is not None:
            self.pay_in_advance = m.get('pay_in_advance')
        if m.get('order_create_time') is not None:
            self.order_create_time = m.get('order_create_time')
        if m.get('buy_out_price') is not None:
            self.buy_out_price = m.get('buy_out_price')
        return self


class JudicialPersonInfo(TeaModel):
    def __init__(
        self,
        name: str = None,
        cert_number: str = None,
        phone: str = None,
        nationality: str = None,
        address: str = None,
        identity_certification: JudicialFileInfo = None,
        job_title: str = None,
        job_certification: JudicialFileInfo = None,
        sex: int = None,
        email: str = None,
    ):
        # 姓名
        self.name = name
        # 身份证号码
        self.cert_number = cert_number
        # 联系电话
        self.phone = phone
        # 民族
        self.nationality = nationality
        # 通讯地址
        self.address = address
        # 身份证明
        self.identity_certification = identity_certification
        # 职务
        self.job_title = job_title
        # 任职证明
        self.job_certification = job_certification
        # 性别， 0-男，1-女
        self.sex = sex
        # 联系邮件地址
        self.email = email

    def validate(self):
        self.validate_required(self.name, 'name')
        if self.identity_certification:
            self.identity_certification.validate()
        if self.job_certification:
            self.job_certification.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.cert_number is not None:
            result['cert_number'] = self.cert_number
        if self.phone is not None:
            result['phone'] = self.phone
        if self.nationality is not None:
            result['nationality'] = self.nationality
        if self.address is not None:
            result['address'] = self.address
        if self.identity_certification is not None:
            result['identity_certification'] = self.identity_certification.to_map()
        if self.job_title is not None:
            result['job_title'] = self.job_title
        if self.job_certification is not None:
            result['job_certification'] = self.job_certification.to_map()
        if self.sex is not None:
            result['sex'] = self.sex
        if self.email is not None:
            result['email'] = self.email
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('cert_number') is not None:
            self.cert_number = m.get('cert_number')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('nationality') is not None:
            self.nationality = m.get('nationality')
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('identity_certification') is not None:
            temp_model = JudicialFileInfo()
            self.identity_certification = temp_model.from_map(m['identity_certification'])
        if m.get('job_title') is not None:
            self.job_title = m.get('job_title')
        if m.get('job_certification') is not None:
            temp_model = JudicialFileInfo()
            self.job_certification = temp_model.from_map(m['job_certification'])
        if m.get('sex') is not None:
            self.sex = m.get('sex')
        if m.get('email') is not None:
            self.email = m.get('email')
        return self


class CommitmentInfo(TeaModel):
    def __init__(
        self,
        total_rent: str = None,
        rental_staging_information: List[RentalStagingInformation] = None,
    ):
        # 租金总额
        self.total_rent = total_rent
        # 租赁分期信息
        self.rental_staging_information = rental_staging_information

    def validate(self):
        self.validate_required(self.total_rent, 'total_rent')
        self.validate_required(self.rental_staging_information, 'rental_staging_information')
        if self.rental_staging_information:
            for k in self.rental_staging_information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_rent is not None:
            result['total_rent'] = self.total_rent
        result['rental_staging_information'] = []
        if self.rental_staging_information is not None:
            for k in self.rental_staging_information:
                result['rental_staging_information'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('total_rent') is not None:
            self.total_rent = m.get('total_rent')
        self.rental_staging_information = []
        if m.get('rental_staging_information') is not None:
            for k in m.get('rental_staging_information'):
                temp_model = RentalStagingInformation()
                self.rental_staging_information.append(temp_model.from_map(k))
        return self


class LegalPerson(TeaModel):
    def __init__(
        self,
        name: str = None,
        id_number: str = None,
        representative_name: str = None,
        legal_phone_number: str = None,
        legal_address: str = None,
        legal_business_address: str = None,
        legal_id_number_file: List[FileInfo] = None,
    ):
        # 被申请人姓名
        self.name = name
        # 法人统一社会信用编码
        self.id_number = id_number
        # 法定代表人姓名
        self.representative_name = representative_name
        # 联系方式
        self.legal_phone_number = legal_phone_number
        # 住所地（同营业执照地址）
        self.legal_address = legal_address
        # 企业经营地址
        self.legal_business_address = legal_business_address
        # 营业执照照片
        # 文件信息列表（先调用接口获取上传url和fileKey）
        self.legal_id_number_file = legal_id_number_file

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.id_number, 'id_number')
        if self.legal_id_number_file:
            for k in self.legal_id_number_file:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.representative_name is not None:
            result['representative_name'] = self.representative_name
        if self.legal_phone_number is not None:
            result['legal_phone_number'] = self.legal_phone_number
        if self.legal_address is not None:
            result['legal_address'] = self.legal_address
        if self.legal_business_address is not None:
            result['legal_business_address'] = self.legal_business_address
        result['legal_id_number_file'] = []
        if self.legal_id_number_file is not None:
            for k in self.legal_id_number_file:
                result['legal_id_number_file'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('representative_name') is not None:
            self.representative_name = m.get('representative_name')
        if m.get('legal_phone_number') is not None:
            self.legal_phone_number = m.get('legal_phone_number')
        if m.get('legal_address') is not None:
            self.legal_address = m.get('legal_address')
        if m.get('legal_business_address') is not None:
            self.legal_business_address = m.get('legal_business_address')
        self.legal_id_number_file = []
        if m.get('legal_id_number_file') is not None:
            for k in m.get('legal_id_number_file'):
                temp_model = FileInfo()
                self.legal_id_number_file.append(temp_model.from_map(k))
        return self


class JudicialBankInfo(TeaModel):
    def __init__(
        self,
        account_bank: str = None,
        account_number: str = None,
        account_name: str = None,
        account_contact_phone: str = None,
    ):
        # 开户行
        self.account_bank = account_bank
        # 开户账号
        self.account_number = account_number
        # 开户名称
        self.account_name = account_name
        # 开户联系电话
        self.account_contact_phone = account_contact_phone

    def validate(self):
        self.validate_required(self.account_bank, 'account_bank')
        self.validate_required(self.account_number, 'account_number')
        self.validate_required(self.account_name, 'account_name')
        self.validate_required(self.account_contact_phone, 'account_contact_phone')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_bank is not None:
            result['account_bank'] = self.account_bank
        if self.account_number is not None:
            result['account_number'] = self.account_number
        if self.account_name is not None:
            result['account_name'] = self.account_name
        if self.account_contact_phone is not None:
            result['account_contact_phone'] = self.account_contact_phone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('account_bank') is not None:
            self.account_bank = m.get('account_bank')
        if m.get('account_number') is not None:
            self.account_number = m.get('account_number')
        if m.get('account_name') is not None:
            self.account_name = m.get('account_name')
        if m.get('account_contact_phone') is not None:
            self.account_contact_phone = m.get('account_contact_phone')
        return self


class ContractTextSignVerifySignatureInfo(TeaModel):
    def __init__(
        self,
        is_modify: bool = None,
    ):
        # 是否被篡改
        self.is_modify = is_modify

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_modify is not None:
            result['is_modify'] = self.is_modify
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('is_modify') is not None:
            self.is_modify = m.get('is_modify')
        return self


class PhaseNotary(TeaModel):
    def __init__(
        self,
        phase_no: int = None,
        notary_content: str = None,
        origin_data_id: str = None,
    ):
        # 阶段编号，与模板阶段编号保持一致，不同阶段阶段编号不一样，要与阶段存证内容保持一致
        self.phase_no = phase_no
        # 阶段存证内容，如果模板数据类型定义是Hash(哈希)则填入Hash即可，如果定义是Structure(结构化)，则填入模板所有字段json对象的字符串Base64后的值
        self.notary_content = notary_content
        # 业务方原始数据ID，业务方确保唯一，方便与业务方进行数据核对使用
        # 
        self.origin_data_id = origin_data_id

    def validate(self):
        self.validate_required(self.phase_no, 'phase_no')
        self.validate_required(self.notary_content, 'notary_content')
        self.validate_required(self.origin_data_id, 'origin_data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.phase_no is not None:
            result['phase_no'] = self.phase_no
        if self.notary_content is not None:
            result['notary_content'] = self.notary_content
        if self.origin_data_id is not None:
            result['origin_data_id'] = self.origin_data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('phase_no') is not None:
            self.phase_no = m.get('phase_no')
        if m.get('notary_content') is not None:
            self.notary_content = m.get('notary_content')
        if m.get('origin_data_id') is not None:
            self.origin_data_id = m.get('origin_data_id')
        return self


class LeasePerformanceInfo(TeaModel):
    def __init__(
        self,
        rent_pay_total: str = None,
        buyout_amount: str = None,
        rental_installment_performance: List[RentalInstallmentPerformance] = None,
    ):
        # 支付租金总额
        self.rent_pay_total = rent_pay_total
        # 买断金额
        self.buyout_amount = buyout_amount
        # 租赁分期履约信息
        self.rental_installment_performance = rental_installment_performance

    def validate(self):
        self.validate_required(self.rent_pay_total, 'rent_pay_total')
        if self.rental_installment_performance:
            for k in self.rental_installment_performance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rent_pay_total is not None:
            result['rent_pay_total'] = self.rent_pay_total
        if self.buyout_amount is not None:
            result['buyout_amount'] = self.buyout_amount
        result['rental_installment_performance'] = []
        if self.rental_installment_performance is not None:
            for k in self.rental_installment_performance:
                result['rental_installment_performance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rent_pay_total') is not None:
            self.rent_pay_total = m.get('rent_pay_total')
        if m.get('buyout_amount') is not None:
            self.buyout_amount = m.get('buyout_amount')
        self.rental_installment_performance = []
        if m.get('rental_installment_performance') is not None:
            for k in m.get('rental_installment_performance'):
                temp_model = RentalInstallmentPerformance()
                self.rental_installment_performance.append(temp_model.from_map(k))
        return self


class NaturalPerson(TeaModel):
    def __init__(
        self,
        name: str = None,
        mobile_number: str = None,
        id_number: str = None,
        nation: str = None,
        address: str = None,
        email: str = None,
        id_number_file: List[FileInfo] = None,
    ):
        # 自然人姓名
        self.name = name
        # 自然人手机号码
        self.mobile_number = mobile_number
        # 自然人身份号码
        self.id_number = id_number
        # 自然人民族
        self.nation = nation
        # 自然人身份地址
        self.address = address
        # 自然人电子邮箱
        self.email = email
        # 自然人身份证正反面照片
        # 文件信息 列表（先调用接口获取上传url和fileKey）
        self.id_number_file = id_number_file

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.mobile_number, 'mobile_number')
        self.validate_required(self.id_number, 'id_number')
        if self.id_number_file:
            for k in self.id_number_file:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.mobile_number is not None:
            result['mobile_number'] = self.mobile_number
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.nation is not None:
            result['nation'] = self.nation
        if self.address is not None:
            result['address'] = self.address
        if self.email is not None:
            result['email'] = self.email
        result['id_number_file'] = []
        if self.id_number_file is not None:
            for k in self.id_number_file:
                result['id_number_file'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('mobile_number') is not None:
            self.mobile_number = m.get('mobile_number')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('nation') is not None:
            self.nation = m.get('nation')
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('email') is not None:
            self.email = m.get('email')
        self.id_number_file = []
        if m.get('id_number_file') is not None:
            for k in m.get('id_number_file'):
                temp_model = FileInfo()
                self.id_number_file.append(temp_model.from_map(k))
        return self


class ContractDocSignVerifyCertInfo(TeaModel):
    def __init__(
        self,
        owner: str = None,
        serial: str = None,
        start_date: str = None,
        end_date: str = None,
        issuer_cn: str = None,
    ):
        # 证书所有者
        self.owner = owner
        # 证书序列号
        self.serial = serial
        # 证书开始日期
        self.start_date = start_date
        # 证书结束日期
        self.end_date = end_date
        # 证书颁发机构
        self.issuer_cn = issuer_cn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['owner'] = self.owner
        if self.serial is not None:
            result['serial'] = self.serial
        if self.start_date is not None:
            result['start_date'] = self.start_date
        if self.end_date is not None:
            result['end_date'] = self.end_date
        if self.issuer_cn is not None:
            result['issuer_cn'] = self.issuer_cn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('owner') is not None:
            self.owner = m.get('owner')
        if m.get('serial') is not None:
            self.serial = m.get('serial')
        if m.get('start_date') is not None:
            self.start_date = m.get('start_date')
        if m.get('end_date') is not None:
            self.end_date = m.get('end_date')
        if m.get('issuer_cn') is not None:
            self.issuer_cn = m.get('issuer_cn')
        return self


class Location(TeaModel):
    def __init__(
        self,
        city: str = None,
        imei: str = None,
        imsi: str = None,
        ip: str = None,
        latitude: str = None,
        longitude: str = None,
        mac_addr: str = None,
        properties: str = None,
    ):
        # 所在城市
        self.city = city
        # 使用设备的IMEI号
        self.imei = imei
        # 使用设备的IMSI号
        self.imsi = imsi
        # 使用设备的IP地址
        self.ip = ip
        # 纬度
        self.latitude = latitude
        # 经度
        self.longitude = longitude
        # 使用设备的Wi-Fi物理地址
        self.mac_addr = mac_addr
        # 扩展属性
        self.properties = properties

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['city'] = self.city
        if self.imei is not None:
            result['imei'] = self.imei
        if self.imsi is not None:
            result['imsi'] = self.imsi
        if self.ip is not None:
            result['ip'] = self.ip
        if self.latitude is not None:
            result['latitude'] = self.latitude
        if self.longitude is not None:
            result['longitude'] = self.longitude
        if self.mac_addr is not None:
            result['mac_addr'] = self.mac_addr
        if self.properties is not None:
            result['properties'] = self.properties
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('imei') is not None:
            self.imei = m.get('imei')
        if m.get('imsi') is not None:
            self.imsi = m.get('imsi')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('latitude') is not None:
            self.latitude = m.get('latitude')
        if m.get('longitude') is not None:
            self.longitude = m.get('longitude')
        if m.get('mac_addr') is not None:
            self.mac_addr = m.get('mac_addr')
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        return self


class CaseBasicInfo(TeaModel):
    def __init__(
        self,
        biz_tenant_id: str = None,
        case_type: str = None,
        amount: str = None,
        input_source_id: str = None,
        input_source: str = None,
        case_ext: str = None,
    ):
        # 案件租户id
        self.biz_tenant_id = biz_tenant_id
        # 案件类型:LEASE：租赁，FINANCIAL：金融，OTHER：其他
        self.case_type = case_type
        # 标的金额（单位元）
        self.amount = amount
        # 业务来源主键
        self.input_source_id = input_source_id
        # 案件进件来源
        self.input_source = input_source
        # 根据业务来源主键对应订单号下的租赁事实报告和证据列表页面的嵌入URL
        self.case_ext = case_ext

    def validate(self):
        self.validate_required(self.biz_tenant_id, 'biz_tenant_id')
        self.validate_required(self.case_type, 'case_type')
        self.validate_required(self.input_source_id, 'input_source_id')
        self.validate_required(self.input_source, 'input_source')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_tenant_id is not None:
            result['biz_tenant_id'] = self.biz_tenant_id
        if self.case_type is not None:
            result['case_type'] = self.case_type
        if self.amount is not None:
            result['amount'] = self.amount
        if self.input_source_id is not None:
            result['input_source_id'] = self.input_source_id
        if self.input_source is not None:
            result['input_source'] = self.input_source
        if self.case_ext is not None:
            result['case_ext'] = self.case_ext
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('biz_tenant_id') is not None:
            self.biz_tenant_id = m.get('biz_tenant_id')
        if m.get('case_type') is not None:
            self.case_type = m.get('case_type')
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        if m.get('input_source_id') is not None:
            self.input_source_id = m.get('input_source_id')
        if m.get('input_source') is not None:
            self.input_source = m.get('input_source')
        if m.get('case_ext') is not None:
            self.case_ext = m.get('case_ext')
        return self


class ContractNotaryDeductExecutionInfo(TeaModel):
    def __init__(
        self,
        payer_id: str = None,
        amount: int = None,
        channel: str = None,
        result: bool = None,
        timestamp: str = None,
        order: str = None,
    ):
        # 付款方的区块链合同签署账号
        self.payer_id = payer_id
        # 扣款金额，单位分
        self.amount = amount
        # 扣款渠道
        self.channel = channel
        # 扣款操作是否成功
        self.result = result
        # 扣款操作发起时间
        self.timestamp = timestamp
        # 代扣计划ID
        self.order = order

    def validate(self):
        self.validate_required(self.payer_id, 'payer_id')
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.channel, 'channel')
        self.validate_required(self.result, 'result')
        self.validate_required(self.timestamp, 'timestamp')
        self.validate_required(self.order, 'order')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.payer_id is not None:
            result['payer_id'] = self.payer_id
        if self.amount is not None:
            result['amount'] = self.amount
        if self.channel is not None:
            result['channel'] = self.channel
        if self.result is not None:
            result['result'] = self.result
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.order is not None:
            result['order'] = self.order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('payer_id') is not None:
            self.payer_id = m.get('payer_id')
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        if m.get('channel') is not None:
            self.channel = m.get('channel')
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('order') is not None:
            self.order = m.get('order')
        return self


class MetricInfo(TeaModel):
    def __init__(
        self,
        collect_amount: int = None,
        collect_time: str = None,
        collect_serial_number: str = None,
    ):
        # 实际计收金额，单位：分。如传100，即为100分，1元
        self.collect_amount = collect_amount
        # 计收受理时间
        self.collect_time = collect_time
        # 计收的订单流水号
        self.collect_serial_number = collect_serial_number

    def validate(self):
        self.validate_required(self.collect_amount, 'collect_amount')
        self.validate_required(self.collect_time, 'collect_time')
        if self.collect_time is not None:
            self.validate_pattern(self.collect_time, 'collect_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.collect_serial_number, 'collect_serial_number')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collect_amount is not None:
            result['collect_amount'] = self.collect_amount
        if self.collect_time is not None:
            result['collect_time'] = self.collect_time
        if self.collect_serial_number is not None:
            result['collect_serial_number'] = self.collect_serial_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('collect_amount') is not None:
            self.collect_amount = m.get('collect_amount')
        if m.get('collect_time') is not None:
            self.collect_time = m.get('collect_time')
        if m.get('collect_serial_number') is not None:
            self.collect_serial_number = m.get('collect_serial_number')
        return self


class LeaseCreditPromiseInfo(TeaModel):
    def __init__(
        self,
        term: int = None,
        pay_money: int = None,
        pay_date: str = None,
        pay_in_advance_time: str = None,
        pay_in_advance_money: int = None,
    ):
        # 租期index
        self.term = term
        # 应还金额
        self.pay_money = pay_money
        # 应还款时间
        self.pay_date = pay_date
        # 垫付日
        self.pay_in_advance_time = pay_in_advance_time
        # 垫付金额
        self.pay_in_advance_money = pay_in_advance_money

    def validate(self):
        self.validate_required(self.term, 'term')
        self.validate_required(self.pay_money, 'pay_money')
        self.validate_required(self.pay_date, 'pay_date')
        self.validate_required(self.pay_in_advance_time, 'pay_in_advance_time')
        self.validate_required(self.pay_in_advance_money, 'pay_in_advance_money')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.term is not None:
            result['term'] = self.term
        if self.pay_money is not None:
            result['pay_money'] = self.pay_money
        if self.pay_date is not None:
            result['pay_date'] = self.pay_date
        if self.pay_in_advance_time is not None:
            result['pay_in_advance_time'] = self.pay_in_advance_time
        if self.pay_in_advance_money is not None:
            result['pay_in_advance_money'] = self.pay_in_advance_money
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('term') is not None:
            self.term = m.get('term')
        if m.get('pay_money') is not None:
            self.pay_money = m.get('pay_money')
        if m.get('pay_date') is not None:
            self.pay_date = m.get('pay_date')
        if m.get('pay_in_advance_time') is not None:
            self.pay_in_advance_time = m.get('pay_in_advance_time')
        if m.get('pay_in_advance_money') is not None:
            self.pay_in_advance_money = m.get('pay_in_advance_money')
        return self


class LeaseOrderExtra(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # 额外信息的主键
        self.key = key
        # 额外信息的值
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class ProposerObject(TeaModel):
    def __init__(
        self,
        name: str = None,
        id_number: str = None,
        phone_number: str = None,
        email: str = None,
        business_address: str = None,
        id_number_file: List[FileInfo] = None,
        representative_name: str = None,
        representative_sex: int = None,
        representative_id_number: str = None,
        representative_mobile_number: str = None,
        representative_id_number_file: List[FileInfo] = None,
        representative_post: str = None,
        representative_post_file: List[FileInfo] = None,
        signature_manager_name: str = None,
        signature_manager_id_card: str = None,
        signature_manager_phone: str = None,
    ):
        # 申请人姓名
        self.name = name
        # 统一社会信用代码
        self.id_number = id_number
        # 联系电话
        self.phone_number = phone_number
        # 电子邮箱地址
        self.email = email
        # 经营地址
        self.business_address = business_address
        # 营业执照照片
        # 文件信息 列表
        self.id_number_file = id_number_file
        # 法定代表人姓名
        self.representative_name = representative_name
        # 法定代表人性别
        # 0: 男 1: 女
        self.representative_sex = representative_sex
        # 法定代表人身份证号码
        self.representative_id_number = representative_id_number
        # 法定代表人手机号码
        self.representative_mobile_number = representative_mobile_number
        # 法定代表人代表身份证明
        # 文件信息列表
        self.representative_id_number_file = representative_id_number_file
        # 法定代表人职务
        self.representative_post = representative_post
        # 法定代表人职务证明
        # 文件信息列表
        self.representative_post_file = representative_post_file
        # 签章管理员姓名
        self.signature_manager_name = signature_manager_name
        # 签章管理员身份证号码
        self.signature_manager_id_card = signature_manager_id_card
        # 签章管理员手机号码
        self.signature_manager_phone = signature_manager_phone

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.id_number, 'id_number')
        if self.id_number_file:
            for k in self.id_number_file:
                if k:
                    k.validate()
        if self.representative_id_number_file:
            for k in self.representative_id_number_file:
                if k:
                    k.validate()
        if self.representative_post_file:
            for k in self.representative_post_file:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.phone_number is not None:
            result['phone_number'] = self.phone_number
        if self.email is not None:
            result['email'] = self.email
        if self.business_address is not None:
            result['business_address'] = self.business_address
        result['id_number_file'] = []
        if self.id_number_file is not None:
            for k in self.id_number_file:
                result['id_number_file'].append(k.to_map() if k else None)
        if self.representative_name is not None:
            result['representative_name'] = self.representative_name
        if self.representative_sex is not None:
            result['representative_sex'] = self.representative_sex
        if self.representative_id_number is not None:
            result['representative_id_number'] = self.representative_id_number
        if self.representative_mobile_number is not None:
            result['representative_mobile_number'] = self.representative_mobile_number
        result['representative_id_number_file'] = []
        if self.representative_id_number_file is not None:
            for k in self.representative_id_number_file:
                result['representative_id_number_file'].append(k.to_map() if k else None)
        if self.representative_post is not None:
            result['representative_post'] = self.representative_post
        result['representative_post_file'] = []
        if self.representative_post_file is not None:
            for k in self.representative_post_file:
                result['representative_post_file'].append(k.to_map() if k else None)
        if self.signature_manager_name is not None:
            result['signature_manager_name'] = self.signature_manager_name
        if self.signature_manager_id_card is not None:
            result['signature_manager_id_card'] = self.signature_manager_id_card
        if self.signature_manager_phone is not None:
            result['signature_manager_phone'] = self.signature_manager_phone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('phone_number') is not None:
            self.phone_number = m.get('phone_number')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('business_address') is not None:
            self.business_address = m.get('business_address')
        self.id_number_file = []
        if m.get('id_number_file') is not None:
            for k in m.get('id_number_file'):
                temp_model = FileInfo()
                self.id_number_file.append(temp_model.from_map(k))
        if m.get('representative_name') is not None:
            self.representative_name = m.get('representative_name')
        if m.get('representative_sex') is not None:
            self.representative_sex = m.get('representative_sex')
        if m.get('representative_id_number') is not None:
            self.representative_id_number = m.get('representative_id_number')
        if m.get('representative_mobile_number') is not None:
            self.representative_mobile_number = m.get('representative_mobile_number')
        self.representative_id_number_file = []
        if m.get('representative_id_number_file') is not None:
            for k in m.get('representative_id_number_file'):
                temp_model = FileInfo()
                self.representative_id_number_file.append(temp_model.from_map(k))
        if m.get('representative_post') is not None:
            self.representative_post = m.get('representative_post')
        self.representative_post_file = []
        if m.get('representative_post_file') is not None:
            for k in m.get('representative_post_file'):
                temp_model = FileInfo()
                self.representative_post_file.append(temp_model.from_map(k))
        if m.get('signature_manager_name') is not None:
            self.signature_manager_name = m.get('signature_manager_name')
        if m.get('signature_manager_id_card') is not None:
            self.signature_manager_id_card = m.get('signature_manager_id_card')
        if m.get('signature_manager_phone') is not None:
            self.signature_manager_phone = m.get('signature_manager_phone')
        return self


class FinanceCertifyRentalInfo(TeaModel):
    def __init__(
        self,
        rent_term: int = None,
        rental_money: int = None,
        rental_return_time: str = None,
    ):
        # 租期
        self.rent_term = rent_term
        # 本期扣款金额，123400表示12.34元
        self.rental_money = rental_money
        # 还款日期，格式为"2019-07-31 12:00:00"
        self.rental_return_time = rental_return_time

    def validate(self):
        self.validate_required(self.rent_term, 'rent_term')
        self.validate_required(self.rental_money, 'rental_money')
        self.validate_required(self.rental_return_time, 'rental_return_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rent_term is not None:
            result['rent_term'] = self.rent_term
        if self.rental_money is not None:
            result['rental_money'] = self.rental_money
        if self.rental_return_time is not None:
            result['rental_return_time'] = self.rental_return_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rent_term') is not None:
            self.rent_term = m.get('rent_term')
        if m.get('rental_money') is not None:
            self.rental_money = m.get('rental_money')
        if m.get('rental_return_time') is not None:
            self.rental_return_time = m.get('rental_return_time')
        return self


class ContractSignFieldApplication(TeaModel):
    def __init__(
        self,
        add_sign_time: bool = None,
        authorized_account_id: str = None,
        file_id: str = None,
        order: int = None,
        pos_page: str = None,
        pos_x: str = None,
        pos_y: str = None,
        seal_id: str = None,
        third_order_no: str = None,
        width: str = None,
        sign_type: int = None,
    ):
        # 是否添加签署时间戳，默认不添加，时间格式如"2019-03-11 10:12:12"
        self.add_sign_time = add_sign_time
        # 签约主体账号标识， 将使用该主体账号对应的数字证书完成本次签署，如：当存在签署操作人代某机构签署时，需要传入该机构的账号id
        self.authorized_account_id = authorized_account_id
        # 电子合同文件ID
        self.file_id = file_id
        # 签署区顺序，默认1,且不小于1，顺序越小越先处理
        self.order = order
        # 页码信息：当签署区signType为2时, 页码可以_-_分割, 例如1到15页，填"1-15"； 其他情况只能是数字
        self.pos_page = pos_page
        # x坐标转为字符串的值，默认空，页面签章必填，骑缝签章不填写
        self.pos_x = pos_x
        # y坐标转为字符串的值
        self.pos_y = pos_y
        # 印章id ，如不传，则采用账号下的默认印章
        self.seal_id = seal_id
        # 第三方业务流水号id，保证相同签署人、相同签约主体、相同签署顺序的任务，对应的第三方业务流水id唯一，默认空
        self.third_order_no = third_order_no
        # 签署区宽，默认印章宽度
        self.width = width
        # 签署类型，1-单页签署，2-骑缝签署，默认1
        self.sign_type = sign_type

    def validate(self):
        self.validate_required(self.authorized_account_id, 'authorized_account_id')
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.pos_page, 'pos_page')
        self.validate_required(self.pos_y, 'pos_y')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_sign_time is not None:
            result['add_sign_time'] = self.add_sign_time
        if self.authorized_account_id is not None:
            result['authorized_account_id'] = self.authorized_account_id
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.order is not None:
            result['order'] = self.order
        if self.pos_page is not None:
            result['pos_page'] = self.pos_page
        if self.pos_x is not None:
            result['pos_x'] = self.pos_x
        if self.pos_y is not None:
            result['pos_y'] = self.pos_y
        if self.seal_id is not None:
            result['seal_id'] = self.seal_id
        if self.third_order_no is not None:
            result['third_order_no'] = self.third_order_no
        if self.width is not None:
            result['width'] = self.width
        if self.sign_type is not None:
            result['sign_type'] = self.sign_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('add_sign_time') is not None:
            self.add_sign_time = m.get('add_sign_time')
        if m.get('authorized_account_id') is not None:
            self.authorized_account_id = m.get('authorized_account_id')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('pos_page') is not None:
            self.pos_page = m.get('pos_page')
        if m.get('pos_x') is not None:
            self.pos_x = m.get('pos_x')
        if m.get('pos_y') is not None:
            self.pos_y = m.get('pos_y')
        if m.get('seal_id') is not None:
            self.seal_id = m.get('seal_id')
        if m.get('third_order_no') is not None:
            self.third_order_no = m.get('third_order_no')
        if m.get('width') is not None:
            self.width = m.get('width')
        if m.get('sign_type') is not None:
            self.sign_type = m.get('sign_type')
        return self


class ContractUserOrganizationApplication(TeaModel):
    def __init__(
        self,
        id_number: str = None,
        id_type: str = None,
        legal_person: str = None,
        legal_person_id: str = None,
        name: str = None,
        organization_id: str = None,
    ):
        # 证件号，该字段只有为空才允许修改
        self.id_number = id_number
        # 证件类型 ，默认CRED_ORG_USCC
        self.id_type = id_type
        # 企业法定代表人名称
        self.legal_person = legal_person
        # 企业法定代表人证件号
        self.legal_person_id = legal_person_id
        # 机构名称
        self.name = name
        # 机构账号id
        self.organization_id = organization_id

    def validate(self):
        self.validate_required(self.organization_id, 'organization_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.legal_person is not None:
            result['legal_person'] = self.legal_person
        if self.legal_person_id is not None:
            result['legal_person_id'] = self.legal_person_id
        if self.name is not None:
            result['name'] = self.name
        if self.organization_id is not None:
            result['organization_id'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('legal_person') is not None:
            self.legal_person = m.get('legal_person')
        if m.get('legal_person_id') is not None:
            self.legal_person_id = m.get('legal_person_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('organization_id') is not None:
            self.organization_id = m.get('organization_id')
        return self


class LeaseEvidentialElement(TeaModel):
    def __init__(
        self,
        lease_order_info: LeaseOrderInfo = None,
        commitment_info: CommitmentInfo = None,
        logistics_info: LogisticsInfo = None,
        performance_info: LeasePerformanceInfo = None,
    ):
        # 订单信息
        self.lease_order_info = lease_order_info
        # 承诺信息
        self.commitment_info = commitment_info
        # 物流信息
        self.logistics_info = logistics_info
        # 履约信息
        self.performance_info = performance_info

    def validate(self):
        self.validate_required(self.lease_order_info, 'lease_order_info')
        if self.lease_order_info:
            self.lease_order_info.validate()
        self.validate_required(self.commitment_info, 'commitment_info')
        if self.commitment_info:
            self.commitment_info.validate()
        self.validate_required(self.logistics_info, 'logistics_info')
        if self.logistics_info:
            self.logistics_info.validate()
        self.validate_required(self.performance_info, 'performance_info')
        if self.performance_info:
            self.performance_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lease_order_info is not None:
            result['lease_order_info'] = self.lease_order_info.to_map()
        if self.commitment_info is not None:
            result['commitment_info'] = self.commitment_info.to_map()
        if self.logistics_info is not None:
            result['logistics_info'] = self.logistics_info.to_map()
        if self.performance_info is not None:
            result['performance_info'] = self.performance_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('lease_order_info') is not None:
            temp_model = LeaseOrderInfo()
            self.lease_order_info = temp_model.from_map(m['lease_order_info'])
        if m.get('commitment_info') is not None:
            temp_model = CommitmentInfo()
            self.commitment_info = temp_model.from_map(m['commitment_info'])
        if m.get('logistics_info') is not None:
            temp_model = LogisticsInfo()
            self.logistics_info = temp_model.from_map(m['logistics_info'])
        if m.get('performance_info') is not None:
            temp_model = LeasePerformanceInfo()
            self.performance_info = temp_model.from_map(m['performance_info'])
        return self


class ContractSignField(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        file_id: str = None,
        signfield_id: str = None,
    ):
        # 电子合同用户ID
        self.account_id = account_id
        # 电子合同文档ID
        self.file_id = file_id
        # 电子合同签署区id
        self.signfield_id = signfield_id

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.signfield_id, 'signfield_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.signfield_id is not None:
            result['signfield_id'] = self.signfield_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('signfield_id') is not None:
            self.signfield_id = m.get('signfield_id')
        return self


class ContractSignFieldDetail(TeaModel):
    def __init__(
        self,
        actor_indentity_type: int = None,
        add_time: int = None,
        assigned_posbean: bool = None,
        assigned_seal: bool = None,
        authorized_account_id: str = None,
        auto_execute: bool = None,
        execute_failed_reason: str = None,
        file_id: str = None,
        flow_id: str = None,
        order: int = None,
        pos_page: str = None,
        pos_x: str = None,
        pos_y: str = None,
        seal_file_key: str = None,
        seal_id: str = None,
        seal_type: str = None,
        signer_account_id: str = None,
        signfield_id: str = None,
        sign_type: int = None,
        status: int = None,
        status_description: str = None,
        width: str = None,
    ):
        # 签约主体类别，0-个人，1-机构，默认0,2 是不限
        self.actor_indentity_type = actor_indentity_type
        # 添加时间
        self.add_time = add_time
        # 是否指定位置，TRUE表示不允许更新位置，配置项，无默认值
        self.assigned_posbean = assigned_posbean
        # 是否指定印章数据，TRUE表示不允许更新印章，配置项，无默认值
        self.assigned_seal = assigned_seal
        # 签约主体账号标识，将使用该主体账号对应的数字证书完成本次签署，如：当存在签署操作人代某机构签署时，需要传入该机构的账号id
        self.authorized_account_id = authorized_account_id
        # 是否自动执行，TRUE需要静默授权，配置项，无默认值
        self.auto_execute = auto_execute
        # 执行失败原因
        self.execute_failed_reason = execute_failed_reason
        # 文件file id
        self.file_id = file_id
        # 流程id
        self.flow_id = flow_id
        # 签署区顺序，默认1,且不小于1，顺序越小越先处理
        self.order = order
        # 页码信息，可以_,_或_-_分割
        self.pos_page = pos_page
        # x坐标
        self.pos_x = pos_x
        # y坐标
        self.pos_y = pos_y
        # 印章文件file key
        self.seal_file_key = seal_file_key
        # 印章id
        self.seal_id = seal_id
        # 印章类型，支持多种类型时逗号分割，0-手绘印章，1-模版印章，为空不限制
        self.seal_type = seal_type
        # 签署操作人个人账号标识，即操作本次签署的个人，如需e签宝通知用户签署，则系统向该账号下绑定的手机、邮箱发送签署链接
        self.signer_account_id = signer_account_id
        # 签署区Id
        self.signfield_id = signfield_id
        # 签署类型，0-不限，1-单页签署，2-骑缝签署,4-关键字签署，默认1
        self.sign_type = sign_type
        # 签署区状态（0："等待执行，1："执行中"，2："执行失败"，3："审批中"，4： "执行完成"）
        self.status = status
        # 状态描述
        self.status_description = status_description
        # 签署区宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actor_indentity_type is not None:
            result['actor_indentity_type'] = self.actor_indentity_type
        if self.add_time is not None:
            result['add_time'] = self.add_time
        if self.assigned_posbean is not None:
            result['assigned_posbean'] = self.assigned_posbean
        if self.assigned_seal is not None:
            result['assigned_seal'] = self.assigned_seal
        if self.authorized_account_id is not None:
            result['authorized_account_id'] = self.authorized_account_id
        if self.auto_execute is not None:
            result['auto_execute'] = self.auto_execute
        if self.execute_failed_reason is not None:
            result['execute_failed_reason'] = self.execute_failed_reason
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.order is not None:
            result['order'] = self.order
        if self.pos_page is not None:
            result['pos_page'] = self.pos_page
        if self.pos_x is not None:
            result['pos_x'] = self.pos_x
        if self.pos_y is not None:
            result['pos_y'] = self.pos_y
        if self.seal_file_key is not None:
            result['seal_file_key'] = self.seal_file_key
        if self.seal_id is not None:
            result['seal_id'] = self.seal_id
        if self.seal_type is not None:
            result['seal_type'] = self.seal_type
        if self.signer_account_id is not None:
            result['signer_account_id'] = self.signer_account_id
        if self.signfield_id is not None:
            result['signfield_id'] = self.signfield_id
        if self.sign_type is not None:
            result['sign_type'] = self.sign_type
        if self.status is not None:
            result['status'] = self.status
        if self.status_description is not None:
            result['status_description'] = self.status_description
        if self.width is not None:
            result['width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actor_indentity_type') is not None:
            self.actor_indentity_type = m.get('actor_indentity_type')
        if m.get('add_time') is not None:
            self.add_time = m.get('add_time')
        if m.get('assigned_posbean') is not None:
            self.assigned_posbean = m.get('assigned_posbean')
        if m.get('assigned_seal') is not None:
            self.assigned_seal = m.get('assigned_seal')
        if m.get('authorized_account_id') is not None:
            self.authorized_account_id = m.get('authorized_account_id')
        if m.get('auto_execute') is not None:
            self.auto_execute = m.get('auto_execute')
        if m.get('execute_failed_reason') is not None:
            self.execute_failed_reason = m.get('execute_failed_reason')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('pos_page') is not None:
            self.pos_page = m.get('pos_page')
        if m.get('pos_x') is not None:
            self.pos_x = m.get('pos_x')
        if m.get('pos_y') is not None:
            self.pos_y = m.get('pos_y')
        if m.get('seal_file_key') is not None:
            self.seal_file_key = m.get('seal_file_key')
        if m.get('seal_id') is not None:
            self.seal_id = m.get('seal_id')
        if m.get('seal_type') is not None:
            self.seal_type = m.get('seal_type')
        if m.get('signer_account_id') is not None:
            self.signer_account_id = m.get('signer_account_id')
        if m.get('signfield_id') is not None:
            self.signfield_id = m.get('signfield_id')
        if m.get('sign_type') is not None:
            self.sign_type = m.get('sign_type')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_description') is not None:
            self.status_description = m.get('status_description')
        if m.get('width') is not None:
            self.width = m.get('width')
        return self


class SupplierInfo(TeaModel):
    def __init__(
        self,
        agent_supplier_id: str = None,
        agent_supplier_corp_id: str = None,
        agent_supplier_corp_name: str = None,
        agent_supplier_name: str = None,
        agent_supplier_corp_owner_name: str = None,
        extra_info: str = None,
    ):
        # 供应商id
        self.agent_supplier_id = agent_supplier_id
        # 被代理机构社会统一信用码
        self.agent_supplier_corp_id = agent_supplier_corp_id
        # 被代理机构名称
        self.agent_supplier_corp_name = agent_supplier_corp_name
        # 被代理供应商名称
        self.agent_supplier_name = agent_supplier_name
        # 被代理机构的法人名称
        self.agent_supplier_corp_owner_name = agent_supplier_corp_owner_name
        # 额外信息
        self.extra_info = extra_info

    def validate(self):
        self.validate_required(self.agent_supplier_id, 'agent_supplier_id')
        self.validate_required(self.agent_supplier_corp_id, 'agent_supplier_corp_id')
        self.validate_required(self.agent_supplier_corp_name, 'agent_supplier_corp_name')
        self.validate_required(self.agent_supplier_name, 'agent_supplier_name')
        self.validate_required(self.agent_supplier_corp_owner_name, 'agent_supplier_corp_owner_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_supplier_id is not None:
            result['agent_supplier_id'] = self.agent_supplier_id
        if self.agent_supplier_corp_id is not None:
            result['agent_supplier_corp_id'] = self.agent_supplier_corp_id
        if self.agent_supplier_corp_name is not None:
            result['agent_supplier_corp_name'] = self.agent_supplier_corp_name
        if self.agent_supplier_name is not None:
            result['agent_supplier_name'] = self.agent_supplier_name
        if self.agent_supplier_corp_owner_name is not None:
            result['agent_supplier_corp_owner_name'] = self.agent_supplier_corp_owner_name
        if self.extra_info is not None:
            result['extra_info'] = self.extra_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('agent_supplier_id') is not None:
            self.agent_supplier_id = m.get('agent_supplier_id')
        if m.get('agent_supplier_corp_id') is not None:
            self.agent_supplier_corp_id = m.get('agent_supplier_corp_id')
        if m.get('agent_supplier_corp_name') is not None:
            self.agent_supplier_corp_name = m.get('agent_supplier_corp_name')
        if m.get('agent_supplier_name') is not None:
            self.agent_supplier_name = m.get('agent_supplier_name')
        if m.get('agent_supplier_corp_owner_name') is not None:
            self.agent_supplier_corp_owner_name = m.get('agent_supplier_corp_owner_name')
        if m.get('extra_info') is not None:
            self.extra_info = m.get('extra_info')
        return self


class ContractNotaryDeductPlanInfo(TeaModel):
    def __init__(
        self,
        payer_id: str = None,
        deduct_plan_info: str = None,
        agreement_no: str = None,
        timestamp: str = None,
    ):
        # PAYERIDNUMBER
        self.payer_id = payer_id
        # “总金额：”+总金额“+”“总期数：”+总期数，“+”每期金额时间（X期金额，时间）
        self.deduct_plan_info = deduct_plan_info
        # AGREEMEND_ID_NUMBER
        self.agreement_no = agreement_no
        # 代扣计划发起时间
        self.timestamp = timestamp

    def validate(self):
        self.validate_required(self.payer_id, 'payer_id')
        self.validate_required(self.deduct_plan_info, 'deduct_plan_info')
        self.validate_required(self.agreement_no, 'agreement_no')
        self.validate_required(self.timestamp, 'timestamp')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.payer_id is not None:
            result['payer_id'] = self.payer_id
        if self.deduct_plan_info is not None:
            result['deduct_plan_info'] = self.deduct_plan_info
        if self.agreement_no is not None:
            result['agreement_no'] = self.agreement_no
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('payer_id') is not None:
            self.payer_id = m.get('payer_id')
        if m.get('deduct_plan_info') is not None:
            self.deduct_plan_info = m.get('deduct_plan_info')
        if m.get('agreement_no') is not None:
            self.agreement_no = m.get('agreement_no')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class ContractNotaryFinishInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        file_num: int = None,
        initiator: str = None,
        signatories: str = None,
        timestamp: str = None,
        tx_hash: str = None,
        user_types: str = None,
        business_type: str = None,
        amounts: str = None,
        sign_party_count: int = None,
        intiator_name: str = None,
        signator_names: str = None,
        detail_info_file_hash: str = None,
    ):
        # 本阶段存证内容哈希值
        self.content = content
        # 签署文件份数
        self.file_num = file_num
        # 发起人ID
        self.initiator = initiator
        # 签署人ID（支持多个，不同ID间用“,”分隔开）
        self.signatories = signatories
        # 存证阶段发生时间，UNIX时间戳(毫秒)
        self.timestamp = timestamp
        # 存证凭据，仅在批量核验时需要填写
        self.tx_hash = tx_hash
        # signatories对应的用户类型
        self.user_types = user_types
        # 签署合同所属行业
        self.business_type = business_type
        # 合同对应的金额，如果不涉及金额，填充为0，个数与file_num对应
        self.amounts = amounts
        # 签署方数量
        self.sign_party_count = sign_party_count
        # 发起人名称
        self.intiator_name = intiator_name
        # 签署人名称,多个逗号隔开
        self.signator_names = signator_names
        # 详细文件哈希
        self.detail_info_file_hash = detail_info_file_hash

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.file_num, 'file_num')
        self.validate_required(self.initiator, 'initiator')
        self.validate_required(self.signatories, 'signatories')
        self.validate_required(self.timestamp, 'timestamp')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.file_num is not None:
            result['file_num'] = self.file_num
        if self.initiator is not None:
            result['initiator'] = self.initiator
        if self.signatories is not None:
            result['signatories'] = self.signatories
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.user_types is not None:
            result['user_types'] = self.user_types
        if self.business_type is not None:
            result['business_type'] = self.business_type
        if self.amounts is not None:
            result['amounts'] = self.amounts
        if self.sign_party_count is not None:
            result['sign_party_count'] = self.sign_party_count
        if self.intiator_name is not None:
            result['intiator_name'] = self.intiator_name
        if self.signator_names is not None:
            result['signator_names'] = self.signator_names
        if self.detail_info_file_hash is not None:
            result['detail_info_file_hash'] = self.detail_info_file_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('file_num') is not None:
            self.file_num = m.get('file_num')
        if m.get('initiator') is not None:
            self.initiator = m.get('initiator')
        if m.get('signatories') is not None:
            self.signatories = m.get('signatories')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('user_types') is not None:
            self.user_types = m.get('user_types')
        if m.get('business_type') is not None:
            self.business_type = m.get('business_type')
        if m.get('amounts') is not None:
            self.amounts = m.get('amounts')
        if m.get('sign_party_count') is not None:
            self.sign_party_count = m.get('sign_party_count')
        if m.get('intiator_name') is not None:
            self.intiator_name = m.get('intiator_name')
        if m.get('signator_names') is not None:
            self.signator_names = m.get('signator_names')
        if m.get('detail_info_file_hash') is not None:
            self.detail_info_file_hash = m.get('detail_info_file_hash')
        return self


class WitnessDocs(TeaModel):
    def __init__(
        self,
        doc_hash: str = None,
        third_doc_id: str = None,
    ):
        # 文档摘要值
        self.doc_hash = doc_hash
        # 第三方文档id
        self.third_doc_id = third_doc_id

    def validate(self):
        self.validate_required(self.doc_hash, 'doc_hash')
        self.validate_required(self.third_doc_id, 'third_doc_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_hash is not None:
            result['doc_hash'] = self.doc_hash
        if self.third_doc_id is not None:
            result['third_doc_id'] = self.third_doc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('doc_hash') is not None:
            self.doc_hash = m.get('doc_hash')
        if m.get('third_doc_id') is not None:
            self.third_doc_id = m.get('third_doc_id')
        return self


class ContractPlatformSignField(TeaModel):
    def __init__(
        self,
        add_sign_time: bool = None,
        order: int = None,
        pos_page: str = None,
        pos_x: str = None,
        pos_y: str = None,
        seal_id: str = None,
        third_order_no: str = None,
        width: str = None,
    ):
        # 是否添加签署时间戳，默认不添加，时间格式如"2019-03-11 10:12:12"
        self.add_sign_time = add_sign_time
        # 签署区顺序，默认1,且不小于1，顺序越小越先处理
        self.order = order
        # 页码信息，当签署区signType为2时, 页码可以_-_分割, 其他情况只能是数字
        self.pos_page = pos_page
        # x坐标转为字符串的值，默认空
        self.pos_x = pos_x
        # y坐标转为字符串的值
        self.pos_y = pos_y
        # 印章id ，如不传，则采用账号下的默认印章
        self.seal_id = seal_id
        # 第三方业务流水号id，保证相同签署人、相同签约主体、相同签署顺序的任务，对应的第三方业务流水id唯一，默认空
        self.third_order_no = third_order_no
        # 签署区宽，默认印章宽度
        self.width = width

    def validate(self):
        self.validate_required(self.pos_page, 'pos_page')
        self.validate_required(self.pos_y, 'pos_y')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_sign_time is not None:
            result['add_sign_time'] = self.add_sign_time
        if self.order is not None:
            result['order'] = self.order
        if self.pos_page is not None:
            result['pos_page'] = self.pos_page
        if self.pos_x is not None:
            result['pos_x'] = self.pos_x
        if self.pos_y is not None:
            result['pos_y'] = self.pos_y
        if self.seal_id is not None:
            result['seal_id'] = self.seal_id
        if self.third_order_no is not None:
            result['third_order_no'] = self.third_order_no
        if self.width is not None:
            result['width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('add_sign_time') is not None:
            self.add_sign_time = m.get('add_sign_time')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('pos_page') is not None:
            self.pos_page = m.get('pos_page')
        if m.get('pos_x') is not None:
            self.pos_x = m.get('pos_x')
        if m.get('pos_y') is not None:
            self.pos_y = m.get('pos_y')
        if m.get('seal_id') is not None:
            self.seal_id = m.get('seal_id')
        if m.get('third_order_no') is not None:
            self.third_order_no = m.get('third_order_no')
        if m.get('width') is not None:
            self.width = m.get('width')
        return self


class ContractDocSignVerifyInfo(TeaModel):
    def __init__(
        self,
        cert: ContractDocSignVerifyCertInfo = None,
        signature: ContractDocSignVerifySignatureInfo = None,
        seal_data: str = None,
    ):
        # 证书信息
        self.cert = cert
        # 签名信息
        self.signature = signature
        # 印章数据
        self.seal_data = seal_data

    def validate(self):
        if self.cert:
            self.cert.validate()
        if self.signature:
            self.signature.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert is not None:
            result['cert'] = self.cert.to_map()
        if self.signature is not None:
            result['signature'] = self.signature.to_map()
        if self.seal_data is not None:
            result['seal_data'] = self.seal_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cert') is not None:
            temp_model = ContractDocSignVerifyCertInfo()
            self.cert = temp_model.from_map(m['cert'])
        if m.get('signature') is not None:
            temp_model = ContractDocSignVerifySignatureInfo()
            self.signature = temp_model.from_map(m['signature'])
        if m.get('seal_data') is not None:
            self.seal_data = m.get('seal_data')
        return self


class WitnessSignData(TeaModel):
    def __init__(
        self,
        seal_file_keys: List[str] = None,
        seal_ids: List[str] = None,
        sign_hash: str = None,
        sign_pos_data: str = None,
        third_doc_id: str = None,
    ):
        # 印章图片fileKey列表
        self.seal_file_keys = seal_file_keys
        # 印章id列表
        self.seal_ids = seal_ids
        # 待签署文档摘要值，批量签时必传
        self.sign_hash = sign_hash
        # 签署位置信息
        self.sign_pos_data = sign_pos_data
        # 第三方文档id，批量签时必传
        self.third_doc_id = third_doc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.seal_file_keys is not None:
            result['seal_file_keys'] = self.seal_file_keys
        if self.seal_ids is not None:
            result['seal_ids'] = self.seal_ids
        if self.sign_hash is not None:
            result['sign_hash'] = self.sign_hash
        if self.sign_pos_data is not None:
            result['sign_pos_data'] = self.sign_pos_data
        if self.third_doc_id is not None:
            result['third_doc_id'] = self.third_doc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('seal_file_keys') is not None:
            self.seal_file_keys = m.get('seal_file_keys')
        if m.get('seal_ids') is not None:
            self.seal_ids = m.get('seal_ids')
        if m.get('sign_hash') is not None:
            self.sign_hash = m.get('sign_hash')
        if m.get('sign_pos_data') is not None:
            self.sign_pos_data = m.get('sign_pos_data')
        if m.get('third_doc_id') is not None:
            self.third_doc_id = m.get('third_doc_id')
        return self


class CaseBaseInfo(TeaModel):
    def __init__(
        self,
        case_id: str = None,
        case_phase: str = None,
        record_id: str = None,
        record_type: str = None,
        case_status: str = None,
        submit_time: str = None,
        arbitral_body: str = None,
        close_time: str = None,
        acceptance_number: str = None,
        case_payment_actual_amount: str = None,
        can_download: str = None,
    ):
        # caseID
        self.case_id = case_id
        # PENDING_RIGHTS_PROTECTION(1, "待发起维权"),
        # TO_BE_SUBMITTED(2, "待提交"),
        # ACCEPTED_AND_PROCESSED(3, "收案处理中"),
        # RESULTS_TO_BE_CONFIRMED(4, "结果待确认"),
        # CLOSED(5, "已关闭"),
        self.case_phase = case_phase
        # 维权ID
        self.record_id = record_id
        # MEDIATION(1, "调解"),
        # LITIGATION(2, "诉讼"),
        # ARBITRATION(3, "仲裁"),
        # CARRIED_OUT(4, "执行"),
        self.record_type = record_type
        # MATERIAL_PREPARATION(1, "材料准备中"),
        # SUBMITTED(2, "已提交"),
        # FILED(3, "已立案"),
        # CLOSED(4, "已结案"),
        # WITHDRAW_THE_CASE(5, "撤案"),
        # REVOKE(6, "撤销"),
        # INADMISSIBLE(7, "不予受理"),
        # SUBMITTING(8, "提交中"),
        # SUBMISSION_FAILED(9, "提交失败"),
        # FINAL_RULING(10, "裁定终本"),
        # CARRIED_OUT_FINISHED(11, "执行完毕"),
        # TO_BE_SIGNED(12, "签署中"),
        # SIGNING_TIMED_OUT(13, "签署超时"),
        # SIGN_REJECTED(14, "签署被拒绝"),
        # SIGN_REVOCATION(15, "签署撤销"),
        # WITHDRAW_THE_CASE_ING(16, "撤案处理中"),
        # WITHDRAW_SIGNING_TIMED_OUT(17, "撤案签署超时"),
        # WITHDRAW_SIGN_REJECTED(18, "撤案签署被拒绝"),
        # WITHDRAW_SIGN_REVOCATION(19, "撤案签署撤销"),
        # SIGNED(20, "签署完成"),
        # WITHDRAW_SIGNED(21, "撤案签署完成"),
        self.case_status = case_status
        # 案件提交时间
        self.submit_time = submit_time
        # 维权机构
        self.arbitral_body = arbitral_body
        # 结案时间 如没有则为""
        self.close_time = close_time
        # 案号 如没有则为""
        self.acceptance_number = acceptance_number
        # 案件回款金额,两位小数 单位(元) 如没有则为""
        self.case_payment_actual_amount = case_payment_actual_amount
        # 是否能够下载 true可以下载 false没有可下载文件
        self.can_download = can_download

    def validate(self):
        self.validate_required(self.case_id, 'case_id')
        self.validate_required(self.case_phase, 'case_phase')
        self.validate_required(self.record_id, 'record_id')
        self.validate_required(self.record_type, 'record_type')
        self.validate_required(self.case_status, 'case_status')
        self.validate_required(self.submit_time, 'submit_time')
        self.validate_required(self.arbitral_body, 'arbitral_body')
        self.validate_required(self.can_download, 'can_download')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.case_id is not None:
            result['case_id'] = self.case_id
        if self.case_phase is not None:
            result['case_phase'] = self.case_phase
        if self.record_id is not None:
            result['record_id'] = self.record_id
        if self.record_type is not None:
            result['record_type'] = self.record_type
        if self.case_status is not None:
            result['case_status'] = self.case_status
        if self.submit_time is not None:
            result['submit_time'] = self.submit_time
        if self.arbitral_body is not None:
            result['arbitral_body'] = self.arbitral_body
        if self.close_time is not None:
            result['close_time'] = self.close_time
        if self.acceptance_number is not None:
            result['acceptance_number'] = self.acceptance_number
        if self.case_payment_actual_amount is not None:
            result['case_payment_actual_amount'] = self.case_payment_actual_amount
        if self.can_download is not None:
            result['can_download'] = self.can_download
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('case_id') is not None:
            self.case_id = m.get('case_id')
        if m.get('case_phase') is not None:
            self.case_phase = m.get('case_phase')
        if m.get('record_id') is not None:
            self.record_id = m.get('record_id')
        if m.get('record_type') is not None:
            self.record_type = m.get('record_type')
        if m.get('case_status') is not None:
            self.case_status = m.get('case_status')
        if m.get('submit_time') is not None:
            self.submit_time = m.get('submit_time')
        if m.get('arbitral_body') is not None:
            self.arbitral_body = m.get('arbitral_body')
        if m.get('close_time') is not None:
            self.close_time = m.get('close_time')
        if m.get('acceptance_number') is not None:
            self.acceptance_number = m.get('acceptance_number')
        if m.get('case_payment_actual_amount') is not None:
            self.case_payment_actual_amount = m.get('case_payment_actual_amount')
        if m.get('can_download') is not None:
            self.can_download = m.get('can_download')
        return self


class ContractNotaryDocumentInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        signatories: str = None,
        timestamp: str = None,
        tx_hash: str = None,
        file_id: str = None,
    ):
        # 签署完成的合同hash
        self.content = content
        # 签署人ID（支持多个，不同ID间用“,”分隔开）
        self.signatories = signatories
        # 存证结束时间，UNIX时间戳(毫秒)
        self.timestamp = timestamp
        # 存证凭据，仅在批量核验时需要填写
        self.tx_hash = tx_hash
        # 签署的文件ID
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.signatories, 'signatories')
        self.validate_required(self.timestamp, 'timestamp')
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.signatories is not None:
            result['signatories'] = self.signatories
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.file_id is not None:
            result['file_id'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('signatories') is not None:
            self.signatories = m.get('signatories')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        return self


class KeywordsPosition(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        page_index: int = None,
        pos_x: str = None,
        pos_y: str = None,
    ):
        # 关键字
        self.keyword = keyword
        # 页码
        self.page_index = page_index
        # x坐标
        self.pos_x = pos_x
        # y坐标
        self.pos_y = pos_y

    def validate(self):
        self.validate_required(self.keyword, 'keyword')
        self.validate_required(self.page_index, 'page_index')
        self.validate_required(self.pos_x, 'pos_x')
        self.validate_required(self.pos_y, 'pos_y')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.page_index is not None:
            result['page_index'] = self.page_index
        if self.pos_x is not None:
            result['pos_x'] = self.pos_x
        if self.pos_y is not None:
            result['pos_y'] = self.pos_y
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('page_index') is not None:
            self.page_index = m.get('page_index')
        if m.get('pos_x') is not None:
            self.pos_x = m.get('pos_x')
        if m.get('pos_y') is not None:
            self.pos_y = m.get('pos_y')
        return self


class ContractDocAddress(TeaModel):
    def __init__(
        self,
        file_id: str = None,
        file_name: str = None,
        file_url: str = None,
        tx_hash: str = None,
    ):
        # 电子合同文档ID
        self.file_id = file_id
        # 电子合同文档名称，默认文件名称
        self.file_name = file_name
        # 电子合同下载文档地址, 有效时间1小时
        self.file_url = file_url
        # 合同文件的存证地址
        self.tx_hash = tx_hash

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.file_url, 'file_url')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.file_url is not None:
            result['file_url'] = self.file_url
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('file_url') is not None:
            self.file_url = m.get('file_url')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        return self


class StubCommonInfo(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        scene_name: str = None,
        biz_type: str = None,
        biz_source: str = None,
        order_id: str = None,
        order_name: str = None,
        order_amount: int = None,
        order_time: str = None,
        stub_amount: int = None,
        customer_id: str = None,
        scene_alipay_id: str = None,
        back_type: str = None,
    ):
        # 项目名称
        self.project_name = project_name
        # 客户名称（三方合约中甲方名称：景区或服务商）
        self.scene_name = scene_name
        # 业务类型。目前只有数字票根这一个情景，枚举为：TICKET_STUB
        self.biz_type = biz_type
        # 业务来源；Alipay：支付宝，Scene：景区
        self.biz_source = biz_source
        # 订单id。若bizSource为支付宝情况下传支付宝流水号（业务系统的出票流水号）；若bizSource为景区时传上游生成的订单号
        self.order_id = order_id
        # 订单名称
        self.order_name = order_name
        # 订单总金额，单位：分。如传100，即为100分，1元
        self.order_amount = order_amount
        # 下单时间
        self.order_time = order_time
        # 待分账金额，单位：分。如传100，即为100分，1元
        self.stub_amount = stub_amount
        # 客户id。支付宝情况下传支付宝id，2088打头；景区时可传自定义的客户id
        self.customer_id = customer_id
        # 景区支付宝id，当biz_source为Alipay时，该字段必填
        self.scene_alipay_id = scene_alipay_id
        # 数字票根背面业务类型，如 IMAGE（背面上传照片业务）、IMAGEANDAR（背面上传照片和AR孔明灯业务）
        self.back_type = back_type

    def validate(self):
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.scene_name, 'scene_name')
        self.validate_required(self.biz_type, 'biz_type')
        self.validate_required(self.biz_source, 'biz_source')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.order_amount, 'order_amount')
        self.validate_required(self.order_time, 'order_time')
        if self.order_time is not None:
            self.validate_pattern(self.order_time, 'order_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.stub_amount, 'stub_amount')
        self.validate_required(self.customer_id, 'customer_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.scene_name is not None:
            result['scene_name'] = self.scene_name
        if self.biz_type is not None:
            result['biz_type'] = self.biz_type
        if self.biz_source is not None:
            result['biz_source'] = self.biz_source
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_name is not None:
            result['order_name'] = self.order_name
        if self.order_amount is not None:
            result['order_amount'] = self.order_amount
        if self.order_time is not None:
            result['order_time'] = self.order_time
        if self.stub_amount is not None:
            result['stub_amount'] = self.stub_amount
        if self.customer_id is not None:
            result['customer_id'] = self.customer_id
        if self.scene_alipay_id is not None:
            result['scene_alipay_id'] = self.scene_alipay_id
        if self.back_type is not None:
            result['back_type'] = self.back_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('scene_name') is not None:
            self.scene_name = m.get('scene_name')
        if m.get('biz_type') is not None:
            self.biz_type = m.get('biz_type')
        if m.get('biz_source') is not None:
            self.biz_source = m.get('biz_source')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_name') is not None:
            self.order_name = m.get('order_name')
        if m.get('order_amount') is not None:
            self.order_amount = m.get('order_amount')
        if m.get('order_time') is not None:
            self.order_time = m.get('order_time')
        if m.get('stub_amount') is not None:
            self.stub_amount = m.get('stub_amount')
        if m.get('customer_id') is not None:
            self.customer_id = m.get('customer_id')
        if m.get('scene_alipay_id') is not None:
            self.scene_alipay_id = m.get('scene_alipay_id')
        if m.get('back_type') is not None:
            self.back_type = m.get('back_type')
        return self


class WitnessFlowConfig(TeaModel):
    def __init__(
        self,
        organ_realname_types: List[int] = None,
        person_realname_types: List[int] = None,
        real_name_cert: bool = None,
        willingness_types: List[int] = None,
    ):
        # 企业实名认证方式,对公打款：1；企业芝麻认证：3；法定代表授权：4；
        self.organ_realname_types = organ_realname_types
        # 个人实名认证方式, 银行四要素：2；芝麻认证-人脸识别：3；微众-人脸识别：4；
        self.person_realname_types = person_realname_types
        # 是否需要实名认证
        self.real_name_cert = real_name_cert
        # 意愿认证方式, 芝麻认证-人脸识别：2；短信验证码：3；微众-人脸识别：4；ukey认证：5；签署密码认证：6；
        self.willingness_types = willingness_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.organ_realname_types is not None:
            result['organ_realname_types'] = self.organ_realname_types
        if self.person_realname_types is not None:
            result['person_realname_types'] = self.person_realname_types
        if self.real_name_cert is not None:
            result['real_name_cert'] = self.real_name_cert
        if self.willingness_types is not None:
            result['willingness_types'] = self.willingness_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('organ_realname_types') is not None:
            self.organ_realname_types = m.get('organ_realname_types')
        if m.get('person_realname_types') is not None:
            self.person_realname_types = m.get('person_realname_types')
        if m.get('real_name_cert') is not None:
            self.real_name_cert = m.get('real_name_cert')
        if m.get('willingness_types') is not None:
            self.willingness_types = m.get('willingness_types')
        return self


class WitnessApprovalData(TeaModel):
    def __init__(
        self,
        approval_flow_id: str = None,
        seal_ids: List[str] = None,
    ):
        # 审批流程id
        self.approval_flow_id = approval_flow_id
        # 印章id列表
        self.seal_ids = seal_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approval_flow_id is not None:
            result['approval_flow_id'] = self.approval_flow_id
        if self.seal_ids is not None:
            result['seal_ids'] = self.seal_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('approval_flow_id') is not None:
            self.approval_flow_id = m.get('approval_flow_id')
        if m.get('seal_ids') is not None:
            self.seal_ids = m.get('seal_ids')
        return self


class SupplierProductItem(TeaModel):
    def __init__(
        self,
        supplier_name: str = None,
        product_model: str = None,
        supplier_id: str = None,
        product_id: str = None,
        main_class: str = None,
        estimated_shipment: int = None,
        sub_class: str = None,
        product_detail_info: str = None,
        product_brand: str = None,
        product_origin: int = None,
        product_name: str = None,
        product_version: int = None,
        install_price: int = None,
        real_stock: int = None,
        deposit_price: int = None,
        product_url: str = None,
        product_price: int = None,
        extra_info: str = None,
    ):
        # 供应商名称
        self.supplier_name = supplier_name
        # 商品型号
        self.product_model = product_model
        # 供应商id
        self.supplier_id = supplier_id
        # 商品唯一id
        self.product_id = product_id
        # 3C
        self.main_class = main_class
        # 预计发货量
        self.estimated_shipment = estimated_shipment
        # 二级类目
        self.sub_class = sub_class
        # 商品详情
        self.product_detail_info = product_detail_info
        # 商品品牌
        self.product_brand = product_brand
        # 商品来源
        self.product_origin = product_origin
        # 商品名称
        self.product_name = product_name
        # 商品版本
        self.product_version = product_version
        # 商品安装费用
        self.install_price = install_price
        # 实际库存
        self.real_stock = real_stock
        # 保证金
        self.deposit_price = deposit_price
        # 商品url
        self.product_url = product_url
        # 官网价
        self.product_price = product_price
        # 商品预留字段
        self.extra_info = extra_info

    def validate(self):
        self.validate_required(self.product_model, 'product_model')
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.main_class, 'main_class')
        self.validate_required(self.sub_class, 'sub_class')
        self.validate_required(self.product_detail_info, 'product_detail_info')
        self.validate_required(self.product_brand, 'product_brand')
        self.validate_required(self.product_origin, 'product_origin')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.product_version, 'product_version')
        self.validate_required(self.product_price, 'product_price')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.supplier_name is not None:
            result['supplier_name'] = self.supplier_name
        if self.product_model is not None:
            result['product_model'] = self.product_model
        if self.supplier_id is not None:
            result['supplier_id'] = self.supplier_id
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.main_class is not None:
            result['main_class'] = self.main_class
        if self.estimated_shipment is not None:
            result['estimated_shipment'] = self.estimated_shipment
        if self.sub_class is not None:
            result['sub_class'] = self.sub_class
        if self.product_detail_info is not None:
            result['product_detail_info'] = self.product_detail_info
        if self.product_brand is not None:
            result['product_brand'] = self.product_brand
        if self.product_origin is not None:
            result['product_origin'] = self.product_origin
        if self.product_name is not None:
            result['product_name'] = self.product_name
        if self.product_version is not None:
            result['product_version'] = self.product_version
        if self.install_price is not None:
            result['install_price'] = self.install_price
        if self.real_stock is not None:
            result['real_stock'] = self.real_stock
        if self.deposit_price is not None:
            result['deposit_price'] = self.deposit_price
        if self.product_url is not None:
            result['product_url'] = self.product_url
        if self.product_price is not None:
            result['product_price'] = self.product_price
        if self.extra_info is not None:
            result['extra_info'] = self.extra_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('supplier_name') is not None:
            self.supplier_name = m.get('supplier_name')
        if m.get('product_model') is not None:
            self.product_model = m.get('product_model')
        if m.get('supplier_id') is not None:
            self.supplier_id = m.get('supplier_id')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('main_class') is not None:
            self.main_class = m.get('main_class')
        if m.get('estimated_shipment') is not None:
            self.estimated_shipment = m.get('estimated_shipment')
        if m.get('sub_class') is not None:
            self.sub_class = m.get('sub_class')
        if m.get('product_detail_info') is not None:
            self.product_detail_info = m.get('product_detail_info')
        if m.get('product_brand') is not None:
            self.product_brand = m.get('product_brand')
        if m.get('product_origin') is not None:
            self.product_origin = m.get('product_origin')
        if m.get('product_name') is not None:
            self.product_name = m.get('product_name')
        if m.get('product_version') is not None:
            self.product_version = m.get('product_version')
        if m.get('install_price') is not None:
            self.install_price = m.get('install_price')
        if m.get('real_stock') is not None:
            self.real_stock = m.get('real_stock')
        if m.get('deposit_price') is not None:
            self.deposit_price = m.get('deposit_price')
        if m.get('product_url') is not None:
            self.product_url = m.get('product_url')
        if m.get('product_price') is not None:
            self.product_price = m.get('product_price')
        if m.get('extra_info') is not None:
            self.extra_info = m.get('extra_info')
        return self


class PhaseQueryResult(TeaModel):
    def __init__(
        self,
        phase_id: str = None,
        tx_hash: str = None,
        status: str = None,
        register_time: int = None,
    ):
        # 阶段ID
        self.phase_id = phase_id
        # 阶段存证的链上交易Hash，只有status为FINISH才会返回
        self.tx_hash = tx_hash
        # 阶段存证状态
        self.status = status
        # 阶段注册成功时间戳
        self.register_time = register_time

    def validate(self):
        self.validate_required(self.phase_id, 'phase_id')
        self.validate_required(self.tx_hash, 'tx_hash')
        self.validate_required(self.status, 'status')
        self.validate_required(self.register_time, 'register_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.phase_id is not None:
            result['phase_id'] = self.phase_id
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.status is not None:
            result['status'] = self.status
        if self.register_time is not None:
            result['register_time'] = self.register_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('phase_id') is not None:
            self.phase_id = m.get('phase_id')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('register_time') is not None:
            self.register_time = m.get('register_time')
        return self


class ApplySupplierOrderProductInput(TeaModel):
    def __init__(
        self,
        product_id: str = None,
        product_num: int = None,
    ):
        # 采购商品id
        self.product_id = product_id
        # 采购商品数量
        self.product_num = product_num

    def validate(self):
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.product_num, 'product_num')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.product_num is not None:
            result['product_num'] = self.product_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('product_num') is not None:
            self.product_num = m.get('product_num')
        return self


class ContractOrganizationApplication(TeaModel):
    def __init__(
        self,
        id_number: str = None,
        id_type: str = None,
        legal_person: str = None,
        legal_person_id: str = None,
        name: str = None,
        organization_id: str = None,
        org_type: str = None,
    ):
        # 证件号
        self.id_number = id_number
        # 证件类型，默认CRED_ORG_USCC，详见机构证件类型说明 （https://antchain.antgroup.com/docs/2/424437#）
        self.id_type = id_type
        # 企业法人名称
        self.legal_person = legal_person
        # 企业法人证件号
        self.legal_person_id = legal_person_id
        # 机构名称
        self.name = name
        # 机构唯一标识，可传入第三方平台的机构用户id等
        self.organization_id = organization_id
        # 机构子类型：ENTERPRISE（企业）、SELF-EMPLOYED（个体工商户）、SUBSIDIARY（分公司）、OTHERORG（其他机构）。若填入这些类型，将会进行相应参数校验，例如：企业类型要求进行企业四要素校验，企业证件号必须是91开头，并且企业类型在签署时会需要授权后才可进行签署；个体工商户要求证件号必须是92开头，其余类型无其他校验。不填入此参数不会进行校验。
        self.org_type = org_type

    def validate(self):
        self.validate_required(self.id_number, 'id_number')
        self.validate_required(self.id_type, 'id_type')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.legal_person is not None:
            result['legal_person'] = self.legal_person
        if self.legal_person_id is not None:
            result['legal_person_id'] = self.legal_person_id
        if self.name is not None:
            result['name'] = self.name
        if self.organization_id is not None:
            result['organization_id'] = self.organization_id
        if self.org_type is not None:
            result['org_type'] = self.org_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('legal_person') is not None:
            self.legal_person = m.get('legal_person')
        if m.get('legal_person_id') is not None:
            self.legal_person_id = m.get('legal_person_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('organization_id') is not None:
            self.organization_id = m.get('organization_id')
        if m.get('org_type') is not None:
            self.org_type = m.get('org_type')
        return self


class PhaseCreateResult(TeaModel):
    def __init__(
        self,
        phase_no: int = None,
        phase_id: str = None,
        origin_data_id: str = None,
    ):
        # 阶段编号，与模板阶段编号保持一致，不同阶段阶段编号不一样，要与阶段存证内容保持一致
        self.phase_no = phase_no
        # 阶段ID，阶段存证的唯一标记
        self.phase_id = phase_id
        # 业务方原始数据ID，方便与业务方进行数据核对使用，并且如果同一个阶段多次存证，则需要根据业务方原始数据ID识别不同的阶段存证响应
        self.origin_data_id = origin_data_id

    def validate(self):
        self.validate_required(self.phase_no, 'phase_no')
        self.validate_required(self.phase_id, 'phase_id')
        self.validate_required(self.origin_data_id, 'origin_data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.phase_no is not None:
            result['phase_no'] = self.phase_no
        if self.phase_id is not None:
            result['phase_id'] = self.phase_id
        if self.origin_data_id is not None:
            result['origin_data_id'] = self.origin_data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('phase_no') is not None:
            self.phase_no = m.get('phase_no')
        if m.get('phase_id') is not None:
            self.phase_id = m.get('phase_id')
        if m.get('origin_data_id') is not None:
            self.origin_data_id = m.get('origin_data_id')
        return self


class EvidentialCheckList(TeaModel):
    def __init__(
        self,
        evidential_name_en: str = None,
        oss_file_name: str = None,
        oss_file_key: str = None,
        sources_of_evidence: str = None,
        evidence_type: str = None,
        deposit_type: str = None,
        tx_hash: str = None,
        deposit_time: str = None,
    ):
        # 证据名称英文
        self.evidential_name_en = evidential_name_en
        # 文件名称
        self.oss_file_name = oss_file_name
        # 文件fileKey ，调用获取文件上传链接时对应的fileKey
        self.oss_file_key = oss_file_key
        # 证据来源
        # BUSINESS_UPLOAD	业务传入
        # ADD_MANULLY	手动添加
        self.sources_of_evidence = sources_of_evidence
        # 证据类型
        # BLOCKCHAIN_DEPOSIT	区块链存证
        # USER_UPLOAD	用户上传
        self.evidence_type = evidence_type
        # 存证类型
        # TEXT	文本
        # FILE	文件
        self.deposit_type = deposit_type
        # 存证哈希 当为区块链存证必填
        self.tx_hash = tx_hash
        # 存证时间 当为区块链存证必填
        self.deposit_time = deposit_time

    def validate(self):
        self.validate_required(self.evidential_name_en, 'evidential_name_en')
        self.validate_required(self.oss_file_name, 'oss_file_name')
        self.validate_required(self.oss_file_key, 'oss_file_key')
        self.validate_required(self.sources_of_evidence, 'sources_of_evidence')
        self.validate_required(self.evidence_type, 'evidence_type')
        self.validate_required(self.deposit_type, 'deposit_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.evidential_name_en is not None:
            result['evidential_name_en'] = self.evidential_name_en
        if self.oss_file_name is not None:
            result['oss_file_name'] = self.oss_file_name
        if self.oss_file_key is not None:
            result['oss_file_key'] = self.oss_file_key
        if self.sources_of_evidence is not None:
            result['sources_of_evidence'] = self.sources_of_evidence
        if self.evidence_type is not None:
            result['evidence_type'] = self.evidence_type
        if self.deposit_type is not None:
            result['deposit_type'] = self.deposit_type
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.deposit_time is not None:
            result['deposit_time'] = self.deposit_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('evidential_name_en') is not None:
            self.evidential_name_en = m.get('evidential_name_en')
        if m.get('oss_file_name') is not None:
            self.oss_file_name = m.get('oss_file_name')
        if m.get('oss_file_key') is not None:
            self.oss_file_key = m.get('oss_file_key')
        if m.get('sources_of_evidence') is not None:
            self.sources_of_evidence = m.get('sources_of_evidence')
        if m.get('evidence_type') is not None:
            self.evidence_type = m.get('evidence_type')
        if m.get('deposit_type') is not None:
            self.deposit_type = m.get('deposit_type')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('deposit_time') is not None:
            self.deposit_time = m.get('deposit_time')
        return self


class WitnessSignResult(TeaModel):
    def __init__(
        self,
        sign_result: str = None,
        signlog_id: str = None,
        third_doc_id: str = None,
    ):
        # 签名结果，外部用户签署返回
        self.sign_result = sign_result
        # 签署日志id，外部用户签署返回
        self.signlog_id = signlog_id
        # 第三方文档id
        self.third_doc_id = third_doc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sign_result is not None:
            result['sign_result'] = self.sign_result
        if self.signlog_id is not None:
            result['signlog_id'] = self.signlog_id
        if self.third_doc_id is not None:
            result['third_doc_id'] = self.third_doc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sign_result') is not None:
            self.sign_result = m.get('sign_result')
        if m.get('signlog_id') is not None:
            self.signlog_id = m.get('signlog_id')
        if m.get('third_doc_id') is not None:
            self.third_doc_id = m.get('third_doc_id')
        return self


class NotaryCheckMeta(TeaModel):
    def __init__(
        self,
        agency_code: str = None,
        hash_algorithm: str = None,
        notary_content: str = None,
        tx_hash: str = None,
        application_code: str = None,
    ):
        # 对应的法院编号
        self.agency_code = agency_code
        # 哈希算法, notary_type 为 HASH 时此参数必填
        self.hash_algorithm = hash_algorithm
        # 存证内容
        self.notary_content = notary_content
        # 交易哈希
        self.tx_hash = tx_hash
        # 应用ID
        self.application_code = application_code

    def validate(self):
        self.validate_required(self.notary_content, 'notary_content')
        self.validate_required(self.tx_hash, 'tx_hash')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agency_code is not None:
            result['agency_code'] = self.agency_code
        if self.hash_algorithm is not None:
            result['hash_algorithm'] = self.hash_algorithm
        if self.notary_content is not None:
            result['notary_content'] = self.notary_content
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.application_code is not None:
            result['application_code'] = self.application_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('agency_code') is not None:
            self.agency_code = m.get('agency_code')
        if m.get('hash_algorithm') is not None:
            self.hash_algorithm = m.get('hash_algorithm')
        if m.get('notary_content') is not None:
            self.notary_content = m.get('notary_content')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('application_code') is not None:
            self.application_code = m.get('application_code')
        return self


class ContractNotaryDeductRefundInfo(TeaModel):
    def __init__(
        self,
        payer_id: str = None,
        amount: int = None,
        order: str = None,
        timestamp: str = None,
    ):
        # PAYERIDNUMBER
        self.payer_id = payer_id
        # 退款金额，单位分
        self.amount = amount
        # 代扣计划ID
        self.order = order
        # 退款操作发起时间
        self.timestamp = timestamp

    def validate(self):
        self.validate_required(self.payer_id, 'payer_id')
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.order, 'order')
        self.validate_required(self.timestamp, 'timestamp')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.payer_id is not None:
            result['payer_id'] = self.payer_id
        if self.amount is not None:
            result['amount'] = self.amount
        if self.order is not None:
            result['order'] = self.order
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('payer_id') is not None:
            self.payer_id = m.get('payer_id')
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class SupplierLogisticInfo(TeaModel):
    def __init__(
        self,
        logistic_order_id: str = None,
    ):
        # 采购平台的物流单号
        self.logistic_order_id = logistic_order_id

    def validate(self):
        self.validate_required(self.logistic_order_id, 'logistic_order_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logistic_order_id is not None:
            result['logistic_order_id'] = self.logistic_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('logistic_order_id') is not None:
            self.logistic_order_id = m.get('logistic_order_id')
        return self


class RenbaoExtInfo(TeaModel):
    def __init__(
        self,
        rec_bank_area_code: str = None,
        account_no: str = None,
        bank_name: str = None,
        account_name: str = None,
        cnaps: str = None,
        identify_no: str = None,
    ):
        # 银行区域代码，可网上查询各银行最新对应的区域代码，比如杭州的区域代码为：3301
        self.rec_bank_area_code = rec_bank_area_code
        # 投保人收款账号
        self.account_no = account_no
        # 完整银行名称，不需要具体到分行
        self.bank_name = bank_name
        # 投保人户名
        self.account_name = account_name
        # 联行号
        self.cnaps = cnaps
        # 统一社会信用代码
        self.identify_no = identify_no

    def validate(self):
        self.validate_required(self.rec_bank_area_code, 'rec_bank_area_code')
        if self.rec_bank_area_code is not None:
            self.validate_max_length(self.rec_bank_area_code, 'rec_bank_area_code', 8)
        self.validate_required(self.account_no, 'account_no')
        if self.account_no is not None:
            self.validate_max_length(self.account_no, 'account_no', 32)
        self.validate_required(self.bank_name, 'bank_name')
        if self.bank_name is not None:
            self.validate_max_length(self.bank_name, 'bank_name', 32)
        self.validate_required(self.account_name, 'account_name')
        if self.account_name is not None:
            self.validate_max_length(self.account_name, 'account_name', 64)
        self.validate_required(self.cnaps, 'cnaps')
        if self.cnaps is not None:
            self.validate_max_length(self.cnaps, 'cnaps', 16)
        self.validate_required(self.identify_no, 'identify_no')
        if self.identify_no is not None:
            self.validate_max_length(self.identify_no, 'identify_no', 32)

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rec_bank_area_code is not None:
            result['rec_bank_area_code'] = self.rec_bank_area_code
        if self.account_no is not None:
            result['account_no'] = self.account_no
        if self.bank_name is not None:
            result['bank_name'] = self.bank_name
        if self.account_name is not None:
            result['account_name'] = self.account_name
        if self.cnaps is not None:
            result['cnaps'] = self.cnaps
        if self.identify_no is not None:
            result['identify_no'] = self.identify_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rec_bank_area_code') is not None:
            self.rec_bank_area_code = m.get('rec_bank_area_code')
        if m.get('account_no') is not None:
            self.account_no = m.get('account_no')
        if m.get('bank_name') is not None:
            self.bank_name = m.get('bank_name')
        if m.get('account_name') is not None:
            self.account_name = m.get('account_name')
        if m.get('cnaps') is not None:
            self.cnaps = m.get('cnaps')
        if m.get('identify_no') is not None:
            self.identify_no = m.get('identify_no')
        return self


class JudicialEventOperateInfo(TeaModel):
    def __init__(
        self,
        operate_type: str = None,
        operate_opinion: str = None,
        operate_reason: str = None,
        req_biz_no: str = None,
    ):
        # 响应类型:
        # 司法调解
        # 延期确认: DELAY_CONFIRM
        # 回款确认: CASH_CONFIRM
        # 
        self.operate_type = operate_type
        # 响应内容
        # 延期确认
        # 确认-CONFIRM
        # 否认-DENY
        # 回款确认:
        # 确认-CONFIRM
        # 有异议-DISSENT
        self.operate_opinion = operate_opinion
        # 当延期申请不同意,回款确认有异议时填写原因
        self.operate_reason = operate_reason
        # 回款记录编号,回款确认时必填
        self.req_biz_no = req_biz_no

    def validate(self):
        self.validate_required(self.operate_type, 'operate_type')
        self.validate_required(self.operate_opinion, 'operate_opinion')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_type is not None:
            result['operate_type'] = self.operate_type
        if self.operate_opinion is not None:
            result['operate_opinion'] = self.operate_opinion
        if self.operate_reason is not None:
            result['operate_reason'] = self.operate_reason
        if self.req_biz_no is not None:
            result['req_biz_no'] = self.req_biz_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operate_type') is not None:
            self.operate_type = m.get('operate_type')
        if m.get('operate_opinion') is not None:
            self.operate_opinion = m.get('operate_opinion')
        if m.get('operate_reason') is not None:
            self.operate_reason = m.get('operate_reason')
        if m.get('req_biz_no') is not None:
            self.req_biz_no = m.get('req_biz_no')
        return self


class ContractSignFlowConfig(TeaModel):
    def __init__(
        self,
        notice_developer_url: str = None,
        notice_type: str = None,
        redirect_url: str = None,
        sign_platform: str = None,
        redirect_url_on_failure: str = None,
        free_signature: bool = None,
    ):
        # 回调通知地址 ,默认取项目配置通知地址
        self.notice_developer_url = notice_developer_url
        # 签署通知和审批通知的通知方式，传 "" 表示不需要通知，传"1"表示短信通知。短信功能需要联系售后开白名单才会生效。
        self.notice_type = notice_type
        # 签署成功或者流程结束后的默认重定向地址，默认签署完成停在当前页面
        self.redirect_url = redirect_url
        # 【该字段已废弃】签署平台，逗号分割，1-开放服务h5，2-支付宝签 ，默认值1
        self.sign_platform = sign_platform
        # 签署失败时的跳转地址，如果不做单独配置，默认与redirect_url一致（配合twc.notary.contract.signflow.create接口使用）
        self.redirect_url_on_failure = redirect_url_on_failure
        # 是否允许自由签署，默认false（配合twc.notary.contract.signflow.create接口使用）
        self.free_signature = free_signature

    def validate(self):
        self.validate_required(self.notice_type, 'notice_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notice_developer_url is not None:
            result['notice_developer_url'] = self.notice_developer_url
        if self.notice_type is not None:
            result['notice_type'] = self.notice_type
        if self.redirect_url is not None:
            result['redirect_url'] = self.redirect_url
        if self.sign_platform is not None:
            result['sign_platform'] = self.sign_platform
        if self.redirect_url_on_failure is not None:
            result['redirect_url_on_failure'] = self.redirect_url_on_failure
        if self.free_signature is not None:
            result['free_signature'] = self.free_signature
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('notice_developer_url') is not None:
            self.notice_developer_url = m.get('notice_developer_url')
        if m.get('notice_type') is not None:
            self.notice_type = m.get('notice_type')
        if m.get('redirect_url') is not None:
            self.redirect_url = m.get('redirect_url')
        if m.get('sign_platform') is not None:
            self.sign_platform = m.get('sign_platform')
        if m.get('redirect_url_on_failure') is not None:
            self.redirect_url_on_failure = m.get('redirect_url_on_failure')
        if m.get('free_signature') is not None:
            self.free_signature = m.get('free_signature')
        return self


class RentInfo(TeaModel):
    def __init__(
        self,
        rent_price: int = None,
        rent_term: int = None,
        commission: int = None,
        buyout_price: int = None,
        retained_price: int = None,
    ):
        # 租金
        self.rent_price = rent_price
        # 租期
        self.rent_term = rent_term
        # 手续费
        self.commission = commission
        # 买断价
        self.buyout_price = buyout_price
        # 留购价
        self.retained_price = retained_price

    def validate(self):
        self.validate_required(self.rent_price, 'rent_price')
        self.validate_required(self.rent_term, 'rent_term')
        self.validate_required(self.commission, 'commission')
        self.validate_required(self.buyout_price, 'buyout_price')
        self.validate_required(self.retained_price, 'retained_price')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rent_price is not None:
            result['rent_price'] = self.rent_price
        if self.rent_term is not None:
            result['rent_term'] = self.rent_term
        if self.commission is not None:
            result['commission'] = self.commission
        if self.buyout_price is not None:
            result['buyout_price'] = self.buyout_price
        if self.retained_price is not None:
            result['retained_price'] = self.retained_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rent_price') is not None:
            self.rent_price = m.get('rent_price')
        if m.get('rent_term') is not None:
            self.rent_term = m.get('rent_term')
        if m.get('commission') is not None:
            self.commission = m.get('commission')
        if m.get('buyout_price') is not None:
            self.buyout_price = m.get('buyout_price')
        if m.get('retained_price') is not None:
            self.retained_price = m.get('retained_price')
        return self


class LeaseClearingInfo(TeaModel):
    def __init__(
        self,
        return_index: int = None,
        clearing_state: int = None,
        clearing_money: int = None,
        start_time: str = None,
        end_time: str = None,
        clearing_order_id: str = None,
        clearing_account: str = None,
        memo: str = None,
    ):
        # 还款批次
        self.return_index = return_index
        # 清分状态
        self.clearing_state = clearing_state
        # 清分金额,精确到毫厘，即123400表示12.34元
        self.clearing_money = clearing_money
        # 开始清分时间
        self.start_time = start_time
        # 结束清分时间
        self.end_time = end_time
        # 清分单号
        self.clearing_order_id = clearing_order_id
        # 清分收款账号
        self.clearing_account = clearing_account
        # 清分额外说明
        self.memo = memo

    def validate(self):
        self.validate_required(self.return_index, 'return_index')
        self.validate_required(self.clearing_state, 'clearing_state')
        self.validate_required(self.clearing_money, 'clearing_money')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.clearing_order_id, 'clearing_order_id')
        self.validate_required(self.clearing_account, 'clearing_account')
        self.validate_required(self.memo, 'memo')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.return_index is not None:
            result['return_index'] = self.return_index
        if self.clearing_state is not None:
            result['clearing_state'] = self.clearing_state
        if self.clearing_money is not None:
            result['clearing_money'] = self.clearing_money
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.clearing_order_id is not None:
            result['clearing_order_id'] = self.clearing_order_id
        if self.clearing_account is not None:
            result['clearing_account'] = self.clearing_account
        if self.memo is not None:
            result['memo'] = self.memo
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('return_index') is not None:
            self.return_index = m.get('return_index')
        if m.get('clearing_state') is not None:
            self.clearing_state = m.get('clearing_state')
        if m.get('clearing_money') is not None:
            self.clearing_money = m.get('clearing_money')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('clearing_order_id') is not None:
            self.clearing_order_id = m.get('clearing_order_id')
        if m.get('clearing_account') is not None:
            self.clearing_account = m.get('clearing_account')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        return self


class PhaseDetail(TeaModel):
    def __init__(
        self,
        phase_id: str = None,
        phase_no: int = None,
        register_time: int = None,
        tx_hash: str = None,
        data_type: str = None,
        notary_content: str = None,
        data_type_key: str = None,
    ):
        # 阶段id
        self.phase_id = phase_id
        # 阶段编号
        self.phase_no = phase_no
        # 阶段存证时间
        self.register_time = register_time
        # 阶段存证凭据
        self.tx_hash = tx_hash
        # 模板字段类型，Hash/Structure，(Hash->哈希,Structure->结构化)
        self.data_type = data_type
        # 阶段存证内容
        # 如果模板数据类型定义是Hash(哈希)则返回存证时Hash
        # 如果定义是Structure(结构化)，则返回所有字段json对象的字符串Base64后的值
        self.notary_content = notary_content
        # 模板字段类型为Structure时才有值，结构化数据里面英文key对应的中文名称关系，json格式，key为字段英文名，value为字段中文名称
        self.data_type_key = data_type_key

    def validate(self):
        self.validate_required(self.phase_id, 'phase_id')
        self.validate_required(self.phase_no, 'phase_no')
        self.validate_required(self.register_time, 'register_time')
        self.validate_required(self.tx_hash, 'tx_hash')
        self.validate_required(self.data_type, 'data_type')
        self.validate_required(self.notary_content, 'notary_content')
        self.validate_required(self.data_type_key, 'data_type_key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.phase_id is not None:
            result['phase_id'] = self.phase_id
        if self.phase_no is not None:
            result['phase_no'] = self.phase_no
        if self.register_time is not None:
            result['register_time'] = self.register_time
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.data_type is not None:
            result['data_type'] = self.data_type
        if self.notary_content is not None:
            result['notary_content'] = self.notary_content
        if self.data_type_key is not None:
            result['data_type_key'] = self.data_type_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('phase_id') is not None:
            self.phase_id = m.get('phase_id')
        if m.get('phase_no') is not None:
            self.phase_no = m.get('phase_no')
        if m.get('register_time') is not None:
            self.register_time = m.get('register_time')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('data_type') is not None:
            self.data_type = m.get('data_type')
        if m.get('notary_content') is not None:
            self.notary_content = m.get('notary_content')
        if m.get('data_type_key') is not None:
            self.data_type_key = m.get('data_type_key')
        return self


class CompanyFourMetaInfo(TeaModel):
    def __init__(
        self,
        company_cert_name: str = None,
        company_cert_no: str = None,
        company_cert_type: str = None,
        legal_person_cert_name: str = None,
        legal_person_cert_no: str = None,
        legal_person_cert_type: str = None,
    ):
        # 企业证件名称
        self.company_cert_name = company_cert_name
        # 企业证件号码
        self.company_cert_no = company_cert_no
        # 证件类型, 默认社会统一信用代码  NATIONAL_LEGAL_MERGE:统一社会信用代码，NATIONAL_LEGAL：营业执照号码
        self.company_cert_type = company_cert_type
        # 法人证件名称
        self.legal_person_cert_name = legal_person_cert_name
        # 法人证件号码
        self.legal_person_cert_no = legal_person_cert_no
        # 法人证件类型 RESIDENT：居民身份证号，PASSPORT：护照，MILITARY：军官证
        self.legal_person_cert_type = legal_person_cert_type

    def validate(self):
        self.validate_required(self.company_cert_name, 'company_cert_name')
        self.validate_required(self.company_cert_no, 'company_cert_no')
        self.validate_required(self.legal_person_cert_name, 'legal_person_cert_name')
        self.validate_required(self.legal_person_cert_no, 'legal_person_cert_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.company_cert_name is not None:
            result['company_cert_name'] = self.company_cert_name
        if self.company_cert_no is not None:
            result['company_cert_no'] = self.company_cert_no
        if self.company_cert_type is not None:
            result['company_cert_type'] = self.company_cert_type
        if self.legal_person_cert_name is not None:
            result['legal_person_cert_name'] = self.legal_person_cert_name
        if self.legal_person_cert_no is not None:
            result['legal_person_cert_no'] = self.legal_person_cert_no
        if self.legal_person_cert_type is not None:
            result['legal_person_cert_type'] = self.legal_person_cert_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('company_cert_name') is not None:
            self.company_cert_name = m.get('company_cert_name')
        if m.get('company_cert_no') is not None:
            self.company_cert_no = m.get('company_cert_no')
        if m.get('company_cert_type') is not None:
            self.company_cert_type = m.get('company_cert_type')
        if m.get('legal_person_cert_name') is not None:
            self.legal_person_cert_name = m.get('legal_person_cert_name')
        if m.get('legal_person_cert_no') is not None:
            self.legal_person_cert_no = m.get('legal_person_cert_no')
        if m.get('legal_person_cert_type') is not None:
            self.legal_person_cert_type = m.get('legal_person_cert_type')
        return self


class MediationCaseDetailInfo(TeaModel):
    def __init__(
        self,
        case_number: str = None,
        case_code: str = None,
        cause_action_name: str = None,
        case_tatus: str = None,
        mediation_platform: str = None,
        mediation_org: str = None,
        mediator: str = None,
        apply_time: int = None,
        mediation_result: str = None,
        accuser_intent_amount: int = None,
        accused_intent_amount: int = None,
        mediation_amount: int = None,
        confirm_fact: str = None,
        mediation_agreement: str = None,
    ):
        # 案件编码
        self.case_number = case_number
        # 案号
        self.case_code = case_code
        # 案由
        self.cause_action_name = cause_action_name
        # 案件状态
        self.case_tatus = case_tatus
        # 调解平台
        self.mediation_platform = mediation_platform
        # 调解机构
        self.mediation_org = mediation_org
        # 调解员
        self.mediator = mediator
        # 申请时间
        self.apply_time = apply_time
        # 调解结果
        self.mediation_result = mediation_result
        # 申请人意向金额
        self.accuser_intent_amount = accuser_intent_amount
        # 被申请人意向金额
        self.accused_intent_amount = accused_intent_amount
        # 和解金额
        self.mediation_amount = mediation_amount
        # 已确认事实
        self.confirm_fact = confirm_fact
        # 调解协议（已达成调解协议或未达成原因）
        self.mediation_agreement = mediation_agreement

    def validate(self):
        self.validate_required(self.case_number, 'case_number')
        self.validate_required(self.case_code, 'case_code')
        self.validate_required(self.cause_action_name, 'cause_action_name')
        self.validate_required(self.case_tatus, 'case_tatus')
        self.validate_required(self.mediation_platform, 'mediation_platform')
        self.validate_required(self.mediation_org, 'mediation_org')
        self.validate_required(self.mediator, 'mediator')
        self.validate_required(self.apply_time, 'apply_time')
        self.validate_required(self.mediation_result, 'mediation_result')
        self.validate_required(self.accuser_intent_amount, 'accuser_intent_amount')
        self.validate_required(self.accused_intent_amount, 'accused_intent_amount')
        self.validate_required(self.mediation_amount, 'mediation_amount')
        self.validate_required(self.confirm_fact, 'confirm_fact')
        self.validate_required(self.mediation_agreement, 'mediation_agreement')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.case_number is not None:
            result['case_number'] = self.case_number
        if self.case_code is not None:
            result['case_code'] = self.case_code
        if self.cause_action_name is not None:
            result['cause_action_name'] = self.cause_action_name
        if self.case_tatus is not None:
            result['case_tatus'] = self.case_tatus
        if self.mediation_platform is not None:
            result['mediation_platform'] = self.mediation_platform
        if self.mediation_org is not None:
            result['mediation_org'] = self.mediation_org
        if self.mediator is not None:
            result['mediator'] = self.mediator
        if self.apply_time is not None:
            result['apply_time'] = self.apply_time
        if self.mediation_result is not None:
            result['mediation_result'] = self.mediation_result
        if self.accuser_intent_amount is not None:
            result['accuser_intent_amount'] = self.accuser_intent_amount
        if self.accused_intent_amount is not None:
            result['accused_intent_amount'] = self.accused_intent_amount
        if self.mediation_amount is not None:
            result['mediation_amount'] = self.mediation_amount
        if self.confirm_fact is not None:
            result['confirm_fact'] = self.confirm_fact
        if self.mediation_agreement is not None:
            result['mediation_agreement'] = self.mediation_agreement
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('case_number') is not None:
            self.case_number = m.get('case_number')
        if m.get('case_code') is not None:
            self.case_code = m.get('case_code')
        if m.get('cause_action_name') is not None:
            self.cause_action_name = m.get('cause_action_name')
        if m.get('case_tatus') is not None:
            self.case_tatus = m.get('case_tatus')
        if m.get('mediation_platform') is not None:
            self.mediation_platform = m.get('mediation_platform')
        if m.get('mediation_org') is not None:
            self.mediation_org = m.get('mediation_org')
        if m.get('mediator') is not None:
            self.mediator = m.get('mediator')
        if m.get('apply_time') is not None:
            self.apply_time = m.get('apply_time')
        if m.get('mediation_result') is not None:
            self.mediation_result = m.get('mediation_result')
        if m.get('accuser_intent_amount') is not None:
            self.accuser_intent_amount = m.get('accuser_intent_amount')
        if m.get('accused_intent_amount') is not None:
            self.accused_intent_amount = m.get('accused_intent_amount')
        if m.get('mediation_amount') is not None:
            self.mediation_amount = m.get('mediation_amount')
        if m.get('confirm_fact') is not None:
            self.confirm_fact = m.get('confirm_fact')
        if m.get('mediation_agreement') is not None:
            self.mediation_agreement = m.get('mediation_agreement')
        return self


class PleaderObject(TeaModel):
    def __init__(
        self,
        party_type: int = None,
        natural_person: NaturalPerson = None,
        legal_person: LegalPerson = None,
    ):
        # 法人或自然人标识，法人为1，自然人为0
        self.party_type = party_type
        # 自然人信息
        # 当partyType=1必填
        self.natural_person = natural_person
        # 法人信息
        # 当partyType=0必填
        self.legal_person = legal_person

    def validate(self):
        self.validate_required(self.party_type, 'party_type')
        if self.natural_person:
            self.natural_person.validate()
        if self.legal_person:
            self.legal_person.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.party_type is not None:
            result['party_type'] = self.party_type
        if self.natural_person is not None:
            result['natural_person'] = self.natural_person.to_map()
        if self.legal_person is not None:
            result['legal_person'] = self.legal_person.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('party_type') is not None:
            self.party_type = m.get('party_type')
        if m.get('natural_person') is not None:
            temp_model = NaturalPerson()
            self.natural_person = temp_model.from_map(m['natural_person'])
        if m.get('legal_person') is not None:
            temp_model = LegalPerson()
            self.legal_person = temp_model.from_map(m['legal_person'])
        return self


class ContractNotarySignInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        contract_hash: str = None,
        signatory: str = None,
        timestamp: str = None,
        tx_hash: str = None,
        intiator_name: str = None,
        signator_names: str = None,
        detail_info_file_hash: str = None,
    ):
        # 本阶段存证内容哈希值
        self.content = content
        # 电子合同文件hash，可能一次性签署多个文件，不同文件的hash间用“,”分隔开
        self.contract_hash = contract_hash
        # 签署人ID
        self.signatory = signatory
        # 存证阶段发生时间，UNIX时间戳(毫秒)
        self.timestamp = timestamp
        # 存证凭据，仅在批量核验时需要填写
        self.tx_hash = tx_hash
        # 发起人名称
        self.intiator_name = intiator_name
        # 签署人名称,多个逗号隔开
        self.signator_names = signator_names
        # 详细文件哈希
        self.detail_info_file_hash = detail_info_file_hash

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.contract_hash, 'contract_hash')
        self.validate_required(self.signatory, 'signatory')
        self.validate_required(self.timestamp, 'timestamp')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.contract_hash is not None:
            result['contract_hash'] = self.contract_hash
        if self.signatory is not None:
            result['signatory'] = self.signatory
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.intiator_name is not None:
            result['intiator_name'] = self.intiator_name
        if self.signator_names is not None:
            result['signator_names'] = self.signator_names
        if self.detail_info_file_hash is not None:
            result['detail_info_file_hash'] = self.detail_info_file_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('contract_hash') is not None:
            self.contract_hash = m.get('contract_hash')
        if m.get('signatory') is not None:
            self.signatory = m.get('signatory')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('intiator_name') is not None:
            self.intiator_name = m.get('intiator_name')
        if m.get('signator_names') is not None:
            self.signator_names = m.get('signator_names')
        if m.get('detail_info_file_hash') is not None:
            self.detail_info_file_hash = m.get('detail_info_file_hash')
        return self


class NotaryInfo(TeaModel):
    def __init__(
        self,
        content_hash: str = None,
        cooperation: str = None,
        creation_type: str = None,
        file_name: str = None,
        hash_algorithm: str = None,
        platform: str = None,
        size: int = None,
        tx_hash: str = None,
        transaction_id: str = None,
    ):
        # 存证内容的哈希值，默认采用SHA256算法
        self.content_hash = content_hash
        # 合作人（版权存证函专用），会展示在存证证明中
        self.cooperation = cooperation
        # 作品名称类型（版权存证函使用），会展示在存证证明中
        self.creation_type = creation_type
        # 如果是文件存证，可填写文件名称
        self.file_name = file_name
        # 计算content_hash的哈希算法，目前只支持SHA256
        self.hash_algorithm = hash_algorithm
        # 申请平台名，用于在存证函上显示用名称
        self.platform = platform
        # 文件容量，默认为0
        self.size = size
        # 发起存证成功后，返回的存证凭据
        self.tx_hash = tx_hash
        # 存证事务ID
        self.transaction_id = transaction_id

    def validate(self):
        self.validate_required(self.content_hash, 'content_hash')
        self.validate_required(self.tx_hash, 'tx_hash')
        self.validate_required(self.transaction_id, 'transaction_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_hash is not None:
            result['content_hash'] = self.content_hash
        if self.cooperation is not None:
            result['cooperation'] = self.cooperation
        if self.creation_type is not None:
            result['creation_type'] = self.creation_type
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.hash_algorithm is not None:
            result['hash_algorithm'] = self.hash_algorithm
        if self.platform is not None:
            result['platform'] = self.platform
        if self.size is not None:
            result['size'] = self.size
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.transaction_id is not None:
            result['transaction_id'] = self.transaction_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content_hash') is not None:
            self.content_hash = m.get('content_hash')
        if m.get('cooperation') is not None:
            self.cooperation = m.get('cooperation')
        if m.get('creation_type') is not None:
            self.creation_type = m.get('creation_type')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('hash_algorithm') is not None:
            self.hash_algorithm = m.get('hash_algorithm')
        if m.get('platform') is not None:
            self.platform = m.get('platform')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('transaction_id') is not None:
            self.transaction_id = m.get('transaction_id')
        return self


class JudicialOrgInfo(TeaModel):
    def __init__(
        self,
        org_name: str = None,
        org_cert_num: str = None,
        org_phone: str = None,
        org_email: str = None,
        org_address: str = None,
        residence_address: str = None,
        org_biz_license_info: JudicialFileInfo = None,
        org_legal_person_info: JudicialPersonInfo = None,
        org_signature_manager_person_info: JudicialPersonInfo = None,
        org_bank_info: JudicialBankInfo = None,
    ):
        # 企业名称
        self.org_name = org_name
        # 企业或机构社会统一信用代码
        self.org_cert_num = org_cert_num
        # 企业联系电话
        self.org_phone = org_phone
        # 企业联系邮箱
        self.org_email = org_email
        # 企业通讯地址
        self.org_address = org_address
        # 企业营业执照地址
        self.residence_address = residence_address
        # 企业或机构营业执照信息
        self.org_biz_license_info = org_biz_license_info
        # 企业法人信息
        self.org_legal_person_info = org_legal_person_info
        # 企业或机构签章管理员信息
        self.org_signature_manager_person_info = org_signature_manager_person_info
        # 企业或机构收款银行账户信息
        self.org_bank_info = org_bank_info

    def validate(self):
        self.validate_required(self.org_name, 'org_name')
        self.validate_required(self.org_cert_num, 'org_cert_num')
        self.validate_required(self.org_phone, 'org_phone')
        if self.org_biz_license_info:
            self.org_biz_license_info.validate()
        if self.org_legal_person_info:
            self.org_legal_person_info.validate()
        if self.org_signature_manager_person_info:
            self.org_signature_manager_person_info.validate()
        if self.org_bank_info:
            self.org_bank_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.org_name is not None:
            result['org_name'] = self.org_name
        if self.org_cert_num is not None:
            result['org_cert_num'] = self.org_cert_num
        if self.org_phone is not None:
            result['org_phone'] = self.org_phone
        if self.org_email is not None:
            result['org_email'] = self.org_email
        if self.org_address is not None:
            result['org_address'] = self.org_address
        if self.residence_address is not None:
            result['residence_address'] = self.residence_address
        if self.org_biz_license_info is not None:
            result['org_biz_license_info'] = self.org_biz_license_info.to_map()
        if self.org_legal_person_info is not None:
            result['org_legal_person_info'] = self.org_legal_person_info.to_map()
        if self.org_signature_manager_person_info is not None:
            result['org_signature_manager_person_info'] = self.org_signature_manager_person_info.to_map()
        if self.org_bank_info is not None:
            result['org_bank_info'] = self.org_bank_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('org_name') is not None:
            self.org_name = m.get('org_name')
        if m.get('org_cert_num') is not None:
            self.org_cert_num = m.get('org_cert_num')
        if m.get('org_phone') is not None:
            self.org_phone = m.get('org_phone')
        if m.get('org_email') is not None:
            self.org_email = m.get('org_email')
        if m.get('org_address') is not None:
            self.org_address = m.get('org_address')
        if m.get('residence_address') is not None:
            self.residence_address = m.get('residence_address')
        if m.get('org_biz_license_info') is not None:
            temp_model = JudicialFileInfo()
            self.org_biz_license_info = temp_model.from_map(m['org_biz_license_info'])
        if m.get('org_legal_person_info') is not None:
            temp_model = JudicialPersonInfo()
            self.org_legal_person_info = temp_model.from_map(m['org_legal_person_info'])
        if m.get('org_signature_manager_person_info') is not None:
            temp_model = JudicialPersonInfo()
            self.org_signature_manager_person_info = temp_model.from_map(m['org_signature_manager_person_info'])
        if m.get('org_bank_info') is not None:
            temp_model = JudicialBankInfo()
            self.org_bank_info = temp_model.from_map(m['org_bank_info'])
        return self


class ContractNotaryInfo(TeaModel):
    def __init__(
        self,
        tx_hash: str = None,
        doc_id: str = None,
        content_hash: str = None,
        transaction_id: str = None,
    ):
        # 存证地址
        self.tx_hash = tx_hash
        # 存证相关联的文档ID
        self.doc_id = doc_id
        # 存证的内容哈希值
        self.content_hash = content_hash
        # 存证事务ID
        self.transaction_id = transaction_id

    def validate(self):
        self.validate_required(self.tx_hash, 'tx_hash')
        self.validate_required(self.transaction_id, 'transaction_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.doc_id is not None:
            result['doc_id'] = self.doc_id
        if self.content_hash is not None:
            result['content_hash'] = self.content_hash
        if self.transaction_id is not None:
            result['transaction_id'] = self.transaction_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('doc_id') is not None:
            self.doc_id = m.get('doc_id')
        if m.get('content_hash') is not None:
            self.content_hash = m.get('content_hash')
        if m.get('transaction_id') is not None:
            self.transaction_id = m.get('transaction_id')
        return self


class PersonInfo(TeaModel):
    def __init__(
        self,
        cert_name: str = None,
        cert_no: str = None,
        cert_type: str = None,
    ):
        # 个人证件名称
        self.cert_name = cert_name
        # 个人证件号码
        self.cert_no = cert_no
        # 证件类型, 默认身份证 RESIDENT：居民身份证号，PASSPORT：护照，MILITARY：军官证
        self.cert_type = cert_type

    def validate(self):
        self.validate_required(self.cert_name, 'cert_name')
        self.validate_required(self.cert_no, 'cert_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_name is not None:
            result['cert_name'] = self.cert_name
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cert_name') is not None:
            self.cert_name = m.get('cert_name')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        return self


class SupplierOrderProductInfo(TeaModel):
    def __init__(
        self,
        product_id: str = None,
        product_price: int = None,
        sn_list: List[str] = None,
    ):
        # 商品id
        self.product_id = product_id
        # 商品采购单价，单位：毫厘
        self.product_price = product_price
        # 商品的sn信息
        self.sn_list = sn_list

    def validate(self):
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.product_price, 'product_price')
        self.validate_required(self.sn_list, 'sn_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.product_price is not None:
            result['product_price'] = self.product_price
        if self.sn_list is not None:
            result['sn_list'] = self.sn_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('product_price') is not None:
            self.product_price = m.get('product_price')
        if m.get('sn_list') is not None:
            self.sn_list = m.get('sn_list')
        return self


class ContractDoc(TeaModel):
    def __init__(
        self,
        encryption: int = None,
        file_id: str = None,
        file_name: str = None,
        file_password: str = None,
    ):
        # 上传的电子合同文档是否被加密过，0-未被加密，1-被加密过，默认0
        self.encryption = encryption
        # 电子合同文档的ID
        self.file_id = file_id
        # 电子合同文档名称，默认文件名称
        self.file_name = file_name
        # 电子合同文档密码, 如果encryption值为1, 文档密码不能为空，默认没有密码
        self.file_password = file_password

    def validate(self):
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.encryption is not None:
            result['encryption'] = self.encryption
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.file_password is not None:
            result['file_password'] = self.file_password
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('encryption') is not None:
            self.encryption = m.get('encryption')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('file_password') is not None:
            self.file_password = m.get('file_password')
        return self


class ContractSeal(TeaModel):
    def __init__(
        self,
        alias: str = None,
        create_date: int = None,
        default_flag: bool = None,
        file_key: str = None,
        height: int = None,
        width: int = None,
        seal_id: str = None,
        seal_type: int = None,
        url: str = None,
        seal_biz_type: str = None,
    ):
        # 印章别名
        self.alias = alias
        # 印章创建时间
        self.create_date = create_date
        # 默认印章标识
        self.default_flag = default_flag
        # 印章fileKey
        self.file_key = file_key
        # 印章高度
        self.height = height
        # 印章宽度
        self.width = width
        # 印章id
        self.seal_id = seal_id
        # 印章类型，1-机构模板章，2-个人模板章，3-自定义印章，4-手绘章
        self.seal_type = seal_type
        # 印章下载地址, 有效时间1小时
        self.url = url
        # 印章业务类型，CANCELLATION-作废章，COMMON-其它
        self.seal_biz_type = seal_biz_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['alias'] = self.alias
        if self.create_date is not None:
            result['create_date'] = self.create_date
        if self.default_flag is not None:
            result['default_flag'] = self.default_flag
        if self.file_key is not None:
            result['file_key'] = self.file_key
        if self.height is not None:
            result['height'] = self.height
        if self.width is not None:
            result['width'] = self.width
        if self.seal_id is not None:
            result['seal_id'] = self.seal_id
        if self.seal_type is not None:
            result['seal_type'] = self.seal_type
        if self.url is not None:
            result['url'] = self.url
        if self.seal_biz_type is not None:
            result['seal_biz_type'] = self.seal_biz_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alias') is not None:
            self.alias = m.get('alias')
        if m.get('create_date') is not None:
            self.create_date = m.get('create_date')
        if m.get('default_flag') is not None:
            self.default_flag = m.get('default_flag')
        if m.get('file_key') is not None:
            self.file_key = m.get('file_key')
        if m.get('height') is not None:
            self.height = m.get('height')
        if m.get('width') is not None:
            self.width = m.get('width')
        if m.get('seal_id') is not None:
            self.seal_id = m.get('seal_id')
        if m.get('seal_type') is not None:
            self.seal_type = m.get('seal_type')
        if m.get('url') is not None:
            self.url = m.get('url')
        if m.get('seal_biz_type') is not None:
            self.seal_biz_type = m.get('seal_biz_type')
        return self


class ContractAccountApplication(TeaModel):
    def __init__(
        self,
        email: str = None,
        id_number: str = None,
        id_type: str = None,
        mobile: str = None,
        name: str = None,
        user_id: str = None,
    ):
        # 邮箱地址，默认空
        self.email = email
        # 证件号
        self.id_number = id_number
        # 目前仅支持CRED_PSN_CH_IDCARD，即身份证号码
        self.id_type = id_type
        # 手机号码，默认空
        self.mobile = mobile
        # 姓名
        self.name = name
        # 用户唯一标识，可传入第三方平台的个人用户id等
        self.user_id = user_id

    def validate(self):
        self.validate_required(self.id_number, 'id_number')
        self.validate_required(self.id_type, 'id_type')
        self.validate_required(self.name, 'name')
        self.validate_required(self.user_id, 'user_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.email is not None:
            result['email'] = self.email
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ContractPlatformSignFieldApplication(TeaModel):
    def __init__(
        self,
        file_id: str = None,
        order: int = None,
        seal_id: str = None,
        third_order_no: str = None,
        pos_page: str = None,
        pos_x: str = None,
        pos_y: str = None,
        width: str = None,
        add_sign_time: bool = None,
        sign_type: int = None,
    ):
        # 文件file id
        self.file_id = file_id
        # 签署顺序，默认1,且不小于1，顺序越小越先处理
        self.order = order
        # 印章id， 仅限企业公章，暂不支持指定企业法定代表人印章 ，如不传，则采用账号下的默认印章
        self.seal_id = seal_id
        # 第三方业务流水号id，保证相同签署人、相同签约主体、相同签署顺序的任务，对应的第三方业务流水id唯一，默认空
        self.third_order_no = third_order_no
        # 页码信息，当签署区signType为2时, 页码可以_-_分割, 其他情况只能是数字
        self.pos_page = pos_page
        # x坐标，默认空
        self.pos_x = pos_x
        # y坐标
        self.pos_y = pos_y
        # 签署区宽，默认印章宽度
        self.width = width
        # 是否添加签署时间戳， 默认不添加，默认格式 yyyy-MM-dd HH : mm : ss
        self.add_sign_time = add_sign_time
        # 签署类型， 1-单页签署，2-骑缝签署，默认1
        self.sign_type = sign_type

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.pos_page, 'pos_page')
        self.validate_required(self.pos_y, 'pos_y')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.order is not None:
            result['order'] = self.order
        if self.seal_id is not None:
            result['seal_id'] = self.seal_id
        if self.third_order_no is not None:
            result['third_order_no'] = self.third_order_no
        if self.pos_page is not None:
            result['pos_page'] = self.pos_page
        if self.pos_x is not None:
            result['pos_x'] = self.pos_x
        if self.pos_y is not None:
            result['pos_y'] = self.pos_y
        if self.width is not None:
            result['width'] = self.width
        if self.add_sign_time is not None:
            result['add_sign_time'] = self.add_sign_time
        if self.sign_type is not None:
            result['sign_type'] = self.sign_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('seal_id') is not None:
            self.seal_id = m.get('seal_id')
        if m.get('third_order_no') is not None:
            self.third_order_no = m.get('third_order_no')
        if m.get('pos_page') is not None:
            self.pos_page = m.get('pos_page')
        if m.get('pos_x') is not None:
            self.pos_x = m.get('pos_x')
        if m.get('pos_y') is not None:
            self.pos_y = m.get('pos_y')
        if m.get('width') is not None:
            self.width = m.get('width')
        if m.get('add_sign_time') is not None:
            self.add_sign_time = m.get('add_sign_time')
        if m.get('sign_type') is not None:
            self.sign_type = m.get('sign_type')
        return self


class LeaseNotaryRecord(TeaModel):
    def __init__(
        self,
        phase: str = None,
        tx_hash: str = None,
    ):
        # 存证阶段
        self.phase = phase
        # 交易哈希，存证记录唯一标识
        self.tx_hash = tx_hash

    def validate(self):
        self.validate_required(self.phase, 'phase')
        self.validate_required(self.tx_hash, 'tx_hash')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.phase is not None:
            result['phase'] = self.phase
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('phase') is not None:
            self.phase = m.get('phase')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        return self


class EvidentialElement(TeaModel):
    def __init__(
        self,
        order_info: OrderInfo = None,
        commitment_info: CommitmentInfo = None,
        logistics_info: LogisticsInfo = None,
        performance_info: PerformanceInfo = None,
    ):
        # 订单信息
        self.order_info = order_info
        # 承诺信息
        self.commitment_info = commitment_info
        # 物流信息
        self.logistics_info = logistics_info
        # 履约信息
        self.performance_info = performance_info

    def validate(self):
        self.validate_required(self.order_info, 'order_info')
        if self.order_info:
            self.order_info.validate()
        self.validate_required(self.commitment_info, 'commitment_info')
        if self.commitment_info:
            self.commitment_info.validate()
        self.validate_required(self.logistics_info, 'logistics_info')
        if self.logistics_info:
            self.logistics_info.validate()
        self.validate_required(self.performance_info, 'performance_info')
        if self.performance_info:
            self.performance_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_info is not None:
            result['order_info'] = self.order_info.to_map()
        if self.commitment_info is not None:
            result['commitment_info'] = self.commitment_info.to_map()
        if self.logistics_info is not None:
            result['logistics_info'] = self.logistics_info.to_map()
        if self.performance_info is not None:
            result['performance_info'] = self.performance_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('order_info') is not None:
            temp_model = OrderInfo()
            self.order_info = temp_model.from_map(m['order_info'])
        if m.get('commitment_info') is not None:
            temp_model = CommitmentInfo()
            self.commitment_info = temp_model.from_map(m['commitment_info'])
        if m.get('logistics_info') is not None:
            temp_model = LogisticsInfo()
            self.logistics_info = temp_model.from_map(m['logistics_info'])
        if m.get('performance_info') is not None:
            temp_model = PerformanceInfo()
            self.performance_info = temp_model.from_map(m['performance_info'])
        return self


class ContractHandSignFieldApplication(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        file_id: str = None,
        order: int = None,
        pos_page: str = None,
        pos_x: str = None,
        pos_y: str = None,
        seal_id: str = None,
        sign_date_bean_type: int = None,
        sign_date_font_size: int = None,
        sign_date_format: str = None,
        sign_date_pos_page: int = None,
        sign_date_pos_x: str = None,
        sign_date_pos_y: str = None,
        sign_type: int = None,
        third_order_no: str = None,
        width: str = None,
        seal_ids: List[str] = None,
        sign_field_type: int = None,
    ):
        # 签署操作人个人账号标识，即操作本次签署的个人
        self.account_id = account_id
        # 电子合同文件ID
        self.file_id = file_id
        # 签署区顺序，默认1,且不小于1，顺序越小越先处理
        self.order = order
        # 页码信息：当签署区signType为2时, 页码可以_-_分割, 例如1到15页，填"1-15"； 其他情况只能是数字；不指定xy坐标签署区可不填写
        self.pos_page = pos_page
        # x坐标，页面签章必填，骑缝签章不填写
        self.pos_x = pos_x
        # y坐标
        self.pos_y = pos_y
        # 印章id
        self.seal_id = seal_id
        # 是否需要添加签署日期，0-禁止 1-必须 ，默认0
        self.sign_date_bean_type = sign_date_bean_type
        # 签章日期字体大小,默认12
        self.sign_date_font_size = sign_date_font_size
        # 签章日期格式，yyyy年MM月dd日
        self.sign_date_format = sign_date_format
        # 页码信息，当signDateBeanType为1时，代表签署的印章必须展示签署日期，默认放在印章正下方，签署人可拖拽日期到当前页面的其他位置，如果发起方指定签署位置的同时，需要同时指定日期盖章位置，则需传入日期盖章页码（与印章页码相同），在传入X\Y坐标即可。
        self.sign_date_pos_page = sign_date_pos_page
        # 签章日期x坐标，默认0
        self.sign_date_pos_x = sign_date_pos_x
        # 签章日期y坐标，默认0
        self.sign_date_pos_y = sign_date_pos_y
        # 签署类型，1-单页签署，2-骑缝签署，默认1
        self.sign_type = sign_type
        # 第三方业务流水号id，保证相同签署人、相同签约主体、相同签署顺序的任务，对应的第三方业务流水id唯一，默认空
        self.third_order_no = third_order_no
        # 签署区宽，默认印章宽度
        self.width = width
        # 印章ids，只支持企业用户进行印章ID列表的设置；用于手动签署时，指定企业印章进行展示，实现手动选择印章进行签署。
        self.seal_ids = seal_ids
        # 签署区预设xy坐标类型，0：不指定X/Y坐标 1：指定X/Y坐标 默认：指定X/Y坐标 ; 签署区设置时可以不指定XY坐标，签署方在签署时拖拽确定最终签署区域，支持在页面任何区域拖拽，个人和企业签署用印都支持
        self.sign_field_type = sign_field_type

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.order is not None:
            result['order'] = self.order
        if self.pos_page is not None:
            result['pos_page'] = self.pos_page
        if self.pos_x is not None:
            result['pos_x'] = self.pos_x
        if self.pos_y is not None:
            result['pos_y'] = self.pos_y
        if self.seal_id is not None:
            result['seal_id'] = self.seal_id
        if self.sign_date_bean_type is not None:
            result['sign_date_bean_type'] = self.sign_date_bean_type
        if self.sign_date_font_size is not None:
            result['sign_date_font_size'] = self.sign_date_font_size
        if self.sign_date_format is not None:
            result['sign_date_format'] = self.sign_date_format
        if self.sign_date_pos_page is not None:
            result['sign_date_pos_page'] = self.sign_date_pos_page
        if self.sign_date_pos_x is not None:
            result['sign_date_pos_x'] = self.sign_date_pos_x
        if self.sign_date_pos_y is not None:
            result['sign_date_pos_y'] = self.sign_date_pos_y
        if self.sign_type is not None:
            result['sign_type'] = self.sign_type
        if self.third_order_no is not None:
            result['third_order_no'] = self.third_order_no
        if self.width is not None:
            result['width'] = self.width
        if self.seal_ids is not None:
            result['seal_ids'] = self.seal_ids
        if self.sign_field_type is not None:
            result['sign_field_type'] = self.sign_field_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('pos_page') is not None:
            self.pos_page = m.get('pos_page')
        if m.get('pos_x') is not None:
            self.pos_x = m.get('pos_x')
        if m.get('pos_y') is not None:
            self.pos_y = m.get('pos_y')
        if m.get('seal_id') is not None:
            self.seal_id = m.get('seal_id')
        if m.get('sign_date_bean_type') is not None:
            self.sign_date_bean_type = m.get('sign_date_bean_type')
        if m.get('sign_date_font_size') is not None:
            self.sign_date_font_size = m.get('sign_date_font_size')
        if m.get('sign_date_format') is not None:
            self.sign_date_format = m.get('sign_date_format')
        if m.get('sign_date_pos_page') is not None:
            self.sign_date_pos_page = m.get('sign_date_pos_page')
        if m.get('sign_date_pos_x') is not None:
            self.sign_date_pos_x = m.get('sign_date_pos_x')
        if m.get('sign_date_pos_y') is not None:
            self.sign_date_pos_y = m.get('sign_date_pos_y')
        if m.get('sign_type') is not None:
            self.sign_type = m.get('sign_type')
        if m.get('third_order_no') is not None:
            self.third_order_no = m.get('third_order_no')
        if m.get('width') is not None:
            self.width = m.get('width')
        if m.get('seal_ids') is not None:
            self.seal_ids = m.get('seal_ids')
        if m.get('sign_field_type') is not None:
            self.sign_field_type = m.get('sign_field_type')
        return self


class RefinanceOrderInfoResponse(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        application_id: str = None,
    ):
        # 订单id
        self.order_id = order_id
        # 合约id
        self.application_id = application_id

    def validate(self):
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.application_id, 'application_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.application_id is not None:
            result['application_id'] = self.application_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('application_id') is not None:
            self.application_id = m.get('application_id')
        return self


class SupplierProductInfo(TeaModel):
    def __init__(
        self,
        extra_info: str = None,
        product_id: str = None,
        product_imei_id: str = None,
        product_name: str = None,
        product_number: int = None,
        product_price: int = None,
        supplier_version: str = None,
    ):
        # 产品额外信息
        self.extra_info = extra_info
        # 产品id
        self.product_id = product_id
        # 电子商品唯一标识码
        self.product_imei_id = product_imei_id
        # 产品名称
        self.product_name = product_name
        # 采购产品的个数
        self.product_number = product_number
        # 采购产品的价格，精确到毫厘，如12.34元表示为123400
        self.product_price = product_price
        # 产品版本
        self.supplier_version = supplier_version

    def validate(self):
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.product_imei_id, 'product_imei_id')
        self.validate_required(self.product_name, 'product_name')
        if self.product_name is not None:
            self.validate_max_length(self.product_name, 'product_name', 50)
        self.validate_required(self.product_number, 'product_number')
        self.validate_required(self.product_price, 'product_price')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra_info is not None:
            result['extra_info'] = self.extra_info
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.product_imei_id is not None:
            result['product_imei_id'] = self.product_imei_id
        if self.product_name is not None:
            result['product_name'] = self.product_name
        if self.product_number is not None:
            result['product_number'] = self.product_number
        if self.product_price is not None:
            result['product_price'] = self.product_price
        if self.supplier_version is not None:
            result['supplier_version'] = self.supplier_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('extra_info') is not None:
            self.extra_info = m.get('extra_info')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('product_imei_id') is not None:
            self.product_imei_id = m.get('product_imei_id')
        if m.get('product_name') is not None:
            self.product_name = m.get('product_name')
        if m.get('product_number') is not None:
            self.product_number = m.get('product_number')
        if m.get('product_price') is not None:
            self.product_price = m.get('product_price')
        if m.get('supplier_version') is not None:
            self.supplier_version = m.get('supplier_version')
        return self


class LeaseOrderProductInfo(TeaModel):
    def __init__(
        self,
        product_id: str = None,
        product_version: str = None,
        product_name: str = None,
        product_price: int = None,
        supplier_isv_account: str = None,
    ):
        # 商品编码 长度不可超过50
        self.product_id = product_id
        # 产品版本，每个版本可以对应一个价格 长度不可超过50，版本号未正整数，示例"123"
        self.product_version = product_version
        # 商品名称 长度不可超过50
        self.product_name = product_name
        # 采购价  精确到毫厘，即123400表示12.34元
        self.product_price = product_price
        # 供应商Id，用以做索引 长度不可超过50
        self.supplier_isv_account = supplier_isv_account

    def validate(self):
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.product_version, 'product_version')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.product_price, 'product_price')
        self.validate_required(self.supplier_isv_account, 'supplier_isv_account')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.product_version is not None:
            result['product_version'] = self.product_version
        if self.product_name is not None:
            result['product_name'] = self.product_name
        if self.product_price is not None:
            result['product_price'] = self.product_price
        if self.supplier_isv_account is not None:
            result['supplier_isv_account'] = self.supplier_isv_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('product_version') is not None:
            self.product_version = m.get('product_version')
        if m.get('product_name') is not None:
            self.product_name = m.get('product_name')
        if m.get('product_price') is not None:
            self.product_price = m.get('product_price')
        if m.get('supplier_isv_account') is not None:
            self.supplier_isv_account = m.get('supplier_isv_account')
        return self


class LesseePerson(TeaModel):
    def __init__(
        self,
        name: str = None,
        cert_no: str = None,
        mobile: str = None,
    ):
        # 承租人姓名
        self.name = name
        # 承租人身份证号
        self.cert_no = cert_no
        # 承租人手机号
        self.mobile = mobile

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.cert_no, 'cert_no')
        self.validate_required(self.mobile, 'mobile')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.mobile is not None:
            result['mobile'] = self.mobile
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        return self


class OnestepFlowNotaryInfo(TeaModel):
    def __init__(
        self,
        template_id: str = None,
        flow_name: str = None,
        notary_user: NotaryUser = None,
        phase_notary_list: List[PhaseNotary] = None,
        properties: str = None,
    ):
        # 全流程模板id，需要提前创建好模板才能获取
        self.template_id = template_id
        # 流程名称，同一个租户下同一个模板，建议唯一不重复
        self.flow_name = flow_name
        # 存证关联实体（个人/企业）的身份识别信息
        self.notary_user = notary_user
        # 阶段存证内容列表，根据模板定义传入
        self.phase_notary_list = phase_notary_list
        # 扩展属性
        self.properties = properties

    def validate(self):
        self.validate_required(self.template_id, 'template_id')
        self.validate_required(self.flow_name, 'flow_name')
        self.validate_required(self.notary_user, 'notary_user')
        if self.notary_user:
            self.notary_user.validate()
        self.validate_required(self.phase_notary_list, 'phase_notary_list')
        if self.phase_notary_list:
            for k in self.phase_notary_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['template_id'] = self.template_id
        if self.flow_name is not None:
            result['flow_name'] = self.flow_name
        if self.notary_user is not None:
            result['notary_user'] = self.notary_user.to_map()
        result['phase_notary_list'] = []
        if self.phase_notary_list is not None:
            for k in self.phase_notary_list:
                result['phase_notary_list'].append(k.to_map() if k else None)
        if self.properties is not None:
            result['properties'] = self.properties
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        if m.get('flow_name') is not None:
            self.flow_name = m.get('flow_name')
        if m.get('notary_user') is not None:
            temp_model = NotaryUser()
            self.notary_user = temp_model.from_map(m['notary_user'])
        self.phase_notary_list = []
        if m.get('phase_notary_list') is not None:
            for k in m.get('phase_notary_list'):
                temp_model = PhaseNotary()
                self.phase_notary_list.append(temp_model.from_map(k))
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        return self


class ContractCreatorApplication(TeaModel):
    def __init__(
        self,
        email: str = None,
        id_number: str = None,
        id_type: str = None,
        mobile: str = None,
        name: str = None,
        creator_id: str = None,
    ):
        # 邮箱地址
        self.email = email
        # 证件号
        self.id_number = id_number
        # 证件类型
        self.id_type = id_type
        # 手机号码
        self.mobile = mobile
        # 姓名
        self.name = name
        # 创建人ID
        self.creator_id = creator_id

    def validate(self):
        self.validate_required(self.id_number, 'id_number')
        self.validate_required(self.id_type, 'id_type')
        self.validate_required(self.name, 'name')
        self.validate_required(self.creator_id, 'creator_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.email is not None:
            result['email'] = self.email
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.creator_id is not None:
            result['creator_id'] = self.creator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('creator_id') is not None:
            self.creator_id = m.get('creator_id')
        return self


class ProductInfo(TeaModel):
    def __init__(
        self,
        need_did: bool = None,
        product_brand: str = None,
        product_id: str = None,
        product_imei_id: str = None,
        product_model: str = None,
        product_name: str = None,
        product_number: int = None,
        product_price: int = None,
        supplier_id: str = None,
        supplier_version: str = None,
        extra_info: str = None,
    ):
        # 是否需要创建did
        self.need_did = need_did
        # 产品品牌，长度不超过50
        self.product_brand = product_brand
        # 产品Id，长度不超过50
        self.product_id = product_id
        # 唯一标识码，imeiID，长度不超过50
        self.product_imei_id = product_imei_id
        # 产品规格型号，长度不超过255
        self.product_model = product_model
        # 产品名称，长度不超过50
        self.product_name = product_name
        # 产品数量
        self.product_number = product_number
        # 产品采购含税价 精确到毫厘，即123400表示12.34元
        self.product_price = product_price
        # 供应商id
        self.supplier_id = supplier_id
        # 供应商对应的产品版本，每个版本可以对应一个价格
        self.supplier_version = supplier_version
        # 额外字段
        self.extra_info = extra_info

    def validate(self):
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.product_number, 'product_number')
        self.validate_required(self.product_price, 'product_price')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.need_did is not None:
            result['need_did'] = self.need_did
        if self.product_brand is not None:
            result['product_brand'] = self.product_brand
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.product_imei_id is not None:
            result['product_imei_id'] = self.product_imei_id
        if self.product_model is not None:
            result['product_model'] = self.product_model
        if self.product_name is not None:
            result['product_name'] = self.product_name
        if self.product_number is not None:
            result['product_number'] = self.product_number
        if self.product_price is not None:
            result['product_price'] = self.product_price
        if self.supplier_id is not None:
            result['supplier_id'] = self.supplier_id
        if self.supplier_version is not None:
            result['supplier_version'] = self.supplier_version
        if self.extra_info is not None:
            result['extra_info'] = self.extra_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('need_did') is not None:
            self.need_did = m.get('need_did')
        if m.get('product_brand') is not None:
            self.product_brand = m.get('product_brand')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('product_imei_id') is not None:
            self.product_imei_id = m.get('product_imei_id')
        if m.get('product_model') is not None:
            self.product_model = m.get('product_model')
        if m.get('product_name') is not None:
            self.product_name = m.get('product_name')
        if m.get('product_number') is not None:
            self.product_number = m.get('product_number')
        if m.get('product_price') is not None:
            self.product_price = m.get('product_price')
        if m.get('supplier_id') is not None:
            self.supplier_id = m.get('supplier_id')
        if m.get('supplier_version') is not None:
            self.supplier_version = m.get('supplier_version')
        if m.get('extra_info') is not None:
            self.extra_info = m.get('extra_info')
        return self


class NotaryFlowDetailQueryReq(TeaModel):
    def __init__(
        self,
        template_id: str = None,
        flow_id: str = None,
        chain_pack_tx_hash: str = None,
        authcode: str = None,
    ):
        # 全流程存证模板ID
        self.template_id = template_id
        # 全流程存证流程id
        self.flow_id = flow_id
        # 链上证据包对应的链上交易Hash
        self.chain_pack_tx_hash = chain_pack_tx_hash
        # 链上证据包授权码
        self.authcode = authcode

    def validate(self):
        self.validate_required(self.template_id, 'template_id')
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.chain_pack_tx_hash, 'chain_pack_tx_hash')
        self.validate_required(self.authcode, 'authcode')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['template_id'] = self.template_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.chain_pack_tx_hash is not None:
            result['chain_pack_tx_hash'] = self.chain_pack_tx_hash
        if self.authcode is not None:
            result['authcode'] = self.authcode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('chain_pack_tx_hash') is not None:
            self.chain_pack_tx_hash = m.get('chain_pack_tx_hash')
        if m.get('authcode') is not None:
            self.authcode = m.get('authcode')
        return self


class PaymentDetail(TeaModel):
    def __init__(
        self,
        biz_trade_id: str = None,
        period: int = None,
        pay_money: int = None,
        pay_date: str = None,
    ):
        # 业务自定义扣款id，长度不能超过64
        self.biz_trade_id = biz_trade_id
        # 扣款期数
        self.period = period
        # 支付金额，单位：分
        self.pay_money = pay_money
        # 计划扣款时间，格式"yyyy-MM-dd HH:mm:ss"
        self.pay_date = pay_date

    def validate(self):
        self.validate_required(self.biz_trade_id, 'biz_trade_id')
        self.validate_required(self.period, 'period')
        self.validate_required(self.pay_money, 'pay_money')
        self.validate_required(self.pay_date, 'pay_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_trade_id is not None:
            result['biz_trade_id'] = self.biz_trade_id
        if self.period is not None:
            result['period'] = self.period
        if self.pay_money is not None:
            result['pay_money'] = self.pay_money
        if self.pay_date is not None:
            result['pay_date'] = self.pay_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('biz_trade_id') is not None:
            self.biz_trade_id = m.get('biz_trade_id')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('pay_money') is not None:
            self.pay_money = m.get('pay_money')
        if m.get('pay_date') is not None:
            self.pay_date = m.get('pay_date')
        return self


class ContractNotaryDeductCancelInfo(TeaModel):
    def __init__(
        self,
        payer_id: str = None,
        cancel_status: bool = None,
        timestamp: str = None,
        orders: str = None,
    ):
        # 付款方的区块链合同签署账号
        self.payer_id = payer_id
        # 是否取消成功
        self.cancel_status = cancel_status
        # 取消操作发起时间
        self.timestamp = timestamp
        # 代扣订单号，多个订单号之间以‘,’隔开
        self.orders = orders

    def validate(self):
        self.validate_required(self.payer_id, 'payer_id')
        self.validate_required(self.cancel_status, 'cancel_status')
        self.validate_required(self.timestamp, 'timestamp')
        self.validate_required(self.orders, 'orders')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.payer_id is not None:
            result['payer_id'] = self.payer_id
        if self.cancel_status is not None:
            result['cancel_status'] = self.cancel_status
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.orders is not None:
            result['orders'] = self.orders
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('payer_id') is not None:
            self.payer_id = m.get('payer_id')
        if m.get('cancel_status') is not None:
            self.cancel_status = m.get('cancel_status')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('orders') is not None:
            self.orders = m.get('orders')
        return self


class ContractPlatformAccountApplication(TeaModel):
    def __init__(
        self,
        email: str = None,
        id_number: str = None,
        id_type: str = None,
        mobile: str = None,
        name: str = None,
        user_id: str = None,
    ):
        # 邮箱地址
        self.email = email
        # 证件号
        self.id_number = id_number
        # 证件类型
        self.id_type = id_type
        # 手机号码
        self.mobile = mobile
        # 姓名
        self.name = name
        # 用户唯一标识，可传入第三方平台的个人用户id等
        self.user_id = user_id

    def validate(self):
        self.validate_required(self.id_number, 'id_number')
        self.validate_required(self.id_type, 'id_type')
        self.validate_required(self.name, 'name')
        self.validate_required(self.user_id, 'user_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.email is not None:
            result['email'] = self.email
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class BankAccountInfo(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        account_bank: str = None,
        account_number: str = None,
        account_phone: str = None,
    ):
        # 开户名称
        self.account_name = account_name
        # 开户行
        self.account_bank = account_bank
        # 开户账号
        self.account_number = account_number
        # 联系电话
        self.account_phone = account_phone

    def validate(self):
        self.validate_required(self.account_name, 'account_name')
        self.validate_required(self.account_bank, 'account_bank')
        self.validate_required(self.account_number, 'account_number')
        self.validate_required(self.account_phone, 'account_phone')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['account_name'] = self.account_name
        if self.account_bank is not None:
            result['account_bank'] = self.account_bank
        if self.account_number is not None:
            result['account_number'] = self.account_number
        if self.account_phone is not None:
            result['account_phone'] = self.account_phone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('account_name') is not None:
            self.account_name = m.get('account_name')
        if m.get('account_bank') is not None:
            self.account_bank = m.get('account_bank')
        if m.get('account_number') is not None:
            self.account_number = m.get('account_number')
        if m.get('account_phone') is not None:
            self.account_phone = m.get('account_phone')
        return self


class ContractPlatformApplication(TeaModel):
    def __init__(
        self,
        id_number: str = None,
        id_type: str = None,
        org_legal_name: str = None,
        org_legal_id_number: str = None,
        name: str = None,
        platform_id: str = None,
    ):
        # 证件号
        self.id_number = id_number
        # 证件类型
        self.id_type = id_type
        # 企业法人名称
        self.org_legal_name = org_legal_name
        # 企业法人证件号
        self.org_legal_id_number = org_legal_id_number
        # 机构名称
        self.name = name
        # 平台方账号id
        self.platform_id = platform_id

    def validate(self):
        self.validate_required(self.id_number, 'id_number')
        self.validate_required(self.id_type, 'id_type')
        self.validate_required(self.name, 'name')
        self.validate_required(self.platform_id, 'platform_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.org_legal_name is not None:
            result['org_legal_name'] = self.org_legal_name
        if self.org_legal_id_number is not None:
            result['org_legal_id_number'] = self.org_legal_id_number
        if self.name is not None:
            result['name'] = self.name
        if self.platform_id is not None:
            result['platform_id'] = self.platform_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('org_legal_name') is not None:
            self.org_legal_name = m.get('org_legal_name')
        if m.get('org_legal_id_number') is not None:
            self.org_legal_id_number = m.get('org_legal_id_number')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('platform_id') is not None:
            self.platform_id = m.get('platform_id')
        return self


class LeaseRentalInfo(TeaModel):
    def __init__(
        self,
        term: int = None,
        rental_return_state: int = None,
        rental_money: int = None,
        return_time: str = None,
        return_way: int = None,
        return_voucher_type: int = None,
        return_voucher_serial: str = None,
        remain_term: int = None,
    ):
        # 租期编号
        self.term = term
        # 租金归还状态，1.足额归还2.部分归还3.未归还
        self.rental_return_state = rental_return_state
        # 租金归还金额,精确到毫厘，即123400表示12.34元
        self.rental_money = rental_money
        # 归还时间
        self.return_time = return_time
        # 归还方式，1.预授权代扣2.支付宝代扣3.主动还款4.其他，5网商直付通代扣
        self.return_way = return_way
        # 还款凭证类型，1.支付宝2.平台代收（客户主动还款）3.其他
        self.return_voucher_type = return_voucher_type
        # 还款凭证编号，不超过128字符，支付宝流水号
        self.return_voucher_serial = return_voucher_serial
        # 剩余归还期数
        self.remain_term = remain_term

    def validate(self):
        self.validate_required(self.term, 'term')
        self.validate_required(self.rental_return_state, 'rental_return_state')
        self.validate_required(self.rental_money, 'rental_money')
        self.validate_required(self.return_time, 'return_time')
        self.validate_required(self.return_way, 'return_way')
        self.validate_required(self.return_voucher_type, 'return_voucher_type')
        self.validate_required(self.return_voucher_serial, 'return_voucher_serial')
        self.validate_required(self.remain_term, 'remain_term')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.term is not None:
            result['term'] = self.term
        if self.rental_return_state is not None:
            result['rental_return_state'] = self.rental_return_state
        if self.rental_money is not None:
            result['rental_money'] = self.rental_money
        if self.return_time is not None:
            result['return_time'] = self.return_time
        if self.return_way is not None:
            result['return_way'] = self.return_way
        if self.return_voucher_type is not None:
            result['return_voucher_type'] = self.return_voucher_type
        if self.return_voucher_serial is not None:
            result['return_voucher_serial'] = self.return_voucher_serial
        if self.remain_term is not None:
            result['remain_term'] = self.remain_term
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('term') is not None:
            self.term = m.get('term')
        if m.get('rental_return_state') is not None:
            self.rental_return_state = m.get('rental_return_state')
        if m.get('rental_money') is not None:
            self.rental_money = m.get('rental_money')
        if m.get('return_time') is not None:
            self.return_time = m.get('return_time')
        if m.get('return_way') is not None:
            self.return_way = m.get('return_way')
        if m.get('return_voucher_type') is not None:
            self.return_voucher_type = m.get('return_voucher_type')
        if m.get('return_voucher_serial') is not None:
            self.return_voucher_serial = m.get('return_voucher_serial')
        if m.get('remain_term') is not None:
            self.remain_term = m.get('remain_term')
        return self


class NotaryCheckResult(TeaModel):
    def __init__(
        self,
        block_height: int = None,
        error_code: int = None,
        error_message: str = None,
        notary_time: str = None,
        notary_type: str = None,
        result: bool = None,
        transaction_id: str = None,
        tx_hash: str = None,
        block_hash: str = None,
        phase: str = None,
    ):
        # 存证所在区块高度
        self.block_height = block_height
        # 核验结果错误码
        self.error_code = error_code
        # 错误信息
        self.error_message = error_message
        # 存证时间
        self.notary_time = notary_time
        # 存证类型
        self.notary_type = notary_type
        # 核验是否成功
        self.result = result
        # 存证事务ID
        self.transaction_id = transaction_id
        # 交易哈希
        self.tx_hash = tx_hash
        # 区块哈希
        self.block_hash = block_hash
        # 存证阶段
        self.phase = phase

    def validate(self):
        self.validate_required(self.block_height, 'block_height')
        if self.block_height is not None:
            self.validate_minimum(self.block_height, 'block_height', 0)
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.notary_time, 'notary_time')
        if self.notary_time is not None:
            self.validate_pattern(self.notary_time, 'notary_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.notary_type, 'notary_type')
        self.validate_required(self.result, 'result')
        self.validate_required(self.transaction_id, 'transaction_id')
        self.validate_required(self.tx_hash, 'tx_hash')
        self.validate_required(self.block_hash, 'block_hash')
        self.validate_required(self.phase, 'phase')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_height is not None:
            result['block_height'] = self.block_height
        if self.error_code is not None:
            result['error_code'] = self.error_code
        if self.error_message is not None:
            result['error_message'] = self.error_message
        if self.notary_time is not None:
            result['notary_time'] = self.notary_time
        if self.notary_type is not None:
            result['notary_type'] = self.notary_type
        if self.result is not None:
            result['result'] = self.result
        if self.transaction_id is not None:
            result['transaction_id'] = self.transaction_id
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.block_hash is not None:
            result['block_hash'] = self.block_hash
        if self.phase is not None:
            result['phase'] = self.phase
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('block_height') is not None:
            self.block_height = m.get('block_height')
        if m.get('error_code') is not None:
            self.error_code = m.get('error_code')
        if m.get('error_message') is not None:
            self.error_message = m.get('error_message')
        if m.get('notary_time') is not None:
            self.notary_time = m.get('notary_time')
        if m.get('notary_type') is not None:
            self.notary_type = m.get('notary_type')
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('transaction_id') is not None:
            self.transaction_id = m.get('transaction_id')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('block_hash') is not None:
            self.block_hash = m.get('block_hash')
        if m.get('phase') is not None:
            self.phase = m.get('phase')
        return self


class LeaseRepaymentInfo(TeaModel):
    def __init__(
        self,
        repayment_unique_id: str = None,
        return_index: str = None,
        return_time: str = None,
        return_money: int = None,
        return_status: int = None,
        return_description: str = None,
        source: int = None,
        remain_return_term: int = None,
        remain_return_money: int = None,
        overdue_status: int = None,
        overdue_rate: int = None,
        overdue_day: int = None,
        overdue_money: int = None,
    ):
        # 融资租赁还款流水
        self.repayment_unique_id = repayment_unique_id
        # 还款批次
        self.return_index = return_index
        # 还款日期
        self.return_time = return_time
        # 还款总额,本金+利息，精确到毫厘，即123400表示12.34元
        self.return_money = return_money
        # 还款结果状态,1.成功 2.失败
        self.return_status = return_status
        # 还款结果简要描述,长度不超过256
        self.return_description = return_description
        # 还款来源,1.共管账号，2.网商清分
        self.source = source
        # 剩余应还期数
        self.remain_return_term = remain_return_term
        # 本期剩余应还金额，精确到毫厘，即123400表示12.34元
        self.remain_return_money = remain_return_money
        # 逾期状态,0为未逾期，1表示逾期
        self.overdue_status = overdue_status
        # 逾期利率（日利率）,精确到小数点后四位 12.34% 表示为1234
        self.overdue_rate = overdue_rate
        # 逾期天数,支用到期日开始计算
        self.overdue_day = overdue_day
        # 逾期应还款总额,本金+利息+逾期利息,精确到毫厘，即123400表示12.34元
        self.overdue_money = overdue_money

    def validate(self):
        self.validate_required(self.repayment_unique_id, 'repayment_unique_id')
        self.validate_required(self.return_index, 'return_index')
        self.validate_required(self.return_time, 'return_time')
        self.validate_required(self.return_money, 'return_money')
        self.validate_required(self.return_status, 'return_status')
        self.validate_required(self.return_description, 'return_description')
        self.validate_required(self.source, 'source')
        self.validate_required(self.remain_return_term, 'remain_return_term')
        self.validate_required(self.remain_return_money, 'remain_return_money')
        self.validate_required(self.overdue_status, 'overdue_status')
        self.validate_required(self.overdue_rate, 'overdue_rate')
        self.validate_required(self.overdue_day, 'overdue_day')
        self.validate_required(self.overdue_money, 'overdue_money')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.repayment_unique_id is not None:
            result['repayment_unique_id'] = self.repayment_unique_id
        if self.return_index is not None:
            result['return_index'] = self.return_index
        if self.return_time is not None:
            result['return_time'] = self.return_time
        if self.return_money is not None:
            result['return_money'] = self.return_money
        if self.return_status is not None:
            result['return_status'] = self.return_status
        if self.return_description is not None:
            result['return_description'] = self.return_description
        if self.source is not None:
            result['source'] = self.source
        if self.remain_return_term is not None:
            result['remain_return_term'] = self.remain_return_term
        if self.remain_return_money is not None:
            result['remain_return_money'] = self.remain_return_money
        if self.overdue_status is not None:
            result['overdue_status'] = self.overdue_status
        if self.overdue_rate is not None:
            result['overdue_rate'] = self.overdue_rate
        if self.overdue_day is not None:
            result['overdue_day'] = self.overdue_day
        if self.overdue_money is not None:
            result['overdue_money'] = self.overdue_money
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('repayment_unique_id') is not None:
            self.repayment_unique_id = m.get('repayment_unique_id')
        if m.get('return_index') is not None:
            self.return_index = m.get('return_index')
        if m.get('return_time') is not None:
            self.return_time = m.get('return_time')
        if m.get('return_money') is not None:
            self.return_money = m.get('return_money')
        if m.get('return_status') is not None:
            self.return_status = m.get('return_status')
        if m.get('return_description') is not None:
            self.return_description = m.get('return_description')
        if m.get('source') is not None:
            self.source = m.get('source')
        if m.get('remain_return_term') is not None:
            self.remain_return_term = m.get('remain_return_term')
        if m.get('remain_return_money') is not None:
            self.remain_return_money = m.get('remain_return_money')
        if m.get('overdue_status') is not None:
            self.overdue_status = m.get('overdue_status')
        if m.get('overdue_rate') is not None:
            self.overdue_rate = m.get('overdue_rate')
        if m.get('overdue_day') is not None:
            self.overdue_day = m.get('overdue_day')
        if m.get('overdue_money') is not None:
            self.overdue_money = m.get('overdue_money')
        return self


class StubExtraInfo(TeaModel):
    def __init__(
        self,
        ticket_vision: str = None,
    ):
        # 票面视觉
        self.ticket_vision = ticket_vision

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ticket_vision is not None:
            result['ticket_vision'] = self.ticket_vision
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ticket_vision') is not None:
            self.ticket_vision = m.get('ticket_vision')
        return self


class ContractTextSignVerifySignInfo(TeaModel):
    def __init__(
        self,
        signature: ContractTextSignVerifySignatureInfo = None,
        cert: ContractTextSignVerifyCertInfo = None,
    ):
        # 签名信息
        self.signature = signature
        # 证书信息
        self.cert = cert

    def validate(self):
        if self.signature:
            self.signature.validate()
        if self.cert:
            self.cert.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.signature is not None:
            result['signature'] = self.signature.to_map()
        if self.cert is not None:
            result['cert'] = self.cert.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('signature') is not None:
            temp_model = ContractTextSignVerifySignatureInfo()
            self.signature = temp_model.from_map(m['signature'])
        if m.get('cert') is not None:
            temp_model = ContractTextSignVerifyCertInfo()
            self.cert = temp_model.from_map(m['cert'])
        return self


class LeasePromiseInfo(TeaModel):
    def __init__(
        self,
        term: int = None,
        pay_money: int = None,
        pay_date: str = None,
    ):
        # 租期index
        self.term = term
        # 应还款金额
        self.pay_money = pay_money
        # 应还款时间
        self.pay_date = pay_date

    def validate(self):
        self.validate_required(self.term, 'term')
        self.validate_required(self.pay_money, 'pay_money')
        self.validate_required(self.pay_date, 'pay_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.term is not None:
            result['term'] = self.term
        if self.pay_money is not None:
            result['pay_money'] = self.pay_money
        if self.pay_date is not None:
            result['pay_date'] = self.pay_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('term') is not None:
            self.term = m.get('term')
        if m.get('pay_money') is not None:
            self.pay_money = m.get('pay_money')
        if m.get('pay_date') is not None:
            self.pay_date = m.get('pay_date')
        return self


class ContractUserAccountApplication(TeaModel):
    def __init__(
        self,
        email: str = None,
        id_number: str = None,
        id_type: str = None,
        mobile: str = None,
        name: str = None,
        user_id: str = None,
    ):
        # 邮箱地址，默认不变
        self.email = email
        # 证件号，该字段只有为空才允许修改
        self.id_number = id_number
        # 证件类型，默认为身份证
        self.id_type = id_type
        # 手机号码，默认不变
        self.mobile = mobile
        # 姓名，默认不变
        self.name = name
        # 用户/经办人账号id
        self.user_id = user_id

    def validate(self):
        self.validate_required(self.user_id, 'user_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.email is not None:
            result['email'] = self.email
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ContractCheckResult(TeaModel):
    def __init__(
        self,
        tx_hash: str = None,
        order_id: str = None,
        content_base_64: str = None,
        block_number: int = None,
        gas_used: int = None,
        log_base_64: str = None,
    ):
        # 交易hash
        self.tx_hash = tx_hash
        # 订单id
        self.order_id = order_id
        # 合约执行结果，Base64编码后的
        self.content_base_64 = content_base_64
        # 块高
        self.block_number = block_number
        # 消耗gas量
        self.gas_used = gas_used
        # log信息
        self.log_base_64 = log_base_64

    def validate(self):
        self.validate_required(self.tx_hash, 'tx_hash')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.content_base_64 is not None:
            result['content_base64'] = self.content_base_64
        if self.block_number is not None:
            result['block_number'] = self.block_number
        if self.gas_used is not None:
            result['gas_used'] = self.gas_used
        if self.log_base_64 is not None:
            result['log_base64'] = self.log_base_64
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('content_base64') is not None:
            self.content_base_64 = m.get('content_base64')
        if m.get('block_number') is not None:
            self.block_number = m.get('block_number')
        if m.get('gas_used') is not None:
            self.gas_used = m.get('gas_used')
        if m.get('log_base64') is not None:
            self.log_base_64 = m.get('log_base64')
        return self


class CompanyTwoMetaInfo(TeaModel):
    def __init__(
        self,
        cert_name: str = None,
        cert_no: str = None,
        cert_type: str = None,
    ):
        # 企业证件名称
        self.cert_name = cert_name
        # 企业证件号码
        self.cert_no = cert_no
        # 证件类型, 默认社会统一信用代码  NATIONAL_LEGAL_MERGE:统一社会信用代码，NATIONAL_LEGAL：营业执照号码
        self.cert_type = cert_type

    def validate(self):
        self.validate_required(self.cert_name, 'cert_name')
        self.validate_required(self.cert_no, 'cert_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_name is not None:
            result['cert_name'] = self.cert_name
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cert_name') is not None:
            self.cert_name = m.get('cert_name')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        return self


class ContractFlowSigner(TeaModel):
    def __init__(
        self,
        sign_order: int = None,
        sign_status: int = None,
        signer_account_id: str = None,
        signer_name: str = None,
        signer_real_name: bool = None,
        signer_authorized_account_id: str = None,
        signer_authorized_account_name: str = None,
        signer_authorized_account_real_name: bool = None,
        signer_authorized_account_type: int = None,
        third_order_no: str = None,
    ):
        # 签署顺序
        self.sign_order = sign_order
        # 签署状态, 0-待签, 1-未签, 2-已签 3-待审批 4-拒签
        self.sign_status = sign_status
        # 签署人账号id
        self.signer_account_id = signer_account_id
        # 签署人名称
        self.signer_name = signer_name
        # 签署人是否已实名
        self.signer_real_name = signer_real_name
        # 签约主体的账号id（个人/企业）；如签署人本签署，则返回签署人账号id；如签署人代机构签署，则返回机构账号id
        self.signer_authorized_account_id = signer_authorized_account_id
        # 签约主体名称
        self.signer_authorized_account_name = signer_authorized_account_name
        # 签署主体是否已实名
        self.signer_authorized_account_real_name = signer_authorized_account_real_name
        # 签署主体类型, 0-个人, 1-机构
        self.signer_authorized_account_type = signer_authorized_account_type
        # 本次签署任务对应指定的第三方业务流水号id，当存在多个第三方业务流水号id时，返回多个，并逗号隔开
        self.third_order_no = third_order_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sign_order is not None:
            result['sign_order'] = self.sign_order
        if self.sign_status is not None:
            result['sign_status'] = self.sign_status
        if self.signer_account_id is not None:
            result['signer_account_id'] = self.signer_account_id
        if self.signer_name is not None:
            result['signer_name'] = self.signer_name
        if self.signer_real_name is not None:
            result['signer_real_name'] = self.signer_real_name
        if self.signer_authorized_account_id is not None:
            result['signer_authorized_account_id'] = self.signer_authorized_account_id
        if self.signer_authorized_account_name is not None:
            result['signer_authorized_account_name'] = self.signer_authorized_account_name
        if self.signer_authorized_account_real_name is not None:
            result['signer_authorized_account_real_name'] = self.signer_authorized_account_real_name
        if self.signer_authorized_account_type is not None:
            result['signer_authorized_account_type'] = self.signer_authorized_account_type
        if self.third_order_no is not None:
            result['third_order_no'] = self.third_order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sign_order') is not None:
            self.sign_order = m.get('sign_order')
        if m.get('sign_status') is not None:
            self.sign_status = m.get('sign_status')
        if m.get('signer_account_id') is not None:
            self.signer_account_id = m.get('signer_account_id')
        if m.get('signer_name') is not None:
            self.signer_name = m.get('signer_name')
        if m.get('signer_real_name') is not None:
            self.signer_real_name = m.get('signer_real_name')
        if m.get('signer_authorized_account_id') is not None:
            self.signer_authorized_account_id = m.get('signer_authorized_account_id')
        if m.get('signer_authorized_account_name') is not None:
            self.signer_authorized_account_name = m.get('signer_authorized_account_name')
        if m.get('signer_authorized_account_real_name') is not None:
            self.signer_authorized_account_real_name = m.get('signer_authorized_account_real_name')
        if m.get('signer_authorized_account_type') is not None:
            self.signer_authorized_account_type = m.get('signer_authorized_account_type')
        if m.get('third_order_no') is not None:
            self.third_order_no = m.get('third_order_no')
        return self


class RepaymentOrderRequest(TeaModel):
    def __init__(
        self,
        pay_date: int = None,
        pay_money: int = None,
        trigger_immediately: int = None,
    ):
        # 代扣触发时间，精确到毫秒
        # java.lang.System#currentTimeMillis()
        self.pay_date = pay_date
        # 代扣金额，整数 精确到分
        self.pay_money = pay_money
        # 是否用户签署成功后立即触发第一期代扣
        self.trigger_immediately = trigger_immediately

    def validate(self):
        self.validate_required(self.pay_date, 'pay_date')
        self.validate_required(self.pay_money, 'pay_money')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pay_date is not None:
            result['pay_date'] = self.pay_date
        if self.pay_money is not None:
            result['pay_money'] = self.pay_money
        if self.trigger_immediately is not None:
            result['trigger_immediately'] = self.trigger_immediately
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pay_date') is not None:
            self.pay_date = m.get('pay_date')
        if m.get('pay_money') is not None:
            self.pay_money = m.get('pay_money')
        if m.get('trigger_immediately') is not None:
            self.trigger_immediately = m.get('trigger_immediately')
        return self


class OneStepSignField(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        file_id: str = None,
        order: int = None,
        pos_page: str = None,
        pos_x: str = None,
        pos_y: str = None,
        seal_id: str = None,
        sign_date_bean_type: int = None,
        sign_date_font_size: int = None,
        sign_date_format: str = None,
        sign_date_pos_page: int = None,
        sign_date_pos_x: str = None,
        sign_date_pos_y: str = None,
        sign_type: int = None,
        third_order_no: str = None,
        width: str = None,
        auto_execute: bool = None,
    ):
        # 签署操作人个人账号标识，即操作本次签署的个人
        self.account_id = account_id
        # 电子合同文件ID
        self.file_id = file_id
        # 签署区顺序，默认1,且不小于1，顺序越小越先处理
        self.order = order
        # 页码信息：当签署区signType为2时, 页码可以_-_分割, 例如1到15页，填"1-15"； 其他情况只能是数字；不指定xy坐标签署区可不填写
        self.pos_page = pos_page
        # x坐标
        self.pos_x = pos_x
        # y坐标
        self.pos_y = pos_y
        # 印章id
        self.seal_id = seal_id
        # 是否需要添加签署日期，0-禁止 1-必须 2-不限制，默认0
        self.sign_date_bean_type = sign_date_bean_type
        # 签章日期字体大小,默认12
        self.sign_date_font_size = sign_date_font_size
        # 签章日期格式，yyyy年MM月dd日
        self.sign_date_format = sign_date_format
        # 页码信息，当signDateBeanType为1时，代表签署的印章必须展示签署日期，默认放在印章正下方，签署人可拖拽日期到当前页面的其他位置，如果发起方指定签署位置的同时，需要同时指定日期盖章位置，则需传入日期盖章页码（与印章页码相同），在传入X\Y坐标即可。
        self.sign_date_pos_page = sign_date_pos_page
        # 签章日期x坐标，默认0
        self.sign_date_pos_x = sign_date_pos_x
        # 签章日期y坐标，默认0
        self.sign_date_pos_y = sign_date_pos_y
        # 签署类型，1-单页签署，2-骑缝签署，默认1
        self.sign_type = sign_type
        # 第三方业务流水号id，保证相同签署人、相同签约主体、相同签署顺序的任务，对应的第三方业务流水id唯一，默认空
        self.third_order_no = third_order_no
        # 签署区宽，默认印章宽度
        self.width = width
        # 是否自动执行签署，默认false，false-手动签署，true-自动签署
        self.auto_execute = auto_execute

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.order is not None:
            result['order'] = self.order
        if self.pos_page is not None:
            result['pos_page'] = self.pos_page
        if self.pos_x is not None:
            result['pos_x'] = self.pos_x
        if self.pos_y is not None:
            result['pos_y'] = self.pos_y
        if self.seal_id is not None:
            result['seal_id'] = self.seal_id
        if self.sign_date_bean_type is not None:
            result['sign_date_bean_type'] = self.sign_date_bean_type
        if self.sign_date_font_size is not None:
            result['sign_date_font_size'] = self.sign_date_font_size
        if self.sign_date_format is not None:
            result['sign_date_format'] = self.sign_date_format
        if self.sign_date_pos_page is not None:
            result['sign_date_pos_page'] = self.sign_date_pos_page
        if self.sign_date_pos_x is not None:
            result['sign_date_pos_x'] = self.sign_date_pos_x
        if self.sign_date_pos_y is not None:
            result['sign_date_pos_y'] = self.sign_date_pos_y
        if self.sign_type is not None:
            result['sign_type'] = self.sign_type
        if self.third_order_no is not None:
            result['third_order_no'] = self.third_order_no
        if self.width is not None:
            result['width'] = self.width
        if self.auto_execute is not None:
            result['auto_execute'] = self.auto_execute
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('pos_page') is not None:
            self.pos_page = m.get('pos_page')
        if m.get('pos_x') is not None:
            self.pos_x = m.get('pos_x')
        if m.get('pos_y') is not None:
            self.pos_y = m.get('pos_y')
        if m.get('seal_id') is not None:
            self.seal_id = m.get('seal_id')
        if m.get('sign_date_bean_type') is not None:
            self.sign_date_bean_type = m.get('sign_date_bean_type')
        if m.get('sign_date_font_size') is not None:
            self.sign_date_font_size = m.get('sign_date_font_size')
        if m.get('sign_date_format') is not None:
            self.sign_date_format = m.get('sign_date_format')
        if m.get('sign_date_pos_page') is not None:
            self.sign_date_pos_page = m.get('sign_date_pos_page')
        if m.get('sign_date_pos_x') is not None:
            self.sign_date_pos_x = m.get('sign_date_pos_x')
        if m.get('sign_date_pos_y') is not None:
            self.sign_date_pos_y = m.get('sign_date_pos_y')
        if m.get('sign_type') is not None:
            self.sign_type = m.get('sign_type')
        if m.get('third_order_no') is not None:
            self.third_order_no = m.get('third_order_no')
        if m.get('width') is not None:
            self.width = m.get('width')
        if m.get('auto_execute') is not None:
            self.auto_execute = m.get('auto_execute')
        return self


class ContractNotaryInitInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        file_num: int = None,
        initiator: str = None,
        signatories: str = None,
        timestamp: str = None,
        tx_hash: str = None,
        intiator_name: str = None,
        signator_names: str = None,
        detail_info_file_hash: str = None,
    ):
        # 本阶段存证内容哈希值
        self.content = content
        # 签署文件份数
        self.file_num = file_num
        # 签署流程发起人ID
        self.initiator = initiator
        # 签署人ID（支持多个，不同ID间用“,”分隔开），由于流程中签署人可后续追加，最终以ContractNotaryFinishInfo中的singatories信息为准。
        self.signatories = signatories
        # 存证阶段发生时间，UNIX时间戳(毫秒)
        self.timestamp = timestamp
        # 存证凭据，仅在批量核验时需要填写
        self.tx_hash = tx_hash
        # 发起人名称
        self.intiator_name = intiator_name
        # 签署人名称,多个逗号隔开
        self.signator_names = signator_names
        # 详细文件哈希
        self.detail_info_file_hash = detail_info_file_hash

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.file_num, 'file_num')
        self.validate_required(self.initiator, 'initiator')
        self.validate_required(self.timestamp, 'timestamp')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.file_num is not None:
            result['file_num'] = self.file_num
        if self.initiator is not None:
            result['initiator'] = self.initiator
        if self.signatories is not None:
            result['signatories'] = self.signatories
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.intiator_name is not None:
            result['intiator_name'] = self.intiator_name
        if self.signator_names is not None:
            result['signator_names'] = self.signator_names
        if self.detail_info_file_hash is not None:
            result['detail_info_file_hash'] = self.detail_info_file_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('file_num') is not None:
            self.file_num = m.get('file_num')
        if m.get('initiator') is not None:
            self.initiator = m.get('initiator')
        if m.get('signatories') is not None:
            self.signatories = m.get('signatories')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('intiator_name') is not None:
            self.intiator_name = m.get('intiator_name')
        if m.get('signator_names') is not None:
            self.signator_names = m.get('signator_names')
        if m.get('detail_info_file_hash') is not None:
            self.detail_info_file_hash = m.get('detail_info_file_hash')
        return self


class Identity(TeaModel):
    def __init__(
        self,
        agent: str = None,
        agent_id: str = None,
        cert_name: str = None,
        cert_no: str = None,
        cert_type: str = None,
        legal_person: str = None,
        legal_person_id: str = None,
        mobile_no: str = None,
        properties: str = None,
        user_type: str = None,
        agent_cert_type: str = None,
        legal_person_cert_type: str = None,
    ):
        # 经办人姓名，企业认证选填
        self.agent = agent
        # 经办人身份证，企业认证选填
        self.agent_id = agent_id
        # 用户名称
        self.cert_name = cert_name
        # 证件号
        self.cert_no = cert_no
        # 证件类型，个人只支持身份证IDENTITY_CARD，企业支持UNIFIED_SOCIAL_CREDIT_CODE（统一社会信用代码）和ENTERPRISE_REGISTERED_NUMBER（企业工商注册号）
        self.cert_type = cert_type
        # 法人姓名，企业认证必选
        self.legal_person = legal_person
        # 法人身份证，企业认证必选
        self.legal_person_id = legal_person_id
        # 用户手机号码
        self.mobile_no = mobile_no
        # 扩展属性
        self.properties = properties
        # 用户类型，PERSON或者ENTERPRISE
        self.user_type = user_type
        # 经办人证件类型，企业认证选填
        self.agent_cert_type = agent_cert_type
        # 法人证件类型，企业认证必选
        self.legal_person_cert_type = legal_person_cert_type

    def validate(self):
        self.validate_required(self.cert_name, 'cert_name')
        self.validate_required(self.cert_no, 'cert_no')
        self.validate_required(self.cert_type, 'cert_type')
        self.validate_required(self.user_type, 'user_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent is not None:
            result['agent'] = self.agent
        if self.agent_id is not None:
            result['agent_id'] = self.agent_id
        if self.cert_name is not None:
            result['cert_name'] = self.cert_name
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        if self.legal_person is not None:
            result['legal_person'] = self.legal_person
        if self.legal_person_id is not None:
            result['legal_person_id'] = self.legal_person_id
        if self.mobile_no is not None:
            result['mobile_no'] = self.mobile_no
        if self.properties is not None:
            result['properties'] = self.properties
        if self.user_type is not None:
            result['user_type'] = self.user_type
        if self.agent_cert_type is not None:
            result['agent_cert_type'] = self.agent_cert_type
        if self.legal_person_cert_type is not None:
            result['legal_person_cert_type'] = self.legal_person_cert_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('agent') is not None:
            self.agent = m.get('agent')
        if m.get('agent_id') is not None:
            self.agent_id = m.get('agent_id')
        if m.get('cert_name') is not None:
            self.cert_name = m.get('cert_name')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        if m.get('legal_person') is not None:
            self.legal_person = m.get('legal_person')
        if m.get('legal_person_id') is not None:
            self.legal_person_id = m.get('legal_person_id')
        if m.get('mobile_no') is not None:
            self.mobile_no = m.get('mobile_no')
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        if m.get('agent_cert_type') is not None:
            self.agent_cert_type = m.get('agent_cert_type')
        if m.get('legal_person_cert_type') is not None:
            self.legal_person_cert_type = m.get('legal_person_cert_type')
        return self


class ContactInfo(TeaModel):
    def __init__(
        self,
        contact_name: str = None,
        contact_phone: str = None,
        contact_email: str = None,
    ):
        # 联系人-姓名
        self.contact_name = contact_name
        # 联系人-电话
        self.contact_phone = contact_phone
        # 联系人-电子邮箱
        self.contact_email = contact_email

    def validate(self):
        self.validate_required(self.contact_name, 'contact_name')
        self.validate_required(self.contact_phone, 'contact_phone')
        self.validate_required(self.contact_email, 'contact_email')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_name is not None:
            result['contact_name'] = self.contact_name
        if self.contact_phone is not None:
            result['contact_phone'] = self.contact_phone
        if self.contact_email is not None:
            result['contact_email'] = self.contact_email
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('contact_name') is not None:
            self.contact_name = m.get('contact_name')
        if m.get('contact_phone') is not None:
            self.contact_phone = m.get('contact_phone')
        if m.get('contact_email') is not None:
            self.contact_email = m.get('contact_email')
        return self


class CertificateInfo(TeaModel):
    def __init__(
        self,
        hash: str = None,
        resource_name: str = None,
        resource_url: str = None,
    ):
        # 存证证明的证书内容的SHA256哈希值
        self.hash = hash
        # 存证证明的证书文件名
        self.resource_name = resource_name
        # 存证证明的证书下载地址
        self.resource_url = resource_url

    def validate(self):
        self.validate_required(self.hash, 'hash')
        self.validate_required(self.resource_name, 'resource_name')
        self.validate_required(self.resource_url, 'resource_url')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hash is not None:
            result['hash'] = self.hash
        if self.resource_name is not None:
            result['resource_name'] = self.resource_name
        if self.resource_url is not None:
            result['resource_url'] = self.resource_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hash') is not None:
            self.hash = m.get('hash')
        if m.get('resource_name') is not None:
            self.resource_name = m.get('resource_name')
        if m.get('resource_url') is not None:
            self.resource_url = m.get('resource_url')
        return self


class ApplySupplierOrderProductOutput(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        pur_order_id: str = None,
        pur_order_status: str = None,
        supplier_id: str = None,
    ):
        # 订单id
        self.order_id = order_id
        # 链上采购单id
        self.pur_order_id = pur_order_id
        # 待采购：READY_DELIVER
        # 已采购：DELIVERED
        # 已拒发：REJECTED
        # 已退货：RETURNED
        # 已取消：CANCELED
        self.pur_order_status = pur_order_status
        # 供应商id
        self.supplier_id = supplier_id

    def validate(self):
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.pur_order_id, 'pur_order_id')
        self.validate_required(self.pur_order_status, 'pur_order_status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.pur_order_id is not None:
            result['pur_order_id'] = self.pur_order_id
        if self.pur_order_status is not None:
            result['pur_order_status'] = self.pur_order_status
        if self.supplier_id is not None:
            result['supplier_id'] = self.supplier_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('pur_order_id') is not None:
            self.pur_order_id = m.get('pur_order_id')
        if m.get('pur_order_status') is not None:
            self.pur_order_status = m.get('pur_order_status')
        if m.get('supplier_id') is not None:
            self.supplier_id = m.get('supplier_id')
        return self


class ContractPlatformOrganizationApplication(TeaModel):
    def __init__(
        self,
        id_number: str = None,
        id_type: str = None,
        org_legal_name: str = None,
        org_legal_id_number: str = None,
        name: str = None,
    ):
        # 证件号
        self.id_number = id_number
        # 证件类型
        self.id_type = id_type
        # 企业法人名称
        self.org_legal_name = org_legal_name
        # 企业法人证件号
        self.org_legal_id_number = org_legal_id_number
        # 机构名称
        self.name = name

    def validate(self):
        self.validate_required(self.id_number, 'id_number')
        self.validate_required(self.id_type, 'id_type')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.org_legal_name is not None:
            result['org_legal_name'] = self.org_legal_name
        if self.org_legal_id_number is not None:
            result['org_legal_id_number'] = self.org_legal_id_number
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('org_legal_name') is not None:
            self.org_legal_name = m.get('org_legal_name')
        if m.get('org_legal_id_number') is not None:
            self.org_legal_id_number = m.get('org_legal_id_number')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class ContractSignFieldSealId(TeaModel):
    def __init__(
        self,
        file_id: str = None,
        flow_id: str = None,
        seal_id: str = None,
        seal_type: str = None,
        signfield_id: str = None,
    ):
        # 文件file id
        self.file_id = file_id
        # 流程id
        self.flow_id = flow_id
        # 印章id
        self.seal_id = seal_id
        # 印章类型，支持多种类型时逗号分割，0-手绘印章，1-模版印章，为空不限制
        self.seal_type = seal_type
        # 签署区Id
        self.signfield_id = signfield_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.seal_id is not None:
            result['seal_id'] = self.seal_id
        if self.seal_type is not None:
            result['seal_type'] = self.seal_type
        if self.signfield_id is not None:
            result['signfield_id'] = self.signfield_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('seal_id') is not None:
            self.seal_id = m.get('seal_id')
        if m.get('seal_type') is not None:
            self.seal_type = m.get('seal_type')
        if m.get('signfield_id') is not None:
            self.signfield_id = m.get('signfield_id')
        return self


class ContractTemplateStructComponent(TeaModel):
    def __init__(
        self,
        font: int = None,
        font_size: str = None,
        height: str = None,
        id: str = None,
        key: str = None,
        label: str = None,
        limit: str = None,
        page: int = None,
        required: bool = None,
        text_color: str = None,
        type: int = None,
        width: str = None,
        x: str = None,
        y: str = None,
    ):
        # 填充字体,默认1，1-宋体，2-新宋体,4-黑体，5-楷体
        self.font = font
        # 填充字体大小,默认12
        self.font_size = font_size
        # 输入项组件高度
        self.height = height
        # 输入项组件id，使用时可用id填充，为空时表示添加，不为空时表示修改
        self.id = id
        # 模板下输入项组件唯一标识，使用模板时也可用根据key值填充
        self.key = key
        # 输入项组件显示名称
        self.label = label
        # 输入项组件type=2,type=3时填充格式校验规则;数字格式如：#,#00.0# 日期格式如： yyyy-MM-dd
        self.limit = limit
        # 页码
        self.page = page
        # 是否必填，默认true
        self.required = required
        # 字体颜色，默认#000000黑色
        self.text_color = text_color
        # 输入项组件类型，1-文本，2-数字,3-日期，6-签约区
        self.type = type
        # 输入项组件宽度
        self.width = width
        # x轴坐标，左下角为原点
        self.x = x
        # y轴坐标，左下角为原点
        self.y = y

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.font is not None:
            result['font'] = self.font
        if self.font_size is not None:
            result['font_size'] = self.font_size
        if self.height is not None:
            result['height'] = self.height
        if self.id is not None:
            result['id'] = self.id
        if self.key is not None:
            result['key'] = self.key
        if self.label is not None:
            result['label'] = self.label
        if self.limit is not None:
            result['limit'] = self.limit
        if self.page is not None:
            result['page'] = self.page
        if self.required is not None:
            result['required'] = self.required
        if self.text_color is not None:
            result['text_color'] = self.text_color
        if self.type is not None:
            result['type'] = self.type
        if self.width is not None:
            result['width'] = self.width
        if self.x is not None:
            result['x'] = self.x
        if self.y is not None:
            result['y'] = self.y
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('font') is not None:
            self.font = m.get('font')
        if m.get('font_size') is not None:
            self.font_size = m.get('font_size')
        if m.get('height') is not None:
            self.height = m.get('height')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('label') is not None:
            self.label = m.get('label')
        if m.get('limit') is not None:
            self.limit = m.get('limit')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('required') is not None:
            self.required = m.get('required')
        if m.get('text_color') is not None:
            self.text_color = m.get('text_color')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('width') is not None:
            self.width = m.get('width')
        if m.get('x') is not None:
            self.x = m.get('x')
        if m.get('y') is not None:
            self.y = m.get('y')
        return self


class TsrResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        hashed_message: str = None,
        hash_algorithm: str = None,
        message: str = None,
        ts: str = None,
        ctsr: str = None,
        sn: str = None,
    ):
        # 可信时间请求结果状态吗
        self.code = code
        # hash后的信息
        self.hashed_message = hashed_message
        # 哈希算法
        self.hash_algorithm = hash_algorithm
        # 请求失败时候的错误信息
        self.message = message
        # 时间
        self.ts = ts
        # 精简后的时间戳完整编码（在校验时需要提交）
        self.ctsr = ctsr
        # 凭证序列号 （在校验的时需要先填写凭证编号）
        # 
        self.sn = sn

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.hashed_message, 'hashed_message')
        self.validate_required(self.hash_algorithm, 'hash_algorithm')
        self.validate_required(self.ts, 'ts')
        self.validate_required(self.ctsr, 'ctsr')
        self.validate_required(self.sn, 'sn')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.hashed_message is not None:
            result['hashed_message'] = self.hashed_message
        if self.hash_algorithm is not None:
            result['hash_algorithm'] = self.hash_algorithm
        if self.message is not None:
            result['message'] = self.message
        if self.ts is not None:
            result['ts'] = self.ts
        if self.ctsr is not None:
            result['ctsr'] = self.ctsr
        if self.sn is not None:
            result['sn'] = self.sn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('hashed_message') is not None:
            self.hashed_message = m.get('hashed_message')
        if m.get('hash_algorithm') is not None:
            self.hash_algorithm = m.get('hash_algorithm')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('ts') is not None:
            self.ts = m.get('ts')
        if m.get('ctsr') is not None:
            self.ctsr = m.get('ctsr')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        return self


class LeaseIotItemInfo(TeaModel):
    def __init__(
        self,
        date: str = None,
        tx_hash: str = None,
        raw_data: str = None,
    ):
        # 证据的时间
        self.date = date
        # 证据的txHash
        self.tx_hash = tx_hash
        # 证据的原始数据，默认为空或加密状态，除非调用方为授权用户（如出资方等
        self.raw_data = raw_data

    def validate(self):
        self.validate_required(self.date, 'date')
        if self.date is not None:
            self.validate_pattern(self.date, 'date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.tx_hash, 'tx_hash')
        self.validate_required(self.raw_data, 'raw_data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['date'] = self.date
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.raw_data is not None:
            result['raw_data'] = self.raw_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('date') is not None:
            self.date = m.get('date')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('raw_data') is not None:
            self.raw_data = m.get('raw_data')
        return self


class WitnessConfirmData(TeaModel):
    def __init__(
        self,
        doc_file_key: str = None,
        hash_algorithm: str = None,
        signed_hash: str = None,
        third_doc_id: str = None,
    ):
        # 文档fileKey
        self.doc_file_key = doc_file_key
        # 文档摘要算法，SHA256
        self.hash_algorithm = hash_algorithm
        # 签署后文档摘要值
        self.signed_hash = signed_hash
        # 第三方文档id
        self.third_doc_id = third_doc_id

    def validate(self):
        self.validate_required(self.hash_algorithm, 'hash_algorithm')
        self.validate_required(self.signed_hash, 'signed_hash')
        self.validate_required(self.third_doc_id, 'third_doc_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_file_key is not None:
            result['doc_file_key'] = self.doc_file_key
        if self.hash_algorithm is not None:
            result['hash_algorithm'] = self.hash_algorithm
        if self.signed_hash is not None:
            result['signed_hash'] = self.signed_hash
        if self.third_doc_id is not None:
            result['third_doc_id'] = self.third_doc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('doc_file_key') is not None:
            self.doc_file_key = m.get('doc_file_key')
        if m.get('hash_algorithm') is not None:
            self.hash_algorithm = m.get('hash_algorithm')
        if m.get('signed_hash') is not None:
            self.signed_hash = m.get('signed_hash')
        if m.get('third_doc_id') is not None:
            self.third_doc_id = m.get('third_doc_id')
        return self


class ContractAccount(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class JudicialMediationBaseParamInfo(TeaModel):
    def __init__(
        self,
        mediation_day_limit: int = None,
        mediation_total_amount: str = None,
        min_amount: str = None,
    ):
        # 委托调解时长(天), 仅支持:30,60,90
        self.mediation_day_limit = mediation_day_limit
        # 调解总标的金额
        self.mediation_total_amount = mediation_total_amount
        # 可接受最低调解回款金额
        self.min_amount = min_amount

    def validate(self):
        self.validate_required(self.mediation_day_limit, 'mediation_day_limit')
        self.validate_required(self.mediation_total_amount, 'mediation_total_amount')
        self.validate_required(self.min_amount, 'min_amount')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mediation_day_limit is not None:
            result['mediation_day_limit'] = self.mediation_day_limit
        if self.mediation_total_amount is not None:
            result['mediation_total_amount'] = self.mediation_total_amount
        if self.min_amount is not None:
            result['min_amount'] = self.min_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('mediation_day_limit') is not None:
            self.mediation_day_limit = m.get('mediation_day_limit')
        if m.get('mediation_total_amount') is not None:
            self.mediation_total_amount = m.get('mediation_total_amount')
        if m.get('min_amount') is not None:
            self.min_amount = m.get('min_amount')
        return self


class CallbackArbitrationStatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        acceptance_number: str = None,
        case_no: str = None,
        confirm_time: int = None,
        preacceptance_number: str = None,
        send_time: int = None,
        status: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 案件文书号
        self.acceptance_number = acceptance_number
        # 案件编号
        self.case_no = case_no
        # 确认时间时间戳
        self.confirm_time = confirm_time
        # 预处理案号
        self.preacceptance_number = preacceptance_number
        # 发送时间时间戳
        self.send_time = send_time
        # 案件状态
        self.status = status

    def validate(self):
        self.validate_required(self.case_no, 'case_no')
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.acceptance_number is not None:
            result['acceptance_number'] = self.acceptance_number
        if self.case_no is not None:
            result['case_no'] = self.case_no
        if self.confirm_time is not None:
            result['confirm_time'] = self.confirm_time
        if self.preacceptance_number is not None:
            result['preacceptance_number'] = self.preacceptance_number
        if self.send_time is not None:
            result['send_time'] = self.send_time
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('acceptance_number') is not None:
            self.acceptance_number = m.get('acceptance_number')
        if m.get('case_no') is not None:
            self.case_no = m.get('case_no')
        if m.get('confirm_time') is not None:
            self.confirm_time = m.get('confirm_time')
        if m.get('preacceptance_number') is not None:
            self.preacceptance_number = m.get('preacceptance_number')
        if m.get('send_time') is not None:
            self.send_time = m.get('send_time')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class CallbackArbitrationStatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CallbackArbitrationSignstatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        case_no: str = None,
        doc_code: str = None,
        res_code: str = None,
        message: str = None,
        send_time: str = None,
        signature: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 案件号
        self.case_no = case_no
        # 签署文件代码 01 申请书 04 撤案申请书
        self.doc_code = doc_code
        # 处理结果码 10000成功 其余都是签署失败
        self.res_code = res_code
        # 失败原因
        self.message = message
        # 发送时间 yyyy-MM-dd
        self.send_time = send_time
        # 签名,采用公钥验签
        self.signature = signature

    def validate(self):
        self.validate_required(self.case_no, 'case_no')
        self.validate_required(self.doc_code, 'doc_code')
        self.validate_required(self.res_code, 'res_code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.send_time, 'send_time')
        self.validate_required(self.signature, 'signature')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.case_no is not None:
            result['case_no'] = self.case_no
        if self.doc_code is not None:
            result['doc_code'] = self.doc_code
        if self.res_code is not None:
            result['res_code'] = self.res_code
        if self.message is not None:
            result['message'] = self.message
        if self.send_time is not None:
            result['send_time'] = self.send_time
        if self.signature is not None:
            result['signature'] = self.signature
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('case_no') is not None:
            self.case_no = m.get('case_no')
        if m.get('doc_code') is not None:
            self.doc_code = m.get('doc_code')
        if m.get('res_code') is not None:
            self.res_code = m.get('res_code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('send_time') is not None:
            self.send_time = m.get('send_time')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        return self


class CallbackArbitrationSignstatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否处理回调成功 true成功
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class CreateContractAccountRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        email: str = None,
        id_number: str = None,
        id_type: str = None,
        mobile: str = None,
        name: str = None,
        user_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 邮箱地址，默认空
        self.email = email
        # 证件号
        self.id_number = id_number
        # 证件类型，默认CRED_PSN_CH_IDCARD，详见个人证件类型说明文档（https://tech.antfin.com/docs/2/155166）
        self.id_type = id_type
        # 手机号码，默认空
        self.mobile = mobile
        # 姓名
        self.name = name
        # 用户唯一标识，可传入第三方平台的个人用户id、证件号、手机号、邮箱等，如果设置则作为账号唯一性字段，相同信息不可重复创建。（个人用户与机构的唯一标识不可重复）
        self.user_id = user_id

    def validate(self):
        self.validate_required(self.id_number, 'id_number')
        self.validate_required(self.id_type, 'id_type')
        self.validate_required(self.name, 'name')
        self.validate_required(self.user_id, 'user_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.email is not None:
            result['email'] = self.email
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CreateContractAccountResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        account_id: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 个人账号ID
        self.account_id = account_id
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateContractAccountsealRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        alias: str = None,
        color: str = None,
        height: int = None,
        width: int = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 电子合同用户ID（在twc.notary.contract.account.create接口中创建）
        self.account_id = account_id
        # 印章别名
        self.alias = alias
        # 印章颜色，RED-红色， BLUE-蓝色，BLACK-黑色
        self.color = color
        # 印章高度, 默认95px
        self.height = height
        # 印章宽度, 默认95px
        self.width = width
        # 模板类型, 详见个人印章样式说明 SQUARE, BORDERLESS, FZKC, HWLS, HWXK, HWXKBORDER, HYLSF, RECTANGLE, YGYJFCS, YGYMBXS, YYGXSF
        self.type = type

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.color, 'color')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.alias is not None:
            result['alias'] = self.alias
        if self.color is not None:
            result['color'] = self.color
        if self.height is not None:
            result['height'] = self.height
        if self.width is not None:
            result['width'] = self.width
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('alias') is not None:
            self.alias = m.get('alias')
        if m.get('color') is not None:
            self.color = m.get('color')
        if m.get('height') is not None:
            self.height = m.get('height')
        if m.get('width') is not None:
            self.width = m.get('width')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CreateContractAccountsealResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        file_key: str = None,
        seal_id: str = None,
        url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 印章fileKey
        self.file_key = file_key
        # 印章id
        self.seal_id = seal_id
        # 印章下载地址, 有效时间1小时
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.file_key is not None:
            result['file_key'] = self.file_key
        if self.seal_id is not None:
            result['seal_id'] = self.seal_id
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('file_key') is not None:
            self.file_key = m.get('file_key')
        if m.get('seal_id') is not None:
            self.seal_id = m.get('seal_id')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class CreateContractOrganizationRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        creator: str = None,
        id_number: str = None,
        id_type: str = None,
        legal_person: str = None,
        legal_person_id: str = None,
        name: str = None,
        user_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 创建人个人账号ID，也就是调用个人账号创建接口（twc.notary.contract.account.create
        # ）返回的accountId
        self.creator = creator
        # 证件号
        self.id_number = id_number
        # 证件类型，默认CRED_ORG_USCC，详见机构证件类型说明 （https://tech.antfin.com/docs/2/155166）
        self.id_type = id_type
        # 企业法人名称
        self.legal_person = legal_person
        # 企业法人证件号
        self.legal_person_id = legal_person_id
        # 机构名称
        self.name = name
        # 机构唯一标识，可传入第三方平台机构id、企业证件号、企业邮箱等如果设置则作为账号唯一性字段，相同id不可重复创建。（个人用户与机构的唯一标识不可重复）
        self.user_id = user_id

    def validate(self):
        self.validate_required(self.creator, 'creator')
        self.validate_required(self.id_number, 'id_number')
        self.validate_required(self.id_type, 'id_type')
        self.validate_required(self.name, 'name')
        self.validate_required(self.user_id, 'user_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.creator is not None:
            result['creator'] = self.creator
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.legal_person is not None:
            result['legal_person'] = self.legal_person
        if self.legal_person_id is not None:
            result['legal_person_id'] = self.legal_person_id
        if self.name is not None:
            result['name'] = self.name
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('legal_person') is not None:
            self.legal_person = m.get('legal_person')
        if m.get('legal_person_id') is not None:
            self.legal_person_id = m.get('legal_person_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CreateContractOrganizationResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        org_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 机构账号ID
        self.org_id = org_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.org_id is not None:
            result['org_id'] = self.org_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('org_id') is not None:
            self.org_id = m.get('org_id')
        return self


class CreateContractOrgsealRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        alias: str = None,
        central: str = None,
        color: str = None,
        height: int = None,
        htext: str = None,
        org_id: str = None,
        qtext: str = None,
        type: str = None,
        width: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 印章别名
        self.alias = alias
        # 中心图案类型，STAR-圆形有五角星，NONE-圆形无五角星， 详见机构印章样式说明
        self.central = central
        # 印章颜色，RED-红色，BLUE-蓝色，BLACK-黑色
        self.color = color
        # 印章高度，默认159px
        self.height = height
        # 横向文，可设置0-8个字，企业名称超出25个字后，不支持设置横向文
        self.htext = htext
        # 机构ID
        self.org_id = org_id
        # 下弦文，可设置0-20个字，企业企业名称超出25个字后，不支持设置下弦文
        self.qtext = qtext
        # 模板类型，TEMPLATE_ROUND-圆章，TEMPLATE_OVAL-椭圆章， 详见机构印章样式说明
        self.type = type
        # 印章宽度，默认159px
        self.width = width

    def validate(self):
        self.validate_required(self.central, 'central')
        self.validate_required(self.color, 'color')
        self.validate_required(self.org_id, 'org_id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.alias is not None:
            result['alias'] = self.alias
        if self.central is not None:
            result['central'] = self.central
        if self.color is not None:
            result['color'] = self.color
        if self.height is not None:
            result['height'] = self.height
        if self.htext is not None:
            result['htext'] = self.htext
        if self.org_id is not None:
            result['org_id'] = self.org_id
        if self.qtext is not None:
            result['qtext'] = self.qtext
        if self.type is not None:
            result['type'] = self.type
        if self.width is not None:
            result['width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('alias') is not None:
            self.alias = m.get('alias')
        if m.get('central') is not None:
            self.central = m.get('central')
        if m.get('color') is not None:
            self.color = m.get('color')
        if m.get('height') is not None:
            self.height = m.get('height')
        if m.get('htext') is not None:
            self.htext = m.get('htext')
        if m.get('org_id') is not None:
            self.org_id = m.get('org_id')
        if m.get('qtext') is not None:
            self.qtext = m.get('qtext')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('width') is not None:
            self.width = m.get('width')
        return self


class CreateContractOrgsealResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        file_key: str = None,
        message: str = None,
        seal_id: str = None,
        url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 印章fileKey
        self.file_key = file_key
        # 业务码信息
        self.message = message
        # 印章ID
        self.seal_id = seal_id
        # 印章下载地址, 有效时间1小时
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.file_key is not None:
            result['file_key'] = self.file_key
        if self.message is not None:
            result['message'] = self.message
        if self.seal_id is not None:
            result['seal_id'] = self.seal_id
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('file_key') is not None:
            self.file_key = m.get('file_key')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('seal_id') is not None:
            self.seal_id = m.get('seal_id')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class AuthContractSignRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        deadline: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 授权人ID，即个人账号ID或机构账号ID
        self.account_id = account_id
        # 授权截止时间, 格式为yyyy-MM-dd HH:mm:ss，默认无限期
        self.deadline = deadline

    def validate(self):
        self.validate_required(self.account_id, 'account_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.deadline is not None:
            result['deadline'] = self.deadline
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('deadline') is not None:
            self.deadline = m.get('deadline')
        return self


class AuthContractSignResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        accepted: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 业务数据, 是否授权成功
        self.accepted = accepted

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.accepted is not None:
            result['accepted'] = self.accepted
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('accepted') is not None:
            self.accepted = m.get('accepted')
        return self


class CreateContractTemplateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        content_md_5: str = None,
        content_type: str = None,
        convert_2pdf: bool = None,
        file_name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 模板文件md5值，再做base64编码
        self.content_md_5 = content_md_5
        # 目标文件的MIME类型
        self.content_type = content_type
        # 是否需要转成pdf，如果模板文件为.doc/.docx 传true，为pdf传false
        self.convert_2pdf = convert_2pdf
        # 文件名称，必须带扩展名如:.pdf,.doc,.docx
        self.file_name = file_name

    def validate(self):
        self.validate_required(self.content_md_5, 'content_md_5')
        self.validate_required(self.content_type, 'content_type')
        self.validate_required(self.convert_2pdf, 'convert_2pdf')
        self.validate_required(self.file_name, 'file_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.content_md_5 is not None:
            result['content_md5'] = self.content_md_5
        if self.content_type is not None:
            result['content_type'] = self.content_type
        if self.convert_2pdf is not None:
            result['convert2_pdf'] = self.convert_2pdf
        if self.file_name is not None:
            result['file_name'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('content_md5') is not None:
            self.content_md_5 = m.get('content_md5')
        if m.get('content_type') is not None:
            self.content_type = m.get('content_type')
        if m.get('convert2_pdf') is not None:
            self.convert_2pdf = m.get('convert2_pdf')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        return self


class CreateContractTemplateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        template_id: str = None,
        upload_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 模板ID
        self.template_id = template_id
        # 文件直传地址，需要用此上传地址使用put方式上传文件，只有文件上传后模板才可用
        self.upload_url = upload_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.template_id is not None:
            result['template_id'] = self.template_id
        if self.upload_url is not None:
            result['upload_url'] = self.upload_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        if m.get('upload_url') is not None:
            self.upload_url = m.get('upload_url')
        return self


class CreateContractFlowRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        auto_archive: bool = None,
        business_scene: str = None,
        config_info: ContractSignFlowConfig = None,
        contract_remind: int = None,
        contract_validity: int = None,
        initiator_account_id: str = None,
        initiator_authorized_account_id: str = None,
        sign_validity: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 是否自动归档，默认false。如设置为true，则在调用签署流程开启(twc.notary.contract.flow.start)后，当所有签署人签署完毕，系统自动将流程归档，状态变为“已完成”状态，在流程状态为“已完成”前，可随时添加签署人；如设置为false，则在调用签署流程开启后，需主动调用签署流程归档接口，将流程状态变更为“已完成”，归档前可随时添加签署人；已完成的流程才可下载签署后的文件
        self.auto_archive = auto_archive
        # 文件主题
        self.business_scene = business_scene
        # 任务配置信息
        self.config_info = config_info
        # 文件到期前，提前多久回调提醒续签，单位为小时，时间区间：1小时——15天（360小时），默认不提醒
        self.contract_remind = contract_remind
        # 文件有效截止日期,毫秒，默认不失效
        self.contract_validity = contract_validity
        # 发起人账户id，即发起本次签署的操作人个人账号id；如不传，默认由对接平台发起
        self.initiator_account_id = initiator_account_id
        # 发起方主体id，如存在个人代机构发起签约，则需传入机构id；如不传，则默认是对接平台
        self.initiator_authorized_account_id = initiator_authorized_account_id
        # 签署有效截止日期,毫秒，默认不失效
        self.sign_validity = sign_validity

    def validate(self):
        self.validate_required(self.business_scene, 'business_scene')
        if self.config_info:
            self.config_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.auto_archive is not None:
            result['auto_archive'] = self.auto_archive
        if self.business_scene is not None:
            result['business_scene'] = self.business_scene
        if self.config_info is not None:
            result['config_info'] = self.config_info.to_map()
        if self.contract_remind is not None:
            result['contract_remind'] = self.contract_remind
        if self.contract_validity is not None:
            result['contract_validity'] = self.contract_validity
        if self.initiator_account_id is not None:
            result['initiator_account_id'] = self.initiator_account_id
        if self.initiator_authorized_account_id is not None:
            result['initiator_authorized_account_id'] = self.initiator_authorized_account_id
        if self.sign_validity is not None:
            result['sign_validity'] = self.sign_validity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('auto_archive') is not None:
            self.auto_archive = m.get('auto_archive')
        if m.get('business_scene') is not None:
            self.business_scene = m.get('business_scene')
        if m.get('config_info') is not None:
            temp_model = ContractSignFlowConfig()
            self.config_info = temp_model.from_map(m['config_info'])
        if m.get('contract_remind') is not None:
            self.contract_remind = m.get('contract_remind')
        if m.get('contract_validity') is not None:
            self.contract_validity = m.get('contract_validity')
        if m.get('initiator_account_id') is not None:
            self.initiator_account_id = m.get('initiator_account_id')
        if m.get('initiator_authorized_account_id') is not None:
            self.initiator_authorized_account_id = m.get('initiator_authorized_account_id')
        if m.get('sign_validity') is not None:
            self.sign_validity = m.get('sign_validity')
        return self


class CreateContractFlowResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        flow_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 流程ID
        self.flow_id = flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        return self


class AddContractDocumentRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        docs: List[ContractDoc] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 流程ID
        self.flow_id = flow_id
        # 文档列表数据
        self.docs = docs

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.docs, 'docs')
        if self.docs:
            for k in self.docs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        result['docs'] = []
        if self.docs is not None:
            for k in self.docs:
                result['docs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        self.docs = []
        if m.get('docs') is not None:
            for k in m.get('docs'):
                temp_model = ContractDoc()
                self.docs.append(temp_model.from_map(k))
        return self


class AddContractDocumentResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class AddContractSignfieldRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        signfields: List[ContractSignFieldApplication] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 签署流程ID
        self.flow_id = flow_id
        # 签署区列表数据
        self.signfields = signfields

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.signfields, 'signfields')
        if self.signfields:
            for k in self.signfields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        result['signfields'] = []
        if self.signfields is not None:
            for k in self.signfields:
                result['signfields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        self.signfields = []
        if m.get('signfields') is not None:
            for k in m.get('signfields'):
                temp_model = ContractSignFieldApplication()
                self.signfields.append(temp_model.from_map(k))
        return self


class AddContractSignfieldResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        signfields: List[ContractSignField] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 签署区列表数据
        self.signfields = signfields

    def validate(self):
        if self.signfields:
            for k in self.signfields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['signfields'] = []
        if self.signfields is not None:
            for k in self.signfields:
                result['signfields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.signfields = []
        if m.get('signfields') is not None:
            for k in m.get('signfields'):
                temp_model = ContractSignField()
                self.signfields.append(temp_model.from_map(k))
        return self


class StartContractFlowRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 流程ID
        self.flow_id = flow_id

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        return self


class StartContractFlowResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class SaveContractFlowRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 流程ID
        self.flow_id = flow_id

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        return self


class SaveContractFlowResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class DownloadContractDocumentRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 流程ID
        self.flow_id = flow_id

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        return self


class DownloadContractDocumentResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        docs: List[ContractDocAddress] = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 文档下载地址信息列表
        self.docs = docs
        # 业务码信息
        self.message = message

    def validate(self):
        if self.docs:
            for k in self.docs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        result['docs'] = []
        if self.docs is not None:
            for k in self.docs:
                result['docs'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        self.docs = []
        if m.get('docs') is not None:
            for k in m.get('docs'):
                temp_model = ContractDocAddress()
                self.docs.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class AddContractFileRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        name: str = None,
        template_id: str = None,
        simple_form_fields: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 文件名称
        self.name = name
        # 模板编号
        self.template_id = template_id
        # 输入项填充内容，以key:value传入
        self.simple_form_fields = simple_form_fields

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.template_id, 'template_id')
        self.validate_required(self.simple_form_fields, 'simple_form_fields')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.template_id is not None:
            result['template_id'] = self.template_id
        if self.simple_form_fields is not None:
            result['simple_form_fields'] = self.simple_form_fields
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        if m.get('simple_form_fields') is not None:
            self.simple_form_fields = m.get('simple_form_fields')
        return self


class AddContractFileResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        download_url: str = None,
        file_id: str = None,
        file_name: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 文件下载地址，有效期一小时
        self.download_url = download_url
        # 文件id
        self.file_id = file_id
        # 文件名称
        self.file_name = file_name
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.download_url is not None:
            result['download_url'] = self.download_url
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('download_url') is not None:
            self.download_url = m.get('download_url')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateContractPlatformRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        creator: ContractAccountApplication = None,
        platform: ContractOrganizationApplication = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 平台方经办人信息
        self.creator = creator
        # 平台机构信息
        self.platform = platform

    def validate(self):
        self.validate_required(self.creator, 'creator')
        if self.creator:
            self.creator.validate()
        self.validate_required(self.platform, 'platform')
        if self.platform:
            self.platform.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.creator is not None:
            result['creator'] = self.creator.to_map()
        if self.platform is not None:
            result['platform'] = self.platform.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('creator') is not None:
            temp_model = ContractAccountApplication()
            self.creator = temp_model.from_map(m['creator'])
        if m.get('platform') is not None:
            temp_model = ContractOrganizationApplication()
            self.platform = temp_model.from_map(m['platform'])
        return self


class CreateContractPlatformResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        creator_id: str = None,
        platform_id: str = None,
        secret: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 创建人ID
        self.creator_id = creator_id
        # 平台方ID
        self.platform_id = platform_id
        # 平台用户与智能合同服务间鉴权使用的密钥
        self.secret = secret
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.creator_id is not None:
            result['creator_id'] = self.creator_id
        if self.platform_id is not None:
            result['platform_id'] = self.platform_id
        if self.secret is not None:
            result['secret'] = self.secret
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('creator_id') is not None:
            self.creator_id = m.get('creator_id')
        if m.get('platform_id') is not None:
            self.platform_id = m.get('platform_id')
        if m.get('secret') is not None:
            self.secret = m.get('secret')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateContractUserRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        organization: ContractOrganizationApplication = None,
        user: ContractAccountApplication = None,
        user_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用户类型为机构时，填写机构信息
        self.organization = organization
        # 用户类型为个人时，则为个人用户信息；用户类型为机构时，则为机构账号经办人信息
        self.user = user
        # 用户类型，个人（PERSON）或机构（ORGANIZATION）
        self.user_type = user_type

    def validate(self):
        if self.organization:
            self.organization.validate()
        self.validate_required(self.user, 'user')
        if self.user:
            self.user.validate()
        self.validate_required(self.user_type, 'user_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.organization is not None:
            result['organization'] = self.organization.to_map()
        if self.user is not None:
            result['user'] = self.user.to_map()
        if self.user_type is not None:
            result['user_type'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('organization') is not None:
            temp_model = ContractOrganizationApplication()
            self.organization = temp_model.from_map(m['organization'])
        if m.get('user') is not None:
            temp_model = ContractAccountApplication()
            self.user = temp_model.from_map(m['user'])
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        return self


class CreateContractUserResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        organization_id: str = None,
        user_id: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 机构账号
        self.organization_id = organization_id
        # 用户类型为个人时返回用户账号；用户类型为机构时返回经办人账号
        self.user_id = user_id
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.organization_id is not None:
            result['organization_id'] = self.organization_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('organization_id') is not None:
            self.organization_id = m.get('organization_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class StartContractHandsignRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        agent_account_id: str = None,
        auto_archive: bool = None,
        business_scene: str = None,
        contract_remind: int = None,
        contract_sign_flow_config: ContractSignFlowConfig = None,
        contract_validity: int = None,
        initiator_account_id: str = None,
        initiator_authorized_account_id: str = None,
        repayment_order_info: List[RepaymentOrderRequest] = None,
        sign_platform: str = None,
        sign_validity: str = None,
        simple_form_fields: str = None,
        template: str = None,
        user_account: str = None,
        short_url: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 代理商户账户
        self.agent_account_id = agent_account_id
        # 是否自动归档，默认为true
        self.auto_archive = auto_archive
        # 合同文件主题
        self.business_scene = business_scene
        # 文件到期前，提前多少小时回调提醒续签，小时（时间区间：1小时——15天），默认不提醒
        self.contract_remind = contract_remind
        # 签署流程任务配置信息
        self.contract_sign_flow_config = contract_sign_flow_config
        # 文件有效截止日期,毫秒，默认不失效
        self.contract_validity = contract_validity
        # 发起人账户id，即发起本次签署的操作人个人账号id；如不传，默认由对接平台发起
        self.initiator_account_id = initiator_account_id
        # 发起方主体id，如存在个人代机构发起签约，则需传入机构id；如不传，则默认是对接平台
        # 
        # 
        self.initiator_authorized_account_id = initiator_authorized_account_id
        # 代扣规则详情，不可为空
        self.repayment_order_info = repayment_order_info
        # 签署平台，ALIPAY（支付宝小程序）或H5，默认H5
        self.sign_platform = sign_platform
        # 签署有效截止日期,毫秒，默认不失效
        self.sign_validity = sign_validity
        # 输入项填充内容，以key:value传入
        self.simple_form_fields = simple_form_fields
        # 待签署的智能合同模板ID
        self.template = template
        # 待签署客户的账户ID
        self.user_account = user_account
        # 是否需要短网址
        self.short_url = short_url

    def validate(self):
        self.validate_required(self.business_scene, 'business_scene')
        if self.contract_sign_flow_config:
            self.contract_sign_flow_config.validate()
        if self.repayment_order_info:
            for k in self.repayment_order_info:
                if k:
                    k.validate()
        self.validate_required(self.simple_form_fields, 'simple_form_fields')
        self.validate_required(self.template, 'template')
        self.validate_required(self.user_account, 'user_account')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.agent_account_id is not None:
            result['agent_account_id'] = self.agent_account_id
        if self.auto_archive is not None:
            result['auto_archive'] = self.auto_archive
        if self.business_scene is not None:
            result['business_scene'] = self.business_scene
        if self.contract_remind is not None:
            result['contract_remind'] = self.contract_remind
        if self.contract_sign_flow_config is not None:
            result['contract_sign_flow_config'] = self.contract_sign_flow_config.to_map()
        if self.contract_validity is not None:
            result['contract_validity'] = self.contract_validity
        if self.initiator_account_id is not None:
            result['initiator_account_id'] = self.initiator_account_id
        if self.initiator_authorized_account_id is not None:
            result['initiator_authorized_account_id'] = self.initiator_authorized_account_id
        result['repayment_order_info'] = []
        if self.repayment_order_info is not None:
            for k in self.repayment_order_info:
                result['repayment_order_info'].append(k.to_map() if k else None)
        if self.sign_platform is not None:
            result['sign_platform'] = self.sign_platform
        if self.sign_validity is not None:
            result['sign_validity'] = self.sign_validity
        if self.simple_form_fields is not None:
            result['simple_form_fields'] = self.simple_form_fields
        if self.template is not None:
            result['template'] = self.template
        if self.user_account is not None:
            result['user_account'] = self.user_account
        if self.short_url is not None:
            result['short_url'] = self.short_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('agent_account_id') is not None:
            self.agent_account_id = m.get('agent_account_id')
        if m.get('auto_archive') is not None:
            self.auto_archive = m.get('auto_archive')
        if m.get('business_scene') is not None:
            self.business_scene = m.get('business_scene')
        if m.get('contract_remind') is not None:
            self.contract_remind = m.get('contract_remind')
        if m.get('contract_sign_flow_config') is not None:
            temp_model = ContractSignFlowConfig()
            self.contract_sign_flow_config = temp_model.from_map(m['contract_sign_flow_config'])
        if m.get('contract_validity') is not None:
            self.contract_validity = m.get('contract_validity')
        if m.get('initiator_account_id') is not None:
            self.initiator_account_id = m.get('initiator_account_id')
        if m.get('initiator_authorized_account_id') is not None:
            self.initiator_authorized_account_id = m.get('initiator_authorized_account_id')
        self.repayment_order_info = []
        if m.get('repayment_order_info') is not None:
            for k in m.get('repayment_order_info'):
                temp_model = RepaymentOrderRequest()
                self.repayment_order_info.append(temp_model.from_map(k))
        if m.get('sign_platform') is not None:
            self.sign_platform = m.get('sign_platform')
        if m.get('sign_validity') is not None:
            self.sign_validity = m.get('sign_validity')
        if m.get('simple_form_fields') is not None:
            self.simple_form_fields = m.get('simple_form_fields')
        if m.get('template') is not None:
            self.template = m.get('template')
        if m.get('user_account') is not None:
            self.user_account = m.get('user_account')
        if m.get('short_url') is not None:
            self.short_url = m.get('short_url')
        return self


class StartContractHandsignResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        flow_id: str = None,
        message: str = None,
        url: str = None,
        short_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 签署流程ID
        self.flow_id = flow_id
        # 业务码信息
        self.message = message
        # 手动签约唤起地址
        self.url = url
        # 唤起签约地址短网址
        self.short_url = short_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.message is not None:
            result['message'] = self.message
        if self.url is not None:
            result['url'] = self.url
        if self.short_url is not None:
            result['short_url'] = self.short_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('url') is not None:
            self.url = m.get('url')
        if m.get('short_url') is not None:
            self.short_url = m.get('short_url')
        return self


class QueryContractFlowRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 流程id
        self.flow_id = flow_id

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        return self


class QueryContractFlowResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        auto_archive: bool = None,
        business_scene: str = None,
        code: int = None,
        config_info: ContractSignFlowConfig = None,
        contract_remind: int = None,
        contract_validity: int = None,
        flow_desc: str = None,
        flow_end_time: str = None,
        flow_id: str = None,
        flow_start_time: str = None,
        flow_status: int = None,
        initiator_account_id: str = None,
        initiator_authorized_account_id: str = None,
        message: str = None,
        sign_validity: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否自动归档
        self.auto_archive = auto_archive
        # 文件主题
        self.business_scene = business_scene
        # 业务码，0表示成功
        self.code = code
        # 流程配置信息
        self.config_info = config_info
        # 文件到期前，提前多少小时提醒续签
        self.contract_remind = contract_remind
        # 文件有效截止日期
        self.contract_validity = contract_validity
        # 流程描述, 如果流程已拒签或已撤回, 并且存在拒签或撤回原因, 流程描述显示为原因, 否则默认为流程状态描述
        self.flow_desc = flow_desc
        # 流程结束时间
        self.flow_end_time = flow_end_time
        # 流程ID
        self.flow_id = flow_id
        # 流程开始时间
        self.flow_start_time = flow_start_time
        # 流程状态,0-草稿 1-签署中 2-完成 3-撤销 4-终止 5-过期 6-删除 7-拒签
        self.flow_status = flow_status
        # 发起人账户id
        self.initiator_account_id = initiator_account_id
        # 发起方主体id
        self.initiator_authorized_account_id = initiator_authorized_account_id
        # 业务码信息
        self.message = message
        # 签署有效截止日期
        self.sign_validity = sign_validity

    def validate(self):
        if self.config_info:
            self.config_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.auto_archive is not None:
            result['auto_archive'] = self.auto_archive
        if self.business_scene is not None:
            result['business_scene'] = self.business_scene
        if self.code is not None:
            result['code'] = self.code
        if self.config_info is not None:
            result['config_info'] = self.config_info.to_map()
        if self.contract_remind is not None:
            result['contract_remind'] = self.contract_remind
        if self.contract_validity is not None:
            result['contract_validity'] = self.contract_validity
        if self.flow_desc is not None:
            result['flow_desc'] = self.flow_desc
        if self.flow_end_time is not None:
            result['flow_end_time'] = self.flow_end_time
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.flow_start_time is not None:
            result['flow_start_time'] = self.flow_start_time
        if self.flow_status is not None:
            result['flow_status'] = self.flow_status
        if self.initiator_account_id is not None:
            result['initiator_account_id'] = self.initiator_account_id
        if self.initiator_authorized_account_id is not None:
            result['initiator_authorized_account_id'] = self.initiator_authorized_account_id
        if self.message is not None:
            result['message'] = self.message
        if self.sign_validity is not None:
            result['sign_validity'] = self.sign_validity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('auto_archive') is not None:
            self.auto_archive = m.get('auto_archive')
        if m.get('business_scene') is not None:
            self.business_scene = m.get('business_scene')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('config_info') is not None:
            temp_model = ContractSignFlowConfig()
            self.config_info = temp_model.from_map(m['config_info'])
        if m.get('contract_remind') is not None:
            self.contract_remind = m.get('contract_remind')
        if m.get('contract_validity') is not None:
            self.contract_validity = m.get('contract_validity')
        if m.get('flow_desc') is not None:
            self.flow_desc = m.get('flow_desc')
        if m.get('flow_end_time') is not None:
            self.flow_end_time = m.get('flow_end_time')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('flow_start_time') is not None:
            self.flow_start_time = m.get('flow_start_time')
        if m.get('flow_status') is not None:
            self.flow_status = m.get('flow_status')
        if m.get('initiator_account_id') is not None:
            self.initiator_account_id = m.get('initiator_account_id')
        if m.get('initiator_authorized_account_id') is not None:
            self.initiator_authorized_account_id = m.get('initiator_authorized_account_id')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('sign_validity') is not None:
            self.sign_validity = m.get('sign_validity')
        return self


class CreateContractAccountsealimageRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        alias: str = None,
        height: int = None,
        width: int = None,
        type: str = None,
        data: str = None,
        transparent_flag: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用户id
        self.account_id = account_id
        # 印章别名
        self.alias = alias
        # 印章高度, 个人默认95px, 机构默认159px
        self.height = height
        # 印章宽度, 个人默认95px, 机构默认159px
        self.width = width
        # 印章数据类型，BASE64：base64格式
        self.type = type
        # 印章数据，base64格式字符串，不包含格式前缀
        self.data = data
        # 是否对图片进行透明化处理，默认false。仅对图片整体做透明化处理，无法去除图片背景
        self.transparent_flag = transparent_flag

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.type, 'type')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.alias is not None:
            result['alias'] = self.alias
        if self.height is not None:
            result['height'] = self.height
        if self.width is not None:
            result['width'] = self.width
        if self.type is not None:
            result['type'] = self.type
        if self.data is not None:
            result['data'] = self.data
        if self.transparent_flag is not None:
            result['transparent_flag'] = self.transparent_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('alias') is not None:
            self.alias = m.get('alias')
        if m.get('height') is not None:
            self.height = m.get('height')
        if m.get('width') is not None:
            self.width = m.get('width')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('transparent_flag') is not None:
            self.transparent_flag = m.get('transparent_flag')
        return self


class CreateContractAccountsealimageResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        file_key: str = None,
        seal_id: str = None,
        url: str = None,
        height: int = None,
        width: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 印章fileKey
        self.file_key = file_key
        # 印章id
        self.seal_id = seal_id
        # 印章下载地址, 有效时间1小时
        self.url = url
        # 印章高度
        self.height = height
        # 印章宽度
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.file_key is not None:
            result['file_key'] = self.file_key
        if self.seal_id is not None:
            result['seal_id'] = self.seal_id
        if self.url is not None:
            result['url'] = self.url
        if self.height is not None:
            result['height'] = self.height
        if self.width is not None:
            result['width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('file_key') is not None:
            self.file_key = m.get('file_key')
        if m.get('seal_id') is not None:
            self.seal_id = m.get('seal_id')
        if m.get('url') is not None:
            self.url = m.get('url')
        if m.get('height') is not None:
            self.height = m.get('height')
        if m.get('width') is not None:
            self.width = m.get('width')
        return self


class GetContractFileuploadurlRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        content_md_5: str = None,
        content_type: str = None,
        convert_2pdf: str = None,
        file_size: int = None,
        file_name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 所属账号id，即个人账号id或机构账号id，如不传，则默认属于对接平台
        self.account_id = account_id
        # 先计算文件md5值，在对该md5值进行base64编码
        self.content_md_5 = content_md_5
        # 目标文件的MIME类型
        self.content_type = content_type
        # 是否转换成pdf文档，默认false，代表不做转换。转换是异步行为，如果指定要转换，需要调用查询文件信息接口查询状态，转换完成后才可使用。
        self.convert_2pdf = convert_2pdf
        # 文件大小，单位byte
        self.file_size = file_size
        # 文件名称（必须带上文件扩展名，不然会导致后续发起流程校验过不去 示例：合同.pdf ）
        self.file_name = file_name

    def validate(self):
        self.validate_required(self.content_md_5, 'content_md_5')
        self.validate_required(self.content_type, 'content_type')
        self.validate_required(self.convert_2pdf, 'convert_2pdf')
        self.validate_required(self.file_size, 'file_size')
        self.validate_required(self.file_name, 'file_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.content_md_5 is not None:
            result['content_md5'] = self.content_md_5
        if self.content_type is not None:
            result['content_type'] = self.content_type
        if self.convert_2pdf is not None:
            result['convert_2_pdf'] = self.convert_2pdf
        if self.file_size is not None:
            result['file_size'] = self.file_size
        if self.file_name is not None:
            result['file_name'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('content_md5') is not None:
            self.content_md_5 = m.get('content_md5')
        if m.get('content_type') is not None:
            self.content_type = m.get('content_type')
        if m.get('convert_2_pdf') is not None:
            self.convert_2pdf = m.get('convert_2_pdf')
        if m.get('file_size') is not None:
            self.file_size = m.get('file_size')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        return self


class GetContractFileuploadurlResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        file_id: str = None,
        message: str = None,
        upload_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 文件Id
        self.file_id = file_id
        # 业务码信息
        self.message = message
        # 文件直传地址, 可以重复使用，但是只能传一样的文件，有效期一小时
        self.upload_url = upload_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.message is not None:
            result['message'] = self.message
        if self.upload_url is not None:
            result['upload_url'] = self.upload_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('upload_url') is not None:
            self.upload_url = m.get('upload_url')
        return self


class AddContractPlatformsignfieldsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        signfields: ContractPlatformSignFieldApplication = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 流程id
        self.flow_id = flow_id
        # 签署区列表数据
        self.signfields = signfields

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.signfields, 'signfields')
        if self.signfields:
            self.signfields.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.signfields is not None:
            result['signfields'] = self.signfields.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('signfields') is not None:
            temp_model = ContractPlatformSignFieldApplication()
            self.signfields = temp_model.from_map(m['signfields'])
        return self


class AddContractPlatformsignfieldsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        signfields: List[ContractSignField] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 签署区列表数据
        self.signfields = signfields

    def validate(self):
        if self.signfields:
            for k in self.signfields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['signfields'] = []
        if self.signfields is not None:
            for k in self.signfields:
                result['signfields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.signfields = []
        if m.get('signfields') is not None:
            for k in m.get('signfields'):
                temp_model = ContractSignField()
                self.signfields.append(temp_model.from_map(k))
        return self


class GetContractFileRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 文件id
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_id is not None:
            result['file_id'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        return self


class GetContractFileResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        file_id: str = None,
        name: str = None,
        download_url: str = None,
        size: int = None,
        status: int = None,
        pdf_total_pages: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 文件id
        self.file_id = file_id
        # 文件名称
        self.name = name
        # 下载地址
        self.download_url = download_url
        # 文件大小，单位byte
        self.size = size
        # 文件状态, 0:文件未上传；1:文件上传中 ；2：文件上传已完成,；3：文件上传失败 ；4：文件等待转pdf ；5：文件已转换pdf 。
        self.status = status
        # pdf文件总页数,仅当文件类型为pdf时有值
        self.pdf_total_pages = pdf_total_pages

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.name is not None:
            result['name'] = self.name
        if self.download_url is not None:
            result['download_url'] = self.download_url
        if self.size is not None:
            result['size'] = self.size
        if self.status is not None:
            result['status'] = self.status
        if self.pdf_total_pages is not None:
            result['pdf_total_pages'] = self.pdf_total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('download_url') is not None:
            self.download_url = m.get('download_url')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('pdf_total_pages') is not None:
            self.pdf_total_pages = m.get('pdf_total_pages')
        return self


class QueryContractAccountsealsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        offset: int = None,
        size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用户id
        self.account_id = account_id
        # 分页起始位置
        self.offset = offset
        # 单页数量
        self.size = size

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.offset, 'offset')
        self.validate_required(self.size, 'size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.offset is not None:
            result['offset'] = self.offset
        if self.size is not None:
            result['size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('offset') is not None:
            self.offset = m.get('offset')
        if m.get('size') is not None:
            self.size = m.get('size')
        return self


class QueryContractAccountsealsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        total: int = None,
        seals: List[ContractSeal] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 查询总数
        self.total = total
        # 印章列表
        self.seals = seals

    def validate(self):
        if self.seals:
            for k in self.seals:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.total is not None:
            result['total'] = self.total
        result['seals'] = []
        if self.seals is not None:
            for k in self.seals:
                result['seals'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('total') is not None:
            self.total = m.get('total')
        self.seals = []
        if m.get('seals') is not None:
            for k in m.get('seals'):
                temp_model = ContractSeal()
                self.seals.append(temp_model.from_map(k))
        return self


class QueryContractOrganizationsealsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        org_id: str = None,
        offset: int = None,
        size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 机构id
        self.org_id = org_id
        # 分页起始位置
        self.offset = offset
        # 单页数量
        self.size = size

    def validate(self):
        self.validate_required(self.org_id, 'org_id')
        self.validate_required(self.offset, 'offset')
        self.validate_required(self.size, 'size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.org_id is not None:
            result['org_id'] = self.org_id
        if self.offset is not None:
            result['offset'] = self.offset
        if self.size is not None:
            result['size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('org_id') is not None:
            self.org_id = m.get('org_id')
        if m.get('offset') is not None:
            self.offset = m.get('offset')
        if m.get('size') is not None:
            self.size = m.get('size')
        return self


class QueryContractOrganizationsealsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        total: int = None,
        seals: List[ContractSeal] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 查询总数
        self.total = total
        # 印章列表
        self.seals = seals

    def validate(self):
        if self.seals:
            for k in self.seals:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.total is not None:
            result['total'] = self.total
        result['seals'] = []
        if self.seals is not None:
            for k in self.seals:
                result['seals'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('total') is not None:
            self.total = m.get('total')
        self.seals = []
        if m.get('seals') is not None:
            for k in m.get('seals'):
                temp_model = ContractSeal()
                self.seals.append(temp_model.from_map(k))
        return self


class QueryContractFlowsignerRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 流程id
        self.flow_id = flow_id

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        return self


class QueryContractFlowsignerResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        signers: List[ContractFlowSigner] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 签字人列表
        self.signers = signers

    def validate(self):
        if self.signers:
            for k in self.signers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['signers'] = []
        if self.signers is not None:
            for k in self.signers:
                result['signers'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.signers = []
        if m.get('signers') is not None:
            for k in m.get('signers'):
                temp_model = ContractFlowSigner()
                self.signers.append(temp_model.from_map(k))
        return self


class QueryContractSignfieldsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        account_id: str = None,
        signfield_ids: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 流程id
        self.flow_id = flow_id
        # 账号id，默认所有签署人
        self.account_id = account_id
        # 指定签署区id列表，逗号分割，默认所有签署区
        self.signfield_ids = signfield_ids

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.signfield_ids is not None:
            result['signfield_ids'] = self.signfield_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('signfield_ids') is not None:
            self.signfield_ids = m.get('signfield_ids')
        return self


class QueryContractSignfieldsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        signfields: List[ContractSignFieldDetail] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 签署区列表数据
        self.signfields = signfields

    def validate(self):
        if self.signfields:
            for k in self.signfields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['signfields'] = []
        if self.signfields is not None:
            for k in self.signfields:
                result['signfields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.signfields = []
        if m.get('signfields') is not None:
            for k in m.get('signfields'):
                temp_model = ContractSignFieldDetail()
                self.signfields.append(temp_model.from_map(k))
        return self


class QueryContractAccountRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 个人账号id
        self.account_id = account_id

    def validate(self):
        self.validate_required(self.account_id, 'account_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        return self


class QueryContractAccountResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        account_id: str = None,
        name: str = None,
        id_type: str = None,
        id_number: str = None,
        mobile: str = None,
        email: str = None,
        third_party_user_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 个人账号id
        self.account_id = account_id
        # 姓名
        self.name = name
        # 证件类型，详见个人证件类型说明
        self.id_type = id_type
        # 证件号
        self.id_number = id_number
        # 联系方式，手机号码
        self.mobile = mobile
        # 联系方式，邮箱地址
        self.email = email
        # 第三方平台的用户id
        self.third_party_user_id = third_party_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.name is not None:
            result['name'] = self.name
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.email is not None:
            result['email'] = self.email
        if self.third_party_user_id is not None:
            result['third_party_user_id'] = self.third_party_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('third_party_user_id') is not None:
            self.third_party_user_id = m.get('third_party_user_id')
        return self


class QueryContractOrganizationRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        org_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 机构账号id
        self.org_id = org_id

    def validate(self):
        self.validate_required(self.org_id, 'org_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.org_id is not None:
            result['org_id'] = self.org_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('org_id') is not None:
            self.org_id = m.get('org_id')
        return self


class QueryContractOrganizationResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        org_id: str = None,
        name: str = None,
        id_type: str = None,
        id_number: str = None,
        org_legal_id_number: str = None,
        org_legal_name: str = None,
        third_party_user_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 机构账号Id
        self.org_id = org_id
        # 机构名称
        self.name = name
        # 证件类型，详见机构证件类型说明
        self.id_type = id_type
        # 证件号
        self.id_number = id_number
        # 企业法人证件号
        self.org_legal_id_number = org_legal_id_number
        # 企业法人名称
        self.org_legal_name = org_legal_name
        # 第三方平台的机构id
        self.third_party_user_id = third_party_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.org_id is not None:
            result['org_id'] = self.org_id
        if self.name is not None:
            result['name'] = self.name
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.org_legal_id_number is not None:
            result['org_legal_id_number'] = self.org_legal_id_number
        if self.org_legal_name is not None:
            result['org_legal_name'] = self.org_legal_name
        if self.third_party_user_id is not None:
            result['third_party_user_id'] = self.third_party_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('org_id') is not None:
            self.org_id = m.get('org_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('org_legal_id_number') is not None:
            self.org_legal_id_number = m.get('org_legal_id_number')
        if m.get('org_legal_name') is not None:
            self.org_legal_name = m.get('org_legal_name')
        if m.get('third_party_user_id') is not None:
            self.third_party_user_id = m.get('third_party_user_id')
        return self


class QueryContractTemplateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        template_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 模板id
        self.template_id = template_id

    def validate(self):
        self.validate_required(self.template_id, 'template_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.template_id is not None:
            result['template_id'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        return self


class QueryContractTemplateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        create_time: int = None,
        download_url: str = None,
        file_size: int = None,
        message: str = None,
        struct_components: List[ContractTemplateStructComponent] = None,
        template_id: str = None,
        template_name: str = None,
        update_time: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 创建时间
        self.create_time = create_time
        # 模板文件下载地址
        self.download_url = download_url
        # 模板文件大小
        self.file_size = file_size
        # 业务码信息
        self.message = message
        # 文件模板中的输入项组件列表
        self.struct_components = struct_components
        # 模板id
        self.template_id = template_id
        # 模板名称
        self.template_name = template_name
        # 更新时间
        self.update_time = update_time

    def validate(self):
        if self.struct_components:
            for k in self.struct_components:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.create_time is not None:
            result['create_time'] = self.create_time
        if self.download_url is not None:
            result['download_url'] = self.download_url
        if self.file_size is not None:
            result['file_size'] = self.file_size
        if self.message is not None:
            result['message'] = self.message
        result['struct_components'] = []
        if self.struct_components is not None:
            for k in self.struct_components:
                result['struct_components'].append(k.to_map() if k else None)
        if self.template_id is not None:
            result['template_id'] = self.template_id
        if self.template_name is not None:
            result['template_name'] = self.template_name
        if self.update_time is not None:
            result['update_time'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('create_time') is not None:
            self.create_time = m.get('create_time')
        if m.get('download_url') is not None:
            self.download_url = m.get('download_url')
        if m.get('file_size') is not None:
            self.file_size = m.get('file_size')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.struct_components = []
        if m.get('struct_components') is not None:
            for k in m.get('struct_components'):
                temp_model = ContractTemplateStructComponent()
                self.struct_components.append(temp_model.from_map(k))
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        if m.get('template_name') is not None:
            self.template_name = m.get('template_name')
        if m.get('update_time') is not None:
            self.update_time = m.get('update_time')
        return self


class CreateContractSignflowRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        auto_archive: bool = None,
        auto_deduction_force: bool = None,
        business_scene: str = None,
        contract_sign_flow_config: ContractSignFlowConfig = None,
        initiator_account_id: str = None,
        initiator_authorized_account_id: str = None,
        repayment_order_info: List[RepaymentOrderRequest] = None,
        sign_platform: str = None,
        sign_validity: int = None,
        payer_tuid: str = None,
        payee_tuid: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 是否自动归档，默认false 如设置为true，则在流程开启后，当所有签署人签署完毕，系统自动将流程归档，状态变为“已完成”状态，在流程状态为“已完成”前，可随时添加签署人；如设置为false，则在调用流程开启后，需主动调用签署流程归档接口，将流程状态变更为“已完成”，归档前可随时添加签署人；已完成的流程才可下载签署后的文件
        self.auto_archive = auto_archive
        # 是否强制代扣
        self.auto_deduction_force = auto_deduction_force
        # 文件主题
        self.business_scene = business_scene
        # 任务配置信息
        self.contract_sign_flow_config = contract_sign_flow_config
        # 发起人账户id，即发起本次签署的操作人个人账号id；如不传，默认由对接平台发起
        self.initiator_account_id = initiator_account_id
        # 发起方主体id，如存在个人代机构发起签约，则需传入机构id；如不传，则默认是对接平台
        self.initiator_authorized_account_id = initiator_authorized_account_id
        # 代扣规则详情
        self.repayment_order_info = repayment_order_info
        # 签署平台，ALIPAY（支付宝小程序）或H5
        self.sign_platform = sign_platform
        # 签署有效截止日期，毫秒，默认3天失效
        self.sign_validity = sign_validity
        # 付款方ID（个人）
        self.payer_tuid = payer_tuid
        # 收款方ID(机构)
        self.payee_tuid = payee_tuid

    def validate(self):
        self.validate_required(self.business_scene, 'business_scene')
        if self.contract_sign_flow_config:
            self.contract_sign_flow_config.validate()
        if self.repayment_order_info:
            for k in self.repayment_order_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.auto_archive is not None:
            result['auto_archive'] = self.auto_archive
        if self.auto_deduction_force is not None:
            result['auto_deduction_force'] = self.auto_deduction_force
        if self.business_scene is not None:
            result['business_scene'] = self.business_scene
        if self.contract_sign_flow_config is not None:
            result['contract_sign_flow_config'] = self.contract_sign_flow_config.to_map()
        if self.initiator_account_id is not None:
            result['initiator_account_id'] = self.initiator_account_id
        if self.initiator_authorized_account_id is not None:
            result['initiator_authorized_account_id'] = self.initiator_authorized_account_id
        result['repayment_order_info'] = []
        if self.repayment_order_info is not None:
            for k in self.repayment_order_info:
                result['repayment_order_info'].append(k.to_map() if k else None)
        if self.sign_platform is not None:
            result['sign_platform'] = self.sign_platform
        if self.sign_validity is not None:
            result['sign_validity'] = self.sign_validity
        if self.payer_tuid is not None:
            result['payer_tuid'] = self.payer_tuid
        if self.payee_tuid is not None:
            result['payee_tuid'] = self.payee_tuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('auto_archive') is not None:
            self.auto_archive = m.get('auto_archive')
        if m.get('auto_deduction_force') is not None:
            self.auto_deduction_force = m.get('auto_deduction_force')
        if m.get('business_scene') is not None:
            self.business_scene = m.get('business_scene')
        if m.get('contract_sign_flow_config') is not None:
            temp_model = ContractSignFlowConfig()
            self.contract_sign_flow_config = temp_model.from_map(m['contract_sign_flow_config'])
        if m.get('initiator_account_id') is not None:
            self.initiator_account_id = m.get('initiator_account_id')
        if m.get('initiator_authorized_account_id') is not None:
            self.initiator_authorized_account_id = m.get('initiator_authorized_account_id')
        self.repayment_order_info = []
        if m.get('repayment_order_info') is not None:
            for k in m.get('repayment_order_info'):
                temp_model = RepaymentOrderRequest()
                self.repayment_order_info.append(temp_model.from_map(k))
        if m.get('sign_platform') is not None:
            self.sign_platform = m.get('sign_platform')
        if m.get('sign_validity') is not None:
            self.sign_validity = m.get('sign_validity')
        if m.get('payer_tuid') is not None:
            self.payer_tuid = m.get('payer_tuid')
        if m.get('payee_tuid') is not None:
            self.payee_tuid = m.get('payee_tuid')
        return self


class CreateContractSignflowResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        flow_id: str = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 签约流程ID
        self.flow_id = flow_id
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateContractRegisterzftRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        address: str = None,
        agent_account_id: str = None,
        alias_name: str = None,
        alipay_logon_id: str = None,
        apply_time: str = None,
        binding_alipay_logon_id: str = None,
        card_alias_no: str = None,
        cert_image: str = None,
        cert_no: str = None,
        cert_type: str = None,
        city_code: str = None,
        contact_email: str = None,
        contact_mobile: str = None,
        contact_name: str = None,
        contact_phone: str = None,
        contact_tag: str = None,
        contact_type: str = None,
        district_code: str = None,
        ext_info: str = None,
        ip_role_id: str = None,
        legal_cert_back_image: str = None,
        legal_cert_front_image: str = None,
        legal_cert_no: str = None,
        legal_name: str = None,
        mcc: str = None,
        merchant_name: str = None,
        merchant_type: str = None,
        name: str = None,
        order_id: str = None,
        out_biz_no: str = None,
        out_door_image: str = None,
        platform_tuid: str = None,
        province_code: str = None,
        service: str = None,
        service_phone: str = None,
        sign_time_with_isv: str = None,
        site_name: str = None,
        site_type: str = None,
        site_url: str = None,
        smid: str = None,
        status: str = None,
        update: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 地址。商户详细经营地址或人员所在地点
        self.address = address
        # 代理商户的账户。如为isv商家入驻，需要传agent_account_id字段，agent_account_id是isv为商家用户注册返回的机构id
        self.agent_account_id = agent_account_id
        # 商户别名
        self.alias_name = alias_name
        # 商户支付宝账户
        self.alipay_logon_id = alipay_logon_id
        # 申请时间
        self.apply_time = apply_time
        # 二级商户支付宝账户，用于协议确认。目前商业场景（除医疗、中小学教育等）下必填。本字段要求与商户名称name同名，且是实名认证支付宝账户
        self.binding_alipay_logon_id = binding_alipay_logon_id
        # 结算卡id
        self.card_alias_no = card_alias_no
        # 营业执照图片url，本业务接口中，如果是特殊行业必填。其值为使用ant.merchant.expand.indirect.image.upload上传图片得到的一串oss key。
        self.cert_image = cert_image
        # 商户社会信用码
        self.cert_no = cert_no
        # 商户证件类型，取值范围：201：营业执照；2011:营业执照(统一社会信用代码)；204：民办非企业登记证书；206：社会团体法人登记证书；218：事业单位法人证书；219：党政机关批准设立文件/行政执法主体资格证；100：个人商户身份证
        self.cert_type = cert_type
        # 城市编码。请按照https://gw.alipayobjects.com/os/basement_prod/253c4dcb-b8a4-4a1e-8be2-79e191a9b6db.xlsx 表格中内容填写。
        # （参考资料：
        # http://www.stats.gov.cn/tjsj/tjbz/tjyqhdmhcxhfdm/）
        self.city_code = city_code
        # 电子邮箱
        self.contact_email = contact_email
        # 商户联系人信息
        self.contact_mobile = contact_mobile
        # 联系人名字
        self.contact_name = contact_name
        # 商户联系人电话信息
        self.contact_phone = contact_phone
        # 商户联系人业务标识枚举，表示商户联系人的职责。异议处理接口人:02;商户关键联系人:06;数据反馈接口人:11;服务联动接口人:08
        self.contact_tag = contact_tag
        # 联系人类型，取值范围：LEGAL_PERSON：法人；CONTROLLER：实际控制人；AGENT：代理人；OTHER：其他
        self.contact_type = contact_type
        # 区县编码。请按照https://gw.alipayobjects.com/os/basement_prod/253c4dcb-b8a4-4a1e-8be2-79e191a9b6db.xlsx 表格中内容填写。
        # （参考资料：
        # http://www.stats.gov.cn/tjsj/tjbz/tjyqhdmhcxhfdm/）
        self.district_code = district_code
        # 返回申请单相关参数。当前返回内容有cardAliasNo，smid
        self.ext_info = ext_info
        # 商户角色id。审核通过后生成。间连商户或平台商二级商户业务中，本字段表示smid
        self.ip_role_id = ip_role_id
        # 法人身份证反面url，其值为使用ant.merchant.expand.indirect.image.upload上传图片得到的一串oss key。本业务接口中，如果是特殊行业必填
        self.legal_cert_back_image = legal_cert_back_image
        # 法人身份证正面url，其值为使用ant.merchant.expand.indirect.image.upload上传图片得到的一串oss key。本业务接口中，如果是特殊行业必填
        self.legal_cert_front_image = legal_cert_front_image
        # 法人身份证号
        self.legal_cert_no = legal_cert_no
        # 法人名称
        self.legal_name = legal_name
        # 商户类别码mcc，参见附件描述中的“类目code” https://gw.alipayobjects.com/os/basement_prod/82cb70f7-abbd-417a-91ba-73c1849f07ea.xlsx 如果要求资质一栏不为空，表明是特殊行业，会有人工审核。注：文档更新可能有滞后性，以实际为准
        self.mcc = mcc
        # 蚂蚁金服（杭*****术有限公司
        self.merchant_name = merchant_name
        # 商家类型：01：企业；02：事业单位；03：民办非企业组织；04：社会团体；05：党政及国家机关；06：个人商户；07：个体工商户
        self.merchant_type = merchant_type
        # 商户名称
        self.name = name
        # 申请单id
        self.order_id = order_id
        # 外部业务号。比如某种业务标准外部订单号,比如交易外部订单号，代表服务商端自己订单号。用于做并发控制，防止一笔外部订单发起两次进件。非必要场景禁止传入本字段，如要使用务必理清场景及字段生成规则，与蚂蚁金服对接人咨询。
        self.out_biz_no = out_biz_no
        # 门头照，其值为使用ant.merchant.expand.indirect.image.upload上传图片得到的一串oss key。如果使用当面付服务则必填
        self.out_door_image = out_door_image
        # 商户在智能合同平台唯一id
        self.platform_tuid = platform_tuid
        # 省份编码。请按照https://gw.alipayobjects.com/os/basement_prod/253c4dcb-b8a4-4a1e-8be2-79e191a9b6db.xlsx 表格中内容填写。
        # （参考资料：
        # http://www.stats.gov.cn/tjsj/tjbz/tjyqhdmhcxhfdm/）
        self.province_code = province_code
        # 商户使用服务，可选值有：当面付、app支付、wap支付、电脑支付
        self.service = service
        # 客服电话
        self.service_phone = service_phone
        # 二级商户与服务商的签约时间
        self.sign_time_with_isv = sign_time_with_isv
        # 站点名称
        self.site_name = site_name
        # 网站：01
        # APP : 02
        # 服务窗:03
        # 公众号:04
        # 其他:05
        # 支付宝小程序:06
        self.site_type = site_type
        # 站点地址
        self.site_url = site_url
        # 二级商户id
        self.smid = smid
        # 申请单状态。99:已完结;-1:失败;031:已提交审核
        self.status = status
        # 0表示不更新，1表示强制更新
        self.update = update

    def validate(self):
        self.validate_required(self.address, 'address')
        self.validate_required(self.alias_name, 'alias_name')
        self.validate_required(self.alipay_logon_id, 'alipay_logon_id')
        self.validate_required(self.apply_time, 'apply_time')
        if self.apply_time is not None:
            self.validate_pattern(self.apply_time, 'apply_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.binding_alipay_logon_id, 'binding_alipay_logon_id')
        self.validate_required(self.cert_image, 'cert_image')
        self.validate_required(self.cert_no, 'cert_no')
        self.validate_required(self.cert_type, 'cert_type')
        self.validate_required(self.city_code, 'city_code')
        self.validate_required(self.contact_email, 'contact_email')
        self.validate_required(self.contact_mobile, 'contact_mobile')
        self.validate_required(self.contact_name, 'contact_name')
        self.validate_required(self.contact_phone, 'contact_phone')
        self.validate_required(self.contact_tag, 'contact_tag')
        self.validate_required(self.contact_type, 'contact_type')
        self.validate_required(self.district_code, 'district_code')
        self.validate_required(self.ext_info, 'ext_info')
        self.validate_required(self.ip_role_id, 'ip_role_id')
        self.validate_required(self.legal_cert_back_image, 'legal_cert_back_image')
        self.validate_required(self.legal_cert_front_image, 'legal_cert_front_image')
        self.validate_required(self.legal_cert_no, 'legal_cert_no')
        self.validate_required(self.legal_name, 'legal_name')
        self.validate_required(self.mcc, 'mcc')
        self.validate_required(self.merchant_name, 'merchant_name')
        self.validate_required(self.merchant_type, 'merchant_type')
        self.validate_required(self.name, 'name')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.out_door_image, 'out_door_image')
        self.validate_required(self.platform_tuid, 'platform_tuid')
        self.validate_required(self.province_code, 'province_code')
        self.validate_required(self.service, 'service')
        self.validate_required(self.service_phone, 'service_phone')
        self.validate_required(self.sign_time_with_isv, 'sign_time_with_isv')
        self.validate_required(self.site_name, 'site_name')
        self.validate_required(self.site_type, 'site_type')
        self.validate_required(self.site_url, 'site_url')
        self.validate_required(self.smid, 'smid')
        self.validate_required(self.status, 'status')
        self.validate_required(self.update, 'update')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.address is not None:
            result['address'] = self.address
        if self.agent_account_id is not None:
            result['agent_account_id'] = self.agent_account_id
        if self.alias_name is not None:
            result['alias_name'] = self.alias_name
        if self.alipay_logon_id is not None:
            result['alipay_logon_id'] = self.alipay_logon_id
        if self.apply_time is not None:
            result['apply_time'] = self.apply_time
        if self.binding_alipay_logon_id is not None:
            result['binding_alipay_logon_id'] = self.binding_alipay_logon_id
        if self.card_alias_no is not None:
            result['card_alias_no'] = self.card_alias_no
        if self.cert_image is not None:
            result['cert_image'] = self.cert_image
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.contact_email is not None:
            result['contact_email'] = self.contact_email
        if self.contact_mobile is not None:
            result['contact_mobile'] = self.contact_mobile
        if self.contact_name is not None:
            result['contact_name'] = self.contact_name
        if self.contact_phone is not None:
            result['contact_phone'] = self.contact_phone
        if self.contact_tag is not None:
            result['contact_tag'] = self.contact_tag
        if self.contact_type is not None:
            result['contact_type'] = self.contact_type
        if self.district_code is not None:
            result['district_code'] = self.district_code
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        if self.ip_role_id is not None:
            result['ip_role_id'] = self.ip_role_id
        if self.legal_cert_back_image is not None:
            result['legal_cert_back_image'] = self.legal_cert_back_image
        if self.legal_cert_front_image is not None:
            result['legal_cert_front_image'] = self.legal_cert_front_image
        if self.legal_cert_no is not None:
            result['legal_cert_no'] = self.legal_cert_no
        if self.legal_name is not None:
            result['legal_name'] = self.legal_name
        if self.mcc is not None:
            result['mcc'] = self.mcc
        if self.merchant_name is not None:
            result['merchant_name'] = self.merchant_name
        if self.merchant_type is not None:
            result['merchant_type'] = self.merchant_type
        if self.name is not None:
            result['name'] = self.name
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.out_door_image is not None:
            result['out_door_image'] = self.out_door_image
        if self.platform_tuid is not None:
            result['platform_tuid'] = self.platform_tuid
        if self.province_code is not None:
            result['province_code'] = self.province_code
        if self.service is not None:
            result['service'] = self.service
        if self.service_phone is not None:
            result['service_phone'] = self.service_phone
        if self.sign_time_with_isv is not None:
            result['sign_time_with_isv'] = self.sign_time_with_isv
        if self.site_name is not None:
            result['site_name'] = self.site_name
        if self.site_type is not None:
            result['site_type'] = self.site_type
        if self.site_url is not None:
            result['site_url'] = self.site_url
        if self.smid is not None:
            result['smid'] = self.smid
        if self.status is not None:
            result['status'] = self.status
        if self.update is not None:
            result['update'] = self.update
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('agent_account_id') is not None:
            self.agent_account_id = m.get('agent_account_id')
        if m.get('alias_name') is not None:
            self.alias_name = m.get('alias_name')
        if m.get('alipay_logon_id') is not None:
            self.alipay_logon_id = m.get('alipay_logon_id')
        if m.get('apply_time') is not None:
            self.apply_time = m.get('apply_time')
        if m.get('binding_alipay_logon_id') is not None:
            self.binding_alipay_logon_id = m.get('binding_alipay_logon_id')
        if m.get('card_alias_no') is not None:
            self.card_alias_no = m.get('card_alias_no')
        if m.get('cert_image') is not None:
            self.cert_image = m.get('cert_image')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('contact_email') is not None:
            self.contact_email = m.get('contact_email')
        if m.get('contact_mobile') is not None:
            self.contact_mobile = m.get('contact_mobile')
        if m.get('contact_name') is not None:
            self.contact_name = m.get('contact_name')
        if m.get('contact_phone') is not None:
            self.contact_phone = m.get('contact_phone')
        if m.get('contact_tag') is not None:
            self.contact_tag = m.get('contact_tag')
        if m.get('contact_type') is not None:
            self.contact_type = m.get('contact_type')
        if m.get('district_code') is not None:
            self.district_code = m.get('district_code')
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        if m.get('ip_role_id') is not None:
            self.ip_role_id = m.get('ip_role_id')
        if m.get('legal_cert_back_image') is not None:
            self.legal_cert_back_image = m.get('legal_cert_back_image')
        if m.get('legal_cert_front_image') is not None:
            self.legal_cert_front_image = m.get('legal_cert_front_image')
        if m.get('legal_cert_no') is not None:
            self.legal_cert_no = m.get('legal_cert_no')
        if m.get('legal_name') is not None:
            self.legal_name = m.get('legal_name')
        if m.get('mcc') is not None:
            self.mcc = m.get('mcc')
        if m.get('merchant_name') is not None:
            self.merchant_name = m.get('merchant_name')
        if m.get('merchant_type') is not None:
            self.merchant_type = m.get('merchant_type')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('out_door_image') is not None:
            self.out_door_image = m.get('out_door_image')
        if m.get('platform_tuid') is not None:
            self.platform_tuid = m.get('platform_tuid')
        if m.get('province_code') is not None:
            self.province_code = m.get('province_code')
        if m.get('service') is not None:
            self.service = m.get('service')
        if m.get('service_phone') is not None:
            self.service_phone = m.get('service_phone')
        if m.get('sign_time_with_isv') is not None:
            self.sign_time_with_isv = m.get('sign_time_with_isv')
        if m.get('site_name') is not None:
            self.site_name = m.get('site_name')
        if m.get('site_type') is not None:
            self.site_type = m.get('site_type')
        if m.get('site_url') is not None:
            self.site_url = m.get('site_url')
        if m.get('smid') is not None:
            self.smid = m.get('smid')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('update') is not None:
            self.update = m.get('update')
        return self


class CreateContractRegisterzftResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误码
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        return self


class CreateContractPlatformtemplateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        auto_deduction: bool = None,
        content_md_5: str = None,
        content_type: str = None,
        convert_2pdf: bool = None,
        file_name: str = None,
        sign_fields: List[ContractPlatformSignField] = None,
        user_sign_pages: List[int] = None,
        auto_deduction_force: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 是否包含代扣规则，如果设置为true，则在创建手动签署流程时，必须传入代扣规则。默认为false
        self.auto_deduction = auto_deduction
        # Base64编码的模板文件的MD5值
        self.content_md_5 = content_md_5
        # 目标文件的MIME类型
        self.content_type = content_type
        # 是否需要转成pdf，如果模板文件为.doc/.docx 传true，为pdf传false
        self.convert_2pdf = convert_2pdf
        # 文件名称，必须带扩展名如:.pdf,.doc,.docx
        self.file_name = file_name
        # 平台方的签署信息列表
        self.sign_fields = sign_fields
        # 用户需要签章的页面列表（默认为最后一页）
        self.user_sign_pages = user_sign_pages
        # 是否强制用户选择代扣
        self.auto_deduction_force = auto_deduction_force

    def validate(self):
        self.validate_required(self.content_md_5, 'content_md_5')
        self.validate_required(self.content_type, 'content_type')
        self.validate_required(self.convert_2pdf, 'convert_2pdf')
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.sign_fields, 'sign_fields')
        if self.sign_fields:
            for k in self.sign_fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.auto_deduction is not None:
            result['auto_deduction'] = self.auto_deduction
        if self.content_md_5 is not None:
            result['content_md5'] = self.content_md_5
        if self.content_type is not None:
            result['content_type'] = self.content_type
        if self.convert_2pdf is not None:
            result['convert2_pdf'] = self.convert_2pdf
        if self.file_name is not None:
            result['file_name'] = self.file_name
        result['sign_fields'] = []
        if self.sign_fields is not None:
            for k in self.sign_fields:
                result['sign_fields'].append(k.to_map() if k else None)
        if self.user_sign_pages is not None:
            result['user_sign_pages'] = self.user_sign_pages
        if self.auto_deduction_force is not None:
            result['auto_deduction_force'] = self.auto_deduction_force
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('auto_deduction') is not None:
            self.auto_deduction = m.get('auto_deduction')
        if m.get('content_md5') is not None:
            self.content_md_5 = m.get('content_md5')
        if m.get('content_type') is not None:
            self.content_type = m.get('content_type')
        if m.get('convert2_pdf') is not None:
            self.convert_2pdf = m.get('convert2_pdf')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        self.sign_fields = []
        if m.get('sign_fields') is not None:
            for k in m.get('sign_fields'):
                temp_model = ContractPlatformSignField()
                self.sign_fields.append(temp_model.from_map(k))
        if m.get('user_sign_pages') is not None:
            self.user_sign_pages = m.get('user_sign_pages')
        if m.get('auto_deduction_force') is not None:
            self.auto_deduction_force = m.get('auto_deduction_force')
        return self


class CreateContractPlatformtemplateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        template_id: str = None,
        upload_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 模板ID
        self.template_id = template_id
        # 文件直传地址，需要用此上传地址使用put方式上传文件，只有文件上传后模板才可用
        self.upload_url = upload_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.template_id is not None:
            result['template_id'] = self.template_id
        if self.upload_url is not None:
            result['upload_url'] = self.upload_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        if m.get('upload_url') is not None:
            self.upload_url = m.get('upload_url')
        return self


class QueryContractMerchantzftRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        agent_account_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 代理商户账户
        self.agent_account_id = agent_account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.agent_account_id is not None:
            result['agent_account_id'] = self.agent_account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('agent_account_id') is not None:
            self.agent_account_id = m.get('agent_account_id')
        return self


class QueryContractMerchantzftResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        data: str = None,
        err_message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 0表示成功，其他为失败
        self.code = code
        # 商户入驻查询信息
        self.data = data
        # 错误信息描述
        self.err_message = err_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data
        if self.err_message is not None:
            result['err_message'] = self.err_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('err_message') is not None:
            self.err_message = m.get('err_message')
        return self


class ListContractOuttradeidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        page_index: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 合同id
        self.flow_id = flow_id
        # 分页第几页
        self.page_index = page_index
        # 每页的大小
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.page_index, 'page_index')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.page_index is not None:
            result['page_index'] = self.page_index
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('page_index') is not None:
            self.page_index = m.get('page_index')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class ListContractOuttradeidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        err_message: str = None,
        total: int = None,
        out_trade_no: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误码
        self.code = code
        # 错误信息描述
        self.err_message = err_message
        # 总符合条件的交易个数
        self.total = total
        # 所有符合条件交易相关的id
        self.out_trade_no = out_trade_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.err_message is not None:
            result['err_message'] = self.err_message
        if self.total is not None:
            result['total'] = self.total
        if self.out_trade_no is not None:
            result['out_trade_no'] = self.out_trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('err_message') is not None:
            self.err_message = m.get('err_message')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('out_trade_no') is not None:
            self.out_trade_no = m.get('out_trade_no')
        return self


class QueryContractTradedetailRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        out_trade_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 合同id
        self.flow_id = flow_id
        # out_trade_no
        self.out_trade_no = out_trade_no

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.out_trade_no, 'out_trade_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.out_trade_no is not None:
            result['out_trade_no'] = self.out_trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('out_trade_no') is not None:
            self.out_trade_no = m.get('out_trade_no')
        return self


class QueryContractTradedetailResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        data: str = None,
        err_message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误码
        self.code = code
        # 订单详情
        self.data = data
        # 错误信息描述
        self.err_message = err_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data
        if self.err_message is not None:
            result['err_message'] = self.err_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('err_message') is not None:
            self.err_message = m.get('err_message')
        return self


class CreateContractMerchantrefundRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        out_request_no: str = None,
        out_trade_no: str = None,
        refund_amount: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 合同id
        self.flow_id = flow_id
        # 退款请求对应的第三方ID（也叫退款ID），需保证同一平台方下唯一
        self.out_request_no = out_request_no
        # 订单id
        self.out_trade_no = out_trade_no
        # 退款金额（单位：分）
        self.refund_amount = refund_amount

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.out_request_no, 'out_request_no')
        self.validate_required(self.out_trade_no, 'out_trade_no')
        self.validate_required(self.refund_amount, 'refund_amount')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.out_request_no is not None:
            result['out_request_no'] = self.out_request_no
        if self.out_trade_no is not None:
            result['out_trade_no'] = self.out_trade_no
        if self.refund_amount is not None:
            result['refund_amount'] = self.refund_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('out_request_no') is not None:
            self.out_request_no = m.get('out_request_no')
        if m.get('out_trade_no') is not None:
            self.out_trade_no = m.get('out_trade_no')
        if m.get('refund_amount') is not None:
            self.refund_amount = m.get('refund_amount')
        return self


class CreateContractMerchantrefundResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        out_request_no: str = None,
        out_trade_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误码
        self.code = code
        # 错误信息描述
        self.message = message
        # 本次请求对应的操作单号
        self.out_request_no = out_request_no
        # 订单id
        self.out_trade_no = out_trade_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.out_request_no is not None:
            result['out_request_no'] = self.out_request_no
        if self.out_trade_no is not None:
            result['out_trade_no'] = self.out_trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('out_request_no') is not None:
            self.out_request_no = m.get('out_request_no')
        if m.get('out_trade_no') is not None:
            self.out_trade_no = m.get('out_trade_no')
        return self


class CreateContractAdminaccountRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        return self


class CreateContractAdminaccountResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        err_message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误码
        self.code = code
        # 错误信息描述
        self.err_message = err_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.err_message is not None:
            result['err_message'] = self.err_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('err_message') is not None:
            self.err_message = m.get('err_message')
        return self


class ListContractTradeidsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        page_index: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 合同id
        self.flow_id = flow_id
        # 1
        self.page_index = page_index
        # 页面大小
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.page_index, 'page_index')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.page_index is not None:
            result['page_index'] = self.page_index
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('page_index') is not None:
            self.page_index = m.get('page_index')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class ListContractTradeidsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        err_message: str = None,
        total: int = None,
        out_trade_no: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 0表示成功
        self.code = code
        # 错误信息描述
        self.err_message = err_message
        # 所有item的个数
        self.total = total
        # 所有满足条件的订单
        self.out_trade_no = out_trade_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.err_message is not None:
            result['err_message'] = self.err_message
        if self.total is not None:
            result['total'] = self.total
        if self.out_trade_no is not None:
            result['out_trade_no'] = self.out_trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('err_message') is not None:
            self.err_message = m.get('err_message')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('out_trade_no') is not None:
            self.out_trade_no = m.get('out_trade_no')
        return self


class CreateContractCommontriggerRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        repayment_order_info: List[RepaymentOrderRequest] = None,
        flow_id: str = None,
        user_tuid: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 代扣规则详情
        self.repayment_order_info = repayment_order_info
        # 合同id
        self.flow_id = flow_id
        # 用户在智能合同平台的身份
        self.user_tuid = user_tuid

    def validate(self):
        self.validate_required(self.repayment_order_info, 'repayment_order_info')
        if self.repayment_order_info:
            for k in self.repayment_order_info:
                if k:
                    k.validate()
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.user_tuid, 'user_tuid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        result['repayment_order_info'] = []
        if self.repayment_order_info is not None:
            for k in self.repayment_order_info:
                result['repayment_order_info'].append(k.to_map() if k else None)
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.user_tuid is not None:
            result['user_tuid'] = self.user_tuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        self.repayment_order_info = []
        if m.get('repayment_order_info') is not None:
            for k in m.get('repayment_order_info'):
                temp_model = RepaymentOrderRequest()
                self.repayment_order_info.append(temp_model.from_map(k))
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('user_tuid') is not None:
            self.user_tuid = m.get('user_tuid')
        return self


class CreateContractCommontriggerResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        err_message: str = None,
        flow_id: str = None,
        platform_tuid: str = None,
        user_tuid: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误码
        self.code = code
        # 错误信息描述
        self.err_message = err_message
        # 合同id
        self.flow_id = flow_id
        # 商户在智能合同平台id
        self.platform_tuid = platform_tuid
        # 用户在智能合同平台的id
        self.user_tuid = user_tuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.err_message is not None:
            result['err_message'] = self.err_message
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.platform_tuid is not None:
            result['platform_tuid'] = self.platform_tuid
        if self.user_tuid is not None:
            result['user_tuid'] = self.user_tuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('err_message') is not None:
            self.err_message = m.get('err_message')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('platform_tuid') is not None:
            self.platform_tuid = m.get('platform_tuid')
        if m.get('user_tuid') is not None:
            self.user_tuid = m.get('user_tuid')
        return self


class CreateContractMerchantindirectzftRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_content: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 入驻材料
        self.biz_content = biz_content

    def validate(self):
        self.validate_required(self.biz_content, 'biz_content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_content is not None:
            result['biz_content'] = self.biz_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_content') is not None:
            self.biz_content = m.get('biz_content')
        return self


class CreateContractMerchantindirectzftResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        body: str = None,
        code: int = None,
        message: str = None,
        order_id: str = None,
        sub_code: str = None,
        sub_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 传入参数内容
        self.body = body
        # 错误码
        self.code = code
        # 错误信息描述
        self.message = message
        # 订单id
        self.order_id = order_id
        # 支付宝返回的二级错误信息
        self.sub_code = sub_code
        # 支付宝返回的二级错误信息描述
        self.sub_msg = sub_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.body is not None:
            result['body'] = self.body
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.sub_code is not None:
            result['sub_code'] = self.sub_code
        if self.sub_msg is not None:
            result['sub_msg'] = self.sub_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('body') is not None:
            self.body = m.get('body')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('sub_code') is not None:
            self.sub_code = m.get('sub_code')
        if m.get('sub_msg') is not None:
            self.sub_msg = m.get('sub_msg')
        return self


class QueryContractMerchantindirectzftRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 商户入驻查询订单id
        self.order_id = order_id

    def validate(self):
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        return self


class QueryContractMerchantindirectzftResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        ext_info: str = None,
        ip_role_id: List[str] = None,
        apply_id: str = None,
        merchant_name: str = None,
        status: str = None,
        sub_code: str = None,
        sub_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误状态码，0表示成功
        self.code = code
        # 错误信息描述
        self.message = message
        # 额外信息，包含smid
        self.ext_info = ext_info
        # 支付宝的ipRoleId
        self.ip_role_id = ip_role_id
        # 申请时间
        self.apply_id = apply_id
        # 商户名称
        self.merchant_name = merchant_name
        # 直付通商户进件的状态
        self.status = status
        # 支付宝返回的错误状态码
        self.sub_code = sub_code
        # 支付宝返回的错误信息描述
        self.sub_msg = sub_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        if self.ip_role_id is not None:
            result['ip_role_id'] = self.ip_role_id
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.merchant_name is not None:
            result['merchant_name'] = self.merchant_name
        if self.status is not None:
            result['status'] = self.status
        if self.sub_code is not None:
            result['sub_code'] = self.sub_code
        if self.sub_msg is not None:
            result['sub_msg'] = self.sub_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        if m.get('ip_role_id') is not None:
            self.ip_role_id = m.get('ip_role_id')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('merchant_name') is not None:
            self.merchant_name = m.get('merchant_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sub_code') is not None:
            self.sub_code = m.get('sub_code')
        if m.get('sub_msg') is not None:
            self.sub_msg = m.get('sub_msg')
        return self


class QueryPayresultfileurlRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bill_date: str = None,
        bill_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 对账日期
        self.bill_date = bill_date
        # 交易类型
        self.bill_type = bill_type

    def validate(self):
        self.validate_required(self.bill_date, 'bill_date')
        self.validate_required(self.bill_type, 'bill_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bill_date is not None:
            result['bill_date'] = self.bill_date
        if self.bill_type is not None:
            result['bill_type'] = self.bill_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bill_date') is not None:
            self.bill_date = m.get('bill_date')
        if m.get('bill_type') is not None:
            self.bill_type = m.get('bill_type')
        return self


class QueryPayresultfileurlResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        pay_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 对账文件的下载地址
        self.pay_url = pay_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.pay_url is not None:
            result['pay_url'] = self.pay_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('pay_url') is not None:
            self.pay_url = m.get('pay_url')
        return self


class CreateContractMerchantimageRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        content: str = None,
        file_name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 图片内容，base64
        self.content = content
        # 图片名称，必须带标准图片后缀
        self.file_name = file_name

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.file_name, 'file_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.content is not None:
            result['content'] = self.content
        if self.file_name is not None:
            result['file_name'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        return self


class CreateContractMerchantimageResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        image_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 图片在oss上的id
        self.image_id = image_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.image_id is not None:
            result['image_id'] = self.image_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('image_id') is not None:
            self.image_id = m.get('image_id')
        return self


class CancelContractPaytradeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 智能合同id
        self.flow_id = flow_id

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        return self


class CancelContractPaytradeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        err_message: str = None,
        canceled_out_trade_no: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误码
        self.code = code
        # 错误信息描述
        self.err_message = err_message
        # 取消的代扣条目
        self.canceled_out_trade_no = canceled_out_trade_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.err_message is not None:
            result['err_message'] = self.err_message
        if self.canceled_out_trade_no is not None:
            result['canceled_out_trade_no'] = self.canceled_out_trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('err_message') is not None:
            self.err_message = m.get('err_message')
        if m.get('canceled_out_trade_no') is not None:
            self.canceled_out_trade_no = m.get('canceled_out_trade_no')
        return self


class CreateContractHandsignflowRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        auto_archive: bool = None,
        business_scene: str = None,
        config_info: ContractSignFlowConfig = None,
        contract_remind: int = None,
        contract_validity: int = None,
        initiator_account_id: str = None,
        initiator_authorized_account_id: str = None,
        sign_validity: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 是否自动归档，默认false。如设置为true，当所有签署人签署完毕，系统自动将流程归档，状态变为“已完成”状态，在流程状态为“已完成”前，可随时添加签署人；如设置为false，则在调用签署流程开启后，需主动调用签署流程归档接口，将流程状态变更为“已完成”，归档前可随时添加签署人；已完成的流程才可下载签署后的文件。
        self.auto_archive = auto_archive
        # 文件主题
        self.business_scene = business_scene
        # 任务配置信息
        self.config_info = config_info
        # 文件到期前，提前多久回调提醒续签，单位为小时，时间区间：1小时——15天（360小时），默认不提醒
        self.contract_remind = contract_remind
        # 文件有效截止日期,毫秒，默认不失效
        self.contract_validity = contract_validity
        # 发起人账户id，即发起本次签署的操作人个人账号id；如不传，默认由对接平台发起
        self.initiator_account_id = initiator_account_id
        # 发起方主体id，如存在个人代机构发起签约，则需传入机构id；如不传，则默认是对接平台
        self.initiator_authorized_account_id = initiator_authorized_account_id
        # 签署有效截止日期,毫秒，默认不失效
        self.sign_validity = sign_validity

    def validate(self):
        self.validate_required(self.business_scene, 'business_scene')
        if self.config_info:
            self.config_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.auto_archive is not None:
            result['auto_archive'] = self.auto_archive
        if self.business_scene is not None:
            result['business_scene'] = self.business_scene
        if self.config_info is not None:
            result['config_info'] = self.config_info.to_map()
        if self.contract_remind is not None:
            result['contract_remind'] = self.contract_remind
        if self.contract_validity is not None:
            result['contract_validity'] = self.contract_validity
        if self.initiator_account_id is not None:
            result['initiator_account_id'] = self.initiator_account_id
        if self.initiator_authorized_account_id is not None:
            result['initiator_authorized_account_id'] = self.initiator_authorized_account_id
        if self.sign_validity is not None:
            result['sign_validity'] = self.sign_validity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('auto_archive') is not None:
            self.auto_archive = m.get('auto_archive')
        if m.get('business_scene') is not None:
            self.business_scene = m.get('business_scene')
        if m.get('config_info') is not None:
            temp_model = ContractSignFlowConfig()
            self.config_info = temp_model.from_map(m['config_info'])
        if m.get('contract_remind') is not None:
            self.contract_remind = m.get('contract_remind')
        if m.get('contract_validity') is not None:
            self.contract_validity = m.get('contract_validity')
        if m.get('initiator_account_id') is not None:
            self.initiator_account_id = m.get('initiator_account_id')
        if m.get('initiator_authorized_account_id') is not None:
            self.initiator_authorized_account_id = m.get('initiator_authorized_account_id')
        if m.get('sign_validity') is not None:
            self.sign_validity = m.get('sign_validity')
        return self


class CreateContractHandsignflowResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        flow_id: str = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 流程ID
        self.flow_id = flow_id
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateContractHandsignfieldRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        sign_fields: List[ContractHandSignFieldApplication] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 流程id
        self.flow_id = flow_id
        # 签署区列表数据
        self.sign_fields = sign_fields

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.sign_fields, 'sign_fields')
        if self.sign_fields:
            for k in self.sign_fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        result['sign_fields'] = []
        if self.sign_fields is not None:
            for k in self.sign_fields:
                result['sign_fields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        self.sign_fields = []
        if m.get('sign_fields') is not None:
            for k in m.get('sign_fields'):
                temp_model = ContractHandSignFieldApplication()
                self.sign_fields.append(temp_model.from_map(k))
        return self


class CreateContractHandsignfieldResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        signfields: List[ContractSignField] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 签署区列表数据
        self.signfields = signfields

    def validate(self):
        if self.signfields:
            for k in self.signfields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['signfields'] = []
        if self.signfields is not None:
            for k in self.signfields:
                result['signfields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.signfields = []
        if m.get('signfields') is not None:
            for k in m.get('signfields'):
                temp_model = ContractSignField()
                self.signfields.append(temp_model.from_map(k))
        return self


class GetContractSignurlRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        flow_id: str = None,
        organize_id: str = None,
        short_url: bool = None,
        agent_account_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 签署人账号id
        self.account_id = account_id
        # 流程id
        self.flow_id = flow_id
        # 存量参数，已废弃
        self.organize_id = organize_id
        # 是否需要同时返回短链接，默认为false
        self.short_url = short_url
        # 本功能需要单独审批开放。当account_id为机构账户时，可以在执行签署时单独指定经办人账户，代为完成本次签署操作。
        self.agent_account_id = agent_account_id

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.organize_id is not None:
            result['organize_id'] = self.organize_id
        if self.short_url is not None:
            result['short_url'] = self.short_url
        if self.agent_account_id is not None:
            result['agent_account_id'] = self.agent_account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('organize_id') is not None:
            self.organize_id = m.get('organize_id')
        if m.get('short_url') is not None:
            self.short_url = m.get('short_url')
        if m.get('agent_account_id') is not None:
            self.agent_account_id = m.get('agent_account_id')
        return self


class GetContractSignurlResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        url: str = None,
        short_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 长链地址
        self.url = url
        # 短链地址
        self.short_url = short_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.url is not None:
            result['url'] = self.url
        if self.short_url is not None:
            result['short_url'] = self.short_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('url') is not None:
            self.url = m.get('url')
        if m.get('short_url') is not None:
            self.short_url = m.get('short_url')
        return self


class CreateWithholdAgreementRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        credit_amount: str = None,
        external_agreement_no: str = None,
        merchant_id: str = None,
        merchant_name: str = None,
        merchant_service_description: str = None,
        merchant_service_name: str = None,
        name_cert_hash: str = None,
        repayment_url: str = None,
        return_url: str = None,
        third_party_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 授信总金额，单位元
        self.credit_amount = credit_amount
        # 商户签约号，代扣协议中标示用户的唯一签约号（确保在商户系统中唯一）
        self.external_agreement_no = external_agreement_no
        # 收款方账号类型，可取值：ALIPAY_USER_ID（支付宝uid);商户id，2088123412341234
        self.merchant_id = merchant_id
        # 商户名称
        self.merchant_name = merchant_name
        # 对服务产品的描述
        self.merchant_service_description = merchant_service_description
        # 商户的服务名称，滴滴出行免密支付
        self.merchant_service_name = merchant_service_name
        # 姓名和身份证号拼接sha256的hash
        self.name_cert_hash = name_cert_hash
        # 还款计划的链接
        self.repayment_url = repayment_url
        # 签约成功后回调的地址
        self.return_url = return_url
        # 第三方用户id
        self.third_party_id = third_party_id

    def validate(self):
        self.validate_required(self.credit_amount, 'credit_amount')
        self.validate_required(self.external_agreement_no, 'external_agreement_no')
        self.validate_required(self.merchant_id, 'merchant_id')
        self.validate_required(self.merchant_name, 'merchant_name')
        self.validate_required(self.merchant_service_name, 'merchant_service_name')
        self.validate_required(self.name_cert_hash, 'name_cert_hash')
        self.validate_required(self.repayment_url, 'repayment_url')
        self.validate_required(self.third_party_id, 'third_party_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.credit_amount is not None:
            result['credit_amount'] = self.credit_amount
        if self.external_agreement_no is not None:
            result['external_agreement_no'] = self.external_agreement_no
        if self.merchant_id is not None:
            result['merchant_id'] = self.merchant_id
        if self.merchant_name is not None:
            result['merchant_name'] = self.merchant_name
        if self.merchant_service_description is not None:
            result['merchant_service_description'] = self.merchant_service_description
        if self.merchant_service_name is not None:
            result['merchant_service_name'] = self.merchant_service_name
        if self.name_cert_hash is not None:
            result['name_cert_hash'] = self.name_cert_hash
        if self.repayment_url is not None:
            result['repayment_url'] = self.repayment_url
        if self.return_url is not None:
            result['return_url'] = self.return_url
        if self.third_party_id is not None:
            result['third_party_id'] = self.third_party_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('credit_amount') is not None:
            self.credit_amount = m.get('credit_amount')
        if m.get('external_agreement_no') is not None:
            self.external_agreement_no = m.get('external_agreement_no')
        if m.get('merchant_id') is not None:
            self.merchant_id = m.get('merchant_id')
        if m.get('merchant_name') is not None:
            self.merchant_name = m.get('merchant_name')
        if m.get('merchant_service_description') is not None:
            self.merchant_service_description = m.get('merchant_service_description')
        if m.get('merchant_service_name') is not None:
            self.merchant_service_name = m.get('merchant_service_name')
        if m.get('name_cert_hash') is not None:
            self.name_cert_hash = m.get('name_cert_hash')
        if m.get('repayment_url') is not None:
            self.repayment_url = m.get('repayment_url')
        if m.get('return_url') is not None:
            self.return_url = m.get('return_url')
        if m.get('third_party_id') is not None:
            self.third_party_id = m.get('third_party_id')
        return self


class CreateWithholdAgreementResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryWithholdAgreementRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        external_agreement_no: str = None,
        third_party_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 商户签约号，代扣协议中标示用户的唯一签约号（确保在商户系统中唯一）
        self.external_agreement_no = external_agreement_no
        # 第三方用户id
        self.third_party_id = third_party_id

    def validate(self):
        self.validate_required(self.external_agreement_no, 'external_agreement_no')
        self.validate_required(self.third_party_id, 'third_party_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.external_agreement_no is not None:
            result['external_agreement_no'] = self.external_agreement_no
        if self.third_party_id is not None:
            result['third_party_id'] = self.third_party_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('external_agreement_no') is not None:
            self.external_agreement_no = m.get('external_agreement_no')
        if m.get('third_party_id') is not None:
            self.third_party_id = m.get('third_party_id')
        return self


class QueryWithholdAgreementResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        credit_amount: str = None,
        merchant_id: str = None,
        merchant_name: str = None,
        merchant_service_name: str = None,
        name_cert_hash: str = None,
        repayment_url: str = None,
        status: str = None,
        third_party_id: str = None,
        external_agreement_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 总授信金额
        self.credit_amount = credit_amount
        # 商家的支付宝uid
        self.merchant_id = merchant_id
        # 商户名称
        self.merchant_name = merchant_name
        # 商户的服务名称
        self.merchant_service_name = merchant_service_name
        # 姓名身份证号拼接后的hash
        self.name_cert_hash = name_cert_hash
        # 还款计划的超链接
        self.repayment_url = repayment_url
        # 协议的状态，如果签署成功返回success,未签是空
        self.status = status
        # 第三方的用户id
        self.third_party_id = third_party_id
        # 商家请求的协议号
        self.external_agreement_no = external_agreement_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.credit_amount is not None:
            result['credit_amount'] = self.credit_amount
        if self.merchant_id is not None:
            result['merchant_id'] = self.merchant_id
        if self.merchant_name is not None:
            result['merchant_name'] = self.merchant_name
        if self.merchant_service_name is not None:
            result['merchant_service_name'] = self.merchant_service_name
        if self.name_cert_hash is not None:
            result['name_cert_hash'] = self.name_cert_hash
        if self.repayment_url is not None:
            result['repayment_url'] = self.repayment_url
        if self.status is not None:
            result['status'] = self.status
        if self.third_party_id is not None:
            result['third_party_id'] = self.third_party_id
        if self.external_agreement_no is not None:
            result['external_agreement_no'] = self.external_agreement_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('credit_amount') is not None:
            self.credit_amount = m.get('credit_amount')
        if m.get('merchant_id') is not None:
            self.merchant_id = m.get('merchant_id')
        if m.get('merchant_name') is not None:
            self.merchant_name = m.get('merchant_name')
        if m.get('merchant_service_name') is not None:
            self.merchant_service_name = m.get('merchant_service_name')
        if m.get('name_cert_hash') is not None:
            self.name_cert_hash = m.get('name_cert_hash')
        if m.get('repayment_url') is not None:
            self.repayment_url = m.get('repayment_url')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_party_id') is not None:
            self.third_party_id = m.get('third_party_id')
        if m.get('external_agreement_no') is not None:
            self.external_agreement_no = m.get('external_agreement_no')
        return self


class QueryWithholdAgreementurlRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        external_agreement_no: str = None,
        third_party_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 商户签约号，代扣协议中标示用户的唯一签约号（确保在商户系统中唯一）
        self.external_agreement_no = external_agreement_no
        # 第三方用户id
        self.third_party_id = third_party_id

    def validate(self):
        self.validate_required(self.external_agreement_no, 'external_agreement_no')
        self.validate_required(self.third_party_id, 'third_party_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.external_agreement_no is not None:
            result['external_agreement_no'] = self.external_agreement_no
        if self.third_party_id is not None:
            result['third_party_id'] = self.third_party_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('external_agreement_no') is not None:
            self.external_agreement_no = m.get('external_agreement_no')
        if m.get('third_party_id') is not None:
            self.third_party_id = m.get('third_party_id')
        return self


class QueryWithholdAgreementurlResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result_message: str = None,
        url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 成功
        self.result_message = result_message
        # 代扣协议签署的入口
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result_message is not None:
            result['result_message'] = self.result_message
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result_message') is not None:
            self.result_message = m.get('result_message')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class CreateWithholdOverduetimeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        merchant_id: str = None,
        merchant_name: str = None,
        merchant_service_name: str = None,
        tenant_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 首款方id
        self.merchant_id = merchant_id
        # 商家名称
        self.merchant_name = merchant_name
        # 商家提供的产品名称
        self.merchant_service_name = merchant_service_name
        # 租户id
        self.tenant_id = tenant_id

    def validate(self):
        self.validate_required(self.merchant_id, 'merchant_id')
        self.validate_required(self.merchant_name, 'merchant_name')
        self.validate_required(self.merchant_service_name, 'merchant_service_name')
        self.validate_required(self.tenant_id, 'tenant_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.merchant_id is not None:
            result['merchant_id'] = self.merchant_id
        if self.merchant_name is not None:
            result['merchant_name'] = self.merchant_name
        if self.merchant_service_name is not None:
            result['merchant_service_name'] = self.merchant_service_name
        if self.tenant_id is not None:
            result['tenant_id'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('merchant_id') is not None:
            self.merchant_id = m.get('merchant_id')
        if m.get('merchant_name') is not None:
            self.merchant_name = m.get('merchant_name')
        if m.get('merchant_service_name') is not None:
            self.merchant_service_name = m.get('merchant_service_name')
        if m.get('tenant_id') is not None:
            self.tenant_id = m.get('tenant_id')
        return self


class CreateWithholdOverduetimeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class SendWithholdDeductRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        amount: str = None,
        business_params: str = None,
        external_agreement_no: str = None,
        order_title: str = None,
        out_biz_no: str = None,
        remark: str = None,
        third_party_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 委托支付订单总金额，单位为元，精确到小数点后两位
        self.amount = amount
        # JSON格式，传递业务扩展参数
        self.business_params = business_params
        # 商户签约号，代扣协议中标示用户的唯一签约号（确保在商户系统中唯一）
        self.external_agreement_no = external_agreement_no
        # 订单标题信息
        self.order_title = order_title
        # 外部订单号,请求方保证唯一性
        self.out_biz_no = out_biz_no
        # 备注
        self.remark = remark
        # 第三方的用户id
        self.third_party_id = third_party_id

    def validate(self):
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.external_agreement_no, 'external_agreement_no')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.third_party_id, 'third_party_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.amount is not None:
            result['amount'] = self.amount
        if self.business_params is not None:
            result['business_params'] = self.business_params
        if self.external_agreement_no is not None:
            result['external_agreement_no'] = self.external_agreement_no
        if self.order_title is not None:
            result['order_title'] = self.order_title
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.remark is not None:
            result['remark'] = self.remark
        if self.third_party_id is not None:
            result['third_party_id'] = self.third_party_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        if m.get('business_params') is not None:
            self.business_params = m.get('business_params')
        if m.get('external_agreement_no') is not None:
            self.external_agreement_no = m.get('external_agreement_no')
        if m.get('order_title') is not None:
            self.order_title = m.get('order_title')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('third_party_id') is not None:
            self.third_party_id = m.get('third_party_id')
        return self


class SendWithholdDeductResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        entrust_order_id: str = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 该笔转账在支付宝系统内部的单据ID
        self.entrust_order_id = entrust_order_id
        # INIT：受理成功，扣款中
        # FINISHED：扣款成功
        # CLOSED：商户已关单
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.entrust_order_id is not None:
            result['entrust_order_id'] = self.entrust_order_id
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('entrust_order_id') is not None:
            self.entrust_order_id = m.get('entrust_order_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class QueryWithholdPayresultRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        entrust_order_id: str = None,
        out_biz_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 请求扣款时，返回的委托单号,该笔转账在支付宝系统内部的单据ID
        self.entrust_order_id = entrust_order_id
        # 外部订单号,请求方保证唯一性
        self.out_biz_no = out_biz_no

    def validate(self):
        self.validate_required(self.entrust_order_id, 'entrust_order_id')
        self.validate_required(self.out_biz_no, 'out_biz_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.entrust_order_id is not None:
            result['entrust_order_id'] = self.entrust_order_id
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('entrust_order_id') is not None:
            self.entrust_order_id = m.get('entrust_order_id')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        return self


class QueryWithholdPayresultResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        pay_date: str = None,
        pay_order_id: str = None,
        status: str = None,
        trans_amount: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 支付完成日期
        self.pay_date = pay_date
        # 支付宝支付单据号
        self.pay_order_id = pay_order_id
        # INIT：受理成功，扣款中
        # FINISHED：扣款成功
        # CLOSED：商户已关单
        self.status = status
        # 扣款金额
        self.trans_amount = trans_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.pay_date is not None:
            result['pay_date'] = self.pay_date
        if self.pay_order_id is not None:
            result['pay_order_id'] = self.pay_order_id
        if self.status is not None:
            result['status'] = self.status
        if self.trans_amount is not None:
            result['trans_amount'] = self.trans_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('pay_date') is not None:
            self.pay_date = m.get('pay_date')
        if m.get('pay_order_id') is not None:
            self.pay_order_id = m.get('pay_order_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('trans_amount') is not None:
            self.trans_amount = m.get('trans_amount')
        return self


class SendWithholdRefundRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_id: str = None,
        out_request_no: str = None,
        refund_amount: str = None,
        remark: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 支付宝支付单据号
        self.order_id = order_id
        # 外部订单号,请求方保证唯一性
        self.out_request_no = out_request_no
        # 需要退款的金额，该金额不能大于订单金额,单位为元，支持两位小数
        self.refund_amount = refund_amount
        # 退款备注
        self.remark = remark

    def validate(self):
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.out_request_no, 'out_request_no')
        self.validate_required(self.refund_amount, 'refund_amount')
        self.validate_required(self.remark, 'remark')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.out_request_no is not None:
            result['out_request_no'] = self.out_request_no
        if self.refund_amount is not None:
            result['refund_amount'] = self.refund_amount
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('out_request_no') is not None:
            self.out_request_no = m.get('out_request_no')
        if m.get('refund_amount') is not None:
            self.refund_amount = m.get('refund_amount')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class SendWithholdRefundResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        refund_amount: str = None,
        refund_date: str = None,
        refund_order_id: str = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 需要退款的金额，该金额不能大于订单金额,单位为元，支持两位小数
        self.refund_amount = refund_amount
        # 退款成功的日期
        self.refund_date = refund_date
        # 退款的支付宝系统内部单据id
        self.refund_order_id = refund_order_id
        # FINISHED,退款成功的状态值
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.refund_amount is not None:
            result['refund_amount'] = self.refund_amount
        if self.refund_date is not None:
            result['refund_date'] = self.refund_date
        if self.refund_order_id is not None:
            result['refund_order_id'] = self.refund_order_id
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('refund_amount') is not None:
            self.refund_amount = m.get('refund_amount')
        if m.get('refund_date') is not None:
            self.refund_date = m.get('refund_date')
        if m.get('refund_order_id') is not None:
            self.refund_order_id = m.get('refund_order_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class SendContractInvitationRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_process_id: str = None,
        callback_url: str = None,
        email: str = None,
        id_number: str = None,
        invitee_cert_type: str = None,
        invite_type: str = None,
        legal_cert_type: str = None,
        legal_name: str = None,
        legal_no: str = None,
        mobile: str = None,
        name: str = None,
        notify_type: str = None,
        organ_cert_no: str = None,
        organ_cert_type: str = None,
        organ_name: str = None,
        redirect_url: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 业务方id，重定向和回调时都回传这个id
        self.biz_process_id = biz_process_id
        # 回调接口地址，默认为空，不回调
        self.callback_url = callback_url
        # 被邀请人邮箱，若手机号和邮箱都传入，则仅手机号有效
        self.email = email
        # 被邀请人证件号
        self.id_number = id_number
        # 被邀请人证件类型，详见个人证件类型说明 ，默认CRED_PSN_CH_IDCARD
        self.invitee_cert_type = invitee_cert_type
        # 邀请个人实名为PERSON，邀请企业为ORGAN
        self.invite_type = invite_type
        # 企业法定代表人证件类型，详见个人证件类型说明 ，默认CRED_PSN_CH_IDCARD
        self.legal_cert_type = legal_cert_type
        # 企业法定代表人姓名
        self.legal_name = legal_name
        # 企业法定代表人证件号
        self.legal_no = legal_no
        # 被邀请人手机号
        self.mobile = mobile
        # 被邀请人姓名
        self.name = name
        # 默认为空，传入“sms”表示短信，“email”表示邮件，若两者都传入，则只发送短信
        self.notify_type = notify_type
        # 企业证件号
        self.organ_cert_no = organ_cert_no
        # 企业证件类型，详见机构证件类型说明 ，默认CRED_ORG_USCC
        self.organ_cert_type = organ_cert_type
        # 企业名称
        self.organ_name = organ_name
        # 结束后重定向地址（需加前缀https:// 或 http:// ），默认停留在当前页面
        self.redirect_url = redirect_url

    def validate(self):
        self.validate_required(self.invite_type, 'invite_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_process_id is not None:
            result['biz_process_id'] = self.biz_process_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.email is not None:
            result['email'] = self.email
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.invitee_cert_type is not None:
            result['invitee_cert_type'] = self.invitee_cert_type
        if self.invite_type is not None:
            result['invite_type'] = self.invite_type
        if self.legal_cert_type is not None:
            result['legal_cert_type'] = self.legal_cert_type
        if self.legal_name is not None:
            result['legal_name'] = self.legal_name
        if self.legal_no is not None:
            result['legal_no'] = self.legal_no
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.notify_type is not None:
            result['notify_type'] = self.notify_type
        if self.organ_cert_no is not None:
            result['organ_cert_no'] = self.organ_cert_no
        if self.organ_cert_type is not None:
            result['organ_cert_type'] = self.organ_cert_type
        if self.organ_name is not None:
            result['organ_name'] = self.organ_name
        if self.redirect_url is not None:
            result['redirect_url'] = self.redirect_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_process_id') is not None:
            self.biz_process_id = m.get('biz_process_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('invitee_cert_type') is not None:
            self.invitee_cert_type = m.get('invitee_cert_type')
        if m.get('invite_type') is not None:
            self.invite_type = m.get('invite_type')
        if m.get('legal_cert_type') is not None:
            self.legal_cert_type = m.get('legal_cert_type')
        if m.get('legal_name') is not None:
            self.legal_name = m.get('legal_name')
        if m.get('legal_no') is not None:
            self.legal_no = m.get('legal_no')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('notify_type') is not None:
            self.notify_type = m.get('notify_type')
        if m.get('organ_cert_no') is not None:
            self.organ_cert_no = m.get('organ_cert_no')
        if m.get('organ_cert_type') is not None:
            self.organ_cert_type = m.get('organ_cert_type')
        if m.get('organ_name') is not None:
            self.organ_name = m.get('organ_name')
        if m.get('redirect_url') is not None:
            self.redirect_url = m.get('redirect_url')
        return self


class SendContractInvitationResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        invitation_id: str = None,
        invitation_url: str = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 邀请任务id
        self.invitation_id = invitation_id
        # 邀请链接
        self.invitation_url = invitation_url
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.invitation_id is not None:
            result['invitation_id'] = self.invitation_id
        if self.invitation_url is not None:
            result['invitation_url'] = self.invitation_url
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('invitation_id') is not None:
            self.invitation_id = m.get('invitation_id')
        if m.get('invitation_url') is not None:
            self.invitation_url = m.get('invitation_url')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class ListContractPayruleRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # flowId
        self.flow_id = flow_id

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        return self


class ListContractPayruleResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        err_message: str = None,
        response_data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 状态码，0表示成功
        self.code = code
        # ""
        self.err_message = err_message
        # 代扣规则描述json表示
        self.response_data = response_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.err_message is not None:
            result['err_message'] = self.err_message
        if self.response_data is not None:
            result['response_data'] = self.response_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('err_message') is not None:
            self.err_message = m.get('err_message')
        if m.get('response_data') is not None:
            self.response_data = m.get('response_data')
        return self


class CreateWithholdQrcodeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        third_party_id: str = None,
        external_agreement_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 第三方的用户id
        self.third_party_id = third_party_id
        # 请求签约的协议号
        self.external_agreement_no = external_agreement_no

    def validate(self):
        self.validate_required(self.third_party_id, 'third_party_id')
        self.validate_required(self.external_agreement_no, 'external_agreement_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.third_party_id is not None:
            result['third_party_id'] = self.third_party_id
        if self.external_agreement_no is not None:
            result['external_agreement_no'] = self.external_agreement_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('third_party_id') is not None:
            self.third_party_id = m.get('third_party_id')
        if m.get('external_agreement_no') is not None:
            self.external_agreement_no = m.get('external_agreement_no')
        return self


class CreateWithholdQrcodeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        qr_code_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 二维码图片链接地址
        self.qr_code_url = qr_code_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.qr_code_url is not None:
            result['qr_code_url'] = self.qr_code_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('qr_code_url') is not None:
            self.qr_code_url = m.get('qr_code_url')
        return self


class CancelContractPaysingletradeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        cancel_out_order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 智能合同id
        self.flow_id = flow_id
        # 被取消的某一期的代扣id
        self.cancel_out_order_no = cancel_out_order_no

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.cancel_out_order_no, 'cancel_out_order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.cancel_out_order_no is not None:
            result['cancel_out_order_no'] = self.cancel_out_order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('cancel_out_order_no') is not None:
            self.cancel_out_order_no = m.get('cancel_out_order_no')
        return self


class CancelContractPaysingletradeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        err_message: str = None,
        canceled_out_trade_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误码，0表示成功
        self.code = code
        # 错误信息描述
        self.err_message = err_message
        # 被取消的某一期代扣订单id
        self.canceled_out_trade_no = canceled_out_trade_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.err_message is not None:
            result['err_message'] = self.err_message
        if self.canceled_out_trade_no is not None:
            result['canceled_out_trade_no'] = self.canceled_out_trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('err_message') is not None:
            self.err_message = m.get('err_message')
        if m.get('canceled_out_trade_no') is not None:
            self.canceled_out_trade_no = m.get('canceled_out_trade_no')
        return self


class ApplyContractCallbackkeyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        return self


class ApplyContractCallbackkeyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        key: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 加签使用的key
        self.key = key
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.key is not None:
            result['key'] = self.key
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateContractOnestepflowRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        auto_archive: bool = None,
        auto_initiate: bool = None,
        business_scene: str = None,
        comment: str = None,
        contract_sign_flow_config: ContractSignFlowConfig = None,
        docs: List[ContractDoc] = None,
        initiator_account_id: str = None,
        initiator_authorized_account_id: str = None,
        sign_fields: List[OneStepSignField] = None,
        sign_platform: str = None,
        sign_validity: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 是否自动归档，默认false。
        self.auto_archive = auto_archive
        # 是否自动开启，默认false。
        self.auto_initiate = auto_initiate
        # 文件主题
        self.business_scene = business_scene
        # 流程备注
        self.comment = comment
        # 任务配置信息
        self.contract_sign_flow_config = contract_sign_flow_config
        # 待签文档信息
        self.docs = docs
        # 发起人账户id，即发起本次签署的操作人个人账号id；如不传，默认由对接平台发起
        self.initiator_account_id = initiator_account_id
        # 发起方主体id，如存在个人代机构发起签约，则需传入机构id；如不传，则默认是对接平台
        self.initiator_authorized_account_id = initiator_authorized_account_id
        # 流程中的签署区信息
        self.sign_fields = sign_fields
        # 签署平台，ALIPAY（支付宝小程序）或H5，默认H5
        self.sign_platform = sign_platform
        # 签署有效截止日期，毫秒，默认3天失效
        self.sign_validity = sign_validity

    def validate(self):
        self.validate_required(self.business_scene, 'business_scene')
        if self.contract_sign_flow_config:
            self.contract_sign_flow_config.validate()
        if self.docs:
            for k in self.docs:
                if k:
                    k.validate()
        if self.sign_fields:
            for k in self.sign_fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.auto_archive is not None:
            result['auto_archive'] = self.auto_archive
        if self.auto_initiate is not None:
            result['auto_initiate'] = self.auto_initiate
        if self.business_scene is not None:
            result['business_scene'] = self.business_scene
        if self.comment is not None:
            result['comment'] = self.comment
        if self.contract_sign_flow_config is not None:
            result['contract_sign_flow_config'] = self.contract_sign_flow_config.to_map()
        result['docs'] = []
        if self.docs is not None:
            for k in self.docs:
                result['docs'].append(k.to_map() if k else None)
        if self.initiator_account_id is not None:
            result['initiator_account_id'] = self.initiator_account_id
        if self.initiator_authorized_account_id is not None:
            result['initiator_authorized_account_id'] = self.initiator_authorized_account_id
        result['sign_fields'] = []
        if self.sign_fields is not None:
            for k in self.sign_fields:
                result['sign_fields'].append(k.to_map() if k else None)
        if self.sign_platform is not None:
            result['sign_platform'] = self.sign_platform
        if self.sign_validity is not None:
            result['sign_validity'] = self.sign_validity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('auto_archive') is not None:
            self.auto_archive = m.get('auto_archive')
        if m.get('auto_initiate') is not None:
            self.auto_initiate = m.get('auto_initiate')
        if m.get('business_scene') is not None:
            self.business_scene = m.get('business_scene')
        if m.get('comment') is not None:
            self.comment = m.get('comment')
        if m.get('contract_sign_flow_config') is not None:
            temp_model = ContractSignFlowConfig()
            self.contract_sign_flow_config = temp_model.from_map(m['contract_sign_flow_config'])
        self.docs = []
        if m.get('docs') is not None:
            for k in m.get('docs'):
                temp_model = ContractDoc()
                self.docs.append(temp_model.from_map(k))
        if m.get('initiator_account_id') is not None:
            self.initiator_account_id = m.get('initiator_account_id')
        if m.get('initiator_authorized_account_id') is not None:
            self.initiator_authorized_account_id = m.get('initiator_authorized_account_id')
        self.sign_fields = []
        if m.get('sign_fields') is not None:
            for k in m.get('sign_fields'):
                temp_model = OneStepSignField()
                self.sign_fields.append(temp_model.from_map(k))
        if m.get('sign_platform') is not None:
            self.sign_platform = m.get('sign_platform')
        if m.get('sign_validity') is not None:
            self.sign_validity = m.get('sign_validity')
        return self


class CreateContractOnestepflowResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        flow_id: str = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 流程ID
        self.flow_id = flow_id
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class QueryContractNotaryRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 签署流程ID
        self.flow_id = flow_id

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        return self


class QueryContractNotaryResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        notaries: List[ContractNotaryInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 存证信息列表
        self.notaries = notaries

    def validate(self):
        if self.notaries:
            for k in self.notaries:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['notaries'] = []
        if self.notaries is not None:
            for k in self.notaries:
                result['notaries'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.notaries = []
        if m.get('notaries') is not None:
            for k in m.get('notaries'):
                temp_model = ContractNotaryInfo()
                self.notaries.append(temp_model.from_map(k))
        return self


class CreateEcocontractTransRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        customer: Identity = None,
        properties: str = None,
        sub_biz_id: str = None,
        tsr: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 存证关联实体（个人/企业）的身份识别信息
        self.customer = customer
        # 扩展属性
        self.properties = properties
        # 业务子类型标识
        self.sub_biz_id = sub_biz_id
        # 是否使用可信时间戳，默认为false
        self.tsr = tsr

    def validate(self):
        self.validate_required(self.customer, 'customer')
        if self.customer:
            self.customer.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.customer is not None:
            result['customer'] = self.customer.to_map()
        if self.properties is not None:
            result['properties'] = self.properties
        if self.sub_biz_id is not None:
            result['sub_biz_id'] = self.sub_biz_id
        if self.tsr is not None:
            result['tsr'] = self.tsr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('customer') is not None:
            temp_model = Identity()
            self.customer = temp_model.from_map(m['customer'])
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        if m.get('sub_biz_id') is not None:
            self.sub_biz_id = m.get('sub_biz_id')
        if m.get('tsr') is not None:
            self.tsr = m.get('tsr')
        return self


class CreateEcocontractTransResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        transaction_id: str = None,
        tsr: TsrResponse = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回事务ID，全局唯一
        self.transaction_id = transaction_id
        # 可信时间信息
        self.tsr = tsr

    def validate(self):
        if self.tsr:
            self.tsr.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.transaction_id is not None:
            result['transaction_id'] = self.transaction_id
        if self.tsr is not None:
            result['tsr'] = self.tsr.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('transaction_id') is not None:
            self.transaction_id = m.get('transaction_id')
        if m.get('tsr') is not None:
            temp_model = TsrResponse()
            self.tsr = temp_model.from_map(m['tsr'])
        return self


class CreateEcocontractTextRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        finish_info: ContractNotaryFinishInfo = None,
        flow_id: str = None,
        init_info: ContractNotaryInitInfo = None,
        phase: str = None,
        sign_info: ContractNotarySignInfo = None,
        transaction_id: str = None,
        document_info: ContractNotaryDocumentInfo = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 签署结束信息，phase为FINISH时必选
        self.finish_info = finish_info
        # 签署流程ID
        self.flow_id = flow_id
        # 签署发起信息，phase为INIT时必选
        self.init_info = init_info
        # 存证阶段，分为INIT(发起)，SIGN(签署)，FINISH(结束)
        self.phase = phase
        # 签署过程信息，phase为SIGN时必选
        self.sign_info = sign_info
        # 存证事务ID
        self.transaction_id = transaction_id
        # 签署文件存档阶段存证核验信息
        self.document_info = document_info

    def validate(self):
        if self.finish_info:
            self.finish_info.validate()
        self.validate_required(self.flow_id, 'flow_id')
        if self.init_info:
            self.init_info.validate()
        self.validate_required(self.phase, 'phase')
        if self.sign_info:
            self.sign_info.validate()
        self.validate_required(self.transaction_id, 'transaction_id')
        if self.document_info:
            self.document_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.finish_info is not None:
            result['finish_info'] = self.finish_info.to_map()
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.init_info is not None:
            result['init_info'] = self.init_info.to_map()
        if self.phase is not None:
            result['phase'] = self.phase
        if self.sign_info is not None:
            result['sign_info'] = self.sign_info.to_map()
        if self.transaction_id is not None:
            result['transaction_id'] = self.transaction_id
        if self.document_info is not None:
            result['document_info'] = self.document_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('finish_info') is not None:
            temp_model = ContractNotaryFinishInfo()
            self.finish_info = temp_model.from_map(m['finish_info'])
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('init_info') is not None:
            temp_model = ContractNotaryInitInfo()
            self.init_info = temp_model.from_map(m['init_info'])
        if m.get('phase') is not None:
            self.phase = m.get('phase')
        if m.get('sign_info') is not None:
            temp_model = ContractNotarySignInfo()
            self.sign_info = temp_model.from_map(m['sign_info'])
        if m.get('transaction_id') is not None:
            self.transaction_id = m.get('transaction_id')
        if m.get('document_info') is not None:
            temp_model = ContractNotaryDocumentInfo()
            self.document_info = temp_model.from_map(m['document_info'])
        return self


class CreateEcocontractTextResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_hash: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 存证凭据,
        self.tx_hash = tx_hash

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        return self


class QueryContractWordspositionRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_id: str = None,
        keywords: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 文档id
        self.file_id = file_id
        # 关键字列表，逗号分割；注意要英文的逗号，不能中文逗号；关键字建议不要设置特殊字符，因Adobe无法识别部分符号，某些特殊字符会因解析失败从而导致搜索不到
        self.keywords = keywords

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.keywords, 'keywords')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.keywords is not None:
            result['keywords'] = self.keywords
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('keywords') is not None:
            self.keywords = m.get('keywords')
        return self


class QueryContractWordspositionResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        file_id: str = None,
        data: List[KeywordsPosition] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 文档id
        self.file_id = file_id
        # 关键字位置列表
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.file_id is not None:
            result['file_id'] = self.file_id
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = KeywordsPosition()
                self.data.append(temp_model.from_map(k))
        return self


class DeleteContractSignerRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        account_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 签署流程ID
        self.flow_id = flow_id
        # 签署人ID
        self.account_id = account_id

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.account_id, 'account_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        return self


class DeleteContractSignerResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class GetContractCertificateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 签署流程ID
        self.flow_id = flow_id

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        return self


class GetContractCertificateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        url: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 下载文件地址(一小时内有效)
        self.url = url
        # 状态值
        self.code = code
        # 状态信息描述
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.url is not None:
            result['url'] = self.url
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('url') is not None:
            self.url = m.get('url')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class QueryContractSignfieldsealidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        account_id: str = None,
        signfield_ids: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 流程id
        self.flow_id = flow_id
        # 账号id，默认所有签署人
        self.account_id = account_id
        # 指定签署区id列表，逗号分割，默认所有签署区
        self.signfield_ids = signfield_ids

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.signfield_ids is not None:
            result['signfield_ids'] = self.signfield_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('signfield_ids') is not None:
            self.signfield_ids = m.get('signfield_ids')
        return self


class QueryContractSignfieldsealidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: str = None,
        message: str = None,
        signfields: List[ContractSignFieldSealId] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 签署区列表数据
        self.signfields = signfields

    def validate(self):
        if self.signfields:
            for k in self.signfields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['signfields'] = []
        if self.signfields is not None:
            for k in self.signfields:
                result['signfields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.signfields = []
        if m.get('signfields') is not None:
            for k in m.get('signfields'):
                temp_model = ContractSignFieldSealId()
                self.signfields.append(temp_model.from_map(k))
        return self


class NotifyContractSignerRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 合同签署流程ID
        self.flow_id = flow_id

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        return self


class NotifyContractSignerResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        account_list: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功。
        self.code = code
        # 业务码信息
        self.message = message
        # 发送通知的用户账号列表
        self.account_list = account_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.account_list is not None:
            result['account_list'] = self.account_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('account_list') is not None:
            self.account_list = m.get('account_list')
        return self


class UpdateContractPlatformRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        platform: ContractPlatformOrganizationApplication = None,
        creator: ContractPlatformAccountApplication = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 平台方企业信息
        self.platform = platform
        # 平台方经办人信息
        self.creator = creator

    def validate(self):
        self.validate_required(self.platform, 'platform')
        if self.platform:
            self.platform.validate()
        if self.creator:
            self.creator.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.platform is not None:
            result['platform'] = self.platform.to_map()
        if self.creator is not None:
            result['creator'] = self.creator.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('platform') is not None:
            temp_model = ContractPlatformOrganizationApplication()
            self.platform = temp_model.from_map(m['platform'])
        if m.get('creator') is not None:
            temp_model = ContractPlatformAccountApplication()
            self.creator = temp_model.from_map(m['creator'])
        return self


class UpdateContractPlatformResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: str = None,
        message: str = None,
        platform: ContractPlatformApplication = None,
        creator: ContractCreatorApplication = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 状态码
        self.code = code
        # 状态信息
        self.message = message
        # 更新后平台方企业信息
        self.platform = platform
        # 更新后平台方经办人信息
        self.creator = creator

    def validate(self):
        if self.platform:
            self.platform.validate()
        if self.creator:
            self.creator.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.platform is not None:
            result['platform'] = self.platform.to_map()
        if self.creator is not None:
            result['creator'] = self.creator.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('platform') is not None:
            temp_model = ContractPlatformApplication()
            self.platform = temp_model.from_map(m['platform'])
        if m.get('creator') is not None:
            temp_model = ContractCreatorApplication()
            self.creator = temp_model.from_map(m['creator'])
        return self


class UpdateContractUserRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        email: str = None,
        id_number: str = None,
        id_type: str = None,
        mobile: str = None,
        name: str = None,
        user_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 邮箱地址，默认不变
        self.email = email
        # 证件号，该字段只有为空才允许修改
        self.id_number = id_number
        # 证件类型，默认为身份证
        self.id_type = id_type
        # 手机号码，默认不变
        self.mobile = mobile
        # 姓名，默认不变
        self.name = name
        # 用户账号id，注册用户返回的个人账号id
        self.user_id = user_id

    def validate(self):
        self.validate_required(self.user_id, 'user_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.email is not None:
            result['email'] = self.email
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class UpdateContractUserResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: str = None,
        message: str = None,
        email: str = None,
        id_number: str = None,
        id_type: str = None,
        mobile: str = None,
        name: str = None,
        user_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 状态码
        self.code = code
        # 状态信息
        self.message = message
        # 邮箱地址
        self.email = email
        # 证件号
        self.id_number = id_number
        # 证件类型
        self.id_type = id_type
        # 手机号码
        self.mobile = mobile
        # 姓名
        self.name = name
        # 用户账号id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.email is not None:
            result['email'] = self.email
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class UpdateContractOrganizationRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id_number: str = None,
        id_type: str = None,
        legal_person: str = None,
        legal_person_id: str = None,
        name: str = None,
        organization_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 证件号，该字段只有为空才允许修改
        self.id_number = id_number
        # 证件类型 ，默认CRED_ORG_USCC
        self.id_type = id_type
        # 企业法定代表人名称
        self.legal_person = legal_person
        # 企业法定代表人证件号
        self.legal_person_id = legal_person_id
        # 机构名称
        self.name = name
        # 机构账号id，注册机构账户时返回的机构账号id
        self.organization_id = organization_id

    def validate(self):
        self.validate_required(self.organization_id, 'organization_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.legal_person is not None:
            result['legal_person'] = self.legal_person
        if self.legal_person_id is not None:
            result['legal_person_id'] = self.legal_person_id
        if self.name is not None:
            result['name'] = self.name
        if self.organization_id is not None:
            result['organization_id'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('legal_person') is not None:
            self.legal_person = m.get('legal_person')
        if m.get('legal_person_id') is not None:
            self.legal_person_id = m.get('legal_person_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('organization_id') is not None:
            self.organization_id = m.get('organization_id')
        return self


class UpdateContractOrganizationResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        id_number: str = None,
        id_type: str = None,
        legal_person: str = None,
        legal_person_id: str = None,
        name: str = None,
        organization_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 证件号
        self.id_number = id_number
        # 证件类型
        self.id_type = id_type
        # 企业法人名称
        self.legal_person = legal_person
        # 企业法人证件号
        self.legal_person_id = legal_person_id
        # 机构名称
        self.name = name
        # 机构账号id
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.legal_person is not None:
            result['legal_person'] = self.legal_person
        if self.legal_person_id is not None:
            result['legal_person_id'] = self.legal_person_id
        if self.name is not None:
            result['name'] = self.name
        if self.organization_id is not None:
            result['organization_id'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('legal_person') is not None:
            self.legal_person = m.get('legal_person')
        if m.get('legal_person_id') is not None:
            self.legal_person_id = m.get('legal_person_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('organization_id') is not None:
            self.organization_id = m.get('organization_id')
        return self


class ApplyContractMerchantRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_content: str = None,
        agent_account_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 入驻信息，必须是json字符串
        self.biz_content = biz_content
        # 代理商户账户ID，此参数传null默认平台机构账户入驻，不允许传空字符串
        self.agent_account_id = agent_account_id

    def validate(self):
        self.validate_required(self.biz_content, 'biz_content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_content is not None:
            result['biz_content'] = self.biz_content
        if self.agent_account_id is not None:
            result['agent_account_id'] = self.agent_account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_content') is not None:
            self.biz_content = m.get('biz_content')
        if m.get('agent_account_id') is not None:
            self.agent_account_id = m.get('agent_account_id')
        return self


class ApplyContractMerchantResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        sub_code: int = None,
        sub_msg: str = None,
        merchant_info: str = None,
        smid: str = None,
        order_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否进件成功
        self.success = success
        # 进件子结果码，0 成功，1 代理商户已进件，2 商户已进件，请走挂接接口进行代理商挂接，3 商户进件中
        self.sub_code = sub_code
        # 进件失败原因
        self.sub_msg = sub_msg
        # 已进件商户信息（当cert_no对应的商户已经进件过，会返回完整的已进件的商户信息）
        self.merchant_info = merchant_info
        # 已进件成功的商户ID（当cert_no表示的商户已经进件过，会返回进件生成的商户ID）
        self.smid = smid
        # 订单ID
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        if self.sub_code is not None:
            result['sub_code'] = self.sub_code
        if self.sub_msg is not None:
            result['sub_msg'] = self.sub_msg
        if self.merchant_info is not None:
            result['merchant_info'] = self.merchant_info
        if self.smid is not None:
            result['smid'] = self.smid
        if self.order_id is not None:
            result['order_id'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('sub_code') is not None:
            self.sub_code = m.get('sub_code')
        if m.get('sub_msg') is not None:
            self.sub_msg = m.get('sub_msg')
        if m.get('merchant_info') is not None:
            self.merchant_info = m.get('merchant_info')
        if m.get('smid') is not None:
            self.smid = m.get('smid')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        return self


class ConfirmContractMerchantRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_id: str = None,
        agent_account_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 商户入驻查询订单id
        self.order_id = order_id
        # 代理商户账户ID，此参数不填默认平台机构账户入驻
        self.agent_account_id = agent_account_id

    def validate(self):
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.agent_account_id is not None:
            result['agent_account_id'] = self.agent_account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('agent_account_id') is not None:
            self.agent_account_id = m.get('agent_account_id')
        return self


class ConfirmContractMerchantResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        ext_info: str = None,
        ip_role_id: List[str] = None,
        apply_id: str = None,
        merchant_name: str = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 额外信息，包含smid
        self.ext_info = ext_info
        # 支付宝的ipRoleId
        self.ip_role_id = ip_role_id
        # 申请时间
        self.apply_id = apply_id
        # 商户名称
        self.merchant_name = merchant_name
        # 直付通商户进件的状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        if self.ip_role_id is not None:
            result['ip_role_id'] = self.ip_role_id
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.merchant_name is not None:
            result['merchant_name'] = self.merchant_name
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        if m.get('ip_role_id') is not None:
            self.ip_role_id = m.get('ip_role_id')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('merchant_name') is not None:
            self.merchant_name = m.get('merchant_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class CreatePrivatecontractTransRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        customer: Identity = None,
        properties: str = None,
        sub_biz_id: str = None,
        tsr: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 存证关联实体（个人/企业）的身份识别信息
        self.customer = customer
        # 扩展属性
        self.properties = properties
        # 业务子类型标识
        self.sub_biz_id = sub_biz_id
        # 是否使用可信时间戳，默认为false
        self.tsr = tsr

    def validate(self):
        self.validate_required(self.customer, 'customer')
        if self.customer:
            self.customer.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.customer is not None:
            result['customer'] = self.customer.to_map()
        if self.properties is not None:
            result['properties'] = self.properties
        if self.sub_biz_id is not None:
            result['sub_biz_id'] = self.sub_biz_id
        if self.tsr is not None:
            result['tsr'] = self.tsr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('customer') is not None:
            temp_model = Identity()
            self.customer = temp_model.from_map(m['customer'])
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        if m.get('sub_biz_id') is not None:
            self.sub_biz_id = m.get('sub_biz_id')
        if m.get('tsr') is not None:
            self.tsr = m.get('tsr')
        return self


class CreatePrivatecontractTransResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        transaction_id: str = None,
        tsr: TsrResponse = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回事务ID，全局唯一
        self.transaction_id = transaction_id
        # 可信时间信息
        self.tsr = tsr

    def validate(self):
        if self.tsr:
            self.tsr.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.transaction_id is not None:
            result['transaction_id'] = self.transaction_id
        if self.tsr is not None:
            result['tsr'] = self.tsr.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('transaction_id') is not None:
            self.transaction_id = m.get('transaction_id')
        if m.get('tsr') is not None:
            temp_model = TsrResponse()
            self.tsr = temp_model.from_map(m['tsr'])
        return self


class CreatePrivatecontractTextRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        finish_info: ContractNotaryFinishInfo = None,
        flow_id: str = None,
        init_info: ContractNotaryInitInfo = None,
        phase: str = None,
        sign_info: ContractNotarySignInfo = None,
        transaction_id: str = None,
        document_info: ContractNotaryDocumentInfo = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 签署结束信息，phase为FINISH时必选
        self.finish_info = finish_info
        # 签署流程ID
        self.flow_id = flow_id
        # 签署发起信息，phase为INIT时必选
        self.init_info = init_info
        # 存证阶段，分为INIT(发起)，SIGN(签署)，FINISH(结束)
        self.phase = phase
        # 签署过程信息，phase为SIGN时必选
        self.sign_info = sign_info
        # 存证事务ID
        self.transaction_id = transaction_id
        # 签署文件存档阶段存证核验信息
        self.document_info = document_info

    def validate(self):
        if self.finish_info:
            self.finish_info.validate()
        self.validate_required(self.flow_id, 'flow_id')
        if self.init_info:
            self.init_info.validate()
        self.validate_required(self.phase, 'phase')
        if self.sign_info:
            self.sign_info.validate()
        self.validate_required(self.transaction_id, 'transaction_id')
        if self.document_info:
            self.document_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.finish_info is not None:
            result['finish_info'] = self.finish_info.to_map()
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.init_info is not None:
            result['init_info'] = self.init_info.to_map()
        if self.phase is not None:
            result['phase'] = self.phase
        if self.sign_info is not None:
            result['sign_info'] = self.sign_info.to_map()
        if self.transaction_id is not None:
            result['transaction_id'] = self.transaction_id
        if self.document_info is not None:
            result['document_info'] = self.document_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('finish_info') is not None:
            temp_model = ContractNotaryFinishInfo()
            self.finish_info = temp_model.from_map(m['finish_info'])
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('init_info') is not None:
            temp_model = ContractNotaryInitInfo()
            self.init_info = temp_model.from_map(m['init_info'])
        if m.get('phase') is not None:
            self.phase = m.get('phase')
        if m.get('sign_info') is not None:
            temp_model = ContractNotarySignInfo()
            self.sign_info = temp_model.from_map(m['sign_info'])
        if m.get('transaction_id') is not None:
            self.transaction_id = m.get('transaction_id')
        if m.get('document_info') is not None:
            temp_model = ContractNotaryDocumentInfo()
            self.document_info = temp_model.from_map(m['document_info'])
        return self


class CreatePrivatecontractTextResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_hash: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 存证凭据,
        self.tx_hash = tx_hash

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        return self


class VerifyPrivatepersonTwometaRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        person_info: PersonInfo = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 个人信息
        self.person_info = person_info
        # 私有云实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.person_info, 'person_info')
        if self.person_info:
            self.person_info.validate()
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.person_info is not None:
            result['person_info'] = self.person_info.to_map()
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('person_info') is not None:
            temp_model = PersonInfo()
            self.person_info = temp_model.from_map(m['person_info'])
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class VerifyPrivatepersonTwometaResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: str = None,
        pass_: bool = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 调用返回值。"0"为调用成功。
        self.code = code
        # 校验是否通过。
        self.pass_ = pass_
        # 错误信息描述
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.pass_ is not None:
            result['pass'] = self.pass_
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('pass') is not None:
            self.pass_ = m.get('pass')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class VerifyPrivatecompanyTwometaRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        company_two_meta_info: CompanyTwoMetaInfo = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 私有云实例id
        self.instance_id = instance_id
        # 企业信息
        self.company_two_meta_info = company_two_meta_info

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.company_two_meta_info, 'company_two_meta_info')
        if self.company_two_meta_info:
            self.company_two_meta_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.company_two_meta_info is not None:
            result['company_two_meta_info'] = self.company_two_meta_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('company_two_meta_info') is not None:
            temp_model = CompanyTwoMetaInfo()
            self.company_two_meta_info = temp_model.from_map(m['company_two_meta_info'])
        return self


class VerifyPrivatecompanyTwometaResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: str = None,
        pass_: bool = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 调用返回值。"0"为调用成功。
        self.code = code
        # 校验是否通过。
        self.pass_ = pass_
        # 错误信息描述
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.pass_ is not None:
            result['pass'] = self.pass_
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('pass') is not None:
            self.pass_ = m.get('pass')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class VerifyPrivatecompanyFourmetaRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        company_four_meta_info: CompanyFourMetaInfo = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 私有云实例id
        self.instance_id = instance_id
        # 企业信息
        self.company_four_meta_info = company_four_meta_info

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.company_four_meta_info, 'company_four_meta_info')
        if self.company_four_meta_info:
            self.company_four_meta_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.company_four_meta_info is not None:
            result['company_four_meta_info'] = self.company_four_meta_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('company_four_meta_info') is not None:
            temp_model = CompanyFourMetaInfo()
            self.company_four_meta_info = temp_model.from_map(m['company_four_meta_info'])
        return self


class VerifyPrivatecompanyFourmetaResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: str = None,
        pass_: bool = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 调用返回值。"0"为调用成功。
        self.code = code
        # 校验是否通过。
        self.pass_ = pass_
        # 错误信息描述
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.pass_ is not None:
            result['pass'] = self.pass_
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('pass') is not None:
            self.pass_ = m.get('pass')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class ApplyPrivatecontractCertRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        user_inner_id: str = None,
        user_type: str = None,
        user_name: str = None,
        user_cert_type: str = None,
        user_cert_number: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 私有云实例id
        self.instance_id = instance_id
        # 私有云系统内部生成的id
        self.user_inner_id = user_inner_id
        # 用户类型,个人PERSON，企业ORG
        self.user_type = user_type
        # 用户名称, 个人为个人名称，企业为企业名称
        self.user_name = user_name
        # 用户证件类型，默认个人,身份证CRED_PSN_CH_IDCARD；
        # 企业,统一社会信用代码,CRED_ORG_USCC
        self.user_cert_type = user_cert_type
        # 证件号码
        self.user_cert_number = user_cert_number

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.user_inner_id, 'user_inner_id')
        self.validate_required(self.user_type, 'user_type')
        self.validate_required(self.user_name, 'user_name')
        self.validate_required(self.user_cert_type, 'user_cert_type')
        self.validate_required(self.user_cert_number, 'user_cert_number')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.user_inner_id is not None:
            result['user_inner_id'] = self.user_inner_id
        if self.user_type is not None:
            result['user_type'] = self.user_type
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.user_cert_type is not None:
            result['user_cert_type'] = self.user_cert_type
        if self.user_cert_number is not None:
            result['user_cert_number'] = self.user_cert_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('user_inner_id') is not None:
            self.user_inner_id = m.get('user_inner_id')
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('user_cert_type') is not None:
            self.user_cert_type = m.get('user_cert_type')
        if m.get('user_cert_number') is not None:
            self.user_cert_number = m.get('user_cert_number')
        return self


class ApplyPrivatecontractCertResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        code: str = None,
        message: str = None,
        cert_auth_org: str = None,
        cert_serial_number: str = None,
        cert_end_time: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 注册是否成功
        self.success = success
        # 返回code,200成功，其他均为失败
        self.code = code
        # 返回信息，成功返回success，错误时会返回详细信息。
        self.message = message
        # 用户的CA证书办法机构
        self.cert_auth_org = cert_auth_org
        # 用户的CA证书序列号
        self.cert_serial_number = cert_serial_number
        # 用户证书过期时间
        self.cert_end_time = cert_end_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.cert_auth_org is not None:
            result['cert_auth_org'] = self.cert_auth_org
        if self.cert_serial_number is not None:
            result['cert_serial_number'] = self.cert_serial_number
        if self.cert_end_time is not None:
            result['cert_end_time'] = self.cert_end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('cert_auth_org') is not None:
            self.cert_auth_org = m.get('cert_auth_org')
        if m.get('cert_serial_number') is not None:
            self.cert_serial_number = m.get('cert_serial_number')
        if m.get('cert_end_time') is not None:
            self.cert_end_time = m.get('cert_end_time')
        return self


class QueryContractTradestatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        out_trade_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 代扣计划外部订单号
        self.out_trade_no = out_trade_no

    def validate(self):
        self.validate_required(self.out_trade_no, 'out_trade_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.out_trade_no is not None:
            result['out_trade_no'] = self.out_trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('out_trade_no') is not None:
            self.out_trade_no = m.get('out_trade_no')
        return self


class QueryContractTradestatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        out_trade_no: str = None,
        deduct_time: str = None,
        pay_date: str = None,
        pay_money: int = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 代扣计划的外部订单号
        self.out_trade_no = out_trade_no
        # 最近一次扣款触发时间戳（单位：ms）
        self.deduct_time = deduct_time
        # 创建代扣计划时设置的扣款时间戳（单位：ms）
        self.pay_date = pay_date
        # 计划扣款金额（单位：分）
        self.pay_money = pay_money
        # 扣款状态
        # PAY_TOBE_TRIGGER 初始未扣款
        # PAY_TRIGGERING 准备扣款状态
        # WAIT_BUYER_PAY 扣款中状态
        # PAY_SYNC_TRADE_SUCCESS 扣款中状态
        # TRADE_REFUNDED 已发生退款
        # TRADE_CLOSED 交易终止（未成功）
        # TRADE_SUCCESS 扣款成功
        # PAY_FAIL 扣款失败
        # TRADE_FINISHED 交易终止（扣款成功）
        # TRADE_CANCEL 代扣取消
        self.status = status

    def validate(self):
        if self.deduct_time is not None:
            self.validate_pattern(self.deduct_time, 'deduct_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.pay_date is not None:
            self.validate_pattern(self.pay_date, 'pay_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.out_trade_no is not None:
            result['out_trade_no'] = self.out_trade_no
        if self.deduct_time is not None:
            result['deduct_time'] = self.deduct_time
        if self.pay_date is not None:
            result['pay_date'] = self.pay_date
        if self.pay_money is not None:
            result['pay_money'] = self.pay_money
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('out_trade_no') is not None:
            self.out_trade_no = m.get('out_trade_no')
        if m.get('deduct_time') is not None:
            self.deduct_time = m.get('deduct_time')
        if m.get('pay_date') is not None:
            self.pay_date = m.get('pay_date')
        if m.get('pay_money') is not None:
            self.pay_money = m.get('pay_money')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class QueryContractRefundRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        refund_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 退款ID，用户调用退款接口时传入的自定义第三方id
        self.refund_id = refund_id

    def validate(self):
        self.validate_required(self.refund_id, 'refund_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.refund_id is not None:
            result['refund_id'] = self.refund_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('refund_id') is not None:
            self.refund_id = m.get('refund_id')
        return self


class QueryContractRefundResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        refund_id: str = None,
        refund_time: str = None,
        refund_amount: int = None,
        status: str = None,
        err_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 退款id
        self.refund_id = refund_id
        # 退款时间（时间戳，单位：ms）
        self.refund_time = refund_time
        # 本次退款请求的退款金额（单位：分）
        self.refund_amount = refund_amount
        # 退款状态
        # REFUNDING 退款中
        # SUCCESS 退款成功
        # FAIL 退款失败
        self.status = status
        # 退款错误信息
        self.err_msg = err_msg

    def validate(self):
        if self.refund_time is not None:
            self.validate_pattern(self.refund_time, 'refund_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.refund_id is not None:
            result['refund_id'] = self.refund_id
        if self.refund_time is not None:
            result['refund_time'] = self.refund_time
        if self.refund_amount is not None:
            result['refund_amount'] = self.refund_amount
        if self.status is not None:
            result['status'] = self.status
        if self.err_msg is not None:
            result['err_msg'] = self.err_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('refund_id') is not None:
            self.refund_id = m.get('refund_id')
        if m.get('refund_time') is not None:
            self.refund_time = m.get('refund_time')
        if m.get('refund_amount') is not None:
            self.refund_amount = m.get('refund_amount')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('err_msg') is not None:
            self.err_msg = m.get('err_msg')
        return self


class GetPrivatecontractSignurlRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        flow_id: str = None,
        user_inner_id: str = None,
        sign_platform: str = None,
        expiration_time: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 私有云实例id
        self.instance_id = instance_id
        # 签署流程ID
        self.flow_id = flow_id
        # 签署用户的内部ID
        self.user_inner_id = user_inner_id
        # 签署平台，默认为H5页面，浏览器打开；也可填写ALIPAY，使用支付宝小程序打开
        self.sign_platform = sign_platform
        # 签署流程过期时间
        self.expiration_time = expiration_time

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.user_inner_id, 'user_inner_id')
        self.validate_required(self.expiration_time, 'expiration_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.user_inner_id is not None:
            result['user_inner_id'] = self.user_inner_id
        if self.sign_platform is not None:
            result['sign_platform'] = self.sign_platform
        if self.expiration_time is not None:
            result['expiration_time'] = self.expiration_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('user_inner_id') is not None:
            self.user_inner_id = m.get('user_inner_id')
        if m.get('sign_platform') is not None:
            self.sign_platform = m.get('sign_platform')
        if m.get('expiration_time') is not None:
            self.expiration_time = m.get('expiration_time')
        return self


class GetPrivatecontractSignurlResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        sign_url: str = None,
        code: str = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 流程签署地址
        self.sign_url = sign_url
        # 返回code,200成功，其他均为失败
        self.code = code
        # 返回信息，成功返回success，错误时会返回详细信息。
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.sign_url is not None:
            result['sign_url'] = self.sign_url
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('sign_url') is not None:
            self.sign_url = m.get('sign_url')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class QueryContractMerchantorderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 申请单id，通过twc.notary.contract.merchant.apply或者twc.notary.contract.merchantindirectzft.create接口返回的order_id
        self.order_id = order_id

    def validate(self):
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        return self


class QueryContractMerchantorderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        order_id: str = None,
        external_id: str = None,
        merchant_name: str = None,
        status: str = None,
        apply_time: str = None,
        fk_audit: str = None,
        fk_audit_memo: str = None,
        kz_audit: str = None,
        kz_audit_memo: str = None,
        sub_confirm: str = None,
        card_alias_no: str = None,
        smid: str = None,
        apply_type: str = None,
        reason: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 申请单id
        self.order_id = order_id
        # 外部商户id
        self.external_id = external_id
        # 进件时填写的商户名称
        self.merchant_name = merchant_name
        # 申请总体状态。99:已完结;-1:失败;031:审核中
        self.status = status
        # 申请单创建时间
        self.apply_time = apply_time
        # 风控审核状态。CREATE：已创建待审批、SKIP：跳过风控审批步骤、PASS：风控审核通过、REJECT：风控审批拒绝
        self.fk_audit = fk_audit
        # 风控审批备注，如有则返回
        self.fk_audit_memo = fk_audit_memo
        # 客资审核状态。CREATE：已创建待审批、SKIP：跳过客资审批步骤、PASS：客资审核通过、REJECT：客资审批拒绝
        self.kz_audit = kz_audit
        # 客资审批备注，如有则返回
        self.kz_audit_memo = kz_audit_memo
        # 二级商户确认状态。CREATE：已发起二级商户确认、SKIP：无需确认、FAIL：签约失败、NOT_CONFIRM：商户未确认、FINISH签约完成
        self.sub_confirm = sub_confirm
        # 进件生成的卡编号，在发起结算时可以作为结算账号
        self.card_alias_no = card_alias_no
        # 二级商户id。当总体申请状态status为99时，smid才算进件完成
        self.smid = smid
        # 本申请单的请求类型。一般可选值包括ZHIFUTONG_CONSULT（直付通商户预校验）/ZHIFUTONG_CREATE（直付通商户创建）/ZHIFUTONG_MODIFY（直付通商户修改）
        self.apply_type = apply_type
        # 申请单处理失败时，通过此此段返回具体的失败理由；与kf_audit_memo和kz_audit_memo配合使用
        self.reason = reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.external_id is not None:
            result['external_id'] = self.external_id
        if self.merchant_name is not None:
            result['merchant_name'] = self.merchant_name
        if self.status is not None:
            result['status'] = self.status
        if self.apply_time is not None:
            result['apply_time'] = self.apply_time
        if self.fk_audit is not None:
            result['fk_audit'] = self.fk_audit
        if self.fk_audit_memo is not None:
            result['fk_audit_memo'] = self.fk_audit_memo
        if self.kz_audit is not None:
            result['kz_audit'] = self.kz_audit
        if self.kz_audit_memo is not None:
            result['kz_audit_memo'] = self.kz_audit_memo
        if self.sub_confirm is not None:
            result['sub_confirm'] = self.sub_confirm
        if self.card_alias_no is not None:
            result['card_alias_no'] = self.card_alias_no
        if self.smid is not None:
            result['smid'] = self.smid
        if self.apply_type is not None:
            result['apply_type'] = self.apply_type
        if self.reason is not None:
            result['reason'] = self.reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('external_id') is not None:
            self.external_id = m.get('external_id')
        if m.get('merchant_name') is not None:
            self.merchant_name = m.get('merchant_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('apply_time') is not None:
            self.apply_time = m.get('apply_time')
        if m.get('fk_audit') is not None:
            self.fk_audit = m.get('fk_audit')
        if m.get('fk_audit_memo') is not None:
            self.fk_audit_memo = m.get('fk_audit_memo')
        if m.get('kz_audit') is not None:
            self.kz_audit = m.get('kz_audit')
        if m.get('kz_audit_memo') is not None:
            self.kz_audit_memo = m.get('kz_audit_memo')
        if m.get('sub_confirm') is not None:
            self.sub_confirm = m.get('sub_confirm')
        if m.get('card_alias_no') is not None:
            self.card_alias_no = m.get('card_alias_no')
        if m.get('smid') is not None:
            self.smid = m.get('smid')
        if m.get('apply_type') is not None:
            self.apply_type = m.get('apply_type')
        if m.get('reason') is not None:
            self.reason = m.get('reason')
        return self


class UpdateContractMerchantRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_content: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 内容和商户进件信息类似，唯一区别在于此接口biz_content不要传external_id，改为传之前进件获取到的商户id信息smid，具体可见示例。
        self.biz_content = biz_content

    def validate(self):
        self.validate_required(self.biz_content, 'biz_content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_content is not None:
            result['biz_content'] = self.biz_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_content') is not None:
            self.biz_content = m.get('biz_content')
        return self


class UpdateContractMerchantResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        order_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 修改进件信息会产生修改订单，此字段标识修改订单id
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.order_id is not None:
            result['order_id'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        return self


class BindContractMerchantRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        smid: str = None,
        cert_no: str = None,
        agent_account_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 商户ID
        self.smid = smid
        # 商户证件号
        self.cert_no = cert_no
        # 代理用户id，传null默认挂接平台方，不允许传空字符串
        self.agent_account_id = agent_account_id

    def validate(self):
        self.validate_required(self.smid, 'smid')
        self.validate_required(self.cert_no, 'cert_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.smid is not None:
            result['smid'] = self.smid
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.agent_account_id is not None:
            result['agent_account_id'] = self.agent_account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('smid') is not None:
            self.smid = m.get('smid')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('agent_account_id') is not None:
            self.agent_account_id = m.get('agent_account_id')
        return self


class BindContractMerchantResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否挂接成功
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class InitPrivatecontractIntanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        service_url: str = None,
        tenant_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 私有化服务地址（可不上传，后续通过更新实例信息的接口进行服务地址填充）
        self.service_url = service_url
        # 开通服务的用户租户ID
        self.tenant_id = tenant_id

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.service_url is not None:
            result['service_url'] = self.service_url
        if self.tenant_id is not None:
            result['tenant_id'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('service_url') is not None:
            self.service_url = m.get('service_url')
        if m.get('tenant_id') is not None:
            self.tenant_id = m.get('tenant_id')
        return self


class InitPrivatecontractIntanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        instance_id: str = None,
        private_key: str = None,
        public_key: str = None,
        private_key_callback: str = None,
        public_key_callback: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 私有化服务实例ID
        self.instance_id = instance_id
        # 签名私钥的base64格式字符串
        self.private_key = private_key
        # 验签公钥的base64格式字符串
        self.public_key = public_key
        # 回调使用的签名私钥
        self.private_key_callback = private_key_callback
        # 回调使用的验签公钥
        self.public_key_callback = public_key_callback

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.private_key is not None:
            result['private_key'] = self.private_key
        if self.public_key is not None:
            result['public_key'] = self.public_key
        if self.private_key_callback is not None:
            result['private_key_callback'] = self.private_key_callback
        if self.public_key_callback is not None:
            result['public_key_callback'] = self.public_key_callback
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('private_key') is not None:
            self.private_key = m.get('private_key')
        if m.get('public_key') is not None:
            self.public_key = m.get('public_key')
        if m.get('private_key_callback') is not None:
            self.private_key_callback = m.get('private_key_callback')
        if m.get('public_key_callback') is not None:
            self.public_key_callback = m.get('public_key_callback')
        return self


class UpdatePrivatecontractIntanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        service_url: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 私有化服务地址
        self.service_url = service_url
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.service_url, 'service_url')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.service_url is not None:
            result['service_url'] = self.service_url
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('service_url') is not None:
            self.service_url = m.get('service_url')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class UpdatePrivatecontractIntanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdatePrivatecontractCertRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        user_inner_id: str = None,
        user_type: str = None,
        user_name: str = None,
        user_cert_type: str = None,
        user_cert_number: str = None,
        update_org_seal: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 私有云实例id
        self.instance_id = instance_id
        # 私有云系统内部生成的用户id
        # 
        self.user_inner_id = user_inner_id
        # 用户类型,个人PERSON，企业ORG
        self.user_type = user_type
        # 用户名称, 个人为个人名称，企业为企业名称
        # 
        self.user_name = user_name
        # 用户证件类型，默认个人,身份证CRED_PSN_CH_IDCARD； 企业,统一社会信用代码,CRED_ORG_USCC
        # 
        self.user_cert_type = user_cert_type
        # 证件号码
        self.user_cert_number = user_cert_number
        # 是否需要更新机构印模
        self.update_org_seal = update_org_seal

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.user_inner_id, 'user_inner_id')
        self.validate_required(self.user_type, 'user_type')
        self.validate_required(self.user_name, 'user_name')
        self.validate_required(self.user_cert_type, 'user_cert_type')
        self.validate_required(self.user_cert_number, 'user_cert_number')
        self.validate_required(self.update_org_seal, 'update_org_seal')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.user_inner_id is not None:
            result['user_inner_id'] = self.user_inner_id
        if self.user_type is not None:
            result['user_type'] = self.user_type
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.user_cert_type is not None:
            result['user_cert_type'] = self.user_cert_type
        if self.user_cert_number is not None:
            result['user_cert_number'] = self.user_cert_number
        if self.update_org_seal is not None:
            result['update_org_seal'] = self.update_org_seal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('user_inner_id') is not None:
            self.user_inner_id = m.get('user_inner_id')
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('user_cert_type') is not None:
            self.user_cert_type = m.get('user_cert_type')
        if m.get('user_cert_number') is not None:
            self.user_cert_number = m.get('user_cert_number')
        if m.get('update_org_seal') is not None:
            self.update_org_seal = m.get('update_org_seal')
        return self


class UpdatePrivatecontractCertResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        code: str = None,
        message: str = None,
        cert_auth_org: str = None,
        cert_serial_number: str = None,
        cert_end_time: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 更新是否成功
        # 
        self.success = success
        # 返回code,0成功，其他均为失败
        # 
        self.code = code
        # 返回信息，成功返回success，错误时会返回详细信息。
        self.message = message
        # 用户的CA证书办法机构
        self.cert_auth_org = cert_auth_org
        # 用户的CA证书序列号
        self.cert_serial_number = cert_serial_number
        # 用户证书过期时间
        self.cert_end_time = cert_end_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.cert_auth_org is not None:
            result['cert_auth_org'] = self.cert_auth_org
        if self.cert_serial_number is not None:
            result['cert_serial_number'] = self.cert_serial_number
        if self.cert_end_time is not None:
            result['cert_end_time'] = self.cert_end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('cert_auth_org') is not None:
            self.cert_auth_org = m.get('cert_auth_org')
        if m.get('cert_serial_number') is not None:
            self.cert_serial_number = m.get('cert_serial_number')
        if m.get('cert_end_time') is not None:
            self.cert_end_time = m.get('cert_end_time')
        return self


class ResetContractMerchantapplyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_id: str = None,
        apply_type: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 进件或进件修改申请订单id，从进件申请接口的返回字段中获取
        self.order_id = order_id
        # 进件类型,1 创建、2 修改、3 申请创建、4 申请修改
        self.apply_type = apply_type

    def validate(self):
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.apply_type, 'apply_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.apply_type is not None:
            result['apply_type'] = self.apply_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('apply_type') is not None:
            self.apply_type = m.get('apply_type')
        return self


class ResetContractMerchantapplyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否成功
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CheckPrivatecontractProvisionRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 私有云合同服务实例ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class CheckPrivatecontractProvisionResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 服务开通状态，0未找到，1已开通，2停服，3已释放
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class PushPrivatecontractGaugeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        amount: int = None,
        order_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 私有云合同服务实例ID
        self.instance_id = instance_id
        # 计量数量
        self.amount = amount
        # 本次上报的唯一订单幂等ID，用流程ID和文件ID拼接生成
        self.order_id = order_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.amount is not None:
            result['amount'] = self.amount
        if self.order_id is not None:
            result['order_id'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        return self


class PushPrivatecontractGaugeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否上报成功
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CheckContractCourtdeductRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        payer_name: str = None,
        payer_account: str = None,
        bank_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 付款账户人姓名
        self.payer_name = payer_name
        # 付款人银行账户
        self.payer_account = payer_account
        # 银行类型：icbc(工行)
        self.bank_type = bank_type

    def validate(self):
        self.validate_required(self.payer_name, 'payer_name')
        self.validate_required(self.payer_account, 'payer_account')
        self.validate_required(self.bank_type, 'bank_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.payer_name is not None:
            result['payer_name'] = self.payer_name
        if self.payer_account is not None:
            result['payer_account'] = self.payer_account
        if self.bank_type is not None:
            result['bank_type'] = self.bank_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('payer_name') is not None:
            self.payer_name = m.get('payer_name')
        if m.get('payer_account') is not None:
            self.payer_account = m.get('payer_account')
        if m.get('bank_type') is not None:
            self.bank_type = m.get('bank_type')
        return self


class CheckContractCourtdeductResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        check_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否预校验成功
        self.success = success
        # 预校验详细信息
        self.check_msg = check_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        if self.check_msg is not None:
            result['check_msg'] = self.check_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('check_msg') is not None:
            self.check_msg = m.get('check_msg')
        return self


class CreateContractCourtdeductRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        case_id: str = None,
        case_name: str = None,
        payee_name: str = None,
        payee_account: str = None,
        payee_bank_type: str = None,
        payer_name: str = None,
        payer_account: str = None,
        payer_bank_type: str = None,
        payment_detail_list: List[PaymentDetail] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 流程id
        self.flow_id = flow_id
        # 客户自定义案件id
        self.case_id = case_id
        # 案件名称
        self.case_name = case_name
        # 收款方人姓名
        self.payee_name = payee_name
        # 收款方人银行账户
        self.payee_account = payee_account
        # 收款方银行类型
        self.payee_bank_type = payee_bank_type
        # 付款方人姓名
        self.payer_name = payer_name
        # 付款方银行账户
        self.payer_account = payer_account
        # 付款方银行类型，例如：icbc（工行）
        self.payer_bank_type = payer_bank_type
        # 扣款计划详情列表
        self.payment_detail_list = payment_detail_list

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.case_id, 'case_id')
        self.validate_required(self.case_name, 'case_name')
        self.validate_required(self.payee_name, 'payee_name')
        self.validate_required(self.payee_account, 'payee_account')
        self.validate_required(self.payee_bank_type, 'payee_bank_type')
        self.validate_required(self.payer_name, 'payer_name')
        self.validate_required(self.payer_account, 'payer_account')
        self.validate_required(self.payer_bank_type, 'payer_bank_type')
        self.validate_required(self.payment_detail_list, 'payment_detail_list')
        if self.payment_detail_list:
            for k in self.payment_detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.case_id is not None:
            result['case_id'] = self.case_id
        if self.case_name is not None:
            result['case_name'] = self.case_name
        if self.payee_name is not None:
            result['payee_name'] = self.payee_name
        if self.payee_account is not None:
            result['payee_account'] = self.payee_account
        if self.payee_bank_type is not None:
            result['payee_bank_type'] = self.payee_bank_type
        if self.payer_name is not None:
            result['payer_name'] = self.payer_name
        if self.payer_account is not None:
            result['payer_account'] = self.payer_account
        if self.payer_bank_type is not None:
            result['payer_bank_type'] = self.payer_bank_type
        result['payment_detail_list'] = []
        if self.payment_detail_list is not None:
            for k in self.payment_detail_list:
                result['payment_detail_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('case_id') is not None:
            self.case_id = m.get('case_id')
        if m.get('case_name') is not None:
            self.case_name = m.get('case_name')
        if m.get('payee_name') is not None:
            self.payee_name = m.get('payee_name')
        if m.get('payee_account') is not None:
            self.payee_account = m.get('payee_account')
        if m.get('payee_bank_type') is not None:
            self.payee_bank_type = m.get('payee_bank_type')
        if m.get('payer_name') is not None:
            self.payer_name = m.get('payer_name')
        if m.get('payer_account') is not None:
            self.payer_account = m.get('payer_account')
        if m.get('payer_bank_type') is not None:
            self.payer_bank_type = m.get('payer_bank_type')
        self.payment_detail_list = []
        if m.get('payment_detail_list') is not None:
            for k in m.get('payment_detail_list'):
                temp_model = PaymentDetail()
                self.payment_detail_list.append(temp_model.from_map(k))
        return self


class CreateContractCourtdeductResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        file_name: str = None,
        tx_hash: str = None,
        notary_content: str = None,
        notary_content_hash: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 给工行上传的调解书文件名
        self.file_name = file_name
        # 存证txHash，存证核验时需要
        self.tx_hash = tx_hash
        # 存证原文
        self.notary_content = notary_content
        # 存证原文hash
        self.notary_content_hash = notary_content_hash

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.notary_content is not None:
            result['notary_content'] = self.notary_content
        if self.notary_content_hash is not None:
            result['notary_content_hash'] = self.notary_content_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('notary_content') is not None:
            self.notary_content = m.get('notary_content')
        if m.get('notary_content_hash') is not None:
            self.notary_content_hash = m.get('notary_content_hash')
        return self


class ExecContractCourtdeductRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bank_type: str = None,
        biz_trade_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 付款银行卡类型，例如：icbc（工行）
        self.bank_type = bank_type
        # 自定义交易id
        self.biz_trade_id = biz_trade_id

    def validate(self):
        self.validate_required(self.bank_type, 'bank_type')
        self.validate_required(self.biz_trade_id, 'biz_trade_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bank_type is not None:
            result['bank_type'] = self.bank_type
        if self.biz_trade_id is not None:
            result['biz_trade_id'] = self.biz_trade_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bank_type') is not None:
            self.bank_type = m.get('bank_type')
        if m.get('biz_trade_id') is not None:
            self.biz_trade_id = m.get('biz_trade_id')
        return self


class ExecContractCourtdeductResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        pay_money: int = None,
        pay_detail_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否执行成功
        self.success = success
        # 扣款金额，单位：分
        self.pay_money = pay_money
        # 扣款详情信息
        self.pay_detail_msg = pay_detail_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        if self.pay_money is not None:
            result['pay_money'] = self.pay_money
        if self.pay_detail_msg is not None:
            result['pay_detail_msg'] = self.pay_detail_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('pay_money') is not None:
            self.pay_money = m.get('pay_money')
        if m.get('pay_detail_msg') is not None:
            self.pay_detail_msg = m.get('pay_detail_msg')
        return self


class GetContractTextsignRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        origin_text: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 平台方注册的用户ID
        self.account_id = account_id
        # 待签名的原文本
        self.origin_text = origin_text

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.origin_text, 'origin_text')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.origin_text is not None:
            result['origin_text'] = self.origin_text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('origin_text') is not None:
            self.origin_text = m.get('origin_text')
        return self


class GetContractTextsignResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        sign_result: str = None,
        flow_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务结果码, 成功: 0
        self.code = code
        # 业务结果信息
        self.message = message
        # 签名结果值
        self.sign_result = sign_result
        # 签名流程id
        self.flow_id = flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.sign_result is not None:
            result['sign_result'] = self.sign_result
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('sign_result') is not None:
            self.sign_result = m.get('sign_result')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        return self


class VerifyContractTextsignRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        origin_text: str = None,
        sign_result: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 注册的平台方用户id
        self.account_id = account_id
        # 签名原文本
        self.origin_text = origin_text
        # 文本签名值
        self.sign_result = sign_result

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.origin_text, 'origin_text')
        self.validate_required(self.sign_result, 'sign_result')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.origin_text is not None:
            result['origin_text'] = self.origin_text
        if self.sign_result is not None:
            result['sign_result'] = self.sign_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('origin_text') is not None:
            self.origin_text = m.get('origin_text')
        if m.get('sign_result') is not None:
            self.sign_result = m.get('sign_result')
        return self


class VerifyContractTextsignResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        sign_info: ContractTextSignVerifySignInfo = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务结果码, 成功0
        self.code = code
        # 结果信息
        self.message = message
        # 签署信息, 包含签名与证书
        self.sign_info = sign_info

    def validate(self):
        if self.sign_info:
            self.sign_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.sign_info is not None:
            result['sign_info'] = self.sign_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('sign_info') is not None:
            temp_model = ContractTextSignVerifySignInfo()
            self.sign_info = temp_model.from_map(m['sign_info'])
        return self


class VerifyContractDocsignRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_id: str = None,
        account_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 文件id
        self.file_id = file_id
        # 平台方用户注册id
        self.account_id = account_id

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.account_id, 'account_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        return self


class VerifyContractDocsignResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        sign_infos: List[ContractDocSignVerifyInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 结果码
        self.code = code
        # 结果信息
        self.message = message
        # 文件签署信息
        self.sign_infos = sign_infos

    def validate(self):
        if self.sign_infos:
            for k in self.sign_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['sign_infos'] = []
        if self.sign_infos is not None:
            for k in self.sign_infos:
                result['sign_infos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.sign_infos = []
        if m.get('sign_infos') is not None:
            for k in m.get('sign_infos'):
                temp_model = ContractDocSignVerifyInfo()
                self.sign_infos.append(temp_model.from_map(k))
        return self


class DeleteContractSignfieldRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        delete_signfields: List[str] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 签署流程id
        self.flow_id = flow_id
        # 删除签署区id列表
        self.delete_signfields = delete_signfields

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.delete_signfields, 'delete_signfields')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.delete_signfields is not None:
            result['delete_signfields'] = self.delete_signfields
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('delete_signfields') is not None:
            self.delete_signfields = m.get('delete_signfields')
        return self


class DeleteContractSignfieldResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否操作成功
        self.success = success
        # 结果码(数字), 成功0
        self.code = code
        # 结果备注（具体错误解释）
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateContractEncrypteduserRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        organization: ContractOrganizationApplication = None,
        user: ContractAccountApplication = None,
        user_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 注册机构用户。类型为机构时(userType = "ORGANIZATION")，该字段必填。
        self.organization = organization
        # 注册为个人用户时，该字段表示个人用户的相关信息；
        # 注册为机构用户时，该字段表示对应机构经办人的个人信息。
        self.user = user
        # 用户类型
        # 个人：PERSON；
        # 机构：ORGANIZATION
        self.user_type = user_type

    def validate(self):
        self.validate_required(self.organization, 'organization')
        if self.organization:
            self.organization.validate()
        self.validate_required(self.user, 'user')
        if self.user:
            self.user.validate()
        self.validate_required(self.user_type, 'user_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.organization is not None:
            result['organization'] = self.organization.to_map()
        if self.user is not None:
            result['user'] = self.user.to_map()
        if self.user_type is not None:
            result['user_type'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('organization') is not None:
            temp_model = ContractOrganizationApplication()
            self.organization = temp_model.from_map(m['organization'])
        if m.get('user') is not None:
            temp_model = ContractAccountApplication()
            self.user = temp_model.from_map(m['user'])
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        return self


class CreateContractEncrypteduserResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        organization_id: str = None,
        user_id: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 机构账号
        self.organization_id = organization_id
        # 用户类型为个人时返回用户账号；
        # 用户类型为机构时返回经办人账号
        self.user_id = user_id
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.organization_id is not None:
            result['organization_id'] = self.organization_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('organization_id') is not None:
            self.organization_id = m.get('organization_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class SetContractTenantkeyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_decrypt_key: str = None,
        signal_pub_key_encoded: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 被通信秘钥加密后的解密密钥字符串。
        self.file_decrypt_key = file_decrypt_key
        # 使用base64编码后的RSA公钥；用于解密decryptKey以及加密入参
        self.signal_pub_key_encoded = signal_pub_key_encoded

    def validate(self):
        self.validate_required(self.file_decrypt_key, 'file_decrypt_key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_decrypt_key is not None:
            result['file_decrypt_key'] = self.file_decrypt_key
        if self.signal_pub_key_encoded is not None:
            result['signal_pub_key_encoded'] = self.signal_pub_key_encoded
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('file_decrypt_key') is not None:
            self.file_decrypt_key = m.get('file_decrypt_key')
        if m.get('signal_pub_key_encoded') is not None:
            self.signal_pub_key_encoded = m.get('signal_pub_key_encoded')
        return self


class SetContractTenantkeyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否成功
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetContractEncryptedfileuploadurlRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_name: str = None,
        encrypted: bool = None,
        md_5: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 包含后缀的文件全名, 合同.pdf
        self.file_name = file_name
        # 是否已加密, 默认否
        self.encrypted = encrypted
        # 明文文件的md5码，用于完整性校验
        self.md_5 = md_5

    def validate(self):
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.md_5, 'md_5')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.encrypted is not None:
            result['encrypted'] = self.encrypted
        if self.md_5 is not None:
            result['md5'] = self.md_5
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('encrypted') is not None:
            self.encrypted = m.get('encrypted')
        if m.get('md5') is not None:
            self.md_5 = m.get('md5')
        return self


class GetContractEncryptedfileuploadurlResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        file_log_id: str = None,
        file_upload_url: str = None,
        expired_time: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 上传的原始文件记录id
        self.file_log_id = file_log_id
        # 文件上传链接
        self.file_upload_url = file_upload_url
        # 上传链接过期时间. yyyy-MM-dd HH:mm:ss
        self.expired_time = expired_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.file_log_id is not None:
            result['file_log_id'] = self.file_log_id
        if self.file_upload_url is not None:
            result['file_upload_url'] = self.file_upload_url
        if self.expired_time is not None:
            result['expired_time'] = self.expired_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('file_log_id') is not None:
            self.file_log_id = m.get('file_log_id')
        if m.get('file_upload_url') is not None:
            self.file_upload_url = m.get('file_upload_url')
        if m.get('expired_time') is not None:
            self.expired_time = m.get('expired_time')
        return self


class CreateContractTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        task_type: str = None,
        task_content: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 任务类型枚举值
        # 文件解密上传任务，FILE_DECRYPT_ESIGN_UPLOAD
        self.task_type = task_type
        # 文件内容文件解密上传任务时，为原始文件id
        self.task_content = task_content

    def validate(self):
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.task_content, 'task_content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.task_type is not None:
            result['task_type'] = self.task_type
        if self.task_content is not None:
            result['task_content'] = self.task_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('task_type') is not None:
            self.task_type = m.get('task_type')
        if m.get('task_content') is not None:
            self.task_content = m.get('task_content')
        return self


class CreateContractTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        task_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 创建的任务id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.task_id is not None:
            result['task_id'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        return self


class QueryContractTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        task_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 创建任务时，返回的任务id
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.task_id is not None:
            result['task_id'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        return self


class QueryContractTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        task_type: str = None,
        task_status: str = None,
        task_result: str = None,
        fail_reason: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 任务类型,FILE_DECRYPT_ESIGN_UPLOAD
        self.task_type = task_type
        # 任务结果
        # INIT,初始化
        # DOING，处理中
        # FAIL，失败
        # SUCCESS，成功
        self.task_status = task_status
        # 当任务为FILE_DECRYPT_ESIGN_UPLOAD时，为处理成功后的文件id
        self.task_result = task_result
        # 失败原因
        self.fail_reason = fail_reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.task_type is not None:
            result['task_type'] = self.task_type
        if self.task_status is not None:
            result['task_status'] = self.task_status
        if self.task_result is not None:
            result['task_result'] = self.task_result
        if self.fail_reason is not None:
            result['fail_reason'] = self.fail_reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('task_type') is not None:
            self.task_type = m.get('task_type')
        if m.get('task_status') is not None:
            self.task_status = m.get('task_status')
        if m.get('task_result') is not None:
            self.task_result = m.get('task_result')
        if m.get('fail_reason') is not None:
            self.fail_reason = m.get('fail_reason')
        return self


class ExecContractPayRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        flow_id: str = None,
        pay_index: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 合同流程id
        self.flow_id = flow_id
        # 每期代扣的唯一编号
        self.pay_index = pay_index

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.pay_index, 'pay_index')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.flow_id is not None:
            result['flow_id'] = self.flow_id
        if self.pay_index is not None:
            result['pay_index'] = self.pay_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('flow_id') is not None:
            self.flow_id = m.get('flow_id')
        if m.get('pay_index') is not None:
            self.pay_index = m.get('pay_index')
        return self


class ExecContractPayResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        trigger_success: bool = None,
        code: str = None,
        msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否触发成功
        self.trigger_success = trigger_success
        # 结果code
        self.code = code
        # 结果描述
        self.msg = msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.trigger_success is not None:
            result['trigger_success'] = self.trigger_success
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('trigger_success') is not None:
            self.trigger_success = m.get('trigger_success')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class SyncInnerTransRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        transaction_id: str = None,
        account_id: str = None,
        biz_id: int = None,
        sub_biz_id: str = None,
        customer: str = None,
        register_time: int = None,
        expire_time: int = None,
        properties: str = None,
        active: bool = None,
        tx_hash: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 事务id
        self.id = id
        # 存证事务id
        self.transaction_id = transaction_id
        # 存证的用户id
        self.account_id = account_id
        # 业务id
        self.biz_id = biz_id
        # 子业务id
        self.sub_biz_id = sub_biz_id
        # 存证主体的json字符串
        self.customer = customer
        # 存证初始化时间
        self.register_time = register_time
        # 到期时间
        self.expire_time = expire_time
        # 扩展属性
        self.properties = properties
        # 是否有效
        self.active = active
        # 交易hash
        self.tx_hash = tx_hash

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.transaction_id, 'transaction_id')
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.biz_id, 'biz_id')
        self.validate_required(self.register_time, 'register_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.transaction_id is not None:
            result['transaction_id'] = self.transaction_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        if self.sub_biz_id is not None:
            result['sub_biz_id'] = self.sub_biz_id
        if self.customer is not None:
            result['customer'] = self.customer
        if self.register_time is not None:
            result['register_time'] = self.register_time
        if self.expire_time is not None:
            result['expire_time'] = self.expire_time
        if self.properties is not None:
            result['properties'] = self.properties
        if self.active is not None:
            result['active'] = self.active
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('transaction_id') is not None:
            self.transaction_id = m.get('transaction_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        if m.get('sub_biz_id') is not None:
            self.sub_biz_id = m.get('sub_biz_id')
        if m.get('customer') is not None:
            self.customer = m.get('customer')
        if m.get('register_time') is not None:
            self.register_time = m.get('register_time')
        if m.get('expire_time') is not None:
            self.expire_time = m.get('expire_time')
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        if m.get('active') is not None:
            self.active = m.get('active')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        return self


class SyncInnerTransResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class SyncInnerNotaryRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        transaction_id: str = None,
        tx_hash: str = None,
        phase: str = None,
        content_hash: str = None,
        create_time: int = None,
        notary_type: str = None,
        notary_size: int = None,
        account_id: str = None,
        biz_id: int = None,
        sub_biz_id: str = None,
        tsr: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # DB的存证id
        self.id = id
        # 事务id
        self.transaction_id = transaction_id
        # 交易hash
        self.tx_hash = tx_hash
        # 阶段
        self.phase = phase
        # 内容hash
        self.content_hash = content_hash
        # 创建时间
        self.create_time = create_time
        # 存证类型
        self.notary_type = notary_type
        # 大小
        self.notary_size = notary_size
        # 用户id
        self.account_id = account_id
        # 业务id
        self.biz_id = biz_id
        # 子业务id
        self.sub_biz_id = sub_biz_id
        # 是否需要可信时间
        self.tsr = tsr

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.transaction_id, 'transaction_id')
        self.validate_required(self.phase, 'phase')
        self.validate_required(self.content_hash, 'content_hash')
        self.validate_required(self.notary_type, 'notary_type')
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.biz_id, 'biz_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.transaction_id is not None:
            result['transaction_id'] = self.transaction_id
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        if self.phase is not None:
            result['phase'] = self.phase
        if self.content_hash is not None:
            result['content_hash'] = self.content_hash
        if self.create_time is not None:
            result['create_time'] = self.create_time
        if self.notary_type is not None:
            result['notary_type'] = self.notary_type
        if self.notary_size is not None:
            result['notary_size'] = self.notary_size
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        if self.sub_biz_id is not None:
            result['sub_biz_id'] = self.sub_biz_id
        if self.tsr is not None:
            result['tsr'] = self.tsr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('transaction_id') is not None:
            self.transaction_id = m.get('transaction_id')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        if m.get('phase') is not None:
            self.phase = m.get('phase')
        if m.get('content_hash') is not None:
            self.content_hash = m.get('content_hash')
        if m.get('create_time') is not None:
            self.create_time = m.get('create_time')
        if m.get('notary_type') is not None:
            self.notary_type = m.get('notary_type')
        if m.get('notary_size') is not None:
            self.notary_size = m.get('notary_size')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        if m.get('sub_biz_id') is not None:
            self.sub_biz_id = m.get('sub_biz_id')
        if m.get('tsr') is not None:
            self.tsr = m.get('tsr')
        return self


class SyncInnerNotaryResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class SyncInnerTwcopenRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        tenant_id: str = None,
        product_code: str = None,
        status: str = None,
        biz_id: int = None,
        order_channel: int = None,
        gmt_create: int = None,
        gmt_modified: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # 租户id
        self.tenant_id = tenant_id
        # 产品code
        self.product_code = product_code
        # 状态
        self.status = status
        # 业务id
        self.biz_id = biz_id
        # 开通渠道
        self.order_channel = order_channel
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.product_code, 'product_code')
        self.validate_required(self.status, 'status')
        self.validate_required(self.biz_id, 'biz_id')
        self.validate_required(self.order_channel, 'order_channel')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.tenant_id is not None:
            result['tenant_id'] = self.tenant_id
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.status is not None:
            result['status'] = self.status
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        if self.order_channel is not None:
            result['order_channel'] = self.order_channel
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('tenant_id') is not None:
            self.tenant_id = m.get('tenant_id')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        if m.get('order_channel') is not None:
            self.order_channel = m.get('order_channel')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        return self


class SyncInnerTwcopenResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class SyncInnerProvisionRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        tenant_id: str = None,
        tenant_name: str = None,
        product_code: str = None,
        is_official: bool = None,
        biz_id: int = None,
        legal_account: bool = None,
        status: int = None,
        instance_id: str = None,
        order_channel: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 自增id
        self.id = id
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 租户id
        self.tenant_id = tenant_id
        # 租户名称
        self.tenant_name = tenant_name
        # 产品码
        self.product_code = product_code
        # 是否正式账号
        self.is_official = is_official
        # 业务分类
        self.biz_id = biz_id
        # 是否法院节点
        self.legal_account = legal_account
        # 服务状态
        self.status = status
        # 商品开通实例id
        self.instance_id = instance_id
        # 订单渠道
        self.order_channel = order_channel

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.product_code, 'product_code')
        self.validate_required(self.biz_id, 'biz_id')
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.tenant_id is not None:
            result['tenant_id'] = self.tenant_id
        if self.tenant_name is not None:
            result['tenant_name'] = self.tenant_name
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.is_official is not None:
            result['is_official'] = self.is_official
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        if self.legal_account is not None:
            result['legal_account'] = self.legal_account
        if self.status is not None:
            result['status'] = self.status
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.order_channel is not None:
            result['order_channel'] = self.order_channel
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('tenant_id') is not None:
            self.tenant_id = m.get('tenant_id')
        if m.get('tenant_name') is not None:
            self.tenant_name = m.get('tenant_name')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('is_official') is not None:
            self.is_official = m.get('is_official')
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        if m.get('legal_account') is not None:
            self.legal_account = m.get('legal_account')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('order_channel') is not None:
            self.order_channel = m.get('order_channel')
        return self


class SyncInnerProvisionResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class SyncInnerTsrRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        token: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # tsr的token信息
        self.token = token

    def validate(self):
        self.validate_required(self.token, 'token')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class SyncInnerTsrResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CheckEpidentityTwometaRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        ep_cert_name: str = None,
        ep_cert_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 认证企业名称。
        self.ep_cert_name = ep_cert_name
        # 企业证件号码。
        self.ep_cert_no = ep_cert_no

    def validate(self):
        self.validate_required(self.ep_cert_name, 'ep_cert_name')
        self.validate_required(self.ep_cert_no, 'ep_cert_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.ep_cert_name is not None:
            result['ep_cert_name'] = self.ep_cert_name
        if self.ep_cert_no is not None:
            result['ep_cert_no'] = self.ep_cert_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('ep_cert_name') is not None:
            self.ep_cert_name = m.get('ep_cert_name')
        if m.get('ep_cert_no') is not None:
            self.ep_cert_no = m.get('ep_cert_no')
        return self


class CheckEpidentityTwometaResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        enterprise_status: str = None,
        open_time: str = None,
        passed: bool = None,
        code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 企业状态。
        self.enterprise_status = enterprise_status
        # 营业期限。
        self.open_time = open_time
        # 核验是否通过。
        self.passed = passed
        # 0:核验成功 1:企业信息有误 2:企业非正常营业
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.enterprise_status is not None:
            result['enterprise_status'] = self.enterprise_status
        if self.open_time is not None:
            result['open_time'] = self.open_time
        if self.passed is not None:
            result['passed'] = self.passed
        if self.code is not None:
            result['code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('enterprise_status') is not None:
            self.enterprise_status = m.get('enterprise_status')
        if m.get('open_time') is not None:
            self.open_time = m.get('open_time')
        if m.get('passed') is not None:
            self.passed = m.get('passed')
        if m.get('code') is not None:
            self.code = m.get('code')
        return self


class CheckEpidentityThreemetaRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        ep_cert_name: str = None,
        ep_cert_no: str = None,
        legal_person_cert_name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 认证企业名称。
        self.ep_cert_name = ep_cert_name
        # 企业证件号码。
        self.ep_cert_no = ep_cert_no
        # 企业法人姓名。
        self.legal_person_cert_name = legal_person_cert_name

    def validate(self):
        self.validate_required(self.ep_cert_name, 'ep_cert_name')
        self.validate_required(self.ep_cert_no, 'ep_cert_no')
        self.validate_required(self.legal_person_cert_name, 'legal_person_cert_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.ep_cert_name is not None:
            result['ep_cert_name'] = self.ep_cert_name
        if self.ep_cert_no is not None:
            result['ep_cert_no'] = self.ep_cert_no
        if self.legal_person_cert_name is not None:
            result['legal_person_cert_name'] = self.legal_person_cert_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('ep_cert_name') is not None:
            self.ep_cert_name = m.get('ep_cert_name')
        if m.get('ep_cert_no') is not None:
            self.ep_cert_no = m.get('ep_cert_no')
        if m.get('legal_person_cert_name') is not None:
            self.legal_person_cert_name = m.get('legal_person_cert_name')
        return self


class CheckEpidentityThreemetaResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        enterprise_status: str = None,
        open_time: str = None,
        passed: bool = None,
        code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 企业状态。
        self.enterprise_status = enterprise_status
        # 营业期限。
        self.open_time = open_time
        # 核验是否通过。
        self.passed = passed
        # 0:核验成功 1:企业信息有误 2:企业非正常营业
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.enterprise_status is not None:
            result['enterprise_status'] = self.enterprise_status
        if self.open_time is not None:
            result['open_time'] = self.open_time
        if self.passed is not None:
            result['passed'] = self.passed
        if self.code is not None:
            result['code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('enterprise_status') is not None:
            self.enterprise_status = m.get('enterprise_status')
        if m.get('open_time') is not None:
            self.open_time = m.get('open_time')
        if m.get('passed') is not None:
            self.passed = m.get('passed')
        if m.get('code') is not None:
            self.code = m.get('code')
        return self


class CheckEpidentityFourmetaRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        ep_cert_name: str = None,
        ep_cert_no: str = None,
        legal_person_cert_name: str = None,
        legal_person_cert_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 认证企业名称。
        self.ep_cert_name = ep_cert_name
        # 企业证件号码。
        self.ep_cert_no = ep_cert_no
        # 企业法人姓名。
        self.legal_person_cert_name = legal_person_cert_name
        # 企业法人身份证号码。
        self.legal_person_cert_no = legal_person_cert_no

    def validate(self):
        self.validate_required(self.ep_cert_name, 'ep_cert_name')
        self.validate_required(self.ep_cert_no, 'ep_cert_no')
        self.validate_required(self.legal_person_cert_name, 'legal_person_cert_name')
        self.validate_required(self.legal_person_cert_no, 'legal_person_cert_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.ep_cert_name is not None:
            result['ep_cert_name'] = self.ep_cert_name
        if self.ep_cert_no is not None:
            result['ep_cert_no'] = self.ep_cert_no
        if self.legal_person_cert_name is not None:
            result['legal_person_cert_name'] = self.legal_person_cert_name
        if self.legal_person_cert_no is not None:
            result['legal_person_cert_no'] = self.legal_person_cert_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('ep_cert_name') is not None:
            self.ep_cert_name = m.get('ep_cert_name')
        if m.get('ep_cert_no') is not None:
            self.ep_cert_no = m.get('ep_cert_no')
        if m.get('legal_person_cert_name') is not None:
            self.legal_person_cert_name = m.get('legal_person_cert_name')
        if m.get('legal_person_cert_no') is not None:
            self.legal_person_cert_no = m.get('legal_person_cert_no')
        return self


class CheckEpidentityFourmetaResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        enterprise_status: str = None,
        open_time: str = None,
        passed: bool = None,
        code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 企业状态。
        self.enterprise_status = enterprise_status
        # 营业期限。
        self.open_time = open_time
        # 核验是否通过。
        self.passed = passed
        # 0:核验成功 1:企业信息有误 2:企业非正常营业
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.enterprise_status is not None:
            result['enterprise_status'] = self.enterprise_status
        if self.open_time is not None:
            result['open_time'] = self.open_time
        if self.passed is not None:
            result['passed'] = self.passed
        if self.code is not None:
            result['code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('enterprise_status') is not None:
            self.enterprise_status = m.get('enterprise_status')
        if m.get('open_time') is not None:
            self.open_time = m.get('open_time')
        if m.get('passed') is not None:
            self.passed = m.get('passed')
        if m.get('code') is not None:
            self.code = m.get('code')
        return self


class CheckNotarizationOrderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 公证订单ID号
        self.order_id = order_id

    def validate(self):
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        return self


class CheckNotarizationOrderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        biz_id: List[str] = None,
        face_auth_code: str = None,
        user_id: str = None,
        valid: bool = None,
        org_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 下单的业务类型ID列表
        self.biz_id = biz_id
        # 实人认证接口调用授权码，与公证订单一一对应，有效次数默认为3次，超过调用次数则失效
        self.face_auth_code = face_auth_code
        # 下单客户的账号ID
        self.user_id = user_id
        # 是否为合法订单
        self.valid = valid
        # 平台公证机构ID
        self.org_id = org_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        if self.face_auth_code is not None:
            result['face_auth_code'] = self.face_auth_code
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.valid is not None:
            result['valid'] = self.valid
        if self.org_id is not None:
            result['org_id'] = self.org_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        if m.get('face_auth_code') is not None:
            self.face_auth_code = m.get('face_auth_code')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('valid') is not None:
            self.valid = m.get('valid')
        if m.get('org_id') is not None:
            self.org_id = m.get('org_id')
        return self


class UpdateNotarizationOrderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_id: str = None,
        reason: str = None,
        status: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 公证订单ID
        self.order_id = order_id
        # 如果出证失败，需要给出失败原因
        self.reason = reason
        # 出证状态的枚举值
        self.status = status

    def validate(self):
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.reason is not None:
            result['reason'] = self.reason
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('reason') is not None:
            self.reason = m.get('reason')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class UpdateNotarizationOrderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        accepted: bool = None,
        reason: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 状态是否更新成功
        self.accepted = accepted
        # 如更新失败，返回失败原因
        self.reason = reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.accepted is not None:
            result['accepted'] = self.accepted
        if self.reason is not None:
            result['reason'] = self.reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('accepted') is not None:
            self.accepted = m.get('accepted')
        if m.get('reason') is not None:
            self.reason = m.get('reason')
        return self


class SetNotarizationOrderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_code: str = None,
        key: str = None,
        order_id: str = None,
        value: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 公证事项ID
        self.biz_code = biz_code
        # 需设置的属性名称
        self.key = key
        # 公证订单ID
        self.order_id = order_id
        # 被设置字段的值
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_code is not None:
            result['biz_code'] = self.biz_code
        if self.key is not None:
            result['key'] = self.key
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_code') is not None:
            self.biz_code = m.get('biz_code')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class SetNotarizationOrderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        accepted: bool = None,
        reason: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否设置成功
        self.accepted = accepted
        # 如设置失败，返回失败原因
        self.reason = reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.accepted is not None:
            result['accepted'] = self.accepted
        if self.reason is not None:
            result['reason'] = self.reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('accepted') is not None:
            self.accepted = m.get('accepted')
        if m.get('reason') is not None:
            self.reason = m.get('reason')
        return self


class InitIdentificationFaceauthRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cert_name: str = None,
        cert_no: str = None,
        auth_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 认证人的姓名
        self.cert_name = cert_name
        # 被验证者的身份证号码
        self.cert_no = cert_no
        # 授权码，针对某些特定场景使用，非必填
        self.auth_code = auth_code

    def validate(self):
        self.validate_required(self.cert_name, 'cert_name')
        self.validate_required(self.cert_no, 'cert_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cert_name is not None:
            result['cert_name'] = self.cert_name
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.auth_code is not None:
            result['auth_code'] = self.auth_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cert_name') is not None:
            self.cert_name = m.get('cert_name')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('auth_code') is not None:
            self.auth_code = m.get('auth_code')
        return self


class InitIdentificationFaceauthResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        certify_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 发起一个实人认证流程，获取到流程ID
        self.certify_id = certify_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.certify_id is not None:
            result['certify_id'] = self.certify_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('certify_id') is not None:
            self.certify_id = m.get('certify_id')
        return self


class CertifyIdentificationFaceauthRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        certify_id: str = None,
        callback_url: str = None,
        redirect_url: str = None,
        auth_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实人认证流程ID
        self.certify_id = certify_id
        # 认证流程结束回调通知地址，非必传
        self.callback_url = callback_url
        # 认证结束后跳转地址，非必填
        self.redirect_url = redirect_url
        # 授权码，针对某些特定场景使用，非必填
        self.auth_code = auth_code

    def validate(self):
        self.validate_required(self.certify_id, 'certify_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.certify_id is not None:
            result['certify_id'] = self.certify_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.redirect_url is not None:
            result['redirect_url'] = self.redirect_url
        if self.auth_code is not None:
            result['auth_code'] = self.auth_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('certify_id') is not None:
            self.certify_id = m.get('certify_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('redirect_url') is not None:
            self.redirect_url = m.get('redirect_url')
        if m.get('auth_code') is not None:
            self.auth_code = m.get('auth_code')
        return self


class CertifyIdentificationFaceauthResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        certify_id: str = None,
        verify_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 实人认证流程ID
        self.certify_id = certify_id
        # 发起实人认证的地址
        self.verify_url = verify_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.certify_id is not None:
            result['certify_id'] = self.certify_id
        if self.verify_url is not None:
            result['verify_url'] = self.verify_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('certify_id') is not None:
            self.certify_id = m.get('certify_id')
        if m.get('verify_url') is not None:
            self.verify_url = m.get('verify_url')
        return self


class QueryIdentificationFaceauthRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        certify_id: str = None,
        auth_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实人认证流程ID
        self.certify_id = certify_id
        # 授权码，针对某些特定场景使用，非必填
        self.auth_code = auth_code

    def validate(self):
        self.validate_required(self.certify_id, 'certify_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.certify_id is not None:
            result['certify_id'] = self.certify_id
        if self.auth_code is not None:
            result['auth_code'] = self.auth_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('certify_id') is not None:
            self.certify_id = m.get('certify_id')
        if m.get('auth_code') is not None:
            self.auth_code = m.get('auth_code')
        return self


class QueryIdentificationFaceauthResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        certify_id: str = None,
        passed: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 实人认证流程ID
        self.certify_id = certify_id
        # 是否通过实人认证
        self.passed = passed

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.certify_id is not None:
            result['certify_id'] = self.certify_id
        if self.passed is not None:
            result['passed'] = self.passed
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('certify_id') is not None:
            self.certify_id = m.get('certify_id')
        if m.get('passed') is not None:
            self.passed = m.get('passed')
        return self


class QueryEnterpriseFaceauthRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 企业法人认证查询
        self.biz_no = biz_no

    def validate(self):
        self.validate_required(self.biz_no, 'biz_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_no is not None:
            result['biz_no'] = self.biz_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_no') is not None:
            self.biz_no = m.get('biz_no')
        return self


class QueryEnterpriseFaceauthResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        biz_no: str = None,
        failed_code: str = None,
        passed: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 认证唯一性标识
        self.biz_no = biz_no
        # 认证失败错误码
        self.failed_code = failed_code
        # 认证是否通过
        self.passed = passed

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.biz_no is not None:
            result['biz_no'] = self.biz_no
        if self.failed_code is not None:
            result['failed_code'] = self.failed_code
        if self.passed is not None:
            result['passed'] = self.passed
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('biz_no') is not None:
            self.biz_no = m.get('biz_no')
        if m.get('failed_code') is not None:
            self.failed_code = m.get('failed_code')
        if m.get('passed') is not None:
            self.passed = m.get('passed')
        return self


class InitEnterpriseFaceauthRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        ep_cert_name: str = None,
        ep_cert_no: str = None,
        ep_cert_type: str = None,
        legal_person_cert_name: str = None,
        legal_person_cert_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 企业名称
        self.ep_cert_name = ep_cert_name
        # 企业证件号
        self.ep_cert_no = ep_cert_no
        # 企业证件类型（NATIONAL_LEGAL（工商注册号）或 NATIONAL_LEGAL_MERGE （ 社会统一信用代码））
        self.ep_cert_type = ep_cert_type
        # 企业法人姓名
        self.legal_person_cert_name = legal_person_cert_name
        # 企业法人身份证号（目前仅支持身份证号）
        self.legal_person_cert_no = legal_person_cert_no

    def validate(self):
        self.validate_required(self.ep_cert_name, 'ep_cert_name')
        self.validate_required(self.ep_cert_no, 'ep_cert_no')
        self.validate_required(self.ep_cert_type, 'ep_cert_type')
        self.validate_required(self.legal_person_cert_name, 'legal_person_cert_name')
        self.validate_required(self.legal_person_cert_no, 'legal_person_cert_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.ep_cert_name is not None:
            result['ep_cert_name'] = self.ep_cert_name
        if self.ep_cert_no is not None:
            result['ep_cert_no'] = self.ep_cert_no
        if self.ep_cert_type is not None:
            result['ep_cert_type'] = self.ep_cert_type
        if self.legal_person_cert_name is not None:
            result['legal_person_cert_name'] = self.legal_person_cert_name
        if self.legal_person_cert_no is not None:
            result['legal_person_cert_no'] = self.legal_person_cert_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('ep_cert_name') is not None:
            self.ep_cert_name = m.get('ep_cert_name')
        if m.get('ep_cert_no') is not None:
            self.ep_cert_no = m.get('ep_cert_no')
        if m.get('ep_cert_type') is not None:
            self.ep_cert_type = m.get('ep_cert_type')
        if m.get('legal_person_cert_name') is not None:
            self.legal_person_cert_name = m.get('legal_person_cert_name')
        if m.get('legal_person_cert_no') is not None:
            self.legal_person_cert_no = m.get('legal_person_cert_no')
        return self


class InitEnterpriseFaceauthResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        biz_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 本次认证的业务唯一性标示
        self.biz_no = biz_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.biz_no is not None:
            result['biz_no'] = self.biz_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('biz_no') is not None:
            self.biz_no = m.get('biz_no')
        return self


class CertifyEnterpriseFaceauthRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_no: str = None,
        callback_url: str = None,
        redirect_url: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 业务唯一性标识
        self.biz_no = biz_no
        # 回调通知地址
        self.callback_url = callback_url
        # 认证完成后回跳地址
        self.redirect_url = redirect_url

    def validate(self):
        self.validate_required(self.biz_no, 'biz_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_no is not None:
            result['biz_no'] = self.biz_no
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.redirect_url is not None:
            result['redirect_url'] = self.redirect_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_no') is not None:
            self.biz_no = m.get('biz_no')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('redirect_url') is not None:
            self.redirect_url = m.get('redirect_url')
        return self


class CertifyEnterpriseFaceauthResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        biz_no: str = None,
        verify_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务唯一性标识
        self.biz_no = biz_no
        # 认证 url
        self.verify_url = verify_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.biz_no is not None:
            result['biz_no'] = self.biz_no
        if self.verify_url is not None:
            result['verify_url'] = self.verify_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('biz_no') is not None:
            self.biz_no = m.get('biz_no')
        if m.get('verify_url') is not None:
            self.verify_url = m.get('verify_url')
        return self


class CreateLeaseOrderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        alipay_order_amount: int = None,
        alipay_order_no: str = None,
        alipay_order_total_amount: int = None,
        deposit_waive_amount: int = None,
        insurance_coverage: int = None,
        insurance_order_no: str = None,
        item_name: str = None,
        item_price: int = None,
        item_type: str = None,
        merchant_alipay_account: str = None,
        merchant_alipay_id: str = None,
        merchant_name: str = None,
        merchant_order_no: str = None,
        payment_channel: str = None,
        tenancy_term_end: int = None,
        tenancy_term_start: int = None,
        insured: bool = None,
        insurance_order_url: str = None,
        insurance_bill_no: str = None,
        insurance_bill_time: str = None,
        insurance_bill_amount: int = None,
        insurance_product_coverage: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 账号标识，可弃用
        self.account_id = account_id
        # 支付宝交易金额
        self.alipay_order_amount = alipay_order_amount
        # 支付宝订单号
        self.alipay_order_no = alipay_order_no
        # 支付宝交易总金额
        self.alipay_order_total_amount = alipay_order_total_amount
        # 免押金额
        self.deposit_waive_amount = deposit_waive_amount
        # 订单总保额，单位分，insured为True时必填
        self.insurance_coverage = insurance_coverage
        # 保单号，insured为True时必填，仅支持数字和字母
        self.insurance_order_no = insurance_order_no
        # 商品名称
        self.item_name = item_name
        # 商品市场价格
        self.item_price = item_price
        # 商品类目
        self.item_type = item_type
        # 商户支付宝账号
        self.merchant_alipay_account = merchant_alipay_account
        # 商户支付宝ID
        self.merchant_alipay_id = merchant_alipay_id
        # 商户名称
        self.merchant_name = merchant_name
        # 商户单号
        self.merchant_order_no = merchant_order_no
        # 支付渠道，包括支付宝（Alipay）、第三方收单机构（ThirdParty）、信用卡（CreditCard）、银行转账（BankTransfer）、微信（WeChatPay）、其他（Other）
        self.payment_channel = payment_channel
        # 租约结束日期
        self.tenancy_term_end = tenancy_term_end
        # 租约起始日期
        self.tenancy_term_start = tenancy_term_start
        # 是否投保，默认为True
        self.insured = insured
        # 保单查询地址，insured为True时必填
        self.insurance_order_url = insurance_order_url
        # 保险缴费单号，insured为True时必填，仅支持数字和字母，长度20
        self.insurance_bill_no = insurance_bill_no
        # 保险缴费北京时间，格式为"YYYYMMDDHHMISS"，时区为UTC+8
        self.insurance_bill_time = insurance_bill_time
        # 保险缴费金额，单位分
        self.insurance_bill_amount = insurance_bill_amount
        # 订单产品保额，单位分，insured为True时必填
        self.insurance_product_coverage = insurance_product_coverage

    def validate(self):
        self.validate_required(self.alipay_order_amount, 'alipay_order_amount')
        if self.alipay_order_amount is not None:
            self.validate_minimum(self.alipay_order_amount, 'alipay_order_amount', 0)
        self.validate_required(self.alipay_order_no, 'alipay_order_no')
        self.validate_required(self.alipay_order_total_amount, 'alipay_order_total_amount')
        if self.alipay_order_total_amount is not None:
            self.validate_minimum(self.alipay_order_total_amount, 'alipay_order_total_amount', 0)
        self.validate_required(self.deposit_waive_amount, 'deposit_waive_amount')
        if self.deposit_waive_amount is not None:
            self.validate_minimum(self.deposit_waive_amount, 'deposit_waive_amount', 0)
        if self.insurance_coverage is not None:
            self.validate_minimum(self.insurance_coverage, 'insurance_coverage', 0)
        self.validate_required(self.item_name, 'item_name')
        self.validate_required(self.item_price, 'item_price')
        if self.item_price is not None:
            self.validate_minimum(self.item_price, 'item_price', 0)
        self.validate_required(self.item_type, 'item_type')
        self.validate_required(self.merchant_alipay_account, 'merchant_alipay_account')
        self.validate_required(self.merchant_alipay_id, 'merchant_alipay_id')
        self.validate_required(self.merchant_name, 'merchant_name')
        self.validate_required(self.tenancy_term_end, 'tenancy_term_end')
        if self.tenancy_term_end is not None:
            self.validate_minimum(self.tenancy_term_end, 'tenancy_term_end', 0)
        self.validate_required(self.tenancy_term_start, 'tenancy_term_start')
        if self.tenancy_term_start is not None:
            self.validate_minimum(self.tenancy_term_start, 'tenancy_term_start', 0)

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.alipay_order_amount is not None:
            result['alipay_order_amount'] = self.alipay_order_amount
        if self.alipay_order_no is not None:
            result['alipay_order_no'] = self.alipay_order_no
        if self.alipay_order_total_amount is not None:
            result['alipay_order_total_amount'] = self.alipay_order_total_amount
        if self.deposit_waive_amount is not None:
            result['deposit_waive_amount'] = self.deposit_waive_amount
        if self.insurance_coverage is not None:
            result['insurance_coverage'] = self.insurance_coverage
        if self.insurance_order_no is not None:
            result['insurance_order_no'] = self.insurance_order_no
        if self.item_name is not None:
            result['item_name'] = self.item_name
        if self.item_price is not None:
            result['item_price'] = self.item_price
        if self.item_type is not None:
            result['item_type'] = self.item_type
        if self.merchant_alipay_account is not None:
            result['merchant_alipay_account'] = self.merchant_alipay_account
        if self.merchant_alipay_id is not None:
            result['merchant_alipay_id'] = self.merchant_alipay_id
        if self.merchant_name is not None:
            result['merchant_name'] = self.merchant_name
        if self.merchant_order_no is not None:
            result['merchant_order_no'] = self.merchant_order_no
        if self.payment_channel is not None:
            result['payment_channel'] = self.payment_channel
        if self.tenancy_term_end is not None:
            result['tenancy_term_end'] = self.tenancy_term_end
        if self.tenancy_term_start is not None:
            result['tenancy_term_start'] = self.tenancy_term_start
        if self.insured is not None:
            result['insured'] = self.insured
        if self.insurance_order_url is not None:
            result['insurance_order_url'] = self.insurance_order_url
        if self.insurance_bill_no is not None:
            result['insurance_bill_no'] = self.insurance_bill_no
        if self.insurance_bill_time is not None:
            result['insurance_bill_time'] = self.insurance_bill_time
        if self.insurance_bill_amount is not None:
            result['insurance_bill_amount'] = self.insurance_bill_amount
        if self.insurance_product_coverage is not None:
            result['insurance_product_coverage'] = self.insurance_product_coverage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('alipay_order_amount') is not None:
            self.alipay_order_amount = m.get('alipay_order_amount')
        if m.get('alipay_order_no') is not None:
            self.alipay_order_no = m.get('alipay_order_no')
        if m.get('alipay_order_total_amount') is not None:
            self.alipay_order_total_amount = m.get('alipay_order_total_amount')
        if m.get('deposit_waive_amount') is not None:
            self.deposit_waive_amount = m.get('deposit_waive_amount')
        if m.get('insurance_coverage') is not None:
            self.insurance_coverage = m.get('insurance_coverage')
        if m.get('insurance_order_no') is not None:
            self.insurance_order_no = m.get('insurance_order_no')
        if m.get('item_name') is not None:
            self.item_name = m.get('item_name')
        if m.get('item_price') is not None:
            self.item_price = m.get('item_price')
        if m.get('item_type') is not None:
            self.item_type = m.get('item_type')
        if m.get('merchant_alipay_account') is not None:
            self.merchant_alipay_account = m.get('merchant_alipay_account')
        if m.get('merchant_alipay_id') is not None:
            self.merchant_alipay_id = m.get('merchant_alipay_id')
        if m.get('merchant_name') is not None:
            self.merchant_name = m.get('merchant_name')
        if m.get('merchant_order_no') is not None:
            self.merchant_order_no = m.get('merchant_order_no')
        if m.get('payment_channel') is not None:
            self.payment_channel = m.get('payment_channel')
        if m.get('tenancy_term_end') is not None:
            self.tenancy_term_end = m.get('tenancy_term_end')
        if m.get('tenancy_term_start') is not None:
            self.tenancy_term_start = m.get('tenancy_term_start')
        if m.get('insured') is not None:
            self.insured = m.get('insured')
        if m.get('insurance_order_url') is not None:
            self.insurance_order_url = m.get('insurance_order_url')
        if m.get('insurance_bill_no') is not None:
            self.insurance_bill_no = m.get('insurance_bill_no')
        if m.get('insurance_bill_time') is not None:
            self.insurance_bill_time = m.get('insurance_bill_time')
        if m.get('insurance_bill_amount') is not None:
            self.insurance_bill_amount = m.get('insurance_bill_amount')
        if m.get('insurance_product_coverage') is not None:
            self.insurance_product_coverage = m.get('insurance_product_coverage')
        return self


class CreateLeaseOrderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否成功
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateNotarizationBillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        alipay_order_no: str = None,
        alipay_uid: str = None,
        cert_name: str = None,
        cert_no: str = None,
        e_notarization_biz: str = None,
        e_notarization_download_url: str = None,
        e_notarization_no: str = None,
        e_notarization_page_no: str = None,
        e_notarization_status: str = None,
        e_notarization_usage: str = None,
        e_notarization_valid_date: str = None,
        legal_person_name: str = None,
        order_id: str = None,
        org_id: str = None,
        payment_amount: int = None,
        phone: str = None,
        scenario: str = None,
        user_type: int = None,
        fee_splitting: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 支付宝交易订单号
        self.alipay_order_no = alipay_order_no
        # 支付宝用户ID
        self.alipay_uid = alipay_uid
        # 申请者名称
        self.cert_name = cert_name
        # 申请者证件号码：身份证号码（个人用户）或企业统一社会信用代码（企业用户）
        self.cert_no = cert_no
        # 电子公证书业务细项，如“200”对应出生公证
        self.e_notarization_biz = e_notarization_biz
        # 电子公证书下载地址
        self.e_notarization_download_url = e_notarization_download_url
        # 电子公证书编号
        self.e_notarization_no = e_notarization_no
        # 电子公证书页数
        self.e_notarization_page_no = e_notarization_page_no
        # 电子公证书状态码
        self.e_notarization_status = e_notarization_status
        # 电子公证书业务用途
        self.e_notarization_usage = e_notarization_usage
        # 电子公证书有效期
        self.e_notarization_valid_date = e_notarization_valid_date
        # 企业法人姓名（企业用户必填）
        self.legal_person_name = legal_person_name
        # 出证订单ID
        self.order_id = order_id
        # 出证机构ID
        self.org_id = org_id
        # 支付宝交易订单支付金额（人民币），单位为分
        self.payment_amount = payment_amount
        # 联系电话
        self.phone = phone
        # 场景枚举：E_NOTARIZATION（电子公证），NOTARY_CERTIFICATION（存证证明）
        self.scenario = scenario
        # 申请者身份类型，1个人，2企业
        self.user_type = user_type
        # 是否为酬金分润方式，是则按照订金额一定比例分润，否则直接支付订单金额
        self.fee_splitting = fee_splitting

    def validate(self):
        if self.e_notarization_valid_date is not None:
            self.validate_pattern(self.e_notarization_valid_date, 'e_notarization_valid_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.scenario, 'scenario')
        self.validate_required(self.fee_splitting, 'fee_splitting')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.alipay_order_no is not None:
            result['alipay_order_no'] = self.alipay_order_no
        if self.alipay_uid is not None:
            result['alipay_uid'] = self.alipay_uid
        if self.cert_name is not None:
            result['cert_name'] = self.cert_name
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.e_notarization_biz is not None:
            result['e_notarization_biz'] = self.e_notarization_biz
        if self.e_notarization_download_url is not None:
            result['e_notarization_download_url'] = self.e_notarization_download_url
        if self.e_notarization_no is not None:
            result['e_notarization_no'] = self.e_notarization_no
        if self.e_notarization_page_no is not None:
            result['e_notarization_page_no'] = self.e_notarization_page_no
        if self.e_notarization_status is not None:
            result['e_notarization_status'] = self.e_notarization_status
        if self.e_notarization_usage is not None:
            result['e_notarization_usage'] = self.e_notarization_usage
        if self.e_notarization_valid_date is not None:
            result['e_notarization_valid_date'] = self.e_notarization_valid_date
        if self.legal_person_name is not None:
            result['legal_person_name'] = self.legal_person_name
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.org_id is not None:
            result['org_id'] = self.org_id
        if self.payment_amount is not None:
            result['payment_amount'] = self.payment_amount
        if self.phone is not None:
            result['phone'] = self.phone
        if self.scenario is not None:
            result['scenario'] = self.scenario
        if self.user_type is not None:
            result['user_type'] = self.user_type
        if self.fee_splitting is not None:
            result['fee_splitting'] = self.fee_splitting
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('alipay_order_no') is not None:
            self.alipay_order_no = m.get('alipay_order_no')
        if m.get('alipay_uid') is not None:
            self.alipay_uid = m.get('alipay_uid')
        if m.get('cert_name') is not None:
            self.cert_name = m.get('cert_name')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('e_notarization_biz') is not None:
            self.e_notarization_biz = m.get('e_notarization_biz')
        if m.get('e_notarization_download_url') is not None:
            self.e_notarization_download_url = m.get('e_notarization_download_url')
        if m.get('e_notarization_no') is not None:
            self.e_notarization_no = m.get('e_notarization_no')
        if m.get('e_notarization_page_no') is not None:
            self.e_notarization_page_no = m.get('e_notarization_page_no')
        if m.get('e_notarization_status') is not None:
            self.e_notarization_status = m.get('e_notarization_status')
        if m.get('e_notarization_usage') is not None:
            self.e_notarization_usage = m.get('e_notarization_usage')
        if m.get('e_notarization_valid_date') is not None:
            self.e_notarization_valid_date = m.get('e_notarization_valid_date')
        if m.get('legal_person_name') is not None:
            self.legal_person_name = m.get('legal_person_name')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('org_id') is not None:
            self.org_id = m.get('org_id')
        if m.get('payment_amount') is not None:
            self.payment_amount = m.get('payment_amount')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('scenario') is not None:
            self.scenario = m.get('scenario')
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        if m.get('fee_splitting') is not None:
            self.fee_splitting = m.get('fee_splitting')
        return self


class CreateNotarizationBillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        accepted: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 计费订单是否创建成功
        self.accepted = accepted

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.accepted is not None:
            result['accepted'] = self.accepted
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('accepted') is not None:
            self.accepted = m.get('accepted')
        return self


class InitCertificationRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        applier: Identity = None,
        notary_info: List[NotaryInfo] = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 申请人的身份信息
        self.applier = applier
        # 存证证明所要展示的存证信息，可填多个
        self.notary_info = notary_info
        # 存证证明的类型：STANDARD（标准存证证明）或COPYRIGHT（版权存证证明），默认为COPYRIGHT
        self.type = type

    def validate(self):
        self.validate_required(self.applier, 'applier')
        if self.applier:
            self.applier.validate()
        self.validate_required(self.notary_info, 'notary_info')
        if self.notary_info:
            for k in self.notary_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.applier is not None:
            result['applier'] = self.applier.to_map()
        result['notary_info'] = []
        if self.notary_info is not None:
            for k in self.notary_info:
                result['notary_info'].append(k.to_map() if k else None)
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('applier') is not None:
            temp_model = Identity()
            self.applier = temp_model.from_map(m['applier'])
        self.notary_info = []
        if m.get('notary_info') is not None:
            for k in m.get('notary_info'):
                temp_model = NotaryInfo()
                self.notary_info.append(temp_model.from_map(k))
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class InitCertificationResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: str = None,
        message: str = None,
        order_id: str = None,
        pay_content: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回值状态码，0000则为成功
        self.code = code
        # 异常状态时的错误信息
        self.message = message
        # 后端生成的存证证明申请订单ID
        self.order_id = order_id
        # 如果是记账模式则为空，其余情况返回支付宝SDK生成的支付内容信息
        self.pay_content = pay_content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.pay_content is not None:
            result['pay_content'] = self.pay_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('pay_content') is not None:
            self.pay_content = m.get('pay_content')
        return self


class QueryCertificationRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 存证证明申请的订单ID
        self.order_id = order_id

    def validate(self):
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        return self


class QueryCertificationResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        certificate_info: List[CertificateInfo] = None,
        code: str = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 存证证明的证书信息列表
        self.certificate_info = certificate_info
        # 返回值状态码，0000则为成功
        self.code = code
        # 异常状态时的错误信息
        self.message = message

    def validate(self):
        if self.certificate_info:
            for k in self.certificate_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['certificate_info'] = []
        if self.certificate_info is not None:
            for k in self.certificate_info:
                result['certificate_info'].append(k.to_map() if k else None)
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.certificate_info = []
        if m.get('certificate_info') is not None:
            for k in m.get('certificate_info'):
                temp_model = CertificateInfo()
                self.certificate_info.append(temp_model.from_map(k))
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class GetTsrCertificateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        return self


class GetTsrCertificateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CreateIdentificationRealpersonRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cert_name: str = None,
        cert_no: str = None,
        auth_code: str = None,
        callback_url: str = None,
        return_url: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 认证人的姓名
        self.cert_name = cert_name
        # 被验证者的身份证号码
        self.cert_no = cert_no
        # 授权码，针对某些特定场景使用，非必填
        self.auth_code = auth_code
        # 认证流程结束回调通知地址，非必传
        self.callback_url = callback_url
        # 认证结束后跳转地址，非必填
        self.return_url = return_url

    def validate(self):
        self.validate_required(self.cert_name, 'cert_name')
        self.validate_required(self.cert_no, 'cert_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cert_name is not None:
            result['cert_name'] = self.cert_name
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.auth_code is not None:
            result['auth_code'] = self.auth_code
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.return_url is not None:
            result['return_url'] = self.return_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cert_name') is not None:
            self.cert_name = m.get('cert_name')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('auth_code') is not None:
            self.auth_code = m.get('auth_code')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('return_url') is not None:
            self.return_url = m.get('return_url')
        return self


class CreateIdentificationRealpersonResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        certify_id: str = None,
        certify_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 实人认证流程ID
        self.certify_id = certify_id
        # 发起实人认证的地址
        self.certify_url = certify_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.certify_id is not None:
            result['certify_id'] = self.certify_id
        if self.certify_url is not None:
            result['certify_url'] = self.certify_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('certify_id') is not None:
            self.certify_id = m.get('certify_id')
        if m.get('certify_url') is not None:
            self.certify_url = m.get('certify_url')
        return self


class QueryIdentificationRealpersonRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        certify_id: str = None,
        auth_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实人认证流程ID
        self.certify_id = certify_id
        # 授权码，针对某些特定场景使用，非必填
        self.auth_code = auth_code

    def validate(self):
        self.validate_required(self.certify_id, 'certify_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.certify_id is not None:
            result['certify_id'] = self.certify_id
        if self.auth_code is not None:
            result['auth_code'] = self.auth_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('certify_id') is not None:
            self.certify_id = m.get('certify_id')
        if m.get('auth_code') is not None:
            self.auth_code = m.get('auth_code')
        return self


class QueryIdentificationRealpersonResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        certify_id: str = None,
        passed: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 实人认证流程ID
        self.certify_id = certify_id
        # 是否通过实人认证
        self.passed = passed

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.certify_id is not None:
            result['certify_id'] = self.certify_id
        if self.passed is not None:
            result['passed'] = self.passed
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('certify_id') is not None:
            self.certify_id = m.get('certify_id')
        if m.get('passed') is not None:
            self.passed = m.get('passed')
        return self


class SaveJointconstraintRecordRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        beneficiary_account_code: str = None,
        beneficiary_account_type: int = None,
        beneficiary_cert_number: str = None,
        beneficiary_cert_type: int = None,
        beneficiary_type: int = None,
        contract_code: str = None,
        contract_fulfillment_code: str = None,
        contract_name: str = None,
        contract_txhash: str = None,
        external_url: str = None,
        industry_code: str = None,
        paid_amount: str = None,
        paid_proof: str = None,
        paid_time: str = None,
        payer_account_code: str = None,
        payer_account_type: int = None,
        payer_cert_number: str = None,
        payer_cert_type: int = None,
        payer_type: int = None,
        payment_amount: str = None,
        payment_date_buffer: int = None,
        payment_deadline: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 收款账户
        self.beneficiary_account_code = beneficiary_account_code
        # 收款账户类型
        # 
        # 1：支付宝
        self.beneficiary_account_type = beneficiary_account_type
        # 应收方证件号码
        # 
        # 
        self.beneficiary_cert_number = beneficiary_cert_number
        # 应收方证件类型
        # 
        # 0：统一社会信用代码
        # 
        # 1：身份证号码
        self.beneficiary_cert_type = beneficiary_cert_type
        # 
        # 应收方类型
        # 
        # 0：企业
        # 
        # 1：个人
        self.beneficiary_type = beneficiary_type
        # 合同编号
        self.contract_code = contract_code
        # 合同履行记录标签
        self.contract_fulfillment_code = contract_fulfillment_code
        # 合同名称
        self.contract_name = contract_name
        # 合同存证哈希
        self.contract_txhash = contract_txhash
        # 商户端合同链接
        # 
        # 从智能合同小程序中跳转至商户端查看合同内容链接
        self.external_url = external_url
        # 所属行业，来自合同
        # 
        # 
        self.industry_code = industry_code
        # 已付金额
        # 
        # 
        self.paid_amount = paid_amount
        # 支付凭据
        # 
        # 
        self.paid_proof = paid_proof
        # 付款时间
        # 
        # 
        self.paid_time = paid_time
        # 付款账户
        # 
        # 
        self.payer_account_code = payer_account_code
        # 
        # 付款账户类型
        # 
        # 1：支付宝
        self.payer_account_type = payer_account_type
        # 应付方证件号码
        # 
        # 
        self.payer_cert_number = payer_cert_number
        # 应付方证件类型
        # 
        # 0：统一社会信用代码
        # 
        # 1：身份证号码
        self.payer_cert_type = payer_cert_type
        # 应付方类型
        # 
        # 0：企业
        # 
        # 1：个人
        self.payer_type = payer_type
        # 履约标的金额
        # 
        # 
        self.payment_amount = payment_amount
        # 履约宽限期，单位：天
        # 
        # 
        self.payment_date_buffer = payment_date_buffer
        # 目标履约日期
        # 
        # 
        self.payment_deadline = payment_deadline

    def validate(self):
        self.validate_required(self.beneficiary_cert_number, 'beneficiary_cert_number')
        self.validate_required(self.beneficiary_cert_type, 'beneficiary_cert_type')
        self.validate_required(self.beneficiary_type, 'beneficiary_type')
        self.validate_required(self.contract_code, 'contract_code')
        self.validate_required(self.contract_fulfillment_code, 'contract_fulfillment_code')
        self.validate_required(self.contract_name, 'contract_name')
        self.validate_required(self.contract_txhash, 'contract_txhash')
        if self.paid_time is not None:
            self.validate_pattern(self.paid_time, 'paid_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.payer_cert_number, 'payer_cert_number')
        self.validate_required(self.payer_cert_type, 'payer_cert_type')
        self.validate_required(self.payer_type, 'payer_type')
        self.validate_required(self.payment_amount, 'payment_amount')
        self.validate_required(self.payment_deadline, 'payment_deadline')
        if self.payment_deadline is not None:
            self.validate_pattern(self.payment_deadline, 'payment_deadline', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.beneficiary_account_code is not None:
            result['beneficiary_account_code'] = self.beneficiary_account_code
        if self.beneficiary_account_type is not None:
            result['beneficiary_account_type'] = self.beneficiary_account_type
        if self.beneficiary_cert_number is not None:
            result['beneficiary_cert_number'] = self.beneficiary_cert_number
        if self.beneficiary_cert_type is not None:
            result['beneficiary_cert_type'] = self.beneficiary_cert_type
        if self.beneficiary_type is not None:
            result['beneficiary_type'] = self.beneficiary_type
        if self.contract_code is not None:
            result['contract_code'] = self.contract_code
        if self.contract_fulfillment_code is not None:
            result['contract_fulfillment_code'] = self.contract_fulfillment_code
        if self.contract_name is not None:
            result['contract_name'] = self.contract_name
        if self.contract_txhash is not None:
            result['contract_txhash'] = self.contract_txhash
        if self.external_url is not None:
            result['external_url'] = self.external_url
        if self.industry_code is not None:
            result['industry_code'] = self.industry_code
        if self.paid_amount is not None:
            result['paid_amount'] = self.paid_amount
        if self.paid_proof is not None:
            result['paid_proof'] = self.paid_proof
        if self.paid_time is not None:
            result['paid_time'] = self.paid_time
        if self.payer_account_code is not None:
            result['payer_account_code'] = self.payer_account_code
        if self.payer_account_type is not None:
            result['payer_account_type'] = self.payer_account_type
        if self.payer_cert_number is not None:
            result['payer_cert_number'] = self.payer_cert_number
        if self.payer_cert_type is not None:
            result['payer_cert_type'] = self.payer_cert_type
        if self.payer_type is not None:
            result['payer_type'] = self.payer_type
        if self.payment_amount is not None:
            result['payment_amount'] = self.payment_amount
        if self.payment_date_buffer is not None:
            result['payment_date_buffer'] = self.payment_date_buffer
        if self.payment_deadline is not None:
            result['payment_deadline'] = self.payment_deadline
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('beneficiary_account_code') is not None:
            self.beneficiary_account_code = m.get('beneficiary_account_code')
        if m.get('beneficiary_account_type') is not None:
            self.beneficiary_account_type = m.get('beneficiary_account_type')
        if m.get('beneficiary_cert_number') is not None:
            self.beneficiary_cert_number = m.get('beneficiary_cert_number')
        if m.get('beneficiary_cert_type') is not None:
            self.beneficiary_cert_type = m.get('beneficiary_cert_type')
        if m.get('beneficiary_type') is not None:
            self.beneficiary_type = m.get('beneficiary_type')
        if m.get('contract_code') is not None:
            self.contract_code = m.get('contract_code')
        if m.get('contract_fulfillment_code') is not None:
            self.contract_fulfillment_code = m.get('contract_fulfillment_code')
        if m.get('contract_name') is not None:
            self.contract_name = m.get('contract_name')
        if m.get('contract_txhash') is not None:
            self.contract_txhash = m.get('contract_txhash')
        if m.get('external_url') is not None:
            self.external_url = m.get('external_url')
        if m.get('industry_code') is not None:
            self.industry_code = m.get('industry_code')
        if m.get('paid_amount') is not None:
            self.paid_amount = m.get('paid_amount')
        if m.get('paid_proof') is not None:
            self.paid_proof = m.get('paid_proof')
        if m.get('paid_time') is not None:
            self.paid_time = m.get('paid_time')
        if m.get('payer_account_code') is not None:
            self.payer_account_code = m.get('payer_account_code')
        if m.get('payer_account_type') is not None:
            self.payer_account_type = m.get('payer_account_type')
        if m.get('payer_cert_number') is not None:
            self.payer_cert_number = m.get('payer_cert_number')
        if m.get('payer_cert_type') is not None:
            self.payer_cert_type = m.get('payer_cert_type')
        if m.get('payer_type') is not None:
            self.payer_type = m.get('payer_type')
        if m.get('payment_amount') is not None:
            self.payment_amount = m.get('payment_amount')
        if m.get('payment_date_buffer') is not None:
            self.payment_date_buffer = m.get('payment_date_buffer')
        if m.get('payment_deadline') is not None:
            self.payment_deadline = m.get('payment_deadline')
        return self


class SaveJointconstraintRecordResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteJointconstraintRecordRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        contract_code: str = None,
        contract_fulfillment_code: str = None,
        payer_cert_number: str = None,
        payer_cert_type: int = None,
        payer_type: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 合同编号
        # 
        # 
        self.contract_code = contract_code
        # 合同履行记录标签
        # 
        # 
        self.contract_fulfillment_code = contract_fulfillment_code
        # 应付方证件号码
        # 
        # 
        self.payer_cert_number = payer_cert_number
        # 应付方证件类型
        # 
        # 0：统一社会信用代码
        # 
        # 1：身份证号码
        self.payer_cert_type = payer_cert_type
        # 应付方类型
        # 
        # 0：企业
        # 
        # 1：个人
        self.payer_type = payer_type

    def validate(self):
        self.validate_required(self.contract_code, 'contract_code')
        self.validate_required(self.contract_fulfillment_code, 'contract_fulfillment_code')
        self.validate_required(self.payer_cert_number, 'payer_cert_number')
        self.validate_required(self.payer_cert_type, 'payer_cert_type')
        self.validate_required(self.payer_type, 'payer_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.contract_code is not None:
            result['contract_code'] = self.contract_code
        if self.contract_fulfillment_code is not None:
            result['contract_fulfillment_code'] = self.contract_fulfillment_code
        if self.payer_cert_number is not None:
            result['payer_cert_number'] = self.payer_cert_number
        if self.payer_cert_type is not None:
            result['payer_cert_type'] = self.payer_cert_type
        if self.payer_type is not None:
            result['payer_type'] = self.payer_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('contract_code') is not None:
            self.contract_code = m.get('contract_code')
        if m.get('contract_fulfillment_code') is not None:
            self.contract_fulfillment_code = m.get('contract_fulfillment_code')
        if m.get('payer_cert_number') is not None:
            self.payer_cert_number = m.get('payer_cert_number')
        if m.get('payer_cert_type') is not None:
            self.payer_cert_type = m.get('payer_cert_type')
        if m.get('payer_type') is not None:
            self.payer_type = m.get('payer_type')
        return self


class DeleteJointconstraintRecordResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryJointconstraintBreachrecordRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        entity_type: int = None,
        cert_type: int = None,
        cert_number: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询对象实体类型
        # 
        # 0：企业
        # 
        # 1：个人
        self.entity_type = entity_type
        # 对象实体证件类型
        # 
        # 0：统一社会信用代码
        # 
        # 1：身份证号码
        self.cert_type = cert_type
        # 对象实体证件号码
        # 
        # 
        self.cert_number = cert_number

    def validate(self):
        self.validate_required(self.entity_type, 'entity_type')
        self.validate_required(self.cert_type, 'cert_type')
        self.validate_required(self.cert_number, 'cert_number')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        if self.cert_number is not None:
            result['cert_number'] = self.cert_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        if m.get('cert_number') is not None:
            self.cert_number = m.get('cert_number')
        return self


class QueryJointconstraintBreachrecordResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        has_record: bool = None,
        breach_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否存在履行记录
        # 
        # 
        self.has_record = has_record
        # 违约次数
        # 
        # 
        self.breach_count = breach_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.has_record is not None:
            result['has_record'] = self.has_record
        if self.breach_count is not None:
            result['breach_count'] = self.breach_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('has_record') is not None:
            self.has_record = m.get('has_record')
        if m.get('breach_count') is not None:
            self.breach_count = m.get('breach_count')
        return self


class ApplyJusticeMediationRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        product_code: str = None,
        court_code: str = None,
        case_body: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 机构码 由蚂蚁分配
        self.product_code = product_code
        # 法院代码 由蚂蚁提供
        self.court_code = court_code
        # 案件内容 JsonString 格式{"agencyRelations":[],"agents":[],"caseInfo":{},"litigants":{}}
        self.case_body = case_body

    def validate(self):
        self.validate_required(self.product_code, 'product_code')
        self.validate_required(self.court_code, 'court_code')
        self.validate_required(self.case_body, 'case_body')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.court_code is not None:
            result['court_code'] = self.court_code
        if self.case_body is not None:
            result['case_body'] = self.case_body
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('court_code') is not None:
            self.court_code = m.get('court_code')
        if m.get('case_body') is not None:
            self.case_body = m.get('case_body')
        return self


class ApplyJusticeMediationResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class QueryJusticeMediationRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        product_code: str = None,
        case_number: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 产品码 由蚂蚁分配
        # 
        self.product_code = product_code
        # 案件编号
        self.case_number = case_number

    def validate(self):
        self.validate_required(self.product_code, 'product_code')
        self.validate_required(self.case_number, 'case_number')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.case_number is not None:
            result['case_number'] = self.case_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('case_number') is not None:
            self.case_number = m.get('case_number')
        return self


class QueryJusticeMediationResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        message: str = None,
        mediation_case_detail_info: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message
        # 案件处理进度信息对象
        self.mediation_case_detail_info = mediation_case_detail_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.mediation_case_detail_info is not None:
            result['mediation_case_detail_info'] = self.mediation_case_detail_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('mediation_case_detail_info') is not None:
            self.mediation_case_detail_info = m.get('mediation_case_detail_info')
        return self


class QueryJusticeCaseinfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        client_token: str = None,
        case_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。clientToken只支持ASCII字符，且不能超过64个字符。
        self.client_token = client_token
        # 案件编号
        self.case_no = case_no

    def validate(self):
        self.validate_required(self.client_token, 'client_token')
        self.validate_required(self.case_no, 'case_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.client_token is not None:
            result['client_token'] = self.client_token
        if self.case_no is not None:
            result['case_no'] = self.case_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('client_token') is not None:
            self.client_token = m.get('client_token')
        if m.get('case_no') is not None:
            self.case_no = m.get('case_no')
        return self


class QueryJusticeCaseinfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        case_no: str = None,
        evidential_element: EvidentialElement = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询的案件编号
        self.case_no = case_no
        # 证据要素
        self.evidential_element = evidential_element
        # 业务码，0表示成功
        self.code = code
        # 业务码信息
        self.message = message

    def validate(self):
        if self.evidential_element:
            self.evidential_element.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.case_no is not None:
            result['case_no'] = self.case_no
        if self.evidential_element is not None:
            result['evidential_element'] = self.evidential_element.to_map()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('case_no') is not None:
            self.case_no = m.get('case_no')
        if m.get('evidential_element') is not None:
            temp_model = EvidentialElement()
            self.evidential_element = temp_model.from_map(m['evidential_element'])
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class GetJusticeUploadfilepathRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_name: str = None,
        client_token: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 文件名称（最长128个字符）
        self.file_name = file_name
        # 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。clientToken只支持ASCII字符，且不能超过64个字符。
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.file_name, 'file_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.client_token is not None:
            result['client_token'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('client_token') is not None:
            self.client_token = m.get('client_token')
        return self


class GetJusticeUploadfilepathResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        upload_file_url: str = None,
        file_key: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # OSS上传链接
        self.upload_file_url = upload_file_url
        # 文件key
        self.file_key = file_key
        # 业务码 0表示成功
        self.code = code
        # 业务码描述
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.upload_file_url is not None:
            result['upload_file_url'] = self.upload_file_url
        if self.file_key is not None:
            result['file_key'] = self.file_key
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('upload_file_url') is not None:
            self.upload_file_url = m.get('upload_file_url')
        if m.get('file_key') is not None:
            self.file_key = m.get('file_key')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateJusticeCasewritebackRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        client_token: str = None,
        case_basic_info: CaseBasicInfo = None,
        proposer_objects: List[ProposerObject] = None,
        pleader_objects: List[PleaderObject] = None,
        lease_evidential_element: LeaseEvidentialElement = None,
        evidential_check_list: List[EvidentialCheckList] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。clientToken只支持ASCII字符，且不能超过64个字符。
        self.client_token = client_token
        # 自动进件案件基础信息
        self.case_basic_info = case_basic_info
        # 发起人对象列表
        self.proposer_objects = proposer_objects
        # 答辩人对象列表
        self.pleader_objects = pleader_objects
        # 自动进件证据要素
        self.lease_evidential_element = lease_evidential_element
        # 证据清单列表
        self.evidential_check_list = evidential_check_list

    def validate(self):
        self.validate_required(self.client_token, 'client_token')
        self.validate_required(self.case_basic_info, 'case_basic_info')
        if self.case_basic_info:
            self.case_basic_info.validate()
        self.validate_required(self.proposer_objects, 'proposer_objects')
        if self.proposer_objects:
            for k in self.proposer_objects:
                if k:
                    k.validate()
        self.validate_required(self.pleader_objects, 'pleader_objects')
        if self.pleader_objects:
            for k in self.pleader_objects:
                if k:
                    k.validate()
        self.validate_required(self.lease_evidential_element, 'lease_evidential_element')
        if self.lease_evidential_element:
            self.lease_evidential_element.validate()
        self.validate_required(self.evidential_check_list, 'evidential_check_list')
        if self.evidential_check_list:
            for k in self.evidential_check_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.client_token is not None:
            result['client_token'] = self.client_token
        if self.case_basic_info is not None:
            result['case_basic_info'] = self.case_basic_info.to_map()
        result['proposer_objects'] = []
        if self.proposer_objects is not None:
            for k in self.proposer_objects:
                result['proposer_objects'].append(k.to_map() if k else None)
        result['pleader_objects'] = []
        if self.pleader_objects is not None:
            for k in self.pleader_objects:
                result['pleader_objects'].append(k.to_map() if k else None)
        if self.lease_evidential_element is not None:
            result['lease_evidential_element'] = self.lease_evidential_element.to_map()
        result['evidential_check_list'] = []
        if self.evidential_check_list is not None:
            for k in self.evidential_check_list:
                result['evidential_check_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('client_token') is not None:
            self.client_token = m.get('client_token')
        if m.get('case_basic_info') is not None:
            temp_model = CaseBasicInfo()
            self.case_basic_info = temp_model.from_map(m['case_basic_info'])
        self.proposer_objects = []
        if m.get('proposer_objects') is not None:
            for k in m.get('proposer_objects'):
                temp_model = ProposerObject()
                self.proposer_objects.append(temp_model.from_map(k))
        self.pleader_objects = []
        if m.get('pleader_objects') is not None:
            for k in m.get('pleader_objects'):
                temp_model = PleaderObject()
                self.pleader_objects.append(temp_model.from_map(k))
        if m.get('lease_evidential_element') is not None:
            temp_model = LeaseEvidentialElement()
            self.lease_evidential_element = temp_model.from_map(m['lease_evidential_element'])
        self.evidential_check_list = []
        if m.get('evidential_check_list') is not None:
            for k in m.get('evidential_check_list'):
                temp_model = EvidentialCheckList()
                self.evidential_check_list.append(temp_model.from_map(k))
        return self


class CreateJusticeCasewritebackResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        create_status: str = None,
        create_status_message: str = None,
        create_time: str = None,
        input_source_id: str = None,
        case_id: str = None,
        code: int = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 创建成功状态
        # success, fail
        self.create_status = create_status
        # 创建状态说明
        self.create_status_message = create_status_message
        # 创建时间（如创建成功，则返回创建日期时间）
        self.create_time = create_time
        # 业务来源主键
        self.input_source_id = input_source_id
        # 案件ID
        self.case_id = case_id
        # 业务码 0表示成功
        self.code = code
        # 业务码描述
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.create_status is not None:
            result['create_status'] = self.create_status
        if self.create_status_message is not None:
            result['create_status_message'] = self.create_status_message
        if self.create_time is not None:
            result['create_time'] = self.create_time
        if self.input_source_id is not None:
            result['input_source_id'] = self.input_source_id
        if self.case_id is not None:
            result['case_id'] = self.case_id
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('create_status') is not None:
            self.create_status = m.get('create_status')
        if m.get('create_status_message') is not None:
            self.create_status_message = m.get('create_status_message')
        if m.get('create_time') is not None:
            self.create_time = m.get('create_time')
        if m.get('input_source_id') is not None:
            self.input_source_id = m.get('input_source_id')
        if m.get('case_id') is not None:
            self.case_id = m.get('case_id')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class QueryJusticeBasecaseRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        index_method: str = None,
        case_id: str = None,
        id_number: str = None,
        business_number: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 针对案件信息查询的索引方式，01为根据案件caseID索引，02为根据申请人的统一社会信用代码与业务订单号进行索引
        self.index_method = index_method
        # 纠纷处理平台后台唯一的caseID 当索引方式为01时必填
        self.case_id = case_id
        # 案件申请人（企业）的统一社会信用代码 当索引方式为02时必填
        self.id_number = id_number
        # 案件的业务订单ID 当索引方式为02时必填
        self.business_number = business_number

    def validate(self):
        self.validate_required(self.index_method, 'index_method')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.index_method is not None:
            result['index_method'] = self.index_method
        if self.case_id is not None:
            result['case_id'] = self.case_id
        if self.id_number is not None:
            result['id_number'] = self.id_number
        if self.business_number is not None:
            result['business_number'] = self.business_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('index_method') is not None:
            self.index_method = m.get('index_method')
        if m.get('case_id') is not None:
            self.case_id = m.get('case_id')
        if m.get('id_number') is not None:
            self.id_number = m.get('id_number')
        if m.get('business_number') is not None:
            self.business_number = m.get('business_number')
        return self


class QueryJusticeBasecaseResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        case_base_info_list: List[CaseBaseInfo] = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功 其余都是代表失败
        self.code = code
        # 案件基础信息出参
        self.case_base_info_list = case_base_info_list
        # 响应的详细信息
        self.message = message

    def validate(self):
        if self.case_base_info_list:
            for k in self.case_base_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        result['case_base_info_list'] = []
        if self.case_base_info_list is not None:
            for k in self.case_base_info_list:
                result['case_base_info_list'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        self.case_base_info_list = []
        if m.get('case_base_info_list') is not None:
            for k in m.get('case_base_info_list'):
                temp_model = CaseBaseInfo()
                self.case_base_info_list.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class DownloadJusticeCasefileRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        case_id: str = None,
        record_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 案件id
        self.case_id = case_id
        # 维权记录id
        self.record_id = record_id

    def validate(self):
        self.validate_required(self.case_id, 'case_id')
        self.validate_required(self.record_id, 'record_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.case_id is not None:
            result['case_id'] = self.case_id
        if self.record_id is not None:
            result['record_id'] = self.record_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('case_id') is not None:
            self.case_id = m.get('case_id')
        if m.get('record_id') is not None:
            self.record_id = m.get('record_id')
        return self


class DownloadJusticeCasefileResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        download_url: str = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务码，0表示成功 其余都是代表失败
        self.code = code
        # 文件下载地址 默认24小时内有效
        self.download_url = download_url
        # 响应的详细信息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.download_url is not None:
            result['download_url'] = self.download_url
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('download_url') is not None:
            self.download_url = m.get('download_url')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class OpenInternalJudicialRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        tenant_id: str = None,
        auth_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 授权开通纠纷行业的真实租户ID
        self.tenant_id = tenant_id
        # 调用接口的授权码
        self.auth_code = auth_code

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.auth_code, 'auth_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.tenant_id is not None:
            result['tenant_id'] = self.tenant_id
        if self.auth_code is not None:
            result['auth_code'] = self.auth_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('tenant_id') is not None:
            self.tenant_id = m.get('tenant_id')
        if m.get('auth_code') is not None:
            self.auth_code = m.get('auth_code')
        return self


class OpenInternalJudicialResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: str = None,
        message: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务响应码 0成功 其余都是失败
        self.code = code
        # 状态码描述
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class SaveJusticePartyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        party_id: int = None,
        party_type: str = None,
        party_organization_info: JudicialOrgInfo = None,
        coordinator_person_info: JudicialPersonInfo = None,
        coordinator_bank_info: JudicialBankInfo = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 委托申请方配置ID
        self.party_id = party_id
        # 委托申请方类型,目前仅支持企业.
        # 个人: PERSON
        # 企业:ORG
        self.party_type = party_type
        # 企业信息实体;
        # 当申请方类型为企业时,该字段必填;
        self.party_organization_info = party_organization_info
        # 案件协同工作联系人信息实体
        self.coordinator_person_info = coordinator_person_info
        # 案件协同人银行账户信息
        self.coordinator_bank_info = coordinator_bank_info

    def validate(self):
        self.validate_required(self.party_type, 'party_type')
        if self.party_organization_info:
            self.party_organization_info.validate()
        if self.coordinator_person_info:
            self.coordinator_person_info.validate()
        if self.coordinator_bank_info:
            self.coordinator_bank_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.party_id is not None:
            result['party_id'] = self.party_id
        if self.party_type is not None:
            result['party_type'] = self.party_type
        if self.party_organization_info is not None:
            result['party_organization_info'] = self.party_organization_info.to_map()
        if self.coordinator_person_info is not None:
            result['coordinator_person_info'] = self.coordinator_person_info.to_map()
        if self.coordinator_bank_info is not None:
            result['coordinator_bank_info'] = self.coordinator_bank_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('party_id') is not None:
            self.party_id = m.get('party_id')
        if m.get('party_type') is not None:
            self.party_type = m.get('party_type')
        if m.get('party_organization_info') is not None:
            temp_model = JudicialOrgInfo()
            self.party_organization_info = temp_model.from_map(m['party_organization_info'])
        if m.get('coordinator_person_info') is not None:
            temp_model = JudicialPersonInfo()
            self.coordinator_person_info = temp_model.from_map(m['coordinator_person_info'])
        if m.get('coordinator_bank_info') is not None:
            temp_model = JudicialBankInfo()
            self.coordinator_bank_info = temp_model.from_map(m['coordinator_bank_info'])
        return self


class SaveJusticePartyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        party_id: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否保存成功,true,false
        self.success = success
        # 委托申请方配置ID
        self.party_id = party_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        if self.party_id is not None:
            result['party_id'] = self.party_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('party_id') is not None:
            self.party_id = m.get('party_id')
        return self


class CreateJusticeNormalcaseRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        case_reason: str = None,
        case_type: str = None,
        external_biz_id: str = None,
        case_desc: str = None,
        case_biz_element_info: str = None,
        party_id: int = None,
        pleader_type: str = None,
        pleader_person_info: JudicialPersonInfo = None,
        use_template: bool = None,
        business_info: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 案由
        self.case_reason = case_reason
        # 业务类型
        # LEASE- 租赁
        # HB_FINANCIAL - HB金融
        self.case_type = case_type
        # 外部业务ID
        self.external_biz_id = external_biz_id
        # 业务描述,用于案件的补充描述; 没有则不填
        self.case_desc = case_desc
        # 针对对应业务类型的证据要素补充.
        self.case_biz_element_info = case_biz_element_info
        # 当事人(申请人)ID, 案件填充信息返回
        self.party_id = party_id
        # 答辩人类型, 目前仅支持个人.
        # PERSON , 个人
        # ORG , 机构
        self.pleader_type = pleader_type
        # 答辩人(自然人)信息, 类型为个人时必填
        self.pleader_person_info = pleader_person_info
        # 是否使用模板
        self.use_template = use_template
        # 使用模板时必填，根据案件要素模板对应提供要素信息
        self.business_info = business_info

    def validate(self):
        self.validate_required(self.case_reason, 'case_reason')
        self.validate_required(self.case_type, 'case_type')
        self.validate_required(self.external_biz_id, 'external_biz_id')
        self.validate_required(self.party_id, 'party_id')
        if self.pleader_person_info:
            self.pleader_person_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.case_reason is not None:
            result['case_reason'] = self.case_reason
        if self.case_type is not None:
            result['case_type'] = self.case_type
        if self.external_biz_id is not None:
            result['external_biz_id'] = self.external_biz_id
        if self.case_desc is not None:
            result['case_desc'] = self.case_desc
        if self.case_biz_element_info is not None:
            result['case_biz_element_info'] = self.case_biz_element_info
        if self.party_id is not None:
            result['party_id'] = self.party_id
        if self.pleader_type is not None:
            result['pleader_type'] = self.pleader_type
        if self.pleader_person_info is not None:
            result['pleader_person_info'] = self.pleader_person_info.to_map()
        if self.use_template is not None:
            result['use_template'] = self.use_template
        if self.business_info is not None:
            result['business_info'] = self.business_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('case_reason') is not None:
            self.case_reason = m.get('case_reason')
        if m.get('case_type') is not None:
            self.case_type = m.get('case_type')
        if m.get('external_biz_id') is not None:
            self.external_biz_id = m.get('external_biz_id')
        if m.get('case_desc') is not None:
            self.case_desc = m.get('case_desc')
        if m.get('case_biz_element_info') is not None:
            self.case_biz_element_info = m.get('case_biz_element_info')
        if m.get('party_id') is not None:
            self.party_id = m.get('party_id')
        if m.get('pleader_type') is not None:
            self.pleader_type = m.get('pleader_type')
        if m.get('pleader_person_info') is not None:
            temp_model = JudicialPersonInfo()
            self.pleader_person_info = temp_model.from_map(m['pleader_person_info'])
        if m.get('use_template') is not None:
            self.use_template = m.get('use_template')
        if m.get('business_info') is not None:
            self.business_info = m.get('business_info')
        return self


class CreateJusticeNormalcaseResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        case_id: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 案件创建是否成功
        self.success = success
        # 案件ID, 创建成功后, 返回的案件ID
        self.case_id = case_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        if self.case_id is not None:
            result['case_id'] = self.case_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('case_id') is not None:
            self.case_id = m.get('case_id')
        return self


class CreateJusticeChaincaseRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        case_reason: str = None,
        case_type: str = None,
        external_biz_id: str = None,
        case_desc: str = None,
        party_id: int = None,
        notary_flow_infos: List[NotaryFlowDetailQueryReq] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 案由
        self.case_reason = case_reason
        # 业务类型
        # LEASE- 租赁
        # HB_FINANCIAL - HB金融,其他不支持
        self.case_type = case_type
        # 外部业务ID
        self.external_biz_id = external_biz_id
        # 业务描述,用于案件的补充描述; 没有则不填
        self.case_desc = case_desc
        # 当事人(申请人)ID, 案件填充信息返回
        self.party_id = party_id
        # 全流程存证信息
        self.notary_flow_infos = notary_flow_infos

    def validate(self):
        self.validate_required(self.case_reason, 'case_reason')
        self.validate_required(self.case_type, 'case_type')
        self.validate_required(self.external_biz_id, 'external_biz_id')
        self.validate_required(self.party_id, 'party_id')
        self.validate_required(self.notary_flow_infos, 'notary_flow_infos')
        if self.notary_flow_infos:
            for k in self.notary_flow_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.case_reason is not None:
            result['case_reason'] = self.case_reason
        if self.case_type is not None:
            result['case_type'] = self.case_type
        if self.external_biz_id is not None:
            result['external_biz_id'] = self.external_biz_id
        if self.case_desc is not None:
            result['case_desc'] = self.case_desc
        if self.party_id is not None:
            result['party_id'] = self.party_id
        result['notary_flow_infos'] = []
        if self.notary_flow_infos is not None:
            for k in self.notary_flow_infos:
                result['notary_flow_infos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('case_reason') is not None:
            self.case_reason = m.get('case_reason')
        if m.get('case_type') is not None:
            self.case_type = m.get('case_type')
        if m.get('external_biz_id') is not None:
            self.external_biz_id = m.get('external_biz_id')
        if m.get('case_desc') is not None:
            self.case_desc = m.get('case_desc')
        if m.get('party_id') is not None:
            self.party_id = m.get('party_id')
        self.notary_flow_infos = []
        if m.get('notary_flow_infos') is not None:
            for k in m.get('notary_flow_infos'):
                temp_model = NotaryFlowDetailQueryReq()
                self.notary_flow_infos.append(temp_model.from_map(k))
        return self


class CreateJusticeChaincaseResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        case_id: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 案件创建是否成功
        self.success = success
        # 案件ID, 创建成功后, 返回的案件ID
        self.case_id = case_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        if self.case_id is not None:
            result['case_id'] = self.case_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('case_id') is not None:
            self.case_id = m.get('case_id')
        return self


class StartJusticeCaseRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        case_id: int = None,
        isv_tenant_id: str = None,
        judicial_biz_type: str = None,
        judicial_mediation_param: JudicialMediationBaseParamInfo = None,
        contact_info: ContactInfo = None,
        bank_account_info: BankAccountInfo = None,
        sign_method: str = None,
        court_code: str = None,
        amount: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 案件Id,创建案件返回的id
        self.case_id = case_id
        # 处置端租户ID
        self.isv_tenant_id = isv_tenant_id
        # 处置方式
        # JUDICIAL_MEDIATION-司法调解
        self.judicial_biz_type = judicial_biz_type
        # 司法调解基础参数, 当处置方式为5, 必填.
        self.judicial_mediation_param = judicial_mediation_param
        # 调解沟通联系人(如果不传则使用租户维度的配置信息)
        self.contact_info = contact_info
        # 调解回款银行账户(如果不传则使用租户维度的配置信息)
        self.bank_account_info = bank_account_info
        # 维权类型为仲裁时填写:SIGN_SILENTLY-静默签署,SIGN_MANUALLY-人工签署
        self.sign_method = sign_method
        # 仲裁委,提交仲裁时必填 41952695X: 宁波仲裁委 123325004722618740: 丽水仲裁委
        self.court_code = court_code
        # 标的额,提交仲裁时必填
        self.amount = amount

    def validate(self):
        self.validate_required(self.case_id, 'case_id')
        self.validate_required(self.isv_tenant_id, 'isv_tenant_id')
        self.validate_required(self.judicial_biz_type, 'judicial_biz_type')
        if self.judicial_mediation_param:
            self.judicial_mediation_param.validate()
        if self.contact_info:
            self.contact_info.validate()
        if self.bank_account_info:
            self.bank_account_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.case_id is not None:
            result['case_id'] = self.case_id
        if self.isv_tenant_id is not None:
            result['isv_tenant_id'] = self.isv_tenant_id
        if self.judicial_biz_type is not None:
            result['judicial_biz_type'] = self.judicial_biz_type
        if self.judicial_mediation_param is not None:
            result['judicial_mediation_param'] = self.judicial_mediation_param.to_map()
        if self.contact_info is not None:
            result['contact_info'] = self.contact_info.to_map()
        if self.bank_account_info is not None:
            result['bank_account_info'] = self.bank_account_info.to_map()
        if self.sign_method is not None:
            result['sign_method'] = self.sign_method
        if self.court_code is not None:
            result['court_code'] = self.court_code
        if self.amount is not None:
            result['amount'] = self.amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('case_id') is not None:
            self.case_id = m.get('case_id')
        if m.get('isv_tenant_id') is not None:
            self.isv_tenant_id = m.get('isv_tenant_id')
        if m.get('judicial_biz_type') is not None:
            self.judicial_biz_type = m.get('judicial_biz_type')
        if m.get('judicial_mediation_param') is not None:
            temp_model = JudicialMediationBaseParamInfo()
            self.judicial_mediation_param = temp_model.from_map(m['judicial_mediation_param'])
        if m.get('contact_info') is not None:
            temp_model = ContactInfo()
            self.contact_info = temp_model.from_map(m['contact_info'])
        if m.get('bank_account_info') is not None:
            temp_model = BankAccountInfo()
            self.bank_account_info = temp_model.from_map(m['bank_account_info'])
        if m.get('sign_method') is not None:
            self.sign_method = m.get('sign_method')
        if m.get('court_code') is not None:
            self.court_code = m.get('court_code')
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        return self


class StartJusticeCaseResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        record_id: int = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 维权记录ID, 维权成功后,返回的对应的维权记录ID
        self.record_id = record_id
        # 案件发起是否成功,true,false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.record_id is not None:
            result['record_id'] = self.record_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('record_id') is not None:
            self.record_id = m.get('record_id')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class QueryJusticeCaseRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        case_id: int = None,
        record_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 案件Id,创建案件返回的id
        self.case_id = case_id
        # 维权记录ID, 维权成功后,返回的对应的维权记录ID
        self.record_id = record_id

    def validate(self):
        self.validate_required(self.case_id, 'case_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.case_id is not None:
            result['case_id'] = self.case_id
        if self.record_id is not None:
            result['record_id'] = self.record_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('case_id') is not None:
            self.case_id = m.get('case_id')
        if m.get('record_id') is not None:
            self.record_id = m.get('record_id')
        return self


class QueryJusticeCaseResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        case_id: int = None,
        record_id: int = None,
        external_biz_id: str = None,
        case_phase_desc: str = None,
        judicial_record_type_desc: str = None,
        judicial_record_status_desc: str = None,
        judicial_record_status_time: str = None,
        judicial_files: List[JudicialFileInfo] = None,
        submit_error_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 案件ID
        self.case_id = case_id
        # 维权记录ID
        self.record_id = record_id
        # 外部业务id
        self.external_biz_id = external_biz_id
        # 案件阶段
        # 待发起维权
        # 待提交
        # 收案处理中
        # 结果待确认
        # 已关闭
        self.case_phase_desc = case_phase_desc
        # 维权方式, (目前仅支持司法调解)
        # 诉讼-2
        # 仲裁-3
        # 仲裁执行-4
        # 司法调解-5
        self.judicial_record_type_desc = judicial_record_type_desc
        # 维权状态字段描述.
        # 
        self.judicial_record_status_desc = judicial_record_status_desc
        # "yyyy-MM-dd" , 当前的状态更新时间
        self.judicial_record_status_time = judicial_record_status_time
        # 维权过程中的文件列表
        self.judicial_files = judicial_files
        # 案件提交失败的原因,维权状态为提交失败时存在
        self.submit_error_msg = submit_error_msg

    def validate(self):
        if self.judicial_files:
            for k in self.judicial_files:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.case_id is not None:
            result['case_id'] = self.case_id
        if self.record_id is not None:
            result['record_id'] = self.record_id
        if self.external_biz_id is not None:
            result['external_biz_id'] = self.external_biz_id
        if self.case_phase_desc is not None:
            result['case_phase_desc'] = self.case_phase_desc
        if self.judicial_record_type_desc is not None:
            result['judicial_record_type_desc'] = self.judicial_record_type_desc
        if self.judicial_record_status_desc is not None:
            result['judicial_record_status_desc'] = self.judicial_record_status_desc
        if self.judicial_record_status_time is not None:
            result['judicial_record_status_time'] = self.judicial_record_status_time
        result['judicial_files'] = []
        if self.judicial_files is not None:
            for k in self.judicial_files:
                result['judicial_files'].append(k.to_map() if k else None)
        if self.submit_error_msg is not None:
            result['submit_error_msg'] = self.submit_error_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('case_id') is not None:
            self.case_id = m.get('case_id')
        if m.get('record_id') is not None:
            self.record_id = m.get('record_id')
        if m.get('external_biz_id') is not None:
            self.external_biz_id = m.get('external_biz_id')
        if m.get('case_phase_desc') is not None:
            self.case_phase_desc = m.get('case_phase_desc')
        if m.get('judicial_record_type_desc') is not None:
            self.judicial_record_type_desc = m.get('judicial_record_type_desc')
        if m.get('judicial_record_status_desc') is not None:
            self.judicial_record_status_desc = m.get('judicial_record_status_desc')
        if m.get('judicial_record_status_time') is not None:
            self.judicial_record_status_time = m.get('judicial_record_status_time')
        self.judicial_files = []
        if m.get('judicial_files') is not None:
            for k in m.get('judicial_files'):
                temp_model = JudicialFileInfo()
                self.judicial_files.append(temp_model.from_map(k))
        if m.get('submit_error_msg') is not None:
            self.submit_error_msg = m.get('submit_error_msg')
        return self


class OperateJusticeEventRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        case_id: int = None,
        record_id: int = None,
        event_type: str = None,
        operate_info: JudicialEventOperateInfo = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 案件Id,创建案件返回的id
        self.case_id = case_id
        # 维权记录id,发起维权返回的Id
        self.record_id = record_id
        # 事件类型(目前仅支持司法调解类):
        # 司法调解-JUDICIAL_MEDIATION
        # 仲裁-ARBITRATION
        # 执行-CARRIED_OUT
        # 补证-SUPPLEMENT
        self.event_type = event_type
        # 针对事件响应的信息
        self.operate_info = operate_info

    def validate(self):
        self.validate_required(self.case_id, 'case_id')
        self.validate_required(self.record_id, 'record_id')
        self.validate_required(self.event_type, 'event_type')
        self.validate_required(self.operate_info, 'operate_info')
        if self.operate_info:
            self.operate_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.case_id is not None:
            result['case_id'] = self.case_id
        if self.record_id is not None:
            result['record_id'] = self.record_id
        if self.event_type is not None:
            result['event_type'] = self.event_type
        if self.operate_info is not None:
            result['operate_info'] = self.operate_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('case_id') is not None:
            self.case_id = m.get('case_id')
        if m.get('record_id') is not None:
            self.record_id = m.get('record_id')
        if m.get('event_type') is not None:
            self.event_type = m.get('event_type')
        if m.get('operate_info') is not None:
            temp_model = JudicialEventOperateInfo()
            self.operate_info = temp_model.from_map(m['operate_info'])
        return self


class OperateJusticeEventResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 触发响应是否成功
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateJusticeCasetemplateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        name: str = None,
        biz_type: str = None,
        flow_templates: str = None,
        template_file_url: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 案件要素模板名称
        self.name = name
        # 模板业务类型名称
        self.biz_type = biz_type
        # 全流程存证模板ID列表，多个用“,”隔开
        self.flow_templates = flow_templates
        # 模板文件下载地址
        self.template_file_url = template_file_url

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.biz_type, 'biz_type')
        self.validate_required(self.flow_templates, 'flow_templates')
        self.validate_required(self.template_file_url, 'template_file_url')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.biz_type is not None:
            result['biz_type'] = self.biz_type
        if self.flow_templates is not None:
            result['flow_templates'] = self.flow_templates
        if self.template_file_url is not None:
            result['template_file_url'] = self.template_file_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('biz_type') is not None:
            self.biz_type = m.get('biz_type')
        if m.get('flow_templates') is not None:
            self.flow_templates = m.get('flow_templates')
        if m.get('template_file_url') is not None:
            self.template_file_url = m.get('template_file_url')
        return self


class CreateJusticeCasetemplateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        template_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 案件要素模板ID，创建成功时返回
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.template_id is not None:
            result['template_id'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        return self


class CreateJusticeRightprotecttemplateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        name: str = None,
        biz_type: str = None,
        right_protect_type: str = None,
        case_template_id: str = None,
        template_file_url: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 维权要素模板名称
        self.name = name
        # 维权要素模板业务类型
        self.biz_type = biz_type
        # 维权措施，枚举值，包括：
        # ARBITRATION，仲裁
        # ARBITRATION_EXECUTION，仲裁执行
        # MEDIATION，调解
        self.right_protect_type = right_protect_type
        # 要素模板关联的案件要素模板ID，要素模板和案件模板必须属于同一个业务类型才可以关联
        self.case_template_id = case_template_id
        # 维权要素模板文件下载地址，文件为excel格式，包含维权要素的所有算法信息、字段信息和文件附件信息
        self.template_file_url = template_file_url

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.biz_type, 'biz_type')
        self.validate_required(self.right_protect_type, 'right_protect_type')
        self.validate_required(self.case_template_id, 'case_template_id')
        self.validate_required(self.template_file_url, 'template_file_url')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.biz_type is not None:
            result['biz_type'] = self.biz_type
        if self.right_protect_type is not None:
            result['right_protect_type'] = self.right_protect_type
        if self.case_template_id is not None:
            result['case_template_id'] = self.case_template_id
        if self.template_file_url is not None:
            result['template_file_url'] = self.template_file_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('biz_type') is not None:
            self.biz_type = m.get('biz_type')
        if m.get('right_protect_type') is not None:
            self.right_protect_type = m.get('right_protect_type')
        if m.get('case_template_id') is not None:
            self.case_template_id = m.get('case_template_id')
        if m.get('template_file_url') is not None:
            self.template_file_url = m.get('template_file_url')
        return self


class CreateJusticeRightprotecttemplateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        template_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 维权要素模板ID，创建成功时返回
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.template_id is not None:
            result['template_id'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        return self


class GetJusticeFileuploadurlRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 上传文件全名
        self.file_name = file_name

    def validate(self):
        self.validate_required(self.file_name, 'file_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_name is not None:
            result['file_name'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        return self


class GetJusticeFileuploadurlResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        file_key: str = None,
        upload_url: str = None,
        expired_time: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 获取的文件key, 请妥善保存, 用于后续接口调用.
        self.file_key = file_key
        # 文件上传链接url
        self.upload_url = upload_url
        # 链接失效日期: "yyyy-MM-dd HH:mm:ss"
        self.expired_time = expired_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.file_key is not None:
            result['file_key'] = self.file_key
        if self.upload_url is not None:
            result['upload_url'] = self.upload_url
        if self.expired_time is not None:
            result['expired_time'] = self.expired_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('file_key') is not None:
            self.file_key = m.get('file_key')
        if m.get('upload_url') is not None:
            self.upload_url = m.get('upload_url')
        if m.get('expired_time') is not None:
            self.expired_time = m.get('expired_time')
        return self


class CreateJusticeDocumenttemplateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        document_template_id: str = None,
        right_protect_template_id: str = None,
        template_name: str = None,
        output_type: str = None,
        input_type: str = None,
        download_url: str = None,
        text_content: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 维权要素模板id + 文书模板类型
        # 1.仲裁-申请请求 ARBITRATION_REQUEST_FOR_APPLICATION
        # 2.仲裁-事实和理由：ARBITRATION_FACTS_AND_REASONS
        self.document_template_id = document_template_id
        # 维权要素模板id
        self.right_protect_template_id = right_protect_template_id
        # 文书模板类型名称，如“仲裁申请书”、“调解协议书”、“起诉状”等
        self.template_name = template_name
        # 文书生成格式类型，枚举
        # NORMAL：普通文本，
        # RICHTEXT：富文本，
        # PDF：pdf格式文件
        self.output_type = output_type
        # 传入的模板样式文件格式（目前只支持txt、doc）
        # TXT：txt格式
        # DOC：doc格式
        self.input_type = input_type
        # 原始模板文件下载地址，如果inputType为DOC则必填
        self.download_url = download_url
        # 模板数据内容，如果inputType为TXT则必填
        self.text_content = text_content

    def validate(self):
        self.validate_required(self.document_template_id, 'document_template_id')
        self.validate_required(self.right_protect_template_id, 'right_protect_template_id')
        self.validate_required(self.template_name, 'template_name')
        self.validate_required(self.output_type, 'output_type')
        self.validate_required(self.input_type, 'input_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.document_template_id is not None:
            result['document_template_id'] = self.document_template_id
        if self.right_protect_template_id is not None:
            result['right_protect_template_id'] = self.right_protect_template_id
        if self.template_name is not None:
            result['template_name'] = self.template_name
        if self.output_type is not None:
            result['output_type'] = self.output_type
        if self.input_type is not None:
            result['input_type'] = self.input_type
        if self.download_url is not None:
            result['download_url'] = self.download_url
        if self.text_content is not None:
            result['text_content'] = self.text_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('document_template_id') is not None:
            self.document_template_id = m.get('document_template_id')
        if m.get('right_protect_template_id') is not None:
            self.right_protect_template_id = m.get('right_protect_template_id')
        if m.get('template_name') is not None:
            self.template_name = m.get('template_name')
        if m.get('output_type') is not None:
            self.output_type = m.get('output_type')
        if m.get('input_type') is not None:
            self.input_type = m.get('input_type')
        if m.get('download_url') is not None:
            self.download_url = m.get('download_url')
        if m.get('text_content') is not None:
            self.text_content = m.get('text_content')
        return self


class CreateJusticeDocumenttemplateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        template_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 文书模板ID，创建成功时返回
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.template_id is not None:
            result['template_id'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        return self


class QueryJusticeCommoncaseinfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        case_no: str = None,
        client_token: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 案件号
        self.case_no = case_no
        # 用户幂等字段
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.case_no, 'case_no')
        self.validate_required(self.client_token, 'client_token')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.case_no is not None:
            result['case_no'] = self.case_no
        if self.client_token is not None:
            result['client_token'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('case_no') is not None:
            self.case_no = m.get('case_no')
        if m.get('client_token') is not None:
            self.client_token = m.get('client_token')
        return self


class QueryJusticeCommoncaseinfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        business_info: str = None,
        case_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 要素信息
        self.business_info = business_info
        # 查询的案件编号
        self.case_no = case_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.business_info is not None:
            result['business_info'] = self.business_info
        if self.case_no is not None:
            result['case_no'] = self.case_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('business_info') is not None:
            self.business_info = m.get('business_info')
        if m.get('case_no') is not None:
            self.case_no = m.get('case_no')
        return self


class CreateLeaseProductinfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        application_id: str = None,
        deposit_price: int = None,
        install_price: int = None,
        lease_id: str = None,
        main_class: str = None,
        product_id: str = None,
        product_name: str = None,
        product_price: int = None,
        rentinfos: List[RentInfo] = None,
        sub_class: str = None,
        supplier_id: str = None,
        supplier_name: str = None,
        supplier_version: str = None,
        extra_info: str = None,
        product_model: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 合约id
        self.application_id = application_id
        # 保证金  精确到毫厘，即123400表示12.34元
        self.deposit_price = deposit_price
        # 安装拆卸费 精确到毫厘，即123400表示12.34元
        self.install_price = install_price
        # 租赁服务平台id
        self.lease_id = lease_id
        # 一级分类
        self.main_class = main_class
        # 商品编码 长度不可超过50
        self.product_id = product_id
        # 商品名称
        self.product_name = product_name
        # 采购价  精确到毫厘，即123400表示12.34元
        self.product_price = product_price
        # 出租详细信息
        self.rentinfos = rentinfos
        # 二级分类
        self.sub_class = sub_class
        # 供应商id
        self.supplier_id = supplier_id
        # 供应商
        self.supplier_name = supplier_name
        # 供应商对该产品版本
        self.supplier_version = supplier_version
        # 商品目录额外信息
        self.extra_info = extra_info
        # 商品规格
        self.product_model = product_model

    def validate(self):
        self.validate_required(self.deposit_price, 'deposit_price')
        self.validate_required(self.install_price, 'install_price')
        self.validate_required(self.lease_id, 'lease_id')
        self.validate_required(self.main_class, 'main_class')
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.product_price, 'product_price')
        self.validate_required(self.rentinfos, 'rentinfos')
        if self.rentinfos:
            for k in self.rentinfos:
                if k:
                    k.validate()
        self.validate_required(self.sub_class, 'sub_class')
        self.validate_required(self.supplier_name, 'supplier_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.application_id is not None:
            result['application_id'] = self.application_id
        if self.deposit_price is not None:
            result['deposit_price'] = self.deposit_price
        if self.install_price is not None:
            result['install_price'] = self.install_price
        if self.lease_id is not None:
            result['lease_id'] = self.lease_id
        if self.main_class is not None:
            result['main_class'] = self.main_class
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.product_name is not None:
            result['product_name'] = self.product_name
        if self.product_price is not None:
            result['product_price'] = self.product_price
        result['rentinfos'] = []
        if self.rentinfos is not None:
            for k in self.rentinfos:
                result['rentinfos'].append(k.to_map() if k else None)
        if self.sub_class is not None:
            result['sub_class'] = self.sub_class
        if self.supplier_id is not None:
            result['supplier_id'] = self.supplier_id
        if self.supplier_name is not None:
            result['supplier_name'] = self.supplier_name
        if self.supplier_version is not None:
            result['supplier_version'] = self.supplier_version
        if self.extra_info is not None:
            result['extra_info'] = self.extra_info
        if self.product_model is not None:
            result['product_model'] = self.product_model
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('application_id') is not None:
            self.application_id = m.get('application_id')
        if m.get('deposit_price') is not None:
            self.deposit_price = m.get('deposit_price')
        if m.get('install_price') is not None:
            self.install_price = m.get('install_price')
        if m.get('lease_id') is not None:
            self.lease_id = m.get('lease_id')
        if m.get('main_class') is not None:
            self.main_class = m.get('main_class')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('product_name') is not None:
            self.product_name = m.get('product_name')
        if m.get('product_price') is not None:
            self.product_price = m.get('product_price')
        self.rentinfos = []
        if m.get('rentinfos') is not None:
            for k in m.get('rentinfos'):
                temp_model = RentInfo()
                self.rentinfos.append(temp_model.from_map(k))
        if m.get('sub_class') is not None:
            self.sub_class = m.get('sub_class')
        if m.get('supplier_id') is not None:
            self.supplier_id = m.get('supplier_id')
        if m.get('supplier_name') is not None:
            self.supplier_name = m.get('supplier_name')
        if m.get('supplier_version') is not None:
            self.supplier_version = m.get('supplier_version')
        if m.get('extra_info') is not None:
            self.extra_info = m.get('extra_info')
        if m.get('product_model') is not None:
            self.product_model = m.get('product_model')
        return self


class CreateLeaseProductinfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: int = None,
        err_message: str = None,
        response_data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 状态码 0表示成功
        self.code = code
        # 错误信息
        self.err_message = err_message
        # 用户信息存储到合约中对应的区块链交易哈希
        self.response_data = response_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.err_message is not None:
            result['err_message'] = self.err_message
        if self.response_data is not None:
            result['response_data'] = self.response