# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bittrade_cryptodotcom_websocket',
 'bittrade_cryptodotcom_websocket.channels',
 'bittrade_cryptodotcom_websocket.channels.models',
 'bittrade_cryptodotcom_websocket.connection',
 'bittrade_cryptodotcom_websocket.events',
 'bittrade_cryptodotcom_websocket.events.models',
 'bittrade_cryptodotcom_websocket.framework',
 'bittrade_cryptodotcom_websocket.messages',
 'bittrade_cryptodotcom_websocket.messages.filters',
 'bittrade_cryptodotcom_websocket.models',
 'bittrade_cryptodotcom_websocket.models.rest',
 'bittrade_cryptodotcom_websocket.operators',
 'bittrade_cryptodotcom_websocket.operators.orderbook',
 'bittrade_cryptodotcom_websocket.operators.stream',
 'bittrade_cryptodotcom_websocket.rest']

package_data = \
{'': ['*']}

install_requires = \
['ccxt>=2.6.5,<3.0.0',
 'elm-framework-helpers>=0.1.10,<0.2.0',
 'expression>=4.2.2,<5.0.0',
 'fire>=0.5.0,<0.6.0',
 'orjson>=3.8.3,<4.0.0',
 'prompt-toolkit>=3.0.36,<4.0.0',
 'ptpython>=3.0.22,<4.0.0',
 'pydantic>=1.10.4,<2.0.0',
 'reactivex>=4.0.4,<5.0.0',
 'requests>=2.28.2,<3.0.0',
 'returns>=0.19.0,<0.20.0',
 'rich>=13.2.0,<14.0.0',
 'websocket-client>=1.4.2,<2.0.0']

setup_kwargs = {
    'name': 'bittrade-cryptodotcom-websocket',
    'version': '0.1.25',
    'description': 'Reactive Websocket for Crypto.com',
    'long_description': '# Crypto.com Websocket\n\n[NOT RELEASED] This is very much a work in progress, despite being on pypi.\nMost things might be wrongly documented; API **will** change\n\n## Features\n\n- Reconnect with incremental backoff \n- Respond to ping\n- request/response factories e.g. `add_order_factory` make websocket events feel like calling an API\n- ... but provides more info than a simple request/response; \n  for instance, `add_order` goes through each stage submitted->pending->open or canceled, \n  emitting a notification at each stage\n\n## Installing\n\n`pip install bittrade-cryptodotcom-websocket` or `poetry add bittrade-cryptodotcom-websocket`\n\n## General considerations\n\n### Observables/Reactivex\n\nThe whole library is build with [Reactivex](https://rxpy.readthedocs.io/en/latest/).\n\nThough Observables seem complicated at first, they are the best way to handle - and (synchronously) test - complex situations that arise over time, like an invalid sequence of messages or socket disconnection and backoff reconnects.\n\nFor simple use cases, they are also rather easy to use as shown in the [examples](./examples) folder or in the Getting Started below\n\n### Concurrency\n\nInternally the library uses threads.\nFor your main program you don\'t have to worry about threads; you can block the main thread.\n\n## Getting started\n\n### Connect to the public feeds\n\n```python\nfrom bittrade_cryptodotcom_websocket import public_websocket_connection, subscribe_ticker\nfrom bittrade_cryptodotcom_websocket.operators import keep_messages_only, filter_new_socket_only\n\n# Prepare connection - note, this is a ConnectableObservable, so it will only trigger connection when we call its ``connect`` method\nsocket_connection = public_websocket_connection()\n# Prepare a feed with only "real" messages, dropping things like status update, heartbeat, etc…\nmessages = socket_connection.pipe(\n    keep_messages_only(),\n)\nsocket_connection.pipe(\n    filter_new_socket_only(),\n    subscribe_ticker(\'USDT/USD\', messages)\n).subscribe(\n    print, print, print  # you can do anything with the messages; here we simply print them out\n)\nsocket_connection.connect()\n```\n\n_(This script is complete, it should run "as is")_\n\n\n## Logging\n\nWe use Python\'s standard logging.\nYou can modify what logs you see as follows:\n\n```\nlogging.getLogger(\'bittrade_cryptodotcom_websocket\').addHandler(logging.StreamHandler())\n```\n\nIn addition, two special logger logs every message sent/received from the socket (except heartbeat) at the `DEBUG` level: `bittrade_cryptodotcom_websocket.raw_socket.sent` and `bittrade_cryptodotcom_websocket.raw_socket.received`\n\nTo view a full, timestamped history of the socket exchanges use\n\n```\nhandler = FileHandler("logs/raw_socket.log")\nlogger = logging.getLogger("bittrade_cryptodotcom_websocket.raw_socket.sent")\nformatter = logging.Formatter("%(asctime)s.%(msecs)03d <== %(message)s", datefmt="%H:%M:%S")\nhandler.setFormatter(formatter)\nlogger.addHandler(handler)\nlogger = logging.getLogger("bittrade_cryptodotcom_websocket.raw_socket.received")\nformatter = logging.Formatter("%(asctime)s.%(msecs)03d --> %(message)s", datefmt="%H:%M:%S")\nhandler.setFormatter(formatter)\nlogger.addHandler(handler)\n```\n\n## Private feeds\n\nSimilar to [bittrade-kraken-rest](https://github.com/TechSpaceAsia/bittrade-kraken-rest), this library attempts to get as little access to sensitive information as possible.\n\nThis means that you\'ll need to implement the signature token yourself. The library never has access to your API secret.\n\nSee `examples/private_subscription.py` for an example of implementation but it is generally as simple as:\n\n```python\nauthenticated_sockets = connection.pipe(\n    filter_new_socket_only(),\n    operators.map(add_token),\n    operators.share(),\n)\n```\n\n# Development guidelines\n\n## `*_http` methods\n\nREST functions over http should be suffixed with `_http` e.g. `get_book_http`.\nThey should return an Observable containing the *full* json body; this is easily achieved via `prepare_request` and `send_request`.\n\nWhere possible models should be defined to describe the *raw* result and *parsed result* if available/useful.\n\nReactive operators may be provided for parsing, but they should never be included in the *raw* functionality of the `*_http` function, only optional.\n\nAny operator that maps to CCXT types should be suffixed with `_ccxt` e.g. `parse_book_ccxt`.',
    'author': 'mat',
    'author_email': 'matt@techspace.asia',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/TechSpaceAsia/bittrade-cryptodotcom-websocket',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
