# Generated by Django 3.1.3 on 2020-11-22 18:15

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('description', models.CharField(blank=True, default='', max_length=200)),
                ('deadline', models.DateField()),
                ('date', models.DateField()),
                ('event_type', models.CharField(choices=[('journal submission', '0'), ('academic conference', '1'), ('funded project', '2')], max_length=50)),
                ('url', models.URLField(blank=True, default='')),
            ],
            options={
                'ordering': ['date'],
            },
        ),
        migrations.CreateModel(
            name='Example',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('description', models.CharField(max_length=255)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('name', models.CharField(max_length=500)),
                ('description', models.TextField(default='')),
                ('requirements', models.TextField(default='')),
                ('is_public', models.BooleanField(default=False)),
                ('state', models.CharField(choices=[('seeking for collaborators', '0'), ('open for collaborators', '1'), ('in progress', '2'), ('done', '3')], default='seeking for collaborators', max_length=100)),
                ('project_type', models.CharField(choices=[('conference', '0'), ('instutution', '1'), ('journal', '2')], default='conference', max_length=100)),
                ('due_date', models.DateField(default=datetime.date.today)),
                ('events', models.ManyToManyField(blank=True, to='api.Event')),
                ('members', models.ManyToManyField(related_name='members', to=settings.AUTH_USER_MODEL)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='owner', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500)),
                ('projects', models.ManyToManyField(to='api.Project')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('name', models.CharField(default='', max_length=100)),
                ('middle_name', models.CharField(blank=True, default='', max_length=100)),
                ('last_name', models.CharField(default='', max_length=100)),
                ('bio', models.CharField(blank=True, default='', max_length=1000)),
                ('photo_url', models.TextField(blank=True, default='')),
                ('age', models.IntegerField(default=0)),
                ('share_age', models.BooleanField(default=True)),
                ('expertise', models.TextField(blank=True, default='')),
                ('gender', models.CharField(choices=[('male', '0'), ('female', '1'), ('do not want to share', '2')], default='do not want to share', max_length=100)),
                ('interests', models.TextField(blank=True, default='')),
                ('share_bio', models.BooleanField(default=True)),
                ('share_gender', models.BooleanField(default=True)),
                ('share_affiliations', models.BooleanField(default=True)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='profile', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='Milestone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.TextField(default='')),
                ('date', models.DateField()),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.project')),
            ],
            options={
                'ordering': ['project'],
            },
        ),
        migrations.CreateModel(
            name='File',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(upload_to='')),
                ('remark', models.CharField(max_length=20)),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.project')),
            ],
            options={
                'ordering': ['project'],
            },
        ),
    ]
