# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401
from yk_utils.models import Model
from yk_utils.models import deserialization


class VerifyResponse(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, matching_score: float=None, verified_image: str=None, verify_status: List[str]=None):  # noqa: E501
        """VerifyResponse - a model defined in Swagger

        :param matching_score: The matching_score of this VerifyResponse.  # noqa: E501
        :type matching_score: float
        :param verified_image: The verified_image of this VerifyResponse.  # noqa: E501
        :type verified_image: str
        :param verify_status: The verify_status of this VerifyResponse.  # noqa: E501
        :type verify_status: List[str]
        """
        self.swagger_types = {
            'matching_score': float,
            'verified_image': str,
            'verify_status': List[str]
        }

        self.attribute_map = {
            'matching_score': 'matching_score',
            'verified_image': 'verified_image',
            'verify_status': 'verify_status'
        }

        self._matching_score = matching_score
        self._verified_image = verified_image
        self._verify_status = verify_status

    @classmethod
    def from_dict(cls, dikt) -> 'VerifyResponse':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The verify_response of this VerifyResponse.  # noqa: E501
        :rtype: VerifyResponse
        """
        return deserialization.deserialize_model(dikt, cls)

    @property
    def matching_score(self) -> float:
        """Gets the matching_score of this VerifyResponse.

        Face matching confidence. Varies between -1 (totally different) to 1 (totally equal).   # noqa: E501

        :return: The matching_score of this VerifyResponse.
        :rtype: float
        """
        return self._matching_score

    @matching_score.setter
    def matching_score(self, matching_score: float):
        """Sets the matching_score of this VerifyResponse.

        Face matching confidence. Varies between -1 (totally different) to 1 (totally equal).   # noqa: E501

        :param matching_score: The matching_score of this VerifyResponse.
        :type matching_score: float
        """

        self._matching_score = matching_score

    @property
    def verified_image(self) -> str:
        """Gets the verified_image of this VerifyResponse.

        JPG base 64 string thumbnail of the live matched image  # noqa: E501

        :return: The verified_image of this VerifyResponse.
        :rtype: str
        """
        return self._verified_image

    @verified_image.setter
    def verified_image(self, verified_image: str):
        """Sets the verified_image of this VerifyResponse.

        JPG base 64 string thumbnail of the live matched image  # noqa: E501

        :param verified_image: The verified_image of this VerifyResponse.
        :type verified_image: str
        """

        self._verified_image = verified_image

    @property
    def verify_status(self) -> List[str]:
        """Gets the verify_status of this VerifyResponse.

        Face verification status  # noqa: E501

        :return: The verify_status of this VerifyResponse.
        :rtype: List[str]
        """
        return self._verify_status

    @verify_status.setter
    def verify_status(self, verify_status: List[str]):
        """Sets the verify_status of this VerifyResponse.

        Face verification status  # noqa: E501

        :param verify_status: The verify_status of this VerifyResponse.
        :type verify_status: List[str]
        """
        allowed_values = ["matching_successful", "matching_failed", "capture_timedout", "camera_failed", "reference_face_detection_failed", "live_face_detection_failed", "liveness_detection_failed", "live_face_quality_failed", "reference_face_quality_failed"]  # noqa: E501
        if not set(verify_status).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `verify_status` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(verify_status) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._verify_status = verify_status
