# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401
from yk_utils.models import Model
from yk_utils.models import deserialization


class VerifyImagesResponse(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, matching_score: float=None, verify_images_status: List[str]=None):  # noqa: E501
        """VerifyImagesResponse - a model defined in Swagger

        :param matching_score: The matching_score of this VerifyImagesResponse.  # noqa: E501
        :type matching_score: float
        :param verify_images_status: The verify_images_status of this VerifyImagesResponse.  # noqa: E501
        :type verify_images_status: List[str]
        """
        self.swagger_types = {
            'matching_score': float,
            'verify_images_status': List[str]
        }

        self.attribute_map = {
            'matching_score': 'matching_score',
            'verify_images_status': 'verify_images_status'
        }

        self._matching_score = matching_score
        self._verify_images_status = verify_images_status

    @classmethod
    def from_dict(cls, dikt) -> 'VerifyImagesResponse':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The verify_images_response of this VerifyImagesResponse.  # noqa: E501
        :rtype: VerifyImagesResponse
        """
        return deserialization.deserialize_model(dikt, cls)

    @property
    def matching_score(self) -> float:
        """Gets the matching_score of this VerifyImagesResponse.

        Face matching confidence. Varies between -1 (totally different) to 1 (totally equal).  # noqa: E501

        :return: The matching_score of this VerifyImagesResponse.
        :rtype: float
        """
        return self._matching_score

    @matching_score.setter
    def matching_score(self, matching_score: float):
        """Sets the matching_score of this VerifyImagesResponse.

        Face matching confidence. Varies between -1 (totally different) to 1 (totally equal).  # noqa: E501

        :param matching_score: The matching_score of this VerifyImagesResponse.
        :type matching_score: float
        """

        self._matching_score = matching_score

    @property
    def verify_images_status(self) -> List[str]:
        """Gets the verify_images_status of this VerifyImagesResponse.

        Face matching status  # noqa: E501

        :return: The verify_images_status of this VerifyImagesResponse.
        :rtype: List[str]
        """
        return self._verify_images_status

    @verify_images_status.setter
    def verify_images_status(self, verify_images_status: List[str]):
        """Sets the verify_images_status of this VerifyImagesResponse.

        Face matching status  # noqa: E501

        :param verify_images_status: The verify_images_status of this VerifyImagesResponse.
        :type verify_images_status: List[str]
        """
        allowed_values = ["matching_successful", "matching_failed", "reference_face_detection_failed", "probe_face_detection_failed"]  # noqa: E501
        if not set(verify_images_status).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `verify_images_status` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(verify_images_status) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._verify_images_status = verify_images_status
