# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401
from yk_utils.models import Model
from yk_utils.models import deserialization


class VerifyImagesRequest(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, probe_image: str=None, reference_image: str=None, matching_score_threshold: float=0.4):  # noqa: E501
        """VerifyImagesRequest - a model defined in Swagger

        :param probe_image: The probe_image of this VerifyImagesRequest.  # noqa: E501
        :type probe_image: str
        :param reference_image: The reference_image of this VerifyImagesRequest.  # noqa: E501
        :type reference_image: str
        :param matching_score_threshold: The matching_score_threshold of this VerifyImagesRequest.  # noqa: E501
        :type matching_score_threshold: float
        """
        self.swagger_types = {
            'probe_image': str,
            'reference_image': str,
            'matching_score_threshold': float
        }

        self.attribute_map = {
            'probe_image': 'probe_image',
            'reference_image': 'reference_image',
            'matching_score_threshold': 'matching_score_threshold'
        }

        self._probe_image = probe_image
        self._reference_image = reference_image
        self._matching_score_threshold = matching_score_threshold

    @classmethod
    def from_dict(cls, dikt) -> 'VerifyImagesRequest':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The verify_images_request of this VerifyImagesRequest.  # noqa: E501
        :rtype: VerifyImagesRequest
        """
        return deserialization.deserialize_model(dikt, cls)

    @property
    def probe_image(self) -> str:
        """Gets the probe_image of this VerifyImagesRequest.

        JPG base 64 string face image to be matched against reference image.  # noqa: E501

        :return: The probe_image of this VerifyImagesRequest.
        :rtype: str
        """
        return self._probe_image

    @probe_image.setter
    def probe_image(self, probe_image: str):
        """Sets the probe_image of this VerifyImagesRequest.

        JPG base 64 string face image to be matched against reference image.  # noqa: E501

        :param probe_image: The probe_image of this VerifyImagesRequest.
        :type probe_image: str
        """
        if probe_image is None:
            raise ValueError("Invalid value for `probe_image`, must not be `None`")  # noqa: E501

        self._probe_image = probe_image

    @property
    def reference_image(self) -> str:
        """Gets the reference_image of this VerifyImagesRequest.

        JPG base 64 string reference face image.  # noqa: E501

        :return: The reference_image of this VerifyImagesRequest.
        :rtype: str
        """
        return self._reference_image

    @reference_image.setter
    def reference_image(self, reference_image: str):
        """Sets the reference_image of this VerifyImagesRequest.

        JPG base 64 string reference face image.  # noqa: E501

        :param reference_image: The reference_image of this VerifyImagesRequest.
        :type reference_image: str
        """
        if reference_image is None:
            raise ValueError("Invalid value for `reference_image`, must not be `None`")  # noqa: E501

        self._reference_image = reference_image

    @property
    def matching_score_threshold(self) -> float:
        """Gets the matching_score_threshold of this VerifyImagesRequest.

        Matching score threshold used to verify matching between probe and reference image.  # noqa: E501

        :return: The matching_score_threshold of this VerifyImagesRequest.
        :rtype: float
        """
        return self._matching_score_threshold

    @matching_score_threshold.setter
    def matching_score_threshold(self, matching_score_threshold: float):
        """Sets the matching_score_threshold of this VerifyImagesRequest.

        Matching score threshold used to verify matching between probe and reference image.  # noqa: E501

        :param matching_score_threshold: The matching_score_threshold of this VerifyImagesRequest.
        :type matching_score_threshold: float
        """

        self._matching_score_threshold = matching_score_threshold
