# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from yk_utils.models import deserialization
from yk_utils.models import Model


class CaptureResponse(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, image: str=None, capture_status: List[str]=None):  # noqa: E501
        """CaptureResponse - a model defined in Swagger

        :param image: The image of this CaptureResponse.  # noqa: E501
        :type image: str
        :param capture_status: The capture_status of this CaptureResponse.  # noqa: E501
        :type capture_status: List[str]
        """
        self.swagger_types = {
            'image': str,
            'capture_status': List[str]
        }

        self.attribute_map = {
            'image': 'image',
            'capture_status': 'capture_status'
        }

        self._image = image
        self._capture_status = capture_status

    @classmethod
    def from_dict(cls, dikt) -> 'CaptureResponse':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The capture_response of this CaptureResponse.  # noqa: E501
        :rtype: CaptureResponse
        """
        return deserialization.deserialize_model(dikt, cls)

    @property
    def image(self) -> str:
        """Gets the image of this CaptureResponse.

        JPG Base 64 string face crop according to ISO/ICAO 19794-5 Token.  # noqa: E501

        :return: The image of this CaptureResponse.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image: str):
        """Sets the image of this CaptureResponse.

        JPG Base 64 string face crop according to ISO/ICAO 19794-5 Token.  # noqa: E501

        :param image: The image of this CaptureResponse.
        :type image: str
        """

        self._image = image

    @property
    def capture_status(self) -> List[str]:
        """Gets the capture_status of this CaptureResponse.

        Face capture result status  # noqa: E501

        :return: The capture_status of this CaptureResponse.
        :rtype: List[str]
        """
        return self._capture_status

    @capture_status.setter
    def capture_status(self, capture_status: List[str]):
        """Sets the capture_status of this CaptureResponse.

        Face capture result status  # noqa: E501

        :param capture_status: The capture_status of this CaptureResponse.
        :type capture_status: List[str]
        """
        allowed_values = ["capture_successful", "capture_timedout", "camera_failed", "live_face_detection_failed", "live_face_quality_failed", "liveness_detection_failed"]  # noqa: E501
        if not set(capture_status).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `capture_status` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(capture_status) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._capture_status = capture_status
