# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401
from yk_utils.models import Model
from yk_utils.models import deserialization


class CaptureRequest(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, capture_time_out: float=10.0, anti_spoofing: bool=True, live_quality_analysis: bool=False):  # noqa: E501
        """CaptureRequest - a model defined in Swagger

        :param capture_time_out: The capture_time_out of this CaptureRequest.  # noqa: E501
        :type capture_time_out: float
        :param anti_spoofing: The anti_spoofing of this CaptureRequest.  # noqa: E501
        :type anti_spoofing: bool
        :param live_quality_analysis: The live_quality_analysis of this CaptureRequest.  # noqa: E501
        :type live_quality_analysis: bool
        """
        self.swagger_types = {
            'capture_time_out': float,
            'anti_spoofing': bool,
            'live_quality_analysis': bool
        }

        self.attribute_map = {
            'capture_time_out': 'capture_time_out',
            'anti_spoofing': 'anti_spoofing',
            'live_quality_analysis': 'live_quality_analysis'
        }

        self._capture_time_out = capture_time_out
        self._anti_spoofing = anti_spoofing
        self._live_quality_analysis = live_quality_analysis

    @classmethod
    def from_dict(cls, dikt) -> 'CaptureRequest':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The capture_request of this CaptureRequest.  # noqa: E501
        :rtype: CaptureRequest
        """
        return deserialization.deserialize_model(dikt, cls)

    @property
    def capture_time_out(self) -> float:
        """Gets the capture_time_out of this CaptureRequest.

        Capture timeout in seconds.  # noqa: E501

        :return: The capture_time_out of this CaptureRequest.
        :rtype: float
        """
        return self._capture_time_out

    @capture_time_out.setter
    def capture_time_out(self, capture_time_out: float):
        """Sets the capture_time_out of this CaptureRequest.

        Capture timeout in seconds.  # noqa: E501

        :param capture_time_out: The capture_time_out of this CaptureRequest.
        :type capture_time_out: float
        """
        if capture_time_out is not None and capture_time_out < 0:  # noqa: E501
            raise ValueError("Invalid value for `capture_time_out`, must be a value greater than or equal to `0`")  # noqa: E501

        self._capture_time_out = capture_time_out

    @property
    def anti_spoofing(self) -> bool:
        """Gets the anti_spoofing of this CaptureRequest.

        Activate anti-spoofing detection.  # noqa: E501

        :return: The anti_spoofing of this CaptureRequest.
        :rtype: bool
        """
        return self._anti_spoofing

    @anti_spoofing.setter
    def anti_spoofing(self, anti_spoofing: bool):
        """Sets the anti_spoofing of this CaptureRequest.

        Activate anti-spoofing detection.  # noqa: E501

        :param anti_spoofing: The anti_spoofing of this CaptureRequest.
        :type anti_spoofing: bool
        """

        self._anti_spoofing = anti_spoofing

    @property
    def live_quality_analysis(self) -> bool:
        """Gets the live_quality_analysis of this CaptureRequest.

        Activate ISO/ICAO-19794-5 face quality compliance checks on the live face images.  # noqa: E501

        :return: The live_quality_analysis of this CaptureRequest.
        :rtype: bool
        """
        return self._live_quality_analysis

    @live_quality_analysis.setter
    def live_quality_analysis(self, live_quality_analysis: bool):
        """Sets the live_quality_analysis of this CaptureRequest.

        Activate ISO/ICAO-19794-5 face quality compliance checks on the live face images.  # noqa: E501

        :param live_quality_analysis: The live_quality_analysis of this CaptureRequest.
        :type live_quality_analysis: bool
        """

        self._live_quality_analysis = live_quality_analysis
