% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{normal_log_mixture}
\alias{normal_log_mixture}
\title{Logarithm of mixture supermartingale for the one- or two-sided normal
mixture.}
\usage{
normal_log_mixture(s, v, v_opt, alpha_opt = 0.05, is_one_sided = TRUE)
}
\arguments{
\item{s}{value of the underlying martingale}

\item{v}{intrinsic time value}

\item{v_opt}{intrinsic time value for which the corresponding boundary is
optimized}

\item{alpha_opt}{alpha for which the corresponding boundary is optimized}

\item{is_one_sided}{if FALSE, use the two-sided normal mixture}
}
\description{
Logarithm of mixture supermartingale for the one- or two-sided normal
mixture.
}
\examples{
normal_log_mixture(10, 100, 100)
normal_log_mixture(c(10, 20), c(100, 400), 100, is_one_sided=FALSE)
}
