% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bernoulli_confidence_interval}
\alias{bernoulli_confidence_interval}
\title{Confidence sequence for [0, 1]-bounded distributions.}
\usage{
bernoulli_confidence_interval(num_successes, num_trials, alpha, t_opt,
  alpha_opt = 0.05)
}
\arguments{
\item{num_successes}{number of "successful" Bernoulli trials seen so far, or
more generally, sum of observed outcomes}

\item{num_trials}{total number of observations seen so far}

\item{alpha}{1 - confidence level}

\item{t_opt}{sample size for which confidence sequence is optimized}

\item{alpha_opt}{1 - confidence level for which confidence is optimized}
}
\value{
a list with named elements `lower` and `upper` giving lower and
  upper confidence bounds, respectively
}
\description{
This function returns confidence bounds for the mean of a Bernoulli
distribution, or more generally, any distribution with support in the unit
interval [0, 1]. (This applies to any bounded distribution after rescaling.)
The confidence bounds form a confidence sequence, so are guaranteed to cover
the true mean uniformly over time with probability 1 - `alpha`.
}
\examples{
bernoulli_confidence_interval(c(50, 500, 5000), c(100, 1000, 10000), .05,
                              1000)
}
