# -*- coding: utf-8 -*-

"""
    apimaticswaggerpetstore

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from apimaticswaggerpetstore.api_helper import APIHelper
from apimaticswaggerpetstore.configuration import Configuration
from apimaticswaggerpetstore.controllers.base_controller import BaseController
from apimaticswaggerpetstore.models.order import Order
from apimaticswaggerpetstore.exceptions.api_exception import APIException

class StoreController(BaseController):

    """A Controller to access Endpoints in the apimaticswaggerpetstore API."""


    def create_place_order(self,
                           body):
        """Does a POST request to /store/order.

        Place an order for a pet

        Args:
            body (Order): order placed for purchasing the pet

        Returns:
            Order: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/store/order'
        _query_builder = Configuration.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise APIException('Invalid Order', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, Order.from_dictionary)

    def get_order_by_id(self,
                        order_id):
        """Does a GET request to /store/order/{orderId}.

        For valid response try integer IDs with value >= 1 and <= 10. Other
        values will generated exceptions

        Args:
            order_id (long|int): ID of pet that needs to be fetched

        Returns:
            Order: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/store/order/{orderId}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'orderId': order_id
        })
        _query_builder = Configuration.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise APIException('Invalid ID supplied', _context)
        elif _context.response.status_code == 404:
            raise APIException('Order not found', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, Order.from_dictionary)

    def delete_order(self,
                     order_id):
        """Does a DELETE request to /store/order/{orderId}.

        For valid response try integer IDs with positive integer value.
        Negative or non-integer values will generate API errors

        Args:
            order_id (long|int): ID of the order that needs to be deleted

        Returns:
            void: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/store/order/{orderId}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'orderId': order_id
        })
        _query_builder = Configuration.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.http_client.delete(_query_url)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise APIException('Invalid ID supplied', _context)
        elif _context.response.status_code == 404:
            raise APIException('Order not found', _context)
        self.validate_response(_context)

    def get_inventory(self):
        """Does a GET request to /store/inventory.

        Returns a map of status codes to quantities

        Returns:
            dict<object, int>: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/store/inventory'
        _query_builder = Configuration.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.http_client.get(_query_url)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return _context.response.raw_body
