# -*- coding: utf-8 -*-

"""
    apimaticswaggerpetstore

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from apimaticswaggerpetstore.api_helper import APIHelper


class Configuration(object):

    """A class used for configuring the SDK by a user.

    This class need not be instantiated and all properties and methods
    are accessible without instance creation.

    """

    # Set the array parameter serialization method
    # (allowed: indexed, unindexed, plain, csv, tsv, psv)
    array_serialization = "indexed"

    # An enum for SDK environments
    class Environment(object):
        PRODUCTION = 0

    # An enum for API servers
    class Server(object):
        SERVER1 = 0
        SERVER2 = 1
        AUTH_SERVER = 2

    # The environment in which the SDK is running
    environment = Environment.PRODUCTION

    # OAuth 2 Client ID
    # TODO: Set an appropriate value
    o_auth_client_id = None

    # OAuth 2 Redirection endpoint or Callback Uri
    # TODO: Set an appropriate value
    o_auth_redirect_uri = None


    # All the environments the SDK can run in
    environments = {
        Environment.PRODUCTION: {
            Server.SERVER1: 'https://petstore.swagger.io/v2',
            Server.SERVER2: 'http://petstore.swagger.io/v2',
            Server.AUTH_SERVER: 'https://petstore.swagger.io/oauth',
        },
    }

    @classmethod
    def get_base_uri(cls, server=Server.SERVER1):
        """Generates the appropriate base URI for the environment and the server.

        Args:
            server (Configuration.Server): The server enum for which the base URI is required.

        Returns:
            String: The base URI.

        """
        return cls.environments[cls.environment][server]
